#ifndef _LINUX_SYS_H
#define _LINUX_SYS_H

/*
 * system call entry points ... but not all are defined
 */
#define NR_syscalls 266

/*
 * These are system calls that will be removed at some time
 * due to newer versions existing..
 * (please be careful - ibcs2 may need some of these).
 */
#ifdef notdef
#define _sys_waitpid	_sys_old_syscall	/* _sys_wait4 */
#define _sys_olduname	_sys_old_syscall	/* _sys_newuname */
#define _sys_uname	_sys_old_syscall	/* _sys_newuname */
#define _sys_stat	_sys_old_syscall	/* _sys_newstat */
#define _sys_fstat	_sys_old_syscall	/* _sys_newfstat */
#define _sys_lstat	_sys_old_syscall	/* _sys_newlstat */
#define _sys_signal	_sys_old_syscall	/* _sys_sigaction */
#define _sys_sgetmask	_sys_old_syscall	/* _sys_sigprocmask */
#define _sys_ssetmask	_sys_old_syscall	/* _sys_sigprocmask */
#endif

/*
 * These are system calls that haven't been implemented yet
 * but have an entry in the table for future expansion..
 */

/*
 * These are registration routines for system calls that are
 * implemented by loadable modules outside of the kernel
 * source tree.
 */
#if !defined(__ASSEMBLY__)
extern int
register_streams_calls(int (*putpmsg) (int, void *, void *, int, int),
		       int (*getpmsg) (int, void *, void *, int, int)) ;

#endif			/* __ASSEMBLY__ */
#endif
