/*
 *      IPv6-IPv6 tunneling header file
 *
 *      Authors:
 *      Sami Kivisaari          <skivisaa@cc.hut.fi>
 *
 *      $Id: s.tunnel.h 1.12 02/10/16 00:31:21+03:00 vnuorval@eric.hut.mediapoli.com $
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 */

#ifndef _TUNNEL_H
#define _TUNNEL_H

#include <linux/in6.h>
#include <linux/if_arp.h>
#include <net/ipv6_tunnel.h>

extern int mipv6_max_tnls;
extern int mipv6_min_tnls;

extern void mipv6_initialize_tunnel(void);
extern void mipv6_shutdown_tunnel(void);

extern int mipv6_add_tnl_to_mn(struct in6_addr *coa, 
			       struct in6_addr *ha_addr,
			       struct in6_addr *home_addr);

extern int mipv6_del_tnl_to_mn(struct in6_addr *coa, 
			       struct in6_addr *ha_addr,
			       struct in6_addr *home_addr);

extern int mipv6_add_tnl_to_ha(struct in6_addr *ha_addr, 
			       struct in6_addr *coa,
			       struct in6_addr *home_addr);

extern int mipv6_del_tnl_to_ha(struct in6_addr *ha_addr, 
			       struct in6_addr *coa,
			       struct in6_addr *home_addr);

static __inline__ int is_mipv6_tnl(struct ipv6_tnl *t)
{
	return (t != NULL && 
		t->parms.flags & IPV6_TNL_F_KERNEL_DEV &&
		t->parms.flags & IPV6_TNL_F_MIPV6_DEV);
			
}

static __inline__ int dev_is_mipv6_tnl(struct net_device *dev)
{
	struct ipv6_tnl *t = (struct ipv6_tnl *)dev->priv;
	return (dev->type == ARPHRD_IPV6_IPV6_TUNNEL && is_mipv6_tnl(t));
}


#endif

