/* SPDX-License-Identifier: GPL-2.0
 *
 * Copyright 2016-2020 HabanaLabs, Ltd.
 * All Rights Reserved.
 *
 */

#ifndef GAUDI_CORESIGHT_H
#define GAUDI_CORESIGHT_H

enum gaudi_debug_stm_regs_index {
	GAUDI_STM_FIRST = 0,
	GAUDI_STM_MME0_ACC = GAUDI_STM_FIRST,
	GAUDI_STM_MME0_SBAB,
	GAUDI_STM_MME0_CTRL,
	GAUDI_STM_MME1_ACC,
	GAUDI_STM_MME1_SBAB,
	GAUDI_STM_MME1_CTRL,
	GAUDI_STM_MME2_ACC,
	GAUDI_STM_MME2_SBAB,
	GAUDI_STM_MME2_CTRL,
	GAUDI_STM_MME3_ACC,
	GAUDI_STM_MME3_SBAB,
	GAUDI_STM_MME3_CTRL,
	GAUDI_STM_DMA_IF_W_S,
	GAUDI_STM_DMA_IF_E_S,
	GAUDI_STM_DMA_IF_W_N,
	GAUDI_STM_DMA_IF_E_N,
	GAUDI_STM_CPU,
	GAUDI_STM_DMA_CH_0_CS,
	GAUDI_STM_DMA_CH_1_CS,
	GAUDI_STM_DMA_CH_2_CS,
	GAUDI_STM_DMA_CH_3_CS,
	GAUDI_STM_DMA_CH_4_CS,
	GAUDI_STM_DMA_CH_5_CS,
	GAUDI_STM_DMA_CH_6_CS,
	GAUDI_STM_DMA_CH_7_CS,
	GAUDI_STM_PCIE,
	GAUDI_STM_MMU_CS,
	GAUDI_STM_PSOC,
	GAUDI_STM_NIC0_0,
	GAUDI_STM_NIC0_1,
	GAUDI_STM_NIC1_0,
	GAUDI_STM_NIC1_1,
	GAUDI_STM_NIC2_0,
	GAUDI_STM_NIC2_1,
	GAUDI_STM_NIC3_0,
	GAUDI_STM_NIC3_1,
	GAUDI_STM_NIC4_0,
	GAUDI_STM_NIC4_1,
	GAUDI_STM_TPC0_EML,
	GAUDI_STM_TPC1_EML,
	GAUDI_STM_TPC2_EML,
	GAUDI_STM_TPC3_EML,
	GAUDI_STM_TPC4_EML,
	GAUDI_STM_TPC5_EML,
	GAUDI_STM_TPC6_EML,
	GAUDI_STM_TPC7_EML,
	GAUDI_STM_LAST = GAUDI_STM_TPC7_EML
};

enum gaudi_debug_etf_regs_index {
	GAUDI_ETF_FIRST = 0,
	GAUDI_ETF_MME0_ACC = GAUDI_ETF_FIRST,
	GAUDI_ETF_MME0_SBAB,
	GAUDI_ETF_MME0_CTRL,
	GAUDI_ETF_MME1_ACC,
	GAUDI_ETF_MME1_SBAB,
	GAUDI_ETF_MME1_CTRL,
	GAUDI_ETF_MME2_ACC,
	GAUDI_ETF_MME2_SBAB,
	GAUDI_ETF_MME2_CTRL,
	GAUDI_ETF_MME3_ACC,
	GAUDI_ETF_MME3_SBAB,
	GAUDI_ETF_MME3_CTRL,
	GAUDI_ETF_DMA_IF_W_S,
	GAUDI_ETF_DMA_IF_E_S,
	GAUDI_ETF_DMA_IF_W_N,
	GAUDI_ETF_DMA_IF_E_N,
	GAUDI_ETF_CPU_0,
	GAUDI_ETF_CPU_1,
	GAUDI_ETF_CPU_TRACE,
	GAUDI_ETF_DMA_CH_0_CS,
	GAUDI_ETF_DMA_CH_1_CS,
	GAUDI_ETF_DMA_CH_2_CS,
	GAUDI_ETF_DMA_CH_3_CS,
	GAUDI_ETF_DMA_CH_4_CS,
	GAUDI_ETF_DMA_CH_5_CS,
	GAUDI_ETF_DMA_CH_6_CS,
	GAUDI_ETF_DMA_CH_7_CS,
	GAUDI_ETF_PCIE,
	GAUDI_ETF_MMU_CS,
	GAUDI_ETF_PSOC,
	GAUDI_ETF_NIC0_0,
	GAUDI_ETF_NIC0_1,
	GAUDI_ETF_NIC1_0,
	GAUDI_ETF_NIC1_1,
	GAUDI_ETF_NIC2_0,
	GAUDI_ETF_NIC2_1,
	GAUDI_ETF_NIC3_0,
	GAUDI_ETF_NIC3_1,
	GAUDI_ETF_NIC4_0,
	GAUDI_ETF_NIC4_1,
	GAUDI_ETF_TPC0_EML,
	GAUDI_ETF_TPC1_EML,
	GAUDI_ETF_TPC2_EML,
	GAUDI_ETF_TPC3_EML,
	GAUDI_ETF_TPC4_EML,
	GAUDI_ETF_TPC5_EML,
	GAUDI_ETF_TPC6_EML,
	GAUDI_ETF_TPC7_EML,
	GAUDI_ETF_LAST = GAUDI_ETF_TPC7_EML
};

enum gaudi_debug_funnel_regs_index {
	GAUDI_FUNNEL_FIRST = 0,
	GAUDI_FUNNEL_MME0_ACC = GAUDI_FUNNEL_FIRST,
	GAUDI_FUNNEL_MME1_ACC,
	GAUDI_FUNNEL_MME2_ACC,
	GAUDI_FUNNEL_MME3_ACC,
	GAUDI_FUNNEL_SRAM_Y0_X0,
	GAUDI_FUNNEL_SRAM_Y0_X1,
	GAUDI_FUNNEL_SRAM_Y0_X2,
	GAUDI_FUNNEL_SRAM_Y0_X3,
	GAUDI_FUNNEL_SRAM_Y0_X4,
	GAUDI_FUNNEL_SRAM_Y0_X5,
	GAUDI_FUNNEL_SRAM_Y0_X6,
	GAUDI_FUNNEL_SRAM_Y0_X7,
	GAUDI_FUNNEL_SRAM_Y1_X0,
	GAUDI_FUNNEL_SRAM_Y1_X1,
	GAUDI_FUNNEL_SRAM_Y1_X2,
	GAUDI_FUNNEL_SRAM_Y1_X3,
	GAUDI_FUNNEL_SRAM_Y1_X4,
	GAUDI_FUNNEL_SRAM_Y1_X5,
	GAUDI_FUNNEL_SRAM_Y1_X6,
	GAUDI_FUNNEL_SRAM_Y1_X7,
	GAUDI_FUNNEL_SRAM_Y2_X0,
	GAUDI_FUNNEL_SRAM_Y2_X1,
	GAUDI_FUNNEL_SRAM_Y2_X2,
	GAUDI_FUNNEL_SRAM_Y2_X3,
	GAUDI_FUNNEL_SRAM_Y2_X4,
	GAUDI_FUNNEL_SRAM_Y2_X5,
	GAUDI_FUNNEL_SRAM_Y2_X6,
	GAUDI_FUNNEL_SRAM_Y2_X7,
	GAUDI_FUNNEL_SRAM_Y3_X0,
	GAUDI_FUNNEL_SRAM_Y3_X1,
	GAUDI_FUNNEL_SRAM_Y3_X2,
	GAUDI_FUNNEL_SRAM_Y3_X4,
	GAUDI_FUNNEL_SRAM_Y3_X3,
	GAUDI_FUNNEL_SRAM_Y3_X5,
	GAUDI_FUNNEL_SRAM_Y3_X6,
	GAUDI_FUNNEL_SRAM_Y3_X7,
	GAUDI_FUNNEL_SIF_0,
	GAUDI_FUNNEL_SIF_1,
	GAUDI_FUNNEL_SIF_2,
	GAUDI_FUNNEL_SIF_3,
	GAUDI_FUNNEL_SIF_4,
	GAUDI_FUNNEL_SIF_5,
	GAUDI_FUNNEL_SIF_6,
	GAUDI_FUNNEL_SIF_7,
	GAUDI_FUNNEL_NIF_0,
	GAUDI_FUNNEL_NIF_1,
	GAUDI_FUNNEL_NIF_2,
	GAUDI_FUNNEL_NIF_3,
	GAUDI_FUNNEL_NIF_4,
	GAUDI_FUNNEL_NIF_5,
	GAUDI_FUNNEL_NIF_6,
	GAUDI_FUNNEL_NIF_7,
	GAUDI_FUNNEL_DMA_IF_W_S,
	GAUDI_FUNNEL_DMA_IF_E_S,
	GAUDI_FUNNEL_DMA_IF_W_N,
	GAUDI_FUNNEL_DMA_IF_E_N,
	GAUDI_FUNNEL_CPU,
	GAUDI_FUNNEL_NIC_TPC_W_S,
	GAUDI_FUNNEL_NIC_TPC_E_S,
	GAUDI_FUNNEL_NIC_TPC_W_N,
	GAUDI_FUNNEL_NIC_TPC_E_N,
	GAUDI_FUNNEL_PCIE,
	GAUDI_FUNNEL_PSOC,
	GAUDI_FUNNEL_NIC0,
	GAUDI_FUNNEL_NIC1,
	GAUDI_FUNNEL_NIC2,
	GAUDI_FUNNEL_NIC3,
	GAUDI_FUNNEL_NIC4,
	GAUDI_FUNNEL_TPC0_EML,
	GAUDI_FUNNEL_TPC1_EML,
	GAUDI_FUNNEL_TPC2_EML,
	GAUDI_FUNNEL_TPC3_EML,
	GAUDI_FUNNEL_TPC4_EML,
	GAUDI_FUNNEL_TPC5_EML,
	GAUDI_FUNNEL_TPC6_EML,
	GAUDI_FUNNEL_TPC7_EML,
	GAUDI_FUNNEL_LAST = GAUDI_FUNNEL_TPC7_EML
};

enum gaudi_debug_bmon_regs_index {
	GAUDI_BMON_FIRST = 0,
	GAUDI_BMON_MME0_ACC_0 = GAUDI_BMON_FIRST,
	GAUDI_BMON_MME0_SBAB_0,
	GAUDI_BMON_MME0_SBAB_1,
	GAUDI_BMON_MME0_CTRL_0,
	GAUDI_BMON_MME0_CTRL_1,
	GAUDI_BMON_MME1_ACC_0,
	GAUDI_BMON_MME1_SBAB_0,
	GAUDI_BMON_MME1_SBAB_1,
	GAUDI_BMON_MME1_CTRL_0,
	GAUDI_BMON_MME1_CTRL_1,
	GAUDI_BMON_MME2_ACC_0,
	GAUDI_BMON_MME2_SBAB_0,
	GAUDI_BMON_MME2_SBAB_1,
	GAUDI_BMON_MME2_CTRL_0,
	GAUDI_BMON_MME2_CTRL_1,
	GAUDI_BMON_MME3_ACC_0,
	GAUDI_BMON_MME3_SBAB_0,
	GAUDI_BMON_MME3_SBAB_1,
	GAUDI_BMON_MME3_CTRL_0,
	GAUDI_BMON_MME3_CTRL_1,
	GAUDI_BMON_DMA_IF_W_S_SOB_WR,
	GAUDI_BMON_DMA_IF_W_S_0_WR,
	GAUDI_BMON_DMA_IF_W_S_0_RD,
	GAUDI_BMON_DMA_IF_W_S_1_WR,
	GAUDI_BMON_DMA_IF_W_S_1_RD,
	GAUDI_BMON_DMA_IF_E_S_SOB_WR,
	GAUDI_BMON_DMA_IF_E_S_0_WR,
	GAUDI_BMON_DMA_IF_E_S_0_RD,
	GAUDI_BMON_DMA_IF_E_S_1_WR,
	GAUDI_BMON_DMA_IF_E_S_1_RD,
	GAUDI_BMON_DMA_IF_W_N_SOB_WR,
	GAUDI_BMON_DMA_IF_W_N_HBM0_WR,
	GAUDI_BMON_DMA_IF_W_N_HBM0_RD,
	GAUDI_BMON_DMA_IF_W_N_HBM1_WR,
	GAUDI_BMON_DMA_IF_W_N_HBM1_RD,
	GAUDI_BMON_DMA_IF_E_N_SOB_WR,
	GAUDI_BMON_DMA_IF_E_N_HBM0_WR,
	GAUDI_BMON_DMA_IF_E_N_HBM0_RD,
	GAUDI_BMON_DMA_IF_E_N_HBM1_WR,
	GAUDI_BMON_DMA_IF_E_N_HBM1_RD,
	GAUDI_BMON_CPU_WR,
	GAUDI_BMON_CPU_RD,
	GAUDI_BMON_DMA_CH_0_0,
	GAUDI_BMON_DMA_CH_0_1,
	GAUDI_BMON_DMA_CH_1_0,
	GAUDI_BMON_DMA_CH_1_1,
	GAUDI_BMON_DMA_CH_2_0,
	GAUDI_BMON_DMA_CH_2_1,
	GAUDI_BMON_DMA_CH_3_0,
	GAUDI_BMON_DMA_CH_3_1,
	GAUDI_BMON_DMA_CH_4_0,
	GAUDI_BMON_DMA_CH_4_1,
	GAUDI_BMON_DMA_CH_5_0,
	GAUDI_BMON_DMA_CH_5_1,
	GAUDI_BMON_DMA_CH_6_0,
	GAUDI_BMON_DMA_CH_6_1,
	GAUDI_BMON_DMA_CH_7_0,
	GAUDI_BMON_DMA_CH_7_1,
	GAUDI_BMON_PCIE_MSTR_WR,
	GAUDI_BMON_PCIE_MSTR_RD,
	GAUDI_BMON_PCIE_SLV_WR,
	GAUDI_BMON_PCIE_SLV_RD,
	GAUDI_BMON_MMU_0,
	GAUDI_BMON_MMU_1,
	GAUDI_BMON_NIC0_0,
	GAUDI_BMON_NIC0_1,
	GAUDI_BMON_NIC0_2,
	GAUDI_BMON_NIC0_3,
	GAUDI_BMON_NIC0_4,
	GAUDI_BMON_NIC1_0,
	GAUDI_BMON_NIC1_1,
	GAUDI_BMON_NIC1_2,
	GAUDI_BMON_NIC1_3,
	GAUDI_BMON_NIC1_4,
	GAUDI_BMON_NIC2_0,
	GAUDI_BMON_NIC2_1,
	GAUDI_BMON_NIC2_2,
	GAUDI_BMON_NIC2_3,
	GAUDI_BMON_NIC2_4,
	GAUDI_BMON_NIC3_0,
	GAUDI_BMON_NIC3_1,
	GAUDI_BMON_NIC3_2,
	GAUDI_BMON_NIC3_3,
	GAUDI_BMON_NIC3_4,
	GAUDI_BMON_NIC4_0,
	GAUDI_BMON_NIC4_1,
	GAUDI_BMON_NIC4_2,
	GAUDI_BMON_NIC4_3,
	GAUDI_BMON_NIC4_4,
	GAUDI_BMON_TPC0_EML_0,
	GAUDI_BMON_TPC0_EML_1,
	GAUDI_BMON_TPC0_EML_2,
	GAUDI_BMON_TPC0_EML_3,
	GAUDI_BMON_TPC1_EML_0,
	GAUDI_BMON_TPC1_EML_1,
	GAUDI_BMON_TPC1_EML_2,
	GAUDI_BMON_TPC1_EML_3,
	GAUDI_BMON_TPC2_EML_0,
	GAUDI_BMON_TPC2_EML_1,
	GAUDI_BMON_TPC2_EML_2,
	GAUDI_BMON_TPC2_EML_3,
	GAUDI_BMON_TPC3_EML_0,
	GAUDI_BMON_TPC3_EML_1,
	GAUDI_BMON_TPC3_EML_2,
	GAUDI_BMON_TPC3_EML_3,
	GAUDI_BMON_TPC4_EML_0,
	GAUDI_BMON_TPC4_EML_1,
	GAUDI_BMON_TPC4_EML_2,
	GAUDI_BMON_TPC4_EML_3,
	GAUDI_BMON_TPC5_EML_0,
	GAUDI_BMON_TPC5_EML_1,
	GAUDI_BMON_TPC5_EML_2,
	GAUDI_BMON_TPC5_EML_3,
	GAUDI_BMON_TPC6_EML_0,
	GAUDI_BMON_TPC6_EML_1,
	GAUDI_BMON_TPC6_EML_2,
	GAUDI_BMON_TPC6_EML_3,
	GAUDI_BMON_TPC7_EML_0,
	GAUDI_BMON_TPC7_EML_1,
	GAUDI_BMON_TPC7_EML_2,
	GAUDI_BMON_TPC7_EML_3,
	GAUDI_BMON_LAST = GAUDI_BMON_TPC7_EML_3
};

enum gaudi_debug_spmu_regs_index {
	GAUDI_SPMU_FIRST = 0,
	GAUDI_SPMU_MME0_ACC = GAUDI_SPMU_FIRST,
	GAUDI_SPMU_MME0_SBAB,
	GAUDI_SPMU_MME0_CTRL,
	GAUDI_SPMU_MME1_ACC,
	GAUDI_SPMU_MME1_SBAB,
	GAUDI_SPMU_MME1_CTRL,
	GAUDI_SPMU_MME2_MME2_ACC,
	GAUDI_SPMU_MME2_SBAB,
	GAUDI_SPMU_MME2_CTRL,
	GAUDI_SPMU_MME3_ACC,
	GAUDI_SPMU_MME3_SBAB,
	GAUDI_SPMU_MME3_CTRL,
	GAUDI_SPMU_DMA_CH_0_CS,
	GAUDI_SPMU_DMA_CH_1_CS,
	GAUDI_SPMU_DMA_CH_2_CS,
	GAUDI_SPMU_DMA_CH_3_CS,
	GAUDI_SPMU_DMA_CH_4_CS,
	GAUDI_SPMU_DMA_CH_5_CS,
	GAUDI_SPMU_DMA_CH_6_CS,
	GAUDI_SPMU_DMA_CH_7_CS,
	GAUDI_SPMU_PCIE,
	GAUDI_SPMU_MMU_CS,
	GAUDI_SPMU_NIC0_0,
	GAUDI_SPMU_NIC0_1,
	GAUDI_SPMU_NIC1_0,
	GAUDI_SPMU_NIC1_1,
	GAUDI_SPMU_NIC2_0,
	GAUDI_SPMU_NIC2_1,
	GAUDI_SPMU_NIC3_0,
	GAUDI_SPMU_NIC3_1,
	GAUDI_SPMU_NIC4_0,
	GAUDI_SPMU_NIC4_1,
	GAUDI_SPMU_TPC0_EML,
	GAUDI_SPMU_TPC1_EML,
	GAUDI_SPMU_TPC2_EML,
	GAUDI_SPMU_TPC3_EML,
	GAUDI_SPMU_TPC4_EML,
	GAUDI_SPMU_TPC5_EML,
	GAUDI_SPMU_TPC6_EML,
	GAUDI_SPMU_TPC7_EML,
	GAUDI_SPMU_LAST = GAUDI_SPMU_TPC7_EML
};

#endif /* GAUDI_CORESIGHT_H */
