# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class IpRecordList(ListResource):

    def __init__(self, version):
        """
        Initialize the IpRecordList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.voice.v1.ip_record.IpRecordList
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordList
        """
        super(IpRecordList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/IpRecords'.format(**self._solution)

    def create(self, ip_address, friendly_name=values.unset,
               cidr_prefix_length=values.unset):
        """
        Create the IpRecordInstance

        :param unicode ip_address: An IP address in dotted decimal notation, IPv4 only.
        :param unicode friendly_name: A string to describe the resource
        :param unicode cidr_prefix_length: An integer representing the length of the `CIDR <https://tools.ietf.org/html/rfc4632>`_ prefix to use with this IP address. By default the entire IP address is used, which for IPv4 is value 32.

        :returns: The created IpRecordInstance
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordInstance
        """
        data = values.of({
            'IpAddress': ip_address,
            'FriendlyName': friendly_name,
            'CidrPrefixLength': cidr_prefix_length,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return IpRecordInstance(self._version, payload, )

    def stream(self, limit=None, page_size=None):
        """
        Streams IpRecordInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.voice.v1.ip_record.IpRecordInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists IpRecordInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.voice.v1.ip_record.IpRecordInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of IpRecordInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of IpRecordInstance
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordPage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return IpRecordPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of IpRecordInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of IpRecordInstance
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return IpRecordPage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a IpRecordContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.voice.v1.ip_record.IpRecordContext
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordContext
        """
        return IpRecordContext(self._version, sid=sid, )

    def __call__(self, sid):
        """
        Constructs a IpRecordContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.voice.v1.ip_record.IpRecordContext
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordContext
        """
        return IpRecordContext(self._version, sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.IpRecordList>'


class IpRecordPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the IpRecordPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.voice.v1.ip_record.IpRecordPage
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordPage
        """
        super(IpRecordPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of IpRecordInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.voice.v1.ip_record.IpRecordInstance
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordInstance
        """
        return IpRecordInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.IpRecordPage>'


class IpRecordContext(InstanceContext):

    def __init__(self, version, sid):
        """
        Initialize the IpRecordContext

        :param Version version: Version that contains the resource
        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.voice.v1.ip_record.IpRecordContext
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordContext
        """
        super(IpRecordContext, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/IpRecords/{sid}'.format(**self._solution)

    def fetch(self):
        """
        Fetch the IpRecordInstance

        :returns: The fetched IpRecordInstance
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return IpRecordInstance(self._version, payload, sid=self._solution['sid'], )

    def update(self, friendly_name=values.unset):
        """
        Update the IpRecordInstance

        :param unicode friendly_name: A string to describe the resource

        :returns: The updated IpRecordInstance
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordInstance
        """
        data = values.of({'FriendlyName': friendly_name, })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return IpRecordInstance(self._version, payload, sid=self._solution['sid'], )

    def delete(self):
        """
        Deletes the IpRecordInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Voice.V1.IpRecordContext {}>'.format(context)


class IpRecordInstance(InstanceResource):

    def __init__(self, version, payload, sid=None):
        """
        Initialize the IpRecordInstance

        :returns: twilio.rest.voice.v1.ip_record.IpRecordInstance
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordInstance
        """
        super(IpRecordInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'sid': payload.get('sid'),
            'friendly_name': payload.get('friendly_name'),
            'ip_address': payload.get('ip_address'),
            'cidr_prefix_length': deserialize.integer(payload.get('cidr_prefix_length')),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: IpRecordContext for this IpRecordInstance
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordContext
        """
        if self._context is None:
            self._context = IpRecordContext(self._version, sid=self._solution['sid'], )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def friendly_name(self):
        """
        :returns: The string that you assigned to describe the resource
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def ip_address(self):
        """
        :returns: An IP address in dotted decimal notation, IPv4 only.
        :rtype: unicode
        """
        return self._properties['ip_address']

    @property
    def cidr_prefix_length(self):
        """
        :returns: An integer representing the length of the `CIDR <https://tools.ietf.org/html/rfc4632>`_ prefix to use with this IP address. By default the entire IP address is used, which for IPv4 is value 32.
        :rtype: unicode
        """
        return self._properties['cidr_prefix_length']

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT that the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The RFC 2822 date and time in GMT that the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def url(self):
        """
        :returns: The absolute URL of the resource
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the IpRecordInstance

        :returns: The fetched IpRecordInstance
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordInstance
        """
        return self._proxy.fetch()

    def update(self, friendly_name=values.unset):
        """
        Update the IpRecordInstance

        :param unicode friendly_name: A string to describe the resource

        :returns: The updated IpRecordInstance
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordInstance
        """
        return self._proxy.update(friendly_name=friendly_name, )

    def delete(self):
        """
        Deletes the IpRecordInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Voice.V1.IpRecordInstance {}>'.format(context)
