# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

require 'date'
require 'google/apis/core/base_service'
require 'google/apis/core/json_representation'
require 'google/apis/core/hashable'
require 'google/apis/errors'

module Google
  module Apis
    module ComputeV1
      
      # Contains the configurations necessary to generate a signature for access to
      # private storage buckets that support Signature Version 4 for authentication.
      # The service name for generating the authentication header will always default
      # to 's3'.
      class Awsv4Signature
        include Google::Apis::Core::Hashable
      
        # The access key used for s3 bucket authentication. Required for updating or
        # creating a backend that uses AWS v4 signature authentication, but will not
        # be returned as part of the configuration when queried with a REST API GET
        # request.
        # @InputOnly
        # Corresponds to the JSON property `accessKey`
        # @return [String]
        attr_accessor :access_key
      
        # The identifier of an access key used for s3 bucket authentication.
        # Corresponds to the JSON property `accessKeyId`
        # @return [String]
        attr_accessor :access_key_id
      
        # The optional version identifier for the access key. You can use this to
        # keep track of different iterations of your access key.
        # Corresponds to the JSON property `accessKeyVersion`
        # @return [String]
        attr_accessor :access_key_version
      
        # The name of the cloud region of your origin. This is a free-form field with
        # the name of the region your cloud uses to host your origin.  For example,
        # "us-east-1" for AWS or "us-ashburn-1" for OCI.
        # Corresponds to the JSON property `originRegion`
        # @return [String]
        attr_accessor :origin_region
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @access_key = args[:access_key] if args.key?(:access_key)
          @access_key_id = args[:access_key_id] if args.key?(:access_key_id)
          @access_key_version = args[:access_key_version] if args.key?(:access_key_version)
          @origin_region = args[:origin_region] if args.key?(:origin_region)
        end
      end
      
      # A specification of the type and number of accelerator cards attached to the
      # instance.
      class AcceleratorConfig
        include Google::Apis::Core::Hashable
      
        # The number of the guest accelerator cards exposed to this instance.
        # Corresponds to the JSON property `acceleratorCount`
        # @return [Fixnum]
        attr_accessor :accelerator_count
      
        # Full or partial URL of the accelerator type resource to attach to this
        # instance. For example:projects/my-project/zones/us-central1-c/acceleratorTypes/
        # nvidia-tesla-p100
        # If you are creating an instance template, specify only the
        # accelerator name.
        # See GPUs on Compute Engine
        # for a full list of accelerator types.
        # Corresponds to the JSON property `acceleratorType`
        # @return [String]
        attr_accessor :accelerator_type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @accelerator_count = args[:accelerator_count] if args.key?(:accelerator_count)
          @accelerator_type = args[:accelerator_type] if args.key?(:accelerator_type)
        end
      end
      
      # Info for accelerator topologies within a densely packed reservation.
      class AcceleratorTopologiesInfo
        include Google::Apis::Core::Hashable
      
        # Info for each accelerator topology.
        # Corresponds to the JSON property `acceleratorTopologyInfos`
        # @return [Array<Google::Apis::ComputeV1::AcceleratorTopologiesInfoAcceleratorTopologyInfo>]
        attr_accessor :accelerator_topology_infos
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @accelerator_topology_infos = args[:accelerator_topology_infos] if args.key?(:accelerator_topology_infos)
        end
      end
      
      # Info for a slice of a given topology.
      class AcceleratorTopologiesInfoAcceleratorTopologyInfo
        include Google::Apis::Core::Hashable
      
        # The accelerator topology.
        # Corresponds to the JSON property `acceleratorTopology`
        # @return [String]
        attr_accessor :accelerator_topology
      
        # Info for each topology state.
        # Corresponds to the JSON property `infoPerTopologyStates`
        # @return [Array<Google::Apis::ComputeV1::AcceleratorTopologiesInfoAcceleratorTopologyInfoInfoPerTopologyState>]
        attr_accessor :info_per_topology_states
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @accelerator_topology = args[:accelerator_topology] if args.key?(:accelerator_topology)
          @info_per_topology_states = args[:info_per_topology_states] if args.key?(:info_per_topology_states)
        end
      end
      
      # Info for each topology state.
      class AcceleratorTopologiesInfoAcceleratorTopologyInfoInfoPerTopologyState
        include Google::Apis::Core::Hashable
      
        # The number of accelerator topologies in this state.
        # Corresponds to the JSON property `count`
        # @return [Fixnum]
        attr_accessor :count
      
        # The state of the accelerator topology.
        # Corresponds to the JSON property `state`
        # @return [String]
        attr_accessor :state
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @count = args[:count] if args.key?(:count)
          @state = args[:state] if args.key?(:state)
        end
      end
      
      # Represents an Accelerator Type resource.
      # Google Cloud Platform provides graphics processing units (accelerators) that
      # you can add to VM instances to improve or accelerate performance when working
      # with intensive workloads. For more information, readGPUs on Compute Engine.
      class AcceleratorType
        include Google::Apis::Core::Hashable
      
        # [Output Only] Creation timestamp inRFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # Deprecation status for a public resource.
        # Corresponds to the JSON property `deprecated`
        # @return [Google::Apis::ComputeV1::DeprecationStatus]
        attr_accessor :deprecated
      
        # [Output Only] An optional textual description of the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. [Output Only] The type of the resource. Alwayscompute#
        # acceleratorType for accelerator types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] Maximum number of accelerator cards allowed per instance.
        # Corresponds to the JSON property `maximumCardsPerInstance`
        # @return [Fixnum]
        attr_accessor :maximum_cards_per_instance
      
        # [Output Only] Name of the resource.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Output only. [Output Only] Server-defined, fully qualified URL for this
        # resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] The name of the zone where the accelerator type resides,
        # such as us-central1-a.
        # You must specify this field as part of the HTTP request URL. It is
        # not settable as a field in the request body.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @deprecated = args[:deprecated] if args.key?(:deprecated)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @maximum_cards_per_instance = args[:maximum_cards_per_instance] if args.key?(:maximum_cards_per_instance)
          @name = args[:name] if args.key?(:name)
          @self_link = args[:self_link] if args.key?(:self_link)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class AcceleratorTypeAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of AcceleratorTypesScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeV1::AcceleratorTypesScopedList>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Alwayscompute#
        # acceleratorTypeAggregatedList for aggregated lists of
        # accelerator types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Unreachable resources.
        # Corresponds to the JSON property `unreachables`
        # @return [Array<String>]
        attr_accessor :unreachables
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::AcceleratorTypeAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @unreachables = args[:unreachables] if args.key?(:unreachables)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::AcceleratorTypeAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of accelerator types.
      class AcceleratorTypeList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of AcceleratorType resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::AcceleratorType>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Alwayscompute#acceleratorTypeList
        # for lists of accelerator types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::AcceleratorTypeList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::AcceleratorTypeList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class AcceleratorTypesScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of accelerator types contained in this scope.
        # Corresponds to the JSON property `acceleratorTypes`
        # @return [Array<Google::Apis::ComputeV1::AcceleratorType>]
        attr_accessor :accelerator_types
      
        # [Output Only] An informational warning that appears when the accelerator
        # types list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::AcceleratorTypesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @accelerator_types = args[:accelerator_types] if args.key?(:accelerator_types)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] An informational warning that appears when the accelerator
        # types list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::AcceleratorTypesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # An access configuration attached to an instance's network interface.
      # Only one access config per instance is supported.
      class AccessConfig
        include Google::Apis::Core::Hashable
      
        # Applies to ipv6AccessConfigs only.
        # The first IPv6 address of the external IPv6 range associated
        # with this instance, prefix length is stored inexternalIpv6PrefixLength in
        # ipv6AccessConfig. To
        # use a static external IP address, it must be unused and in the same region
        # as the instance's zone. If not specified, Google Cloud will automatically
        # assign an external IPv6 address from the instance's subnetwork.
        # Corresponds to the JSON property `externalIpv6`
        # @return [String]
        attr_accessor :external_ipv6
      
        # Applies to ipv6AccessConfigs only. The prefix length of the
        # external IPv6 range.
        # Corresponds to the JSON property `externalIpv6PrefixLength`
        # @return [Fixnum]
        attr_accessor :external_ipv6_prefix_length
      
        # Output only. [Output Only] Type of the resource. Alwayscompute#accessConfig
        # for access configs.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The name of this access configuration. In accessConfigs
        # (IPv4), the default and recommended name is External NAT, but
        # you can use any arbitrary string, such as My external IP orNetwork Access. In
        # ipv6AccessConfigs, the
        # recommend name is External IPv6.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Applies to accessConfigs (IPv4) only. Anexternal IP
        # address associated with this instance. Specify an unused static
        # external IP address available to the project or leave this field undefined
        # to use an IP from a shared ephemeral IP address pool. If you specify a
        # static external IP address, it must live in the same region as the zone of
        # the instance.
        # Corresponds to the JSON property `natIP`
        # @return [String]
        attr_accessor :nat_ip
      
        # This signifies the networking tier used for configuring this access
        # configuration and can only take the following values: PREMIUM,STANDARD.
        # If an AccessConfig is specified without a valid external IP address, an
        # ephemeral IP will be created with this networkTier.
        # If an AccessConfig with a valid external IP address is specified, it must
        # match that of the networkTier associated with the Address resource owning
        # that IP.
        # Corresponds to the JSON property `networkTier`
        # @return [String]
        attr_accessor :network_tier
      
        # The DNS domain name for the public PTR record.
        # You can set this field only if the `setPublicPtr` field is enabled
        # inaccessConfig. If this field is unspecified inipv6AccessConfig, a default PTR
        # record will be created for
        # first IP in associated external IPv6 range.
        # Corresponds to the JSON property `publicPtrDomainName`
        # @return [String]
        attr_accessor :public_ptr_domain_name
      
        # The resource URL for the security policy associated with this access
        # config.
        # Corresponds to the JSON property `securityPolicy`
        # @return [String]
        attr_accessor :security_policy
      
        # Specifies whether a public DNS 'PTR' record should be created to map the
        # external IP address of the instance to a DNS domain name.
        # This field is not used in ipv6AccessConfig. A default PTR
        # record will be created if the VM has external IPv6 range associated.
        # Corresponds to the JSON property `setPublicPtr`
        # @return [Boolean]
        attr_accessor :set_public_ptr
        alias_method :set_public_ptr?, :set_public_ptr
      
        # The type of configuration. In accessConfigs (IPv4), the
        # default and only option is ONE_TO_ONE_NAT. Inipv6AccessConfigs, the default
        # and only option isDIRECT_IPV6.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @external_ipv6 = args[:external_ipv6] if args.key?(:external_ipv6)
          @external_ipv6_prefix_length = args[:external_ipv6_prefix_length] if args.key?(:external_ipv6_prefix_length)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @nat_ip = args[:nat_ip] if args.key?(:nat_ip)
          @network_tier = args[:network_tier] if args.key?(:network_tier)
          @public_ptr_domain_name = args[:public_ptr_domain_name] if args.key?(:public_ptr_domain_name)
          @security_policy = args[:security_policy] if args.key?(:security_policy)
          @set_public_ptr = args[:set_public_ptr] if args.key?(:set_public_ptr)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # Represents an IP Address resource.
      # Google Compute Engine has two IP Address resources:
      # * [Global (external and
      # internal)](https://cloud.google.com/compute/docs/reference/rest/v1/
      # globalAddresses)
      # * [Regional (external and
      # internal)](https://cloud.google.com/compute/docs/reference/rest/v1/addresses)
      # For more information, see
      # Reserving a static external IP address.
      class Address
        include Google::Apis::Core::Hashable
      
        # The static IP address represented by this resource.
        # Corresponds to the JSON property `address`
        # @return [String]
        attr_accessor :address
      
        # The type of address to reserve, either INTERNAL orEXTERNAL. If unspecified,
        # defaults to EXTERNAL.
        # Corresponds to the JSON property `addressType`
        # @return [String]
        attr_accessor :address_type
      
        # Output only. [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this field when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Output only. [Output Only] The unique identifier for the resource. This
        # identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Reference to the source of external IPv4 addresses,
        # like a PublicDelegatedPrefix (PDP) for BYOIP.
        # The PDP must support enhanced IPv4 allocations.
        # Use one of the following formats to specify a PDP when reserving an
        # external IPv4 address using BYOIP.
        # 
        # -
        # Full resource URL, as inhttps://www.googleapis.com/compute/v1/projects/
        # projectId/regions/region/publicDelegatedPrefixes/pdp-name
        # -
        # Partial URL, as in
        # 
        # 
        # - projects/projectId/regions/region/publicDelegatedPrefixes/pdp-name
        # - regions/region/publicDelegatedPrefixes/pdp-name
        # Corresponds to the JSON property `ipCollection`
        # @return [String]
        attr_accessor :ip_collection
      
        # The IP version that will be used by this address. Valid options areIPV4 or
        # IPV6.
        # Corresponds to the JSON property `ipVersion`
        # @return [String]
        attr_accessor :ip_version
      
        # The endpoint type of this address, which should be VM
        # or NETLB. This is used for deciding which type of endpoint
        # this address can be used after the external IPv6 address reservation.
        # Corresponds to the JSON property `ipv6EndpointType`
        # @return [String]
        attr_accessor :ipv6_endpoint_type
      
        # Output only. [Output Only] Type of the resource. Always compute#address for
        # addresses.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # A fingerprint for the labels being applied to this Address, which is
        # essentially a hash of the labels set used for optimistic locking. The
        # fingerprint is initially generated by Compute Engine and changes after
        # every request to modify or update labels. You must always provide an
        # up-to-date fingerprint hash in order to update or change labels,
        # otherwise the request will fail with error412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to
        # retrieve an Address.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # Labels for this resource. These can only be added or modified by thesetLabels
        # method. Each label key/value pair must comply withRFC1035.
        # Label values may be empty.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # Name of the resource. Provided by the client when the resource is created.
        # The name must be 1-63 characters long, and comply withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character
        # must be a lowercase letter, and all following characters (except for the
        # last character) must be a dash, lowercase letter, or digit. The last
        # character must be a lowercase letter or digit.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The URL of the network in which to reserve the address. This field can
        # only be used with INTERNAL type with theVPC_PEERING purpose.
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # This signifies the networking tier used for configuring this address and
        # can only take the following values: PREMIUM orSTANDARD. Internal IP addresses
        # are always Premium Tier;
        # global external IP addresses are always Premium Tier; regional external IP
        # addresses can be either Standard or Premium Tier.
        # If this field is not specified, it is assumed to be PREMIUM.
        # Corresponds to the JSON property `networkTier`
        # @return [String]
        attr_accessor :network_tier
      
        # The prefix length if the resource represents an IP range.
        # Corresponds to the JSON property `prefixLength`
        # @return [Fixnum]
        attr_accessor :prefix_length
      
        # The purpose of this resource, which can be one of the following values:
        # 
        # 
        # - GCE_ENDPOINT for addresses that are used by VM
        # instances, alias IP ranges, load balancers, and similar resources.
        # - DNS_RESOLVER for a DNS resolver address in a subnetwork
        # for a Cloud DNS  inbound
        # forwarder IP addresses (regional internal IP address in a subnet of
        # a VPC network)
        # - VPC_PEERING for global internal IP addresses used for
        # 
        # private services access allocated ranges.
        # - NAT_AUTO for the regional external IP addresses used by
        # Cloud NAT when allocating addresses using
        # 
        # automatic NAT IP address allocation.
        # - IPSEC_INTERCONNECT for addresses created from a private
        # IP range that are reserved for a VLAN attachment in an
        # *HA VPN over Cloud Interconnect* configuration. These addresses
        # are regional resources.
        # - `SHARED_LOADBALANCER_VIP` for an internal IP address that is assigned
        # to multiple internal forwarding rules.
        # - `PRIVATE_SERVICE_CONNECT` for a private network address that is
        # used to configure Private Service Connect. Only global internal addresses
        # can use this purpose.
        # Corresponds to the JSON property `purpose`
        # @return [String]
        attr_accessor :purpose
      
        # Output only. [Output Only] The URL of the region where a regional address
        # resides.
        # For regional addresses, you must specify the region as a path parameter in
        # the HTTP request URL. *This field is not applicable to global
        # addresses.*
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] The status of the address, which can be one
        # ofRESERVING, RESERVED, or IN_USE.
        # An address that is RESERVING is currently in the process of
        # being reserved. A RESERVED address is currently reserved and
        # available to use. An IN_USE address is currently being used
        # by another resource and is not available.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # The URL of the subnetwork in which to reserve the address. If an IP address
        # is specified, it must be within the subnetwork's IP range. This field can
        # only be used with INTERNAL type with aGCE_ENDPOINT or DNS_RESOLVER purpose.
        # Corresponds to the JSON property `subnetwork`
        # @return [String]
        attr_accessor :subnetwork
      
        # [Output Only] The URLs of the resources that are using this address.
        # Corresponds to the JSON property `users`
        # @return [Array<String>]
        attr_accessor :users
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @address = args[:address] if args.key?(:address)
          @address_type = args[:address_type] if args.key?(:address_type)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @ip_collection = args[:ip_collection] if args.key?(:ip_collection)
          @ip_version = args[:ip_version] if args.key?(:ip_version)
          @ipv6_endpoint_type = args[:ipv6_endpoint_type] if args.key?(:ipv6_endpoint_type)
          @kind = args[:kind] if args.key?(:kind)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
          @name = args[:name] if args.key?(:name)
          @network = args[:network] if args.key?(:network)
          @network_tier = args[:network_tier] if args.key?(:network_tier)
          @prefix_length = args[:prefix_length] if args.key?(:prefix_length)
          @purpose = args[:purpose] if args.key?(:purpose)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @status = args[:status] if args.key?(:status)
          @subnetwork = args[:subnetwork] if args.key?(:subnetwork)
          @users = args[:users] if args.key?(:users)
        end
      end
      
      # 
      class AddressAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of AddressesScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeV1::AddressesScopedList>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Alwayscompute#
        # addressAggregatedList for aggregated lists of
        # addresses.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Unreachable resources.
        # Corresponds to the JSON property `unreachables`
        # @return [Array<String>]
        attr_accessor :unreachables
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::AddressAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @unreachables = args[:unreachables] if args.key?(:unreachables)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::AddressAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of addresses.
      class AddressList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Address resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::Address>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Always compute#addressList for
        # lists of addresses.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::AddressList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::AddressList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class AddressesScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of addresses contained in this scope.
        # Corresponds to the JSON property `addresses`
        # @return [Array<Google::Apis::ComputeV1::Address>]
        attr_accessor :addresses
      
        # [Output Only] Informational warning which replaces the list of addresses
        # when the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::AddressesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @addresses = args[:addresses] if args.key?(:addresses)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning which replaces the list of addresses
        # when the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::AddressesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Specifies options for controlling advanced machine features.
      # Options that would traditionally be configured in a BIOS belong
      # here. Features that require operating system support may have
      # corresponding entries in the GuestOsFeatures of anImage (e.g., whether or not
      # the OS in theImage supports nested virtualization being enabled or
      # disabled).
      class AdvancedMachineFeatures
        include Google::Apis::Core::Hashable
      
        # Whether to enable nested virtualization or not (default is false).
        # Corresponds to the JSON property `enableNestedVirtualization`
        # @return [Boolean]
        attr_accessor :enable_nested_virtualization
        alias_method :enable_nested_virtualization?, :enable_nested_virtualization
      
        # Whether to enable UEFI networking for instance creation.
        # Corresponds to the JSON property `enableUefiNetworking`
        # @return [Boolean]
        attr_accessor :enable_uefi_networking
        alias_method :enable_uefi_networking?, :enable_uefi_networking
      
        # Type of Performance Monitoring Unit requested on instance.
        # Corresponds to the JSON property `performanceMonitoringUnit`
        # @return [String]
        attr_accessor :performance_monitoring_unit
      
        # The number of threads per physical core. To disable simultaneous
        # multithreading (SMT) set this to 1. If unset, the maximum number
        # of threads supported per core by the underlying processor is
        # assumed.
        # Corresponds to the JSON property `threadsPerCore`
        # @return [Fixnum]
        attr_accessor :threads_per_core
      
        # Turbo frequency mode to use for the instance.
        # Supported modes include:
        # * ALL_CORE_MAX
        # Using empty string or not setting this field will use the platform-specific
        # default turbo mode.
        # Corresponds to the JSON property `turboMode`
        # @return [String]
        attr_accessor :turbo_mode
      
        # The number of physical cores to expose to an instance. Multiply by
        # the number of threads per core to compute the total number of virtual
        # CPUs to expose to the instance. If unset, the number of cores is
        # inferred from the instance's nominal CPU count and the underlying
        # platform's SMT width.
        # Corresponds to the JSON property `visibleCoreCount`
        # @return [Fixnum]
        attr_accessor :visible_core_count
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @enable_nested_virtualization = args[:enable_nested_virtualization] if args.key?(:enable_nested_virtualization)
          @enable_uefi_networking = args[:enable_uefi_networking] if args.key?(:enable_uefi_networking)
          @performance_monitoring_unit = args[:performance_monitoring_unit] if args.key?(:performance_monitoring_unit)
          @threads_per_core = args[:threads_per_core] if args.key?(:threads_per_core)
          @turbo_mode = args[:turbo_mode] if args.key?(:turbo_mode)
          @visible_core_count = args[:visible_core_count] if args.key?(:visible_core_count)
        end
      end
      
      # An alias IP range attached to an instance's network interface.
      class AliasIpRange
        include Google::Apis::Core::Hashable
      
        # The IP alias ranges to allocate for this interface. This IP CIDR range
        # must belong to the specified subnetwork and cannot contain IP addresses
        # reserved by system or used by other network interfaces. This range may be
        # a single IP address (such as 10.2.3.4), a netmask (such as/24) or a CIDR-
        # formatted string (such as10.1.2.0/24).
        # Corresponds to the JSON property `ipCidrRange`
        # @return [String]
        attr_accessor :ip_cidr_range
      
        # The name of a subnetwork secondary IP range from which to allocate an IP
        # alias range. If not specified, the primary range of the subnetwork is used.
        # Corresponds to the JSON property `subnetworkRangeName`
        # @return [String]
        attr_accessor :subnetwork_range_name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @ip_cidr_range = args[:ip_cidr_range] if args.key?(:ip_cidr_range)
          @subnetwork_range_name = args[:subnetwork_range_name] if args.key?(:subnetwork_range_name)
        end
      end
      
      # This reservation type is specified by total resource amounts (e.g. total
      # count of CPUs) and can account for multiple instance SKUs. In other words,
      # one can create instances of varying shapes against this reservation.
      class AllocationAggregateReservation
        include Google::Apis::Core::Hashable
      
        # Output only. [Output only] List of resources currently in use.
        # Corresponds to the JSON property `inUseResources`
        # @return [Array<Google::Apis::ComputeV1::AllocationAggregateReservationReservedResourceInfo>]
        attr_accessor :in_use_resources
      
        # List of reserved resources (CPUs, memory, accelerators).
        # Corresponds to the JSON property `reservedResources`
        # @return [Array<Google::Apis::ComputeV1::AllocationAggregateReservationReservedResourceInfo>]
        attr_accessor :reserved_resources
      
        # The VM family that all instances scheduled against this reservation must
        # belong to.
        # Corresponds to the JSON property `vmFamily`
        # @return [String]
        attr_accessor :vm_family
      
        # The workload type of the instances that will target this reservation.
        # Corresponds to the JSON property `workloadType`
        # @return [String]
        attr_accessor :workload_type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @in_use_resources = args[:in_use_resources] if args.key?(:in_use_resources)
          @reserved_resources = args[:reserved_resources] if args.key?(:reserved_resources)
          @vm_family = args[:vm_family] if args.key?(:vm_family)
          @workload_type = args[:workload_type] if args.key?(:workload_type)
        end
      end
      
      # 
      class AllocationAggregateReservationReservedResourceInfo
        include Google::Apis::Core::Hashable
      
        # Properties of accelerator resources in this reservation.
        # Corresponds to the JSON property `accelerator`
        # @return [Google::Apis::ComputeV1::AllocationAggregateReservationReservedResourceInfoAccelerator]
        attr_accessor :accelerator
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @accelerator = args[:accelerator] if args.key?(:accelerator)
        end
      end
      
      # 
      class AllocationAggregateReservationReservedResourceInfoAccelerator
        include Google::Apis::Core::Hashable
      
        # Number of accelerators of specified type.
        # Corresponds to the JSON property `acceleratorCount`
        # @return [Fixnum]
        attr_accessor :accelerator_count
      
        # Full or partial URL to accelerator type. e.g.
        # "projects/`PROJECT`/zones/`ZONE`/acceleratorTypes/ct4l"
        # Corresponds to the JSON property `acceleratorType`
        # @return [String]
        attr_accessor :accelerator_type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @accelerator_count = args[:accelerator_count] if args.key?(:accelerator_count)
          @accelerator_type = args[:accelerator_type] if args.key?(:accelerator_type)
        end
      end
      
      # 
      class AllocationReservationSharingPolicy
        include Google::Apis::Core::Hashable
      
        # Sharing config for all Google Cloud services.
        # Corresponds to the JSON property `serviceShareType`
        # @return [String]
        attr_accessor :service_share_type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @service_share_type = args[:service_share_type] if args.key?(:service_share_type)
        end
      end
      
      # [Output Only] Contains output only fields.
      class AllocationResourceStatus
        include Google::Apis::Core::Hashable
      
        # Health information for the reservation.
        # Corresponds to the JSON property `healthInfo`
        # @return [Google::Apis::ComputeV1::AllocationResourceStatusHealthInfo]
        attr_accessor :health_info
      
        # The number of reservation blocks associated with this reservation.
        # Corresponds to the JSON property `reservationBlockCount`
        # @return [Fixnum]
        attr_accessor :reservation_block_count
      
        # Maintenance Info for ReservationBlocks.
        # Corresponds to the JSON property `reservationMaintenance`
        # @return [Google::Apis::ComputeV1::GroupMaintenanceInfo]
        attr_accessor :reservation_maintenance
      
        # Contains Properties set for the reservation.
        # Corresponds to the JSON property `specificSkuAllocation`
        # @return [Google::Apis::ComputeV1::AllocationResourceStatusSpecificSkuAllocation]
        attr_accessor :specific_sku_allocation
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @health_info = args[:health_info] if args.key?(:health_info)
          @reservation_block_count = args[:reservation_block_count] if args.key?(:reservation_block_count)
          @reservation_maintenance = args[:reservation_maintenance] if args.key?(:reservation_maintenance)
          @specific_sku_allocation = args[:specific_sku_allocation] if args.key?(:specific_sku_allocation)
        end
      end
      
      # Health information for the reservation.
      class AllocationResourceStatusHealthInfo
        include Google::Apis::Core::Hashable
      
        # The number of reservation blocks that are degraded.
        # Corresponds to the JSON property `degradedBlockCount`
        # @return [Fixnum]
        attr_accessor :degraded_block_count
      
        # The health status of the reservation.
        # Corresponds to the JSON property `healthStatus`
        # @return [String]
        attr_accessor :health_status
      
        # The number of reservation blocks that are healthy.
        # Corresponds to the JSON property `healthyBlockCount`
        # @return [Fixnum]
        attr_accessor :healthy_block_count
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @degraded_block_count = args[:degraded_block_count] if args.key?(:degraded_block_count)
          @health_status = args[:health_status] if args.key?(:health_status)
          @healthy_block_count = args[:healthy_block_count] if args.key?(:healthy_block_count)
        end
      end
      
      # Contains Properties set for the reservation.
      class AllocationResourceStatusSpecificSkuAllocation
        include Google::Apis::Core::Hashable
      
        # ID of the instance template used to populate reservation properties.
        # Corresponds to the JSON property `sourceInstanceTemplateId`
        # @return [String]
        attr_accessor :source_instance_template_id
      
        # Per service utilization breakdown. The Key is the Google Cloud managed
        # service name.
        # Corresponds to the JSON property `utilizations`
        # @return [Hash<String,Fixnum>]
        attr_accessor :utilizations
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @source_instance_template_id = args[:source_instance_template_id] if args.key?(:source_instance_template_id)
          @utilizations = args[:utilizations] if args.key?(:utilizations)
        end
      end
      
      # 
      class AllocationSpecificSkuAllocationAllocatedInstancePropertiesReservedDisk
        include Google::Apis::Core::Hashable
      
        # Specifies the size of the disk in base-2 GB.
        # Corresponds to the JSON property `diskSizeGb`
        # @return [Fixnum]
        attr_accessor :disk_size_gb
      
        # Specifies the disk interface to use for attaching this disk, which is
        # either SCSI or NVME. The default isSCSI.
        # For performance characteristics of SCSI over NVMe, seeLocal SSD performance.
        # Corresponds to the JSON property `interface`
        # @return [String]
        attr_accessor :interface
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @disk_size_gb = args[:disk_size_gb] if args.key?(:disk_size_gb)
          @interface = args[:interface] if args.key?(:interface)
        end
      end
      
      # Properties of the SKU instances being reserved.
      # Next ID: 9
      class AllocationSpecificSkuAllocationReservedInstanceProperties
        include Google::Apis::Core::Hashable
      
        # Specifies accelerator type and count.
        # Corresponds to the JSON property `guestAccelerators`
        # @return [Array<Google::Apis::ComputeV1::AcceleratorConfig>]
        attr_accessor :guest_accelerators
      
        # Specifies amount of local ssd to reserve with each instance. The type
        # of disk is local-ssd.
        # Corresponds to the JSON property `localSsds`
        # @return [Array<Google::Apis::ComputeV1::AllocationSpecificSkuAllocationAllocatedInstancePropertiesReservedDisk>]
        attr_accessor :local_ssds
      
        # An opaque location hint used to place the allocation close to other
        # resources.
        # This field is for use by internal tools that use the public API.
        # Corresponds to the JSON property `locationHint`
        # @return [String]
        attr_accessor :location_hint
      
        # Specifies type of machine (name only) which has fixed number of vCPUs
        # and fixed amount of memory. This also includes specifying custom
        # machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
        # Corresponds to the JSON property `machineType`
        # @return [String]
        attr_accessor :machine_type
      
        # Minimum cpu platform the reservation.
        # Corresponds to the JSON property `minCpuPlatform`
        # @return [String]
        attr_accessor :min_cpu_platform
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @guest_accelerators = args[:guest_accelerators] if args.key?(:guest_accelerators)
          @local_ssds = args[:local_ssds] if args.key?(:local_ssds)
          @location_hint = args[:location_hint] if args.key?(:location_hint)
          @machine_type = args[:machine_type] if args.key?(:machine_type)
          @min_cpu_platform = args[:min_cpu_platform] if args.key?(:min_cpu_platform)
        end
      end
      
      # This reservation type allows to pre allocate specific instance
      # configuration.
      class AllocationSpecificSkuReservation
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Indicates how many instances are actually usable
        # currently.
        # Corresponds to the JSON property `assuredCount`
        # @return [Fixnum]
        attr_accessor :assured_count
      
        # Specifies the number of resources that are allocated.
        # Corresponds to the JSON property `count`
        # @return [Fixnum]
        attr_accessor :count
      
        # Output only. [Output Only] Indicates how many instances are in use.
        # Corresponds to the JSON property `inUseCount`
        # @return [Fixnum]
        attr_accessor :in_use_count
      
        # Properties of the SKU instances being reserved.
        # Next ID: 9
        # Corresponds to the JSON property `instanceProperties`
        # @return [Google::Apis::ComputeV1::AllocationSpecificSkuAllocationReservedInstanceProperties]
        attr_accessor :instance_properties
      
        # Specifies the instance template to create the reservation. If you use
        # this field, you must exclude the instanceProperties field.
        # This field is optional, and it can be a full or partial URL. For example,
        # the following are all valid URLs to an instance template:
        # 
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/global/
        # instanceTemplates/instanceTemplate
        # - projects/project/global/instanceTemplates/instanceTemplate
        # - global/instanceTemplates/instanceTemplate
        # Corresponds to the JSON property `sourceInstanceTemplate`
        # @return [String]
        attr_accessor :source_instance_template
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @assured_count = args[:assured_count] if args.key?(:assured_count)
          @count = args[:count] if args.key?(:count)
          @in_use_count = args[:in_use_count] if args.key?(:in_use_count)
          @instance_properties = args[:instance_properties] if args.key?(:instance_properties)
          @source_instance_template = args[:source_instance_template] if args.key?(:source_instance_template)
        end
      end
      
      # An instance-attached disk resource.
      class AttachedDisk
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] The architecture of the attached disk. Valid values
        # are ARM64
        # or X86_64.
        # Corresponds to the JSON property `architecture`
        # @return [String]
        attr_accessor :architecture
      
        # Specifies whether the disk will be auto-deleted when the instance is
        # deleted (but not when the disk is detached from the instance).
        # Corresponds to the JSON property `autoDelete`
        # @return [Boolean]
        attr_accessor :auto_delete
        alias_method :auto_delete?, :auto_delete
      
        # Indicates that this is a boot disk. The virtual machine will use the first
        # partition of the disk for its root filesystem.
        # Corresponds to the JSON property `boot`
        # @return [Boolean]
        attr_accessor :boot
        alias_method :boot?, :boot
      
        # Specifies a unique device name of your choice that is reflected into the/dev/
        # disk/by-id/google-* tree of a Linux operating system
        # running within the instance. This name can be used to reference the device
        # for mounting, resizing, and so on, from within the instance.
        # If not specified, the server chooses a default device name to apply to this
        # disk, in the form persistent-disk-x, where x is a number
        # assigned by Google Compute Engine. This field is only applicable for
        # persistent disks.
        # Corresponds to the JSON property `deviceName`
        # @return [String]
        attr_accessor :device_name
      
        # Encrypts or decrypts a disk using acustomer-supplied
        # encryption key.
        # If you are creating a new disk, this field encrypts the new disk using
        # an encryption key that you provide. If you are attaching an existing
        # disk that is already encrypted, this field decrypts the disk using
        # the customer-supplied encryption key.
        # If you encrypt a disk using a customer-supplied key, you must provide the
        # same key again when you attempt to use this resource at a later time. For
        # example, you must provide the key when you create a snapshot or an image
        # from the disk or when you attach the disk to a virtual machine instance.
        # If you do not provide an encryption key, then the disk will be encrypted
        # using an automatically generated key and you do not need to provide a key
        # to use the disk later.
        # Note:
        # Instance templates do not storecustomer-supplied
        # encryption keys, so you cannot use your own keys to encrypt disks in amanaged
        # instance group.
        # You cannot create VMs that have disks with customer-supplied keys using
        # the bulk
        # insert method.
        # Corresponds to the JSON property `diskEncryptionKey`
        # @return [Google::Apis::ComputeV1::CustomerEncryptionKey]
        attr_accessor :disk_encryption_key
      
        # The size of the disk in GB.
        # Corresponds to the JSON property `diskSizeGb`
        # @return [Fixnum]
        attr_accessor :disk_size_gb
      
        # [Input Only] Whether to force attach the regional disk even if it's
        # currently attached to another instance. If you try to force attach a zonal
        # disk to an instance, you will receive an error.
        # Corresponds to the JSON property `forceAttach`
        # @return [Boolean]
        attr_accessor :force_attach
        alias_method :force_attach?, :force_attach
      
        # A list of features to enable on the guest operating system. Applicable
        # only for bootable images. Read
        # Enabling guest operating system features to see a list of available
        # options.
        # Corresponds to the JSON property `guestOsFeatures`
        # @return [Array<Google::Apis::ComputeV1::GuestOsFeature>]
        attr_accessor :guest_os_features
      
        # Output only. [Output Only] A zero-based index to this disk, where 0 is
        # reserved for the
        # boot disk. If you have many disks attached to an instance, each
        # disk would have a unique index number.
        # Corresponds to the JSON property `index`
        # @return [Fixnum]
        attr_accessor :index
      
        # [Input Only] Specifies the parameters for a new disk that will be created
        # alongside the new instance. Use initialization parameters to create boot
        # disks or local SSDs attached to the new instance.
        # This field is persisted and returned for instanceTemplate and not returned
        # in the context of instance.
        # This property is mutually exclusive with the source property;
        # you can only define one or the other, but not both.
        # Corresponds to the JSON property `initializeParams`
        # @return [Google::Apis::ComputeV1::AttachedDiskInitializeParams]
        attr_accessor :initialize_params
      
        # Specifies the disk interface to use for attaching this disk, which is
        # either SCSI or NVME. For most machine types, the
        # default is SCSI. Local SSDs can use either NVME or SCSI.
        # In certain configurations, persistent disks can use NVMe. For more
        # information, seeAbout
        # persistent disks.
        # Corresponds to the JSON property `interface`
        # @return [String]
        attr_accessor :interface
      
        # Output only. [Output Only] Type of the resource. Alwayscompute#attachedDisk
        # for attached disks.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Output only. [Output Only] Any valid publicly visible licenses.
        # Corresponds to the JSON property `licenses`
        # @return [Array<String>]
        attr_accessor :licenses
      
        # The mode in which to attach this disk, either READ_WRITE orREAD_ONLY. If not
        # specified, the default is to attach the disk
        # in READ_WRITE mode.
        # Corresponds to the JSON property `mode`
        # @return [String]
        attr_accessor :mode
      
        # Output only. For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state,
        # this
        # field is set to PRESERVED if the LocalSSD data has been saved
        # to a persistent location by customer request.  (see the
        # discard_local_ssd option on Stop/Suspend).
        # Read-only in the api.
        # Corresponds to the JSON property `savedState`
        # @return [String]
        attr_accessor :saved_state
      
        # Initial State for shielded instance,
        # these are public keys which are safe to store in public
        # Corresponds to the JSON property `shieldedInstanceInitialState`
        # @return [Google::Apis::ComputeV1::InitialStateConfig]
        attr_accessor :shielded_instance_initial_state
      
        # Specifies a valid partial or full URL to an existing Persistent Disk
        # resource. When creating a new instance boot disk, one ofinitializeParams.
        # sourceImage orinitializeParams.sourceSnapshot or disks.source
        # is required.
        # If desired, you can also attach existing non-root persistent disks using
        # this property. This field is only applicable for persistent disks.
        # Note that for InstanceTemplate, specify the disk name for zonal disk,
        # and the URL for regional disk.
        # Corresponds to the JSON property `source`
        # @return [String]
        attr_accessor :source
      
        # Specifies the type of the disk, either SCRATCH orPERSISTENT. If not specified,
        # the default isPERSISTENT.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @architecture = args[:architecture] if args.key?(:architecture)
          @auto_delete = args[:auto_delete] if args.key?(:auto_delete)
          @boot = args[:boot] if args.key?(:boot)
          @device_name = args[:device_name] if args.key?(:device_name)
          @disk_encryption_key = args[:disk_encryption_key] if args.key?(:disk_encryption_key)
          @disk_size_gb = args[:disk_size_gb] if args.key?(:disk_size_gb)
          @force_attach = args[:force_attach] if args.key?(:force_attach)
          @guest_os_features = args[:guest_os_features] if args.key?(:guest_os_features)
          @index = args[:index] if args.key?(:index)
          @initialize_params = args[:initialize_params] if args.key?(:initialize_params)
          @interface = args[:interface] if args.key?(:interface)
          @kind = args[:kind] if args.key?(:kind)
          @licenses = args[:licenses] if args.key?(:licenses)
          @mode = args[:mode] if args.key?(:mode)
          @saved_state = args[:saved_state] if args.key?(:saved_state)
          @shielded_instance_initial_state = args[:shielded_instance_initial_state] if args.key?(:shielded_instance_initial_state)
          @source = args[:source] if args.key?(:source)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # [Input Only] Specifies the parameters for a new disk that will be created
      # alongside the new instance. Use initialization parameters to create boot
      # disks or local SSDs attached to the new instance.
      # This field is persisted and returned for instanceTemplate and not returned
      # in the context of instance.
      # This property is mutually exclusive with the source property;
      # you can only define one or the other, but not both.
      class AttachedDiskInitializeParams
        include Google::Apis::Core::Hashable
      
        # The architecture of the attached disk. Valid values are
        # arm64 or x86_64.
        # Corresponds to the JSON property `architecture`
        # @return [String]
        attr_accessor :architecture
      
        # An optional description. Provide this property when creating the disk.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Specifies the disk name. If not specified, the default is to use the name
        # of the instance. If a disk with the same name already exists in the given
        # region, the existing disk is attached to the new instance and the
        # new disk is not created.
        # Corresponds to the JSON property `diskName`
        # @return [String]
        attr_accessor :disk_name
      
        # Specifies the size of the disk in base-2 GB. The size must be at least
        # 10 GB. If you specify a sourceImage, which is required for
        # boot disks, the default size is the size of the sourceImage.
        # If you do not specify a sourceImage, the default disk size
        # is 500 GB.
        # Corresponds to the JSON property `diskSizeGb`
        # @return [Fixnum]
        attr_accessor :disk_size_gb
      
        # Specifies the disk type to use to create the instance. If not specified,
        # the default is pd-standard, specified using the full URL.
        # For example:
        # https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/pd-
        # standard
        # For a full list of acceptable values, seePersistent disk
        # types. If you specify this field when creating a VM, you can provide
        # either the full or partial URL. For example, the following values are
        # valid:
        # 
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone/
        # diskTypes/diskType
        # - projects/project/zones/zone/diskTypes/diskType
        # - zones/zone/diskTypes/diskType
        # If you specify this field when creating or updating an instance template
        # or all-instances configuration, specify the type of the disk, not the
        # URL. For example: pd-standard.
        # Corresponds to the JSON property `diskType`
        # @return [String]
        attr_accessor :disk_type
      
        # Whether this disk is using confidential compute mode.
        # Corresponds to the JSON property `enableConfidentialCompute`
        # @return [Boolean]
        attr_accessor :enable_confidential_compute
        alias_method :enable_confidential_compute?, :enable_confidential_compute
      
        # Labels to apply to this disk. These can be later modified by thedisks.
        # setLabels method. This field is only applicable for
        # persistent disks.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # A list of publicly visible licenses. Reserved for Google's use.
        # Corresponds to the JSON property `licenses`
        # @return [Array<String>]
        attr_accessor :licenses
      
        # Specifies which action to take on instance update with this disk. Default
        # is to use the existing disk.
        # Corresponds to the JSON property `onUpdateAction`
        # @return [String]
        attr_accessor :on_update_action
      
        # Indicates how many IOPS to provision for the disk. This sets the number
        # of I/O operations per second that the disk can handle. Values must be
        # between 10,000 and 120,000. For more details, see theExtreme persistent
        # disk documentation.
        # Corresponds to the JSON property `provisionedIops`
        # @return [Fixnum]
        attr_accessor :provisioned_iops
      
        # Indicates how much throughput to provision for the disk. This sets the
        # number of throughput mb per second that the disk can handle. Values must
        # greater than or equal to 1.
        # Corresponds to the JSON property `provisionedThroughput`
        # @return [Fixnum]
        attr_accessor :provisioned_throughput
      
        # Required for each regional disk associated with the instance. Specify
        # the URLs of the zones where the disk should be replicated to.
        # You must provide exactly two replica zones, and one zone must be the same
        # as the instance zone.
        # Corresponds to the JSON property `replicaZones`
        # @return [Array<String>]
        attr_accessor :replica_zones
      
        # Resource manager tags to be bound to the disk. Tag keys and values
        # have the same definition as resource
        # manager tags. Keys and values can be either in numeric format,
        # such as `tagKeys/`tag_key_id`` and `tagValues/456` or in namespaced
        # format such as ``org_id|project_id`/`tag_key_short_name`` and
        # ``tag_value_short_name``. The field is ignored (both PUT & PATCH) when
        # empty.
        # Corresponds to the JSON property `resourceManagerTags`
        # @return [Hash<String,String>]
        attr_accessor :resource_manager_tags
      
        # Resource policies applied to this disk for automatic snapshot creations.
        # Specified using the full or partial URL. For instance template, specify
        # only the resource policy name.
        # Corresponds to the JSON property `resourcePolicies`
        # @return [Array<String>]
        attr_accessor :resource_policies
      
        # The source image to create this disk. When creating a new instance boot
        # disk, one of initializeParams.sourceImage orinitializeParams.sourceSnapshot or
        # disks.source
        # is required.
        # To create a disk with one of the public operating system
        # images, specify the image by its family name. For example, specifyfamily/
        # debian-9 to use the latest Debian 9 image:
        # projects/debian-cloud/global/images/family/debian-9
        # Alternatively, use a specific version of a public operating system image:
        # projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
        # To create a disk with a custom image that you created, specify the
        # image name in the following format:
        # global/images/my-custom-image
        # You can also specify a custom image by its image family, which returns
        # the latest version of the image in that family. Replace the image name
        # with family/family-name:
        # global/images/family/my-image-family
        # If the source image is deleted later, this field will not be set.
        # Corresponds to the JSON property `sourceImage`
        # @return [String]
        attr_accessor :source_image
      
        # Thecustomer-supplied
        # encryption key of the source image. Required if the source image is
        # protected by a customer-supplied encryption key.
        # InstanceTemplate and InstancePropertiesPatch do not storecustomer-supplied
        # encryption keys, so you cannot create disks for instances in a managed
        # instance group if the
        # source images are encrypted with your own keys.
        # Corresponds to the JSON property `sourceImageEncryptionKey`
        # @return [Google::Apis::ComputeV1::CustomerEncryptionKey]
        attr_accessor :source_image_encryption_key
      
        # The source snapshot to create this disk. When creating a new instance
        # boot disk, one of initializeParams.sourceSnapshot orinitializeParams.
        # sourceImage or disks.source
        # is required.
        # To create a disk with a snapshot that you created, specify the
        # snapshot name in the following format:
        # global/snapshots/my-backup
        # If the source snapshot is deleted later, this field will not be set.
        # Note: You cannot create VMs in bulk using a snapshot as the source. Use
        # an image instead when you create VMs using
        # the bulk
        # insert method.
        # Corresponds to the JSON property `sourceSnapshot`
        # @return [String]
        attr_accessor :source_snapshot
      
        # Thecustomer-supplied
        # encryption key of the source snapshot.
        # Corresponds to the JSON property `sourceSnapshotEncryptionKey`
        # @return [Google::Apis::ComputeV1::CustomerEncryptionKey]
        attr_accessor :source_snapshot_encryption_key
      
        # The storage pool in which the new disk is created. You can provide
        # this as a partial or full URL to the resource. For example, the following
        # are valid values:
        # 
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone/
        # storagePools/storagePool
        # - projects/project/zones/zone/storagePools/storagePool
        # - zones/zone/storagePools/storagePool
        # Corresponds to the JSON property `storagePool`
        # @return [String]
        attr_accessor :storage_pool
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @architecture = args[:architecture] if args.key?(:architecture)
          @description = args[:description] if args.key?(:description)
          @disk_name = args[:disk_name] if args.key?(:disk_name)
          @disk_size_gb = args[:disk_size_gb] if args.key?(:disk_size_gb)
          @disk_type = args[:disk_type] if args.key?(:disk_type)
          @enable_confidential_compute = args[:enable_confidential_compute] if args.key?(:enable_confidential_compute)
          @labels = args[:labels] if args.key?(:labels)
          @licenses = args[:licenses] if args.key?(:licenses)
          @on_update_action = args[:on_update_action] if args.key?(:on_update_action)
          @provisioned_iops = args[:provisioned_iops] if args.key?(:provisioned_iops)
          @provisioned_throughput = args[:provisioned_throughput] if args.key?(:provisioned_throughput)
          @replica_zones = args[:replica_zones] if args.key?(:replica_zones)
          @resource_manager_tags = args[:resource_manager_tags] if args.key?(:resource_manager_tags)
          @resource_policies = args[:resource_policies] if args.key?(:resource_policies)
          @source_image = args[:source_image] if args.key?(:source_image)
          @source_image_encryption_key = args[:source_image_encryption_key] if args.key?(:source_image_encryption_key)
          @source_snapshot = args[:source_snapshot] if args.key?(:source_snapshot)
          @source_snapshot_encryption_key = args[:source_snapshot_encryption_key] if args.key?(:source_snapshot_encryption_key)
          @storage_pool = args[:storage_pool] if args.key?(:storage_pool)
        end
      end
      
      # Specifies the audit configuration for a service.
      # The configuration determines which permission types are logged, and what
      # identities, if any, are exempted from logging.
      # An AuditConfig must have one or more AuditLogConfigs.
      # If there are AuditConfigs for both `allServices` and a specific service,
      # the union of the two AuditConfigs is used for that service: the log_types
      # specified in each AuditConfig are enabled, and the exempted_members in each
      # AuditLogConfig are exempted.
      # Example Policy with multiple AuditConfigs:
      # `
      # "audit_configs": [
      # `
      # "service": "allServices",
      # "audit_log_configs": [
      # `
      # "log_type": "DATA_READ",
      # "exempted_members": [
      # "user:jose@example.com"
      # ]
      # `,
      # `
      # "log_type": "DATA_WRITE"
      # `,
      # `
      # "log_type": "ADMIN_READ"
      # `
      # ]
      # `,
      # `
      # "service": "sampleservice.googleapis.com",
      # "audit_log_configs": [
      # `
      # "log_type": "DATA_READ"
      # `,
      # `
      # "log_type": "DATA_WRITE",
      # "exempted_members": [
      # "user:aliya@example.com"
      # ]
      # `
      # ]
      # `
      # ]
      # `
      # For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
      # logging. It also exempts `jose@example.com` from DATA_READ logging, and
      # `aliya@example.com` from DATA_WRITE logging.
      class AuditConfig
        include Google::Apis::Core::Hashable
      
        # The configuration for logging of each type of permission.
        # Corresponds to the JSON property `auditLogConfigs`
        # @return [Array<Google::Apis::ComputeV1::AuditLogConfig>]
        attr_accessor :audit_log_configs
      
        # Specifies a service that will be enabled for audit logging.
        # For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
        # `allServices` is a special value that covers all services.
        # Corresponds to the JSON property `service`
        # @return [String]
        attr_accessor :service
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @audit_log_configs = args[:audit_log_configs] if args.key?(:audit_log_configs)
          @service = args[:service] if args.key?(:service)
        end
      end
      
      # Provides the configuration for logging a type of permissions.
      # Example:
      # `
      # "audit_log_configs": [
      # `
      # "log_type": "DATA_READ",
      # "exempted_members": [
      # "user:jose@example.com"
      # ]
      # `,
      # `
      # "log_type": "DATA_WRITE"
      # `
      # ]
      # `
      # This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
      # jose@example.com from DATA_READ logging.
      class AuditLogConfig
        include Google::Apis::Core::Hashable
      
        # Specifies the identities that do not cause logging for this type of
        # permission.
        # Follows the same format of Binding.members.
        # Corresponds to the JSON property `exemptedMembers`
        # @return [Array<String>]
        attr_accessor :exempted_members
      
        # The log type that this config enables.
        # Corresponds to the JSON property `logType`
        # @return [String]
        attr_accessor :log_type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @exempted_members = args[:exempted_members] if args.key?(:exempted_members)
          @log_type = args[:log_type] if args.key?(:log_type)
        end
      end
      
      # Represents an Autoscaler resource.
      # Google Compute Engine has two Autoscaler resources:
      # * [Zonal](/compute/docs/reference/rest/v1/autoscalers)
      # * [Regional](/compute/docs/reference/rest/v1/regionAutoscalers)
      # Use autoscalers to automatically add or delete instances from a
      # managed instance group according to your defined autoscaling policy.
      # For more information, read Autoscaling Groups of Instances.
      # For zonal managed instance groups resource, use the autoscaler
      # resource.
      # For regional managed instance groups, use theregionAutoscalers resource.
      class Autoscaler
        include Google::Apis::Core::Hashable
      
        # Cloud Autoscaler policy.
        # Corresponds to the JSON property `autoscalingPolicy`
        # @return [Google::Apis::ComputeV1::AutoscalingPolicy]
        attr_accessor :autoscaling_policy
      
        # Output only. [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Output only. [Output Only] The unique identifier for the resource. This
        # identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. [Output Only] Type of the resource. Always compute#autoscaler
        # for autoscalers.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource. Provided by the client when the resource is created.
        # The name must be 1-63 characters long, and comply withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must
        # be a dash, lowercase letter, or digit, except the last character, which
        # cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Output only. [Output Only] Target recommended MIG size (number of instances)
        # computed by
        # autoscaler. Autoscaler calculates the recommended MIG size even when the
        # autoscaling policy mode is different from ON. This field is empty when
        # autoscaler is not connected to an existing managed instance group or
        # autoscaler did not generate its prediction.
        # Corresponds to the JSON property `recommendedSize`
        # @return [Fixnum]
        attr_accessor :recommended_size
      
        # Output only. [Output Only] URL of theregion
        # where the instance group resides (for autoscalers living in regional
        # scope).
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # Output only. [Output Only] Status information of existing scaling schedules.
        # Corresponds to the JSON property `scalingScheduleStatus`
        # @return [Hash<String,Google::Apis::ComputeV1::ScalingScheduleStatus>]
        attr_accessor :scaling_schedule_status
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] The status of the autoscaler configuration. Current set of
        # possible values:
        # 
        # - PENDING:
        # Autoscaler backend hasn't read new/updated configuration.
        # - DELETING:
        # Configuration is being deleted.
        # - ACTIVE:
        # Configuration is acknowledged to be effective. Some warnings might
        # be present in the statusDetails field.
        # - ERROR:
        # Configuration has errors. Actionable for users. Details are present in
        # the statusDetails field.
        # New values might be added in the future.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # [Output Only] Human-readable details about the current state of the
        # autoscaler. Read the documentation forCommonly
        # returned status messages for examples of status messages you might
        # encounter.
        # Corresponds to the JSON property `statusDetails`
        # @return [Array<Google::Apis::ComputeV1::AutoscalerStatusDetails>]
        attr_accessor :status_details
      
        # URL of the managed instance group that this autoscaler will scale. This
        # field is required when creating an autoscaler.
        # Corresponds to the JSON property `target`
        # @return [String]
        attr_accessor :target
      
        # Output only. [Output Only] URL of thezone
        # where the instance group resides (for autoscalers living in zonal scope).
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @autoscaling_policy = args[:autoscaling_policy] if args.key?(:autoscaling_policy)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @recommended_size = args[:recommended_size] if args.key?(:recommended_size)
          @region = args[:region] if args.key?(:region)
          @scaling_schedule_status = args[:scaling_schedule_status] if args.key?(:scaling_schedule_status)
          @self_link = args[:self_link] if args.key?(:self_link)
          @status = args[:status] if args.key?(:status)
          @status_details = args[:status_details] if args.key?(:status_details)
          @target = args[:target] if args.key?(:target)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class AutoscalerAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of AutoscalersScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeV1::AutoscalersScopedList>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Alwayscompute#
        # autoscalerAggregatedList for aggregated lists of
        # autoscalers.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Unreachable resources.
        # end_interface: MixerListResponseWithEtagBuilder
        # Corresponds to the JSON property `unreachables`
        # @return [Array<String>]
        attr_accessor :unreachables
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::AutoscalerAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @unreachables = args[:unreachables] if args.key?(:unreachables)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::AutoscalerAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of Autoscaler resources.
      class AutoscalerList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Autoscaler resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::Autoscaler>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Always compute#autoscalerList
        # for lists of autoscalers.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::AutoscalerList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::AutoscalerList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class AutoscalerStatusDetails
        include Google::Apis::Core::Hashable
      
        # The status message.
        # Corresponds to the JSON property `message`
        # @return [String]
        attr_accessor :message
      
        # The type of error, warning, or notice returned. Current set of possible
        # values:
        # 
        # - ALL_INSTANCES_UNHEALTHY (WARNING):
        # All instances in the instance group are unhealthy (not in RUNNING
        # state).
        # - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR):
        # There is no backend service attached to the instance group.
        # - CAPPED_AT_MAX_NUM_REPLICAS (WARNING):
        # Autoscaler recommends a size greater than maxNumReplicas.
        # - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING):
        # The custom metric samples are not exported often enough to be
        # a credible base for autoscaling.
        # - CUSTOM_METRIC_INVALID (ERROR):
        # The custom metric that was specified does not exist or does not have
        # the necessary labels.
        # - MIN_EQUALS_MAX (WARNING):
        # The minNumReplicas is equal to maxNumReplicas. This means the
        # autoscaler cannot add or remove instances from the instance group.
        # - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING):
        # The autoscaler did not receive any data from the custom metric
        # configured for autoscaling.
        # - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING):
        # The autoscaler is configured to scale based on a load balancing signal
        # but the instance group has not received any requests from the load
        # balancer.
        # - MODE_OFF (WARNING):
        # Autoscaling is turned off. The number of instances in the group won't
        # change automatically. The autoscaling configuration is preserved.
        # - MODE_ONLY_UP (WARNING):
        # Autoscaling is in the "Autoscale only out" mode. The autoscaler can add
        # instances but not remove any.
        # - MORE_THAN_ONE_BACKEND_SERVICE (ERROR):
        # The instance group cannot be autoscaled because it has more than one
        # backend service attached to it.
        # - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR):
        # There is insufficient quota for the necessary resources, such as CPU or
        # number of instances.
        # - REGION_RESOURCE_STOCKOUT (ERROR):
        # Shown only for regional autoscalers: there is a resource stockout in
        # the chosen region.
        # - SCALING_TARGET_DOES_NOT_EXIST (ERROR):
        # The target to be scaled does not exist.
        # - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION
        # (ERROR): Autoscaling does not work with an HTTP/S load balancer that
        # has been configured for maxRate.
        # - ZONE_RESOURCE_STOCKOUT (ERROR):
        # For zonal autoscalers: there is a resource stockout in the chosen zone.
        # For regional autoscalers: in at least one of the zones you're using
        # there is a resource stockout.
        # New values might be added in the future. Some of the values might not be
        # available in all API versions.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @message = args[:message] if args.key?(:message)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # 
      class AutoscalersScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of autoscalers contained in this scope.
        # Corresponds to the JSON property `autoscalers`
        # @return [Array<Google::Apis::ComputeV1::Autoscaler>]
        attr_accessor :autoscalers
      
        # [Output Only] Informational warning which replaces the list of autoscalers
        # when the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::AutoscalersScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @autoscalers = args[:autoscalers] if args.key?(:autoscalers)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning which replaces the list of autoscalers
        # when the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::AutoscalersScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Cloud Autoscaler policy.
      class AutoscalingPolicy
        include Google::Apis::Core::Hashable
      
        # The number of seconds that your application takes to initialize on a VM
        # instance. This is referred to as the
        # [initialization period](/compute/docs/autoscaler#cool_down_period).
        # Specifying an accurate initialization period improves
        # autoscaler decisions. For example, when scaling out, the autoscaler ignores
        # data from VMs that are still initializing because those VMs might not yet
        # represent normal usage of your application. The default initialization
        # period is 60 seconds.
        # Initialization periods might vary because of numerous
        # factors. We recommend that you test how long your application takes to
        # initialize. To do this, create a VM and time your application's startup
        # process.
        # Corresponds to the JSON property `coolDownPeriodSec`
        # @return [Fixnum]
        attr_accessor :cool_down_period_sec
      
        # CPU utilization policy.
        # Corresponds to the JSON property `cpuUtilization`
        # @return [Google::Apis::ComputeV1::AutoscalingPolicyCpuUtilization]
        attr_accessor :cpu_utilization
      
        # Configuration parameters of autoscaling based on a custom metric.
        # Corresponds to the JSON property `customMetricUtilizations`
        # @return [Array<Google::Apis::ComputeV1::AutoscalingPolicyCustomMetricUtilization>]
        attr_accessor :custom_metric_utilizations
      
        # Configuration parameters of autoscaling based on load balancing.
        # Corresponds to the JSON property `loadBalancingUtilization`
        # @return [Google::Apis::ComputeV1::AutoscalingPolicyLoadBalancingUtilization]
        attr_accessor :load_balancing_utilization
      
        # The maximum number of instances that the autoscaler can scale out to. This
        # is required when creating or updating an autoscaler. The maximum number
        # of replicas must not be lower than minimal number of replicas.
        # Corresponds to the JSON property `maxNumReplicas`
        # @return [Fixnum]
        attr_accessor :max_num_replicas
      
        # The minimum number of replicas that the autoscaler can scale in to.
        # This cannot be less than 0. If not provided, autoscaler chooses a
        # default value depending on maximum number of instances allowed.
        # Corresponds to the JSON property `minNumReplicas`
        # @return [Fixnum]
        attr_accessor :min_num_replicas
      
        # Defines the operating mode for this policy.
        # The following modes are available:
        # 
        # - OFF: Disables the autoscaler but maintains its
        # configuration.
        # - ONLY_SCALE_OUT: Restricts the autoscaler to add
        # VM instances only.
        # - ON: Enables all autoscaler activities according to its
        # policy.
        # For more information, see
        # "Turning off or restricting an autoscaler"
        # Corresponds to the JSON property `mode`
        # @return [String]
        attr_accessor :mode
      
        # Configuration that allows for slower scale in so that even if Autoscaler
        # recommends an abrupt scale in of a MIG, it will be throttled as specified
        # by the parameters below.
        # Corresponds to the JSON property `scaleInControl`
        # @return [Google::Apis::ComputeV1::AutoscalingPolicyScaleInControl]
        attr_accessor :scale_in_control
      
        # Scaling schedules defined for an autoscaler. Multiple schedules
        # can be set on an autoscaler, and they can overlap. During overlapping
        # periods the greatest min_required_replicas of all scaling schedules is
        # applied. Up to 128 scaling schedules are allowed.
        # Corresponds to the JSON property `scalingSchedules`
        # @return [Hash<String,Google::Apis::ComputeV1::AutoscalingPolicyScalingSchedule>]
        attr_accessor :scaling_schedules
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @cool_down_period_sec = args[:cool_down_period_sec] if args.key?(:cool_down_period_sec)
          @cpu_utilization = args[:cpu_utilization] if args.key?(:cpu_utilization)
          @custom_metric_utilizations = args[:custom_metric_utilizations] if args.key?(:custom_metric_utilizations)
          @load_balancing_utilization = args[:load_balancing_utilization] if args.key?(:load_balancing_utilization)
          @max_num_replicas = args[:max_num_replicas] if args.key?(:max_num_replicas)
          @min_num_replicas = args[:min_num_replicas] if args.key?(:min_num_replicas)
          @mode = args[:mode] if args.key?(:mode)
          @scale_in_control = args[:scale_in_control] if args.key?(:scale_in_control)
          @scaling_schedules = args[:scaling_schedules] if args.key?(:scaling_schedules)
        end
      end
      
      # CPU utilization policy.
      class AutoscalingPolicyCpuUtilization
        include Google::Apis::Core::Hashable
      
        # Indicates whether predictive autoscaling based on CPU metric is enabled.
        # Valid values are:
        # * NONE (default). No predictive method is used. The autoscaler scales the
        # group to meet current demand based on real-time metrics.
        # * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by
        # monitoring daily and weekly load patterns and scaling out ahead of
        # anticipated demand.
        # Corresponds to the JSON property `predictiveMethod`
        # @return [String]
        attr_accessor :predictive_method
      
        # The target CPU utilization that the autoscaler maintains. Must be
        # a float value in the range (0, 1]. If not specified, the default is0.6.
        # If the CPU level is below the target utilization, the autoscaler scales
        # in the number of instances until it reaches the minimum number of
        # instances you specified or until the average CPU of your instances
        # reaches the target utilization.
        # If the average CPU is above the target utilization, the autoscaler
        # scales out until it reaches the maximum number of instances you
        # specified or until the average utilization reaches the target
        # utilization.
        # Corresponds to the JSON property `utilizationTarget`
        # @return [Float]
        attr_accessor :utilization_target
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @predictive_method = args[:predictive_method] if args.key?(:predictive_method)
          @utilization_target = args[:utilization_target] if args.key?(:utilization_target)
        end
      end
      
      # Custom utilization metric policy.
      class AutoscalingPolicyCustomMetricUtilization
        include Google::Apis::Core::Hashable
      
        # A filter string, compatible with a Stackdriver Monitoringfilter string
        # forTimeSeries.list API call. This filter is
        # used to select a specific TimeSeries for the purpose of autoscaling and
        # to determine whether the metric is exporting per-instance or
        # per-group data.
        # For the filter to be valid for autoscaling purposes, the following rules
        # apply:
        # 
        # 
        # - You can only use the AND operator for joining
        # selectors.
        # - You can only use direct equality comparison operator
        # (=) without any functions for each selector.
        # - You can specify the metric in both the filter string and in the
        # metric field. However, if specified in both places, the metric must
        # be identical.
        # - The monitored resource type
        # determines what kind of values are expected for the metric. If it is
        # a gce_instance, the autoscaler expects the metric to
        # include a separate TimeSeries for each instance in a group. In such a
        # case, you cannot filter on resource labels.
        # 
        # 
        # If the resource type is any other value, the autoscaler expects
        # this metric to contain values that apply to the entire autoscaled
        # instance group and resource label filtering can be performed to
        # point autoscaler at the correct TimeSeries to scale upon. This is
        # called a *per-group metric* for the purpose of autoscaling.
        # 
        # If not specified, the type defaults to
        # gce_instance.
        # Try to provide a filter that is selective enough to pick just one
        # TimeSeries for the autoscaled group or for each of the instances (if you
        # are using gce_instance resource type). If multiple
        # TimeSeries are returned upon the query execution, the autoscaler will sum
        # their respective values to obtain its scaling value.
        # Corresponds to the JSON property `filter`
        # @return [String]
        attr_accessor :filter
      
        # The identifier (type) of the Stackdriver Monitoring metric. The metric
        # cannot have negative values.
        # The metric must have a value type of INT64 orDOUBLE.
        # Corresponds to the JSON property `metric`
        # @return [String]
        attr_accessor :metric
      
        # If scaling is based on a per-group metric value that represents the
        # total amount of work to be done or resource usage, set this value to an
        # amount assigned for a single instance of the scaled group. Autoscaler
        # keeps the number of instances proportional to the value of this
        # metric. The metric itself does not change value due to group
        # resizing.
        # A good metric to use with the target is for examplepubsub.googleapis.com/
        # subscription/num_undelivered_messages
        # or a custom metric exporting the total number of requests coming to
        # your instances.
        # A bad example would be a metric exporting an average or median latency,
        # since this value can't include a chunk assignable to a single instance,
        # it could be better used with utilization_target instead.
        # Corresponds to the JSON property `singleInstanceAssignment`
        # @return [Float]
        attr_accessor :single_instance_assignment
      
        # The target value of the metric that autoscaler maintains. This
        # must be a positive value. A utilization metric scales number of
        # virtual machines handling requests to increase or decrease
        # proportionally to the metric.
        # For example, a good metric to use as a utilization_target ishttps://www.
        # googleapis.com/compute/v1/instance/network/received_bytes_count.
        # The autoscaler works to keep this value constant for each of the
        # instances.
        # Corresponds to the JSON property `utilizationTarget`
        # @return [Float]
        attr_accessor :utilization_target
      
        # Defines how target utilization value is expressed for a Stackdriver
        # Monitoring metric. Either GAUGE,DELTA_PER_SECOND, or DELTA_PER_MINUTE.
        # Corresponds to the JSON property `utilizationTargetType`
        # @return [String]
        attr_accessor :utilization_target_type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @filter = args[:filter] if args.key?(:filter)
          @metric = args[:metric] if args.key?(:metric)
          @single_instance_assignment = args[:single_instance_assignment] if args.key?(:single_instance_assignment)
          @utilization_target = args[:utilization_target] if args.key?(:utilization_target)
          @utilization_target_type = args[:utilization_target_type] if args.key?(:utilization_target_type)
        end
      end
      
      # Configuration parameters of autoscaling based on load balancing.
      class AutoscalingPolicyLoadBalancingUtilization
        include Google::Apis::Core::Hashable
      
        # Fraction of backend capacity utilization (set in HTTP(S) load balancing
        # configuration) that the autoscaler maintains. Must be a positive float
        # value. If not defined, the default is 0.8.
        # Corresponds to the JSON property `utilizationTarget`
        # @return [Float]
        attr_accessor :utilization_target
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @utilization_target = args[:utilization_target] if args.key?(:utilization_target)
        end
      end
      
      # Configuration that allows for slower scale in so that even if Autoscaler
      # recommends an abrupt scale in of a MIG, it will be throttled as specified
      # by the parameters below.
      class AutoscalingPolicyScaleInControl
        include Google::Apis::Core::Hashable
      
        # Encapsulates numeric value that can be either absolute or relative.
        # Corresponds to the JSON property `maxScaledInReplicas`
        # @return [Google::Apis::ComputeV1::FixedOrPercent]
        attr_accessor :max_scaled_in_replicas
      
        # How far back autoscaling looks when computing recommendations to
        # include directives regarding slower scale in, as described above.
        # Corresponds to the JSON property `timeWindowSec`
        # @return [Fixnum]
        attr_accessor :time_window_sec
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @max_scaled_in_replicas = args[:max_scaled_in_replicas] if args.key?(:max_scaled_in_replicas)
          @time_window_sec = args[:time_window_sec] if args.key?(:time_window_sec)
        end
      end
      
      # Scaling based on user-defined schedule. The message describes a single
      # scaling schedule. A scaling schedule changes the minimum number of VM
      # instances an autoscaler can recommend, which can trigger scaling out.
      class AutoscalingPolicyScalingSchedule
        include Google::Apis::Core::Hashable
      
        # A description of a scaling schedule.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # A boolean value that specifies whether a scaling schedule can influence
        # autoscaler recommendations. If set to true, then a scaling schedule has
        # no effect. This field is optional, and its value is false by default.
        # Corresponds to the JSON property `disabled`
        # @return [Boolean]
        attr_accessor :disabled
        alias_method :disabled?, :disabled
      
        # The duration of time intervals, in seconds, for which this
        # scaling schedule is to run. The minimum allowed value is 300.
        # This field is required.
        # Corresponds to the JSON property `durationSec`
        # @return [Fixnum]
        attr_accessor :duration_sec
      
        # The minimum number of VM instances that the autoscaler will
        # recommend in time intervals starting according to schedule. This field is
        # required.
        # Corresponds to the JSON property `minRequiredReplicas`
        # @return [Fixnum]
        attr_accessor :min_required_replicas
      
        # The start timestamps of time intervals when this scaling
        # schedule is to provide a scaling signal. This field uses the extended
        # cron format (with an optional year field). The expression can describe a
        # single timestamp if the optional year is set, in which case the scaling
        # schedule runs once. The schedule is interpreted with respect to
        # time_zone. This field is required. Note: These timestamps only describe
        # when autoscaler starts providing the scaling signal. The VMs
        # need additional time to become serving.
        # Corresponds to the JSON property `schedule`
        # @return [String]
        attr_accessor :schedule
      
        # The time zone to use when interpreting the schedule.
        # The value of this field must be a time zone name from the tz database:
        # https://en.wikipedia.org/wiki/Tz_database. This field is assigned a
        # default value of "UTC" if left empty.
        # Corresponds to the JSON property `timeZone`
        # @return [String]
        attr_accessor :time_zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @description = args[:description] if args.key?(:description)
          @disabled = args[:disabled] if args.key?(:disabled)
          @duration_sec = args[:duration_sec] if args.key?(:duration_sec)
          @min_required_replicas = args[:min_required_replicas] if args.key?(:min_required_replicas)
          @schedule = args[:schedule] if args.key?(:schedule)
          @time_zone = args[:time_zone] if args.key?(:time_zone)
        end
      end
      
      # Message containing information of one individual backend.
      class Backend
        include Google::Apis::Core::Hashable
      
        # Specifies how to determine whether the backend of a load balancer can
        # handle additional traffic or is fully loaded. For usage guidelines, see
        # Connection balancing mode.
        # Backends must use compatible balancing modes. For more information, see
        # Supported balancing modes and target capacity settings and
        # Restrictions and guidance for instance groups.
        # Note: Currently, if you use the API to configure incompatible balancing
        # modes, the configuration might be accepted even though it has no impact
        # and is ignored. Specifically, Backend.maxUtilization is ignored when
        # Backend.balancingMode is RATE. In the future, this incompatible combination
        # will be rejected.
        # Corresponds to the JSON property `balancingMode`
        # @return [String]
        attr_accessor :balancing_mode
      
        # A multiplier applied to the backend's target capacity of its balancing
        # mode.
        # The default value is 1, which means the group serves up to
        # 100% of its configured capacity (depending onbalancingMode). A setting of 0
        # means the group is
        # completely drained, offering 0% of its available capacity. The valid ranges
        # are 0.0 and [0.1,1.0].
        # You cannot configure a setting larger than 0 and smaller than0.1.
        # You cannot configure a setting of 0 when there is only one
        # backend attached to the backend service.
        # Not available with backends that don't support using abalancingMode. This
        # includes backends such as global
        # internet NEGs, regional serverless NEGs, and PSC NEGs.
        # Corresponds to the JSON property `capacityScaler`
        # @return [Float]
        attr_accessor :capacity_scaler
      
        # List of custom metrics that are used for CUSTOM_METRICS
        # BalancingMode.
        # Corresponds to the JSON property `customMetrics`
        # @return [Array<Google::Apis::ComputeV1::BackendCustomMetric>]
        attr_accessor :custom_metrics
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # This field designates whether this is a failover backend. More than one
        # failover backend can be configured for a given BackendService.
        # Corresponds to the JSON property `failover`
        # @return [Boolean]
        attr_accessor :failover
        alias_method :failover?, :failover
      
        # The fully-qualified URL of aninstance
        # group or network endpoint
        # group (NEG) resource. To determine what types of backends a load
        # balancer supports, see the [Backend services
        # overview](https://cloud.google.com/load-balancing/docs/backend-service#
        # backends).
        # You must use the *fully-qualified* URL (starting withhttps://www.googleapis.
        # com/) to specify the instance group
        # or NEG. Partial URLs are not supported.
        # If haPolicy is specified, backends must refer to NEG resources of type
        # GCE_VM_IP.
        # Corresponds to the JSON property `group`
        # @return [String]
        attr_accessor :group
      
        # Defines a target maximum number of simultaneous connections. For usage
        # guidelines, seeConnection
        # balancing mode and Utilization
        # balancing mode. Not available if the backend'sbalancingMode is RATE.
        # Corresponds to the JSON property `maxConnections`
        # @return [Fixnum]
        attr_accessor :max_connections
      
        # Defines a target maximum number of simultaneous connections.  For usage
        # guidelines, seeConnection
        # balancing mode and Utilization
        # balancing mode.
        # Not available if the backend's balancingMode isRATE.
        # Corresponds to the JSON property `maxConnectionsPerEndpoint`
        # @return [Fixnum]
        attr_accessor :max_connections_per_endpoint
      
        # Defines a target maximum number of simultaneous connections.
        # For usage guidelines, seeConnection
        # balancing mode and Utilization
        # balancing mode.
        # Not available if the backend's balancingMode isRATE.
        # Corresponds to the JSON property `maxConnectionsPerInstance`
        # @return [Fixnum]
        attr_accessor :max_connections_per_instance
      
        # Defines a maximum number of HTTP requests per second (RPS). For
        # usage guidelines, seeRate
        # balancing mode and Utilization
        # balancing mode.
        # Not available if the backend's balancingMode isCONNECTION.
        # Corresponds to the JSON property `maxRate`
        # @return [Fixnum]
        attr_accessor :max_rate
      
        # Defines a maximum target for requests per second (RPS). For usage
        # guidelines, seeRate
        # balancing mode and Utilization
        # balancing mode.
        # Not available if the backend's balancingMode isCONNECTION.
        # Corresponds to the JSON property `maxRatePerEndpoint`
        # @return [Float]
        attr_accessor :max_rate_per_endpoint
      
        # Defines a maximum target for requests per second (RPS). For usage
        # guidelines, seeRate
        # balancing mode and Utilization
        # balancing mode.
        # Not available if the backend's balancingMode isCONNECTION.
        # Corresponds to the JSON property `maxRatePerInstance`
        # @return [Float]
        attr_accessor :max_rate_per_instance
      
        # Optional parameter to define a target capacity for theUTILIZATION balancing
        # mode. The valid range is[0.0, 1.0].
        # For usage guidelines, seeUtilization
        # balancing mode.
        # Corresponds to the JSON property `maxUtilization`
        # @return [Float]
        attr_accessor :max_utilization
      
        # This field indicates whether this backend should be fully utilized before
        # sending traffic to backends with default preference. The possible values
        # are:
        # 
        # - PREFERRED: Backends with this preference level will be
        # filled up to their capacity limits first, based on RTT.
        # - DEFAULT:  If preferred backends don't have enough
        # capacity, backends in this layer would be used and traffic would be
        # assigned based on the load balancing algorithm you use. This is the
        # default
        # Corresponds to the JSON property `preference`
        # @return [String]
        attr_accessor :preference
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @balancing_mode = args[:balancing_mode] if args.key?(:balancing_mode)
          @capacity_scaler = args[:capacity_scaler] if args.key?(:capacity_scaler)
          @custom_metrics = args[:custom_metrics] if args.key?(:custom_metrics)
          @description = args[:description] if args.key?(:description)
          @failover = args[:failover] if args.key?(:failover)
          @group = args[:group] if args.key?(:group)
          @max_connections = args[:max_connections] if args.key?(:max_connections)
          @max_connections_per_endpoint = args[:max_connections_per_endpoint] if args.key?(:max_connections_per_endpoint)
          @max_connections_per_instance = args[:max_connections_per_instance] if args.key?(:max_connections_per_instance)
          @max_rate = args[:max_rate] if args.key?(:max_rate)
          @max_rate_per_endpoint = args[:max_rate_per_endpoint] if args.key?(:max_rate_per_endpoint)
          @max_rate_per_instance = args[:max_rate_per_instance] if args.key?(:max_rate_per_instance)
          @max_utilization = args[:max_utilization] if args.key?(:max_utilization)
          @preference = args[:preference] if args.key?(:preference)
        end
      end
      
      # Represents a Cloud Storage Bucket resource.
      # This Cloud Storage bucket resource is referenced by a URL map of a load
      # balancer. For more information, readBackend Buckets.
      class BackendBucket
        include Google::Apis::Core::Hashable
      
        # Cloud Storage bucket name.
        # Corresponds to the JSON property `bucketName`
        # @return [String]
        attr_accessor :bucket_name
      
        # Message containing Cloud CDN configuration for a backend bucket.
        # Corresponds to the JSON property `cdnPolicy`
        # @return [Google::Apis::ComputeV1::BackendBucketCdnPolicy]
        attr_accessor :cdn_policy
      
        # Compress text responses using Brotli or gzip compression, based on
        # the client's Accept-Encoding header.
        # Corresponds to the JSON property `compressionMode`
        # @return [String]
        attr_accessor :compression_mode
      
        # [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # Headers that the Application Load Balancer should add to proxied responses.
        # Corresponds to the JSON property `customResponseHeaders`
        # @return [Array<String>]
        attr_accessor :custom_response_headers
      
        # An optional textual description of the resource; provided by the client
        # when the resource is created.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The resource URL for the edge security policy associated with
        # this backend bucket.
        # Corresponds to the JSON property `edgeSecurityPolicy`
        # @return [String]
        attr_accessor :edge_security_policy
      
        # If true, enable Cloud CDN for this BackendBucket.
        # Corresponds to the JSON property `enableCdn`
        # @return [Boolean]
        attr_accessor :enable_cdn
        alias_method :enable_cdn?, :enable_cdn
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. Type of the resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The value can only be INTERNAL_MANAGED for cross-region internal layer 7
        # load balancer.
        # If loadBalancingScheme is not specified, the backend bucket can be used by
        # classic global external load balancers, or global application external load
        # balancers, or both.
        # Corresponds to the JSON property `loadBalancingScheme`
        # @return [String]
        attr_accessor :load_balancing_scheme
      
        # Name of the resource. Provided by the client when the resource is created.
        # The name must be 1-63 characters long, and comply withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must
        # be a dash, lowercase letter, or digit, except the last character, which
        # cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Additional Backend Bucket parameters.
        # Corresponds to the JSON property `params`
        # @return [Google::Apis::ComputeV1::BackendBucketParams]
        attr_accessor :params
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] List of resources referencing that backend bucket.
        # Corresponds to the JSON property `usedBy`
        # @return [Array<Google::Apis::ComputeV1::BackendBucketUsedBy>]
        attr_accessor :used_by
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @bucket_name = args[:bucket_name] if args.key?(:bucket_name)
          @cdn_policy = args[:cdn_policy] if args.key?(:cdn_policy)
          @compression_mode = args[:compression_mode] if args.key?(:compression_mode)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @custom_response_headers = args[:custom_response_headers] if args.key?(:custom_response_headers)
          @description = args[:description] if args.key?(:description)
          @edge_security_policy = args[:edge_security_policy] if args.key?(:edge_security_policy)
          @enable_cdn = args[:enable_cdn] if args.key?(:enable_cdn)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @load_balancing_scheme = args[:load_balancing_scheme] if args.key?(:load_balancing_scheme)
          @name = args[:name] if args.key?(:name)
          @params = args[:params] if args.key?(:params)
          @self_link = args[:self_link] if args.key?(:self_link)
          @used_by = args[:used_by] if args.key?(:used_by)
        end
      end
      
      # Message containing Cloud CDN configuration for a backend bucket.
      class BackendBucketCdnPolicy
        include Google::Apis::Core::Hashable
      
        # Bypass the cache when the specified request headers are matched - e.g.
        # Pragma or Authorization headers. Up to 5 headers can be specified.
        # The cache is bypassed for all cdnPolicy.cacheMode settings.
        # Corresponds to the JSON property `bypassCacheOnRequestHeaders`
        # @return [Array<Google::Apis::ComputeV1::BackendBucketCdnPolicyBypassCacheOnRequestHeader>]
        attr_accessor :bypass_cache_on_request_headers
      
        # Message containing what to include in the cache key for a request for
        # Cloud CDN.
        # Corresponds to the JSON property `cacheKeyPolicy`
        # @return [Google::Apis::ComputeV1::BackendBucketCdnPolicyCacheKeyPolicy]
        attr_accessor :cache_key_policy
      
        # Specifies the cache setting for all responses from this backend.
        # The possible values are:USE_ORIGIN_HEADERS Requires the origin to set valid
        # caching
        # headers to cache content. Responses without these headers will not be
        # cached at Google's edge, and will require a full trip to the origin on
        # every request, potentially impacting performance and increasing load on
        # the origin server.FORCE_CACHE_ALL Cache all content, ignoring any "private",
        # "no-store" or "no-cache" directives in Cache-Control response headers.
        # Warning: this may result in Cloud CDN caching private,
        # per-user (user identifiable) content.CACHE_ALL_STATIC Automatically cache
        # static content,
        # including common image formats, media (video and audio), and web assets
        # (JavaScript and CSS). Requests and responses that are marked as
        # uncacheable, as well as dynamic content (including HTML), will not be
        # cached.
        # If no value is provided for cdnPolicy.cacheMode, it defaults
        # to CACHE_ALL_STATIC.
        # Corresponds to the JSON property `cacheMode`
        # @return [String]
        attr_accessor :cache_mode
      
        # Specifies a separate client (e.g. browser client) maximum TTL. This is
        # used to clamp the max-age (or Expires) value sent to the client.  With
        # FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the
        # response max-age directive, along with a "public" directive.  For
        # cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age
        # from the origin (if specified), or else sets the response max-age
        # directive to the lesser of the client_ttl and default_ttl, and also
        # ensures a "public" cache-control directive is present.
        # If a client TTL is not specified, a default value (1 hour) will be used.
        # The maximum allowed value is 31,622,400s (1 year).
        # Corresponds to the JSON property `clientTtl`
        # @return [Fixnum]
        attr_accessor :client_ttl
      
        # Specifies the default TTL for cached content served by this origin for
        # responses that do not have an existing valid TTL (max-age or s-maxage).
        # Setting a TTL of "0" means "always revalidate".
        # The value of defaultTTL cannot be set to a value greater than that of
        # maxTTL, but can be equal.
        # When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL
        # will overwrite the TTL set in all responses. The maximum allowed value is
        # 31,622,400s (1 year), noting that infrequently accessed objects may be
        # evicted from the cache before the defined TTL.
        # Corresponds to the JSON property `defaultTtl`
        # @return [Fixnum]
        attr_accessor :default_ttl
      
        # Specifies the maximum allowed TTL for cached content served by this
        # origin.
        # Cache directives that attempt to set a max-age or s-maxage higher than
        # this, or an Expires header more than maxTTL seconds in the future will
        # be capped at the value of maxTTL, as if it were the value of an
        # s-maxage Cache-Control directive.
        # Headers sent to the client will not be modified.
        # Setting a TTL of "0" means "always revalidate".
        # The maximum allowed value is 31,622,400s (1 year), noting that
        # infrequently accessed objects may be evicted from the cache before
        # the defined TTL.
        # Corresponds to the JSON property `maxTtl`
        # @return [Fixnum]
        attr_accessor :max_ttl
      
        # Negative caching allows per-status code TTLs to be set, in order
        # to apply fine-grained caching for common errors or redirects.
        # This can reduce the load on your origin and improve end-user
        # experience by reducing response latency.
        # When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS,
        # negative caching applies to responses with the specified response code
        # that lack any Cache-Control, Expires, or Pragma: no-cache directives.
        # When the cache mode is set to FORCE_CACHE_ALL, negative caching applies
        # to all responses with the specified response code, and override any
        # caching headers.
        # By default, Cloud CDN will apply the following default TTLs to these
        # status codes:
        # HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
        # HTTP 404 (Not Found), 410 (Gone),
        # 451 (Unavailable For Legal Reasons): 120s
        # HTTP 405 (Method Not Found), 501 (Not Implemented): 60s.
        # These defaults can be overridden in negative_caching_policy.
        # Corresponds to the JSON property `negativeCaching`
        # @return [Boolean]
        attr_accessor :negative_caching
        alias_method :negative_caching?, :negative_caching
      
        # Sets a cache TTL for the specified HTTP status code.
        # negative_caching must be enabled to configure negative_caching_policy.
        # Omitting the policy and leaving negative_caching enabled will use
        # Cloud CDN's default cache TTLs.
        # Note that when specifying an explicit negative_caching_policy, you
        # should take care to specify a cache TTL for all response codes
        # that you wish to cache. Cloud CDN will not apply any default
        # negative caching when a policy exists.
        # Corresponds to the JSON property `negativeCachingPolicy`
        # @return [Array<Google::Apis::ComputeV1::BackendBucketCdnPolicyNegativeCachingPolicy>]
        attr_accessor :negative_caching_policy
      
        # If true then Cloud CDN will combine multiple concurrent cache fill
        # requests into a small number of requests to the origin.
        # Corresponds to the JSON property `requestCoalescing`
        # @return [Boolean]
        attr_accessor :request_coalescing
        alias_method :request_coalescing?, :request_coalescing
      
        # Serve existing content from the cache (if available) when revalidating
        # content with the origin, or when an error is encountered when refreshing
        # the cache.
        # This setting defines the default "max-stale" duration for any cached
        # responses that do not specify a max-stale directive. Stale responses that
        # exceed the TTL configured here will not be served. The default limit
        # (max-stale) is 86400s (1 day), which will allow stale content to be
        # served up to this limit beyond the max-age (or s-maxage) of a cached
        # response.
        # The maximum allowed value is 604800 (1 week).
        # Set this to zero (0) to disable serve-while-stale.
        # Corresponds to the JSON property `serveWhileStale`
        # @return [Fixnum]
        attr_accessor :serve_while_stale
      
        # Maximum number of seconds the response to a signed URL request will be
        # considered fresh. After this time period, the response will be
        # revalidated before being served. Defaults to 1hr (3600s).  When serving
        # responses to signed URL requests, Cloud CDN will internally behave as
        # though all responses from this backend had a "Cache-Control:
        # public, max-age=[TTL]" header, regardless of any existing
        # Cache-Control header. The actual headers served in responses will not be
        # altered.
        # Corresponds to the JSON property `signedUrlCacheMaxAgeSec`
        # @return [Fixnum]
        attr_accessor :signed_url_cache_max_age_sec
      
        # [Output Only] Names of the keys for signing request URLs.
        # Corresponds to the JSON property `signedUrlKeyNames`
        # @return [Array<String>]
        attr_accessor :signed_url_key_names
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @bypass_cache_on_request_headers = args[:bypass_cache_on_request_headers] if args.key?(:bypass_cache_on_request_headers)
          @cache_key_policy = args[:cache_key_policy] if args.key?(:cache_key_policy)
          @cache_mode = args[:cache_mode] if args.key?(:cache_mode)
          @client_ttl = args[:client_ttl] if args.key?(:client_ttl)
          @default_ttl = args[:default_ttl] if args.key?(:default_ttl)
          @max_ttl = args[:max_ttl] if args.key?(:max_ttl)
          @negative_caching = args[:negative_caching] if args.key?(:negative_caching)
          @negative_caching_policy = args[:negative_caching_policy] if args.key?(:negative_caching_policy)
          @request_coalescing = args[:request_coalescing] if args.key?(:request_coalescing)
          @serve_while_stale = args[:serve_while_stale] if args.key?(:serve_while_stale)
          @signed_url_cache_max_age_sec = args[:signed_url_cache_max_age_sec] if args.key?(:signed_url_cache_max_age_sec)
          @signed_url_key_names = args[:signed_url_key_names] if args.key?(:signed_url_key_names)
        end
      end
      
      # Bypass the cache when the specified request headers are present,
      # e.g. Pragma or Authorization headers. Values are case insensitive.
      # The presence of such a header overrides the cache_mode setting.
      class BackendBucketCdnPolicyBypassCacheOnRequestHeader
        include Google::Apis::Core::Hashable
      
        # The header field name to match on when bypassing cache.
        # Values are case-insensitive.
        # Corresponds to the JSON property `headerName`
        # @return [String]
        attr_accessor :header_name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @header_name = args[:header_name] if args.key?(:header_name)
        end
      end
      
      # Message containing what to include in the cache key for a request for
      # Cloud CDN.
      class BackendBucketCdnPolicyCacheKeyPolicy
        include Google::Apis::Core::Hashable
      
        # Allows HTTP request headers (by name) to be used in the cache key.
        # Corresponds to the JSON property `includeHttpHeaders`
        # @return [Array<String>]
        attr_accessor :include_http_headers
      
        # Names of query string parameters to include in cache keys. Default
        # parameters are always included. '&' and '=' will be percent encoded
        # and not treated as delimiters.
        # Corresponds to the JSON property `queryStringWhitelist`
        # @return [Array<String>]
        attr_accessor :query_string_whitelist
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @include_http_headers = args[:include_http_headers] if args.key?(:include_http_headers)
          @query_string_whitelist = args[:query_string_whitelist] if args.key?(:query_string_whitelist)
        end
      end
      
      # Specify CDN TTLs for response error codes.
      class BackendBucketCdnPolicyNegativeCachingPolicy
        include Google::Apis::Core::Hashable
      
        # The HTTP status code to define a TTL against. Only HTTP status codes
        # 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 can be
        # specified as values, and you cannot specify a status code more than
        # once.
        # Corresponds to the JSON property `code`
        # @return [Fixnum]
        attr_accessor :code
      
        # The TTL (in seconds) for which to cache responses with the
        # corresponding status code.
        # The maximum allowed value is 1800s (30 minutes), noting that
        # infrequently accessed objects may be evicted from the cache before the
        # defined TTL.
        # Corresponds to the JSON property `ttl`
        # @return [Fixnum]
        attr_accessor :ttl
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @code = args[:code] if args.key?(:code)
          @ttl = args[:ttl] if args.key?(:ttl)
        end
      end
      
      # Contains a list of BackendBucket resources.
      class BackendBucketList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of BackendBucket resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::BackendBucket>]
        attr_accessor :items
      
        # Output only. Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::BackendBucketList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::BackendBucketList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Additional Backend Bucket parameters.
      class BackendBucketParams
        include Google::Apis::Core::Hashable
      
        # Tag keys/values directly bound to this resource.
        # Tag keys and values have the same definition as resource
        # manager tags. The field is allowed for INSERT
        # only. The keys/values to set on the resource should be specified in
        # either ID ` : ` or Namespaced format
        # ` : `.
        # For example the following are valid inputs:
        # * `"tagKeys/333" : "tagValues/444", "tagKeys/123" : "tagValues/456"`
        # * `"123/environment" : "production", "345/abc" : "xyz"`
        # Note:
        # * Invalid combinations of ID & namespaced format is not supported. For
        # instance: `"123/environment" : "tagValues/444"` is invalid.
        # Corresponds to the JSON property `resourceManagerTags`
        # @return [Hash<String,String>]
        attr_accessor :resource_manager_tags
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @resource_manager_tags = args[:resource_manager_tags] if args.key?(:resource_manager_tags)
        end
      end
      
      # 
      class BackendBucketUsedBy
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Server-defined URL for UrlMaps referencing that
        # BackendBucket.
        # Corresponds to the JSON property `reference`
        # @return [String]
        attr_accessor :reference
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @reference = args[:reference] if args.key?(:reference)
        end
      end
      
      # Custom Metrics are used for CUSTOM_METRICS balancing_mode.
      class BackendCustomMetric
        include Google::Apis::Core::Hashable
      
        # If true, the metric data is collected and reported to Cloud
        # Monitoring, but is not used for load balancing.
        # Corresponds to the JSON property `dryRun`
        # @return [Boolean]
        attr_accessor :dry_run
        alias_method :dry_run?, :dry_run
      
        # Optional parameter to define a target utilization for the Custom Metrics
        # balancing mode. The valid range is [0.0, 1.0].
        # Corresponds to the JSON property `maxUtilization`
        # @return [Float]
        attr_accessor :max_utilization
      
        # Name of a custom utilization signal. The name must be 1-64 characters
        # long and match the regular expression
        # `[a-z]([-_.a-z0-9]*[a-z0-9])?` which means that the
        # first character must be a lowercase letter, and all following
        # characters must be a dash, period, underscore, lowercase letter, or
        # digit, except the last character, which cannot be a dash, period, or
        # underscore. For usage guidelines, see Custom Metrics balancing mode. This
        # field can only be used for a global or regional backend service with the
        # loadBalancingScheme set to EXTERNAL_MANAGED,INTERNAL_MANAGED
        # INTERNAL_SELF_MANAGED.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @dry_run = args[:dry_run] if args.key?(:dry_run)
          @max_utilization = args[:max_utilization] if args.key?(:max_utilization)
          @name = args[:name] if args.key?(:name)
        end
      end
      
      # Represents a Backend Service resource.
      # A backend service defines how Google Cloud load balancers distribute traffic.
      # The backend service configuration contains a set of values, such as the
      # protocol used to connect to backends, various distribution and session
      # settings, health checks, and timeouts. These settings provide fine-grained
      # control over how your load balancer behaves. Most of the settings have
      # default values that allow for easy configuration if you need to get started
      # quickly.
      # Backend services in Google Compute Engine can be either regionally or
      # globally scoped.
      # * [Global](https://cloud.google.com/compute/docs/reference/rest/v1/
      # backendServices)
      # * [Regional](https://cloud.google.com/compute/docs/reference/rest/v1/
      # regionBackendServices)
      # For more information, seeBackend
      # Services.
      class BackendService
        include Google::Apis::Core::Hashable
      
        # Lifetime of cookies in seconds. This setting is applicable to Application
        # Load Balancers and Traffic Director and requires
        # GENERATED_COOKIE or HTTP_COOKIE session affinity.
        # If set to 0, the cookie is non-persistent and lasts only until
        # the end of the browser session (or equivalent). The maximum allowed value
        # is two weeks (1,209,600).
        # Not supported when the backend service is referenced by a URL map that is
        # bound to target gRPC proxy that has validateForProxyless field set to true.
        # Corresponds to the JSON property `affinityCookieTtlSec`
        # @return [Fixnum]
        attr_accessor :affinity_cookie_ttl_sec
      
        # The list of backends that serve this BackendService.
        # Corresponds to the JSON property `backends`
        # @return [Array<Google::Apis::ComputeV1::Backend>]
        attr_accessor :backends
      
        # Message containing Cloud CDN configuration for a backend service.
        # Corresponds to the JSON property `cdnPolicy`
        # @return [Google::Apis::ComputeV1::BackendServiceCdnPolicy]
        attr_accessor :cdn_policy
      
        # Settings controlling the volume of requests, connections and retries to this
        # backend service.
        # Corresponds to the JSON property `circuitBreakers`
        # @return [Google::Apis::ComputeV1::CircuitBreakers]
        attr_accessor :circuit_breakers
      
        # Compress text responses using Brotli or gzip compression, based on
        # the client's Accept-Encoding header.
        # Corresponds to the JSON property `compressionMode`
        # @return [String]
        attr_accessor :compression_mode
      
        # Message containing connection draining configuration.
        # Corresponds to the JSON property `connectionDraining`
        # @return [Google::Apis::ComputeV1::ConnectionDraining]
        attr_accessor :connection_draining
      
        # Connection Tracking configuration for this BackendService.
        # Corresponds to the JSON property `connectionTrackingPolicy`
        # @return [Google::Apis::ComputeV1::BackendServiceConnectionTrackingPolicy]
        attr_accessor :connection_tracking_policy
      
        # This message defines settings for a consistent hash style load balancer.
        # Corresponds to the JSON property `consistentHash`
        # @return [Google::Apis::ComputeV1::ConsistentHashLoadBalancerSettings]
        attr_accessor :consistent_hash
      
        # Output only. [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # List of custom metrics that are used for theWEIGHTED_ROUND_ROBIN
        # locality_lb_policy.
        # Corresponds to the JSON property `customMetrics`
        # @return [Array<Google::Apis::ComputeV1::BackendServiceCustomMetric>]
        attr_accessor :custom_metrics
      
        # Headers that the load balancer adds to proxied requests. See [Creating
        # custom
        # headers](https://cloud.google.com/load-balancing/docs/custom-headers).
        # Corresponds to the JSON property `customRequestHeaders`
        # @return [Array<String>]
        attr_accessor :custom_request_headers
      
        # Headers that the load balancer adds to proxied responses. See [Creating
        # custom
        # headers](https://cloud.google.com/load-balancing/docs/custom-headers).
        # Corresponds to the JSON property `customResponseHeaders`
        # @return [Array<String>]
        attr_accessor :custom_response_headers
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The resource URL for the edge security policy associated with
        # this backend service.
        # Corresponds to the JSON property `edgeSecurityPolicy`
        # @return [String]
        attr_accessor :edge_security_policy
      
        # If true, enables Cloud CDN for the backend service of a
        # global external Application Load Balancer.
        # Corresponds to the JSON property `enableCDN`
        # @return [Boolean]
        attr_accessor :enable_cdn
        alias_method :enable_cdn?, :enable_cdn
      
        # Specifies the canary migration state. Possible values are PREPARE,
        # TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC.
        # To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be
        # changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before
        # the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the
        # TEST_BY_PERCENTAGE state can be used to migrate traffic by percentage using
        # externalManagedMigrationTestingPercentage.
        # Rolling back a migration requires the states to be set in reverse order. So
        # changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to
        # be set to TEST_ALL_TRAFFIC at the same time. Optionally, the
        # TEST_BY_PERCENTAGE state can be used to migrate some traffic back to
        # EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
        # Corresponds to the JSON property `externalManagedMigrationState`
        # @return [String]
        attr_accessor :external_managed_migration_state
      
        # Determines the fraction of requests that should be processed by the Global
        # external Application Load Balancer.
        # The value of this field must be in the range [0, 100].
        # Session affinity options will slightly affect this routing behavior, for
        # more details, see:Session
        # Affinity.
        # This value can only be set if the loadBalancingScheme in the BackendService
        # is set to EXTERNAL (when using the classic Application Load Balancer) and
        # the migration state is TEST_BY_PERCENTAGE.
        # Corresponds to the JSON property `externalManagedMigrationTestingPercentage`
        # @return [Float]
        attr_accessor :external_managed_migration_testing_percentage
      
        # For load balancers that have configurable
        # failover:
        # [Internal passthrough Network Load
        # Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-
        # overview)
        # and [external passthrough
        # Network Load
        # Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-
        # failover-overview).
        # On failover or failback, this field indicates whether connection draining
        # will be honored. Google Cloud has a fixed connection draining timeout of
        # 10 minutes. A setting of true terminates existing TCP
        # connections to the active pool during failover and failback, immediately
        # draining traffic. A setting of false allows existing TCP
        # connections to persist, even on VMs no longer in the active pool, for up
        # to the duration of the connection draining timeout (10 minutes).
        # Corresponds to the JSON property `failoverPolicy`
        # @return [Google::Apis::ComputeV1::BackendServiceFailoverPolicy]
        attr_accessor :failover_policy
      
        # Fingerprint of this resource. A hash of the contents stored in this object.
        # This field is used in optimistic locking. This field will be ignored when
        # inserting a BackendService. An up-to-date fingerprint must be provided in
        # order to update the BackendService, otherwise the request will
        # fail with error 412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to
        # retrieve a BackendService.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # Configures self-managed High Availability (HA) for External and Internal
        # Protocol Forwarding.
        # The backends of this regional backend service must only specify zonal
        # network endpoint groups (NEGs) of type GCE_VM_IP.
        # When haPolicy is set for an Internal Passthrough Network Load Balancer, the
        # regional backend service must set the network field. All zonal NEGs must
        # belong to the same network. However, individual NEGs can
        # belong to different subnetworks of that network.
        # When haPolicy is specified, the set of attached network endpoints across
        # all backends comprise an High Availability domain from which one endpoint
        # is selected as the active endpoint (the leader) that receives all
        # traffic.
        # haPolicy can be added only at backend service creation time. Once set up,
        # it cannot be deleted.
        # Note that haPolicy is not for load balancing, and therefore cannot be
        # specified with sessionAffinity, connectionTrackingPolicy, and
        # failoverPolicy.
        # haPolicy requires customers to be responsible for tracking backend
        # endpoint health and electing a leader among the healthy endpoints.
        # Therefore, haPolicy cannot be specified with healthChecks.
        # haPolicy can only be specified for External Passthrough Network Load
        # Balancers and Internal Passthrough Network Load Balancers.
        # Corresponds to the JSON property `haPolicy`
        # @return [Google::Apis::ComputeV1::BackendServiceHaPolicy]
        attr_accessor :ha_policy
      
        # The list of URLs to the healthChecks, httpHealthChecks (legacy), or
        # httpsHealthChecks (legacy) resource for health checking this backend
        # service. Not all backend services support legacy health checks. See
        # Load balancer guide. Currently, at most one health check can be
        # specified for each backend service. Backend services with
        # instance group or zonal NEG backends must have a health check unless
        # haPolicy is specified. Backend services with internet or serverless NEG
        # backends must not have a health check.
        # healthChecks[] cannot be specified with haPolicy.
        # Corresponds to the JSON property `healthChecks`
        # @return [Array<String>]
        attr_accessor :health_checks
      
        # Identity-Aware Proxy
        # Corresponds to the JSON property `iap`
        # @return [Google::Apis::ComputeV1::BackendServiceIap]
        attr_accessor :iap
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Specifies a preference for traffic sent from the proxy to the backend (or
        # from the client to the backend for proxyless gRPC).
        # The possible values are:
        # 
        # - IPV4_ONLY: Only send IPv4 traffic to the backends of the
        # backend service (Instance Group, Managed Instance Group, Network Endpoint
        # Group), regardless of traffic from the client to the proxy. Only IPv4
        # health checks are used to check the health of the backends. This is the
        # default setting.
        # - PREFER_IPV6: Prioritize the connection to the endpoint's
        # IPv6 address over its IPv4 address (provided there is a healthy IPv6
        # address).
        # - IPV6_ONLY: Only send IPv6 traffic to the backends of the
        # backend service (Instance Group, Managed Instance Group, Network Endpoint
        # Group), regardless of traffic from the client to the proxy. Only IPv6
        # health checks are used to check the health of the backends.
        # This field is applicable to either:
        # 
        # -  Advanced global external Application Load Balancer (load balancing
        # scheme EXTERNAL_MANAGED),
        # -  Regional external Application Load
        # Balancer,
        # -  Internal proxy Network Load Balancer (load balancing
        # scheme INTERNAL_MANAGED),
        # -  Regional internal Application Load
        # Balancer (load balancing scheme INTERNAL_MANAGED),
        # -  Traffic
        # Director with Envoy proxies and proxyless gRPC (load balancing scheme
        # INTERNAL_SELF_MANAGED).
        # Corresponds to the JSON property `ipAddressSelectionPolicy`
        # @return [String]
        attr_accessor :ip_address_selection_policy
      
        # Output only. [Output Only] Type of resource. Always compute#backendService
        # for backend services.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Specifies the load balancer type. A backend service
        # created for one type of load balancer cannot be used with another.
        # For more information, refer toChoosing
        # a load balancer.
        # Corresponds to the JSON property `loadBalancingScheme`
        # @return [String]
        attr_accessor :load_balancing_scheme
      
        # A list of locality load-balancing policies to be used in order of
        # preference. When you use localityLbPolicies, you must set at least one
        # value for either the localityLbPolicies[].policy or the
        # localityLbPolicies[].customPolicy field. localityLbPolicies overrides any
        # value set in the localityLbPolicy field.
        # For an example of how to use this field, seeDefine
        # a list of preferred policies.
        # Caution: This field and its children are intended for use in a service mesh
        # that includes gRPC clients only. Envoy proxies can't use backend services
        # that have this configuration.
        # Corresponds to the JSON property `localityLbPolicies`
        # @return [Array<Google::Apis::ComputeV1::BackendServiceLocalityLoadBalancingPolicyConfig>]
        attr_accessor :locality_lb_policies
      
        # The load balancing algorithm used within the scope of the locality. The
        # possible values are:
        # 
        # - ROUND_ROBIN: This is a simple policy in which each healthy
        # backend is selected in round robin order. This is the default.
        # - LEAST_REQUEST: An O(1) algorithm which
        # selects two random healthy hosts and picks the host which has fewer active
        # requests.
        # - RING_HASH: The ring/modulo hash load balancer implements
        # consistent hashing to backends. The algorithm has the property that the
        # addition/removal of a host from a set of N hosts only affects 1/N of the
        # requests.
        # - RANDOM: The load balancer selects a random healthy
        # host.
        # - ORIGINAL_DESTINATION: Backend host is selected
        # based on the client connection metadata, i.e., connections are opened to
        # the same address as the destination address of the incoming connection
        # before the connection was redirected to the load balancer.
        # - MAGLEV: used as a drop in replacement for the ring hash
        # load balancer. Maglev is not as stable as ring hash but has faster table
        # lookup build times and host selection times. For more information about
        # Maglev, see Maglev:
        # A Fast and Reliable Software Network Load Balancer.
        # - WEIGHTED_ROUND_ROBIN: Per-endpoint Weighted Round Robin
        # Load Balancing using weights computed from Backend reported Custom Metrics.
        # If set, the Backend Service responses are expected to contain non-standard
        # HTTP response header field Endpoint-Load-Metrics. The reported
        # metrics to use for computing the weights are specified via thecustomMetrics
        # field.
        # 
        # This field is applicable to either:
        # - A regional backend service with the service_protocol set to HTTP,
        # HTTPS, HTTP2 or H2C, and load_balancing_scheme set to
        # INTERNAL_MANAGED.
        # - A global backend service with the
        # load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or
        # EXTERNAL_MANAGED.
        # 
        # 
        # If sessionAffinity is not configured—that is, if session
        # affinity remains at the default value of NONE—then the
        # default value for localityLbPolicy
        # is ROUND_ROBIN. If session affinity is set to a value other
        # than NONE,
        # then the default value for localityLbPolicy isMAGLEV.
        # 
        # Only ROUND_ROBIN and RING_HASH are supported
        # when the backend service is referenced by a URL map that is bound to
        # target gRPC proxy that has validateForProxyless field set to true.
        # 
        # localityLbPolicy cannot be specified with haPolicy.
        # Corresponds to the JSON property `localityLbPolicy`
        # @return [String]
        attr_accessor :locality_lb_policy
      
        # The available logging options for the load balancer traffic served by this
        # backend service.
        # Corresponds to the JSON property `logConfig`
        # @return [Google::Apis::ComputeV1::BackendServiceLogConfig]
        attr_accessor :log_config
      
        # A Duration represents a fixed-length span of time represented
        # as a count of seconds and fractions of seconds at nanosecond
        # resolution. It is independent of any calendar and concepts like "day"
        # or "month". Range is approximately 10,000 years.
        # Corresponds to the JSON property `maxStreamDuration`
        # @return [Google::Apis::ComputeV1::Duration]
        attr_accessor :max_stream_duration
      
        # Deployment metadata associated with the resource to be set by a GKE hub
        # controller and read by the backend RCTH
        # Corresponds to the JSON property `metadatas`
        # @return [Hash<String,String>]
        attr_accessor :metadatas
      
        # Name of the resource. Provided by the client when the resource is created.
        # The name must be 1-63 characters long, and comply withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must
        # be a dash, lowercase letter, or digit, except the last character, which
        # cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The URL of the network to which this backend service belongs.
        # This field must be set for Internal Passthrough Network Load Balancers when
        # the haPolicy is enabled, and for External Passthrough Network Load
        # Balancers when the haPolicy fastIpMove is enabled.
        # This field can only be specified when the load balancing scheme is set
        # toINTERNAL, or when the load balancing scheme is set toEXTERNAL and haPolicy
        # fastIpMove is enabled.
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # Configures traffic steering properties of internal passthrough Network
        # Load Balancers.
        # networkPassThroughLbTrafficPolicy cannot be specified with haPolicy.
        # Corresponds to the JSON property `networkPassThroughLbTrafficPolicy`
        # @return [Google::Apis::ComputeV1::BackendServiceNetworkPassThroughLbTrafficPolicy]
        attr_accessor :network_pass_through_lb_traffic_policy
      
        # Settings controlling the eviction of unhealthy hosts from the load balancing
        # pool for the backend service.
        # Corresponds to the JSON property `outlierDetection`
        # @return [Google::Apis::ComputeV1::OutlierDetection]
        attr_accessor :outlier_detection
      
        # Additional Backend Service parameters.
        # Corresponds to the JSON property `params`
        # @return [Google::Apis::ComputeV1::BackendServiceParams]
        attr_accessor :params
      
        # Deprecated in favor of portName. The TCP port to connect on
        # the backend. The default value is 80.
        # For internal passthrough Network Load Balancers and external passthrough
        # Network Load Balancers, omit port.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        # A named port on a backend instance group representing the port for
        # communication to the backend VMs in that group. The
        # named port must be [defined on each backend instance
        # group](https://cloud.google.com/load-balancing/docs/backend-service#
        # named_ports).
        # This parameter has no meaning if the backends are NEGs. For internal
        # passthrough Network Load Balancers and external passthrough Network Load
        # Balancers, omit port_name.
        # Corresponds to the JSON property `portName`
        # @return [String]
        attr_accessor :port_name
      
        # The protocol this BackendService uses to communicate
        # with backends.
        # Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP or GRPC.
        # depending on the chosen load balancer or Traffic Director configuration.
        # Refer to the documentation for the load balancers or for Traffic Director
        # for more information.
        # Must be set to GRPC when the backend service is referenced by a URL map
        # that is bound to target gRPC proxy.
        # Corresponds to the JSON property `protocol`
        # @return [String]
        attr_accessor :protocol
      
        # Output only. [Output Only] URL of the region where the regional backend
        # service
        # resides. This field is not applicable to global backend services.
        # You must specify this field as part of the HTTP request URL. It is
        # not settable as a field in the request body.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] The resource URL for the security policy associated with this
        # backend service.
        # Corresponds to the JSON property `securityPolicy`
        # @return [String]
        attr_accessor :security_policy
      
        # The authentication and authorization settings for a BackendService.
        # Corresponds to the JSON property `securitySettings`
        # @return [Google::Apis::ComputeV1::SecuritySettings]
        attr_accessor :security_settings
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # URLs of networkservices.ServiceBinding resources.
        # Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED.
        # If set, lists of backends and health checks must be both empty.
        # Corresponds to the JSON property `serviceBindings`
        # @return [Array<String>]
        attr_accessor :service_bindings
      
        # URL to networkservices.ServiceLbPolicy resource.
        # Can only be set if load balancing scheme is EXTERNAL_MANAGED,
        # INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
        # Corresponds to the JSON property `serviceLbPolicy`
        # @return [String]
        attr_accessor :service_lb_policy
      
        # Type of session affinity to use. The default is NONE.
        # Only NONE and HEADER_FIELD are supported
        # when the backend service is referenced by a URL map that is bound to
        # target gRPC proxy that has validateForProxyless field set to true.
        # For more details, see:
        # [Session
        # Affinity](https://cloud.google.com/load-balancing/docs/backend-service#
        # session_affinity).
        # sessionAffinity cannot be specified with haPolicy.
        # Corresponds to the JSON property `sessionAffinity`
        # @return [String]
        attr_accessor :session_affinity
      
        # The HTTP cookie used for stateful session affinity.
        # Corresponds to the JSON property `strongSessionAffinityCookie`
        # @return [Google::Apis::ComputeV1::BackendServiceHttpCookie]
        attr_accessor :strong_session_affinity_cookie
      
        # Subsetting configuration for this BackendService.
        # Currently this is applicable only for Internal TCP/UDP load balancing,
        # Internal HTTP(S) load balancing and Traffic Director.
        # Corresponds to the JSON property `subsetting`
        # @return [Google::Apis::ComputeV1::Subsetting]
        attr_accessor :subsetting
      
        # The backend service timeout has a different meaning depending on the
        # type of load balancer. For more information see,
        # Backend service settings.
        # The default is 30 seconds.
        # The full range of timeout values allowed goes from 1
        # through 2,147,483,647 seconds.
        # This value can be overridden in the PathMatcher configuration of the
        # UrlMap that references this backend service.
        # Not supported when the backend service is referenced by a URL map that is
        # bound to target gRPC proxy that has validateForProxyless field set to true.
        # Instead, use maxStreamDuration.
        # Corresponds to the JSON property `timeoutSec`
        # @return [Fixnum]
        attr_accessor :timeout_sec
      
        # Configuration for Backend Authenticated TLS and mTLS. May only be specified
        # when the backend protocol is SSL, HTTPS or HTTP2.
        # Corresponds to the JSON property `tlsSettings`
        # @return [Google::Apis::ComputeV1::BackendServiceTlsSettings]
        attr_accessor :tls_settings
      
        # Output only. [Output Only] List of resources referencing given backend service.
        # Corresponds to the JSON property `usedBy`
        # @return [Array<Google::Apis::ComputeV1::BackendServiceUsedBy>]
        attr_accessor :used_by
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @affinity_cookie_ttl_sec = args[:affinity_cookie_ttl_sec] if args.key?(:affinity_cookie_ttl_sec)
          @backends = args[:backends] if args.key?(:backends)
          @cdn_policy = args[:cdn_policy] if args.key?(:cdn_policy)
          @circuit_breakers = args[:circuit_breakers] if args.key?(:circuit_breakers)
          @compression_mode = args[:compression_mode] if args.key?(:compression_mode)
          @connection_draining = args[:connection_draining] if args.key?(:connection_draining)
          @connection_tracking_policy = args[:connection_tracking_policy] if args.key?(:connection_tracking_policy)
          @consistent_hash = args[:consistent_hash] if args.key?(:consistent_hash)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @custom_metrics = args[:custom_metrics] if args.key?(:custom_metrics)
          @custom_request_headers = args[:custom_request_headers] if args.key?(:custom_request_headers)
          @custom_response_headers = args[:custom_response_headers] if args.key?(:custom_response_headers)
          @description = args[:description] if args.key?(:description)
          @edge_security_policy = args[:edge_security_policy] if args.key?(:edge_security_policy)
          @enable_cdn = args[:enable_cdn] if args.key?(:enable_cdn)
          @external_managed_migration_state = args[:external_managed_migration_state] if args.key?(:external_managed_migration_state)
          @external_managed_migration_testing_percentage = args[:external_managed_migration_testing_percentage] if args.key?(:external_managed_migration_testing_percentage)
          @failover_policy = args[:failover_policy] if args.key?(:failover_policy)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @ha_policy = args[:ha_policy] if args.key?(:ha_policy)
          @health_checks = args[:health_checks] if args.key?(:health_checks)
          @iap = args[:iap] if args.key?(:iap)
          @id = args[:id] if args.key?(:id)
          @ip_address_selection_policy = args[:ip_address_selection_policy] if args.key?(:ip_address_selection_policy)
          @kind = args[:kind] if args.key?(:kind)
          @load_balancing_scheme = args[:load_balancing_scheme] if args.key?(:load_balancing_scheme)
          @locality_lb_policies = args[:locality_lb_policies] if args.key?(:locality_lb_policies)
          @locality_lb_policy = args[:locality_lb_policy] if args.key?(:locality_lb_policy)
          @log_config = args[:log_config] if args.key?(:log_config)
          @max_stream_duration = args[:max_stream_duration] if args.key?(:max_stream_duration)
          @metadatas = args[:metadatas] if args.key?(:metadatas)
          @name = args[:name] if args.key?(:name)
          @network = args[:network] if args.key?(:network)
          @network_pass_through_lb_traffic_policy = args[:network_pass_through_lb_traffic_policy] if args.key?(:network_pass_through_lb_traffic_policy)
          @outlier_detection = args[:outlier_detection] if args.key?(:outlier_detection)
          @params = args[:params] if args.key?(:params)
          @port = args[:port] if args.key?(:port)
          @port_name = args[:port_name] if args.key?(:port_name)
          @protocol = args[:protocol] if args.key?(:protocol)
          @region = args[:region] if args.key?(:region)
          @security_policy = args[:security_policy] if args.key?(:security_policy)
          @security_settings = args[:security_settings] if args.key?(:security_settings)
          @self_link = args[:self_link] if args.key?(:self_link)
          @service_bindings = args[:service_bindings] if args.key?(:service_bindings)
          @service_lb_policy = args[:service_lb_policy] if args.key?(:service_lb_policy)
          @session_affinity = args[:session_affinity] if args.key?(:session_affinity)
          @strong_session_affinity_cookie = args[:strong_session_affinity_cookie] if args.key?(:strong_session_affinity_cookie)
          @subsetting = args[:subsetting] if args.key?(:subsetting)
          @timeout_sec = args[:timeout_sec] if args.key?(:timeout_sec)
          @tls_settings = args[:tls_settings] if args.key?(:tls_settings)
          @used_by = args[:used_by] if args.key?(:used_by)
        end
      end
      
      # Contains a list of BackendServicesScopedList.
      class BackendServiceAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of BackendServicesScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeV1::BackendServicesScopedList>]
        attr_accessor :items
      
        # Output only. Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Unreachable resources.
        # Corresponds to the JSON property `unreachables`
        # @return [Array<String>]
        attr_accessor :unreachables
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::BackendServiceAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @unreachables = args[:unreachables] if args.key?(:unreachables)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::BackendServiceAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Message containing Cloud CDN configuration for a backend service.
      class BackendServiceCdnPolicy
        include Google::Apis::Core::Hashable
      
        # Bypass the cache when the specified request headers are matched - e.g.
        # Pragma or Authorization headers. Up to 5 headers can be specified.
        # The cache is bypassed for all cdnPolicy.cacheMode settings.
        # Corresponds to the JSON property `bypassCacheOnRequestHeaders`
        # @return [Array<Google::Apis::ComputeV1::BackendServiceCdnPolicyBypassCacheOnRequestHeader>]
        attr_accessor :bypass_cache_on_request_headers
      
        # Message containing what to include in the cache key for a request for Cloud
        # CDN.
        # Corresponds to the JSON property `cacheKeyPolicy`
        # @return [Google::Apis::ComputeV1::CacheKeyPolicy]
        attr_accessor :cache_key_policy
      
        # Specifies the cache setting for all responses from this backend.
        # The possible values are:USE_ORIGIN_HEADERS Requires the origin to set valid
        # caching
        # headers to cache content. Responses without these headers will not be
        # cached at Google's edge, and will require a full trip to the origin on
        # every request, potentially impacting performance and increasing load on
        # the origin server.FORCE_CACHE_ALL Cache all content, ignoring any "private",
        # "no-store" or "no-cache" directives in Cache-Control response headers.
        # Warning: this may result in Cloud CDN caching private,
        # per-user (user identifiable) content.CACHE_ALL_STATIC Automatically cache
        # static content,
        # including common image formats, media (video and audio), and web assets
        # (JavaScript and CSS). Requests and responses that are marked as
        # uncacheable, as well as dynamic content (including HTML), will not be
        # cached.
        # If no value is provided for cdnPolicy.cacheMode, it defaults
        # to CACHE_ALL_STATIC.
        # Corresponds to the JSON property `cacheMode`
        # @return [String]
        attr_accessor :cache_mode
      
        # Specifies a separate client (e.g. browser client) maximum TTL. This is
        # used to clamp the max-age (or Expires) value sent to the client.  With
        # FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the
        # response max-age directive, along with a "public" directive.  For
        # cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age
        # from the origin (if specified), or else sets the response max-age
        # directive to the lesser of the client_ttl and default_ttl, and also
        # ensures a "public" cache-control directive is present.
        # If a client TTL is not specified, a default value (1 hour) will be used.
        # The maximum allowed value is 31,622,400s (1 year).
        # Corresponds to the JSON property `clientTtl`
        # @return [Fixnum]
        attr_accessor :client_ttl
      
        # Specifies the default TTL for cached content served by this origin for
        # responses that do not have an existing valid TTL (max-age or s-maxage).
        # Setting a TTL of "0" means "always revalidate".
        # The value of defaultTTL cannot be set to a value greater than that of
        # maxTTL, but can be equal.
        # When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL
        # will overwrite the TTL set in all responses. The maximum allowed value is
        # 31,622,400s (1 year), noting that infrequently accessed objects may be
        # evicted from the cache before the defined TTL.
        # Corresponds to the JSON property `defaultTtl`
        # @return [Fixnum]
        attr_accessor :default_ttl
      
        # Specifies the maximum allowed TTL for cached content served by this
        # origin.
        # Cache directives that attempt to set a max-age or s-maxage higher than
        # this, or an Expires header more than maxTTL seconds in the future will
        # be capped at the value of maxTTL, as if it were the value of an
        # s-maxage Cache-Control directive.
        # Headers sent to the client will not be modified.
        # Setting a TTL of "0" means "always revalidate".
        # The maximum allowed value is 31,622,400s (1 year), noting that
        # infrequently accessed objects may be evicted from the cache before
        # the defined TTL.
        # Corresponds to the JSON property `maxTtl`
        # @return [Fixnum]
        attr_accessor :max_ttl
      
        # Negative caching allows per-status code TTLs to be set, in order
        # to apply fine-grained caching for common errors or redirects.
        # This can reduce the load on your origin and improve end-user
        # experience by reducing response latency.
        # When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS,
        # negative caching applies to responses with the specified response code
        # that lack any Cache-Control, Expires, or Pragma: no-cache directives.
        # When the cache mode is set to FORCE_CACHE_ALL, negative caching applies
        # to all responses with the specified response code, and override any
        # caching headers.
        # By default, Cloud CDN will apply the following default TTLs to these
        # status codes:
        # HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
        # HTTP 404 (Not Found), 410 (Gone),
        # 451 (Unavailable For Legal Reasons): 120s
        # HTTP 405 (Method Not Found), 501 (Not Implemented): 60s.
        # These defaults can be overridden in negative_caching_policy.
        # Corresponds to the JSON property `negativeCaching`
        # @return [Boolean]
        attr_accessor :negative_caching
        alias_method :negative_caching?, :negative_caching
      
        # Sets a cache TTL for the specified HTTP status code.
        # negative_caching must be enabled to configure negative_caching_policy.
        # Omitting the policy and leaving negative_caching enabled will use
        # Cloud CDN's default cache TTLs.
        # Note that when specifying an explicit negative_caching_policy, you
        # should take care to specify a cache TTL for all response codes
        # that you wish to cache. Cloud CDN will not apply any default
        # negative caching when a policy exists.
        # Corresponds to the JSON property `negativeCachingPolicy`
        # @return [Array<Google::Apis::ComputeV1::BackendServiceCdnPolicyNegativeCachingPolicy>]
        attr_accessor :negative_caching_policy
      
        # If true then Cloud CDN will combine multiple concurrent cache fill
        # requests into a small number of requests to the origin.
        # Corresponds to the JSON property `requestCoalescing`
        # @return [Boolean]
        attr_accessor :request_coalescing
        alias_method :request_coalescing?, :request_coalescing
      
        # Serve existing content from the cache (if available) when revalidating
        # content with the origin, or when an error is encountered when refreshing
        # the cache.
        # This setting defines the default "max-stale" duration for any cached
        # responses that do not specify a max-stale directive. Stale responses that
        # exceed the TTL configured here will not be served. The default limit
        # (max-stale) is 86400s (1 day), which will allow stale content to be
        # served up to this limit beyond the max-age (or s-maxage) of a cached
        # response.
        # The maximum allowed value is 604800 (1 week).
        # Set this to zero (0) to disable serve-while-stale.
        # Corresponds to the JSON property `serveWhileStale`
        # @return [Fixnum]
        attr_accessor :serve_while_stale
      
        # Maximum number of seconds the response to a signed URL request will be
        # considered fresh. After this time period, the response will be
        # revalidated before being served. Defaults to 1hr (3600s).  When serving
        # responses to signed URL requests, Cloud CDN will internally behave as
        # though all responses from this backend had a "Cache-Control:
        # public, max-age=[TTL]" header, regardless of any existing
        # Cache-Control header. The actual headers served in responses will not be
        # altered.
        # Corresponds to the JSON property `signedUrlCacheMaxAgeSec`
        # @return [Fixnum]
        attr_accessor :signed_url_cache_max_age_sec
      
        # [Output Only] Names of the keys for signing request URLs.
        # Corresponds to the JSON property `signedUrlKeyNames`
        # @return [Array<String>]
        attr_accessor :signed_url_key_names
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @bypass_cache_on_request_headers = args[:bypass_cache_on_request_headers] if args.key?(:bypass_cache_on_request_headers)
          @cache_key_policy = args[:cache_key_policy] if args.key?(:cache_key_policy)
          @cache_mode = args[:cache_mode] if args.key?(:cache_mode)
          @client_ttl = args[:client_ttl] if args.key?(:client_ttl)
          @default_ttl = args[:default_ttl] if args.key?(:default_ttl)
          @max_ttl = args[:max_ttl] if args.key?(:max_ttl)
          @negative_caching = args[:negative_caching] if args.key?(:negative_caching)
          @negative_caching_policy = args[:negative_caching_policy] if args.key?(:negative_caching_policy)
          @request_coalescing = args[:request_coalescing] if args.key?(:request_coalescing)
          @serve_while_stale = args[:serve_while_stale] if args.key?(:serve_while_stale)
          @signed_url_cache_max_age_sec = args[:signed_url_cache_max_age_sec] if args.key?(:signed_url_cache_max_age_sec)
          @signed_url_key_names = args[:signed_url_key_names] if args.key?(:signed_url_key_names)
        end
      end
      
      # Bypass the cache when the specified request headers are present,
      # e.g. Pragma or Authorization headers. Values are case insensitive.
      # The presence of such a header overrides the cache_mode setting.
      class BackendServiceCdnPolicyBypassCacheOnRequestHeader
        include Google::Apis::Core::Hashable
      
        # The header field name to match on when bypassing cache.
        # Values are case-insensitive.
        # Corresponds to the JSON property `headerName`
        # @return [String]
        attr_accessor :header_name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @header_name = args[:header_name] if args.key?(:header_name)
        end
      end
      
      # Specify CDN TTLs for response error codes.
      class BackendServiceCdnPolicyNegativeCachingPolicy
        include Google::Apis::Core::Hashable
      
        # The HTTP status code to define a TTL against. Only HTTP status codes
        # 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 can be
        # specified as values, and you cannot specify a status code more than
        # once.
        # Corresponds to the JSON property `code`
        # @return [Fixnum]
        attr_accessor :code
      
        # The TTL (in seconds) for which to cache responses with the
        # corresponding status code.
        # The maximum allowed value is 1800s (30 minutes), noting that
        # infrequently accessed objects may be evicted from the cache before the
        # defined TTL.
        # Corresponds to the JSON property `ttl`
        # @return [Fixnum]
        attr_accessor :ttl
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @code = args[:code] if args.key?(:code)
          @ttl = args[:ttl] if args.key?(:ttl)
        end
      end
      
      # Connection Tracking configuration for this BackendService.
      class BackendServiceConnectionTrackingPolicy
        include Google::Apis::Core::Hashable
      
        # Specifies connection persistence when backends are unhealthy. The default
        # value is DEFAULT_FOR_PROTOCOL.
        # If set to DEFAULT_FOR_PROTOCOL, the existing connections
        # persist on unhealthy backends only for connection-oriented protocols
        # (TCP and SCTP) and only if the Tracking Mode isPER_CONNECTION (default
        # tracking mode) or the Session
        # Affinity is configured for 5-tuple. They do not persist forUDP.
        # If set to NEVER_PERSIST, after a backend becomes unhealthy,
        # the existing connections on the unhealthy backend are never persisted on
        # the unhealthy backend. They are always diverted to newly selected healthy
        # backends (unless all backends are unhealthy).
        # If set to ALWAYS_PERSIST, existing connections always
        # persist on unhealthy backends regardless of protocol and session
        # affinity. It is generally not recommended to use this mode overriding the
        # default.
        # For more details, see [Connection Persistence for Network Load
        # Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-
        # backend-service#connection-persistence)
        # and [Connection Persistence for Internal TCP/UDP Load
        # Balancing](https://cloud.google.com/load-balancing/docs/internal#connection-
        # persistence).
        # Corresponds to the JSON property `connectionPersistenceOnUnhealthyBackends`
        # @return [String]
        attr_accessor :connection_persistence_on_unhealthy_backends
      
        # Enable Strong Session Affinity for external passthrough Network Load
        # Balancers. This option is not available publicly.
        # Corresponds to the JSON property `enableStrongAffinity`
        # @return [Boolean]
        attr_accessor :enable_strong_affinity
        alias_method :enable_strong_affinity?, :enable_strong_affinity
      
        # Specifies how long to keep a Connection Tracking entry while there is no
        # matching traffic (in seconds).
        # For internal passthrough Network Load Balancers:
        # 
        # - The minimum (default) is 10 minutes and the maximum is 16 hours.
        # - It can be set only if Connection Tracking is less than 5-tuple
        # (i.e. Session Affinity is CLIENT_IP_NO_DESTINATION,CLIENT_IP or
        # CLIENT_IP_PROTO, and Tracking
        # Mode is PER_SESSION).
        # For external passthrough Network Load Balancers the default is 60
        # seconds. This option is not available publicly.
        # Corresponds to the JSON property `idleTimeoutSec`
        # @return [Fixnum]
        attr_accessor :idle_timeout_sec
      
        # Specifies the key used for connection tracking. There are two
        # options:
        # 
        # - PER_CONNECTION: This is the default mode. The Connection
        # Tracking is performed as per the Connection Key (default Hash Method) for
        # the specific protocol.
        # - PER_SESSION: The Connection Tracking is performed as per
        # the configured Session Affinity. It matches the configured Session
        # Affinity.
        # For more details, see [Tracking Mode for Network Load
        # Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-
        # backend-service#tracking-mode)
        # and [Tracking Mode for Internal TCP/UDP Load
        # Balancing](https://cloud.google.com/load-balancing/docs/internal#tracking-mode)
        # .
        # Corresponds to the JSON property `trackingMode`
        # @return [String]
        attr_accessor :tracking_mode
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @connection_persistence_on_unhealthy_backends = args[:connection_persistence_on_unhealthy_backends] if args.key?(:connection_persistence_on_unhealthy_backends)
          @enable_strong_affinity = args[:enable_strong_affinity] if args.key?(:enable_strong_affinity)
          @idle_timeout_sec = args[:idle_timeout_sec] if args.key?(:idle_timeout_sec)
          @tracking_mode = args[:tracking_mode] if args.key?(:tracking_mode)
        end
      end
      
      # Custom Metrics are used for WEIGHTED_ROUND_ROBIN
      # locality_lb_policy.
      class BackendServiceCustomMetric
        include Google::Apis::Core::Hashable
      
        # If true, the metric data is not used for load balancing.
        # Corresponds to the JSON property `dryRun`
        # @return [Boolean]
        attr_accessor :dry_run
        alias_method :dry_run?, :dry_run
      
        # Name of a custom utilization signal. The name must be 1-64 characters
        # long and match the regular expression
        # `[a-z]([-_.a-z0-9]*[a-z0-9])?` which means that the
        # first character must be a lowercase letter, and all following
        # characters must be a dash, period, underscore, lowercase letter, or
        # digit, except the last character, which cannot be a dash, period, or
        # underscore. For usage guidelines, see Custom Metrics balancing mode. This
        # field can only be used for a global or regional backend service with the
        # loadBalancingScheme set to EXTERNAL_MANAGED,INTERNAL_MANAGED
        # INTERNAL_SELF_MANAGED.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @dry_run = args[:dry_run] if args.key?(:dry_run)
          @name = args[:name] if args.key?(:name)
        end
      end
      
      # For load balancers that have configurable
      # failover:
      # [Internal passthrough Network Load
      # Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-
      # overview)
      # and [external passthrough
      # Network Load
      # Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-
      # failover-overview).
      # On failover or failback, this field indicates whether connection draining
      # will be honored. Google Cloud has a fixed connection draining timeout of
      # 10 minutes. A setting of true terminates existing TCP
      # connections to the active pool during failover and failback, immediately
      # draining traffic. A setting of false allows existing TCP
      # connections to persist, even on VMs no longer in the active pool, for up
      # to the duration of the connection draining timeout (10 minutes).
      class BackendServiceFailoverPolicy
        include Google::Apis::Core::Hashable
      
        # This can be set to true only if the protocol isTCP.
        # The default is false.
        # Corresponds to the JSON property `disableConnectionDrainOnFailover`
        # @return [Boolean]
        attr_accessor :disable_connection_drain_on_failover
        alias_method :disable_connection_drain_on_failover?, :disable_connection_drain_on_failover
      
        # If set to true, connections to the
        # load balancer are dropped when all primary and all backup backend VMs are
        # unhealthy.If set to false, connections are distributed
        # among all primary VMs when all primary and all backup backend VMs are
        # unhealthy.
        # For load balancers that have configurable
        # failover:
        # [Internal passthrough
        # Network Load
        # Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-
        # overview)
        # and [external passthrough
        # Network Load
        # Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-
        # failover-overview).
        # The default is false.
        # Corresponds to the JSON property `dropTrafficIfUnhealthy`
        # @return [Boolean]
        attr_accessor :drop_traffic_if_unhealthy
        alias_method :drop_traffic_if_unhealthy?, :drop_traffic_if_unhealthy
      
        # The value of the field must be in the range[0, 1]. If the value is 0, the load
        # balancer performs a
        # failover when the number of healthy primary VMs equals zero.
        # For all other values, the load balancer performs a failover when the
        # total number of healthy primary VMs is less than this ratio.
        # For load balancers that have configurable
        # failover:
        # [Internal TCP/UDP Load
        # Balancing](https://cloud.google.com/load-balancing/docs/internal/failover-
        # overview)
        # and [external TCP/UDP Load
        # Balancing](https://cloud.google.com/load-balancing/docs/network/networklb-
        # failover-overview).
        # Corresponds to the JSON property `failoverRatio`
        # @return [Float]
        attr_accessor :failover_ratio
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @disable_connection_drain_on_failover = args[:disable_connection_drain_on_failover] if args.key?(:disable_connection_drain_on_failover)
          @drop_traffic_if_unhealthy = args[:drop_traffic_if_unhealthy] if args.key?(:drop_traffic_if_unhealthy)
          @failover_ratio = args[:failover_ratio] if args.key?(:failover_ratio)
        end
      end
      
      # 
      class BackendServiceGroupHealth
        include Google::Apis::Core::Hashable
      
        # Metadata defined as annotations on the network endpoint group.
        # Corresponds to the JSON property `annotations`
        # @return [Hash<String,String>]
        attr_accessor :annotations
      
        # Health state of the backend instances or endpoints in requested instance or
        # network endpoint group, determined based on configured health checks.
        # Corresponds to the JSON property `healthStatus`
        # @return [Array<Google::Apis::ComputeV1::HealthStatus>]
        attr_accessor :health_status
      
        # Output only. [Output Only] Type of resource. Alwayscompute#
        # backendServiceGroupHealth for the health of backend
        # services.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @annotations = args[:annotations] if args.key?(:annotations)
          @health_status = args[:health_status] if args.key?(:health_status)
          @kind = args[:kind] if args.key?(:kind)
        end
      end
      
      # 
      class BackendServiceHaPolicy
        include Google::Apis::Core::Hashable
      
        # Specifies whether fast IP move is enabled, and if so, the mechanism to
        # achieve it.
        # Supported values are:
        # 
        # - DISABLED: Fast IP Move is disabled. You can only use the
        # haPolicy.leader API to update the leader.
        # - >GARP_RA: Provides a method to very quickly define a new network
        # endpoint as the leader. This method is faster than updating the leader
        # using the haPolicy.leader API. Fast IP move works as follows: The VM
        # hosting the network endpoint that should become the new leader sends
        # either a Gratuitous ARP (GARP) packet (IPv4) or an ICMPv6 Router
        # Advertisement(RA) packet (IPv6).  Google Cloud immediately but
        # temporarily associates the forwarding rule IP address with that VM, and
        # both new and in-flight packets are quickly delivered to that VM.
        # Note the important properties of the Fast IP Move functionality:
        # 
        # - The GARP/RA-initiated re-routing stays active for approximately 20
        # minutes. After triggering fast failover, you must also
        # appropriately set the haPolicy.leader.
        # -  The new leader instance should continue to send GARP/RA packets
        # periodically every 10 seconds until at least 10 minutes after updating
        # the haPolicy.leader (but stop immediately if it is no longer the leader).
        # - After triggering a fast failover, we recommend that you wait at least
        # 3 seconds before sending another GARP/RA packet from a different VM
        # instance to avoid race conditions.
        # - Don't send GARP/RA packets from different VM
        # instances at the same time. If multiple instances continue to send
        # GARP/RA packets, traffic might be routed to different destinations in an
        # alternating order. This condition ceases when a single instance
        # issues a GARP/RA packet.
        # - The GARP/RA request always takes priority over the leader API.
        # Using the haPolicy.leader API to change the leader to a different
        # instance will have no effect until the GARP/RA request becomes
        # inactive.
        # - The GARP/RA packets should follow the GARP/RA
        # Packet Specifications..
        # -  When multiple forwarding rules refer to a regional backend service,
        # you need only send a GARP or RA packet for a single forwarding rule
        # virtual IP. The virtual IPs for all forwarding rules targeting the same
        # backend service will also be moved to the sender of the GARP or RA
        # packet.
        # The following are the Fast IP Move limitations (that is, when fastIPMove
        # is not DISABLED):
        # 
        # - Multiple forwarding rules cannot use the same IP address if one of
        # them refers to a regional backend service with fastIPMove.
        # - The regional backend service must set the network field, and all
        # NEGs must belong to that network. However, individual
        # NEGs can belong to different subnetworks of that network.
        # - The maximum number of network endpoints across all backends of a
        # backend service with fastIPMove is 32.
        # - The maximum number of backend services with fastIPMove that can have
        # the same network endpoint attached to one of its backends is 64.
        # - The maximum number of backend services with fastIPMove in a VPC in a
        # region is 64.
        # - The network endpoints that are attached to a backend of a backend
        # service with fastIPMove cannot resolve to Gen3+ machines for IPv6.
        # - Traffic directed to the leader by a static route next hop will not be
        # redirected to a new leader by fast failover. Such traffic will only be
        # redirected once an haPolicy.leader update has taken effect. Only traffic
        # to the forwarding rule's virtual IP will be redirected to a new leader by
        # fast failover.
        # haPolicy.fastIPMove can be set only at backend service creation time.
        # Once set, it cannot be updated.
        # By default, fastIpMove is set to DISABLED.
        # Corresponds to the JSON property `fastIPMove`
        # @return [String]
        attr_accessor :fast_ip_move
      
        # Selects one of the network endpoints attached to the backend NEGs of
        # this service as the active endpoint (the leader) that receives all
        # traffic.
        # When the leader changes, there is no connection draining to persist
        # existing connections on the old leader.
        # You are responsible for selecting a suitable endpoint as the
        # leader. For example, preferring a healthy endpoint over unhealthy ones.
        # Note that this service does not track backend endpoint health, and
        # selects the configured leader unconditionally.
        # Corresponds to the JSON property `leader`
        # @return [Google::Apis::ComputeV1::BackendServiceHaPolicyLeader]
        attr_accessor :leader
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @fast_ip_move = args[:fast_ip_move] if args.key?(:fast_ip_move)
          @leader = args[:leader] if args.key?(:leader)
        end
      end
      
      # 
      class BackendServiceHaPolicyLeader
        include Google::Apis::Core::Hashable
      
        # A fully-qualified URL (starting with https://www.googleapis.com/)
        # of the zonal Network Endpoint Group (NEG) with `GCE_VM_IP` endpoints
        # that the leader is attached to.
        # The leader's backendGroup must already be specified as a backend of
        # this backend service. Removing a backend that is designated as the
        # leader's backendGroup is not permitted.
        # Corresponds to the JSON property `backendGroup`
        # @return [String]
        attr_accessor :backend_group
      
        # The network endpoint within the leader.backendGroup that is
        # designated as the leader.
        # This network endpoint cannot be detached from the NEG specified in
        # the haPolicy.leader.backendGroup until the leader is updated with
        # another network endpoint, or the leader is removed from the haPolicy.
        # Corresponds to the JSON property `networkEndpoint`
        # @return [Google::Apis::ComputeV1::BackendServiceHaPolicyLeaderNetworkEndpoint]
        attr_accessor :network_endpoint
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @backend_group = args[:backend_group] if args.key?(:backend_group)
          @network_endpoint = args[:network_endpoint] if args.key?(:network_endpoint)
        end
      end
      
      # 
      class BackendServiceHaPolicyLeaderNetworkEndpoint
        include Google::Apis::Core::Hashable
      
        # The name of the VM instance of the leader network endpoint. The
        # instance must already be attached to the NEG specified in the
        # haPolicy.leader.backendGroup.
        # The name must be 1-63 characters long, and comply with RFC1035.
        # Authorization requires the following IAM permission on the
        # specified resource instance: compute.instances.use
        # Corresponds to the JSON property `instance`
        # @return [String]
        attr_accessor :instance
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance = args[:instance] if args.key?(:instance)
        end
      end
      
      # The HTTP cookie used for stateful session affinity.
      class BackendServiceHttpCookie
        include Google::Apis::Core::Hashable
      
        # Name of the cookie.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Path to set for the cookie.
        # Corresponds to the JSON property `path`
        # @return [String]
        attr_accessor :path
      
        # A Duration represents a fixed-length span of time represented
        # as a count of seconds and fractions of seconds at nanosecond
        # resolution. It is independent of any calendar and concepts like "day"
        # or "month". Range is approximately 10,000 years.
        # Corresponds to the JSON property `ttl`
        # @return [Google::Apis::ComputeV1::Duration]
        attr_accessor :ttl
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @name = args[:name] if args.key?(:name)
          @path = args[:path] if args.key?(:path)
          @ttl = args[:ttl] if args.key?(:ttl)
        end
      end
      
      # Identity-Aware Proxy
      class BackendServiceIap
        include Google::Apis::Core::Hashable
      
        # Whether the serving infrastructure will authenticate and authorize all
        # incoming requests.
        # Corresponds to the JSON property `enabled`
        # @return [Boolean]
        attr_accessor :enabled
        alias_method :enabled?, :enabled
      
        # OAuth2 client ID to use for the authentication flow.
        # Corresponds to the JSON property `oauth2ClientId`
        # @return [String]
        attr_accessor :oauth2_client_id
      
        # OAuth2 client secret to use for the authentication flow.
        # For security reasons, this value cannot be retrieved via the API.
        # Instead, the SHA-256 hash of the value is returned in the
        # oauth2ClientSecretSha256 field.
        # @InputOnly
        # Corresponds to the JSON property `oauth2ClientSecret`
        # @return [String]
        attr_accessor :oauth2_client_secret
      
        # Output only. [Output Only] SHA256 hash value for the field
        # oauth2_client_secret above.
        # Corresponds to the JSON property `oauth2ClientSecretSha256`
        # @return [String]
        attr_accessor :oauth2_client_secret_sha256
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @enabled = args[:enabled] if args.key?(:enabled)
          @oauth2_client_id = args[:oauth2_client_id] if args.key?(:oauth2_client_id)
          @oauth2_client_secret = args[:oauth2_client_secret] if args.key?(:oauth2_client_secret)
          @oauth2_client_secret_sha256 = args[:oauth2_client_secret_sha256] if args.key?(:oauth2_client_secret_sha256)
        end
      end
      
      # Contains a list of BackendService resources.
      class BackendServiceList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of BackendService resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::BackendService>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Alwayscompute#backendServiceList
        # for lists of backend services.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::BackendServiceList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::BackendServiceList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of usable BackendService resources.
      class BackendServiceListUsable
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of BackendService resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::BackendService>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Alwayscompute#
        # usableBackendServiceList for lists of usable backend
        # services.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::BackendServiceListUsable::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::BackendServiceListUsable::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Container for either a built-in LB policy supported by gRPC or Envoy or
      # a custom one implemented by the end user.
      class BackendServiceLocalityLoadBalancingPolicyConfig
        include Google::Apis::Core::Hashable
      
        # The configuration for a custom policy implemented by the user and
        # deployed with the client.
        # Corresponds to the JSON property `customPolicy`
        # @return [Google::Apis::ComputeV1::BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy]
        attr_accessor :custom_policy
      
        # The configuration for a built-in load balancing policy.
        # Corresponds to the JSON property `policy`
        # @return [Google::Apis::ComputeV1::BackendServiceLocalityLoadBalancingPolicyConfigPolicy]
        attr_accessor :policy
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @custom_policy = args[:custom_policy] if args.key?(:custom_policy)
          @policy = args[:policy] if args.key?(:policy)
        end
      end
      
      # The configuration for a custom policy implemented by the user and
      # deployed with the client.
      class BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy
        include Google::Apis::Core::Hashable
      
        # An optional, arbitrary JSON object with configuration data, understood
        # by a locally installed custom policy implementation.
        # Corresponds to the JSON property `data`
        # @return [String]
        attr_accessor :data
      
        # Identifies the custom policy.
        # The value should match the name of a custom implementation registered
        # on the gRPC clients. It should follow protocol buffer message naming
        # conventions and include the full path (for example,
        # myorg.CustomLbPolicy). The maximum length is 256 characters.
        # Do not specify the same custom policy more than once for a
        # backend. If you do, the configuration is rejected.
        # For an example of how to use this field, seeUse
        # a custom policy.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @data = args[:data] if args.key?(:data)
          @name = args[:name] if args.key?(:name)
        end
      end
      
      # The configuration for a built-in load balancing policy.
      class BackendServiceLocalityLoadBalancingPolicyConfigPolicy
        include Google::Apis::Core::Hashable
      
        # The name of a locality load-balancing policy. Valid values include
        # ROUND_ROBIN and, for Java clients, LEAST_REQUEST. For information
        # about these values, see the description of localityLbPolicy.
        # Do not specify the same policy more than once for a
        # backend. If you do, the configuration is rejected.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @name = args[:name] if args.key?(:name)
        end
      end
      
      # The available logging options for the load balancer traffic served by this
      # backend service.
      class BackendServiceLogConfig
        include Google::Apis::Core::Hashable
      
        # Denotes whether to enable logging for the load balancer
        # traffic served by this backend service. The default value is false.
        # Corresponds to the JSON property `enable`
        # @return [Boolean]
        attr_accessor :enable
        alias_method :enable?, :enable
      
        # This field can only be specified if logging is enabled for this backend
        # service and "logConfig.optionalMode" was set to CUSTOM. Contains a list
        # of optional fields you want to include in the logs. For example:
        # serverInstance, serverGkeDetails.cluster,
        # serverGkeDetails.pod.podNamespace
        # Corresponds to the JSON property `optionalFields`
        # @return [Array<String>]
        attr_accessor :optional_fields
      
        # This field can only be specified if logging is enabled for this backend
        # service. Configures whether all, none or a subset of optional fields
        # should be added to the reported logs. One of [INCLUDE_ALL_OPTIONAL,
        # EXCLUDE_ALL_OPTIONAL, CUSTOM]. Default is EXCLUDE_ALL_OPTIONAL.
        # Corresponds to the JSON property `optionalMode`
        # @return [String]
        attr_accessor :optional_mode
      
        # This field can only be specified if logging is enabled for this backend
        # service. The value of the field must be in [0, 1]. This configures the
        # sampling rate of requests to the load balancer where 1.0 means all logged
        # requests are reported and 0.0 means no logged requests are reported. The
        # default value is 1.0.
        # Corresponds to the JSON property `sampleRate`
        # @return [Float]
        attr_accessor :sample_rate
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @enable = args[:enable] if args.key?(:enable)
          @optional_fields = args[:optional_fields] if args.key?(:optional_fields)
          @optional_mode = args[:optional_mode] if args.key?(:optional_mode)
          @sample_rate = args[:sample_rate] if args.key?(:sample_rate)
        end
      end
      
      # 
      class BackendServiceNetworkPassThroughLbTrafficPolicy
        include Google::Apis::Core::Hashable
      
        # When configured, new connections are load balanced across healthy backend
        # endpoints in the local zone.
        # Corresponds to the JSON property `zonalAffinity`
        # @return [Google::Apis::ComputeV1::BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity]
        attr_accessor :zonal_affinity
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @zonal_affinity = args[:zonal_affinity] if args.key?(:zonal_affinity)
        end
      end
      
      # 
      class BackendServiceNetworkPassThroughLbTrafficPolicyZonalAffinity
        include Google::Apis::Core::Hashable
      
        # This field indicates whether zonal affinity is enabled or not. The
        # possible values are:
        # 
        # - ZONAL_AFFINITY_DISABLED: Default Value. Zonal Affinity
        # is disabled. The load balancer distributes new connections to all
        # healthy backend endpoints across all zones.
        # - ZONAL_AFFINITY_STAY_WITHIN_ZONE: Zonal Affinity is
        # enabled. The load balancer distributes new connections to all healthy
        # backend endpoints in the local zone only. If there are no healthy
        # backend endpoints in the local zone, the load balancer distributes
        # new connections to all backend endpoints in the local zone.
        # - ZONAL_AFFINITY_SPILL_CROSS_ZONE: Zonal Affinity is
        # enabled. The load balancer distributes new connections to all healthy
        # backend endpoints in the local zone only. If there aren't enough
        # healthy backend endpoints in the local zone, the load balancer
        # distributes new connections to all healthy backend endpoints across all
        # zones.
        # Corresponds to the JSON property `spillover`
        # @return [String]
        attr_accessor :spillover
      
        # The value of the field must be in [0, 1]. When the ratio of the count
        # of healthy backend endpoints in a zone to the count of backend
        # endpoints in that same zone is equal to or above this threshold, the
        # load balancer distributes new connections to all healthy endpoints in
        # the local zone only. When the ratio of the count of healthy backend
        # endpoints in a zone to the count of backend endpoints in that same
        # zone is below this threshold, the load balancer distributes all new
        # connections to all healthy endpoints across all zones.
        # Corresponds to the JSON property `spilloverRatio`
        # @return [Float]
        attr_accessor :spillover_ratio
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @spillover = args[:spillover] if args.key?(:spillover)
          @spillover_ratio = args[:spillover_ratio] if args.key?(:spillover_ratio)
        end
      end
      
      # Additional Backend Service parameters.
      class BackendServiceParams
        include Google::Apis::Core::Hashable
      
        # Tag keys/values directly bound to this resource.
        # Tag keys and values have the same definition as resource
        # manager tags. The field is allowed for INSERT
        # only. The keys/values to set on the resource should be specified in
        # either ID ` : ` or Namespaced format
        # ` : `.
        # For example the following are valid inputs:
        # * `"tagKeys/333" : "tagValues/444", "tagKeys/123" : "tagValues/456"`
        # * `"123/environment" : "production", "345/abc" : "xyz"`
        # Note:
        # * Invalid combinations of ID & namespaced format is not supported. For
        # instance: `"123/environment" : "tagValues/444"` is invalid.
        # Corresponds to the JSON property `resourceManagerTags`
        # @return [Hash<String,String>]
        attr_accessor :resource_manager_tags
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @resource_manager_tags = args[:resource_manager_tags] if args.key?(:resource_manager_tags)
        end
      end
      
      # 
      class BackendServiceReference
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `backendService`
        # @return [String]
        attr_accessor :backend_service
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @backend_service = args[:backend_service] if args.key?(:backend_service)
        end
      end
      
      # 
      class BackendServiceTlsSettings
        include Google::Apis::Core::Hashable
      
        # Reference to the BackendAuthenticationConfig resource from the
        # networksecurity.googleapis.com namespace. Can be used in authenticating
        # TLS connections to the backend, as specified by the authenticationMode
        # field. Can only be specified if authenticationMode is not NONE.
        # Corresponds to the JSON property `authenticationConfig`
        # @return [String]
        attr_accessor :authentication_config
      
        # Server Name Indication - see RFC3546 section 3.1. If set, the load
        # balancer sends this string as the SNI hostname in the TLS connection to
        # the backend, and requires that this string match a Subject Alternative
        # Name (SAN) in the backend's server certificate. With a Regional Internet
        # NEG backend, if the SNI is specified here, the load balancer uses it
        # regardless of whether the Regional Internet NEG is specified with FQDN or
        # IP address and port. When both sni and subjectAltNames[] are specified,
        # the load balancer matches the backend certificate's SAN only to
        # subjectAltNames[].
        # Corresponds to the JSON property `sni`
        # @return [String]
        attr_accessor :sni
      
        # A list of Subject Alternative Names (SANs) that the Load Balancer
        # verifies during a TLS handshake with the backend. When the server
        # presents its X.509 certificate to the Load Balancer, the Load Balancer
        # inspects the certificate's SAN field, and requires that at least one SAN
        # match one of the subjectAltNames in the list. This field is limited to 5
        # entries. When both sni and subjectAltNames[] are specified, the load
        # balancer matches the backend certificate's SAN only to subjectAltNames[].
        # Corresponds to the JSON property `subjectAltNames`
        # @return [Array<Google::Apis::ComputeV1::BackendServiceTlsSettingsSubjectAltName>]
        attr_accessor :subject_alt_names
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @authentication_config = args[:authentication_config] if args.key?(:authentication_config)
          @sni = args[:sni] if args.key?(:sni)
          @subject_alt_names = args[:subject_alt_names] if args.key?(:subject_alt_names)
        end
      end
      
      # A Subject Alternative Name that the load balancer matches against the SAN
      # field in the TLS certificate provided by the backend, specified as either
      # a DNS name or a URI, in accordance with RFC 5280 4.2.1.6
      class BackendServiceTlsSettingsSubjectAltName
        include Google::Apis::Core::Hashable
      
        # The SAN specified as a DNS Name.
        # Corresponds to the JSON property `dnsName`
        # @return [String]
        attr_accessor :dns_name
      
        # The SAN specified as a URI.
        # Corresponds to the JSON property `uniformResourceIdentifier`
        # @return [String]
        attr_accessor :uniform_resource_identifier
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @dns_name = args[:dns_name] if args.key?(:dns_name)
          @uniform_resource_identifier = args[:uniform_resource_identifier] if args.key?(:uniform_resource_identifier)
        end
      end
      
      # 
      class BackendServiceUsedBy
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Server-defined URL for resources referencing given
        # BackendService like UrlMaps, TargetTcpProxies, TargetSslProxies
        # and ForwardingRule.
        # Corresponds to the JSON property `reference`
        # @return [String]
        attr_accessor :reference
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @reference = args[:reference] if args.key?(:reference)
        end
      end
      
      # 
      class BackendServicesScopedList
        include Google::Apis::Core::Hashable
      
        # A list of BackendServices contained in this scope.
        # Corresponds to the JSON property `backendServices`
        # @return [Array<Google::Apis::ComputeV1::BackendService>]
        attr_accessor :backend_services
      
        # Informational warning which replaces the list of
        # backend services when the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::BackendServicesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @backend_services = args[:backend_services] if args.key?(:backend_services)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Informational warning which replaces the list of
        # backend services when the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::BackendServicesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class BfdPacket
        include Google::Apis::Core::Hashable
      
        # The Authentication Present bit of the BFD packet. This is specified in
        # section 4.1 ofRFC5880
        # Corresponds to the JSON property `authenticationPresent`
        # @return [Boolean]
        attr_accessor :authentication_present
        alias_method :authentication_present?, :authentication_present
      
        # The Control Plane Independent bit of the BFD packet. This is specified in
        # section 4.1 ofRFC5880
        # Corresponds to the JSON property `controlPlaneIndependent`
        # @return [Boolean]
        attr_accessor :control_plane_independent
        alias_method :control_plane_independent?, :control_plane_independent
      
        # The demand bit of the BFD packet. This is specified in section 4.1 ofRFC5880
        # Corresponds to the JSON property `demand`
        # @return [Boolean]
        attr_accessor :demand
        alias_method :demand?, :demand
      
        # The diagnostic code specifies the local system's reason for the last change
        # in session state. This allows remote systems to determine the reason that
        # the previous session failed, for example. These diagnostic codes are
        # specified in section 4.1 ofRFC5880
        # Corresponds to the JSON property `diagnostic`
        # @return [String]
        attr_accessor :diagnostic
      
        # The Final bit of the BFD packet. This is specified in section 4.1 ofRFC5880
        # Corresponds to the JSON property `final`
        # @return [Boolean]
        attr_accessor :final
        alias_method :final?, :final
      
        # The length of the BFD Control packet in bytes. This is specified in section
        # 4.1 ofRFC5880
        # Corresponds to the JSON property `length`
        # @return [Fixnum]
        attr_accessor :length
      
        # The Required Min Echo RX Interval value in the BFD packet. This is
        # specified in section 4.1 ofRFC5880
        # Corresponds to the JSON property `minEchoRxIntervalMs`
        # @return [Fixnum]
        attr_accessor :min_echo_rx_interval_ms
      
        # The Required Min RX Interval value in the BFD packet. This is specified in
        # section 4.1 ofRFC5880
        # Corresponds to the JSON property `minRxIntervalMs`
        # @return [Fixnum]
        attr_accessor :min_rx_interval_ms
      
        # The Desired Min TX Interval value in the BFD packet. This is specified in
        # section 4.1 ofRFC5880
        # Corresponds to the JSON property `minTxIntervalMs`
        # @return [Fixnum]
        attr_accessor :min_tx_interval_ms
      
        # The detection time multiplier of the BFD packet. This is specified in
        # section 4.1 ofRFC5880
        # Corresponds to the JSON property `multiplier`
        # @return [Fixnum]
        attr_accessor :multiplier
      
        # The multipoint bit of the BFD packet. This is specified in section 4.1
        # ofRFC5880
        # Corresponds to the JSON property `multipoint`
        # @return [Boolean]
        attr_accessor :multipoint
        alias_method :multipoint?, :multipoint
      
        # The My Discriminator value in the BFD packet. This is specified in section
        # 4.1 ofRFC5880
        # Corresponds to the JSON property `myDiscriminator`
        # @return [Fixnum]
        attr_accessor :my_discriminator
      
        # The Poll bit of the BFD packet. This is specified in section 4.1 ofRFC5880
        # Corresponds to the JSON property `poll`
        # @return [Boolean]
        attr_accessor :poll
        alias_method :poll?, :poll
      
        # The current BFD session state as seen by the transmitting system. These
        # states are specified in section 4.1 ofRFC5880
        # Corresponds to the JSON property `state`
        # @return [String]
        attr_accessor :state
      
        # The version number of the BFD protocol, as specified in section 4.1 ofRFC5880.
        # Corresponds to the JSON property `version`
        # @return [Fixnum]
        attr_accessor :version
      
        # The Your Discriminator value in the BFD packet. This is specified in
        # section 4.1 ofRFC5880
        # Corresponds to the JSON property `yourDiscriminator`
        # @return [Fixnum]
        attr_accessor :your_discriminator
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @authentication_present = args[:authentication_present] if args.key?(:authentication_present)
          @control_plane_independent = args[:control_plane_independent] if args.key?(:control_plane_independent)
          @demand = args[:demand] if args.key?(:demand)
          @diagnostic = args[:diagnostic] if args.key?(:diagnostic)
          @final = args[:final] if args.key?(:final)
          @length = args[:length] if args.key?(:length)
          @min_echo_rx_interval_ms = args[:min_echo_rx_interval_ms] if args.key?(:min_echo_rx_interval_ms)
          @min_rx_interval_ms = args[:min_rx_interval_ms] if args.key?(:min_rx_interval_ms)
          @min_tx_interval_ms = args[:min_tx_interval_ms] if args.key?(:min_tx_interval_ms)
          @multiplier = args[:multiplier] if args.key?(:multiplier)
          @multipoint = args[:multipoint] if args.key?(:multipoint)
          @my_discriminator = args[:my_discriminator] if args.key?(:my_discriminator)
          @poll = args[:poll] if args.key?(:poll)
          @state = args[:state] if args.key?(:state)
          @version = args[:version] if args.key?(:version)
          @your_discriminator = args[:your_discriminator] if args.key?(:your_discriminator)
        end
      end
      
      # Next free: 15
      class BfdStatus
        include Google::Apis::Core::Hashable
      
        # The BFD session initialization mode for this BGP peer.
        # If set to ACTIVE, the Cloud Router will initiate the BFD session for
        # this BGP peer. If set to PASSIVE, the Cloud Router will wait for the
        # peer router to initiate the BFD session for this BGP peer. If set to
        # DISABLED, BFD is disabled for this BGP peer.
        # Corresponds to the JSON property `bfdSessionInitializationMode`
        # @return [String]
        attr_accessor :bfd_session_initialization_mode
      
        # Unix timestamp of the most recent config update.
        # Corresponds to the JSON property `configUpdateTimestampMicros`
        # @return [Fixnum]
        attr_accessor :config_update_timestamp_micros
      
        # Control packet counts for the current BFD session.
        # Corresponds to the JSON property `controlPacketCounts`
        # @return [Google::Apis::ComputeV1::BfdStatusPacketCounts]
        attr_accessor :control_packet_counts
      
        # Inter-packet time interval statistics for control packets.
        # Corresponds to the JSON property `controlPacketIntervals`
        # @return [Array<Google::Apis::ComputeV1::PacketIntervals>]
        attr_accessor :control_packet_intervals
      
        # The diagnostic code specifies the local system's reason for the last change
        # in session state. This allows remote systems to determine the reason that
        # the previous session failed, for example. These diagnostic codes are
        # specified in section 4.1 ofRFC5880
        # Corresponds to the JSON property `localDiagnostic`
        # @return [String]
        attr_accessor :local_diagnostic
      
        # The current BFD session state as seen by the transmitting system. These
        # states are specified in section 4.1 ofRFC5880
        # Corresponds to the JSON property `localState`
        # @return [String]
        attr_accessor :local_state
      
        # Negotiated transmit interval for control packets.
        # Corresponds to the JSON property `negotiatedLocalControlTxIntervalMs`
        # @return [Fixnum]
        attr_accessor :negotiated_local_control_tx_interval_ms
      
        # The most recent Rx control packet for this BFD session.
        # Corresponds to the JSON property `rxPacket`
        # @return [Google::Apis::ComputeV1::BfdPacket]
        attr_accessor :rx_packet
      
        # The most recent Tx control packet for this BFD session.
        # Corresponds to the JSON property `txPacket`
        # @return [Google::Apis::ComputeV1::BfdPacket]
        attr_accessor :tx_packet
      
        # Session uptime in milliseconds. Value will be 0 if session is not up.
        # Corresponds to the JSON property `uptimeMs`
        # @return [Fixnum]
        attr_accessor :uptime_ms
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @bfd_session_initialization_mode = args[:bfd_session_initialization_mode] if args.key?(:bfd_session_initialization_mode)
          @config_update_timestamp_micros = args[:config_update_timestamp_micros] if args.key?(:config_update_timestamp_micros)
          @control_packet_counts = args[:control_packet_counts] if args.key?(:control_packet_counts)
          @control_packet_intervals = args[:control_packet_intervals] if args.key?(:control_packet_intervals)
          @local_diagnostic = args[:local_diagnostic] if args.key?(:local_diagnostic)
          @local_state = args[:local_state] if args.key?(:local_state)
          @negotiated_local_control_tx_interval_ms = args[:negotiated_local_control_tx_interval_ms] if args.key?(:negotiated_local_control_tx_interval_ms)
          @rx_packet = args[:rx_packet] if args.key?(:rx_packet)
          @tx_packet = args[:tx_packet] if args.key?(:tx_packet)
          @uptime_ms = args[:uptime_ms] if args.key?(:uptime_ms)
        end
      end
      
      # 
      class BfdStatusPacketCounts
        include Google::Apis::Core::Hashable
      
        # Number of packets received since the beginning of the current BFD
        # session.
        # Corresponds to the JSON property `numRx`
        # @return [Fixnum]
        attr_accessor :num_rx
      
        # Number of packets received that were rejected because of errors since the
        # beginning of the current BFD session.
        # Corresponds to the JSON property `numRxRejected`
        # @return [Fixnum]
        attr_accessor :num_rx_rejected
      
        # Number of packets received that were successfully processed since the
        # beginning of the current BFD session.
        # Corresponds to the JSON property `numRxSuccessful`
        # @return [Fixnum]
        attr_accessor :num_rx_successful
      
        # Number of packets transmitted since the beginning of the current BFD
        # session.
        # Corresponds to the JSON property `numTx`
        # @return [Fixnum]
        attr_accessor :num_tx
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @num_rx = args[:num_rx] if args.key?(:num_rx)
          @num_rx_rejected = args[:num_rx_rejected] if args.key?(:num_rx_rejected)
          @num_rx_successful = args[:num_rx_successful] if args.key?(:num_rx_successful)
          @num_tx = args[:num_tx] if args.key?(:num_tx)
        end
      end
      
      # 
      class BgpRoute
        include Google::Apis::Core::Hashable
      
        # Output only. [Output only] AS-PATH for the route
        # Corresponds to the JSON property `asPaths`
        # @return [Array<Google::Apis::ComputeV1::BgpRouteAsPath>]
        attr_accessor :as_paths
      
        # Output only. [Output only] BGP communities in human-readable A:B format.
        # Corresponds to the JSON property `communities`
        # @return [Array<String>]
        attr_accessor :communities
      
        # Network Layer Reachability Information (NLRI) for a route.
        # Corresponds to the JSON property `destination`
        # @return [Google::Apis::ComputeV1::BgpRouteNetworkLayerReachabilityInformation]
        attr_accessor :destination
      
        # Output only. [Output only] BGP multi-exit discriminator
        # Corresponds to the JSON property `med`
        # @return [Fixnum]
        attr_accessor :med
      
        # Output only. [Output only] BGP origin (EGP, IGP or INCOMPLETE)
        # Corresponds to the JSON property `origin`
        # @return [String]
        attr_accessor :origin
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @as_paths = args[:as_paths] if args.key?(:as_paths)
          @communities = args[:communities] if args.key?(:communities)
          @destination = args[:destination] if args.key?(:destination)
          @med = args[:med] if args.key?(:med)
          @origin = args[:origin] if args.key?(:origin)
        end
      end
      
      # 
      class BgpRouteAsPath
        include Google::Apis::Core::Hashable
      
        # Output only. [Output only] ASNs in the path segment. When type is SEQUENCE,
        # these are
        # ordered.
        # Corresponds to the JSON property `asns`
        # @return [Array<Fixnum>]
        attr_accessor :asns
      
        # Output only. [Output only] ASNs in the path segment. This field is for better
        # support of 32 bit ASNs as the other asns field suffers from overflow when
        # the ASN is larger. When type is SEQUENCE, these are ordered.
        # Corresponds to the JSON property `asns32`
        # @return [Array<Fixnum>]
        attr_accessor :asns32
      
        # Output only. [Output only] Type of AS-PATH segment (SEQUENCE or SET)
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @asns = args[:asns] if args.key?(:asns)
          @asns32 = args[:asns32] if args.key?(:asns32)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # Network Layer Reachability Information (NLRI) for a route.
      class BgpRouteNetworkLayerReachabilityInformation
        include Google::Apis::Core::Hashable
      
        # If the BGP session supports multiple paths (RFC 7911), the path
        # identifier for this route.
        # Corresponds to the JSON property `pathId`
        # @return [Fixnum]
        attr_accessor :path_id
      
        # Human readable CIDR notation for a prefix. E.g. 10.42.0.0/16.
        # Corresponds to the JSON property `prefix`
        # @return [String]
        attr_accessor :prefix
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @path_id = args[:path_id] if args.key?(:path_id)
          @prefix = args[:prefix] if args.key?(:prefix)
        end
      end
      
      # Associates `members`, or principals, with a `role`.
      class Binding
        include Google::Apis::Core::Hashable
      
        # Represents a textual expression in the Common Expression Language (CEL)
        # syntax. CEL is a C-like expression language. The syntax and semantics of CEL
        # are documented at https://github.com/google/cel-spec.
        # Example (Comparison):
        # title: "Summary size limit"
        # description: "Determines if a summary is less than 100 chars"
        # expression: "document.summary.size() < 100"
        # Example (Equality):
        # title: "Requestor is owner"
        # description: "Determines if requestor is the document owner"
        # expression: "document.owner == request.auth.claims.email"
        # Example (Logic):
        # title: "Public documents"
        # description: "Determine whether the document should be publicly visible"
        # expression: "document.type != 'private' && document.type != 'internal'"
        # Example (Data Manipulation):
        # title: "Notification string"
        # description: "Create a notification string with a timestamp."
        # expression: "'New message received at ' + string(document.create_time)"
        # The exact variables and functions that may be referenced within an expression
        # are determined by the service that evaluates it. See the service
        # documentation for additional information.
        # Corresponds to the JSON property `condition`
        # @return [Google::Apis::ComputeV1::Expr]
        attr_accessor :condition
      
        # Specifies the principals requesting access for a Google Cloud resource.
        # `members` can have the following values:
        # * `allUsers`: A special identifier that represents anyone who is
        # on the internet; with or without a Google account.
        # * `allAuthenticatedUsers`: A special identifier that represents anyone
        # who is authenticated with a Google account or a service account.
        # Does not include identities that come from external identity providers
        # (IdPs) through identity federation.
        # * `user:`emailid``: An email address that represents a specific Google
        # account. For example, `alice@example.com` .
        # * `serviceAccount:`emailid``: An email address that represents a Google
        # service account. For example,
        # `my-other-app@appspot.gserviceaccount.com`.
        # * `serviceAccount:`projectid`.svc.id.goog[`namespace`/`kubernetes-sa`]`: An
        # identifier for a
        # [Kubernetes service
        # account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-
        # service-accounts).
        # For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`.
        # * `group:`emailid``: An email address that represents a Google group.
        # For example, `admins@example.com`.
        # * `domain:`domain``: The G Suite domain (primary) that represents all the
        # users of that domain. For example, `google.com` or `example.com`.
        # * `principal://iam.googleapis.com/locations/global/workforcePools/`pool_id`/
        # subject/`subject_attribute_value``:
        # A single identity in a workforce identity pool.
        # * `principalSet://iam.googleapis.com/locations/global/workforcePools/`pool_id`/
        # group/`group_id``:
        # All workforce identities in a group.
        # * `principalSet://iam.googleapis.com/locations/global/workforcePools/`pool_id`/
        # attribute.`attribute_name`/`attribute_value``:
        # All workforce identities with a specific attribute value.
        # * `principalSet://iam.googleapis.com/locations/global/workforcePools/`pool_id`/
        # *`:
        # All identities in a workforce identity pool.
        # * `principal://iam.googleapis.com/projects/`project_number`/locations/global/
        # workloadIdentityPools/`pool_id`/subject/`subject_attribute_value``:
        # A single identity in a workload identity pool.
        # * `principalSet://iam.googleapis.com/projects/`project_number`/locations/
        # global/workloadIdentityPools/`pool_id`/group/`group_id``:
        # A workload identity pool group.
        # * `principalSet://iam.googleapis.com/projects/`project_number`/locations/
        # global/workloadIdentityPools/`pool_id`/attribute.`attribute_name`/`
        # attribute_value``:
        # All identities in a workload identity pool with a certain attribute.
        # * `principalSet://iam.googleapis.com/projects/`project_number`/locations/
        # global/workloadIdentityPools/`pool_id`/*`:
        # All identities in a workload identity pool.
        # * `deleted:user:`emailid`?uid=`uniqueid``: An email address (plus unique
        # identifier) representing a user that has been recently deleted. For
        # example, `alice@example.com?uid=123456789012345678901`. If the user is
        # recovered, this value reverts to `user:`emailid`` and the recovered user
        # retains the role in the binding.
        # * `deleted:serviceAccount:`emailid`?uid=`uniqueid``: An email address (plus
        # unique identifier) representing a service account that has been recently
        # deleted. For example,
        # `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`.
        # If the service account is undeleted, this value reverts to
        # `serviceAccount:`emailid`` and the undeleted service account retains the
        # role in the binding.
        # * `deleted:group:`emailid`?uid=`uniqueid``: An email address (plus unique
        # identifier) representing a Google group that has been recently
        # deleted. For example, `admins@example.com?uid=123456789012345678901`. If
        # the group is recovered, this value reverts to `group:`emailid`` and the
        # recovered group retains the role in the binding.
        # * `deleted:principal://iam.googleapis.com/locations/global/workforcePools/`
        # pool_id`/subject/`subject_attribute_value``:
        # Deleted single identity in a workforce identity pool. For example,
        # `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-
        # pool-id/subject/my-subject-attribute-value`.
        # Corresponds to the JSON property `members`
        # @return [Array<String>]
        attr_accessor :members
      
        # Role that is assigned to the list of `members`, or principals.
        # For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        # For an overview of the IAM roles and permissions, see the
        # [IAM documentation](https://cloud.google.com/iam/docs/roles-overview). For
        # a list of the available pre-defined roles, see
        # [here](https://cloud.google.com/iam/docs/understanding-roles).
        # Corresponds to the JSON property `role`
        # @return [String]
        attr_accessor :role
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @condition = args[:condition] if args.key?(:condition)
          @members = args[:members] if args.key?(:members)
          @role = args[:role] if args.key?(:role)
        end
      end
      
      # A transient resource used in compute.disks.bulkInsert and
      # compute.regionDisks.bulkInsert. It is only used to process
      # requests and is not persisted.
      class BulkInsertDiskResource
        include Google::Apis::Core::Hashable
      
        # The URL of the DiskConsistencyGroupPolicy for the group of disks to clone.
        # This may be a full or partial URL, such as:
        # 
        # 
        # -
        # https://www.googleapis.com/compute/v1/projects/project/regions/region/
        # resourcePolicies/resourcePolicy
        # 
        # -
        # projects/project/regions/region/resourcePolicies/resourcePolicy
        # 
        # -
        # regions/region/resourcePolicies/resourcePolicy
        # Corresponds to the JSON property `sourceConsistencyGroupPolicy`
        # @return [String]
        attr_accessor :source_consistency_group_policy
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @source_consistency_group_policy = args[:source_consistency_group_policy] if args.key?(:source_consistency_group_policy)
        end
      end
      
      # A transient resource used in compute.instances.bulkInsert and
      # compute.regionInstances.bulkInsert . This resource is not persisted
      # anywhere, it is used only for processing the requests.
      class BulkInsertInstanceResource
        include Google::Apis::Core::Hashable
      
        # The maximum number of instances to create.
        # Corresponds to the JSON property `count`
        # @return [Fixnum]
        attr_accessor :count
      
        # A flexible specification of machine types for instances to create.
        # Corresponds to the JSON property `instanceFlexibilityPolicy`
        # @return [Google::Apis::ComputeV1::InstanceFlexibilityPolicy]
        attr_accessor :instance_flexibility_policy
      
        # The instance properties defining the VM instances to be created. Required
        # if sourceInstanceTemplate is not provided.
        # Corresponds to the JSON property `instanceProperties`
        # @return [Google::Apis::ComputeV1::InstanceProperties]
        attr_accessor :instance_properties
      
        # Configuration for location policy among multiple possible locations
        # (e.g. preferences for zone selection among zones in a single region).
        # Corresponds to the JSON property `locationPolicy`
        # @return [Google::Apis::ComputeV1::LocationPolicy]
        attr_accessor :location_policy
      
        # The minimum number of instances to create. If no min_count is
        # specified then count is used as the default value. Ifmin_count instances
        # cannot be created, then no instances will
        # be created and instances already created will be deleted.
        # Corresponds to the JSON property `minCount`
        # @return [Fixnum]
        attr_accessor :min_count
      
        # The string pattern used for the names of the VMs.
        # Either name_pattern or per_instance_properties
        # must be set. The pattern must contain one continuous sequence of
        # placeholder hash characters (#) with each character corresponding to one
        # digit of the generated instance name. Example: a name_pattern
        # of inst-#### generates instance names such asinst-0001 and inst-0002. If
        # existing instances
        # in the same project and zone have names that match the name pattern
        # then the generated instance numbers start after the biggest
        # existing number. For example, if there exists an instance with nameinst-0050,
        # then instance names generated using the patterninst-#### begin with inst-0051.
        # The name pattern
        # placeholder #...# can contain up to 18 characters.
        # Corresponds to the JSON property `namePattern`
        # @return [String]
        attr_accessor :name_pattern
      
        # Per-instance properties to be set on individual instances.
        # Keys of this map specify requested instance names.
        # Can be empty if name_pattern is used.
        # Corresponds to the JSON property `perInstanceProperties`
        # @return [Hash<String,Google::Apis::ComputeV1::BulkInsertInstanceResourcePerInstanceProperties>]
        attr_accessor :per_instance_properties
      
        # Specifies the instance template from which to create instances. You may
        # combine sourceInstanceTemplate withinstanceProperties to override specific
        # values from an
        # existing instance template. Bulk API follows the semantics of JSON Merge
        # Patch described by RFC
        # 7396.
        # It can be a full or partial URL. For example, the following are
        # all valid URLs to an instance template:
        # 
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/global/
        # instanceTemplates/instanceTemplate
        # - projects/project/global/instanceTemplates/instanceTemplate
        # - global/instanceTemplates/instanceTemplate
        # This field is optional.
        # Corresponds to the JSON property `sourceInstanceTemplate`
        # @return [String]
        attr_accessor :source_instance_template
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @count = args[:count] if args.key?(:count)
          @instance_flexibility_policy = args[:instance_flexibility_policy] if args.key?(:instance_flexibility_policy)
          @instance_properties = args[:instance_properties] if args.key?(:instance_properties)
          @location_policy = args[:location_policy] if args.key?(:location_policy)
          @min_count = args[:min_count] if args.key?(:min_count)
          @name_pattern = args[:name_pattern] if args.key?(:name_pattern)
          @per_instance_properties = args[:per_instance_properties] if args.key?(:per_instance_properties)
          @source_instance_template = args[:source_instance_template] if args.key?(:source_instance_template)
        end
      end
      
      # Per-instance properties to be set on individual instances.
      # To be extended in the future.
      class BulkInsertInstanceResourcePerInstanceProperties
        include Google::Apis::Core::Hashable
      
        # Specifies the hostname of the instance. More details in:
        # https://cloud.google.com/compute/docs/instances/custom-hostname-vm#
        # naming_convention
        # Corresponds to the JSON property `hostname`
        # @return [String]
        attr_accessor :hostname
      
        # Output only. This field is only temporary. It will be removed. Do not use it.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @hostname = args[:hostname] if args.key?(:hostname)
          @name = args[:name] if args.key?(:name)
        end
      end
      
      # 
      class BulkInsertOperationStatus
        include Google::Apis::Core::Hashable
      
        # [Output Only] Count of VMs successfully created so far.
        # Corresponds to the JSON property `createdVmCount`
        # @return [Fixnum]
        attr_accessor :created_vm_count
      
        # [Output Only] Count of VMs that got deleted during rollback.
        # Corresponds to the JSON property `deletedVmCount`
        # @return [Fixnum]
        attr_accessor :deleted_vm_count
      
        # [Output Only] Count of VMs that started creating but encountered an
        # error.
        # Corresponds to the JSON property `failedToCreateVmCount`
        # @return [Fixnum]
        attr_accessor :failed_to_create_vm_count
      
        # [Output Only] Creation status of BulkInsert operation - information
        # if the flow is rolling forward or rolling back.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # [Output Only] Count of VMs originally planned to be created.
        # Corresponds to the JSON property `targetVmCount`
        # @return [Fixnum]
        attr_accessor :target_vm_count
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @created_vm_count = args[:created_vm_count] if args.key?(:created_vm_count)
          @deleted_vm_count = args[:deleted_vm_count] if args.key?(:deleted_vm_count)
          @failed_to_create_vm_count = args[:failed_to_create_vm_count] if args.key?(:failed_to_create_vm_count)
          @status = args[:status] if args.key?(:status)
          @target_vm_count = args[:target_vm_count] if args.key?(:target_vm_count)
        end
      end
      
      # 
      class BulkSetLabelsRequest
        include Google::Apis::Core::Hashable
      
        # The fingerprint of the previous set of labels for this resource,
        # used to detect conflicts. The fingerprint is initially generated by Compute
        # Engine and changes after every request to modify or update labels. You may
        # optionally provide an up-to-date fingerprint hash in order to update or
        # change labels. Make a get() request to the resource to get the
        # latest fingerprint.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # The labels to set for this resource.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
        end
      end
      
      # 
      class BulkZoneSetLabelsRequest
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `requests`
        # @return [Array<Google::Apis::ComputeV1::BulkSetLabelsRequest>]
        attr_accessor :requests
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @requests = args[:requests] if args.key?(:requests)
        end
      end
      
      # 
      class BundledLocalSsds
        include Google::Apis::Core::Hashable
      
        # The default disk interface if the interface is not specified.
        # Corresponds to the JSON property `defaultInterface`
        # @return [String]
        attr_accessor :default_interface
      
        # The number of partitions.
        # Corresponds to the JSON property `partitionCount`
        # @return [Fixnum]
        attr_accessor :partition_count
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @default_interface = args[:default_interface] if args.key?(:default_interface)
          @partition_count = args[:partition_count] if args.key?(:partition_count)
        end
      end
      
      # 
      class CacheInvalidationRule
        include Google::Apis::Core::Hashable
      
        # A list of cache tags used to identify cached objects.
        # 
        # - Cache tags are specified when the response is first cached, by setting
        # the `Cache-Tag` response header at the origin.
        # - Multiple cache tags in the same invalidation request are treated as
        # Boolean `OR` - for example, `tag1 OR tag2 OR tag3`.
        # - If other fields are also specified, these are treated as Boolean `AND`
        # with any tags.
        # Up to 10 tags can be specified in a single invalidation request.
        # Corresponds to the JSON property `cacheTags`
        # @return [Array<String>]
        attr_accessor :cache_tags
      
        # If set, this invalidation rule will only apply to requests with a Host
        # header matching host.
        # Corresponds to the JSON property `host`
        # @return [String]
        attr_accessor :host
      
        # 
        # Corresponds to the JSON property `path`
        # @return [String]
        attr_accessor :path
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @cache_tags = args[:cache_tags] if args.key?(:cache_tags)
          @host = args[:host] if args.key?(:host)
          @path = args[:path] if args.key?(:path)
        end
      end
      
      # Message containing what to include in the cache key for a request for Cloud
      # CDN.
      class CacheKeyPolicy
        include Google::Apis::Core::Hashable
      
        # If true, requests to different hosts will be cached separately.
        # Corresponds to the JSON property `includeHost`
        # @return [Boolean]
        attr_accessor :include_host
        alias_method :include_host?, :include_host
      
        # Allows HTTP request headers (by name) to be used in the cache key.
        # Corresponds to the JSON property `includeHttpHeaders`
        # @return [Array<String>]
        attr_accessor :include_http_headers
      
        # Allows HTTP cookies (by name) to be used in the cache key.
        # The name=value pair will be used in the cache key Cloud CDN generates.
        # Corresponds to the JSON property `includeNamedCookies`
        # @return [Array<String>]
        attr_accessor :include_named_cookies
      
        # If true, http and https requests will be cached separately.
        # Corresponds to the JSON property `includeProtocol`
        # @return [Boolean]
        attr_accessor :include_protocol
        alias_method :include_protocol?, :include_protocol
      
        # If true, include query string parameters in the cache key according to
        # query_string_whitelist and query_string_blacklist. If neither is set, the
        # entire query string will be included. If false, the query string will be
        # excluded from the cache key entirely.
        # Corresponds to the JSON property `includeQueryString`
        # @return [Boolean]
        attr_accessor :include_query_string
        alias_method :include_query_string?, :include_query_string
      
        # Names of query string parameters to exclude in cache keys. All other
        # parameters will be included. Either specify query_string_whitelist or
        # query_string_blacklist, not both. '&' and '=' will be percent encoded and
        # not treated as delimiters.
        # Corresponds to the JSON property `queryStringBlacklist`
        # @return [Array<String>]
        attr_accessor :query_string_blacklist
      
        # Names of query string parameters to include in cache keys. All other
        # parameters will be excluded. Either specify query_string_whitelist or
        # query_string_blacklist, not both. '&' and '=' will be percent encoded and
        # not treated as delimiters.
        # Corresponds to the JSON property `queryStringWhitelist`
        # @return [Array<String>]
        attr_accessor :query_string_whitelist
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @include_host = args[:include_host] if args.key?(:include_host)
          @include_http_headers = args[:include_http_headers] if args.key?(:include_http_headers)
          @include_named_cookies = args[:include_named_cookies] if args.key?(:include_named_cookies)
          @include_protocol = args[:include_protocol] if args.key?(:include_protocol)
          @include_query_string = args[:include_query_string] if args.key?(:include_query_string)
          @query_string_blacklist = args[:query_string_blacklist] if args.key?(:query_string_blacklist)
          @query_string_whitelist = args[:query_string_whitelist] if args.key?(:query_string_whitelist)
        end
      end
      
      # A request to recommend the best way to consume the specified resources in the
      # future.
      class CalendarModeAdviceRequest
        include Google::Apis::Core::Hashable
      
        # Specification of resources to create in the future.
        # The key of the map is an arbitrary string specified by the caller.
        # Value of the map is a specification of required resources and their
        # constraints. Currently only one value is allowed in this map.
        # Corresponds to the JSON property `futureResourcesSpecs`
        # @return [Hash<String,Google::Apis::ComputeV1::FutureResourcesSpec>]
        attr_accessor :future_resources_specs
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @future_resources_specs = args[:future_resources_specs] if args.key?(:future_resources_specs)
        end
      end
      
      # A response containing the recommended way of creating the specified resources
      # in the future. It contains (will contain) multiple recommendations that can
      # be analyzed by the customer and the best one can be picked.
      class CalendarModeAdviceResponse
        include Google::Apis::Core::Hashable
      
        # Recommendations where, how and when to create the requested resources
        # in order to maximize their obtainability and minimize cost.
        # Corresponds to the JSON property `recommendations`
        # @return [Array<Google::Apis::ComputeV1::CalendarModeRecommendation>]
        attr_accessor :recommendations
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @recommendations = args[:recommendations] if args.key?(:recommendations)
        end
      end
      
      # A single recommendation to create requested resources. Contains detailed
      # recommendations for every future resources specification specified in
      # CalendarModeAdviceRequest.
      class CalendarModeRecommendation
        include Google::Apis::Core::Hashable
      
        # Recommendations for every future resource specification passed in
        # CalendarModeAdviceRequest. Keys of the map correspond to keys
        # specified in the request.
        # Corresponds to the JSON property `recommendationsPerSpec`
        # @return [Hash<String,Google::Apis::ComputeV1::FutureResourcesRecommendation>]
        attr_accessor :recommendations_per_spec
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @recommendations_per_spec = args[:recommendations_per_spec] if args.key?(:recommendations_per_spec)
        end
      end
      
      # Settings controlling the volume of requests, connections and retries to this
      # backend service.
      class CircuitBreakers
        include Google::Apis::Core::Hashable
      
        # The maximum number of connections to the backend service. If not specified,
        # there is no limit.
        # Not supported when the backend service is referenced by a URL map that is
        # bound to target gRPC proxy that has validateForProxyless field set to true.
        # Corresponds to the JSON property `maxConnections`
        # @return [Fixnum]
        attr_accessor :max_connections
      
        # The maximum number of pending requests allowed to the backend service. If
        # not specified, there is no limit.
        # Not supported when the backend service is referenced by a URL map that is
        # bound to target gRPC proxy that has validateForProxyless field set to true.
        # Corresponds to the JSON property `maxPendingRequests`
        # @return [Fixnum]
        attr_accessor :max_pending_requests
      
        # The maximum number of parallel requests that allowed to the backend
        # service. If not specified, there is no limit.
        # Corresponds to the JSON property `maxRequests`
        # @return [Fixnum]
        attr_accessor :max_requests
      
        # Maximum requests for a single connection to the backend service.
        # This parameter is respected by both the HTTP/1.1 and HTTP/2
        # implementations. If not specified, there is no limit. Setting this
        # parameter to 1 will effectively disable keep alive.
        # Not supported when the backend service is referenced by a URL map that is
        # bound to target gRPC proxy that has validateForProxyless field set to true.
        # Corresponds to the JSON property `maxRequestsPerConnection`
        # @return [Fixnum]
        attr_accessor :max_requests_per_connection
      
        # The maximum number of parallel retries allowed to the backend cluster. If
        # not specified, the default is 1.
        # Not supported when the backend service is referenced by a URL map that is
        # bound to target gRPC proxy that has validateForProxyless field set to true.
        # Corresponds to the JSON property `maxRetries`
        # @return [Fixnum]
        attr_accessor :max_retries
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @max_connections = args[:max_connections] if args.key?(:max_connections)
          @max_pending_requests = args[:max_pending_requests] if args.key?(:max_pending_requests)
          @max_requests = args[:max_requests] if args.key?(:max_requests)
          @max_requests_per_connection = args[:max_requests_per_connection] if args.key?(:max_requests_per_connection)
          @max_retries = args[:max_retries] if args.key?(:max_retries)
        end
      end
      
      # Represents a regional resource-based commitment resource.
      # Creating this commitment resource means that you are purchasing a
      # resource-based committed use contract, with an explicit start and end time.
      # You can purchase resource-based commitments for both hardware and software
      # resources. For more information, read
      # Resource-based committed use discounts
      class Commitment
        include Google::Apis::Core::Hashable
      
        # Specifies whether to automatically renew the commitment at the end of its
        # current term. The default value is false. If you set the field
        # to true, each time your commitment reaches the end of its
        # term, Compute Engine automatically renews it for another term. You can
        # update this field anytime before the commitment expires. For example, if
        # the commitment is set to expire at 12 AM UTC-8 on January 3, 2027, you can
        # update this field until 11:59 PM UTC-8 on January 2, 2027.
        # Corresponds to the JSON property `autoRenew`
        # @return [Boolean]
        attr_accessor :auto_renew
        alias_method :auto_renew?, :auto_renew
      
        # The category of the commitment; specifies whether the commitment is for
        # hardware or software resources. Category MACHINE specifies
        # that you are committing to hardware machine resources such asVCPU or MEMORY,
        # listed in resources.
        # Category LICENSE specifies that you are committing to software
        # licenses, listed in licenseResources.
        # Note that if you specify MACHINE commitments, then you must
        # also specify a type to indicate the machine series of the
        # hardware resource that you are committing to.
        # Corresponds to the JSON property `category`
        # @return [String]
        attr_accessor :category
      
        # Output only. [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # [Input Only] Optional, specifies the requested commitment end time inRFC3339
        # text format. Use this option when the desired
        # commitment's end date is later than the start date + term duration.
        # Corresponds to the JSON property `customEndTimestamp`
        # @return [String]
        attr_accessor :custom_end_timestamp
      
        # An optional description of the commitment. You can provide this property
        # when you create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Output only. [Output Only] Commitment end time inRFC3339
        # text format.
        # Corresponds to the JSON property `endTimestamp`
        # @return [String]
        attr_accessor :end_timestamp
      
        # 
        # Corresponds to the JSON property `existingReservations`
        # @return [Array<String>]
        attr_accessor :existing_reservations
      
        # Output only. [Output Only] The unique identifier for the resource. This
        # identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. [Output Only] Type of the resource. Always compute#commitment
        # for commitments.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Commitment for a particular license resource.
        # Corresponds to the JSON property `licenseResource`
        # @return [Google::Apis::ComputeV1::LicenseResourceCommitment]
        attr_accessor :license_resource
      
        # The list of source commitments that you are merging to create the new
        # merged commitment. For more information, see
        # Merging commitments.
        # Corresponds to the JSON property `mergeSourceCommitments`
        # @return [Array<String>]
        attr_accessor :merge_source_commitments
      
        # Name of the commitment. You must specify a name when you purchase the
        # commitment. The name must be 1-63 characters long, and comply withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must
        # be a dash, lowercase letter, or digit, except the last character, which
        # cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The minimum time duration that you commit to purchasing resources.
        # The plan that you choose determines the preset term length of the
        # commitment (which is 1 year or 3 years) and affects the discount rate that
        # you receive for your resources. Committing to a longer time duration
        # typically gives you a higher discount rate. The supported values for this
        # field are TWELVE_MONTH (1 year), andTHIRTY_SIX_MONTH (3 years).
        # Corresponds to the JSON property `plan`
        # @return [String]
        attr_accessor :plan
      
        # Output only. [Output Only] URL of the region where the commitment and
        # committed
        # resources are located.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # The list of new reservations that you want to create and attach to this
        # commitment.
        # You must attach reservations to your commitment if your commitment
        # specifies any GPUs or Local SSD disks. For more information, see
        # Attach reservations to resource-based commitments.
        # Specify this property only if you want to create new
        # reservations to attach. To attach existing reservations, specify
        # theexistingReservations property instead.
        # Corresponds to the JSON property `reservations`
        # @return [Array<Google::Apis::ComputeV1::Reservation>]
        attr_accessor :reservations
      
        # [Output Only] Contains output only fields.
        # Corresponds to the JSON property `resourceStatus`
        # @return [Google::Apis::ComputeV1::CommitmentResourceStatus]
        attr_accessor :resource_status
      
        # The list of all the hardware resources, with their types and amounts, that
        # you want to commit to. Specify as a separate entry in the list for each
        # individual resource type.
        # Corresponds to the JSON property `resources`
        # @return [Array<Google::Apis::ComputeV1::ResourceCommitment>]
        attr_accessor :resources
      
        # Output only. [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # The source commitment from which you are transferring resources to create
        # the new split commitment. For more information, see
        # Split commitments.
        # Corresponds to the JSON property `splitSourceCommitment`
        # @return [String]
        attr_accessor :split_source_commitment
      
        # Output only. [Output Only] Commitment start time inRFC3339
        # text format.
        # Corresponds to the JSON property `startTimestamp`
        # @return [String]
        attr_accessor :start_timestamp
      
        # Output only. [Output Only] Status of the commitment with regards to eventual
        # expiration
        # (each commitment has an end date defined). Status can be one of the
        # following values: NOT_YET_ACTIVE, ACTIVE, orEXPIRED.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # Output only. [Output Only] An optional, human-readable explanation of the
        # status.
        # Corresponds to the JSON property `statusMessage`
        # @return [String]
        attr_accessor :status_message
      
        # The type of commitment; specifies the
        # machine series for which you want to commit to purchasing resources.
        # The choice of machine series affects the discount rate and the eligible
        # resource types.
        # The type must be one of the following:ACCELERATOR_OPTIMIZED,
        # ACCELERATOR_OPTIMIZED_A3,ACCELERATOR_OPTIMIZED_A3_MEGA,COMPUTE_OPTIMIZED,
        # COMPUTE_OPTIMIZED_C2D,
        # COMPUTE_OPTIMIZED_C3, COMPUTE_OPTIMIZED_C3D,COMPUTE_OPTIMIZED_H3,
        # GENERAL_PURPOSE,GENERAL_PURPOSE_C4, GENERAL_PURPOSE_E2,GENERAL_PURPOSE_N2,
        # GENERAL_PURPOSE_N2D,GENERAL_PURPOSE_N4, GENERAL_PURPOSE_T2D,GRAPHICS_OPTIMIZED,
        # GRAPHICS_OPTIMIZED_G4,MEMORY_OPTIMIZED, MEMORY_OPTIMIZED_M3,
        # MEMORY_OPTIMIZED_X4, STORAGE_OPTIMIZED_Z3. For
        # example, type MEMORY_OPTIMIZED specifies a commitment that
        # applies only to eligible resources of memory optimized M1 and M2 machine
        # series. Type GENERAL_PURPOSE specifies a commitment that
        # applies only to eligible resources of general purpose N1 machine series.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @auto_renew = args[:auto_renew] if args.key?(:auto_renew)
          @category = args[:category] if args.key?(:category)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @custom_end_timestamp = args[:custom_end_timestamp] if args.key?(:custom_end_timestamp)
          @description = args[:description] if args.key?(:description)
          @end_timestamp = args[:end_timestamp] if args.key?(:end_timestamp)
          @existing_reservations = args[:existing_reservations] if args.key?(:existing_reservations)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @license_resource = args[:license_resource] if args.key?(:license_resource)
          @merge_source_commitments = args[:merge_source_commitments] if args.key?(:merge_source_commitments)
          @name = args[:name] if args.key?(:name)
          @plan = args[:plan] if args.key?(:plan)
          @region = args[:region] if args.key?(:region)
          @reservations = args[:reservations] if args.key?(:reservations)
          @resource_status = args[:resource_status] if args.key?(:resource_status)
          @resources = args[:resources] if args.key?(:resources)
          @self_link = args[:self_link] if args.key?(:self_link)
          @split_source_commitment = args[:split_source_commitment] if args.key?(:split_source_commitment)
          @start_timestamp = args[:start_timestamp] if args.key?(:start_timestamp)
          @status = args[:status] if args.key?(:status)
          @status_message = args[:status_message] if args.key?(:status_message)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # 
      class CommitmentAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of CommitmentsScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeV1::CommitmentsScopedList>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Alwayscompute#
        # commitmentAggregatedList for aggregated lists of
        # commitments.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Unreachable resources.
        # Corresponds to the JSON property `unreachables`
        # @return [Array<String>]
        attr_accessor :unreachables
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::CommitmentAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @unreachables = args[:unreachables] if args.key?(:unreachables)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::CommitmentAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of Commitment resources.
      class CommitmentList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Commitment resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::Commitment>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Always compute#commitmentList
        # for lists of commitments.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::CommitmentList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::CommitmentList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # [Output Only] Contains output only fields.
      class CommitmentResourceStatus
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Indicates the end time of customer's eligibility to
        # send
        # custom term requests in RFC3339 text format. Term extension requests that
        # (not the end time in the request) after this time will be rejected.
        # Corresponds to the JSON property `customTermEligibilityEndTimestamp`
        # @return [String]
        attr_accessor :custom_term_eligibility_end_timestamp
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @custom_term_eligibility_end_timestamp = args[:custom_term_eligibility_end_timestamp] if args.key?(:custom_term_eligibility_end_timestamp)
        end
      end
      
      # 
      class CommitmentsScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] The list of commitments contained in this scope.
        # Corresponds to the JSON property `commitments`
        # @return [Array<Google::Apis::ComputeV1::Commitment>]
        attr_accessor :commitments
      
        # [Output Only] Informational warning which replaces the list of commitments
        # when the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::CommitmentsScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @commitments = args[:commitments] if args.key?(:commitments)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning which replaces the list of commitments
        # when the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::CommitmentsScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # A set of Confidential Instance options.
      class ConfidentialInstanceConfig
        include Google::Apis::Core::Hashable
      
        # Defines the type of technology used by the confidential instance.
        # Corresponds to the JSON property `confidentialInstanceType`
        # @return [String]
        attr_accessor :confidential_instance_type
      
        # Defines whether the instance should have confidential compute enabled.
        # Corresponds to the JSON property `enableConfidentialCompute`
        # @return [Boolean]
        attr_accessor :enable_confidential_compute
        alias_method :enable_confidential_compute?, :enable_confidential_compute
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @confidential_instance_type = args[:confidential_instance_type] if args.key?(:confidential_instance_type)
          @enable_confidential_compute = args[:enable_confidential_compute] if args.key?(:enable_confidential_compute)
        end
      end
      
      # Message containing connection draining configuration.
      class ConnectionDraining
        include Google::Apis::Core::Hashable
      
        # Configures a duration timeout for existing requests on a removed backend
        # instance. For supported load balancers and protocols, as described inEnabling
        # connection draining.
        # Corresponds to the JSON property `drainingTimeoutSec`
        # @return [Fixnum]
        attr_accessor :draining_timeout_sec
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @draining_timeout_sec = args[:draining_timeout_sec] if args.key?(:draining_timeout_sec)
        end
      end
      
      # This message defines settings for a consistent hash style load balancer.
      class ConsistentHashLoadBalancerSettings
        include Google::Apis::Core::Hashable
      
        # The information about the HTTP Cookie on which the hash function is based
        # for load balancing policies that use a consistent hash.
        # Corresponds to the JSON property `httpCookie`
        # @return [Google::Apis::ComputeV1::ConsistentHashLoadBalancerSettingsHttpCookie]
        attr_accessor :http_cookie
      
        # The hash based on the value of the specified header field. This field is
        # applicable if the sessionAffinity is set toHEADER_FIELD.
        # Corresponds to the JSON property `httpHeaderName`
        # @return [String]
        attr_accessor :http_header_name
      
        # The minimum number of virtual nodes to use for the hash ring. Defaults to
        # 1024. Larger ring sizes result in more granular load distributions. If the
        # number of hosts in the load balancing pool is larger than the ring size,
        # each host will be assigned a single virtual node.
        # Corresponds to the JSON property `minimumRingSize`
        # @return [Fixnum]
        attr_accessor :minimum_ring_size
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @http_cookie = args[:http_cookie] if args.key?(:http_cookie)
          @http_header_name = args[:http_header_name] if args.key?(:http_header_name)
          @minimum_ring_size = args[:minimum_ring_size] if args.key?(:minimum_ring_size)
        end
      end
      
      # The information about the HTTP Cookie on which the hash function is based
      # for load balancing policies that use a consistent hash.
      class ConsistentHashLoadBalancerSettingsHttpCookie
        include Google::Apis::Core::Hashable
      
        # Name of the cookie.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Path to set for the cookie.
        # Corresponds to the JSON property `path`
        # @return [String]
        attr_accessor :path
      
        # A Duration represents a fixed-length span of time represented
        # as a count of seconds and fractions of seconds at nanosecond
        # resolution. It is independent of any calendar and concepts like "day"
        # or "month". Range is approximately 10,000 years.
        # Corresponds to the JSON property `ttl`
        # @return [Google::Apis::ComputeV1::Duration]
        attr_accessor :ttl
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @name = args[:name] if args.key?(:name)
          @path = args[:path] if args.key?(:path)
          @ttl = args[:ttl] if args.key?(:ttl)
        end
      end
      
      # The specification for allowing client-side cross-origin requests. For more
      # information about the W3C recommendation for cross-origin resource sharing
      # (CORS), see Fetch API Living
      # Standard.
      class CorsPolicy
        include Google::Apis::Core::Hashable
      
        # In response to a preflight request, setting this to true
        # indicates that
        # the actual request can include user credentials. This field translates to
        # the Access-Control-Allow-Credentials header.
        # Default is false.
        # Corresponds to the JSON property `allowCredentials`
        # @return [Boolean]
        attr_accessor :allow_credentials
        alias_method :allow_credentials?, :allow_credentials
      
        # Specifies the content for the Access-Control-Allow-Headers
        # header.
        # Corresponds to the JSON property `allowHeaders`
        # @return [Array<String>]
        attr_accessor :allow_headers
      
        # Specifies the content for the Access-Control-Allow-Methods
        # header.
        # Corresponds to the JSON property `allowMethods`
        # @return [Array<String>]
        attr_accessor :allow_methods
      
        # Specifies a regular expression that matches allowed origins. For
        # more information, see regular expression syntax.
        # An origin is allowed if it matches either an item inallowOrigins or an item
        # inallowOriginRegexes.
        # Regular expressions can only be used when the loadBalancingScheme is
        # set to INTERNAL_SELF_MANAGED.
        # Corresponds to the JSON property `allowOriginRegexes`
        # @return [Array<String>]
        attr_accessor :allow_origin_regexes
      
        # Specifies the list of origins that is allowed to do CORS requests.
        # An origin is allowed if it matches either an item inallowOrigins or an item
        # inallowOriginRegexes.
        # Corresponds to the JSON property `allowOrigins`
        # @return [Array<String>]
        attr_accessor :allow_origins
      
        # If true, disables the CORS policy.
        # The default value is false, which indicates that the CORS
        # policy is in effect.
        # Corresponds to the JSON property `disabled`
        # @return [Boolean]
        attr_accessor :disabled
        alias_method :disabled?, :disabled
      
        # Specifies the content for the Access-Control-Expose-Headers
        # header.
        # Corresponds to the JSON property `exposeHeaders`
        # @return [Array<String>]
        attr_accessor :expose_headers
      
        # Specifies how long results of a preflight request can be cached in
        # seconds. This field translates to the Access-Control-Max-Age
        # header.
        # Corresponds to the JSON property `maxAge`
        # @return [Fixnum]
        attr_accessor :max_age
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @allow_credentials = args[:allow_credentials] if args.key?(:allow_credentials)
          @allow_headers = args[:allow_headers] if args.key?(:allow_headers)
          @allow_methods = args[:allow_methods] if args.key?(:allow_methods)
          @allow_origin_regexes = args[:allow_origin_regexes] if args.key?(:allow_origin_regexes)
          @allow_origins = args[:allow_origins] if args.key?(:allow_origins)
          @disabled = args[:disabled] if args.key?(:disabled)
          @expose_headers = args[:expose_headers] if args.key?(:expose_headers)
          @max_age = args[:max_age] if args.key?(:max_age)
        end
      end
      
      # A resource that represents a cross-site network.
      # You can use cross-site networks to connect your on-premises networks to
      # each other through Interconnect connections.
      class CrossSiteNetwork
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of the cross-site network.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Output only. [Output Only] The unique identifier for the resource type. The
        # server
        # generates this identifier.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. [Output Only] Type of the resource. Alwayscompute#
        # crossSiteNetwork for cross-site networks.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource. Provided by the client when the resource is created.
        # The name must be 1-63 characters long, and comply withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must
        # be a dash, lowercase letter, or digit, except the last character, which
        # cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Output only. [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @self_link = args[:self_link] if args.key?(:self_link)
        end
      end
      
      # Response to the list request that contains a list of cross-site networks.
      class CrossSiteNetworkList
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `etag`
        # @return [String]
        attr_accessor :etag
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of CrossSiteNetwork resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::CrossSiteNetwork>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of the resource. Alwayscompute#
        # crossSiteNetwork for cross-site networks.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Unreachable resources.
        # end_interface: MixerListResponseWithEtagBuilder
        # Corresponds to the JSON property `unreachables`
        # @return [Array<String>]
        attr_accessor :unreachables
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::CrossSiteNetworkList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @etag = args[:etag] if args.key?(:etag)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @unreachables = args[:unreachables] if args.key?(:unreachables)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::CrossSiteNetworkList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Specifies the custom error response policy that must be applied when the
      # backend service or backend bucket responds with an error.
      class CustomErrorResponsePolicy
        include Google::Apis::Core::Hashable
      
        # Specifies rules for returning error responses.
        # In a given policy, if you specify rules for both a range of error codes
        # as well as rules for specific error codes then rules with specific error
        # codes have a higher priority. For example, assume that you configure a rule
        # for 401 (Un-authorized) code, and another for all 4 series
        # error codes (4XX). If the backend service returns a401, then the rule for 401
        # will be applied.
        # However if the backend service returns a 403, the rule for4xx takes effect.
        # Corresponds to the JSON property `errorResponseRules`
        # @return [Array<Google::Apis::ComputeV1::CustomErrorResponsePolicyCustomErrorResponseRule>]
        attr_accessor :error_response_rules
      
        # The full or partial URL to the BackendBucket resource that
        # contains the custom error content. Examples are:
        # 
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/global/
        # backendBuckets/myBackendBucket
        # - compute/v1/projects/project/global/backendBuckets/myBackendBucket
        # - global/backendBuckets/myBackendBucket
        # If errorService is not specified at lower levels likepathMatcher, pathRule and
        # routeRule,
        # an errorService specified at a higher level in theUrlMap will be used.
        # IfUrlMap.defaultCustomErrorResponsePolicy contains one or
        # moreerrorResponseRules[], it must specifyerrorService.
        # If load balancer cannot reach
        # the backendBucket, a simple Not Found Error will
        # be returned, with the original response code (oroverrideResponseCode if
        # configured).
        # errorService is not supported for internal or regionalHTTP/HTTPS load
        # balancers.
        # Corresponds to the JSON property `errorService`
        # @return [String]
        attr_accessor :error_service
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @error_response_rules = args[:error_response_rules] if args.key?(:error_response_rules)
          @error_service = args[:error_service] if args.key?(:error_service)
        end
      end
      
      # Specifies the mapping between the response code that will be returned along
      # with the custom error content and the response code returned by the backend
      # service.
      class CustomErrorResponsePolicyCustomErrorResponseRule
        include Google::Apis::Core::Hashable
      
        # Valid values include:
        # 
        # 
        # - A number between 400 and 599: For example
        # 401 or 503, in which case the load balancer
        # applies the policy if the error code exactly matches this value.
        # - 5xx: Load Balancer will apply the policy if the
        # backend service responds with any response code in the range of
        # 500 to 599.
        # - 4xx: Load
        # Balancer will apply the policy if the backend service responds with any
        # response code in the range of 400 to
        # 499.
        # Values must be unique within matchResponseCodes and across
        # allerrorResponseRules ofCustomErrorResponsePolicy.
        # Corresponds to the JSON property `matchResponseCodes`
        # @return [Array<String>]
        attr_accessor :match_response_codes
      
        # The HTTP status code returned with the response containing the custom
        # error content. If overrideResponseCode is not supplied, the
        # same response code returned by the original backend bucket or backend
        # service is returned to the client.
        # Corresponds to the JSON property `overrideResponseCode`
        # @return [Fixnum]
        attr_accessor :override_response_code
      
        # The full path to a file within backendBucket . For example:/errors/
        # defaultError.html
        # path must start
        # with a leading slash. path cannot have trailing slashes.
        # If the file is not available in backendBucket  or the
        # load balancer cannot reach the BackendBucket, a simpleNot Found Error is
        # returned to the client.
        # The value must
        # be from 1 to 1024 characters
        # Corresponds to the JSON property `path`
        # @return [String]
        attr_accessor :path
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @match_response_codes = args[:match_response_codes] if args.key?(:match_response_codes)
          @override_response_code = args[:override_response_code] if args.key?(:override_response_code)
          @path = args[:path] if args.key?(:path)
        end
      end
      
      # 
      class CustomerEncryptionKey
        include Google::Apis::Core::Hashable
      
        # The name of the encryption key that is stored in Google Cloud KMS.
        # For example:
        # "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/
        # key_region/cryptoKeys/key
        # The fully-qualifed key name may be returned for resource GET requests. For
        # example:
        # "kmsKeyName": "projects/kms_project_id/locations/region/keyRings/
        # key_region/cryptoKeys/key
        # /cryptoKeyVersions/1
        # Corresponds to the JSON property `kmsKeyName`
        # @return [String]
        attr_accessor :kms_key_name
      
        # The service account being used for the encryption request for the given KMS
        # key. If absent, the Compute Engine default service account is used.
        # For example:
        # "kmsKeyServiceAccount": "name@project_id.iam.gserviceaccount.com/
        # Corresponds to the JSON property `kmsKeyServiceAccount`
        # @return [String]
        attr_accessor :kms_key_service_account
      
        # Specifies a 256-bit customer-supplied
        # encryption key, encoded in RFC
        # 4648 base64 to either encrypt or decrypt this resource. You can
        # provide either the rawKey or thersaEncryptedKey.
        # For example:
        # "rawKey":
        # "SGVsbG8gZnJvbSBHb29nbGUgQ2xvdWQgUGxhdGZvcm0="
        # Corresponds to the JSON property `rawKey`
        # @return [String]
        attr_accessor :raw_key
      
        # Specifies an RFC 4648 base64 encoded, RSA-wrapped 2048-bit
        # customer-supplied encryption key to either encrypt or decrypt this
        # resource. You can provide either the rawKey or thersaEncryptedKey.
        # For example:
        # "rsaEncryptedKey":
        # "ieCx/NcW06PcT7Ep1X6LUTc/hLvUDYyzSZPPVCVPTVEohpeHASqC8uw5TzyO9U+Fka9JFH
        # z0mBibXUInrC/jEk014kCK/NPjYgEMOyssZ4ZINPKxlUh2zn1bV+MCaTICrdmuSBTWlUUiFoD
        # D6PYznLwh8ZNdaheCeZ8ewEXgFQ8V+sDroLaN3Xs3MDTXQEMMoNUXMCZEIpg9Vtp9x2oe=="
        # The key must meet the following requirements before you can provide it to
        # Compute Engine:
        # 
        # 1. The key is wrapped using a RSA public key certificate provided by
        # Google.
        # 2. After being wrapped, the key must be encoded in RFC 4648 base64
        # encoding.
        # Gets the RSA public key certificate provided by Google at:
        # https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem
        # Corresponds to the JSON property `rsaEncryptedKey`
        # @return [String]
        attr_accessor :rsa_encrypted_key
      
        # [Output only] TheRFC
        # 4648 base64 encoded SHA-256 hash of the customer-supplied
        # encryption key that protects this resource.
        # Corresponds to the JSON property `sha256`
        # @return [String]
        attr_accessor :sha256
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @kms_key_name = args[:kms_key_name] if args.key?(:kms_key_name)
          @kms_key_service_account = args[:kms_key_service_account] if args.key?(:kms_key_service_account)
          @raw_key = args[:raw_key] if args.key?(:raw_key)
          @rsa_encrypted_key = args[:rsa_encrypted_key] if args.key?(:rsa_encrypted_key)
          @sha256 = args[:sha256] if args.key?(:sha256)
        end
      end
      
      # 
      class CustomerEncryptionKeyProtectedDisk
        include Google::Apis::Core::Hashable
      
        # Decrypts data associated with the disk with acustomer-supplied
        # encryption key.
        # Corresponds to the JSON property `diskEncryptionKey`
        # @return [Google::Apis::ComputeV1::CustomerEncryptionKey]
        attr_accessor :disk_encryption_key
      
        # Specifies a valid partial or full URL to an existing Persistent Disk
        # resource. This field is only applicable for persistent disks.
        # For example:
        # "source": "/compute/v1/projects/project_id/zones/zone/disks/
        # disk_name
        # Corresponds to the JSON property `source`
        # @return [String]
        attr_accessor :source
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @disk_encryption_key = args[:disk_encryption_key] if args.key?(:disk_encryption_key)
          @source = args[:source] if args.key?(:source)
        end
      end
      
      # Represents a whole or partial calendar date, such as a birthday. The time of
      # day and time zone are either specified elsewhere or are insignificant. The
      # date is relative to the Gregorian Calendar. This can represent one of the
      # following:
      # * A full date, with non-zero year, month, and day values.
      # * A month and day, with a zero year (for example, an anniversary).
      # * A year on its own, with a zero month and a zero day.
      # * A year and month, with a zero day (for example, a credit card expiration
      # date).
      # Related types:
      # * google.type.TimeOfDay
      # * google.type.DateTime
      # * google.protobuf.Timestamp
      class Date
        include Google::Apis::Core::Hashable
      
        # Day of a month. Must be from 1 to 31 and valid for the year and month, or 0
        # to specify a year by itself or a year and month where the day isn't
        # significant.
        # Corresponds to the JSON property `day`
        # @return [Fixnum]
        attr_accessor :day
      
        # Month of a year. Must be from 1 to 12, or 0 to specify a year without a
        # month and day.
        # Corresponds to the JSON property `month`
        # @return [Fixnum]
        attr_accessor :month
      
        # Year of the date. Must be from 1 to 9999, or 0 to specify a date without
        # a year.
        # Corresponds to the JSON property `year`
        # @return [Fixnum]
        attr_accessor :year
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @day = args[:day] if args.key?(:day)
          @month = args[:month] if args.key?(:month)
          @year = args[:year] if args.key?(:year)
        end
      end
      
      # Deprecation status for a public resource.
      class DeprecationStatus
        include Google::Apis::Core::Hashable
      
        # An optional RFC3339 timestamp on or after which the state of this
        # resource is intended to change to DELETED. This is only
        # informational and the status will not change unless the client explicitly
        # changes it.
        # Corresponds to the JSON property `deleted`
        # @return [String]
        attr_accessor :deleted
      
        # An optional RFC3339 timestamp on or after which the state of this
        # resource is intended to change to DEPRECATED. This is only
        # informational and the status will not change unless the client explicitly
        # changes it.
        # Corresponds to the JSON property `deprecated`
        # @return [String]
        attr_accessor :deprecated
      
        # An optional RFC3339 timestamp on or after which the state of this
        # resource is intended to change to OBSOLETE. This is only
        # informational and the status will not change unless the client explicitly
        # changes it.
        # Corresponds to the JSON property `obsolete`
        # @return [String]
        attr_accessor :obsolete
      
        # The URL of the suggested replacement for a deprecated resource.
        # The suggested replacement resource must be the same kind of resource as the
        # deprecated resource.
        # Corresponds to the JSON property `replacement`
        # @return [String]
        attr_accessor :replacement
      
        # The deprecation state of this resource. This can be ACTIVE,DEPRECATED,
        # OBSOLETE, or DELETED.
        # Operations which communicate the end of life date for an image, can useACTIVE.
        # Operations which create a new resource using aDEPRECATED resource will return
        # successfully, but with a
        # warning indicating the deprecated resource and recommending its
        # replacement. Operations which use OBSOLETE orDELETED resources will be
        # rejected and result in an error.
        # Corresponds to the JSON property `state`
        # @return [String]
        attr_accessor :state
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @deleted = args[:deleted] if args.key?(:deleted)
          @deprecated = args[:deprecated] if args.key?(:deprecated)
          @obsolete = args[:obsolete] if args.key?(:obsolete)
          @replacement = args[:replacement] if args.key?(:replacement)
          @state = args[:state] if args.key?(:state)
        end
      end
      
      # Represents a Persistent Disk resource.
      # Google Compute Engine has two Disk resources:
      # * [Zonal](/compute/docs/reference/rest/v1/disks)
      # * [Regional](/compute/docs/reference/rest/v1/regionDisks)
      # Persistent disks are required for running your VM instances.
      # Create both boot and non-boot (data) persistent disks. For more information,
      # read Persistent Disks. For more
      # storage options, read Storage options.
      # The disks resource represents a zonal persistent disk.
      # For more information, readZonal persistent disks.
      # The regionDisks resource represents a
      # regional persistent disk.  For more information, read
      # Regional resources.
      class Disk
        include Google::Apis::Core::Hashable
      
        # The access mode of the disk.
        # 
        # 
        # - READ_WRITE_SINGLE: The default AccessMode, means the
        # disk can be attached to single instance in RW mode.
        # - READ_WRITE_MANY: The AccessMode means the disk can be
        # attached to multiple instances in RW mode.
        # - READ_ONLY_MANY: The AccessMode means the disk can be
        # attached to multiple instances in RO mode.
        # The AccessMode is only valid for Hyperdisk disk types.
        # Corresponds to the JSON property `accessMode`
        # @return [String]
        attr_accessor :access_mode
      
        # The architecture of the disk. Valid values are
        # ARM64 or X86_64.
        # Corresponds to the JSON property `architecture`
        # @return [String]
        attr_accessor :architecture
      
        # Disk asynchronously replicated into this disk.
        # Corresponds to the JSON property `asyncPrimaryDisk`
        # @return [Google::Apis::ComputeV1::DiskAsyncReplication]
        attr_accessor :async_primary_disk
      
        # Output only. [Output Only] A list of disks this disk is asynchronously
        # replicated to.
        # Corresponds to the JSON property `asyncSecondaryDisks`
        # @return [Hash<String,Google::Apis::ComputeV1::DiskAsyncReplicationList>]
        attr_accessor :async_secondary_disks
      
        # Output only. [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Encrypts the disk using a
        # customer-supplied encryption key or a
        # customer-managed encryption key.
        # Encryption keys do not protect access to metadata of the disk.
        # After you encrypt a disk with a customer-supplied key, you must provide the
        # same key if you use the disk later. For example, to create a disk snapshot,
        # to create a disk image, to create a machine image, or to attach the disk to
        # a virtual machine.
        # After you encrypt a disk with a customer-managed key, thediskEncryptionKey.
        # kmsKeyName is set to a key *version*
        # name once the disk is created. The disk is encrypted with this version of
        # the key. In the response, diskEncryptionKey.kmsKeyName appears
        # in the following format:
        # "diskEncryptionKey.kmsKeyName":
        # "projects/kms_project_id/locations/region/keyRings/
        # key_region/cryptoKeys/key
        # /cryptoKeysVersions/version
        # If you do not provide an encryption key when creating the disk, then the
        # disk is encrypted using an automatically generated key and you don't need
        # to provide a key to use the disk later.
        # Corresponds to the JSON property `diskEncryptionKey`
        # @return [Google::Apis::ComputeV1::CustomerEncryptionKey]
        attr_accessor :disk_encryption_key
      
        # Whether this disk is using confidential compute mode.
        # Corresponds to the JSON property `enableConfidentialCompute`
        # @return [Boolean]
        attr_accessor :enable_confidential_compute
        alias_method :enable_confidential_compute?, :enable_confidential_compute
      
        # A list of features to enable on the guest operating system. Applicable
        # only for bootable images. Read
        # Enabling guest operating system features to see a list of available
        # options.
        # Corresponds to the JSON property `guestOsFeatures`
        # @return [Array<Google::Apis::ComputeV1::GuestOsFeature>]
        attr_accessor :guest_os_features
      
        # Output only. [Output Only] The unique identifier for the resource. This
        # identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. [Output Only] Type of the resource. Always compute#disk for
        # disks.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # A fingerprint for the labels being applied to this disk, which is
        # essentially a hash of the labels set used for optimistic locking. The
        # fingerprint is initially generated by Compute Engine and changes after
        # every request to modify or update labels. You must always provide an
        # up-to-date fingerprint hash in order to update or change labels,
        # otherwise the request will fail with error412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to
        # retrieve a disk.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # Labels to apply to this disk. These can be later modified by
        # the setLabels method.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # Output only. [Output Only] Last attach timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `lastAttachTimestamp`
        # @return [String]
        attr_accessor :last_attach_timestamp
      
        # Output only. [Output Only] Last detach timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `lastDetachTimestamp`
        # @return [String]
        attr_accessor :last_detach_timestamp
      
        # Integer license codes indicating which licenses are attached to this disk.
        # Corresponds to the JSON property `licenseCodes`
        # @return [Array<Fixnum>]
        attr_accessor :license_codes
      
        # A list of publicly visible licenses. Reserved for Google's use.
        # Corresponds to the JSON property `licenses`
        # @return [Array<String>]
        attr_accessor :licenses
      
        # An opaque location hint used to place the disk close to other resources.
        # This field is for use by internal tools that use the public API.
        # Corresponds to the JSON property `locationHint`
        # @return [String]
        attr_accessor :location_hint
      
        # Name of the resource. Provided by the client when the resource is created.
        # The name must be 1-63 characters long, and comply withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?`
        # which means the first character must be a lowercase letter, and all
        # following characters must be a dash, lowercase letter, or digit, except
        # the last character, which cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Internal use only.
        # Corresponds to the JSON property `options`
        # @return [String]
        attr_accessor :options
      
        # Additional disk params.
        # Corresponds to the JSON property `params`
        # @return [Google::Apis::ComputeV1::DiskParams]
        attr_accessor :params
      
        # Physical block size of the persistent disk, in bytes.
        # If not present in a request, a default value is used.
        # The currently supported size is 4096, other sizes may be added in
        # the future.
        # If an unsupported value is requested, the error message will list
        # the supported values for the caller's project.
        # Corresponds to the JSON property `physicalBlockSizeBytes`
        # @return [Fixnum]
        attr_accessor :physical_block_size_bytes
      
        # Indicates how many IOPS to provision for the disk. This sets the number
        # of I/O operations per second that the disk can handle. Values must be
        # between 10,000 and 120,000. For more details, see theExtreme persistent
        # disk documentation.
        # Corresponds to the JSON property `provisionedIops`
        # @return [Fixnum]
        attr_accessor :provisioned_iops
      
        # Indicates how much throughput to provision for the disk. This sets the
        # number of throughput mb per second that the disk can handle. Values must be
        # greater than or equal to 1.
        # Corresponds to the JSON property `provisionedThroughput`
        # @return [Fixnum]
        attr_accessor :provisioned_throughput
      
        # Output only. [Output Only] URL of the region where the disk resides. Only
        # applicable for
        # regional resources.
        # You must specify this field as part of the HTTP request URL. It is
        # not settable as a field in the request body.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # URLs of the zones where the disk should be replicated to. Only applicable
        # for regional resources.
        # Corresponds to the JSON property `replicaZones`
        # @return [Array<String>]
        attr_accessor :replica_zones
      
        # Resource policies applied to this disk for automatic snapshot creations.
        # Corresponds to the JSON property `resourcePolicies`
        # @return [Array<String>]
        attr_accessor :resource_policies
      
        # Output only. [Output Only] Status information for the disk resource.
        # Corresponds to the JSON property `resourceStatus`
        # @return [Google::Apis::ComputeV1::DiskResourceStatus]
        attr_accessor :resource_status
      
        # Output only. Reserved for future use.
        # Corresponds to the JSON property `satisfiesPzi`
        # @return [Boolean]
        attr_accessor :satisfies_pzi
        alias_method :satisfies_pzi?, :satisfies_pzi
      
        # Output only. [Output Only] Reserved for future use.
        # Corresponds to the JSON property `satisfiesPzs`
        # @return [Boolean]
        attr_accessor :satisfies_pzs
        alias_method :satisfies_pzs?, :satisfies_pzs
      
        # Output only. [Output Only] Server-defined fully-qualified URL for this
        # resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Size, in GB, of the persistent disk. You can specify
        # this field when creating a persistent disk using thesourceImage,
        # sourceSnapshot, orsourceDisk parameter, or specify it alone to create an empty
        # persistent disk.
        # If you specify this field along with a source, the value ofsizeGb must not be
        # less than the size of the
        # source.
        # Acceptable values are greater than 0.
        # Corresponds to the JSON property `sizeGb`
        # @return [Fixnum]
        attr_accessor :size_gb
      
        # Output only. [Output Only] URL of the DiskConsistencyGroupPolicy for a
        # secondary disk
        # that was created using a consistency group.
        # Corresponds to the JSON property `sourceConsistencyGroupPolicy`
        # @return [String]
        attr_accessor :source_consistency_group_policy
      
        # Output only. [Output Only] ID of the DiskConsistencyGroupPolicy for a
        # secondary disk
        # that was created using a consistency group.
        # Corresponds to the JSON property `sourceConsistencyGroupPolicyId`
        # @return [String]
        attr_accessor :source_consistency_group_policy_id
      
        # The source disk used to create this disk. You can provide this as a
        # partial or full URL to the resource. For example, the following are valid
        # values:
        # 
        # 
        # -
        # https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/
        # disk
        # 
        # -
        # https://www.googleapis.com/compute/v1/projects/project/regions/region/
        # disks/disk
        # 
        # -
        # projects/project/zones/zone/disks/disk
        # 
        # -
        # projects/project/regions/region/disks/disk
        # 
        # -
        # zones/zone/disks/disk
        # 
        # -
        # regions/region/disks/disk
        # Corresponds to the JSON property `sourceDisk`
        # @return [String]
        attr_accessor :source_disk
      
        # Output only. [Output Only] The unique ID of the disk used to create this disk.
        # This
        # value identifies the exact disk that was used to create this persistent
        # disk. For example, if you created the persistent disk from a disk that
        # was later deleted and recreated under the same name, the source disk ID
        # would identify the exact version of the disk that was used.
        # Corresponds to the JSON property `sourceDiskId`
        # @return [String]
        attr_accessor :source_disk_id
      
        # The source image used to create this disk. If the source image is
        # deleted, this field will not be set.
        # To create a disk with one of the public operating system images, specify
        # the image by its family name. For example, specifyfamily/debian-9 to use the
        # latest Debian 9 image:
        # projects/debian-cloud/global/images/family/debian-9
        # Alternatively, use a specific version of a public operating system image:
        # projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
        # To create a disk with a custom image that you created, specify the
        # image name in the following format:
        # global/images/my-custom-image
        # You can also specify a custom image by its image family, which returns
        # the latest version of the image in that family. Replace the image name
        # with family/family-name:
        # global/images/family/my-image-family
        # Corresponds to the JSON property `sourceImage`
        # @return [String]
        attr_accessor :source_image
      
        # Thecustomer-supplied
        # encryption key of the source image. Required if the source image is
        # protected by a customer-supplied encryption key.
        # Corresponds to the JSON property `sourceImageEncryptionKey`
        # @return [Google::Apis::ComputeV1::CustomerEncryptionKey]
        attr_accessor :source_image_encryption_key
      
        # Output only. [Output Only] The ID value of the image used to create this disk.
        # This
        # value identifies the exact image that was used to create this persistent
        # disk. For example, if you created the persistent disk from an image that
        # was later deleted and recreated under the same name, the source image ID
        # would identify the exact version of the image that was used.
        # Corresponds to the JSON property `sourceImageId`
        # @return [String]
        attr_accessor :source_image_id
      
        # The source instant snapshot used to create this disk. You can provide
        # this as a partial or full URL to the resource. For example, the following
        # are valid values:
        # 
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone/
        # instantSnapshots/instantSnapshot
        # - projects/project/zones/zone/instantSnapshots/instantSnapshot
        # - zones/zone/instantSnapshots/instantSnapshot
        # Corresponds to the JSON property `sourceInstantSnapshot`
        # @return [String]
        attr_accessor :source_instant_snapshot
      
        # Output only. [Output Only] The unique ID of the instant snapshot used to
        # create this
        # disk. This value identifies the exact instant snapshot that was used to
        # create this persistent disk. For example, if you created the persistent
        # disk from an instant snapshot that was later deleted and recreated under
        # the same name, the source instant snapshot ID would identify the exact
        # version of the instant snapshot that was used.
        # Corresponds to the JSON property `sourceInstantSnapshotId`
        # @return [String]
        attr_accessor :source_instant_snapshot_id
      
        # The source snapshot used to create this disk. You can provide this as a
        # partial or full URL to the resource. For example, the following are valid
        # values:
        # 
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/global/snapshots/
        # snapshot
        # - projects/project/global/snapshots/snapshot
        # - global/snapshots/snapshot
        # Corresponds to the JSON property `sourceSnapshot`
        # @return [String]
        attr_accessor :source_snapshot
      
        # Thecustomer-supplied
        # encryption key of the source snapshot. Required if the source snapshot
        # is protected by a customer-supplied encryption key.
        # Corresponds to the JSON property `sourceSnapshotEncryptionKey`
        # @return [Google::Apis::ComputeV1::CustomerEncryptionKey]
        attr_accessor :source_snapshot_encryption_key
      
        # Output only. [Output Only] The unique ID of the snapshot used to create this
        # disk. This
        # value identifies the exact snapshot that was used to create this persistent
        # disk. For example, if you created the persistent disk from a snapshot that
        # was later deleted and recreated under the same name, the source snapshot ID
        # would identify the exact version of the snapshot that was used.
        # Corresponds to the JSON property `sourceSnapshotId`
        # @return [String]
        attr_accessor :source_snapshot_id
      
        # The full Google Cloud Storage URI where the disk image is stored. This file
        # must be a gzip-compressed tarball whose name ends in .tar.gz or virtual
        # machine disk whose name ends in vmdk. Valid URIs may start with gs:// or
        # https://storage.googleapis.com/. This flag is not optimized for creating
        # multiple disks from a source storage object. To create many disks from a
        # source storage object, use gcloud compute images
        # import instead.
        # Corresponds to the JSON property `sourceStorageObject`
        # @return [String]
        attr_accessor :source_storage_object
      
        # Output only. [Output Only] The status of disk creation.
        # 
        # 
        # - CREATING: Disk is provisioning.
        # - RESTORING: Source data is being copied into the
        # disk.
        # - FAILED: Disk creation failed.
        # - READY: Disk is ready for use.
        # - DELETING: Disk is deleting.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # The storage pool in which the new disk is created. You can provide
        # this as a partial or full URL to the resource. For example, the following
        # are valid values:
        # 
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone/
        # storagePools/storagePool
        # - projects/project/zones/zone/storagePools/storagePool
        # - zones/zone/storagePools/storagePool
        # Corresponds to the JSON property `storagePool`
        # @return [String]
        attr_accessor :storage_pool
      
        # URL of the disk type resource describing which disk type to use to create
        # the disk. Provide this when creating the disk. For example:projects/project/
        # zones/zone/diskTypes/pd-ssd. See Persistent disk
        # types.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        # Output only. [Output Only] Links to the users of the disk (attached instances)
        # in form:projects/project/zones/zone/instances/instance
        # Corresponds to the JSON property `users`
        # @return [Array<String>]
        attr_accessor :users
      
        # Output only. [Output Only] URL of the zone where the disk resides.
        # You must specify this field as part of the HTTP request URL. It is
        # not settable as a field in the request body.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @access_mode = args[:access_mode] if args.key?(:access_mode)
          @architecture = args[:architecture] if args.key?(:architecture)
          @async_primary_disk = args[:async_primary_disk] if args.key?(:async_primary_disk)
          @async_secondary_disks = args[:async_secondary_disks] if args.key?(:async_secondary_disks)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @disk_encryption_key = args[:disk_encryption_key] if args.key?(:disk_encryption_key)
          @enable_confidential_compute = args[:enable_confidential_compute] if args.key?(:enable_confidential_compute)
          @guest_os_features = args[:guest_os_features] if args.key?(:guest_os_features)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
          @last_attach_timestamp = args[:last_attach_timestamp] if args.key?(:last_attach_timestamp)
          @last_detach_timestamp = args[:last_detach_timestamp] if args.key?(:last_detach_timestamp)
          @license_codes = args[:license_codes] if args.key?(:license_codes)
          @licenses = args[:licenses] if args.key?(:licenses)
          @location_hint = args[:location_hint] if args.key?(:location_hint)
          @name = args[:name] if args.key?(:name)
          @options = args[:options] if args.key?(:options)
          @params = args[:params] if args.key?(:params)
          @physical_block_size_bytes = args[:physical_block_size_bytes] if args.key?(:physical_block_size_bytes)
          @provisioned_iops = args[:provisioned_iops] if args.key?(:provisioned_iops)
          @provisioned_throughput = args[:provisioned_throughput] if args.key?(:provisioned_throughput)
          @region = args[:region] if args.key?(:region)
          @replica_zones = args[:replica_zones] if args.key?(:replica_zones)
          @resource_policies = args[:resource_policies] if args.key?(:resource_policies)
          @resource_status = args[:resource_status] if args.key?(:resource_status)
          @satisfies_pzi = args[:satisfies_pzi] if args.key?(:satisfies_pzi)
          @satisfies_pzs = args[:satisfies_pzs] if args.key?(:satisfies_pzs)
          @self_link = args[:self_link] if args.key?(:self_link)
          @size_gb = args[:size_gb] if args.key?(:size_gb)
          @source_consistency_group_policy = args[:source_consistency_group_policy] if args.key?(:source_consistency_group_policy)
          @source_consistency_group_policy_id = args[:source_consistency_group_policy_id] if args.key?(:source_consistency_group_policy_id)
          @source_disk = args[:source_disk] if args.key?(:source_disk)
          @source_disk_id = args[:source_disk_id] if args.key?(:source_disk_id)
          @source_image = args[:source_image] if args.key?(:source_image)
          @source_image_encryption_key = args[:source_image_encryption_key] if args.key?(:source_image_encryption_key)
          @source_image_id = args[:source_image_id] if args.key?(:source_image_id)
          @source_instant_snapshot = args[:source_instant_snapshot] if args.key?(:source_instant_snapshot)
          @source_instant_snapshot_id = args[:source_instant_snapshot_id] if args.key?(:source_instant_snapshot_id)
          @source_snapshot = args[:source_snapshot] if args.key?(:source_snapshot)
          @source_snapshot_encryption_key = args[:source_snapshot_encryption_key] if args.key?(:source_snapshot_encryption_key)
          @source_snapshot_id = args[:source_snapshot_id] if args.key?(:source_snapshot_id)
          @source_storage_object = args[:source_storage_object] if args.key?(:source_storage_object)
          @status = args[:status] if args.key?(:status)
          @storage_pool = args[:storage_pool] if args.key?(:storage_pool)
          @type = args[:type] if args.key?(:type)
          @users = args[:users] if args.key?(:users)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class DiskAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of DisksScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeV1::DisksScopedList>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Alwayscompute#diskAggregatedList
        # for aggregated lists of persistent
        # disks.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Unreachable resources.
        # Corresponds to the JSON property `unreachables`
        # @return [Array<String>]
        attr_accessor :unreachables
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::DiskAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @unreachables = args[:unreachables] if args.key?(:unreachables)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::DiskAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class DiskAsyncReplication
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] URL of the DiskConsistencyGroupPolicy if
        # replication was
        # started on the disk as a member of a group.
        # Corresponds to the JSON property `consistencyGroupPolicy`
        # @return [String]
        attr_accessor :consistency_group_policy
      
        # Output only. [Output Only] ID of the DiskConsistencyGroupPolicy if replication
        # was
        # started on the disk as a member of a group.
        # Corresponds to the JSON property `consistencyGroupPolicyId`
        # @return [String]
        attr_accessor :consistency_group_policy_id
      
        # The other disk asynchronously replicated to or from the current disk.
        # You can provide this as a partial or full URL to the resource.
        # For example, the following are valid values:
        # 
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/
        # disk
        # - projects/project/zones/zone/disks/disk
        # - zones/zone/disks/disk
        # Corresponds to the JSON property `disk`
        # @return [String]
        attr_accessor :disk
      
        # Output only. [Output Only] The unique ID of the other disk asynchronously
        # replicated
        # to or from the current disk. This value identifies the exact disk that
        # was used to create this replication. For example, if you started
        # replicating the persistent disk from a disk that was later deleted and
        # recreated under the same name, the disk ID would identify the exact
        # version of the disk that was used.
        # Corresponds to the JSON property `diskId`
        # @return [String]
        attr_accessor :disk_id
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @consistency_group_policy = args[:consistency_group_policy] if args.key?(:consistency_group_policy)
          @consistency_group_policy_id = args[:consistency_group_policy_id] if args.key?(:consistency_group_policy_id)
          @disk = args[:disk] if args.key?(:disk)
          @disk_id = args[:disk_id] if args.key?(:disk_id)
        end
      end
      
      # 
      class DiskAsyncReplicationList
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `asyncReplicationDisk`
        # @return [Google::Apis::ComputeV1::DiskAsyncReplication]
        attr_accessor :async_replication_disk
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @async_replication_disk = args[:async_replication_disk] if args.key?(:async_replication_disk)
        end
      end
      
      # A specification of the desired way to instantiate a disk in the instance
      # template when its created from a source instance.
      class DiskInstantiationConfig
        include Google::Apis::Core::Hashable
      
        # Specifies whether the disk will be auto-deleted when the instance is
        # deleted (but not when the disk is detached from the instance).
        # Corresponds to the JSON property `autoDelete`
        # @return [Boolean]
        attr_accessor :auto_delete
        alias_method :auto_delete?, :auto_delete
      
        # The custom source image to be used to restore this disk when instantiating
        # this instance template.
        # Corresponds to the JSON property `customImage`
        # @return [String]
        attr_accessor :custom_image
      
        # Specifies the device name of the disk to which the configurations apply to.
        # Corresponds to the JSON property `deviceName`
        # @return [String]
        attr_accessor :device_name
      
        # Specifies whether to include the disk and what image to use. Possible
        # values are:
        # 
        # 
        # - source-image: to use the same image that was used to
        # create the source instance's corresponding disk. Applicable to the boot
        # disk and additional read-write disks.
        # - source-image-family: to use the same image family that
        # was used to create the source instance's corresponding disk. Applicable
        # to the boot disk and additional read-write disks.
        # - custom-image: to use a user-provided image url for disk
        # creation. Applicable to the boot disk and additional read-write
        # disks.
        # - attach-read-only: to attach a read-only
        # disk. Applicable to read-only disks.
        # - do-not-include: to exclude a disk from the template.
        # Applicable to additional read-write disks, local SSDs, and read-only
        # disks.
        # Corresponds to the JSON property `instantiateFrom`
        # @return [String]
        attr_accessor :instantiate_from
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @auto_delete = args[:auto_delete] if args.key?(:auto_delete)
          @custom_image = args[:custom_image] if args.key?(:custom_image)
          @device_name = args[:device_name] if args.key?(:device_name)
          @instantiate_from = args[:instantiate_from] if args.key?(:instantiate_from)
        end
      end
      
      # A list of Disk resources.
      class DiskList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Disk resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::Disk>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Always compute#diskList for
        # lists of disks.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::DiskList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::DiskList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class MoveDiskRequest
        include Google::Apis::Core::Hashable
      
        # The URL of the destination zone to move the disk. This can be a full or
        # partial URL. For example, the following are all valid URLs to a zone:
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone
        # - projects/project/zones/zone
        # - zones/zone
        # Corresponds to the JSON property `destinationZone`
        # @return [String]
        attr_accessor :destination_zone
      
        # The URL of the target disk to move. This can be a full or partial URL.
        # For example, the following are all valid URLs to a disk:
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/
        # disk
        # - projects/project/zones/zone/disks/disk
        # - zones/zone/disks/disk
        # Corresponds to the JSON property `targetDisk`
        # @return [String]
        attr_accessor :target_disk
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @destination_zone = args[:destination_zone] if args.key?(:destination_zone)
          @target_disk = args[:target_disk] if args.key?(:target_disk)
        end
      end
      
      # Additional disk params.
      class DiskParams
        include Google::Apis::Core::Hashable
      
        # Resource manager tags to be bound to the disk. Tag keys and values
        # have the same definition as resource
        # manager tags. Keys and values can be either in numeric format,
        # such as `tagKeys/`tag_key_id`` and `tagValues/456` or in namespaced
        # format such as ``org_id|project_id`/`tag_key_short_name`` and
        # ``tag_value_short_name``. The field is ignored (both PUT &
        # PATCH) when empty.
        # Corresponds to the JSON property `resourceManagerTags`
        # @return [Hash<String,String>]
        attr_accessor :resource_manager_tags
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @resource_manager_tags = args[:resource_manager_tags] if args.key?(:resource_manager_tags)
        end
      end
      
      # 
      class DiskResourceStatus
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `asyncPrimaryDisk`
        # @return [Google::Apis::ComputeV1::DiskResourceStatusAsyncReplicationStatus]
        attr_accessor :async_primary_disk
      
        # Key: disk, value: AsyncReplicationStatus message
        # Corresponds to the JSON property `asyncSecondaryDisks`
        # @return [Hash<String,Google::Apis::ComputeV1::DiskResourceStatusAsyncReplicationStatus>]
        attr_accessor :async_secondary_disks
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @async_primary_disk = args[:async_primary_disk] if args.key?(:async_primary_disk)
          @async_secondary_disks = args[:async_secondary_disks] if args.key?(:async_secondary_disks)
        end
      end
      
      # 
      class DiskResourceStatusAsyncReplicationStatus
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `state`
        # @return [String]
        attr_accessor :state
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @state = args[:state] if args.key?(:state)
        end
      end
      
      # Represents a Disk Type resource.
      # Google Compute Engine has two Disk Type resources:
      # * [Regional](/compute/docs/reference/rest/v1/regionDiskTypes)
      # * [Zonal](/compute/docs/reference/rest/v1/diskTypes)
      # You can choose from a variety of disk types based on your needs.
      # For more information, readStorage options.
      # The diskTypes resource represents disk types for a zonal
      # persistent disk.
      # For more information, readZonal persistent disks.
      # The regionDiskTypes resource represents disk types for a
      # regional persistent disk. For more information, read Regional persistent disks.
      class DiskType
        include Google::Apis::Core::Hashable
      
        # [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # [Output Only] Server-defined default disk size in GB.
        # Corresponds to the JSON property `defaultDiskSizeGb`
        # @return [Fixnum]
        attr_accessor :default_disk_size_gb
      
        # Deprecation status for a public resource.
        # Corresponds to the JSON property `deprecated`
        # @return [Google::Apis::ComputeV1::DeprecationStatus]
        attr_accessor :deprecated
      
        # [Output Only] An optional description of this resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. [Output Only] Type of the resource. Always compute#diskType
        # for disk types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] Name of the resource.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] URL of the region where the disk type resides. Only
        # applicable for regional resources.
        # You must specify this field as part of the HTTP request URL. It is
        # not settable as a field in the request body.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] An optional textual description of the valid disk size,
        # such as "10GB-10TB".
        # Corresponds to the JSON property `validDiskSize`
        # @return [String]
        attr_accessor :valid_disk_size
      
        # [Output Only] URL of the zone where the disk type resides.
        # You must specify this field as part of the HTTP request URL. It is
        # not settable as a field in the request body.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @default_disk_size_gb = args[:default_disk_size_gb] if args.key?(:default_disk_size_gb)
          @deprecated = args[:deprecated] if args.key?(:deprecated)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @valid_disk_size = args[:valid_disk_size] if args.key?(:valid_disk_size)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class DiskTypeAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of DiskTypesScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeV1::DiskTypesScopedList>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Alwayscompute#
        # diskTypeAggregatedList.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Unreachable resources.
        # Corresponds to the JSON property `unreachables`
        # @return [Array<String>]
        attr_accessor :unreachables
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::DiskTypeAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @unreachables = args[:unreachables] if args.key?(:unreachables)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::DiskTypeAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of disk types.
      class DiskTypeList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of DiskType resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::DiskType>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Always compute#diskTypeList
        # for disk types.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::DiskTypeList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::DiskTypeList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class DiskTypesScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of disk types contained in this scope.
        # Corresponds to the JSON property `diskTypes`
        # @return [Array<Google::Apis::ComputeV1::DiskType>]
        attr_accessor :disk_types
      
        # [Output Only] Informational warning which replaces the list of disk types
        # when the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::DiskTypesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @disk_types = args[:disk_types] if args.key?(:disk_types)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning which replaces the list of disk types
        # when the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::DiskTypesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class DisksAddResourcePoliciesRequest
        include Google::Apis::Core::Hashable
      
        # Full or relative path to the resource policy to be added to this disk. You
        # can only specify one resource policy.
        # Corresponds to the JSON property `resourcePolicies`
        # @return [Array<String>]
        attr_accessor :resource_policies
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @resource_policies = args[:resource_policies] if args.key?(:resource_policies)
        end
      end
      
      # 
      class DisksRemoveResourcePoliciesRequest
        include Google::Apis::Core::Hashable
      
        # Resource policies to be removed from this disk.
        # Corresponds to the JSON property `resourcePolicies`
        # @return [Array<String>]
        attr_accessor :resource_policies
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @resource_policies = args[:resource_policies] if args.key?(:resource_policies)
        end
      end
      
      # 
      class DisksResizeRequest
        include Google::Apis::Core::Hashable
      
        # The new size of the persistent disk, which is specified in GB.
        # Corresponds to the JSON property `sizeGb`
        # @return [Fixnum]
        attr_accessor :size_gb
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @size_gb = args[:size_gb] if args.key?(:size_gb)
        end
      end
      
      # 
      class DisksScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of disks contained in this scope.
        # Corresponds to the JSON property `disks`
        # @return [Array<Google::Apis::ComputeV1::Disk>]
        attr_accessor :disks
      
        # [Output Only] Informational warning which replaces the list of disks when
        # the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::DisksScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @disks = args[:disks] if args.key?(:disks)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning which replaces the list of disks when
        # the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::DisksScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class DisksStartAsyncReplicationRequest
        include Google::Apis::Core::Hashable
      
        # The secondary disk to start asynchronous replication to.
        # You can provide this as a partial or full URL to the resource. For example,
        # the following are valid values:
        # 
        # 
        # -
        # https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/
        # disk
        # 
        # -
        # https://www.googleapis.com/compute/v1/projects/project/regions/region/
        # disks/disk
        # 
        # -
        # projects/project/zones/zone/disks/disk
        # 
        # -
        # projects/project/regions/region/disks/disk
        # 
        # -
        # zones/zone/disks/disk
        # 
        # -
        # regions/region/disks/disk
        # Corresponds to the JSON property `asyncSecondaryDisk`
        # @return [String]
        attr_accessor :async_secondary_disk
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @async_secondary_disk = args[:async_secondary_disk] if args.key?(:async_secondary_disk)
        end
      end
      
      # A transient resource used in compute.disks.stopGroupAsyncReplication and
      # compute.regionDisks.stopGroupAsyncReplication. It is only used to process
      # requests and is not persisted.
      class DisksStopGroupAsyncReplicationResource
        include Google::Apis::Core::Hashable
      
        # The URL of the DiskConsistencyGroupPolicy for the group of disks to stop.
        # This may be a full or partial URL, such as:
        # 
        # 
        # -
        # https://www.googleapis.com/compute/v1/projects/project/regions/region/
        # resourcePolicies/resourcePolicy
        # 
        # -
        # projects/project/regions/region/resourcePolicies/resourcePolicy
        # 
        # -
        # regions/region/resourcePolicies/resourcePolicy
        # Corresponds to the JSON property `resourcePolicy`
        # @return [String]
        attr_accessor :resource_policy
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @resource_policy = args[:resource_policy] if args.key?(:resource_policy)
        end
      end
      
      # A set of Display Device options
      class DisplayDevice
        include Google::Apis::Core::Hashable
      
        # Defines whether the instance has Display enabled.
        # Corresponds to the JSON property `enableDisplay`
        # @return [Boolean]
        attr_accessor :enable_display
        alias_method :enable_display?, :enable_display
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @enable_display = args[:enable_display] if args.key?(:enable_display)
        end
      end
      
      # 
      class DistributionPolicy
        include Google::Apis::Core::Hashable
      
        # The distribution shape to which the group converges either proactively or
        # on resize events (depending on the value set inupdatePolicy.
        # instanceRedistributionType).
        # Corresponds to the JSON property `targetShape`
        # @return [String]
        attr_accessor :target_shape
      
        # Zones where the regional managed instance group will create and manage
        # its instances.
        # Corresponds to the JSON property `zones`
        # @return [Array<Google::Apis::ComputeV1::DistributionPolicyZoneConfiguration>]
        attr_accessor :zones
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @target_shape = args[:target_shape] if args.key?(:target_shape)
          @zones = args[:zones] if args.key?(:zones)
        end
      end
      
      # 
      class DistributionPolicyZoneConfiguration
        include Google::Apis::Core::Hashable
      
        # The URL of thezone.
        # The zone must exist in the region where the managed instance group is
        # located.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # A Duration represents a fixed-length span of time represented
      # as a count of seconds and fractions of seconds at nanosecond
      # resolution. It is independent of any calendar and concepts like "day"
      # or "month". Range is approximately 10,000 years.
      class Duration
        include Google::Apis::Core::Hashable
      
        # Span of time that's a fraction of a second at nanosecond resolution.
        # Durations less than one second are represented with a 0
        # `seconds` field and a positive `nanos` field. Must be from 0
        # to 999,999,999 inclusive.
        # Corresponds to the JSON property `nanos`
        # @return [Fixnum]
        attr_accessor :nanos
      
        # Span of time at a resolution of a second. Must be from 0
        # to 315,576,000,000 inclusive. Note: these bounds are computed from:
        # 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
        # Corresponds to the JSON property `seconds`
        # @return [Fixnum]
        attr_accessor :seconds
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @nanos = args[:nanos] if args.key?(:nanos)
          @seconds = args[:seconds] if args.key?(:seconds)
        end
      end
      
      # Describes the cause of the error with structured details.
      # Example of an error when contacting the "pubsub.googleapis.com" API when it
      # is not enabled:
      # ` "reason": "API_DISABLED"
      # "domain": "googleapis.com"
      # "metadata": `
      # "resource": "projects/123",
      # "service": "pubsub.googleapis.com"
      # `
      # `
      # This response indicates that the pubsub.googleapis.com API is not enabled.
      # Example of an error that is returned when attempting to create a Spanner
      # instance in a region that is out of stock:
      # ` "reason": "STOCKOUT"
      # "domain": "spanner.googleapis.com",
      # "metadata": `
      # "availableRegions": "us-central1,us-east2"
      # `
      # `
      class ErrorInfo
        include Google::Apis::Core::Hashable
      
        # The logical grouping to which the "reason" belongs. The error domain
        # is typically the registered service name of the tool or product that
        # generates the error. Example: "pubsub.googleapis.com". If the error is
        # generated by some common infrastructure, the error domain must be a
        # globally unique value that identifies the infrastructure. For Google API
        # infrastructure, the error domain is "googleapis.com".
        # Corresponds to the JSON property `domain`
        # @return [String]
        attr_accessor :domain
      
        # Additional structured details about this error.
        # Keys must match a regular expression of `a-z+` but should
        # ideally be lowerCamelCase. Also, they must be limited to 64 characters in
        # length. When identifying the current value of an exceeded limit, the units
        # should be contained in the key, not the value.  For example, rather than
        # ``"instanceLimit": "100/request"``, should be returned as,
        # ``"instanceLimitPerRequest": "100"``, if the client exceeds the number of
        # instances that can be created in a single (batch) request.
        # Corresponds to the JSON property `metadatas`
        # @return [Hash<String,String>]
        attr_accessor :metadatas
      
        # The reason of the error. This is a constant value that identifies the
        # proximate cause of the error. Error reasons are unique within a particular
        # domain of errors. This should be at most 63 characters and match a
        # regular expression of `A-Z+[A-Z0-9]`, which represents
        # UPPER_SNAKE_CASE.
        # Corresponds to the JSON property `reason`
        # @return [String]
        attr_accessor :reason
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @domain = args[:domain] if args.key?(:domain)
          @metadatas = args[:metadatas] if args.key?(:metadatas)
          @reason = args[:reason] if args.key?(:reason)
        end
      end
      
      # 
      class ExchangedPeeringRoute
        include Google::Apis::Core::Hashable
      
        # The destination range of the route.
        # Corresponds to the JSON property `destRange`
        # @return [String]
        attr_accessor :dest_range
      
        # True if the peering route has been imported from a peer. The actual import
        # happens if the field networkPeering.importCustomRoutes is true
        # for this network, and networkPeering.exportCustomRoutes is
        # true for the peer network, and the import does not result in a route
        # conflict.
        # Corresponds to the JSON property `imported`
        # @return [Boolean]
        attr_accessor :imported
        alias_method :imported?, :imported
      
        # The region of peering route next hop, only applies to dynamic routes.
        # Corresponds to the JSON property `nextHopRegion`
        # @return [String]
        attr_accessor :next_hop_region
      
        # The priority of the peering route.
        # Corresponds to the JSON property `priority`
        # @return [Fixnum]
        attr_accessor :priority
      
        # The type of the peering route.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @dest_range = args[:dest_range] if args.key?(:dest_range)
          @imported = args[:imported] if args.key?(:imported)
          @next_hop_region = args[:next_hop_region] if args.key?(:next_hop_region)
          @priority = args[:priority] if args.key?(:priority)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # 
      class ExchangedPeeringRoutesList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of ExchangedPeeringRoute resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::ExchangedPeeringRoute>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Alwayscompute#
        # exchangedPeeringRoutesList for exchanged peering
        # routes lists.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::ExchangedPeeringRoutesList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::ExchangedPeeringRoutesList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represents a textual expression in the Common Expression Language (CEL)
      # syntax. CEL is a C-like expression language. The syntax and semantics of CEL
      # are documented at https://github.com/google/cel-spec.
      # Example (Comparison):
      # title: "Summary size limit"
      # description: "Determines if a summary is less than 100 chars"
      # expression: "document.summary.size() < 100"
      # Example (Equality):
      # title: "Requestor is owner"
      # description: "Determines if requestor is the document owner"
      # expression: "document.owner == request.auth.claims.email"
      # Example (Logic):
      # title: "Public documents"
      # description: "Determine whether the document should be publicly visible"
      # expression: "document.type != 'private' && document.type != 'internal'"
      # Example (Data Manipulation):
      # title: "Notification string"
      # description: "Create a notification string with a timestamp."
      # expression: "'New message received at ' + string(document.create_time)"
      # The exact variables and functions that may be referenced within an expression
      # are determined by the service that evaluates it. See the service
      # documentation for additional information.
      class Expr
        include Google::Apis::Core::Hashable
      
        # Optional. Description of the expression. This is a longer text which
        # describes the expression, e.g. when hovered over it in a UI.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Textual representation of an expression in Common Expression Language
        # syntax.
        # Corresponds to the JSON property `expression`
        # @return [String]
        attr_accessor :expression
      
        # Optional. String indicating the location of the expression for error
        # reporting, e.g. a file name and a position in the file.
        # Corresponds to the JSON property `location`
        # @return [String]
        attr_accessor :location
      
        # Optional. Title for the expression, i.e. a short string describing
        # its purpose. This can be used e.g. in UIs which allow to enter the
        # expression.
        # Corresponds to the JSON property `title`
        # @return [String]
        attr_accessor :title
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @description = args[:description] if args.key?(:description)
          @expression = args[:expression] if args.key?(:expression)
          @location = args[:location] if args.key?(:location)
          @title = args[:title] if args.key?(:title)
        end
      end
      
      # Represents an external VPN gateway.
      # External VPN gateway is the on-premises VPN gateway(s) or another cloud
      # provider's VPN gateway that connects to your Google Cloud VPN gateway.
      # To create a highly available VPN from Google Cloud Platform to your
      # VPN gateway or another cloud provider's VPN gateway, you must create a
      # external VPN gateway resource with information about the other gateway.
      # For more information about using external VPN gateways, see
      # Creating an HA VPN gateway and tunnel pair to a peer VPN.
      class ExternalVpnGateway
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Output only. [Output Only] The unique identifier for the resource. This
        # identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # A list of interfaces for this external VPN gateway.
        # If your peer-side gateway is an on-premises gateway and non-AWS cloud
        # providers' gateway, at most two interfaces can be provided for an external
        # VPN gateway. If your peer side is an AWS virtual private gateway, four
        # interfaces should be provided for an external VPN gateway.
        # Corresponds to the JSON property `interfaces`
        # @return [Array<Google::Apis::ComputeV1::ExternalVpnGatewayInterface>]
        attr_accessor :interfaces
      
        # Output only. [Output Only] Type of the resource. Alwayscompute#
        # externalVpnGateway for externalVpnGateways.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # A fingerprint for the labels being applied to this ExternalVpnGateway,
        # which is essentially a hash of the labels set used for optimistic locking.
        # The fingerprint is initially generated by Compute Engine and changes after
        # every request to modify or update labels. You must always provide an
        # up-to-date fingerprint hash in order to update or change labels,
        # otherwise the request will fail with error412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to
        # retrieve an ExternalVpnGateway.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # Labels for this resource. These can only be added or modified by thesetLabels
        # method. Each label key/value pair must comply withRFC1035.
        # Label values may be empty.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # Name of the resource. Provided by the client when the resource is created.
        # The name must be 1-63 characters long, and comply withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must be
        # a dash, lowercase letter, or digit, except the last character, which cannot
        # be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Indicates the user-supplied redundancy type of this external VPN gateway.
        # Corresponds to the JSON property `redundancyType`
        # @return [String]
        attr_accessor :redundancy_type
      
        # Output only. [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @interfaces = args[:interfaces] if args.key?(:interfaces)
          @kind = args[:kind] if args.key?(:kind)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
          @name = args[:name] if args.key?(:name)
          @redundancy_type = args[:redundancy_type] if args.key?(:redundancy_type)
          @self_link = args[:self_link] if args.key?(:self_link)
        end
      end
      
      # The interface for the external VPN gateway.
      class ExternalVpnGatewayInterface
        include Google::Apis::Core::Hashable
      
        # The numeric ID of this interface.
        # The allowed input values for this id for different redundancy types of
        # external VPN gateway:
        # 
        # - SINGLE_IP_INTERNALLY_REDUNDANT - 0
        # - TWO_IPS_REDUNDANCY - 0, 1
        # - FOUR_IPS_REDUNDANCY - 0, 1, 2, 3
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # IP address of the interface in the external VPN gateway. Only IPv4 is
        # supported. This IP address can be either from your on-premise gateway or
        # another Cloud provider's VPN gateway, it cannot be an IP address from
        # Google Compute Engine.
        # Corresponds to the JSON property `ipAddress`
        # @return [String]
        attr_accessor :ip_address
      
        # IPv6 address of the interface in the external VPN gateway. This IPv6
        # address can be either from your on-premise gateway or another Cloud
        # provider's VPN gateway, it cannot be an IP address from Google Compute
        # Engine. Must specify an IPv6 address (not IPV4-mapped) using any format
        # described in RFC 4291 (e.g. 2001:db8:0:0:2d9:51:0:0). The output format
        # is RFC 5952 format (e.g. 2001:db8::2d9:51:0:0).
        # Corresponds to the JSON property `ipv6Address`
        # @return [String]
        attr_accessor :ipv6_address
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @ip_address = args[:ip_address] if args.key?(:ip_address)
          @ipv6_address = args[:ipv6_address] if args.key?(:ipv6_address)
        end
      end
      
      # Response to the list request, and contains a list of externalVpnGateways.
      class ExternalVpnGatewayList
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `etag`
        # @return [String]
        attr_accessor :etag
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of ExternalVpnGateway resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::ExternalVpnGateway>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Always compute#
        # externalVpnGatewayList for lists of externalVpnGateways.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::ExternalVpnGatewayList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @etag = args[:etag] if args.key?(:etag)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::ExternalVpnGatewayList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class FileContentBuffer
        include Google::Apis::Core::Hashable
      
        # The raw content in the secure keys file.
        # Corresponds to the JSON property `content`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :content
      
        # The file type of source file.
        # Corresponds to the JSON property `fileType`
        # @return [String]
        attr_accessor :file_type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @content = args[:content] if args.key?(:content)
          @file_type = args[:file_type] if args.key?(:file_type)
        end
      end
      
      # Represents a Firewall Rule resource.
      # Firewall rules allow or deny ingress traffic to, and egress traffic from your
      # instances. For more information, readFirewall rules.
      class Firewall
        include Google::Apis::Core::Hashable
      
        # The list of ALLOW rules specified by this firewall. Each rule specifies a
        # protocol and port-range tuple that describes a permitted connection.
        # Corresponds to the JSON property `allowed`
        # @return [Array<Google::Apis::ComputeV1::Firewall::Allowed>]
        attr_accessor :allowed
      
        # Output only. [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # The list of DENY rules specified by this firewall. Each rule specifies a
        # protocol and port-range tuple that describes a denied connection.
        # Corresponds to the JSON property `denied`
        # @return [Array<Google::Apis::ComputeV1::Firewall::Denied>]
        attr_accessor :denied
      
        # An optional description of this resource. Provide this field when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # If destination ranges are specified, the firewall rule applies only to
        # traffic that has destination IP address in these ranges. These ranges must
        # be expressed inCIDR format. Both IPv4 and IPv6 are supported.
        # Corresponds to the JSON property `destinationRanges`
        # @return [Array<String>]
        attr_accessor :destination_ranges
      
        # Direction of traffic to which this firewall applies, either `INGRESS` or
        # `EGRESS`. The default is `INGRESS`. For `EGRESS` traffic, you cannot
        # specify the sourceTags fields.
        # Corresponds to the JSON property `direction`
        # @return [String]
        attr_accessor :direction
      
        # Denotes whether the firewall rule is disabled. When set to true, the
        # firewall rule is not enforced and the network behaves as if it did not
        # exist. If this is unspecified, the firewall rule will be enabled.
        # Corresponds to the JSON property `disabled`
        # @return [Boolean]
        attr_accessor :disabled
        alias_method :disabled?, :disabled
      
        # Output only. [Output Only] The unique identifier for the resource. This
        # identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. [Output Only] Type of the resource. Always compute#firewall
        # for firewall rules.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The available logging options for a firewall rule.
        # Corresponds to the JSON property `logConfig`
        # @return [Google::Apis::ComputeV1::FirewallLogConfig]
        attr_accessor :log_config
      
        # Name of the resource; provided by the client when the resource is created.
        # The name must be 1-63 characters long, and comply withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character
        # must be a lowercase letter, and all following characters (except for the
        # last character) must be a dash, lowercase letter, or digit. The last
        # character must be a lowercase letter or digit.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # URL of the network resource for this firewall rule. If not
        # specified when creating a firewall rule, the default network
        # is used:
        # global/networks/default
        # If you choose to specify this field, you can specify the network as a full
        # or partial URL. For example, the following are all valid URLs:
        # 
        # -
        # https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-
        # network
        # - projects/myproject/global/networks/my-network
        # - global/networks/default
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # Additional firewall parameters.
        # Corresponds to the JSON property `params`
        # @return [Google::Apis::ComputeV1::FirewallParams]
        attr_accessor :params
      
        # Priority for this rule.
        # This is an integer between `0` and `65535`, both inclusive.
        # The default value is `1000`.
        # Relative priorities determine which rule takes effect if multiple rules
        # apply. Lower values indicate higher priority. For example, a rule with
        # priority `0` has higher precedence than a rule with priority `1`.
        # DENY rules take precedence over ALLOW rules if they have equal priority.
        # Note that VPC networks have implied
        # rules with a priority of `65535`. To avoid conflicts with the implied
        # rules, use a priority number less than `65535`.
        # Corresponds to the JSON property `priority`
        # @return [Fixnum]
        attr_accessor :priority
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # If source ranges are specified, the firewall rule applies only to traffic
        # that has a source IP address in these ranges. These ranges must be
        # expressed inCIDR format. One or both of sourceRanges
        # and sourceTags may be set.
        # If both fields are set, the rule applies to traffic that has a
        # source IP address within sourceRanges OR a source IP
        # from a resource with a matching tag listed in thesourceTags field. The
        # connection does not need to match
        # both fields for the rule to
        # apply. Both IPv4 and IPv6 are supported.
        # Corresponds to the JSON property `sourceRanges`
        # @return [Array<String>]
        attr_accessor :source_ranges
      
        # If source service accounts are specified, the firewall rules apply only to
        # traffic originating from an instance with a service account in this list.
        # Source service accounts cannot be used to control traffic to an instance's
        # external IP address because service accounts are associated with an
        # instance, not an IP address.sourceRanges can be set at the same time
        # assourceServiceAccounts.
        # If both are set, the firewall applies to traffic that
        # has a source IP address within the sourceRanges OR a source
        # IP that belongs to an instance with service account listed
        # insourceServiceAccount. The connection does not need to match
        # both fields for the firewall to apply.sourceServiceAccounts cannot be used at
        # the same time assourceTags or targetTags.
        # Corresponds to the JSON property `sourceServiceAccounts`
        # @return [Array<String>]
        attr_accessor :source_service_accounts
      
        # If source tags are specified, the firewall rule applies only to traffic
        # with source IPs that match the primary network interfaces of VM instances
        # that have the tag and are in the same VPC network.
        # Source tags cannot be used to control traffic to an instance's external IP
        # address, it only applies to traffic between instances in the same virtual
        # network. Because tags are associated with instances, not IP addresses.
        # One or both of sourceRanges and sourceTags may be
        # set. If both fields are set, the firewall applies to traffic that has a
        # source IP address within sourceRanges OR a source IP from a
        # resource with a matching tag listed in the sourceTags
        # field. The connection does not need to match both fields for the
        # firewall to apply.
        # Corresponds to the JSON property `sourceTags`
        # @return [Array<String>]
        attr_accessor :source_tags
      
        # A list of service accounts indicating sets of instances located in the
        # network that may make network connections as specified inallowed[].
        # targetServiceAccounts cannot be used at the same time astargetTags or
        # sourceTags.
        # If neither targetServiceAccounts nor targetTags
        # are specified, the firewall rule applies to all instances on the specified
        # network.
        # Corresponds to the JSON property `targetServiceAccounts`
        # @return [Array<String>]
        attr_accessor :target_service_accounts
      
        # A list of tags that controls which instances the firewall rule
        # applies to. If targetTags are specified, then the firewall
        # rule applies only to instances in the VPC network that have one of those
        # tags. If no targetTags are specified, the firewall rule
        # applies to all instances on the specified network.
        # Corresponds to the JSON property `targetTags`
        # @return [Array<String>]
        attr_accessor :target_tags
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @allowed = args[:allowed] if args.key?(:allowed)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @denied = args[:denied] if args.key?(:denied)
          @description = args[:description] if args.key?(:description)
          @destination_ranges = args[:destination_ranges] if args.key?(:destination_ranges)
          @direction = args[:direction] if args.key?(:direction)
          @disabled = args[:disabled] if args.key?(:disabled)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @log_config = args[:log_config] if args.key?(:log_config)
          @name = args[:name] if args.key?(:name)
          @network = args[:network] if args.key?(:network)
          @params = args[:params] if args.key?(:params)
          @priority = args[:priority] if args.key?(:priority)
          @self_link = args[:self_link] if args.key?(:self_link)
          @source_ranges = args[:source_ranges] if args.key?(:source_ranges)
          @source_service_accounts = args[:source_service_accounts] if args.key?(:source_service_accounts)
          @source_tags = args[:source_tags] if args.key?(:source_tags)
          @target_service_accounts = args[:target_service_accounts] if args.key?(:target_service_accounts)
          @target_tags = args[:target_tags] if args.key?(:target_tags)
        end
        
        # 
        class Allowed
          include Google::Apis::Core::Hashable
        
          # The IP protocol to which this rule applies. The protocol type is
          # required when creating a firewall rule. This value can either be one of the
          # following well known protocol strings (tcp, udp,icmp, esp, ah, ipip,sctp) or
          # the IP protocol number.
          # Corresponds to the JSON property `IPProtocol`
          # @return [String]
          attr_accessor :ip_protocol
        
          # An optional list of ports to which this rule applies.
          # This field is only applicable for the UDP or TCP protocol.
          # Each entry must be either an integer or a range.
          # If not specified, this rule applies to connections through any port.
          # Example inputs include: ["22"], ["80","443"],
          # and ["12345-12349"].
          # Corresponds to the JSON property `ports`
          # @return [Array<String>]
          attr_accessor :ports
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @ip_protocol = args[:ip_protocol] if args.key?(:ip_protocol)
            @ports = args[:ports] if args.key?(:ports)
          end
        end
        
        # 
        class Denied
          include Google::Apis::Core::Hashable
        
          # The IP protocol to which this rule applies. The protocol type is
          # required when creating a firewall rule. This value can either be one of the
          # following well known protocol strings (tcp, udp,icmp, esp, ah, ipip,sctp) or
          # the IP protocol number.
          # Corresponds to the JSON property `IPProtocol`
          # @return [String]
          attr_accessor :ip_protocol
        
          # An optional list of ports to which this rule applies.
          # This field is only applicable for the UDP or TCP protocol.
          # Each entry must be either an integer or a range.
          # If not specified, this rule applies to connections through any port.
          # Example inputs include: ["22"], ["80","443"],
          # and ["12345-12349"].
          # Corresponds to the JSON property `ports`
          # @return [Array<String>]
          attr_accessor :ports
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @ip_protocol = args[:ip_protocol] if args.key?(:ip_protocol)
            @ports = args[:ports] if args.key?(:ports)
          end
        end
      end
      
      # Contains a list of firewalls.
      class FirewallList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Firewall resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::Firewall>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Always compute#firewallList
        # for lists of firewalls.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::FirewallList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::FirewallList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # The available logging options for a firewall rule.
      class FirewallLogConfig
        include Google::Apis::Core::Hashable
      
        # This field denotes whether to enable logging for a particular firewall
        # rule.
        # Corresponds to the JSON property `enable`
        # @return [Boolean]
        attr_accessor :enable
        alias_method :enable?, :enable
      
        # This field can only be specified for a particular firewall rule if
        # logging is enabled for that rule. This field denotes whether to include
        # or exclude metadata for firewall logs.
        # Corresponds to the JSON property `metadata`
        # @return [String]
        attr_accessor :metadata
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @enable = args[:enable] if args.key?(:enable)
          @metadata = args[:metadata] if args.key?(:metadata)
        end
      end
      
      # Additional firewall parameters.
      class FirewallParams
        include Google::Apis::Core::Hashable
      
        # Tag keys/values directly bound to this resource.
        # Tag keys and values have the same definition as resource
        # manager tags. The field is allowed for INSERT
        # only. The keys/values to set on the resource should be specified in
        # either ID ` : ` or Namespaced format
        # ` : `.
        # For example the following are valid inputs:
        # * `"tagKeys/333" : "tagValues/444", "tagKeys/123" : "tagValues/456"`
        # * `"123/environment" : "production", "345/abc" : "xyz"`
        # Note:
        # * Invalid combinations of ID & namespaced format is not supported. For
        # instance: `"123/environment" : "tagValues/444"` is invalid.
        # Corresponds to the JSON property `resourceManagerTags`
        # @return [Hash<String,String>]
        attr_accessor :resource_manager_tags
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @resource_manager_tags = args[:resource_manager_tags] if args.key?(:resource_manager_tags)
        end
      end
      
      # 
      class FirewallPoliciesListAssociationsResponse
        include Google::Apis::Core::Hashable
      
        # A list of associations.
        # Corresponds to the JSON property `associations`
        # @return [Array<Google::Apis::ComputeV1::FirewallPolicyAssociation>]
        attr_accessor :associations
      
        # Output only. [Output Only] Type of firewallPolicy associations. Alwayscompute#
        # FirewallPoliciesListAssociations for lists of
        # firewallPolicy associations.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @associations = args[:associations] if args.key?(:associations)
          @kind = args[:kind] if args.key?(:kind)
        end
      end
      
      # 
      class FirewallPoliciesScopedList
        include Google::Apis::Core::Hashable
      
        # A list of firewall policies contained in this scope.
        # Corresponds to the JSON property `firewallPolicies`
        # @return [Array<Google::Apis::ComputeV1::FirewallPolicy>]
        attr_accessor :firewall_policies
      
        # Informational warning which replaces the list of firewall policies when
        # the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::FirewallPoliciesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @firewall_policies = args[:firewall_policies] if args.key?(:firewall_policies)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Informational warning which replaces the list of firewall policies when
        # the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::FirewallPoliciesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represents a Firewall Policy resource.
      class FirewallPolicy
        include Google::Apis::Core::Hashable
      
        # A list of associations that belong to this firewall policy.
        # Corresponds to the JSON property `associations`
        # @return [Array<Google::Apis::ComputeV1::FirewallPolicyAssociation>]
        attr_accessor :associations
      
        # Output only. [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Deprecated, please use short name instead. User-provided name of the
        # Organization firewall policy. The name should be unique in the organization
        # in which the firewall policy is created.
        # This field is not applicable to network firewall policies.
        # This name must be set on creation and cannot be changed.
        # The name must be 1-63 characters long, and comply
        # with RFC1035. Specifically, the name must be 1-63 characters
        # long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which
        # means the first character must be a lowercase letter, and all following
        # characters must be a dash, lowercase letter, or digit, except the last
        # character, which cannot be a dash.
        # Corresponds to the JSON property `displayName`
        # @return [String]
        attr_accessor :display_name
      
        # Specifies a fingerprint for this resource, which is essentially a hash of
        # the metadata's contents and used for optimistic locking. The
        # fingerprint is initially generated by Compute Engine and changes after
        # every request to modify or update metadata. You must always provide an
        # up-to-date fingerprint hash in order to update or change metadata,
        # otherwise the request will fail with error412 conditionNotMet.
        # To see the latest fingerprint, make get() request to the
        # firewall policy.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. [Output only] Type of the resource. Alwayscompute#
        # firewallPolicyfor firewall policies
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource. For Organization Firewall Policies it's a
        # [Output Only] numeric ID allocated by Google Cloud which uniquely
        # identifies the Organization Firewall Policy.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # A list of packet mirroring rules that belong to this policy.
        # Corresponds to the JSON property `packetMirroringRules`
        # @return [Array<Google::Apis::ComputeV1::FirewallPolicyRule>]
        attr_accessor :packet_mirroring_rules
      
        # Output only. [Output Only] The parent of the firewall policy.
        # This field is not applicable to network firewall policies.
        # Corresponds to the JSON property `parent`
        # @return [String]
        attr_accessor :parent
      
        # The type of the firewall policy. This field can be eitherVPC_POLICY or
        # RDMA_ROCE_POLICY.
        # Note: if not specified then VPC_POLICY will be used.
        # Corresponds to the JSON property `policyType`
        # @return [String]
        attr_accessor :policy_type
      
        # Output only. [Output Only] URL of the region where the regional firewall
        # policy resides.
        # This field is not applicable to global firewall policies.
        # You must specify this field as part of the HTTP request URL. It is
        # not settable as a field in the request body.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # Output only. [Output Only] Total count of all firewall policy rule tuples. A
        # firewall
        # policy can not exceed a set number of tuples.
        # Corresponds to the JSON property `ruleTupleCount`
        # @return [Fixnum]
        attr_accessor :rule_tuple_count
      
        # A list of rules that belong to this policy.
        # There must always be a default rule (rule with priority 2147483647 and
        # match "*"). If no rules are provided when creating a firewall policy, a
        # default rule with action "allow" will be added.
        # Corresponds to the JSON property `rules`
        # @return [Array<Google::Apis::ComputeV1::FirewallPolicyRule>]
        attr_accessor :rules
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Server-defined URL for this resource with the
        # resource id.
        # Corresponds to the JSON property `selfLinkWithId`
        # @return [String]
        attr_accessor :self_link_with_id
      
        # User-provided name of the Organization firewall policy. The name should be
        # unique in the organization in which the firewall policy is created.
        # This field is not applicable to network firewall policies.
        # This name must be set on creation and cannot be changed. The name must be
        # 1-63 characters long, and comply with RFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must
        # be a dash, lowercase letter, or digit, except the last character, which
        # cannot be a dash.
        # Corresponds to the JSON property `shortName`
        # @return [String]
        attr_accessor :short_name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @associations = args[:associations] if args.key?(:associations)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @display_name = args[:display_name] if args.key?(:display_name)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @packet_mirroring_rules = args[:packet_mirroring_rules] if args.key?(:packet_mirroring_rules)
          @parent = args[:parent] if args.key?(:parent)
          @policy_type = args[:policy_type] if args.key?(:policy_type)
          @region = args[:region] if args.key?(:region)
          @rule_tuple_count = args[:rule_tuple_count] if args.key?(:rule_tuple_count)
          @rules = args[:rules] if args.key?(:rules)
          @self_link = args[:self_link] if args.key?(:self_link)
          @self_link_with_id = args[:self_link_with_id] if args.key?(:self_link_with_id)
          @short_name = args[:short_name] if args.key?(:short_name)
        end
      end
      
      # 
      class FirewallPolicyAssociation
        include Google::Apis::Core::Hashable
      
        # The target that the firewall policy is attached to.
        # Corresponds to the JSON property `attachmentTarget`
        # @return [String]
        attr_accessor :attachment_target
      
        # [Output Only] Deprecated, please use short name instead. The display name
        # of the firewall policy of the association.
        # Corresponds to the JSON property `displayName`
        # @return [String]
        attr_accessor :display_name
      
        # Output only. [Output Only] The firewall policy ID of the association.
        # Corresponds to the JSON property `firewallPolicyId`
        # @return [String]
        attr_accessor :firewall_policy_id
      
        # The name for an association.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Output only. [Output Only] The short name of the firewall policy of the
        # association.
        # Corresponds to the JSON property `shortName`
        # @return [String]
        attr_accessor :short_name
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @attachment_target = args[:attachment_target] if args.key?(:attachment_target)
          @display_name = args[:display_name] if args.key?(:display_name)
          @firewall_policy_id = args[:firewall_policy_id] if args.key?(:firewall_policy_id)
          @name = args[:name] if args.key?(:name)
          @short_name = args[:short_name] if args.key?(:short_name)
        end
      end
      
      # 
      class FirewallPolicyList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of FirewallPolicy resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::FirewallPolicy>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Alwayscompute#firewallPolicyList
        # for listsof FirewallPolicies
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::FirewallPolicyList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::FirewallPolicyList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represents a rule that describes one or more match conditions along with
      # the action to be taken when traffic matches this condition (allow or deny).
      class FirewallPolicyRule
        include Google::Apis::Core::Hashable
      
        # The Action to perform when the client connection triggers the rule.
        # Valid actions for firewall rules are: "allow", "deny",
        # "apply_security_profile_group" and "goto_next".
        # Valid actions for packet mirroring rules are: "mirror", "do_not_mirror"
        # and "goto_next".
        # Corresponds to the JSON property `action`
        # @return [String]
        attr_accessor :action
      
        # An optional description for this resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # The direction in which this rule applies.
        # Corresponds to the JSON property `direction`
        # @return [String]
        attr_accessor :direction
      
        # Denotes whether the firewall policy rule is disabled. When set to true,
        # the firewall policy rule is not enforced and traffic behaves as if it did
        # not exist. If this is unspecified, the firewall policy rule will be
        # enabled.
        # Corresponds to the JSON property `disabled`
        # @return [Boolean]
        attr_accessor :disabled
        alias_method :disabled?, :disabled
      
        # Denotes whether to enable logging for a particular rule. If logging is
        # enabled, logs will be exported to the configured export destination in
        # Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you
        # cannot enable logging on "goto_next" rules.
        # Corresponds to the JSON property `enableLogging`
        # @return [Boolean]
        attr_accessor :enable_logging
        alias_method :enable_logging?, :enable_logging
      
        # Output only. [Output only] Type of the resource. Returnscompute#
        # firewallPolicyRule for firewall rules andcompute#packetMirroringRule for
        # packet mirroring rules.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Represents a match condition that incoming traffic is evaluated against.
        # Exactly one field must be specified.
        # Corresponds to the JSON property `match`
        # @return [Google::Apis::ComputeV1::FirewallPolicyRuleMatcher]
        attr_accessor :match
      
        # An integer indicating the priority of a rule in the list. The priority
        # must be a positive value between 0 and 2147483647.
        # Rules are evaluated from highest to lowest priority where 0 is the
        # highest priority and 2147483647 is the lowest priority.
        # Corresponds to the JSON property `priority`
        # @return [Fixnum]
        attr_accessor :priority
      
        # An optional name for the rule. This field is not a unique identifier
        # and can be updated.
        # Corresponds to the JSON property `ruleName`
        # @return [String]
        attr_accessor :rule_name
      
        # Output only. [Output Only] Calculation of the complexity of a single firewall
        # policy
        # rule.
        # Corresponds to the JSON property `ruleTupleCount`
        # @return [Fixnum]
        attr_accessor :rule_tuple_count
      
        # A fully-qualified URL of a SecurityProfile resource instance.
        # Example:
        # https://networksecurity.googleapis.com/v1/projects/`project`/locations/`
        # location`/securityProfileGroups/my-security-profile-group
        # Must be specified if action is one of 'apply_security_profile_group' or
        # 'mirror'. Cannot be specified for other actions.
        # Corresponds to the JSON property `securityProfileGroup`
        # @return [String]
        attr_accessor :security_profile_group
      
        # A list of network resource URLs to which this rule applies.  This field
        # allows you to control which network's VMs get this rule.  If this field
        # is left blank, all VMs within the organization will receive the rule.
        # Corresponds to the JSON property `targetResources`
        # @return [Array<String>]
        attr_accessor :target_resources
      
        # A list of secure tags that controls which instances the firewall rule
        # applies to. If targetSecureTag are specified, then the
        # firewall rule applies only to instances in the VPC network that have one
        # of those EFFECTIVE secure tags, if all the target_secure_tag are in
        # INEFFECTIVE state, then this rule will be ignored.targetSecureTag may not be
        # set at the same time astargetServiceAccounts.
        # If neither targetServiceAccounts nortargetSecureTag are specified, the
        # firewall rule applies
        # to all instances on the specified network.
        # Maximum number of target label tags allowed is 256.
        # Corresponds to the JSON property `targetSecureTags`
        # @return [Array<Google::Apis::ComputeV1::FirewallPolicyRuleSecureTag>]
        attr_accessor :target_secure_tags
      
        # A list of service accounts indicating the sets of instances that are
        # applied with this rule.
        # Corresponds to the JSON property `targetServiceAccounts`
        # @return [Array<String>]
        attr_accessor :target_service_accounts
      
        # Boolean flag indicating if the traffic should be TLS decrypted.
        # Can be set only if action = 'apply_security_profile_group' and cannot
        # be set for other actions.
        # Corresponds to the JSON property `tlsInspect`
        # @return [Boolean]
        attr_accessor :tls_inspect
        alias_method :tls_inspect?, :tls_inspect
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @action = args[:action] if args.key?(:action)
          @description = args[:description] if args.key?(:description)
          @direction = args[:direction] if args.key?(:direction)
          @disabled = args[:disabled] if args.key?(:disabled)
          @enable_logging = args[:enable_logging] if args.key?(:enable_logging)
          @kind = args[:kind] if args.key?(:kind)
          @match = args[:match] if args.key?(:match)
          @priority = args[:priority] if args.key?(:priority)
          @rule_name = args[:rule_name] if args.key?(:rule_name)
          @rule_tuple_count = args[:rule_tuple_count] if args.key?(:rule_tuple_count)
          @security_profile_group = args[:security_profile_group] if args.key?(:security_profile_group)
          @target_resources = args[:target_resources] if args.key?(:target_resources)
          @target_secure_tags = args[:target_secure_tags] if args.key?(:target_secure_tags)
          @target_service_accounts = args[:target_service_accounts] if args.key?(:target_service_accounts)
          @tls_inspect = args[:tls_inspect] if args.key?(:tls_inspect)
        end
      end
      
      # Represents a match condition that incoming traffic is evaluated against.
      # Exactly one field must be specified.
      class FirewallPolicyRuleMatcher
        include Google::Apis::Core::Hashable
      
        # Address groups which should be matched against the traffic destination.
        # Maximum number of destination address groups is 10.
        # Corresponds to the JSON property `destAddressGroups`
        # @return [Array<String>]
        attr_accessor :dest_address_groups
      
        # Fully Qualified Domain Name (FQDN) which should be matched against
        # traffic destination.
        # Maximum number of destination fqdn allowed is 100.
        # Corresponds to the JSON property `destFqdns`
        # @return [Array<String>]
        attr_accessor :dest_fqdns
      
        # CIDR IP address range.
        # Maximum number of destination CIDR IP ranges allowed is 5000.
        # Corresponds to the JSON property `destIpRanges`
        # @return [Array<String>]
        attr_accessor :dest_ip_ranges
      
        # Network context of the traffic destination. Allowed values are:
        # 
        # 
        # - UNSPECIFIED
        # - INTERNET
        # - NON_INTERNET
        # Corresponds to the JSON property `destNetworkContext`
        # @return [String]
        attr_accessor :dest_network_context
      
        # Network type of the traffic destination. Allowed values are:
        # 
        # 
        # - UNSPECIFIED
        # - INTERNET
        # - NON_INTERNET
        # Corresponds to the JSON property `destNetworkType`
        # @return [String]
        attr_accessor :dest_network_type
      
        # Region codes whose IP addresses will be used to match for destination
        # of traffic. Should be specified as 2 letter country code defined as per
        # ISO 3166 alpha-2 country codes. ex."US"
        # Maximum number of dest region codes allowed is 5000.
        # Corresponds to the JSON property `destRegionCodes`
        # @return [Array<String>]
        attr_accessor :dest_region_codes
      
        # Names of Network Threat Intelligence lists.
        # The IPs in these lists will be matched against traffic destination.
        # Corresponds to the JSON property `destThreatIntelligences`
        # @return [Array<String>]
        attr_accessor :dest_threat_intelligences
      
        # Pairs of IP protocols and ports that the rule should match.
        # Corresponds to the JSON property `layer4Configs`
        # @return [Array<Google::Apis::ComputeV1::FirewallPolicyRuleMatcherLayer4Config>]
        attr_accessor :layer4_configs
      
        # Address groups which should be matched against the traffic source.
        # Maximum number of source address groups is 10.
        # Corresponds to the JSON property `srcAddressGroups`
        # @return [Array<String>]
        attr_accessor :src_address_groups
      
        # Fully Qualified Domain Name (FQDN) which should be matched against
        # traffic source.
        # Maximum number of source fqdn allowed is 100.
        # Corresponds to the JSON property `srcFqdns`
        # @return [Array<String>]
        attr_accessor :src_fqdns
      
        # CIDR IP address range.
        # Maximum number of source CIDR IP ranges allowed is 5000.
        # Corresponds to the JSON property `srcIpRanges`
        # @return [Array<String>]
        attr_accessor :src_ip_ranges
      
        # Network context of the traffic source. Allowed values are:
        # 
        # 
        # - UNSPECIFIED
        # - INTERNET
        # - INTRA_VPC
        # - NON_INTERNET
        # - VPC_NETWORKS
        # Corresponds to the JSON property `srcNetworkContext`
        # @return [String]
        attr_accessor :src_network_context
      
        # Network type of the traffic source. Allowed values are:
        # 
        # 
        # - UNSPECIFIED
        # - INTERNET
        # - INTRA_VPC
        # - NON_INTERNET
        # - VPC_NETWORKS
        # Corresponds to the JSON property `srcNetworkType`
        # @return [String]
        attr_accessor :src_network_type
      
        # Networks of the traffic source. It can be either a full or partial url.
        # Corresponds to the JSON property `srcNetworks`
        # @return [Array<String>]
        attr_accessor :src_networks
      
        # Region codes whose IP addresses will be used to match for source
        # of traffic. Should be specified as 2 letter country code defined as per
        # ISO 3166 alpha-2 country codes. ex."US"
        # Maximum number of source region codes allowed is 5000.
        # Corresponds to the JSON property `srcRegionCodes`
        # @return [Array<String>]
        attr_accessor :src_region_codes
      
        # List of secure tag values, which should be matched at the source
        # of the traffic.
        # For INGRESS rule, if all the srcSecureTag are INEFFECTIVE,
        # and there is no srcIpRange, this rule will be ignored.
        # Maximum number of source tag values allowed is 256.
        # Corresponds to the JSON property `srcSecureTags`
        # @return [Array<Google::Apis::ComputeV1::FirewallPolicyRuleSecureTag>]
        attr_accessor :src_secure_tags
      
        # Names of Network Threat Intelligence lists.
        # The IPs in these lists will be matched against traffic source.
        # Corresponds to the JSON property `srcThreatIntelligences`
        # @return [Array<String>]
        attr_accessor :src_threat_intelligences
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @dest_address_groups = args[:dest_address_groups] if args.key?(:dest_address_groups)
          @dest_fqdns = args[:dest_fqdns] if args.key?(:dest_fqdns)
          @dest_ip_ranges = args[:dest_ip_ranges] if args.key?(:dest_ip_ranges)
          @dest_network_context = args[:dest_network_context] if args.key?(:dest_network_context)
          @dest_network_type = args[:dest_network_type] if args.key?(:dest_network_type)
          @dest_region_codes = args[:dest_region_codes] if args.key?(:dest_region_codes)
          @dest_threat_intelligences = args[:dest_threat_intelligences] if args.key?(:dest_threat_intelligences)
          @layer4_configs = args[:layer4_configs] if args.key?(:layer4_configs)
          @src_address_groups = args[:src_address_groups] if args.key?(:src_address_groups)
          @src_fqdns = args[:src_fqdns] if args.key?(:src_fqdns)
          @src_ip_ranges = args[:src_ip_ranges] if args.key?(:src_ip_ranges)
          @src_network_context = args[:src_network_context] if args.key?(:src_network_context)
          @src_network_type = args[:src_network_type] if args.key?(:src_network_type)
          @src_networks = args[:src_networks] if args.key?(:src_networks)
          @src_region_codes = args[:src_region_codes] if args.key?(:src_region_codes)
          @src_secure_tags = args[:src_secure_tags] if args.key?(:src_secure_tags)
          @src_threat_intelligences = args[:src_threat_intelligences] if args.key?(:src_threat_intelligences)
        end
      end
      
      # 
      class FirewallPolicyRuleMatcherLayer4Config
        include Google::Apis::Core::Hashable
      
        # The IP protocol to which this rule applies. The protocol type is
        # required when creating a firewall rule. This value can either be
        # one of the following well known protocol strings (tcp,udp, icmp, esp,ah, ipip,
        # sctp), or the IP
        # protocol number.
        # Corresponds to the JSON property `ipProtocol`
        # @return [String]
        attr_accessor :ip_protocol
      
        # An optional list of ports to which this rule applies. This field is
        # only applicable for UDP or TCP protocol. Each entry must be either
        # an integer or a range. If not specified, this rule applies to
        # connections through any port.
        # Example inputs include: ["22"],["80","443"], and ["12345-12349"].
        # Corresponds to the JSON property `ports`
        # @return [Array<String>]
        attr_accessor :ports
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @ip_protocol = args[:ip_protocol] if args.key?(:ip_protocol)
          @ports = args[:ports] if args.key?(:ports)
        end
      end
      
      # 
      class FirewallPolicyRuleSecureTag
        include Google::Apis::Core::Hashable
      
        # Name of the secure tag, created with TagManager's TagValue API.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Output only. [Output Only] State of the secure tag, either `EFFECTIVE` or
        # `INEFFECTIVE`. A secure tag is `INEFFECTIVE` when it is deleted
        # or its network is deleted.
        # Corresponds to the JSON property `state`
        # @return [String]
        attr_accessor :state
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @name = args[:name] if args.key?(:name)
          @state = args[:state] if args.key?(:state)
        end
      end
      
      # Encapsulates numeric value that can be either absolute or relative.
      class FixedOrPercent
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Absolute value of VM instances calculated based on
        # the
        # specific mode.
        # 
        # 
        # - If the value is fixed, then the calculated
        # value is equal to the fixed value.
        # - If the value is a percent, then the
        # calculated
        # value is percent/100 * targetSize. For example,
        # the calculated value of a 80% of a managed instance group
        # with 150 instances would be (80/100 * 150) = 120 VM instances. If there
        # is a remainder, the number is rounded.
        # Corresponds to the JSON property `calculated`
        # @return [Fixnum]
        attr_accessor :calculated
      
        # Specifies a fixed number of VM instances. This must be a positive integer.
        # Corresponds to the JSON property `fixed`
        # @return [Fixnum]
        attr_accessor :fixed
      
        # Specifies a percentage of instances between 0 to 100%, inclusive. For
        # example, specify 80 for 80%.
        # Corresponds to the JSON property `percent`
        # @return [Fixnum]
        attr_accessor :percent
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @calculated = args[:calculated] if args.key?(:calculated)
          @fixed = args[:fixed] if args.key?(:fixed)
          @percent = args[:percent] if args.key?(:percent)
        end
      end
      
      # Specifies a flexible time range with flexible start time and duration.
      # It is possible to specify a contradictory time range that cannot be matched
      # by any Interval. This causes a validation error.
      class FlexibleTimeRange
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `maxDuration`
        # @return [String]
        attr_accessor :max_duration
      
        # 
        # Corresponds to the JSON property `minDuration`
        # @return [String]
        attr_accessor :min_duration
      
        # 
        # Corresponds to the JSON property `startTimeNotEarlierThan`
        # @return [String]
        attr_accessor :start_time_not_earlier_than
      
        # 
        # Corresponds to the JSON property `startTimeNotLaterThan`
        # @return [String]
        attr_accessor :start_time_not_later_than
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @max_duration = args[:max_duration] if args.key?(:max_duration)
          @min_duration = args[:min_duration] if args.key?(:min_duration)
          @start_time_not_earlier_than = args[:start_time_not_earlier_than] if args.key?(:start_time_not_earlier_than)
          @start_time_not_later_than = args[:start_time_not_later_than] if args.key?(:start_time_not_later_than)
        end
      end
      
      # Represents a Forwarding Rule resource.
      # Forwarding rule resources in Google Cloud can be either regional or global in
      # scope:
      # * [Global](https://cloud.google.com/compute/docs/reference/rest/v1/
      # globalForwardingRules)
      # * [Regional](https://cloud.google.com/compute/docs/reference/rest/v1/
      # forwardingRules)
      # A forwarding rule and its corresponding IP address represent the frontend
      # configuration of a Google Cloud load balancer.
      # Forwarding rules can also reference target instances and Cloud VPN Classic
      # gateways (targetVpnGateway).
      # For more information, read
      # Forwarding rule concepts and
      # Using protocol forwarding.
      class ForwardingRule
        include Google::Apis::Core::Hashable
      
        # IP address for which this forwarding rule accepts traffic. When a client
        # sends traffic to this IP address, the forwarding rule directs the traffic
        # to the referenced target or backendService.
        # While creating a forwarding rule, specifying an IPAddress is
        # required under the following circumstances:
        # 
        # - When the target is set to targetGrpcProxy andvalidateForProxyless is set
        # to true, theIPAddress should be set to 0.0.0.0.
        # - When the target is a Private Service Connect Google APIs
        # bundle, you must specify an IPAddress.
        # Otherwise, you can optionally specify an IP address that references an
        # existing static (reserved) IP address resource. When omitted, Google Cloud
        # assigns an ephemeral IP address.
        # Use one of the following formats to specify an IP address while creating a
        # forwarding rule:
        # * IP address number, as in `100.1.2.3`
        # * IPv6 address range, as in `2600:1234::/96`
        # * Full resource URL, as inhttps://www.googleapis.com/compute/v1/projects/
        # project_id/regions/region/addresses/address-name
        # * Partial URL or by name, as in:
        # 
        # - projects/project_id/regions/region/addresses/address-name
        # - regions/region/addresses/address-name
        # - global/addresses/address-name
        # - address-name
        # The forwarding rule's target or backendService,
        # and in most cases, also the loadBalancingScheme, determine the
        # type of IP address that you can use. For detailed information, see
        # [IP address
        # specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-
        # concepts#ip_address_specifications).
        # When reading an IPAddress, the API always returns the IP
        # address number.
        # Corresponds to the JSON property `IPAddress`
        # @return [String]
        attr_accessor :ip_address
      
        # The IP protocol to which this rule applies.
        # For protocol forwarding, valid
        # options are TCP, UDP, ESP,AH, SCTP, ICMP andL3_DEFAULT.
        # The valid IP protocols are different for different load balancing products
        # as described in [Load balancing
        # features](https://cloud.google.com/load-balancing/docs/features#
        # protocols_from_the_load_balancer_to_the_backends).
        # Corresponds to the JSON property `IPProtocol`
        # @return [String]
        attr_accessor :ip_protocol
      
        # The ports, portRange, and allPorts
        # fields are mutually exclusive. Only packets addressed to ports in the
        # specified range will be forwarded to the backends configured with this
        # forwarding rule.
        # The allPorts field has the following limitations:
        # 
        # - It requires that the forwarding rule IPProtocol be TCP,
        # UDP, SCTP, or L3_DEFAULT.
        # - It's applicable only to the following products: internal passthrough
        # Network Load Balancers, backend service-based external passthrough Network
        # Load Balancers, and internal and external protocol forwarding.
        # - Set this field to true to allow packets addressed to any port or
        # packets lacking destination port information (for example, UDP fragments
        # after the first fragment) to be forwarded to the backends configured with
        # this forwarding rule. The L3_DEFAULT protocol requiresallPorts be set to
        # true.
        # Corresponds to the JSON property `allPorts`
        # @return [Boolean]
        attr_accessor :all_ports
        alias_method :all_ports?, :all_ports
      
        # If set to true, clients can access the internal passthrough Network Load
        # Balancers, the regional internal Application Load Balancer, and the
        # regional internal proxy Network Load Balancer from all regions.
        # If false, only allows access from the local region the load balancer is
        # located at. Note that for INTERNAL_MANAGED forwarding rules, this field
        # cannot be changed after the forwarding rule is created.
        # Corresponds to the JSON property `allowGlobalAccess`
        # @return [Boolean]
        attr_accessor :allow_global_access
        alias_method :allow_global_access?, :allow_global_access
      
        # This is used in PSC consumer ForwardingRule to control whether the PSC
        # endpoint can be accessed from another region.
        # Corresponds to the JSON property `allowPscGlobalAccess`
        # @return [Boolean]
        attr_accessor :allow_psc_global_access
        alias_method :allow_psc_global_access?, :allow_psc_global_access
      
        # Identifies the backend service to which the forwarding rule sends traffic.
        # Required for internal and external passthrough Network Load Balancers;
        # must be omitted for all other load balancer types.
        # Corresponds to the JSON property `backendService`
        # @return [String]
        attr_accessor :backend_service
      
        # Output only. [Output Only] The URL for the corresponding base forwarding rule.
        # By base
        # forwarding rule, we mean the forwarding rule that has the same IP address,
        # protocol, and port settings with the current forwarding rule, but without
        # sourceIPRanges specified.
        # Always empty if the current forwarding rule does not have sourceIPRanges
        # specified.
        # Corresponds to the JSON property `baseForwardingRule`
        # @return [String]
        attr_accessor :base_forwarding_rule
      
        # Output only. [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Specifies the canary migration state for the backend buckets attached to
        # this forwarding rule. Possible values are PREPARE, TEST_BY_PERCENTAGE, and
        # TEST_ALL_TRAFFIC.
        # To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be
        # changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before
        # the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the
        # TEST_BY_PERCENTAGE state can be used to migrate traffic to backend buckets
        # attached to this forwarding rule by percentage using
        # externalManagedBackendBucketMigrationTestingPercentage.
        # Rolling back a migration requires the states to be set in reverse order. So
        # changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to
        # be set to TEST_ALL_TRAFFIC at the same time. Optionally, the
        # TEST_BY_PERCENTAGE state can be used to migrate some traffic back to
        # EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
        # Corresponds to the JSON property `externalManagedBackendBucketMigrationState`
        # @return [String]
        attr_accessor :external_managed_backend_bucket_migration_state
      
        # Determines the fraction of requests to backend buckets that should be
        # processed by the global external Application Load Balancer.
        # The value of this field must be in the range [0, 100].
        # This value can only be set if the loadBalancingScheme in the BackendService
        # is set to EXTERNAL (when using the classic Application Load Balancer) and
        # the migration state is TEST_BY_PERCENTAGE.
        # Corresponds to the JSON property `externalManagedBackendBucketMigrationTestingPercentage`
        # @return [Float]
        attr_accessor :external_managed_backend_bucket_migration_testing_percentage
      
        # Fingerprint of this resource. A hash of the contents stored in this object.
        # This field is used in optimistic locking. This field will be ignored when
        # inserting a ForwardingRule. Include the fingerprint in patch request to
        # ensure that you do not overwrite changes that were applied from another
        # concurrent request.
        # To see the latest fingerprint, make a get() request to
        # retrieve a ForwardingRule.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Resource reference of a PublicDelegatedPrefix. The PDP must
        # be a sub-PDP in EXTERNAL_IPV6_FORWARDING_RULE_CREATION mode.
        # Use one of the following formats to specify a sub-PDP when creating an IPv6
        # NetLB forwarding rule using BYOIP:
        # Full resource URL, as inhttps://www.googleapis.com/compute/v1/projects/
        # project_id/regions/region/publicDelegatedPrefixes/sub-pdp-name
        # Partial URL, as in:
        # 
        # - projects/project_id/regions/region/publicDelegatedPrefixes/sub-pdp-name
        # - regions/region/publicDelegatedPrefixes/sub-pdp-name
        # Corresponds to the JSON property `ipCollection`
        # @return [String]
        attr_accessor :ip_collection
      
        # The IP Version that will be used by this forwarding rule.  Valid options
        # are IPV4 or IPV6.
        # Corresponds to the JSON property `ipVersion`
        # @return [String]
        attr_accessor :ip_version
      
        # Indicates whether or not this load balancer can be used as a collector for
        # packet mirroring. To prevent mirroring loops, instances behind this
        # load balancer will not have their traffic mirrored even if aPacketMirroring
        # rule applies to them.
        # This can only be set to true for load balancers that have
        # theirloadBalancingScheme set to INTERNAL.
        # Corresponds to the JSON property `isMirroringCollector`
        # @return [Boolean]
        attr_accessor :is_mirroring_collector
        alias_method :is_mirroring_collector?, :is_mirroring_collector
      
        # Output only. [Output Only] Type of the resource. Alwayscompute#forwardingRule
        # for forwarding rule resources.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # A fingerprint for the labels being applied to this resource, which is
        # essentially a hash of the labels set used for optimistic locking. The
        # fingerprint is initially generated by Compute Engine and changes after
        # every request to modify or update labels. You must always provide an
        # up-to-date fingerprint hash in order to update or change labels,
        # otherwise the request will fail with error412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to
        # retrieve a ForwardingRule.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # Labels for this resource. These can only be added or modified by thesetLabels
        # method. Each label key/value pair must comply withRFC1035.
        # Label values may be empty.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # Specifies the forwarding rule type.
        # For more information about forwarding rules, refer to
        # Forwarding rule concepts.
        # Corresponds to the JSON property `loadBalancingScheme`
        # @return [String]
        attr_accessor :load_balancing_scheme
      
        # Opaque filter criteria used by load balancer to restrict routing
        # configuration to a limited set of xDS
        # compliant clients. In their xDS requests to load balancer, xDS clients
        # present node
        # metadata. When there is a match, the relevant configuration
        # is made available to those proxies. Otherwise, all the resources (e.g.
        # TargetHttpProxy, UrlMap)
        # referenced by the ForwardingRule are not visible to
        # those proxies.
        # For each metadataFilter in this list, if itsfilterMatchCriteria is set to
        # MATCH_ANY, at least one of thefilterLabels must match the corresponding label
        # provided in
        # the metadata. If its filterMatchCriteria is set to
        # MATCH_ALL, then all of its filterLabels must match with
        # corresponding labels provided in the metadata. If multiplemetadataFilters are
        # specified, all of them need to be satisfied
        # in order to be considered a match.
        # metadataFilters specified here will be applifed before
        # those specified in the UrlMap that thisForwardingRule references.
        # metadataFilters only applies to Loadbalancers that have
        # their loadBalancingScheme set toINTERNAL_SELF_MANAGED.
        # Corresponds to the JSON property `metadataFilters`
        # @return [Array<Google::Apis::ComputeV1::MetadataFilter>]
        attr_accessor :metadata_filters
      
        # Name of the resource; provided by the client when the resource is created.
        # The name must be 1-63 characters long, and comply withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must
        # be a dash, lowercase letter, or digit, except the last character, which
        # cannot be a dash.
        # For Private Service Connect forwarding rules that forward traffic to Google
        # APIs, the forwarding rule name must be a 1-20 characters string with
        # lowercase letters and numbers and must start with a letter.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # This field is not used for global external load balancing.
        # For internal passthrough Network Load Balancers, this field identifies the
        # network that the load balanced IP should belong to for this forwarding
        # rule.
        # If the subnetwork is specified, the network of the subnetwork will be used.
        # If neither subnetwork nor this field is specified, the default network will
        # be used.
        # For Private Service Connect forwarding rules that forward traffic to Google
        # APIs, a network must be provided.
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # This signifies the networking tier used for configuring
        # this load balancer and can only take the following values:PREMIUM, STANDARD.
        # For regional ForwardingRule, the valid values are PREMIUM andSTANDARD. For
        # GlobalForwardingRule, the valid value isPREMIUM.
        # If this field is not specified, it is assumed to be PREMIUM.
        # If IPAddress is specified, this value must be equal to the
        # networkTier of the Address.
        # Corresponds to the JSON property `networkTier`
        # @return [String]
        attr_accessor :network_tier
      
        # This is used in PSC consumer ForwardingRule to control whether it should
        # try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use
        # this field. Once set, this field is not mutable.
        # Corresponds to the JSON property `noAutomateDnsZone`
        # @return [Boolean]
        attr_accessor :no_automate_dns_zone
        alias_method :no_automate_dns_zone?, :no_automate_dns_zone
      
        # The ports, portRange, and allPorts
        # fields are mutually exclusive. Only packets addressed to ports in the
        # specified range will be forwarded to the backends configured with this
        # forwarding rule.
        # The portRange field has the following limitations:
        # 
        # - It requires that the forwarding rule IPProtocol be TCP,
        # UDP, or SCTP, and
        # - It's applicable only to the following products: external passthrough
        # Network Load Balancers, internal and external proxy Network Load Balancers,
        # internal and external Application Load Balancers, external protocol
        # forwarding, and Classic VPN.
        # - Some products have restrictions on what ports can be used. See
        # port specifications for details.
        # For external forwarding rules, two or more forwarding rules cannot use the
        # same [IPAddress, IPProtocol] pair, and cannot have overlappingportRanges.
        # For internal forwarding rules within the same VPC network, two or more
        # forwarding rules cannot use the same [IPAddress, IPProtocol]
        # pair, and cannot have overlapping portRanges.
        # @pattern: \\d+(?:-\\d+)?
        # Corresponds to the JSON property `portRange`
        # @return [String]
        attr_accessor :port_range
      
        # The ports, portRange, and allPorts
        # fields are mutually exclusive. Only packets addressed to ports in the
        # specified range will be forwarded to the backends configured with this
        # forwarding rule.
        # The ports field has the following limitations:
        # 
        # - It requires that the forwarding rule IPProtocol be TCP,
        # UDP, or SCTP, and
        # - It's applicable only to the following products: internal passthrough
        # Network Load Balancers, backend service-based external passthrough Network
        # Load Balancers, and internal protocol forwarding.
        # - You can specify a list of up to five ports by number, separated by
        # commas. The ports can be contiguous or discontiguous.
        # For external forwarding rules, two or more forwarding rules cannot use the
        # same [IPAddress, IPProtocol] pair if they share at least one
        # port number.
        # For internal forwarding rules within the same VPC network, two or more
        # forwarding rules cannot use the same [IPAddress, IPProtocol]
        # pair if they share at least one port number.
        # @pattern: \\d+(?:-\\d+)?
        # Corresponds to the JSON property `ports`
        # @return [Array<String>]
        attr_accessor :ports
      
        # [Output Only] The PSC connection id of the PSC forwarding rule.
        # Corresponds to the JSON property `pscConnectionId`
        # @return [Fixnum]
        attr_accessor :psc_connection_id
      
        # 
        # Corresponds to the JSON property `pscConnectionStatus`
        # @return [String]
        attr_accessor :psc_connection_status
      
        # Output only. [Output Only] URL of the region where the regional forwarding
        # rule resides.
        # This field is not applicable to global forwarding rules.
        # You must specify this field as part of the HTTP request URL. It is
        # not settable as a field in the request body.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Server-defined URL for this resource with the
        # resource id.
        # Corresponds to the JSON property `selfLinkWithId`
        # @return [String]
        attr_accessor :self_link_with_id
      
        # Service Directory resources to register this forwarding rule with.
        # Currently, only supports a single Service Directory resource.
        # Corresponds to the JSON property `serviceDirectoryRegistrations`
        # @return [Array<Google::Apis::ComputeV1::ForwardingRuleServiceDirectoryRegistration>]
        attr_accessor :service_directory_registrations
      
        # An optional prefix to the service name for this forwarding rule.
        # If specified, the prefix is the first label of the fully qualified service
        # name.
        # The label must be 1-63 characters long, and comply withRFC1035.
        # Specifically, the label must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must
        # be a dash, lowercase letter, or digit, except the last character, which
        # cannot be a dash.
        # This field is only used for internal load balancing.
        # Corresponds to the JSON property `serviceLabel`
        # @return [String]
        attr_accessor :service_label
      
        # [Output Only]
        # The internal fully qualified service name for this forwarding rule.
        # This field is only used for internal load balancing.
        # Corresponds to the JSON property `serviceName`
        # @return [String]
        attr_accessor :service_name
      
        # If not empty, this forwarding rule will only forward the traffic when the
        # source IP address matches one of the IP addresses or CIDR ranges set here.
        # Note that a forwarding rule can only have up to 64 source IP ranges, and
        # this field can only be used with a regional forwarding rule whose scheme
        # isEXTERNAL.
        # Each source_ip_range entry should be either an IP address (for
        # example, 1.2.3.4) or a CIDR range (for example, 1.2.3.0/24).
        # Corresponds to the JSON property `sourceIpRanges`
        # @return [Array<String>]
        attr_accessor :source_ip_ranges
      
        # This field identifies the subnetwork that the load balanced IP should
        # belong to for this forwarding rule, used with internal load balancers and
        # external passthrough Network Load Balancers with IPv6.
        # If the network specified is in auto subnet mode, this field is optional.
        # However, a subnetwork must be specified if the network is in custom subnet
        # mode or when creating external forwarding rule with IPv6.
        # Corresponds to the JSON property `subnetwork`
        # @return [String]
        attr_accessor :subnetwork
      
        # The URL of the target resource to receive the matched traffic.  For
        # regional forwarding rules, this target must be in the same region as the
        # forwarding rule. For global forwarding rules, this target must be a global
        # load balancing resource.
        # The forwarded traffic must be of a type appropriate to the target object.
        # 
        # 
        # -  For load balancers, see the "Target" column in [Port specifications](
        # https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#
        # ip_address_specifications).
        # -  For Private Service Connect forwarding rules that forward traffic to
        # Google APIs, provide the name of a supported Google API bundle:
        # 
        # 
        # -  vpc-sc -  APIs that support VPC Service Controls.
        # -  all-apis - All supported Google APIs.
        # 
        # 
        # -  For Private Service Connect forwarding rules that forward traffic to
        # managed services, the target must be a service attachment. The target is not
        # mutable once set as a service attachment.
        # Corresponds to the JSON property `target`
        # @return [String]
        attr_accessor :target
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @ip_address = args[:ip_address] if args.key?(:ip_address)
          @ip_protocol = args[:ip_protocol] if args.key?(:ip_protocol)
          @all_ports = args[:all_ports] if args.key?(:all_ports)
          @allow_global_access = args[:allow_global_access] if args.key?(:allow_global_access)
          @allow_psc_global_access = args[:allow_psc_global_access] if args.key?(:allow_psc_global_access)
          @backend_service = args[:backend_service] if args.key?(:backend_service)
          @base_forwarding_rule = args[:base_forwarding_rule] if args.key?(:base_forwarding_rule)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @external_managed_backend_bucket_migration_state = args[:external_managed_backend_bucket_migration_state] if args.key?(:external_managed_backend_bucket_migration_state)
          @external_managed_backend_bucket_migration_testing_percentage = args[:external_managed_backend_bucket_migration_testing_percentage] if args.key?(:external_managed_backend_bucket_migration_testing_percentage)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @id = args[:id] if args.key?(:id)
          @ip_collection = args[:ip_collection] if args.key?(:ip_collection)
          @ip_version = args[:ip_version] if args.key?(:ip_version)
          @is_mirroring_collector = args[:is_mirroring_collector] if args.key?(:is_mirroring_collector)
          @kind = args[:kind] if args.key?(:kind)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
          @load_balancing_scheme = args[:load_balancing_scheme] if args.key?(:load_balancing_scheme)
          @metadata_filters = args[:metadata_filters] if args.key?(:metadata_filters)
          @name = args[:name] if args.key?(:name)
          @network = args[:network] if args.key?(:network)
          @network_tier = args[:network_tier] if args.key?(:network_tier)
          @no_automate_dns_zone = args[:no_automate_dns_zone] if args.key?(:no_automate_dns_zone)
          @port_range = args[:port_range] if args.key?(:port_range)
          @ports = args[:ports] if args.key?(:ports)
          @psc_connection_id = args[:psc_connection_id] if args.key?(:psc_connection_id)
          @psc_connection_status = args[:psc_connection_status] if args.key?(:psc_connection_status)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @self_link_with_id = args[:self_link_with_id] if args.key?(:self_link_with_id)
          @service_directory_registrations = args[:service_directory_registrations] if args.key?(:service_directory_registrations)
          @service_label = args[:service_label] if args.key?(:service_label)
          @service_name = args[:service_name] if args.key?(:service_name)
          @source_ip_ranges = args[:source_ip_ranges] if args.key?(:source_ip_ranges)
          @subnetwork = args[:subnetwork] if args.key?(:subnetwork)
          @target = args[:target] if args.key?(:target)
        end
      end
      
      # 
      class ForwardingRuleAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of ForwardingRulesScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeV1::ForwardingRulesScopedList>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Alwayscompute#
        # forwardingRuleAggregatedList for lists of forwarding rules.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Unreachable resources.
        # Corresponds to the JSON property `unreachables`
        # @return [Array<String>]
        attr_accessor :unreachables
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::ForwardingRuleAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @unreachables = args[:unreachables] if args.key?(:unreachables)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::ForwardingRuleAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of ForwardingRule resources.
      class ForwardingRuleList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of ForwardingRule resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::ForwardingRule>]
        attr_accessor :items
      
        # Output only. Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::ForwardingRuleList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::ForwardingRuleList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class ForwardingRuleReference
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `forwardingRule`
        # @return [String]
        attr_accessor :forwarding_rule
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @forwarding_rule = args[:forwarding_rule] if args.key?(:forwarding_rule)
        end
      end
      
      # Describes the auto-registration of the forwarding rule to Service Directory.
      # The region and project of the Service Directory resource generated from
      # this registration will be the same as this forwarding rule.
      class ForwardingRuleServiceDirectoryRegistration
        include Google::Apis::Core::Hashable
      
        # Service Directory namespace to register the forwarding rule under.
        # Corresponds to the JSON property `namespace`
        # @return [String]
        attr_accessor :namespace
      
        # Service Directory service to register the forwarding rule under.
        # Corresponds to the JSON property `service`
        # @return [String]
        attr_accessor :service
      
        # [Optional] Service Directory region to register this global forwarding
        # rule under. Default to "us-central1". Only used for PSC for Google APIs.
        # All PSC for Google APIs forwarding rules on the same network should use
        # the same Service Directory region.
        # Corresponds to the JSON property `serviceDirectoryRegion`
        # @return [String]
        attr_accessor :service_directory_region
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @namespace = args[:namespace] if args.key?(:namespace)
          @service = args[:service] if args.key?(:service)
          @service_directory_region = args[:service_directory_region] if args.key?(:service_directory_region)
        end
      end
      
      # 
      class ForwardingRulesScopedList
        include Google::Apis::Core::Hashable
      
        # A list of forwarding rules contained in this scope.
        # Corresponds to the JSON property `forwardingRules`
        # @return [Array<Google::Apis::ComputeV1::ForwardingRule>]
        attr_accessor :forwarding_rules
      
        # Informational warning which replaces the list of forwarding rules when
        # the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::ForwardingRulesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @forwarding_rules = args[:forwarding_rules] if args.key?(:forwarding_rules)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Informational warning which replaces the list of forwarding rules when
        # the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::ForwardingRulesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class FutureReservation
        include Google::Apis::Core::Hashable
      
        # This reservation type is specified by total resource amounts (e.g. total
        # count of CPUs) and can account for multiple instance SKUs. In other words,
        # one can create instances of varying shapes against this reservation.
        # Corresponds to the JSON property `aggregateReservation`
        # @return [Google::Apis::ComputeV1::AllocationAggregateReservation]
        attr_accessor :aggregate_reservation
      
        # Future timestamp when the FR auto-created reservations will be deleted by
        # Compute Engine. Format of this field must be a valid
        # href="https://www.ietf.org/rfc/rfc3339.txt">RFC3339 value.
        # Corresponds to the JSON property `autoCreatedReservationsDeleteTime`
        # @return [String]
        attr_accessor :auto_created_reservations_delete_time
      
        # A Duration represents a fixed-length span of time represented
        # as a count of seconds and fractions of seconds at nanosecond
        # resolution. It is independent of any calendar and concepts like "day"
        # or "month". Range is approximately 10,000 years.
        # Corresponds to the JSON property `autoCreatedReservationsDuration`
        # @return [Google::Apis::ComputeV1::Duration]
        attr_accessor :auto_created_reservations_duration
      
        # Setting for enabling or disabling automatic deletion for auto-created
        # reservation. If set to true, auto-created reservations will be
        # deleted at Future Reservation's end time (default) or at user's defined
        # timestamp if any of the
        # [auto_created_reservations_delete_time, auto_created_reservations_duration]
        # values is specified.
        # For keeping auto-created reservation indefinitely, this value should be set
        # to false.
        # Corresponds to the JSON property `autoDeleteAutoCreatedReservations`
        # @return [Boolean]
        attr_accessor :auto_delete_auto_created_reservations
        alias_method :auto_delete_auto_created_reservations?, :auto_delete_auto_created_reservations
      
        # If not present, then FR will not deliver a new commitment or update an
        # existing commitment.
        # Corresponds to the JSON property `commitmentInfo`
        # @return [Google::Apis::ComputeV1::FutureReservationCommitmentInfo]
        attr_accessor :commitment_info
      
        # Output only. [Output Only] The creation timestamp for this future reservation
        # inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # Type of the deployment requested as part of future reservation.
        # Corresponds to the JSON property `deploymentType`
        # @return [String]
        attr_accessor :deployment_type
      
        # An optional description of this resource. Provide this property when you
        # create the future reservation.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Indicates if this group of VMs have emergent maintenance enabled.
        # Corresponds to the JSON property `enableEmergentMaintenance`
        # @return [Boolean]
        attr_accessor :enable_emergent_maintenance
        alias_method :enable_emergent_maintenance?, :enable_emergent_maintenance
      
        # Output only. [Output Only] A unique identifier for this future reservation.
        # The server
        # defines this identifier.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. [Output Only] Type of the resource. Alwayscompute#
        # futureReservation for future reservations.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The name of the resource, provided by the client when initially creating
        # the resource. The resource name must be 1-63 characters long, and comply
        # withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must be
        # a dash, lowercase letter, or digit, except the last character, which cannot
        # be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Name prefix for the reservations to be created at the time of
        # delivery. The name prefix must comply with RFC1035.
        # Maximum allowed length for name prefix is 20. Automatically created
        # reservations name format will be -date-####.
        # Corresponds to the JSON property `namePrefix`
        # @return [String]
        attr_accessor :name_prefix
      
        # Planning state before being submitted for evaluation
        # Corresponds to the JSON property `planningStatus`
        # @return [String]
        attr_accessor :planning_status
      
        # The reservation mode which determines reservation-termination behavior and
        # expected pricing.
        # Corresponds to the JSON property `reservationMode`
        # @return [String]
        attr_accessor :reservation_mode
      
        # Name of reservations where the capacity is provisioned at the time of
        # delivery of  future reservations. If the reservation with the given name
        # does not exist already, it is created automatically at the time of Approval
        # with INACTIVE state till specified start-time. Either provide the
        # reservation_name or a name_prefix.
        # Corresponds to the JSON property `reservationName`
        # @return [String]
        attr_accessor :reservation_name
      
        # Maintenance information for this reservation
        # Corresponds to the JSON property `schedulingType`
        # @return [String]
        attr_accessor :scheduling_type
      
        # Output only. [Output Only] Server-defined fully-qualified URL for this
        # resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Server-defined URL for this resource with the
        # resource id.
        # Corresponds to the JSON property `selfLinkWithId`
        # @return [String]
        attr_accessor :self_link_with_id
      
        # The share setting for reservations and sole tenancy node groups.
        # Corresponds to the JSON property `shareSettings`
        # @return [Google::Apis::ComputeV1::ShareSettings]
        attr_accessor :share_settings
      
        # Indicates whether the auto-created reservation can be consumed by VMs with
        # affinity for "any" reservation. If the field is set, then only VMs that
        # target the reservation by name can consume from the delivered reservation.
        # Corresponds to the JSON property `specificReservationRequired`
        # @return [Boolean]
        attr_accessor :specific_reservation_required
        alias_method :specific_reservation_required?, :specific_reservation_required
      
        # Future Reservation configuration to indicate instance properties and
        # total count.
        # Corresponds to the JSON property `specificSkuProperties`
        # @return [Google::Apis::ComputeV1::FutureReservationSpecificSkuProperties]
        attr_accessor :specific_sku_properties
      
        # [Output only] Represents status related to the future reservation.
        # Corresponds to the JSON property `status`
        # @return [Google::Apis::ComputeV1::FutureReservationStatus]
        attr_accessor :status
      
        # Time window for this Future Reservation.
        # Corresponds to the JSON property `timeWindow`
        # @return [Google::Apis::ComputeV1::FutureReservationTimeWindow]
        attr_accessor :time_window
      
        # Output only. [Output Only] URL of the Zone where this future reservation
        # resides.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @aggregate_reservation = args[:aggregate_reservation] if args.key?(:aggregate_reservation)
          @auto_created_reservations_delete_time = args[:auto_created_reservations_delete_time] if args.key?(:auto_created_reservations_delete_time)
          @auto_created_reservations_duration = args[:auto_created_reservations_duration] if args.key?(:auto_created_reservations_duration)
          @auto_delete_auto_created_reservations = args[:auto_delete_auto_created_reservations] if args.key?(:auto_delete_auto_created_reservations)
          @commitment_info = args[:commitment_info] if args.key?(:commitment_info)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @deployment_type = args[:deployment_type] if args.key?(:deployment_type)
          @description = args[:description] if args.key?(:description)
          @enable_emergent_maintenance = args[:enable_emergent_maintenance] if args.key?(:enable_emergent_maintenance)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @name_prefix = args[:name_prefix] if args.key?(:name_prefix)
          @planning_status = args[:planning_status] if args.key?(:planning_status)
          @reservation_mode = args[:reservation_mode] if args.key?(:reservation_mode)
          @reservation_name = args[:reservation_name] if args.key?(:reservation_name)
          @scheduling_type = args[:scheduling_type] if args.key?(:scheduling_type)
          @self_link = args[:self_link] if args.key?(:self_link)
          @self_link_with_id = args[:self_link_with_id] if args.key?(:self_link_with_id)
          @share_settings = args[:share_settings] if args.key?(:share_settings)
          @specific_reservation_required = args[:specific_reservation_required] if args.key?(:specific_reservation_required)
          @specific_sku_properties = args[:specific_sku_properties] if args.key?(:specific_sku_properties)
          @status = args[:status] if args.key?(:status)
          @time_window = args[:time_window] if args.key?(:time_window)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class FutureReservationCommitmentInfo
        include Google::Apis::Core::Hashable
      
        # name of the commitment where capacity is being delivered to.
        # Corresponds to the JSON property `commitmentName`
        # @return [String]
        attr_accessor :commitment_name
      
        # Indicates if a Commitment needs to be created as part of FR delivery. If
        # this field is not present, then no
        # commitment needs to be created.
        # Corresponds to the JSON property `commitmentPlan`
        # @return [String]
        attr_accessor :commitment_plan
      
        # Only applicable if FR is delivering to the same reservation. If set, all
        # parent commitments will be extended to match the end date of the plan for
        # this commitment.
        # Corresponds to the JSON property `previousCommitmentTerms`
        # @return [String]
        attr_accessor :previous_commitment_terms
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @commitment_name = args[:commitment_name] if args.key?(:commitment_name)
          @commitment_plan = args[:commitment_plan] if args.key?(:commitment_plan)
          @previous_commitment_terms = args[:previous_commitment_terms] if args.key?(:previous_commitment_terms)
        end
      end
      
      # 
      class FutureReservationSpecificSkuProperties
        include Google::Apis::Core::Hashable
      
        # Properties of the SKU instances being reserved.
        # Next ID: 9
        # Corresponds to the JSON property `instanceProperties`
        # @return [Google::Apis::ComputeV1::AllocationSpecificSkuAllocationReservedInstanceProperties]
        attr_accessor :instance_properties
      
        # The instance template that will be used to populate the
        # ReservedInstanceProperties of the future reservation
        # Corresponds to the JSON property `sourceInstanceTemplate`
        # @return [String]
        attr_accessor :source_instance_template
      
        # Total number of instances for which capacity assurance is requested at a
        # future time period.
        # Corresponds to the JSON property `totalCount`
        # @return [Fixnum]
        attr_accessor :total_count
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_properties = args[:instance_properties] if args.key?(:instance_properties)
          @source_instance_template = args[:source_instance_template] if args.key?(:source_instance_template)
          @total_count = args[:total_count] if args.key?(:total_count)
        end
      end
      
      # [Output only] Represents status related to the future reservation.
      class FutureReservationStatus
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] The current status of the requested amendment.
        # Corresponds to the JSON property `amendmentStatus`
        # @return [String]
        attr_accessor :amendment_status
      
        # Output only. Fully qualified urls of the automatically created reservations at
        # start_time.
        # Corresponds to the JSON property `autoCreatedReservations`
        # @return [Array<String>]
        attr_accessor :auto_created_reservations
      
        # [Output Only] Represents the existing matching usage for the future
        # reservation.
        # Corresponds to the JSON property `existingMatchingUsageInfo`
        # @return [Google::Apis::ComputeV1::FutureReservationStatusExistingMatchingUsageInfo]
        attr_accessor :existing_matching_usage_info
      
        # Output only. This count indicates the fulfilled capacity so far. This is set
        # during
        # "PROVISIONING" state. This count also includes capacity delivered as part
        # of existing matching reservations.
        # Corresponds to the JSON property `fulfilledCount`
        # @return [Fixnum]
        attr_accessor :fulfilled_count
      
        # The state that the future reservation will be reverted to should the
        # amendment be declined.
        # Corresponds to the JSON property `lastKnownGoodState`
        # @return [Google::Apis::ComputeV1::FutureReservationStatusLastKnownGoodState]
        attr_accessor :last_known_good_state
      
        # Output only. Time when Future Reservation would become LOCKED, after which no
        # modifications to Future Reservation will be allowed. Applicable only
        # after the Future Reservation is in the APPROVED state. The lock_time is
        # an RFC3339 string. The procurement_status will transition to PROCURING
        # state at this time.
        # Corresponds to the JSON property `lockTime`
        # @return [String]
        attr_accessor :lock_time
      
        # Output only. Current state of this Future Reservation
        # Corresponds to the JSON property `procurementStatus`
        # @return [String]
        attr_accessor :procurement_status
      
        # Properties to be set for the Future Reservation.
        # Corresponds to the JSON property `specificSkuProperties`
        # @return [Google::Apis::ComputeV1::FutureReservationStatusSpecificSkuProperties]
        attr_accessor :specific_sku_properties
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @amendment_status = args[:amendment_status] if args.key?(:amendment_status)
          @auto_created_reservations = args[:auto_created_reservations] if args.key?(:auto_created_reservations)
          @existing_matching_usage_info = args[:existing_matching_usage_info] if args.key?(:existing_matching_usage_info)
          @fulfilled_count = args[:fulfilled_count] if args.key?(:fulfilled_count)
          @last_known_good_state = args[:last_known_good_state] if args.key?(:last_known_good_state)
          @lock_time = args[:lock_time] if args.key?(:lock_time)
          @procurement_status = args[:procurement_status] if args.key?(:procurement_status)
          @specific_sku_properties = args[:specific_sku_properties] if args.key?(:specific_sku_properties)
        end
      end
      
      # [Output Only] Represents the existing matching usage for the future
      # reservation.
      class FutureReservationStatusExistingMatchingUsageInfo
        include Google::Apis::Core::Hashable
      
        # Output only. Count to represent min(FR total_count,
        # matching_reserved_capacity+matching_unreserved_instances)
        # Corresponds to the JSON property `count`
        # @return [Fixnum]
        attr_accessor :count
      
        # Output only. Timestamp when the matching usage was calculated
        # Corresponds to the JSON property `timestamp`
        # @return [String]
        attr_accessor :timestamp
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @count = args[:count] if args.key?(:count)
          @timestamp = args[:timestamp] if args.key?(:timestamp)
        end
      end
      
      # The state that the future reservation will be reverted to should the
      # amendment be declined.
      class FutureReservationStatusLastKnownGoodState
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] The description of the FutureReservation before an
        # amendment was requested.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # [Output Only] Represents the existing matching usage for the future
        # reservation.
        # Corresponds to the JSON property `existingMatchingUsageInfo`
        # @return [Google::Apis::ComputeV1::FutureReservationStatusExistingMatchingUsageInfo]
        attr_accessor :existing_matching_usage_info
      
        # The properties of the last known good state for the Future Reservation.
        # Corresponds to the JSON property `futureReservationSpecs`
        # @return [Google::Apis::ComputeV1::FutureReservationStatusLastKnownGoodStateFutureReservationSpecs]
        attr_accessor :future_reservation_specs
      
        # Output only. [Output Only] The lock time of the FutureReservation before an
        # amendment was requested.
        # Corresponds to the JSON property `lockTime`
        # @return [String]
        attr_accessor :lock_time
      
        # Output only. [Output Only] The name prefix of the Future Reservation before an
        # amendment was requested.
        # Corresponds to the JSON property `namePrefix`
        # @return [String]
        attr_accessor :name_prefix
      
        # Output only. [Output Only] The status of the last known good state for the
        # Future
        # Reservation.
        # Corresponds to the JSON property `procurementStatus`
        # @return [String]
        attr_accessor :procurement_status
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @description = args[:description] if args.key?(:description)
          @existing_matching_usage_info = args[:existing_matching_usage_info] if args.key?(:existing_matching_usage_info)
          @future_reservation_specs = args[:future_reservation_specs] if args.key?(:future_reservation_specs)
          @lock_time = args[:lock_time] if args.key?(:lock_time)
          @name_prefix = args[:name_prefix] if args.key?(:name_prefix)
          @procurement_status = args[:procurement_status] if args.key?(:procurement_status)
        end
      end
      
      # The properties of the last known good state for the Future Reservation.
      class FutureReservationStatusLastKnownGoodStateFutureReservationSpecs
        include Google::Apis::Core::Hashable
      
        # The share setting for reservations and sole tenancy node groups.
        # Corresponds to the JSON property `shareSettings`
        # @return [Google::Apis::ComputeV1::ShareSettings]
        attr_accessor :share_settings
      
        # Output only. [Output Only] The previous instance related properties of the
        # Future Reservation.
        # Corresponds to the JSON property `specificSkuProperties`
        # @return [Google::Apis::ComputeV1::FutureReservationSpecificSkuProperties]
        attr_accessor :specific_sku_properties
      
        # Output only. [Output Only] The previous time window of the Future Reservation.
        # Corresponds to the JSON property `timeWindow`
        # @return [Google::Apis::ComputeV1::FutureReservationTimeWindow]
        attr_accessor :time_window
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @share_settings = args[:share_settings] if args.key?(:share_settings)
          @specific_sku_properties = args[:specific_sku_properties] if args.key?(:specific_sku_properties)
          @time_window = args[:time_window] if args.key?(:time_window)
        end
      end
      
      # Properties to be set for the Future Reservation.
      class FutureReservationStatusSpecificSkuProperties
        include Google::Apis::Core::Hashable
      
        # ID of the instance template used to populate the Future Reservation
        # properties.
        # Corresponds to the JSON property `sourceInstanceTemplateId`
        # @return [String]
        attr_accessor :source_instance_template_id
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @source_instance_template_id = args[:source_instance_template_id] if args.key?(:source_instance_template_id)
        end
      end
      
      # 
      class FutureReservationTimeWindow
        include Google::Apis::Core::Hashable
      
        # A Duration represents a fixed-length span of time represented
        # as a count of seconds and fractions of seconds at nanosecond
        # resolution. It is independent of any calendar and concepts like "day"
        # or "month". Range is approximately 10,000 years.
        # Corresponds to the JSON property `duration`
        # @return [Google::Apis::ComputeV1::Duration]
        attr_accessor :duration
      
        # 
        # Corresponds to the JSON property `endTime`
        # @return [String]
        attr_accessor :end_time
      
        # Start time of the Future Reservation. The start_time is an RFC3339
        # string.
        # Corresponds to the JSON property `startTime`
        # @return [String]
        attr_accessor :start_time
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @duration = args[:duration] if args.key?(:duration)
          @end_time = args[:end_time] if args.key?(:end_time)
          @start_time = args[:start_time] if args.key?(:start_time)
        end
      end
      
      # Contains a list of future reservations.
      class FutureReservationsAggregatedListResponse
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `etag`
        # @return [String]
        attr_accessor :etag
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Future reservation resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeV1::FutureReservationsScopedList>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Alwayscompute#
        # futureReservationsAggregatedListResponse for future
        # resevation aggregated list response.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Unreachable resources.
        # Corresponds to the JSON property `unreachables`
        # @return [Array<String>]
        attr_accessor :unreachables
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::FutureReservationsAggregatedListResponse::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @etag = args[:etag] if args.key?(:etag)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @unreachables = args[:unreachables] if args.key?(:unreachables)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::FutureReservationsAggregatedListResponse::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class FutureReservationsListResponse
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `etag`
        # @return [String]
        attr_accessor :etag
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # [Output Only] A list of future reservation resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::FutureReservation>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource.Alwayscompute#
        # FutureReservationsListResponse for lists of
        # reservations
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Unreachable resources.
        # Corresponds to the JSON property `unreachables`
        # @return [Array<String>]
        attr_accessor :unreachables
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::FutureReservationsListResponse::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @etag = args[:etag] if args.key?(:etag)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @unreachables = args[:unreachables] if args.key?(:unreachables)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::FutureReservationsListResponse::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class FutureReservationsScopedList
        include Google::Apis::Core::Hashable
      
        # A list of future reservations contained in this scope.
        # Corresponds to the JSON property `futureReservations`
        # @return [Array<Google::Apis::ComputeV1::FutureReservation>]
        attr_accessor :future_reservations
      
        # Informational warning which replaces the list of future reservations when
        # the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::FutureReservationsScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @future_reservations = args[:future_reservations] if args.key?(:future_reservations)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Informational warning which replaces the list of future reservations when
        # the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::FutureReservationsScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Recommendation for single resources specification, to be created in the
      # future.
      class FutureResourcesRecommendation
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `endTime`
        # @return [String]
        attr_accessor :end_time
      
        # The advised location for resource usage. When a zone, in format
        # 'zones/'.
        # If not set, it means that no location is recommended - see
        # other_locations for details.
        # Corresponds to the JSON property `location`
        # @return [String]
        attr_accessor :location
      
        # List of locations in the request scope that were not
        # recommended. Keys of the map are zones, in format 'zones/'.
        # The values are status information indicating the recommendation status.
        # Corresponds to the JSON property `otherLocations`
        # @return [Hash<String,Google::Apis::ComputeV1::FutureResourcesRecommendationOtherLocation>]
        attr_accessor :other_locations
      
        # Unique id of the recommendation, a UUID string generated by the API.
        # Corresponds to the JSON property `recommendationId`
        # @return [String]
        attr_accessor :recommendation_id
      
        # Type of recommendation. Currently only FUTURE_RESERVATION is supported.
        # Corresponds to the JSON property `recommendationType`
        # @return [String]
        attr_accessor :recommendation_type
      
        # 
        # Corresponds to the JSON property `startTime`
        # @return [String]
        attr_accessor :start_time
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @end_time = args[:end_time] if args.key?(:end_time)
          @location = args[:location] if args.key?(:location)
          @other_locations = args[:other_locations] if args.key?(:other_locations)
          @recommendation_id = args[:recommendation_id] if args.key?(:recommendation_id)
          @recommendation_type = args[:recommendation_type] if args.key?(:recommendation_type)
          @start_time = args[:start_time] if args.key?(:start_time)
        end
      end
      
      # Information about recommendation status for locations
      # that were allowed but not used by the response.
      class FutureResourcesRecommendationOtherLocation
        include Google::Apis::Core::Hashable
      
        # Details (human readable) describing the situation.
        # For example, if status is CONDITION_NOT_MET, then
        # details contain information about the parameters of the time window
        # that did not meet the required conditions.
        # Corresponds to the JSON property `details`
        # @return [String]
        attr_accessor :details
      
        # Status of recommendation in this location.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @details = args[:details] if args.key?(:details)
          @status = args[:status] if args.key?(:status)
        end
      end
      
      # Specification of resources to be created at some time in the future within an
      # optionally specified set of locations, and within the specified time range.
      class FutureResourcesSpec
        include Google::Apis::Core::Hashable
      
        # Indicates if the reservation allocation strategy is static (DENSE) or
        # dynamic (STANDARD). Defaults to DENSE.
        # Corresponds to the JSON property `deploymentType`
        # @return [String]
        attr_accessor :deployment_type
      
        # Specification of locations to create resources in.
        # Corresponds to the JSON property `locationPolicy`
        # @return [Google::Apis::ComputeV1::FutureResourcesSpecLocationPolicy]
        attr_accessor :location_policy
      
        # Specification of reserved resources.
        # Corresponds to the JSON property `targetResources`
        # @return [Google::Apis::ComputeV1::FutureResourcesSpecTargetResources]
        attr_accessor :target_resources
      
        # Specifies a flexible time range with flexible start time and duration.
        # It is possible to specify a contradictory time range that cannot be matched
        # by any Interval. This causes a validation error.
        # Corresponds to the JSON property `timeRangeSpec`
        # @return [Google::Apis::ComputeV1::FlexibleTimeRange]
        attr_accessor :time_range_spec
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @deployment_type = args[:deployment_type] if args.key?(:deployment_type)
          @location_policy = args[:location_policy] if args.key?(:location_policy)
          @target_resources = args[:target_resources] if args.key?(:target_resources)
          @time_range_spec = args[:time_range_spec] if args.key?(:time_range_spec)
        end
      end
      
      # 
      class FutureResourcesSpecAggregateResources
        include Google::Apis::Core::Hashable
      
        # Size of the request, in accelerator (chip) count.
        # Corresponds to the JSON property `acceleratorCount`
        # @return [Fixnum]
        attr_accessor :accelerator_count
      
        # The VM family that all instances scheduled against this reservation
        # must belong to. Use for TPU reservations.
        # Corresponds to the JSON property `vmFamily`
        # @return [String]
        attr_accessor :vm_family
      
        # Workload type. Use for TPU reservations.
        # Corresponds to the JSON property `workloadType`
        # @return [String]
        attr_accessor :workload_type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @accelerator_count = args[:accelerator_count] if args.key?(:accelerator_count)
          @vm_family = args[:vm_family] if args.key?(:vm_family)
          @workload_type = args[:workload_type] if args.key?(:workload_type)
        end
      end
      
      # 
      class FutureResourcesSpecLocalSsdPartition
        include Google::Apis::Core::Hashable
      
        # Disk interface. Defaults to SCSI.
        # Corresponds to the JSON property `diskInterface`
        # @return [String]
        attr_accessor :disk_interface
      
        # The size of the disk in GB.
        # Corresponds to the JSON property `diskSizeGb`
        # @return [Fixnum]
        attr_accessor :disk_size_gb
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @disk_interface = args[:disk_interface] if args.key?(:disk_interface)
          @disk_size_gb = args[:disk_size_gb] if args.key?(:disk_size_gb)
        end
      end
      
      # Specification of locations to create resources in.
      class FutureResourcesSpecLocationPolicy
        include Google::Apis::Core::Hashable
      
        # Preferences for specified locations.
        # Keys of the map are locations - zones, in format of 'zones/'.
        # Values are preferences for the zones.
        # If a zone is not specified in this map, it is ALLOWed.
        # Corresponds to the JSON property `locations`
        # @return [Hash<String,Google::Apis::ComputeV1::FutureResourcesSpecLocationPolicyLocation>]
        attr_accessor :locations
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @locations = args[:locations] if args.key?(:locations)
        end
      end
      
      # Preference for a single specified location.
      class FutureResourcesSpecLocationPolicyLocation
        include Google::Apis::Core::Hashable
      
        # Preference for this location.
        # Corresponds to the JSON property `preference`
        # @return [String]
        attr_accessor :preference
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @preference = args[:preference] if args.key?(:preference)
        end
      end
      
      # 
      class FutureResourcesSpecSpecificSkuResources
        include Google::Apis::Core::Hashable
      
        # Size of the request, in instance count.
        # Corresponds to the JSON property `instanceCount`
        # @return [Fixnum]
        attr_accessor :instance_count
      
        # Local SSD partitions. You do not have to include SSD partitions that
        # are built in the machine type.
        # Corresponds to the JSON property `localSsdPartitions`
        # @return [Array<Google::Apis::ComputeV1::FutureResourcesSpecLocalSsdPartition>]
        attr_accessor :local_ssd_partitions
      
        # The machine type to use for instances that will use the reservation.
        # This field only accepts machine type names. e.g. n2-standard-4
        # and does not accept machine type full or partial url. e.g.
        # projects/my-l7ilb-project/zones/us-central1-a/machineTypes/n2-standard-4.
        # Use for GPU reservations.
        # Corresponds to the JSON property `machineType`
        # @return [String]
        attr_accessor :machine_type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_count = args[:instance_count] if args.key?(:instance_count)
          @local_ssd_partitions = args[:local_ssd_partitions] if args.key?(:local_ssd_partitions)
          @machine_type = args[:machine_type] if args.key?(:machine_type)
        end
      end
      
      # Specification of reserved resources.
      class FutureResourcesSpecTargetResources
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `aggregateResources`
        # @return [Google::Apis::ComputeV1::FutureResourcesSpecAggregateResources]
        attr_accessor :aggregate_resources
      
        # 
        # Corresponds to the JSON property `specificSkuResources`
        # @return [Google::Apis::ComputeV1::FutureResourcesSpecSpecificSkuResources]
        attr_accessor :specific_sku_resources
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @aggregate_resources = args[:aggregate_resources] if args.key?(:aggregate_resources)
          @specific_sku_resources = args[:specific_sku_resources] if args.key?(:specific_sku_resources)
        end
      end
      
      # 
      class GrpcHealthCheck
        include Google::Apis::Core::Hashable
      
        # The gRPC service name for the health check. This field is optional. The
        # value of grpc_service_name has the following meanings by convention:
        # - Empty service_name means the overall status of all services at the
        # backend.
        # - Non-empty service_name means the health of that gRPC service, as defined
        # by the owner of the service.
        # The grpc_service_name can only be ASCII.
        # Corresponds to the JSON property `grpcServiceName`
        # @return [String]
        attr_accessor :grpc_service_name
      
        # The TCP port number to which the health check prober sends packets. Valid
        # values are 1 through 65535.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        # Not supported.
        # Corresponds to the JSON property `portName`
        # @return [String]
        attr_accessor :port_name
      
        # Specifies how a port is selected for health checking. Can be one of the
        # following values:
        # USE_FIXED_PORT: Specifies a port number explicitly using theport field  in the
        # health check. Supported by backend services
        # for passthrough load balancers and backend services for proxy load
        # balancers. Not supported by target pools. The health check supports all
        # backends supported by the backend service provided the backend can be
        # health checked. For example, GCE_VM_IP network endpoint
        # groups, GCE_VM_IP_PORT network endpoint groups, and instance
        # group backends.
        # USE_NAMED_PORT: Not supported.
        # USE_SERVING_PORT: Provides an indirect method of specifying
        # the health check port by referring to the backend service. Only supported
        # by backend services for proxy load balancers. Not supported by target
        # pools.  Not supported by backend services for passthrough load balancers.
        # Supports all backends that can be health checked; for example,GCE_VM_IP_PORT
        # network endpoint groups and instance group
        # backends.
        # For GCE_VM_IP_PORT network endpoint group backends, the health
        # check uses the port number specified for each endpoint in the network
        # endpoint group.  For instance group backends, the health check uses the
        # port number determined by looking up the backend service's named port in
        # the instance group's list of named ports.
        # Corresponds to the JSON property `portSpecification`
        # @return [String]
        attr_accessor :port_specification
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @grpc_service_name = args[:grpc_service_name] if args.key?(:grpc_service_name)
          @port = args[:port] if args.key?(:port)
          @port_name = args[:port_name] if args.key?(:port_name)
          @port_specification = args[:port_specification] if args.key?(:port_specification)
        end
      end
      
      # 
      class GrpctlsHealthCheck
        include Google::Apis::Core::Hashable
      
        # The gRPC service name for the health check. This field is optional. The
        # value of grpc_service_name has the following meanings by convention:
        # - Empty service_name means the overall status of all services at the
        # backend.
        # - Non-empty service_name means the health of that gRPC service, as defined
        # by the owner of the service.
        # The grpc_service_name can only be ASCII.
        # Corresponds to the JSON property `grpcServiceName`
        # @return [String]
        attr_accessor :grpc_service_name
      
        # The TCP port number to which the health check prober sends packets. Valid
        # values are 1 through 65535.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        # Specifies how a port is selected for health checking. Can be one of the
        # following values:
        # USE_FIXED_PORT: Specifies a port number explicitly using theport field  in the
        # health check. Supported by backend services
        # for passthrough load balancers and backend services for proxy load
        # balancers. Not supported by target pools. The health check supports all
        # backends supported by the backend service provided the backend can be
        # health checked. For example, GCE_VM_IP network endpoint
        # groups, GCE_VM_IP_PORT network endpoint groups, and instance
        # group backends.
        # USE_NAMED_PORT: Not supported.
        # USE_SERVING_PORT: Provides an indirect method of specifying
        # the health check port by referring to the backend service. Only supported
        # by backend services for proxy load balancers. Not supported by target
        # pools.  Not supported by backend services for passthrough load balancers.
        # Supports all backends that can be health checked; for example,GCE_VM_IP_PORT
        # network endpoint groups and instance group
        # backends.
        # For GCE_VM_IP_PORT network endpoint group backends, the health
        # check uses the port number specified for each endpoint in the network
        # endpoint group.  For instance group backends, the health check uses the
        # port number determined by looking up the backend service's named port in
        # the instance group's list of named ports.
        # Corresponds to the JSON property `portSpecification`
        # @return [String]
        attr_accessor :port_specification
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @grpc_service_name = args[:grpc_service_name] if args.key?(:grpc_service_name)
          @port = args[:port] if args.key?(:port)
          @port_specification = args[:port_specification] if args.key?(:port_specification)
        end
      end
      
      # 
      class GlobalAddressesMoveRequest
        include Google::Apis::Core::Hashable
      
        # An optional destination address description if intended to be different
        # from the source.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # The URL of the destination address to move to. This can be a full or
        # partial URL. For example, the following are all valid URLs to a address:
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/global/addresses/
        # address
        # - projects/project/global/addresses/address
        # Note that destination project must be different from the source project. So/
        # global/addresses/address is not valid partial url.
        # Corresponds to the JSON property `destinationAddress`
        # @return [String]
        attr_accessor :destination_address
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @description = args[:description] if args.key?(:description)
          @destination_address = args[:destination_address] if args.key?(:destination_address)
        end
      end
      
      # 
      class GlobalNetworkEndpointGroupsAttachEndpointsRequest
        include Google::Apis::Core::Hashable
      
        # The list of network endpoints to be attached.
        # Corresponds to the JSON property `networkEndpoints`
        # @return [Array<Google::Apis::ComputeV1::NetworkEndpoint>]
        attr_accessor :network_endpoints
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @network_endpoints = args[:network_endpoints] if args.key?(:network_endpoints)
        end
      end
      
      # 
      class GlobalNetworkEndpointGroupsDetachEndpointsRequest
        include Google::Apis::Core::Hashable
      
        # The list of network endpoints to be detached.
        # Corresponds to the JSON property `networkEndpoints`
        # @return [Array<Google::Apis::ComputeV1::NetworkEndpoint>]
        attr_accessor :network_endpoints
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @network_endpoints = args[:network_endpoints] if args.key?(:network_endpoints)
        end
      end
      
      # 
      class GlobalOrganizationSetPolicyRequest
        include Google::Apis::Core::Hashable
      
        # Flatten Policy to create a backward compatible wire-format.
        # Deprecated. Use 'policy' to specify bindings.
        # Corresponds to the JSON property `bindings`
        # @return [Array<Google::Apis::ComputeV1::Binding>]
        attr_accessor :bindings
      
        # Flatten Policy to create a backward compatible wire-format.
        # Deprecated. Use 'policy' to specify the etag.
        # Corresponds to the JSON property `etag`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :etag
      
        # An Identity and Access Management (IAM) policy, which specifies access
        # controls for Google Cloud resources.
        # A `Policy` is a collection of `bindings`. A `binding` binds one or more
        # `members`, or principals, to a single `role`. Principals can be user
        # accounts, service accounts, Google groups, and domains (such as G Suite). A
        # `role` is a named list of permissions; each `role` can be an IAM predefined
        # role or a user-created custom role.
        # For some types of Google Cloud resources, a `binding` can also specify a
        # `condition`, which is a logical expression that allows access to a resource
        # only if the expression evaluates to `true`. A condition can add constraints
        # based on attributes of the request, the resource, or both. To learn which
        # resources support conditions in their IAM policies, see the
        # [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-
        # policies).
        # **JSON example:**
        # ```
        # `
        # "bindings": [
        # `
        # "role": "roles/resourcemanager.organizationAdmin",
        # "members": [
        # "user:mike@example.com",
        # "group:admins@example.com",
        # "domain:google.com",
        # "serviceAccount:my-project-id@appspot.gserviceaccount.com"
        # ]
        # `,
        # `
        # "role": "roles/resourcemanager.organizationViewer",
        # "members": [
        # "user:eve@example.com"
        # ],
        # "condition": `
        # "title": "expirable access",
        # "description": "Does not grant access after Sep 2020",
        # "expression": "request.time < timestamp('2020-10-01T00:00:00.000Z')
        # ",
        # `
        # `
        # ],
        # "etag": "BwWWja0YfJA=",
        # "version": 3
        # `
        # ```
        # **YAML example:**
        # ```
        # bindings:
        # - members:
        # - user:mike@example.com
        # - group:admins@example.com
        # - domain:google.com
        # - serviceAccount:my-project-id@appspot.gserviceaccount.com
        # role: roles/resourcemanager.organizationAdmin
        # - members:
        # - user:eve@example.com
        # role: roles/resourcemanager.organizationViewer
        # condition:
        # title: expirable access
        # description: Does not grant access after Sep 2020
        # expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
        # etag: BwWWja0YfJA=
        # version: 3
        # ```
        # For a description of IAM and its features, see the
        # [IAM documentation](https://cloud.google.com/iam/docs/).
        # Corresponds to the JSON property `policy`
        # @return [Google::Apis::ComputeV1::Policy]
        attr_accessor :policy
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @bindings = args[:bindings] if args.key?(:bindings)
          @etag = args[:etag] if args.key?(:etag)
          @policy = args[:policy] if args.key?(:policy)
        end
      end
      
      # 
      class GlobalSetLabelsRequest
        include Google::Apis::Core::Hashable
      
        # The fingerprint of the previous set of labels for this resource,
        # used to detect conflicts. The fingerprint is initially generated by Compute
        # Engine and changes after every request to modify or update labels. You must
        # always provide an up-to-date fingerprint hash when updating or changing
        # labels, otherwise the request will fail with error412 conditionNotMet.  Make a
        # get() request to the
        # resource to get the latest fingerprint.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # A list of labels to apply for this resource. Each label must comply with
        # the
        # requirements for labels. For example,"webserver-frontend": "images". A label
        # value can also be
        # empty (e.g. "my-label": "").
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
        end
      end
      
      # 
      class GlobalSetPolicyRequest
        include Google::Apis::Core::Hashable
      
        # Flatten Policy to create a backward compatible wire-format.
        # Deprecated. Use 'policy' to specify bindings.
        # Corresponds to the JSON property `bindings`
        # @return [Array<Google::Apis::ComputeV1::Binding>]
        attr_accessor :bindings
      
        # Flatten Policy to create a backward compatible wire-format.
        # Deprecated. Use 'policy' to specify the etag.
        # Corresponds to the JSON property `etag`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :etag
      
        # An Identity and Access Management (IAM) policy, which specifies access
        # controls for Google Cloud resources.
        # A `Policy` is a collection of `bindings`. A `binding` binds one or more
        # `members`, or principals, to a single `role`. Principals can be user
        # accounts, service accounts, Google groups, and domains (such as G Suite). A
        # `role` is a named list of permissions; each `role` can be an IAM predefined
        # role or a user-created custom role.
        # For some types of Google Cloud resources, a `binding` can also specify a
        # `condition`, which is a logical expression that allows access to a resource
        # only if the expression evaluates to `true`. A condition can add constraints
        # based on attributes of the request, the resource, or both. To learn which
        # resources support conditions in their IAM policies, see the
        # [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-
        # policies).
        # **JSON example:**
        # ```
        # `
        # "bindings": [
        # `
        # "role": "roles/resourcemanager.organizationAdmin",
        # "members": [
        # "user:mike@example.com",
        # "group:admins@example.com",
        # "domain:google.com",
        # "serviceAccount:my-project-id@appspot.gserviceaccount.com"
        # ]
        # `,
        # `
        # "role": "roles/resourcemanager.organizationViewer",
        # "members": [
        # "user:eve@example.com"
        # ],
        # "condition": `
        # "title": "expirable access",
        # "description": "Does not grant access after Sep 2020",
        # "expression": "request.time < timestamp('2020-10-01T00:00:00.000Z')
        # ",
        # `
        # `
        # ],
        # "etag": "BwWWja0YfJA=",
        # "version": 3
        # `
        # ```
        # **YAML example:**
        # ```
        # bindings:
        # - members:
        # - user:mike@example.com
        # - group:admins@example.com
        # - domain:google.com
        # - serviceAccount:my-project-id@appspot.gserviceaccount.com
        # role: roles/resourcemanager.organizationAdmin
        # - members:
        # - user:eve@example.com
        # role: roles/resourcemanager.organizationViewer
        # condition:
        # title: expirable access
        # description: Does not grant access after Sep 2020
        # expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
        # etag: BwWWja0YfJA=
        # version: 3
        # ```
        # For a description of IAM and its features, see the
        # [IAM documentation](https://cloud.google.com/iam/docs/).
        # Corresponds to the JSON property `policy`
        # @return [Google::Apis::ComputeV1::Policy]
        attr_accessor :policy
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @bindings = args[:bindings] if args.key?(:bindings)
          @etag = args[:etag] if args.key?(:etag)
          @policy = args[:policy] if args.key?(:policy)
        end
      end
      
      # Maintenance Info for ReservationBlocks.
      class GroupMaintenanceInfo
        include Google::Apis::Core::Hashable
      
        # Describes number of instances that have ongoing maintenance.
        # Corresponds to the JSON property `instanceMaintenanceOngoingCount`
        # @return [Fixnum]
        attr_accessor :instance_maintenance_ongoing_count
      
        # Describes number of instances that have pending maintenance.
        # Corresponds to the JSON property `instanceMaintenancePendingCount`
        # @return [Fixnum]
        attr_accessor :instance_maintenance_pending_count
      
        # Progress for ongoing maintenance for this group of VMs/hosts.
        # Describes number of hosts in the block that have ongoing maintenance.
        # Corresponds to the JSON property `maintenanceOngoingCount`
        # @return [Fixnum]
        attr_accessor :maintenance_ongoing_count
      
        # Progress for ongoing maintenance for this group of VMs/hosts.
        # Describes number of hosts in the block that have pending maintenance.
        # Corresponds to the JSON property `maintenancePendingCount`
        # @return [Fixnum]
        attr_accessor :maintenance_pending_count
      
        # The type of maintenance for the reservation.
        # Corresponds to the JSON property `schedulingType`
        # @return [String]
        attr_accessor :scheduling_type
      
        # Describes number of subblock Infrastructure that has ongoing maintenance.
        # Here, Subblock Infrastructure Maintenance pertains to upstream hardware
        # contained in the Subblock that is necessary for a VM Family(e.g. NVLink
        # Domains). Not all VM Families will support this field.
        # Corresponds to the JSON property `subblockInfraMaintenanceOngoingCount`
        # @return [Fixnum]
        attr_accessor :subblock_infra_maintenance_ongoing_count
      
        # Describes number of subblock Infrastructure that has pending maintenance.
        # Here, Subblock Infrastructure Maintenance pertains to upstream hardware
        # contained in the Subblock that is necessary for a VM Family (e.g. NVLink
        # Domains). Not all VM Families will support this field.
        # Corresponds to the JSON property `subblockInfraMaintenancePendingCount`
        # @return [Fixnum]
        attr_accessor :subblock_infra_maintenance_pending_count
      
        # Upcoming Maintenance notification information.
        # Corresponds to the JSON property `upcomingGroupMaintenance`
        # @return [Google::Apis::ComputeV1::UpcomingMaintenance]
        attr_accessor :upcoming_group_maintenance
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_maintenance_ongoing_count = args[:instance_maintenance_ongoing_count] if args.key?(:instance_maintenance_ongoing_count)
          @instance_maintenance_pending_count = args[:instance_maintenance_pending_count] if args.key?(:instance_maintenance_pending_count)
          @maintenance_ongoing_count = args[:maintenance_ongoing_count] if args.key?(:maintenance_ongoing_count)
          @maintenance_pending_count = args[:maintenance_pending_count] if args.key?(:maintenance_pending_count)
          @scheduling_type = args[:scheduling_type] if args.key?(:scheduling_type)
          @subblock_infra_maintenance_ongoing_count = args[:subblock_infra_maintenance_ongoing_count] if args.key?(:subblock_infra_maintenance_ongoing_count)
          @subblock_infra_maintenance_pending_count = args[:subblock_infra_maintenance_pending_count] if args.key?(:subblock_infra_maintenance_pending_count)
          @upcoming_group_maintenance = args[:upcoming_group_maintenance] if args.key?(:upcoming_group_maintenance)
        end
      end
      
      # A guest attributes entry.
      class GuestAttributes
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Type of the resource. Alwayscompute#guestAttributes
        # for guest attributes entry.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The path to be queried. This can be the default namespace ('') or a
        # nested namespace ('\/') or a specified key
        # ('\/\').
        # Corresponds to the JSON property `queryPath`
        # @return [String]
        attr_accessor :query_path
      
        # Array of guest attribute namespace/key/value tuples.
        # Corresponds to the JSON property `queryValue`
        # @return [Google::Apis::ComputeV1::GuestAttributesValue]
        attr_accessor :query_value
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # The key to search for.
        # Corresponds to the JSON property `variableKey`
        # @return [String]
        attr_accessor :variable_key
      
        # Output only. [Output Only] The value found for the requested key.
        # Corresponds to the JSON property `variableValue`
        # @return [String]
        attr_accessor :variable_value
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @kind = args[:kind] if args.key?(:kind)
          @query_path = args[:query_path] if args.key?(:query_path)
          @query_value = args[:query_value] if args.key?(:query_value)
          @self_link = args[:self_link] if args.key?(:self_link)
          @variable_key = args[:variable_key] if args.key?(:variable_key)
          @variable_value = args[:variable_value] if args.key?(:variable_value)
        end
      end
      
      # A guest attributes namespace/key/value entry.
      class GuestAttributesEntry
        include Google::Apis::Core::Hashable
      
        # Key for the guest attribute entry.
        # Corresponds to the JSON property `key`
        # @return [String]
        attr_accessor :key
      
        # Namespace for the guest attribute entry.
        # Corresponds to the JSON property `namespace`
        # @return [String]
        attr_accessor :namespace
      
        # Value for the guest attribute entry.
        # Corresponds to the JSON property `value`
        # @return [String]
        attr_accessor :value
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @key = args[:key] if args.key?(:key)
          @namespace = args[:namespace] if args.key?(:namespace)
          @value = args[:value] if args.key?(:value)
        end
      end
      
      # Array of guest attribute namespace/key/value tuples.
      class GuestAttributesValue
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::GuestAttributesEntry>]
        attr_accessor :items
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @items = args[:items] if args.key?(:items)
        end
      end
      
      # Guest OS features.
      class GuestOsFeature
        include Google::Apis::Core::Hashable
      
        # The ID of a supported feature. To add multiple values, use commas to
        # separate values. Set to one or more of the following values:
        # 
        # - VIRTIO_SCSI_MULTIQUEUE
        # - WINDOWS
        # - MULTI_IP_SUBNET
        # - UEFI_COMPATIBLE
        # - GVNIC
        # - SEV_CAPABLE
        # - SUSPEND_RESUME_COMPATIBLE
        # - SEV_LIVE_MIGRATABLE_V2
        # - SEV_SNP_CAPABLE
        # - TDX_CAPABLE
        # - IDPF
        # - SNP_SVSM_CAPABLE
        # For more information, see
        # Enabling guest operating system features.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # 
      class Http2HealthCheck
        include Google::Apis::Core::Hashable
      
        # The value of the host header in the HTTP/2 health check request. If left
        # empty (default value), the host header is set to the destination IP address
        # to which health check packets are sent. The destination IP address depends
        # on the type of load balancer. For details, see:
        # https://cloud.google.com/load-balancing/docs/health-check-concepts#hc-packet-
        # dest
        # Corresponds to the JSON property `host`
        # @return [String]
        attr_accessor :host
      
        # The TCP port number to which the health check prober sends packets. The
        # default value is 443. Valid values are 1 through65535.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        # Not supported.
        # Corresponds to the JSON property `portName`
        # @return [String]
        attr_accessor :port_name
      
        # Specifies how a port is selected for health checking. Can be one of the
        # following values:
        # USE_FIXED_PORT: Specifies a port number explicitly using theport field  in the
        # health check. Supported by backend services
        # for passthrough load balancers and backend services for proxy load
        # balancers. Not supported by target pools. The health check supports all
        # backends supported by the backend service provided the backend can be
        # health checked. For example, GCE_VM_IP network endpoint
        # groups, GCE_VM_IP_PORT network endpoint groups, and instance
        # group backends.
        # USE_NAMED_PORT: Not supported.
        # USE_SERVING_PORT: Provides an indirect method of specifying
        # the health check port by referring to the backend service. Only supported
        # by backend services for proxy load balancers. Not supported by target
        # pools.  Not supported by backend services for passthrough load balancers.
        # Supports all backends that can be health checked; for example,GCE_VM_IP_PORT
        # network endpoint groups and instance group
        # backends.
        # For GCE_VM_IP_PORT network endpoint group backends, the health
        # check uses the port number specified for each endpoint in the network
        # endpoint group.  For instance group backends, the health check uses the
        # port number determined by looking up the backend service's named port in
        # the instance group's list of named ports.
        # Corresponds to the JSON property `portSpecification`
        # @return [String]
        attr_accessor :port_specification
      
        # Specifies the type of proxy header to append before sending data to the
        # backend, either NONE or PROXY_V1. The default
        # is NONE.
        # Corresponds to the JSON property `proxyHeader`
        # @return [String]
        attr_accessor :proxy_header
      
        # The request path of the HTTP/2 health check request. The default value is/.
        # Must comply withRFC3986.
        # Corresponds to the JSON property `requestPath`
        # @return [String]
        attr_accessor :request_path
      
        # Creates a content-based HTTP/2 health check. In addition to the required
        # HTTP 200 (OK) status code, you can configure the health check to pass only
        # when the backend sends this specific ASCII response string within the first
        # 1024 bytes of the HTTP response body. For details, see:
        # https://cloud.google.com/load-balancing/docs/health-check-concepts#criteria-
        # protocol-http
        # Corresponds to the JSON property `response`
        # @return [String]
        attr_accessor :response
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @host = args[:host] if args.key?(:host)
          @port = args[:port] if args.key?(:port)
          @port_name = args[:port_name] if args.key?(:port_name)
          @port_specification = args[:port_specification] if args.key?(:port_specification)
          @proxy_header = args[:proxy_header] if args.key?(:proxy_header)
          @request_path = args[:request_path] if args.key?(:request_path)
          @response = args[:response] if args.key?(:response)
        end
      end
      
      # 
      class HttpHealthCheck
        include Google::Apis::Core::Hashable
      
        # The value of the host header in the HTTP health check request. If left
        # empty (default value), the host header is set to the destination IP address
        # to which health check packets are sent. The destination IP address depends
        # on the type of load balancer. For details, see:
        # https://cloud.google.com/load-balancing/docs/health-check-concepts#hc-packet-
        # dest
        # Corresponds to the JSON property `host`
        # @return [String]
        attr_accessor :host
      
        # The TCP port number to which the health check prober sends packets. The
        # default value is 80. Valid values are 1 through65535.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        # Not supported.
        # Corresponds to the JSON property `portName`
        # @return [String]
        attr_accessor :port_name
      
        # Specifies how a port is selected for health checking. Can be one of the
        # following values:
        # USE_FIXED_PORT: Specifies a port number explicitly using theport field  in the
        # health check. Supported by backend services
        # for passthrough load balancers and backend services for proxy load
        # balancers. Also supported in legacy HTTP health checks for target pools.
        # The health check supports all backends supported by the backend service
        # provided the backend can be health checked. For example,GCE_VM_IP network
        # endpoint groups, GCE_VM_IP_PORT
        # network endpoint groups, and instance group backends.
        # USE_NAMED_PORT: Not supported.
        # USE_SERVING_PORT: Provides an indirect method of specifying
        # the health check port by referring to the backend service. Only supported
        # by backend services for proxy load balancers. Not supported by target
        # pools.  Not supported by backend services for pass-through load balancers.
        # Supports all backends that can be health checked; for example,GCE_VM_IP_PORT
        # network endpoint groups and instance group
        # backends.
        # For GCE_VM_IP_PORT network endpoint group backends, the health
        # check uses the port number specified for each endpoint in the network
        # endpoint group.  For instance group backends, the health check uses the
        # port number determined by looking up the backend service's named port in
        # the instance group's list of named ports.
        # Corresponds to the JSON property `portSpecification`
        # @return [String]
        attr_accessor :port_specification
      
        # Specifies the type of proxy header to append before sending data to the
        # backend, either NONE or PROXY_V1. The default
        # is NONE.
        # Corresponds to the JSON property `proxyHeader`
        # @return [String]
        attr_accessor :proxy_header
      
        # The request path of the HTTP health check request. The default value is/. Must
        # comply withRFC3986.
        # Corresponds to the JSON property `requestPath`
        # @return [String]
        attr_accessor :request_path
      
        # Creates a content-based HTTP health check. In addition to the required
        # HTTP 200 (OK) status code, you can configure the health check to pass only
        # when the backend sends this specific ASCII response string within the first
        # 1024 bytes of the HTTP response body. For details, see:
        # https://cloud.google.com/load-balancing/docs/health-check-concepts#criteria-
        # protocol-http
        # Corresponds to the JSON property `response`
        # @return [String]
        attr_accessor :response
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @host = args[:host] if args.key?(:host)
          @port = args[:port] if args.key?(:port)
          @port_name = args[:port_name] if args.key?(:port_name)
          @port_specification = args[:port_specification] if args.key?(:port_specification)
          @proxy_header = args[:proxy_header] if args.key?(:proxy_header)
          @request_path = args[:request_path] if args.key?(:request_path)
          @response = args[:response] if args.key?(:response)
        end
      end
      
      # 
      class HttpsHealthCheck
        include Google::Apis::Core::Hashable
      
        # The value of the host header in the HTTPS health check request. If left
        # empty (default value), the host header is set to the destination IP address
        # to which health check packets are sent. The destination IP address depends
        # on the type of load balancer. For details, see:
        # https://cloud.google.com/load-balancing/docs/health-check-concepts#hc-packet-
        # dest
        # Corresponds to the JSON property `host`
        # @return [String]
        attr_accessor :host
      
        # The TCP port number to which the health check prober sends packets. The
        # default value is 443. Valid values are 1 through65535.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        # Not supported.
        # Corresponds to the JSON property `portName`
        # @return [String]
        attr_accessor :port_name
      
        # Specifies how a port is selected for health checking. Can be one of the
        # following values:
        # USE_FIXED_PORT: Specifies a port number explicitly using theport field  in the
        # health check. Supported by backend services
        # for passthrough load balancers and backend services for proxy load
        # balancers. Not supported by target pools. The health check supports all
        # backends supported by the backend service provided the backend can be
        # health checked. For example, GCE_VM_IP network endpoint
        # groups, GCE_VM_IP_PORT network endpoint groups, and instance
        # group backends.
        # USE_NAMED_PORT: Not supported.
        # USE_SERVING_PORT: Provides an indirect method of specifying
        # the health check port by referring to the backend service. Only supported
        # by backend services for proxy load balancers. Not supported by target
        # pools.  Not supported by backend services for passthrough load balancers.
        # Supports all backends that can be health checked; for example,GCE_VM_IP_PORT
        # network endpoint groups and instance group
        # backends.
        # For GCE_VM_IP_PORT network endpoint group backends, the health
        # check uses the port number specified for each endpoint in the network
        # endpoint group.  For instance group backends, the health check uses the
        # port number determined by looking up the backend service's named port in
        # the instance group's list of named ports.
        # Corresponds to the JSON property `portSpecification`
        # @return [String]
        attr_accessor :port_specification
      
        # Specifies the type of proxy header to append before sending data to the
        # backend, either NONE or PROXY_V1. The default
        # is NONE.
        # Corresponds to the JSON property `proxyHeader`
        # @return [String]
        attr_accessor :proxy_header
      
        # The request path of the HTTPS health check request. The default value is/.
        # Must comply withRFC3986.
        # Corresponds to the JSON property `requestPath`
        # @return [String]
        attr_accessor :request_path
      
        # Creates a content-based HTTPS health check. In addition to the required
        # HTTP 200 (OK) status code, you can configure the health check to pass only
        # when the backend sends this specific ASCII response string within the first
        # 1024 bytes of the HTTP response body. For details, see:
        # https://cloud.google.com/load-balancing/docs/health-check-concepts#criteria-
        # protocol-http
        # Corresponds to the JSON property `response`
        # @return [String]
        attr_accessor :response
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @host = args[:host] if args.key?(:host)
          @port = args[:port] if args.key?(:port)
          @port_name = args[:port_name] if args.key?(:port_name)
          @port_specification = args[:port_specification] if args.key?(:port_specification)
          @proxy_header = args[:proxy_header] if args.key?(:proxy_header)
          @request_path = args[:request_path] if args.key?(:request_path)
          @response = args[:response] if args.key?(:response)
        end
      end
      
      # Represents a health check resource.
      # Google Compute Engine has two health check resources:
      # * [Regional](/compute/docs/reference/rest/v1/regionHealthChecks)
      # * [Global](/compute/docs/reference/rest/v1/healthChecks)
      # These health check resources can be used for load balancing and for
      # autohealing VMs in a managed instance group (MIG).
      # **Load balancing**
      # Health check requirements vary depending on the type of load balancer. For
      # details about the type of health check supported for
      # each load balancer and corresponding backend type,
      # see Health
      # checks overview: Load balancer guide.
      # **Autohealing in MIGs**
      # The health checks that you use for autohealing VMs in a MIG can be either
      # regional or global. For more information, see  Set up an
      # application health check and autohealing.
      # For more information, seeHealth checks
      # overview.
      class HealthCheck
        include Google::Apis::Core::Hashable
      
        # How often (in seconds) to send a health check. The default value is 5
        # seconds.
        # Corresponds to the JSON property `checkIntervalSec`
        # @return [Fixnum]
        attr_accessor :check_interval_sec
      
        # Output only. [Output Only] Creation timestamp in3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # 
        # Corresponds to the JSON property `grpcHealthCheck`
        # @return [Google::Apis::ComputeV1::GrpcHealthCheck]
        attr_accessor :grpc_health_check
      
        # 
        # Corresponds to the JSON property `grpcTlsHealthCheck`
        # @return [Google::Apis::ComputeV1::GrpctlsHealthCheck]
        attr_accessor :grpc_tls_health_check
      
        # A so-far unhealthy instance will be marked healthy after this
        # many consecutive successes. The default value is 2.
        # Corresponds to the JSON property `healthyThreshold`
        # @return [Fixnum]
        attr_accessor :healthy_threshold
      
        # 
        # Corresponds to the JSON property `http2HealthCheck`
        # @return [Google::Apis::ComputeV1::Http2HealthCheck]
        attr_accessor :http2_health_check
      
        # 
        # Corresponds to the JSON property `httpHealthCheck`
        # @return [Google::Apis::ComputeV1::HttpHealthCheck]
        attr_accessor :http_health_check
      
        # 
        # Corresponds to the JSON property `httpsHealthCheck`
        # @return [Google::Apis::ComputeV1::HttpsHealthCheck]
        attr_accessor :https_health_check
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. Type of the resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Configuration of logging on a health check. If logging is enabled, logs
        # will be exported to Stackdriver.
        # Corresponds to the JSON property `logConfig`
        # @return [Google::Apis::ComputeV1::HealthCheckLogConfig]
        attr_accessor :log_config
      
        # Name of the resource. Provided by the client when the resource is created.
        # The name must be 1-63 characters long, and comply withRFC1035.
        # For example, a name that is 1-63 characters long, matches the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise complies with
        # RFC1035. This regular expression describes a name where the first
        # character is a lowercase letter, and all following characters are a dash,
        # lowercase letter, or digit, except the last character, which isn't a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Output only. [Output Only] Region where the health check resides.  Not
        # applicable to
        # global health checks.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # The list of cloud regions from which health checks are performed. If any
        # regions are specified, then exactly 3 regions should be specified. The
        # region names must be valid names of Google Cloud regions.
        # This can only be set for global health check.
        # If this list is non-empty, then there are restrictions
        # on what other health check fields are supported and what other resources
        # can use this health check:
        # 
        # - SSL, HTTP2, and GRPC protocols are not supported.
        # - The TCP request field is not supported.
        # - The proxyHeader field for HTTP, HTTPS, and TCP is not
        # supported.
        # - The checkIntervalSec field must be at least 30.
        # - The health check cannot be used with BackendService nor with managed
        # instance group auto-healing.
        # Corresponds to the JSON property `sourceRegions`
        # @return [Array<String>]
        attr_accessor :source_regions
      
        # 
        # Corresponds to the JSON property `sslHealthCheck`
        # @return [Google::Apis::ComputeV1::SslHealthCheck]
        attr_accessor :ssl_health_check
      
        # 
        # Corresponds to the JSON property `tcpHealthCheck`
        # @return [Google::Apis::ComputeV1::TcpHealthCheck]
        attr_accessor :tcp_health_check
      
        # How long (in seconds) to wait before claiming failure. The default value is
        # 5 seconds. It is invalid for timeoutSec to have greater
        # value than checkIntervalSec.
        # Corresponds to the JSON property `timeoutSec`
        # @return [Fixnum]
        attr_accessor :timeout_sec
      
        # Specifies the type of the healthCheck, either TCP,SSL, HTTP, HTTPS,HTTP2 or
        # GRPC. Exactly one of the
        # protocol-specific health check fields must be specified, which must matchtype
        # field.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        # A so-far healthy instance will be marked unhealthy after this many
        # consecutive failures. The default value is 2.
        # Corresponds to the JSON property `unhealthyThreshold`
        # @return [Fixnum]
        attr_accessor :unhealthy_threshold
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @check_interval_sec = args[:check_interval_sec] if args.key?(:check_interval_sec)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @grpc_health_check = args[:grpc_health_check] if args.key?(:grpc_health_check)
          @grpc_tls_health_check = args[:grpc_tls_health_check] if args.key?(:grpc_tls_health_check)
          @healthy_threshold = args[:healthy_threshold] if args.key?(:healthy_threshold)
          @http2_health_check = args[:http2_health_check] if args.key?(:http2_health_check)
          @http_health_check = args[:http_health_check] if args.key?(:http_health_check)
          @https_health_check = args[:https_health_check] if args.key?(:https_health_check)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @log_config = args[:log_config] if args.key?(:log_config)
          @name = args[:name] if args.key?(:name)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @source_regions = args[:source_regions] if args.key?(:source_regions)
          @ssl_health_check = args[:ssl_health_check] if args.key?(:ssl_health_check)
          @tcp_health_check = args[:tcp_health_check] if args.key?(:tcp_health_check)
          @timeout_sec = args[:timeout_sec] if args.key?(:timeout_sec)
          @type = args[:type] if args.key?(:type)
          @unhealthy_threshold = args[:unhealthy_threshold] if args.key?(:unhealthy_threshold)
        end
      end
      
      # Contains a list of HealthCheck resources.
      class HealthCheckList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of HealthCheck resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::HealthCheck>]
        attr_accessor :items
      
        # Output only. Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::HealthCheckList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::HealthCheckList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Configuration of logging on a health check. If logging is enabled, logs
      # will be exported to Stackdriver.
      class HealthCheckLogConfig
        include Google::Apis::Core::Hashable
      
        # Indicates whether or not to export logs. This is false by default, which
        # means no health check logging will be done.
        # Corresponds to the JSON property `enable`
        # @return [Boolean]
        attr_accessor :enable
        alias_method :enable?, :enable
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @enable = args[:enable] if args.key?(:enable)
        end
      end
      
      # A full or valid partial URL to a health check. For example, the following are
      # valid URLs:
      # 
      # - https://www.googleapis.com/compute/beta/projects/project-id/global/
      # httpHealthChecks/health-check
      # - projects/project-id/global/httpHealthChecks/health-check
      # - global/httpHealthChecks/health-check
      class HealthCheckReference
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `healthCheck`
        # @return [String]
        attr_accessor :health_check
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @health_check = args[:health_check] if args.key?(:health_check)
        end
      end
      
      # Represents a Health-Check as a Service resource.
      class HealthCheckService
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Fingerprint of this resource. A hash of the contents stored in this object.
        # This field is used in optimistic locking. This field will be ignored when
        # inserting a HealthCheckService. An up-to-date fingerprint must
        # be provided in order to patch/update the HealthCheckService; Otherwise, the
        # request will fail with error 412 conditionNotMet. To see the
        # latest fingerprint, make a get() request to retrieve the
        # HealthCheckService.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # A list of URLs to the HealthCheck resources. Must have
        # at least one HealthCheck, and not more than 10 for regionalHealthCheckService,
        # and not more than 1 for globalHealthCheckService.HealthCheck resources must
        # haveportSpecification=USE_SERVING_PORT orportSpecification=USE_FIXED_PORT. For
        # regional HealthCheckService, theHealthCheck must be regional and in the same
        # region. For global HealthCheckService,HealthCheck must be global. Mix of
        # regional and globalHealthChecks is not supported. Multiple
        # regionalHealthChecks must belong to the same region. RegionalHealthChecks must
        # belong to the same region as zones ofNetworkEndpointGroups. For
        # globalHealthCheckService using globalINTERNET_IP_PORT NetworkEndpointGroups,
        # the
        # global HealthChecks must specify sourceRegions,
        # and HealthChecks that specify sourceRegions can
        # only be used with global INTERNET_IP_PORTNetworkEndpointGroups.
        # Corresponds to the JSON property `healthChecks`
        # @return [Array<String>]
        attr_accessor :health_checks
      
        # Optional. Policy for how the results from multiple health checks
        # for the same endpoint are aggregated. Defaults to NO_AGGREGATION
        # if unspecified.
        # 
        # - NO_AGGREGATION. An EndpointHealth message is
        # returned for each  pair in the health check
        # service.
        # - AND. If any health check of an endpoint reportsUNHEALTHY, then UNHEALTHY
        # is theHealthState of the endpoint. If all health checks reportHEALTHY, the
        # HealthState of the endpoint isHEALTHY.
        # .
        # This is only allowed with regional HealthCheckService.
        # Corresponds to the JSON property `healthStatusAggregationPolicy`
        # @return [String]
        attr_accessor :health_status_aggregation_policy
      
        # Output only. [Output Only] The unique identifier for the resource. This
        # identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. [Output only] Type of the resource. Alwayscompute#
        # healthCheckServicefor health check services.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource. The name must be 1-63 characters long, and comply
        # with RFC1035. Specifically, the name must be 1-63 characters
        # long and match the regular expression
        # `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
        # must be a lowercase letter, and all following characters must be a dash,
        # lowercase letter, or digit, except the last character, which cannot be a
        # dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # A list of URLs to the NetworkEndpointGroup
        # resources. Must not have more than 100.  For regionalHealthCheckService, NEGs
        # must be in
        # zones in the region of the HealthCheckService. For globalHealthCheckServices,
        # the NetworkEndpointGroups
        # must be global INTERNET_IP_PORT.
        # Corresponds to the JSON property `networkEndpointGroups`
        # @return [Array<String>]
        attr_accessor :network_endpoint_groups
      
        # A list of URLs to the NotificationEndpoint
        # resources. Must not have more than 10.  A list of endpoints for
        # receiving notifications of change in health status. For
        # regionalHealthCheckService,NotificationEndpoint must be regional and in the
        # same region. For global HealthCheckService,NotificationEndpoint must be global.
        # Corresponds to the JSON property `notificationEndpoints`
        # @return [Array<String>]
        attr_accessor :notification_endpoints
      
        # Output only. [Output Only] URL of the region where the health check service
        # resides. This field is not applicable to global health check services.
        # You must specify this field as part of the HTTP request URL. It is
        # not settable as a field in the request body.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # Output only. [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @health_checks = args[:health_checks] if args.key?(:health_checks)
          @health_status_aggregation_policy = args[:health_status_aggregation_policy] if args.key?(:health_status_aggregation_policy)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @network_endpoint_groups = args[:network_endpoint_groups] if args.key?(:network_endpoint_groups)
          @notification_endpoints = args[:notification_endpoints] if args.key?(:notification_endpoints)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
        end
      end
      
      # A full or valid partial URL to a health check service. For example, the
      # following are valid URLs:
      # 
      # - https://www.googleapis.com/compute/beta/projects/project-id/regions/us-
      # west1/healthCheckServices/health-check-service
      # - projects/project-id/regions/us-west1/healthCheckServices/health-check-
      # service
      # - regions/us-west1/healthCheckServices/health-check-service
      class HealthCheckServiceReference
        include Google::Apis::Core::Hashable
      
        # 
        # Corresponds to the JSON property `healthCheckService`
        # @return [String]
        attr_accessor :health_check_service
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @health_check_service = args[:health_check_service] if args.key?(:health_check_service)
        end
      end
      
      # 
      class HealthCheckServicesList
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Unique identifier for the resource; defined by the
        # server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # Output only. A list of HealthCheckService resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::HealthCheckService>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of the resource. Alwayscompute#
        # healthCheckServicesList for lists of
        # HealthCheckServices.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Output only. [Output Only] This token allows you to get the next page of
        # results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::HealthCheckServicesList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::HealthCheckServicesList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class HealthChecksAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of HealthChecksScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeV1::HealthChecksScopedList>]
        attr_accessor :items
      
        # Output only. Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Unreachable resources.
        # Corresponds to the JSON property `unreachables`
        # @return [Array<String>]
        attr_accessor :unreachables
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::HealthChecksAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @unreachables = args[:unreachables] if args.key?(:unreachables)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::HealthChecksAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class HealthChecksScopedList
        include Google::Apis::Core::Hashable
      
        # A list of HealthChecks contained in this scope.
        # Corresponds to the JSON property `healthChecks`
        # @return [Array<Google::Apis::ComputeV1::HealthCheck>]
        attr_accessor :health_checks
      
        # Informational warning which replaces the list of
        # backend services when the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::HealthChecksScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @health_checks = args[:health_checks] if args.key?(:health_checks)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Informational warning which replaces the list of
        # backend services when the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::HealthChecksScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class HealthStatus
        include Google::Apis::Core::Hashable
      
        # Metadata defined as annotations for network endpoint.
        # Corresponds to the JSON property `annotations`
        # @return [Hash<String,String>]
        attr_accessor :annotations
      
        # URL of the forwarding rule associated with the health status of the
        # instance.
        # Corresponds to the JSON property `forwardingRule`
        # @return [String]
        attr_accessor :forwarding_rule
      
        # A forwarding rule IP address assigned to this instance.
        # Corresponds to the JSON property `forwardingRuleIp`
        # @return [String]
        attr_accessor :forwarding_rule_ip
      
        # Health state of the IPv4 address of the instance.
        # Corresponds to the JSON property `healthState`
        # @return [String]
        attr_accessor :health_state
      
        # URL of the instance resource.
        # Corresponds to the JSON property `instance`
        # @return [String]
        attr_accessor :instance
      
        # For target pool based Network Load Balancing, it indicates the forwarding
        # rule's IP address assigned to this instance. For other types of load
        # balancing, the field indicates VM internal ip.
        # Corresponds to the JSON property `ipAddress`
        # @return [String]
        attr_accessor :ip_address
      
        # 
        # Corresponds to the JSON property `ipv6Address`
        # @return [String]
        attr_accessor :ipv6_address
      
        # Health state of the IPv6 address of the instance.
        # Corresponds to the JSON property `ipv6HealthState`
        # @return [String]
        attr_accessor :ipv6_health_state
      
        # The named port of the instance group, not necessarily the port that is
        # health-checked.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        # 
        # Corresponds to the JSON property `weight`
        # @return [String]
        attr_accessor :weight
      
        # 
        # Corresponds to the JSON property `weightError`
        # @return [String]
        attr_accessor :weight_error
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @annotations = args[:annotations] if args.key?(:annotations)
          @forwarding_rule = args[:forwarding_rule] if args.key?(:forwarding_rule)
          @forwarding_rule_ip = args[:forwarding_rule_ip] if args.key?(:forwarding_rule_ip)
          @health_state = args[:health_state] if args.key?(:health_state)
          @instance = args[:instance] if args.key?(:instance)
          @ip_address = args[:ip_address] if args.key?(:ip_address)
          @ipv6_address = args[:ipv6_address] if args.key?(:ipv6_address)
          @ipv6_health_state = args[:ipv6_health_state] if args.key?(:ipv6_health_state)
          @port = args[:port] if args.key?(:port)
          @weight = args[:weight] if args.key?(:weight)
          @weight_error = args[:weight_error] if args.key?(:weight_error)
        end
      end
      
      # 
      class HealthStatusForNetworkEndpoint
        include Google::Apis::Core::Hashable
      
        # URL of the backend service associated with the health state of the network
        # endpoint.
        # Corresponds to the JSON property `backendService`
        # @return [Google::Apis::ComputeV1::BackendServiceReference]
        attr_accessor :backend_service
      
        # URL of the forwarding rule associated with the health state of the network
        # endpoint.
        # Corresponds to the JSON property `forwardingRule`
        # @return [Google::Apis::ComputeV1::ForwardingRuleReference]
        attr_accessor :forwarding_rule
      
        # A full or valid partial URL to a health check. For example, the following are
        # valid URLs:
        # 
        # - https://www.googleapis.com/compute/beta/projects/project-id/global/
        # httpHealthChecks/health-check
        # - projects/project-id/global/httpHealthChecks/health-check
        # - global/httpHealthChecks/health-check
        # Corresponds to the JSON property `healthCheck`
        # @return [Google::Apis::ComputeV1::HealthCheckReference]
        attr_accessor :health_check
      
        # A full or valid partial URL to a health check service. For example, the
        # following are valid URLs:
        # 
        # - https://www.googleapis.com/compute/beta/projects/project-id/regions/us-
        # west1/healthCheckServices/health-check-service
        # - projects/project-id/regions/us-west1/healthCheckServices/health-check-
        # service
        # - regions/us-west1/healthCheckServices/health-check-service
        # Corresponds to the JSON property `healthCheckService`
        # @return [Google::Apis::ComputeV1::HealthCheckServiceReference]
        attr_accessor :health_check_service
      
        # Health state of the network endpoint determined based on the health checks
        # configured.
        # Corresponds to the JSON property `healthState`
        # @return [String]
        attr_accessor :health_state
      
        # Health state of the ipv6 network endpoint determined based on the health
        # checks configured.
        # Corresponds to the JSON property `ipv6HealthState`
        # @return [String]
        attr_accessor :ipv6_health_state
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @backend_service = args[:backend_service] if args.key?(:backend_service)
          @forwarding_rule = args[:forwarding_rule] if args.key?(:forwarding_rule)
          @health_check = args[:health_check] if args.key?(:health_check)
          @health_check_service = args[:health_check_service] if args.key?(:health_check_service)
          @health_state = args[:health_state] if args.key?(:health_state)
          @ipv6_health_state = args[:ipv6_health_state] if args.key?(:ipv6_health_state)
        end
      end
      
      # Provides links to documentation or for performing an out of band action.
      # For example, if a quota check failed with an error indicating the calling
      # project hasn't enabled the accessed service, this can contain a URL pointing
      # directly to the right place in the developer console to flip the bit.
      class Help
        include Google::Apis::Core::Hashable
      
        # URL(s) pointing to additional information on handling the current error.
        # Corresponds to the JSON property `links`
        # @return [Array<Google::Apis::ComputeV1::HelpLink>]
        attr_accessor :links
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @links = args[:links] if args.key?(:links)
        end
      end
      
      # Describes a URL link.
      class HelpLink
        include Google::Apis::Core::Hashable
      
        # Describes what the link offers.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # The URL of the link.
        # Corresponds to the JSON property `url`
        # @return [String]
        attr_accessor :url
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @description = args[:description] if args.key?(:description)
          @url = args[:url] if args.key?(:url)
        end
      end
      
      # UrlMaps
      # A host-matching rule for a URL. If matched, will use the namedPathMatcher to
      # select the BackendService.
      class HostRule
        include Google::Apis::Core::Hashable
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # The list of host patterns to match. They must be valid hostnames with
        # optional port numbers in the format host:port.* matches any string of ([a-z0-9-
        # .]*). In
        # that case, * must be the first character, and if followed by
        # anything, the immediate following character must be either -
        # or ..
        # * based matching is not supported when the URL map is bound
        # to a target gRPC proxy that has the validateForProxyless field
        # set to true.
        # Corresponds to the JSON property `hosts`
        # @return [Array<String>]
        attr_accessor :hosts
      
        # The name of the PathMatcher to use to match the path portion
        # of the URL if the hostRule matches the URL's host portion.
        # Corresponds to the JSON property `pathMatcher`
        # @return [String]
        attr_accessor :path_matcher
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @description = args[:description] if args.key?(:description)
          @hosts = args[:hosts] if args.key?(:hosts)
          @path_matcher = args[:path_matcher] if args.key?(:path_matcher)
        end
      end
      
      # Specification for how requests are aborted as part of fault injection.
      class HttpFaultAbort
        include Google::Apis::Core::Hashable
      
        # The HTTP status code used to abort the request.
        # The value must be from 200 to 599 inclusive.
        # For gRPC protocol, the gRPC status code is mapped to HTTP status code
        # according to this
        # mapping table. HTTP status 200 is mapped to gRPC status
        # UNKNOWN. Injecting an OK status is currently not supported by
        # Traffic Director.
        # Corresponds to the JSON property `httpStatus`
        # @return [Fixnum]
        attr_accessor :http_status
      
        # The percentage of traffic for connections, operations, or requests
        # that is aborted as part of fault injection.
        # The value must be from 0.0 to 100.0 inclusive.
        # Corresponds to the JSON property `percentage`
        # @return [Float]
        attr_accessor :percentage
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @http_status = args[:http_status] if args.key?(:http_status)
          @percentage = args[:percentage] if args.key?(:percentage)
        end
      end
      
      # Specifies the delay introduced by the load balancer before forwarding the
      # request to the backend service as part of fault injection.
      class HttpFaultDelay
        include Google::Apis::Core::Hashable
      
        # A Duration represents a fixed-length span of time represented
        # as a count of seconds and fractions of seconds at nanosecond
        # resolution. It is independent of any calendar and concepts like "day"
        # or "month". Range is approximately 10,000 years.
        # Corresponds to the JSON property `fixedDelay`
        # @return [Google::Apis::ComputeV1::Duration]
        attr_accessor :fixed_delay
      
        # The percentage of traffic for connections, operations, or requests for
        # which a delay is introduced as part of fault injection.
        # The value must be from 0.0 to 100.0 inclusive.
        # Corresponds to the JSON property `percentage`
        # @return [Float]
        attr_accessor :percentage
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @fixed_delay = args[:fixed_delay] if args.key?(:fixed_delay)
          @percentage = args[:percentage] if args.key?(:percentage)
        end
      end
      
      # The specification for fault injection introduced into traffic to test
      # the resiliency of clients to backend service failure. As part of fault
      # injection, when clients send requests to a backend service, delays can be
      # introduced by the load balancer on a percentage of requests before sending
      # those request to the backend service. Similarly requests from clients can be
      # aborted by the load balancer for a percentage of requests.
      class HttpFaultInjection
        include Google::Apis::Core::Hashable
      
        # Specification for how requests are aborted as part of fault injection.
        # Corresponds to the JSON property `abort`
        # @return [Google::Apis::ComputeV1::HttpFaultAbort]
        attr_accessor :abort
      
        # Specifies the delay introduced by the load balancer before forwarding the
        # request to the backend service as part of fault injection.
        # Corresponds to the JSON property `delay`
        # @return [Google::Apis::ComputeV1::HttpFaultDelay]
        attr_accessor :delay
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @abort = args[:abort] if args.key?(:abort)
          @delay = args[:delay] if args.key?(:delay)
        end
      end
      
      # The request and response header transformations that take effect before
      # the request is passed along to the selected backendService.
      class HttpHeaderAction
        include Google::Apis::Core::Hashable
      
        # Headers to add to a matching request before forwarding the request to
        # thebackendService.
        # Corresponds to the JSON property `requestHeadersToAdd`
        # @return [Array<Google::Apis::ComputeV1::HttpHeaderOption>]
        attr_accessor :request_headers_to_add
      
        # A list of header names for headers that need to be removed from the
        # request before forwarding the request to the backendService.
        # Corresponds to the JSON property `requestHeadersToRemove`
        # @return [Array<String>]
        attr_accessor :request_headers_to_remove
      
        # Headers to add the response before sending the response back to the
        # client.
        # Corresponds to the JSON property `responseHeadersToAdd`
        # @return [Array<Google::Apis::ComputeV1::HttpHeaderOption>]
        attr_accessor :response_headers_to_add
      
        # A list of header names for headers that need to be removed from the
        # response before sending the response back to the client.
        # Corresponds to the JSON property `responseHeadersToRemove`
        # @return [Array<String>]
        attr_accessor :response_headers_to_remove
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @request_headers_to_add = args[:request_headers_to_add] if args.key?(:request_headers_to_add)
          @request_headers_to_remove = args[:request_headers_to_remove] if args.key?(:request_headers_to_remove)
          @response_headers_to_add = args[:response_headers_to_add] if args.key?(:response_headers_to_add)
          @response_headers_to_remove = args[:response_headers_to_remove] if args.key?(:response_headers_to_remove)
        end
      end
      
      # matchRule criteria for request header matches.
      class HttpHeaderMatch
        include Google::Apis::Core::Hashable
      
        # The value should exactly match contents of exactMatch.
        # Only one of exactMatch, prefixMatch,suffixMatch, regexMatch,presentMatch or
        # rangeMatch must be set.
        # Corresponds to the JSON property `exactMatch`
        # @return [String]
        attr_accessor :exact_match
      
        # The name of the HTTP header to match.
        # For matching against the HTTP request's authority, use a headerMatch
        # with the header name ":authority".
        # For matching a request's method, use the headerName ":method".
        # When the URL map is bound to a target gRPC proxy that has
        # the validateForProxyless field set to true, only
        # non-binary
        # user-specified custom metadata and the `content-type` header are supported.
        # The following transport-level headers cannot be used in header matching
        # rules:
        # `:authority`, `:method`, `:path`, `:scheme`, `user-agent`,
        # `accept-encoding`, `content-encoding`, `grpc-accept-encoding`,
        # `grpc-encoding`, `grpc-previous-rpc-attempts`, `grpc-tags-bin`,
        # `grpc-timeout` and `grpc-trace-bin`.
        # Corresponds to the JSON property `headerName`
        # @return [String]
        attr_accessor :header_name
      
        # If set to false, the headerMatch is considered a
        # match if the preceding match criteria are met. If set to true,
        # the headerMatch is considered a match if the preceding
        # match criteria are NOT met.
        # The default setting is false.
        # Corresponds to the JSON property `invertMatch`
        # @return [Boolean]
        attr_accessor :invert_match
        alias_method :invert_match?, :invert_match
      
        # The value of the header must start with the contents ofprefixMatch.
        # Only one of exactMatch, prefixMatch,suffixMatch, regexMatch,presentMatch or
        # rangeMatch must be set.
        # Corresponds to the JSON property `prefixMatch`
        # @return [String]
        attr_accessor :prefix_match
      
        # A header with the contents of headerName must exist. The
        # match takes place whether or not the request's header has a value.
        # Only one of exactMatch, prefixMatch,suffixMatch, regexMatch,presentMatch or
        # rangeMatch must be set.
        # Corresponds to the JSON property `presentMatch`
        # @return [Boolean]
        attr_accessor :present_match
        alias_method :present_match?, :present_match
      
        # HttpRouteRuleMatch criteria for field values that must stay
        # within the specified integer range.
        # Corresponds to the JSON property `rangeMatch`
        # @return [Google::Apis::ComputeV1::Int64RangeMatch]
        attr_accessor :range_match
      
        # The value of the header must match the regular expression specified
        # inregexMatch.
        # For more information about regular expression syntax, see Syntax.
        # For matching against a port specified in the HTTP request, use a
        # headerMatch with headerName set to PORT and a regular expression that
        # satisfies the RFC2616 Host header's port specifier.
        # Only one of exactMatch, prefixMatch,suffixMatch, regexMatch,presentMatch or
        # rangeMatch must be set.
        # Regular expressions can only be used when the loadBalancingScheme is
        # set to INTERNAL_SELF_MANAGED, EXTERNAL_MANAGED
        # (regional scope) or INTERNAL_MANAGED.
        # Corresponds to the JSON property `regexMatch`
        # @return [String]
        attr_accessor :regex_match
      
        # The value of the header must end with the contents ofsuffixMatch.
        # Only one of exactMatch, prefixMatch,suffixMatch, regexMatch,presentMatch or
        # rangeMatch must be set.
        # Corresponds to the JSON property `suffixMatch`
        # @return [String]
        attr_accessor :suffix_match
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @exact_match = args[:exact_match] if args.key?(:exact_match)
          @header_name = args[:header_name] if args.key?(:header_name)
          @invert_match = args[:invert_match] if args.key?(:invert_match)
          @prefix_match = args[:prefix_match] if args.key?(:prefix_match)
          @present_match = args[:present_match] if args.key?(:present_match)
          @range_match = args[:range_match] if args.key?(:range_match)
          @regex_match = args[:regex_match] if args.key?(:regex_match)
          @suffix_match = args[:suffix_match] if args.key?(:suffix_match)
        end
      end
      
      # Specification determining how headers are added to requests or responses.
      class HttpHeaderOption
        include Google::Apis::Core::Hashable
      
        # The name of the header.
        # Corresponds to the JSON property `headerName`
        # @return [String]
        attr_accessor :header_name
      
        # The value of the header to add.
        # Corresponds to the JSON property `headerValue`
        # @return [String]
        attr_accessor :header_value
      
        # If false, headerValue is appended to any values
        # that already
        # exist for the header. If true, headerValue is set for the
        # header, discarding any values that were set for that header.
        # The default value is true,
        # unless a variable is present in headerValue,
        # in which case the default value is false.
        # .
        # Corresponds to the JSON property `replace`
        # @return [Boolean]
        attr_accessor :replace
        alias_method :replace?, :replace
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @header_name = args[:header_name] if args.key?(:header_name)
          @header_value = args[:header_value] if args.key?(:header_value)
          @replace = args[:replace] if args.key?(:replace)
        end
      end
      
      # Represents a legacy HTTP Health Check resource.
      # Legacy HTTP health checks are now only required by target pool-based network
      # load balancers. For all other load balancers, including backend service-based
      # network load balancers, and for managed instance group auto-healing, you must
      # use modern (non-legacy) health checks.
      # For more information, seeHealth checks
      # overview.
      class HttpHealthCheck
        include Google::Apis::Core::Hashable
      
        # How often (in seconds) to send a health check. The default value is5 seconds.
        # Corresponds to the JSON property `checkIntervalSec`
        # @return [Fixnum]
        attr_accessor :check_interval_sec
      
        # [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # A so-far unhealthy instance will be marked healthy after this
        # many consecutive successes. The default value is 2.
        # Corresponds to the JSON property `healthyThreshold`
        # @return [Fixnum]
        attr_accessor :healthy_threshold
      
        # The value of the host header in the HTTP health check request. If left
        # empty (default value), the public IP on behalf of which this health check
        # is performed will be used.
        # Corresponds to the JSON property `host`
        # @return [String]
        attr_accessor :host
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. [Output Only] Type of the resource. Alwayscompute#httpHealthCheck
        # for HTTP health checks.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource. Provided by the client when the resource is created.
        # The name must be 1-63 characters long, and comply withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must
        # be a dash, lowercase letter, or digit, except the last character, which
        # cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The TCP port number for the HTTP health check request. The default value is80.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        # The request path of the HTTP health check request. The default value is/. This
        # field does not support query
        # parameters. Must comply withRFC3986.
        # Corresponds to the JSON property `requestPath`
        # @return [String]
        attr_accessor :request_path
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # How long (in seconds) to wait before claiming failure. The default value is5
        # seconds. It is invalid for timeoutSec to have
        # greater value than checkIntervalSec.
        # Corresponds to the JSON property `timeoutSec`
        # @return [Fixnum]
        attr_accessor :timeout_sec
      
        # A so-far healthy instance will be marked unhealthy after this
        # many consecutive failures. The default value is 2.
        # Corresponds to the JSON property `unhealthyThreshold`
        # @return [Fixnum]
        attr_accessor :unhealthy_threshold
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @check_interval_sec = args[:check_interval_sec] if args.key?(:check_interval_sec)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @healthy_threshold = args[:healthy_threshold] if args.key?(:healthy_threshold)
          @host = args[:host] if args.key?(:host)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @port = args[:port] if args.key?(:port)
          @request_path = args[:request_path] if args.key?(:request_path)
          @self_link = args[:self_link] if args.key?(:self_link)
          @timeout_sec = args[:timeout_sec] if args.key?(:timeout_sec)
          @unhealthy_threshold = args[:unhealthy_threshold] if args.key?(:unhealthy_threshold)
        end
      end
      
      # Contains a list of HttpHealthCheck resources.
      class HttpHealthCheckList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of HttpHealthCheck resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::HttpHealthCheck>]
        attr_accessor :items
      
        # Output only. Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::HttpHealthCheckList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::HttpHealthCheckList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # HttpRouteRuleMatch criteria for a request's query parameter.
      class HttpQueryParameterMatch
        include Google::Apis::Core::Hashable
      
        # The queryParameterMatch matches if the value of the
        # parameter exactly matches the contents of exactMatch.
        # Only one of presentMatch, exactMatch, orregexMatch must be set.
        # Corresponds to the JSON property `exactMatch`
        # @return [String]
        attr_accessor :exact_match
      
        # The name of the query parameter to match. The query parameter must exist in
        # the request, in the absence of which the request match fails.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Specifies that the queryParameterMatch matches if the
        # request contains the query parameter, irrespective of whether the
        # parameter has a value or not.
        # Only one of presentMatch, exactMatch, orregexMatch must be set.
        # Corresponds to the JSON property `presentMatch`
        # @return [Boolean]
        attr_accessor :present_match
        alias_method :present_match?, :present_match
      
        # The queryParameterMatch matches if the value of the
        # parameter matches the regular expression specified byregexMatch. For
        # more information about regular expression syntax, see Syntax.
        # Only one of presentMatch, exactMatch, orregexMatch must be set.
        # Regular expressions can only be used when the loadBalancingScheme is
        # set to INTERNAL_SELF_MANAGED, EXTERNAL_MANAGED
        # (regional scope) or INTERNAL_MANAGED.
        # Corresponds to the JSON property `regexMatch`
        # @return [String]
        attr_accessor :regex_match
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @exact_match = args[:exact_match] if args.key?(:exact_match)
          @name = args[:name] if args.key?(:name)
          @present_match = args[:present_match] if args.key?(:present_match)
          @regex_match = args[:regex_match] if args.key?(:regex_match)
        end
      end
      
      # Specifies settings for an HTTP redirect.
      class HttpRedirectAction
        include Google::Apis::Core::Hashable
      
        # The host that is used in the redirect response instead of the one that
        # was supplied in the request.
        # The value must be from 1 to 255
        # characters.
        # Corresponds to the JSON property `hostRedirect`
        # @return [String]
        attr_accessor :host_redirect
      
        # If set to true, the URL scheme in the redirected request is
        # set to HTTPS.
        # If set to false, the URL scheme of the redirected request
        # remains the same as that of the request.
        # This must only be set for URL maps used inTargetHttpProxys. Setting this true
        # forTargetHttpsProxy is not permitted.
        # The default is set to false.
        # Corresponds to the JSON property `httpsRedirect`
        # @return [Boolean]
        attr_accessor :https_redirect
        alias_method :https_redirect?, :https_redirect
      
        # The path that is used in the redirect response instead of the one
        # that was supplied in the request.
        # pathRedirect cannot be supplied together withprefixRedirect. Supply one alone
        # or neither. If neither is
        # supplied, the path of the original request is used for the redirect.
        # The value must be from 1 to 1024 characters.
        # Corresponds to the JSON property `pathRedirect`
        # @return [String]
        attr_accessor :path_redirect
      
        # The prefix that replaces the prefixMatch specified in
        # the HttpRouteRuleMatch, retaining the remaining portion
        # of the URL before redirecting the request.
        # prefixRedirect cannot be supplied together withpathRedirect. Supply one alone
        # or neither. If neither is
        # supplied, the path of the original request is used for the redirect.
        # The value must be from 1 to 1024 characters.
        # Corresponds to the JSON property `prefixRedirect`
        # @return [String]
        attr_accessor :prefix_redirect
      
        # The HTTP Status code to use for this RedirectAction.
        # Supported values are:
        # 
        # - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds
        # to 301.
        # - FOUND, which corresponds to 302.
        # - SEE_OTHER which corresponds to 303.
        # - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request
        # method is retained.
        # - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request
        # method is retained.
        # Corresponds to the JSON property `redirectResponseCode`
        # @return [String]
        attr_accessor :redirect_response_code
      
        # If set to true, any accompanying query portion of the original
        # URL is
        # removed before redirecting the request. If set to false, the
        # query portion of the original URL is retained.
        # The default is set to false.
        # Corresponds to the JSON property `stripQuery`
        # @return [Boolean]
        attr_accessor :strip_query
        alias_method :strip_query?, :strip_query
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @host_redirect = args[:host_redirect] if args.key?(:host_redirect)
          @https_redirect = args[:https_redirect] if args.key?(:https_redirect)
          @path_redirect = args[:path_redirect] if args.key?(:path_redirect)
          @prefix_redirect = args[:prefix_redirect] if args.key?(:prefix_redirect)
          @redirect_response_code = args[:redirect_response_code] if args.key?(:redirect_response_code)
          @strip_query = args[:strip_query] if args.key?(:strip_query)
        end
      end
      
      # The retry policy associates with HttpRouteRule
      class HttpRetryPolicy
        include Google::Apis::Core::Hashable
      
        # Specifies the allowed number retries. This number must be > 0.
        # If not specified, defaults to 1.
        # Corresponds to the JSON property `numRetries`
        # @return [Fixnum]
        attr_accessor :num_retries
      
        # A Duration represents a fixed-length span of time represented
        # as a count of seconds and fractions of seconds at nanosecond
        # resolution. It is independent of any calendar and concepts like "day"
        # or "month". Range is approximately 10,000 years.
        # Corresponds to the JSON property `perTryTimeout`
        # @return [Google::Apis::ComputeV1::Duration]
        attr_accessor :per_try_timeout
      
        # Specifies one or more conditions when this retry policy applies. Valid
        # values are:
        # 
        # - 5xx: retry is attempted if the instance or endpoint
        # responds with any 5xx response code, or if the instance or
        # endpoint does not respond at all. For example, disconnects, reset, read
        # timeout, connection failure, and refused streams.
        # - gateway-error: Similar to 5xx, but only
        # applies to response codes 502, 503 or504.
        # - connect-failure: a retry is attempted on failures
        # connecting to the instance or endpoint. For example, connection
        # timeouts.
        # - retriable-4xx: a retry is attempted if the instance
        # or endpoint responds with a 4xx response code.
        # The only error that you can retry is error code 409.
        # - refused-stream: a retry is attempted if the instance
        # or endpoint resets the stream with a REFUSED_STREAM error
        # code. This reset type indicates that it is safe to retry.
        # - cancelled: a retry is attempted if the gRPC status
        # code in the response header is set to cancelled.
        # - deadline-exceeded: a retry is attempted if the gRPC
        # status code in the response header is set todeadline-exceeded.
        # - internal: a retry is attempted if the gRPC
        # status code in the response header is set tointernal.
        # - resource-exhausted: a retry is attempted if the gRPC
        # status code in the response header is set toresource-exhausted.
        # - unavailable: a retry is attempted if the gRPC
        # status code in the response header is set tounavailable.
        # Only the following codes are supported when the URL map is bound to
        # target gRPC proxy that has validateForProxyless field set to true.
        # 
        # - cancelled
        # - deadline-exceeded
        # - internal
        # - resource-exhausted
        # - unavailable
        # Corresponds to the JSON property `retryConditions`
        # @return [Array<String>]
        attr_accessor :retry_conditions
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @num_retries = args[:num_retries] if args.key?(:num_retries)
          @per_try_timeout = args[:per_try_timeout] if args.key?(:per_try_timeout)
          @retry_conditions = args[:retry_conditions] if args.key?(:retry_conditions)
        end
      end
      
      # 
      class HttpRouteAction
        include Google::Apis::Core::Hashable
      
        # The specification for allowing client-side cross-origin requests. For more
        # information about the W3C recommendation for cross-origin resource sharing
        # (CORS), see Fetch API Living
        # Standard.
        # Corresponds to the JSON property `corsPolicy`
        # @return [Google::Apis::ComputeV1::CorsPolicy]
        attr_accessor :cors_policy
      
        # The specification for fault injection introduced into traffic to test
        # the resiliency of clients to backend service failure. As part of fault
        # injection, when clients send requests to a backend service, delays can be
        # introduced by the load balancer on a percentage of requests before sending
        # those request to the backend service. Similarly requests from clients can be
        # aborted by the load balancer for a percentage of requests.
        # Corresponds to the JSON property `faultInjectionPolicy`
        # @return [Google::Apis::ComputeV1::HttpFaultInjection]
        attr_accessor :fault_injection_policy
      
        # A Duration represents a fixed-length span of time represented
        # as a count of seconds and fractions of seconds at nanosecond
        # resolution. It is independent of any calendar and concepts like "day"
        # or "month". Range is approximately 10,000 years.
        # Corresponds to the JSON property `maxStreamDuration`
        # @return [Google::Apis::ComputeV1::Duration]
        attr_accessor :max_stream_duration
      
        # A policy that specifies how requests intended for the route's backends
        # are shadowed to a separate mirrored backend service. The load balancer
        # doesn't wait for responses from the shadow service. Before sending traffic
        # to the shadow service, the host or authority header is suffixed with-shadow.
        # Corresponds to the JSON property `requestMirrorPolicy`
        # @return [Google::Apis::ComputeV1::RequestMirrorPolicy]
        attr_accessor :request_mirror_policy
      
        # The retry policy associates with HttpRouteRule
        # Corresponds to the JSON property `retryPolicy`
        # @return [Google::Apis::ComputeV1::HttpRetryPolicy]
        attr_accessor :retry_policy
      
        # A Duration represents a fixed-length span of time represented
        # as a count of seconds and fractions of seconds at nanosecond
        # resolution. It is independent of any calendar and concepts like "day"
        # or "month". Range is approximately 10,000 years.
        # Corresponds to the JSON property `timeout`
        # @return [Google::Apis::ComputeV1::Duration]
        attr_accessor :timeout
      
        # The spec for modifying the path before sending the request to the matched
        # backend service.
        # Corresponds to the JSON property `urlRewrite`
        # @return [Google::Apis::ComputeV1::UrlRewrite]
        attr_accessor :url_rewrite
      
        # A list of weighted backend services to send traffic to when a route match
        # occurs. The weights determine the fraction of traffic that flows to
        # their corresponding backend service. If all traffic needs to
        # go to a single backend service, there must be oneweightedBackendService with
        # weight set to a non-zero number.
        # After a backend service is identified and before forwarding
        # the request to
        # the backend service, advanced routing actions such as URL rewrites and
        # header transformations are applied depending on additional settings
        # specified in this HttpRouteAction.
        # Corresponds to the JSON property `weightedBackendServices`
        # @return [Array<Google::Apis::ComputeV1::WeightedBackendService>]
        attr_accessor :weighted_backend_services
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @cors_policy = args[:cors_policy] if args.key?(:cors_policy)
          @fault_injection_policy = args[:fault_injection_policy] if args.key?(:fault_injection_policy)
          @max_stream_duration = args[:max_stream_duration] if args.key?(:max_stream_duration)
          @request_mirror_policy = args[:request_mirror_policy] if args.key?(:request_mirror_policy)
          @retry_policy = args[:retry_policy] if args.key?(:retry_policy)
          @timeout = args[:timeout] if args.key?(:timeout)
          @url_rewrite = args[:url_rewrite] if args.key?(:url_rewrite)
          @weighted_backend_services = args[:weighted_backend_services] if args.key?(:weighted_backend_services)
        end
      end
      
      # The HttpRouteRule setting specifies how to match an HTTP request
      # and the corresponding routing action that load balancing proxies perform.
      class HttpRouteRule
        include Google::Apis::Core::Hashable
      
        # Specifies the custom error response policy that must be applied when the
        # backend service or backend bucket responds with an error.
        # Corresponds to the JSON property `customErrorResponsePolicy`
        # @return [Google::Apis::ComputeV1::CustomErrorResponsePolicy]
        attr_accessor :custom_error_response_policy
      
        # The short description conveying the intent of this routeRule.
        # The description can have a maximum length of 1024 characters.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # The request and response header transformations that take effect before
        # the request is passed along to the selected backendService.
        # Corresponds to the JSON property `headerAction`
        # @return [Google::Apis::ComputeV1::HttpHeaderAction]
        attr_accessor :header_action
      
        # The list of criteria for matching attributes of a request to thisrouteRule.
        # This list has OR semantics: the request matches
        # this routeRule when any of thematchRules are satisfied. However predicates
        # within
        # a given matchRule have AND semantics. All predicates
        # within a matchRule must match for the request to
        # match the rule.
        # Corresponds to the JSON property `matchRules`
        # @return [Array<Google::Apis::ComputeV1::HttpRouteRuleMatch>]
        attr_accessor :match_rules
      
        # For routeRules within a given pathMatcher,
        # priority determines the order in which a load balancer interpretsrouteRules.
        # RouteRules are evaluated in order
        # of priority, from the lowest to highest number. The priority of a
        # rule decreases as its number increases (1, 2, 3, N+1). The first rule
        # that matches the request is applied.
        # You cannot configure two or more routeRules with the same priority.
        # Priority for each rule must be set to a number from 0 to 2147483647
        # inclusive.
        # Priority numbers can have gaps, which enable you to add or remove rules
        # in the future without affecting the rest of the rules. For example, 1, 2,
        # 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which you
        # could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future
        # without any impact on existing rules.
        # Corresponds to the JSON property `priority`
        # @return [Fixnum]
        attr_accessor :priority
      
        # In response to a matching matchRule, the load balancer
        # performs advanced routing actions, such as URL rewrites and header
        # transformations, before forwarding the request to the selected backend.
        # Only one of urlRedirect, service orrouteAction.weightedBackendService can be
        # set.
        # URL maps for classic Application Load Balancers only support
        # the urlRewrite action within a route rule'srouteAction.
        # Corresponds to the JSON property `routeAction`
        # @return [Google::Apis::ComputeV1::HttpRouteAction]
        attr_accessor :route_action
      
        # The full or partial URL of the backend service resource to which traffic
        # is directed if this rule is matched. If routeAction is
        # also specified, advanced routing actions, such as URL rewrites,
        # take effect before sending the request to the backend.
        # Only one of urlRedirect, service orrouteAction.weightedBackendService can be
        # set.
        # Corresponds to the JSON property `service`
        # @return [String]
        attr_accessor :service
      
        # Specifies settings for an HTTP redirect.
        # Corresponds to the JSON property `urlRedirect`
        # @return [Google::Apis::ComputeV1::HttpRedirectAction]
        attr_accessor :url_redirect
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @custom_error_response_policy = args[:custom_error_response_policy] if args.key?(:custom_error_response_policy)
          @description = args[:description] if args.key?(:description)
          @header_action = args[:header_action] if args.key?(:header_action)
          @match_rules = args[:match_rules] if args.key?(:match_rules)
          @priority = args[:priority] if args.key?(:priority)
          @route_action = args[:route_action] if args.key?(:route_action)
          @service = args[:service] if args.key?(:service)
          @url_redirect = args[:url_redirect] if args.key?(:url_redirect)
        end
      end
      
      # HttpRouteRuleMatch specifies a set of criteria for matching
      # requests to an HttpRouteRule. All specified criteria must
      # be satisfied for a match to occur.
      class HttpRouteRuleMatch
        include Google::Apis::Core::Hashable
      
        # For satisfying the matchRule condition, the path of the
        # request must exactly match the value specified infullPathMatch after removing
        # any query parameters and anchor
        # that may be part of the original URL.
        # fullPathMatch must be from 1 to 1024 characters.
        # Only one of prefixMatch, fullPathMatch,regexMatch or path_template_match must
        # be
        # specified.
        # Corresponds to the JSON property `fullPathMatch`
        # @return [String]
        attr_accessor :full_path_match
      
        # Specifies a list of header match criteria, all of which must match
        # corresponding headers in the request.
        # Corresponds to the JSON property `headerMatches`
        # @return [Array<Google::Apis::ComputeV1::HttpHeaderMatch>]
        attr_accessor :header_matches
      
        # Specifies that prefixMatch and fullPathMatch
        # matches are case sensitive.
        # The default value is false.
        # ignoreCase must not be used with regexMatch.
        # Not supported when the URL map is bound to a target gRPC proxy.
        # Corresponds to the JSON property `ignoreCase`
        # @return [Boolean]
        attr_accessor :ignore_case
        alias_method :ignore_case?, :ignore_case
      
        # Opaque filter criteria used by the load balancer to restrict routing
        # configuration to a limited set of xDS
        # compliant clients. In their xDS requests to the load balancer, xDS clients
        # present node
        # metadata. When there is a match, the relevant routing configuration
        # is made available to those proxies.
        # For each metadataFilter in this list, if itsfilterMatchCriteria is set to
        # MATCH_ANY, at least one of thefilterLabels must match the corresponding label
        # provided in
        # the metadata. If its filterMatchCriteria is set to
        # MATCH_ALL, then all of its filterLabels must match with
        # corresponding labels provided in the metadata. If multiple
        # metadata filters are specified, all of them need to be
        # satisfied in order to be considered a match.
        # metadataFilters specified here is applied after those
        # specified in ForwardingRule that refers to theUrlMap this HttpRouteRuleMatch
        # belongs to.
        # metadataFilters only applies to load balancers that haveloadBalancingScheme
        # set toINTERNAL_SELF_MANAGED.
        # Not supported when the URL map is bound to a target gRPC proxy that
        # has validateForProxyless field set to true.
        # Corresponds to the JSON property `metadataFilters`
        # @return [Array<Google::Apis::ComputeV1::MetadataFilter>]
        attr_accessor :metadata_filters
      
        # If specified, this field defines a path template pattern that must match
        # the :path header after the query string is removed.
        # A path template pattern can include variables and wildcards.
        # Variables are enclosed in curly braces, for example`variable_name`. Wildcards
        # include * that
        # matches a single path segment, and ** that matches zero or
        # more path segments. The pattern must follow these rules:
        # 
        # - The value must be between 1 and 1024 characters.
        # - The pattern must start with a leading slash ("/").
        # - No more than 5 operators (variables or wildcards) may appear in
        # the pattern.
        # Precisely one ofprefixMatch, fullPathMatch,regexMatch, or pathTemplateMatch
        # must be
        # set.
        # Corresponds to the JSON property `pathTemplateMatch`
        # @return [String]
        attr_accessor :path_template_match
      
        # For satisfying the matchRule condition, the request's
        # path must begin with the specified prefixMatch.prefixMatch must begin with a /.
        # The value must be from 1 to 1024 characters.
        # The * character inside a prefix match is
        # treated as a literal character, not as a wildcard.
        # Only one of prefixMatch, fullPathMatch,regexMatch or path_template_match can
        # be
        # used within a matchRule.
        # Corresponds to the JSON property `prefixMatch`
        # @return [String]
        attr_accessor :prefix_match
      
        # Specifies a list of query parameter match criteria, all of which must
        # match corresponding query parameters in the request.
        # Not supported when the URL map is bound to a target gRPC proxy.
        # Corresponds to the JSON property `queryParameterMatches`
        # @return [Array<Google::Apis::ComputeV1::HttpQueryParameterMatch>]
        attr_accessor :query_parameter_matches
      
        # For satisfying the matchRule condition, the path of the
        # request must satisfy the regular expression specified inregexMatch after
        # removing any query parameters and anchor
        # supplied with the original URL. For
        # more information about regular expression syntax, see Syntax.
        # Only one of prefixMatch, fullPathMatch,regexMatch or path_template_match must
        # be
        # specified.
        # Regular expressions can only be used when the loadBalancingScheme is
        # set to INTERNAL_SELF_MANAGED, EXTERNAL_MANAGED
        # (regional scope) or INTERNAL_MANAGED.
        # Corresponds to the JSON property `regexMatch`
        # @return [String]
        attr_accessor :regex_match
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @full_path_match = args[:full_path_match] if args.key?(:full_path_match)
          @header_matches = args[:header_matches] if args.key?(:header_matches)
          @ignore_case = args[:ignore_case] if args.key?(:ignore_case)
          @metadata_filters = args[:metadata_filters] if args.key?(:metadata_filters)
          @path_template_match = args[:path_template_match] if args.key?(:path_template_match)
          @prefix_match = args[:prefix_match] if args.key?(:prefix_match)
          @query_parameter_matches = args[:query_parameter_matches] if args.key?(:query_parameter_matches)
          @regex_match = args[:regex_match] if args.key?(:regex_match)
        end
      end
      
      # Represents a legacy HTTPS Health Check resource.
      # Legacy HTTPS health checks have been deprecated. If you are using a target
      # pool-based network load balancer, you must use a legacy HTTP (not HTTPS)
      # health check. For all other load balancers, including backend service-based
      # network load balancers, and for managed instance group auto-healing, you must
      # use modern (non-legacy) health checks.
      # For more information, seeHealth checks
      # overview.
      class HttpsHealthCheck
        include Google::Apis::Core::Hashable
      
        # How often (in seconds) to send a health check. The default value is 5
        # seconds.
        # Corresponds to the JSON property `checkIntervalSec`
        # @return [Fixnum]
        attr_accessor :check_interval_sec
      
        # [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # A so-far unhealthy instance will be marked healthy after this
        # many consecutive successes. The default value is 2.
        # Corresponds to the JSON property `healthyThreshold`
        # @return [Fixnum]
        attr_accessor :healthy_threshold
      
        # The value of the host header in the HTTPS health check request. If left
        # empty (default value), the public IP on behalf of which this health check
        # is performed will be used.
        # Corresponds to the JSON property `host`
        # @return [String]
        attr_accessor :host
      
        # [Output Only] The unique identifier for the resource. This identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. Type of the resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource. Provided by the client when the resource is created.
        # The name must be 1-63 characters long, and comply withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must
        # be a dash, lowercase letter, or digit, except the last character, which
        # cannot be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The TCP port number for the HTTPS health check request. The default value
        # is 443.
        # Corresponds to the JSON property `port`
        # @return [Fixnum]
        attr_accessor :port
      
        # The request path of the HTTPS health check request. The default value is
        # "/". Must comply withRFC3986.
        # Corresponds to the JSON property `requestPath`
        # @return [String]
        attr_accessor :request_path
      
        # [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # How long (in seconds) to wait before claiming failure. The default value is
        # 5 seconds. It is invalid for timeoutSec to have a greater value than
        # checkIntervalSec.
        # Corresponds to the JSON property `timeoutSec`
        # @return [Fixnum]
        attr_accessor :timeout_sec
      
        # A so-far healthy instance will be marked unhealthy after this
        # many consecutive failures. The default value is 2.
        # Corresponds to the JSON property `unhealthyThreshold`
        # @return [Fixnum]
        attr_accessor :unhealthy_threshold
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @check_interval_sec = args[:check_interval_sec] if args.key?(:check_interval_sec)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @healthy_threshold = args[:healthy_threshold] if args.key?(:healthy_threshold)
          @host = args[:host] if args.key?(:host)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @port = args[:port] if args.key?(:port)
          @request_path = args[:request_path] if args.key?(:request_path)
          @self_link = args[:self_link] if args.key?(:self_link)
          @timeout_sec = args[:timeout_sec] if args.key?(:timeout_sec)
          @unhealthy_threshold = args[:unhealthy_threshold] if args.key?(:unhealthy_threshold)
        end
      end
      
      # Contains a list of HttpsHealthCheck resources.
      class HttpsHealthCheckList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of HttpsHealthCheck resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::HttpsHealthCheck>]
        attr_accessor :items
      
        # Output only. Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::HttpsHealthCheckList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::HttpsHealthCheckList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represents an Image resource.
      # You can use images to create boot disks for your VM instances.
      # For more information, read Images.
      class Image
        include Google::Apis::Core::Hashable
      
        # The architecture of the image. Valid values are
        # ARM64 or X86_64.
        # Corresponds to the JSON property `architecture`
        # @return [String]
        attr_accessor :architecture
      
        # Size of the image tar.gz archive stored in Google Cloud
        # Storage (in bytes).
        # Corresponds to the JSON property `archiveSizeBytes`
        # @return [Fixnum]
        attr_accessor :archive_size_bytes
      
        # Output only. [Output Only] Creation timestamp inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # Deprecation status for a public resource.
        # Corresponds to the JSON property `deprecated`
        # @return [Google::Apis::ComputeV1::DeprecationStatus]
        attr_accessor :deprecated
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Size of the image when restored onto a persistent disk (in GB).
        # Corresponds to the JSON property `diskSizeGb`
        # @return [Fixnum]
        attr_accessor :disk_size_gb
      
        # Output only. Whether this image is created from a confidential compute mode
        # disk.
        # [Output Only]: This field is not set by user, but from source disk.
        # Corresponds to the JSON property `enableConfidentialCompute`
        # @return [Boolean]
        attr_accessor :enable_confidential_compute
        alias_method :enable_confidential_compute?, :enable_confidential_compute
      
        # The name of the image family to which this image belongs. The image
        # family name can be from a publicly managed image family provided by
        # Compute Engine, or from a custom image family you create. For example,centos-
        # stream-9 is a publicly available image family.
        # For more information, see Image
        # family best practices.
        # When creating disks, you can specify an image family instead of a specific
        # image name. The image family always returns its latest image that is not
        # deprecated. The name of the image family must comply with RFC1035.
        # Corresponds to the JSON property `family`
        # @return [String]
        attr_accessor :family
      
        # A list of features to enable on the guest operating system. Applicable
        # only for bootable images. To see a list of available options, see
        # theguestOSfeatures[].type parameter.
        # Corresponds to the JSON property `guestOsFeatures`
        # @return [Array<Google::Apis::ComputeV1::GuestOsFeature>]
        attr_accessor :guest_os_features
      
        # Output only. [Output Only] The unique identifier for the resource. This
        # identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Encrypts the image using acustomer-supplied
        # encryption key.
        # After you encrypt an image with a customer-supplied key, you must provide
        # the same key if you use the image later (e.g. to create a disk from
        # the image).
        # Customer-supplied encryption keys do not protect access to metadata
        # of the disk.
        # If you do not provide an encryption key when creating the image, then the
        # disk will be encrypted using an automatically generated key and you do not
        # need to provide a key to use the image later.
        # Corresponds to the JSON property `imageEncryptionKey`
        # @return [Google::Apis::ComputeV1::CustomerEncryptionKey]
        attr_accessor :image_encryption_key
      
        # Output only. [Output Only] Type of the resource. Always compute#image for
        # images.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # A fingerprint for the labels being applied to this image, which is
        # essentially a hash of the labels used for optimistic locking. The
        # fingerprint is initially generated by Compute Engine and changes after
        # every request to modify or update labels. You must always provide an
        # up-to-date fingerprint hash in order to update or change labels,
        # otherwise the request will fail with error412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to
        # retrieve an image.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # Labels to apply to this image. These can be later modified by
        # the setLabels method.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # Integer license codes indicating which licenses are attached to this image.
        # Corresponds to the JSON property `licenseCodes`
        # @return [Array<Fixnum>]
        attr_accessor :license_codes
      
        # Any applicable license URI.
        # Corresponds to the JSON property `licenses`
        # @return [Array<String>]
        attr_accessor :licenses
      
        # Name of the resource; provided by the client when the resource is created.
        # The name must be 1-63 characters long, and comply withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must be
        # a dash, lowercase letter, or digit, except the last character, which cannot
        # be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Additional image params.
        # Corresponds to the JSON property `params`
        # @return [Google::Apis::ComputeV1::ImageParams]
        attr_accessor :params
      
        # The parameters of the raw disk image.
        # Corresponds to the JSON property `rawDisk`
        # @return [Google::Apis::ComputeV1::Image::RawDisk]
        attr_accessor :raw_disk
      
        # Output only. Reserved for future use.
        # Corresponds to the JSON property `satisfiesPzi`
        # @return [Boolean]
        attr_accessor :satisfies_pzi
        alias_method :satisfies_pzi?, :satisfies_pzi
      
        # Output only. [Output Only] Reserved for future use.
        # Corresponds to the JSON property `satisfiesPzs`
        # @return [Boolean]
        attr_accessor :satisfies_pzs
        alias_method :satisfies_pzs?, :satisfies_pzs
      
        # Output only. [Output Only] Server-defined URL for the resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Initial State for shielded instance,
        # these are public keys which are safe to store in public
        # Corresponds to the JSON property `shieldedInstanceInitialState`
        # @return [Google::Apis::ComputeV1::InitialStateConfig]
        attr_accessor :shielded_instance_initial_state
      
        # URL of the source disk used to create this image.
        # For example, the following are valid values:
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/
        # disk
        # - projects/project/zones/zone/disks/disk
        # - zones/zone/disks/disk
        # In order to create an image, you must provide the full or partial URL of
        # one of the following:
        # 
        # - The rawDisk.source URL
        # - The sourceDisk URL
        # - The sourceImage URL
        # - The sourceSnapshot URL
        # Corresponds to the JSON property `sourceDisk`
        # @return [String]
        attr_accessor :source_disk
      
        # Thecustomer-supplied
        # encryption key of the source disk. Required if the source disk is
        # protected by a customer-supplied encryption key.
        # Corresponds to the JSON property `sourceDiskEncryptionKey`
        # @return [Google::Apis::ComputeV1::CustomerEncryptionKey]
        attr_accessor :source_disk_encryption_key
      
        # Output only. [Output Only]
        # The ID value of the disk used to create this image. This value may be used
        # to determine whether the image was taken from the current or a previous
        # instance of a given disk name.
        # Corresponds to the JSON property `sourceDiskId`
        # @return [String]
        attr_accessor :source_disk_id
      
        # URL of the source image used to create this image.
        # The following are valid formats for the URL:
        # 
        # - https://www.googleapis.com/compute/v1/projects/project_id/global/
        # images/image_name
        # - projects/project_id/global/images/image_name
        # In order to create an image, you must provide the full or partial URL of
        # one of the following:
        # 
        # - The rawDisk.source URL
        # - The sourceDisk URL
        # - The sourceImage URL
        # - The sourceSnapshot URL
        # Corresponds to the JSON property `sourceImage`
        # @return [String]
        attr_accessor :source_image
      
        # The customer-supplied encryption key of the source image. Required if the
        # source image is protected by a customer-supplied encryption key.
        # Corresponds to the JSON property `sourceImageEncryptionKey`
        # @return [Google::Apis::ComputeV1::CustomerEncryptionKey]
        attr_accessor :source_image_encryption_key
      
        # Output only. [Output Only]
        # The ID value of the image used to create this image. This value may be used
        # to determine whether the image was taken from the current or a previous
        # instance of a given image name.
        # Corresponds to the JSON property `sourceImageId`
        # @return [String]
        attr_accessor :source_image_id
      
        # URL of the source snapshot used to create this image.
        # The following are valid formats for the URL:
        # 
        # - https://www.googleapis.com/compute/v1/projects/project_id/global/
        # snapshots/snapshot_name
        # - projects/project_id/global/snapshots/snapshot_name
        # In order to create an image, you must provide the full or partial URL of
        # one of the following:
        # 
        # - The rawDisk.source URL
        # - The sourceDisk URL
        # - The sourceImage URL
        # - The sourceSnapshot URL
        # Corresponds to the JSON property `sourceSnapshot`
        # @return [String]
        attr_accessor :source_snapshot
      
        # The customer-supplied encryption key of the source snapshot. Required if
        # the source snapshot is protected by a customer-supplied encryption key.
        # Corresponds to the JSON property `sourceSnapshotEncryptionKey`
        # @return [Google::Apis::ComputeV1::CustomerEncryptionKey]
        attr_accessor :source_snapshot_encryption_key
      
        # Output only. [Output Only]
        # The ID value of the snapshot used to create this image. This value may be
        # used to determine whether the snapshot was taken from the current or a
        # previous instance of a given snapshot name.
        # Corresponds to the JSON property `sourceSnapshotId`
        # @return [String]
        attr_accessor :source_snapshot_id
      
        # The type of the image used to create this disk. The
        # default and only valid value is RAW.
        # Corresponds to the JSON property `sourceType`
        # @return [String]
        attr_accessor :source_type
      
        # Output only. [Output Only] The status of the image. An image can be used to
        # create other
        # resources, such as instances, only after the image has been successfully
        # created and the status is set to READY. Possible
        # values are FAILED, PENDING, orREADY.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # Cloud Storage bucket storage location of the image (regional or
        # multi-regional).
        # Corresponds to the JSON property `storageLocations`
        # @return [Array<String>]
        attr_accessor :storage_locations
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @architecture = args[:architecture] if args.key?(:architecture)
          @archive_size_bytes = args[:archive_size_bytes] if args.key?(:archive_size_bytes)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @deprecated = args[:deprecated] if args.key?(:deprecated)
          @description = args[:description] if args.key?(:description)
          @disk_size_gb = args[:disk_size_gb] if args.key?(:disk_size_gb)
          @enable_confidential_compute = args[:enable_confidential_compute] if args.key?(:enable_confidential_compute)
          @family = args[:family] if args.key?(:family)
          @guest_os_features = args[:guest_os_features] if args.key?(:guest_os_features)
          @id = args[:id] if args.key?(:id)
          @image_encryption_key = args[:image_encryption_key] if args.key?(:image_encryption_key)
          @kind = args[:kind] if args.key?(:kind)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
          @license_codes = args[:license_codes] if args.key?(:license_codes)
          @licenses = args[:licenses] if args.key?(:licenses)
          @name = args[:name] if args.key?(:name)
          @params = args[:params] if args.key?(:params)
          @raw_disk = args[:raw_disk] if args.key?(:raw_disk)
          @satisfies_pzi = args[:satisfies_pzi] if args.key?(:satisfies_pzi)
          @satisfies_pzs = args[:satisfies_pzs] if args.key?(:satisfies_pzs)
          @self_link = args[:self_link] if args.key?(:self_link)
          @shielded_instance_initial_state = args[:shielded_instance_initial_state] if args.key?(:shielded_instance_initial_state)
          @source_disk = args[:source_disk] if args.key?(:source_disk)
          @source_disk_encryption_key = args[:source_disk_encryption_key] if args.key?(:source_disk_encryption_key)
          @source_disk_id = args[:source_disk_id] if args.key?(:source_disk_id)
          @source_image = args[:source_image] if args.key?(:source_image)
          @source_image_encryption_key = args[:source_image_encryption_key] if args.key?(:source_image_encryption_key)
          @source_image_id = args[:source_image_id] if args.key?(:source_image_id)
          @source_snapshot = args[:source_snapshot] if args.key?(:source_snapshot)
          @source_snapshot_encryption_key = args[:source_snapshot_encryption_key] if args.key?(:source_snapshot_encryption_key)
          @source_snapshot_id = args[:source_snapshot_id] if args.key?(:source_snapshot_id)
          @source_type = args[:source_type] if args.key?(:source_type)
          @status = args[:status] if args.key?(:status)
          @storage_locations = args[:storage_locations] if args.key?(:storage_locations)
        end
        
        # The parameters of the raw disk image.
        class RawDisk
          include Google::Apis::Core::Hashable
        
          # The format used to encode and transmit the block device, which should beTAR.
          # This is just a container and transmission format and not
          # a runtime format. Provided by the client when the disk image is created.
          # Corresponds to the JSON property `containerType`
          # @return [String]
          attr_accessor :container_type
        
          # [Deprecated] This field is deprecated.
          # An optional SHA1 checksum of the disk image before unpackaging provided
          # by the client when the disk image is created.
          # Corresponds to the JSON property `sha1Checksum`
          # @return [String]
          attr_accessor :sha1_checksum
        
          # The full Google Cloud Storage URL where the raw disk image archive is
          # stored.
          # The following are valid formats for the URL:
          # 
          # - https://storage.googleapis.com/bucket_name/image_archive_name
          # - https://storage.googleapis.com/bucket_name/folder_name/image_archive_name
          # In order to create an image, you must provide the full or partial URL of
          # one of the following:
          # 
          # - The rawDisk.source URL
          # - The sourceDisk URL
          # - The sourceImage URL
          # - The sourceSnapshot URL
          # Corresponds to the JSON property `source`
          # @return [String]
          attr_accessor :source
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @container_type = args[:container_type] if args.key?(:container_type)
            @sha1_checksum = args[:sha1_checksum] if args.key?(:sha1_checksum)
            @source = args[:source] if args.key?(:source)
          end
        end
      end
      
      # 
      class ImageFamilyView
        include Google::Apis::Core::Hashable
      
        # Represents an Image resource.
        # You can use images to create boot disks for your VM instances.
        # For more information, read Images.
        # Corresponds to the JSON property `image`
        # @return [Google::Apis::ComputeV1::Image]
        attr_accessor :image
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @image = args[:image] if args.key?(:image)
        end
      end
      
      # Contains a list of images.
      class ImageList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Image resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::Image>]
        attr_accessor :items
      
        # Output only. Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::ImageList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::ImageList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Additional image params.
      class ImageParams
        include Google::Apis::Core::Hashable
      
        # Resource manager tags to be bound to the image. Tag keys and values have
        # the same definition as resource
        # manager tags. Keys and values can be either in numeric format,
        # such as `tagKeys/`tag_key_id`` and `tagValues/456` or in namespaced
        # format such as ``org_id|project_id`/`tag_key_short_name`` and
        # ``tag_value_short_name``. The field is ignored (both PUT &
        # PATCH) when empty.
        # Corresponds to the JSON property `resourceManagerTags`
        # @return [Hash<String,String>]
        attr_accessor :resource_manager_tags
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @resource_manager_tags = args[:resource_manager_tags] if args.key?(:resource_manager_tags)
        end
      end
      
      # Initial State for shielded instance,
      # these are public keys which are safe to store in public
      class InitialStateConfig
        include Google::Apis::Core::Hashable
      
        # The Key Database (db).
        # Corresponds to the JSON property `dbs`
        # @return [Array<Google::Apis::ComputeV1::FileContentBuffer>]
        attr_accessor :dbs
      
        # The forbidden key database (dbx).
        # Corresponds to the JSON property `dbxs`
        # @return [Array<Google::Apis::ComputeV1::FileContentBuffer>]
        attr_accessor :dbxs
      
        # The Key Exchange Key (KEK).
        # Corresponds to the JSON property `keks`
        # @return [Array<Google::Apis::ComputeV1::FileContentBuffer>]
        attr_accessor :keks
      
        # The Platform Key (PK).
        # Corresponds to the JSON property `pk`
        # @return [Google::Apis::ComputeV1::FileContentBuffer]
        attr_accessor :pk
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @dbs = args[:dbs] if args.key?(:dbs)
          @dbxs = args[:dbxs] if args.key?(:dbxs)
          @keks = args[:keks] if args.key?(:keks)
          @pk = args[:pk] if args.key?(:pk)
        end
      end
      
      # Represents an Instance resource.
      # An instance is a virtual machine that is hosted on Google Cloud Platform.
      # For more information, readVirtual Machine Instances.
      class Instance
        include Google::Apis::Core::Hashable
      
        # Specifies options for controlling advanced machine features.
        # Options that would traditionally be configured in a BIOS belong
        # here. Features that require operating system support may have
        # corresponding entries in the GuestOsFeatures of anImage (e.g., whether or not
        # the OS in theImage supports nested virtualization being enabled or
        # disabled).
        # Corresponds to the JSON property `advancedMachineFeatures`
        # @return [Google::Apis::ComputeV1::AdvancedMachineFeatures]
        attr_accessor :advanced_machine_features
      
        # Allows this instance to send and receive packets with non-matching
        # destination or source IPs. This is required if you plan to use this
        # instance to forward routes. For more information, seeEnabling IP Forwarding.
        # Corresponds to the JSON property `canIpForward`
        # @return [Boolean]
        attr_accessor :can_ip_forward
        alias_method :can_ip_forward?, :can_ip_forward
      
        # A set of Confidential Instance options.
        # Corresponds to the JSON property `confidentialInstanceConfig`
        # @return [Google::Apis::ComputeV1::ConfidentialInstanceConfig]
        attr_accessor :confidential_instance_config
      
        # Output only. [Output Only] The CPU platform used by this instance.
        # Corresponds to the JSON property `cpuPlatform`
        # @return [String]
        attr_accessor :cpu_platform
      
        # Output only. [Output Only] Creation timestamp inRFC3339 text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # Whether the resource should be protected against deletion.
        # Corresponds to the JSON property `deletionProtection`
        # @return [Boolean]
        attr_accessor :deletion_protection
        alias_method :deletion_protection?, :deletion_protection
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Array of disks associated with this instance. Persistent disks must be
        # created before you can assign them.
        # Corresponds to the JSON property `disks`
        # @return [Array<Google::Apis::ComputeV1::AttachedDisk>]
        attr_accessor :disks
      
        # A set of Display Device options
        # Corresponds to the JSON property `displayDevice`
        # @return [Google::Apis::ComputeV1::DisplayDevice]
        attr_accessor :display_device
      
        # Specifies a fingerprint for this resource, which is essentially a hash of
        # the instance's contents and used for optimistic locking. The
        # fingerprint is initially generated by Compute Engine and changes after
        # every request to modify or update the instance. You must always provide an
        # up-to-date fingerprint hash in order to update the instance.
        # To see the latest fingerprint, make get() request to the
        # instance.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # A list of the type and count of accelerator cards attached to the instance.
        # Corresponds to the JSON property `guestAccelerators`
        # @return [Array<Google::Apis::ComputeV1::AcceleratorConfig>]
        attr_accessor :guest_accelerators
      
        # Specifies the hostname of the instance. The specified hostname must be
        # RFC1035 compliant. If hostname is not specified, the default hostname is
        # [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and
        # [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
        # Corresponds to the JSON property `hostname`
        # @return [String]
        attr_accessor :hostname
      
        # Output only. [Output Only] The unique identifier for the resource. This
        # identifier is
        # defined by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Encrypts suspended data for an instance with acustomer-managed
        # encryption key.
        # If you are creating a new instance, this field will encrypt the local SSD
        # and in-memory contents of the instance during the suspend operation.
        # If you do not provide an encryption key when creating the instance, then
        # the local SSD and in-memory contents will be encrypted using
        # an automatically generated key during the suspend operation.
        # Corresponds to the JSON property `instanceEncryptionKey`
        # @return [Google::Apis::ComputeV1::CustomerEncryptionKey]
        attr_accessor :instance_encryption_key
      
        # KeyRevocationActionType of the instance. Supported options are "STOP" and
        # "NONE". The default value is "NONE" if it is not specified.
        # Corresponds to the JSON property `keyRevocationActionType`
        # @return [String]
        attr_accessor :key_revocation_action_type
      
        # Output only. [Output Only] Type of the resource. Always compute#instance
        # for instances.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # A fingerprint for this request, which is essentially a hash of
        # the label's contents and used for optimistic locking. The
        # fingerprint is initially generated by Compute Engine and changes after
        # every request to modify or update labels. You must always provide an
        # up-to-date fingerprint hash in order to update or change labels.
        # To see the latest fingerprint, make get() request to the
        # instance.
        # Corresponds to the JSON property `labelFingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :label_fingerprint
      
        # Labels to apply to this instance. These can be later modified by
        # the setLabels method.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # Output only. [Output Only] Last start timestamp inRFC3339 text format.
        # Corresponds to the JSON property `lastStartTimestamp`
        # @return [String]
        attr_accessor :last_start_timestamp
      
        # Output only. [Output Only] Last stop timestamp inRFC3339 text format.
        # Corresponds to the JSON property `lastStopTimestamp`
        # @return [String]
        attr_accessor :last_stop_timestamp
      
        # Output only. [Output Only] Last suspended timestamp inRFC3339 text format.
        # Corresponds to the JSON property `lastSuspendedTimestamp`
        # @return [String]
        attr_accessor :last_suspended_timestamp
      
        # Full or partial URL of the machine type resource to use for this instance,
        # in the format:zones/zone/machineTypes/machine-type. This is provided by the
        # client
        # when the instance is created. For example, the following is a valid partial
        # url to a predefined
        # machine type:
        # zones/us-central1-f/machineTypes/n1-standard-1
        # To create acustom
        # machine type, provide a URL to a machine type in the following format,
        # where CPUS is 1 or an even number up to 32 (2,
        # 4, 6, ... 24, etc), and MEMORY is the total
        # memory for this instance. Memory must be a multiple of 256 MB and must
        # be supplied in MB (e.g. 5 GB of memory is 5120 MB):
        # zones/zone/machineTypes/custom-CPUS-MEMORY
        # For example: zones/us-central1-f/machineTypes/custom-4-5120
        # For a full list of restrictions, read theSpecifications
        # for custom machine types.
        # Corresponds to the JSON property `machineType`
        # @return [String]
        attr_accessor :machine_type
      
        # A metadata key/value entry.
        # Corresponds to the JSON property `metadata`
        # @return [Google::Apis::ComputeV1::Metadata]
        attr_accessor :metadata
      
        # Specifies aminimum CPU
        # platform for the VM instance. Applicable values are the friendly names
        # of CPU platforms, such as minCpuPlatform: "Intel
        # Haswell" or minCpuPlatform: "Intel Sandy
        # Bridge".
        # Corresponds to the JSON property `minCpuPlatform`
        # @return [String]
        attr_accessor :min_cpu_platform
      
        # The name of the resource, provided by the client when initially creating
        # the resource. The resource name must be 1-63 characters long, and comply
        # withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must be
        # a dash, lowercase letter, or digit, except the last character, which cannot
        # be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # An array of network configurations for this instance. These specify how
        # interfaces are configured to interact with other network services, such as
        # connecting to the internet. Multiple interfaces are supported
        # per instance.
        # Corresponds to the JSON property `networkInterfaces`
        # @return [Array<Google::Apis::ComputeV1::NetworkInterface>]
        attr_accessor :network_interfaces
      
        # 
        # Corresponds to the JSON property `networkPerformanceConfig`
        # @return [Google::Apis::ComputeV1::NetworkPerformanceConfig]
        attr_accessor :network_performance_config
      
        # Additional instance params.
        # Corresponds to the JSON property `params`
        # @return [Google::Apis::ComputeV1::InstanceParams]
        attr_accessor :params
      
        # The private IPv6 google access type for the VM.
        # If not specified, use  INHERIT_FROM_SUBNETWORK as default.
        # Corresponds to the JSON property `privateIpv6GoogleAccess`
        # @return [String]
        attr_accessor :private_ipv6_google_access
      
        # Specifies the reservations that this instance can consume from.
        # Corresponds to the JSON property `reservationAffinity`
        # @return [Google::Apis::ComputeV1::ReservationAffinity]
        attr_accessor :reservation_affinity
      
        # Resource policies applied to this instance.
        # Corresponds to the JSON property `resourcePolicies`
        # @return [Array<String>]
        attr_accessor :resource_policies
      
        # Contains output only fields.
        # Use this sub-message for actual values set on Instance attributes as compared
        # to the value requested by the user (intent) in their instance CRUD calls.
        # Corresponds to the JSON property `resourceStatus`
        # @return [Google::Apis::ComputeV1::ResourceStatus]
        attr_accessor :resource_status
      
        # Output only. [Output Only] Reserved for future use.
        # Corresponds to the JSON property `satisfiesPzi`
        # @return [Boolean]
        attr_accessor :satisfies_pzi
        alias_method :satisfies_pzi?, :satisfies_pzi
      
        # Output only. [Output Only] Reserved for future use.
        # Corresponds to the JSON property `satisfiesPzs`
        # @return [Boolean]
        attr_accessor :satisfies_pzs
        alias_method :satisfies_pzs?, :satisfies_pzs
      
        # Sets the scheduling options for an Instance.
        # Corresponds to the JSON property `scheduling`
        # @return [Google::Apis::ComputeV1::Scheduling]
        attr_accessor :scheduling
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # A list of service accounts, with their specified scopes, authorized for
        # this instance. Only one service account per VM instance is supported.
        # Service accounts generate access tokens that can be accessed
        # through the metadata server and used to authenticate applications on the
        # instance. SeeService Accounts
        # for more information.
        # Corresponds to the JSON property `serviceAccounts`
        # @return [Array<Google::Apis::ComputeV1::ServiceAccount>]
        attr_accessor :service_accounts
      
        # A set of Shielded Instance options.
        # Corresponds to the JSON property `shieldedInstanceConfig`
        # @return [Google::Apis::ComputeV1::ShieldedInstanceConfig]
        attr_accessor :shielded_instance_config
      
        # The policy describes the baseline against which
        # Instance boot integrity is measured.
        # Corresponds to the JSON property `shieldedInstanceIntegrityPolicy`
        # @return [Google::Apis::ComputeV1::ShieldedInstanceIntegrityPolicy]
        attr_accessor :shielded_instance_integrity_policy
      
        # Source machine image
        # Corresponds to the JSON property `sourceMachineImage`
        # @return [String]
        attr_accessor :source_machine_image
      
        # Source machine image encryption key when creating an instance from a
        # machine image.
        # Corresponds to the JSON property `sourceMachineImageEncryptionKey`
        # @return [Google::Apis::ComputeV1::CustomerEncryptionKey]
        attr_accessor :source_machine_image_encryption_key
      
        # Output only. [Output Only] Whether a VM has been restricted for start because
        # Compute
        # Engine has detected suspicious activity.
        # Corresponds to the JSON property `startRestricted`
        # @return [Boolean]
        attr_accessor :start_restricted
        alias_method :start_restricted?, :start_restricted
      
        # Output only. [Output Only] The status of the instance. One of the
        # following values: PROVISIONING, STAGING,RUNNING, STOPPING, SUSPENDING,
        # SUSPENDED, REPAIRING, andTERMINATED. For more information about the status of
        # the
        # instance, see
        # Instance life cycle.
        # Corresponds to the JSON property `status`
        # @return [String]
        attr_accessor :status
      
        # Output only. [Output Only] An optional, human-readable explanation of the
        # status.
        # Corresponds to the JSON property `statusMessage`
        # @return [String]
        attr_accessor :status_message
      
        # A set of instance tags.
        # Corresponds to the JSON property `tags`
        # @return [Google::Apis::ComputeV1::Tags]
        attr_accessor :tags
      
        # Output only. [Output Only] URL of the zone where the instance resides.
        # You must specify this field as part of the HTTP request URL. It is
        # not settable as a field in the request body.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @advanced_machine_features = args[:advanced_machine_features] if args.key?(:advanced_machine_features)
          @can_ip_forward = args[:can_ip_forward] if args.key?(:can_ip_forward)
          @confidential_instance_config = args[:confidential_instance_config] if args.key?(:confidential_instance_config)
          @cpu_platform = args[:cpu_platform] if args.key?(:cpu_platform)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @deletion_protection = args[:deletion_protection] if args.key?(:deletion_protection)
          @description = args[:description] if args.key?(:description)
          @disks = args[:disks] if args.key?(:disks)
          @display_device = args[:display_device] if args.key?(:display_device)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @guest_accelerators = args[:guest_accelerators] if args.key?(:guest_accelerators)
          @hostname = args[:hostname] if args.key?(:hostname)
          @id = args[:id] if args.key?(:id)
          @instance_encryption_key = args[:instance_encryption_key] if args.key?(:instance_encryption_key)
          @key_revocation_action_type = args[:key_revocation_action_type] if args.key?(:key_revocation_action_type)
          @kind = args[:kind] if args.key?(:kind)
          @label_fingerprint = args[:label_fingerprint] if args.key?(:label_fingerprint)
          @labels = args[:labels] if args.key?(:labels)
          @last_start_timestamp = args[:last_start_timestamp] if args.key?(:last_start_timestamp)
          @last_stop_timestamp = args[:last_stop_timestamp] if args.key?(:last_stop_timestamp)
          @last_suspended_timestamp = args[:last_suspended_timestamp] if args.key?(:last_suspended_timestamp)
          @machine_type = args[:machine_type] if args.key?(:machine_type)
          @metadata = args[:metadata] if args.key?(:metadata)
          @min_cpu_platform = args[:min_cpu_platform] if args.key?(:min_cpu_platform)
          @name = args[:name] if args.key?(:name)
          @network_interfaces = args[:network_interfaces] if args.key?(:network_interfaces)
          @network_performance_config = args[:network_performance_config] if args.key?(:network_performance_config)
          @params = args[:params] if args.key?(:params)
          @private_ipv6_google_access = args[:private_ipv6_google_access] if args.key?(:private_ipv6_google_access)
          @reservation_affinity = args[:reservation_affinity] if args.key?(:reservation_affinity)
          @resource_policies = args[:resource_policies] if args.key?(:resource_policies)
          @resource_status = args[:resource_status] if args.key?(:resource_status)
          @satisfies_pzi = args[:satisfies_pzi] if args.key?(:satisfies_pzi)
          @satisfies_pzs = args[:satisfies_pzs] if args.key?(:satisfies_pzs)
          @scheduling = args[:scheduling] if args.key?(:scheduling)
          @self_link = args[:self_link] if args.key?(:self_link)
          @service_accounts = args[:service_accounts] if args.key?(:service_accounts)
          @shielded_instance_config = args[:shielded_instance_config] if args.key?(:shielded_instance_config)
          @shielded_instance_integrity_policy = args[:shielded_instance_integrity_policy] if args.key?(:shielded_instance_integrity_policy)
          @source_machine_image = args[:source_machine_image] if args.key?(:source_machine_image)
          @source_machine_image_encryption_key = args[:source_machine_image_encryption_key] if args.key?(:source_machine_image_encryption_key)
          @start_restricted = args[:start_restricted] if args.key?(:start_restricted)
          @status = args[:status] if args.key?(:status)
          @status_message = args[:status_message] if args.key?(:status_message)
          @tags = args[:tags] if args.key?(:tags)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class InstanceAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # An object that contains a list of instances scoped by zone.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeV1::InstancesScopedList>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Alwayscompute#
        # instanceAggregatedList for aggregated lists of
        # Instance resources.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Unreachable resources.
        # Corresponds to the JSON property `unreachables`
        # @return [Array<String>]
        attr_accessor :unreachables
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::InstanceAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @unreachables = args[:unreachables] if args.key?(:unreachables)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::InstanceAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class InstanceConsumptionData
        include Google::Apis::Core::Hashable
      
        # Output only. Resources consumed by the instance.
        # Corresponds to the JSON property `consumptionInfo`
        # @return [Google::Apis::ComputeV1::InstanceConsumptionInfo]
        attr_accessor :consumption_info
      
        # Output only. Server-defined URL for the instance.
        # Corresponds to the JSON property `instance`
        # @return [String]
        attr_accessor :instance
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @consumption_info = args[:consumption_info] if args.key?(:consumption_info)
          @instance = args[:instance] if args.key?(:instance)
        end
      end
      
      # 
      class InstanceConsumptionInfo
        include Google::Apis::Core::Hashable
      
        # Output only. The number of virtual CPUs that are available to the instance.
        # Corresponds to the JSON property `guestCpus`
        # @return [Fixnum]
        attr_accessor :guest_cpus
      
        # Output only. The amount of local SSD storage available to the instance,
        # defined in GiB.
        # Corresponds to the JSON property `localSsdGb`
        # @return [Fixnum]
        attr_accessor :local_ssd_gb
      
        # Output only. The amount of physical memory available to the instance,
        # defined in MiB.
        # Corresponds to the JSON property `memoryMb`
        # @return [Fixnum]
        attr_accessor :memory_mb
      
        # Output only. The minimal guaranteed number of virtual CPUs that are reserved.
        # Corresponds to the JSON property `minNodeCpus`
        # @return [Fixnum]
        attr_accessor :min_node_cpus
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @guest_cpus = args[:guest_cpus] if args.key?(:guest_cpus)
          @local_ssd_gb = args[:local_ssd_gb] if args.key?(:local_ssd_gb)
          @memory_mb = args[:memory_mb] if args.key?(:memory_mb)
          @min_node_cpus = args[:min_node_cpus] if args.key?(:min_node_cpus)
        end
      end
      
      # A flexible specification of machine types for instances to create.
      class InstanceFlexibilityPolicy
        include Google::Apis::Core::Hashable
      
        # Specification of alternative, flexible instance subsets.
        # One of them will be selected to create the instances
        # based on various criteria, like:
        # - ranks,
        # - location policy,
        # - current capacity,
        # - available reservations (you can specify affinity in
        # InstanceProperties),
        # - SWAN/GOOSE limitations.
        # Key is an arbitrary, unique RFC1035 string that identifies the instance
        # selection.
        # Corresponds to the JSON property `instanceSelections`
        # @return [Hash<String,Google::Apis::ComputeV1::InstanceFlexibilityPolicyInstanceSelection>]
        attr_accessor :instance_selections
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_selections = args[:instance_selections] if args.key?(:instance_selections)
        end
      end
      
      # Specification of machine type to use. Every position inside this message
      # is an alternative.
      # The count specified in the shape flexibility must not exceed the number
      # of entries in per_instance_properties or the capacity of the
      # name_pattern, if used.
      class InstanceFlexibilityPolicyInstanceSelection
        include Google::Apis::Core::Hashable
      
        # Disks to be attached to the instances created from in this selection.
        # They override the disks specified in the instance properties.
        # Corresponds to the JSON property `disks`
        # @return [Array<Google::Apis::ComputeV1::AttachedDisk>]
        attr_accessor :disks
      
        # Alternative machine types to use for instances that are created from
        # these properties. This field only accepts a machine type names, for
        # example `n2-standard-4` and not URLs or partial URLs.
        # Corresponds to the JSON property `machineTypes`
        # @return [Array<String>]
        attr_accessor :machine_types
      
        # Rank when prioritizing the shape flexibilities.
        # The instance selections with rank are considered
        # first, in the ascending order of the rank.
        # If not set, defaults to 0.
        # Corresponds to the JSON property `rank`
        # @return [Fixnum]
        attr_accessor :rank
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @disks = args[:disks] if args.key?(:disks)
          @machine_types = args[:machine_types] if args.key?(:machine_types)
          @rank = args[:rank] if args.key?(:rank)
        end
      end
      
      # Represents an Instance Group resource.
      # Instance Groups can be used to configure a target forload
      # balancing.
      # Instance groups can either be managed or unmanaged.
      # To create
      # managed instance groups, use the instanceGroupManager
      # orregionInstanceGroupManager resource instead.
      # Use zonal unmanaged instance groups if you need to applyload
      # balancing to groups of heterogeneous instances or if you need to manage
      # the instances yourself. You cannot create regional unmanaged instance groups.
      # For more information, readInstance
      # groups.
      class InstanceGroup
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] The creation timestamp for this instance group
        # inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Output only. [Output Only] The fingerprint of the named ports. The system
        # uses this fingerprint to detect conflicts when multiple users change the
        # named ports concurrently.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # Output only. [Output Only] A unique identifier for this instance group,
        # generated
        # by the server.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. [Output Only] The resource type, which is alwayscompute#
        # instanceGroup for instance groups.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The name of the instance group. The name must be 1-63 characters
        # long, and comply withRFC1035.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Optional. Assigns a name to a port number. For example:`name: "http", port: 80`
        # This
        # allows the system to reference ports by the assigned name instead of a
        # port number. Named ports can also contain multiple ports. For example:[`name: "
        # app1", port: 8080`, `name:
        # "app1", port: 8081`, `name: "app2", port:
        # 8082`]
        # Named ports apply to all instances in this instance group.
        # Corresponds to the JSON property `namedPorts`
        # @return [Array<Google::Apis::ComputeV1::NamedPort>]
        attr_accessor :named_ports
      
        # [Output Only] The URL of the network to which all instances in the
        # instance group belong. If your instance has multiple network interfaces,
        # then the network and subnetwork fields only refer to the
        # network and subnet used by your primary interface (nic0).
        # Corresponds to the JSON property `network`
        # @return [String]
        attr_accessor :network
      
        # Output only. [Output Only] The URL of theregion
        # where the instance group is located (for regional resources).
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # Output only. [Output Only] The URL for this instance group. The server
        # generates
        # this URL.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] The total number of instances in the instance group.
        # Corresponds to the JSON property `size`
        # @return [Fixnum]
        attr_accessor :size
      
        # Output only. [Output Only] The URL of the subnetwork to which all instances in
        # the
        # instance group belong. If your instance has multiple network interfaces,
        # then the network and subnetwork fields only refer to the
        # network and subnet used by your primary interface (nic0).
        # Corresponds to the JSON property `subnetwork`
        # @return [String]
        attr_accessor :subnetwork
      
        # Output only. [Output Only] The URL of thezone
        # where the instance group is located (for zonal resources).
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @named_ports = args[:named_ports] if args.key?(:named_ports)
          @network = args[:network] if args.key?(:network)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @size = args[:size] if args.key?(:size)
          @subnetwork = args[:subnetwork] if args.key?(:subnetwork)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class InstanceGroupAggregatedList
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Unique identifier for the resource; defined by the
        # server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceGroupsScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeV1::InstanceGroupsScopedList>]
        attr_accessor :items
      
        # Output only. [Output Only] The resource type, which is alwayscompute#
        # instanceGroupAggregatedList for aggregated lists of
        # instance groups.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Output only. [Output Only] This token allows you to get the next page of
        # results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Unreachable resources.
        # Corresponds to the JSON property `unreachables`
        # @return [Array<String>]
        attr_accessor :unreachables
      
        # Output only. [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::InstanceGroupAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @unreachables = args[:unreachables] if args.key?(:unreachables)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Output only. [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::InstanceGroupAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # A list of InstanceGroup resources.
      class InstanceGroupList
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Unique identifier for the resource; defined by the
        # server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceGroup resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::InstanceGroup>]
        attr_accessor :items
      
        # Output only. [Output Only] The resource type, which is alwayscompute#
        # instanceGroupList for instance group lists.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Output only. [Output Only] This token allows you to get the next page of
        # results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::InstanceGroupList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Output only. [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::InstanceGroupList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Represents a Managed Instance Group resource.
      # An instance group is a collection of VM instances that you can manage as a
      # single entity. For more information, readInstance groups.
      # For zonal Managed Instance Group, use the instanceGroupManagers
      # resource.
      # For regional Managed Instance Group, use theregionInstanceGroupManagers
      # resource.
      class InstanceGroupManager
        include Google::Apis::Core::Hashable
      
        # Specifies configuration that overrides the instance template configuration
        # for the group.
        # Corresponds to the JSON property `allInstancesConfig`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerAllInstancesConfig]
        attr_accessor :all_instances_config
      
        # The autohealing policy for this managed instance group. You can specify
        # only one value.
        # Corresponds to the JSON property `autoHealingPolicies`
        # @return [Array<Google::Apis::ComputeV1::InstanceGroupManagerAutoHealingPolicy>]
        attr_accessor :auto_healing_policies
      
        # The base instance name is a prefix that you want to attach to the names of
        # all VMs in a MIG. The maximum character length is 58 and the name must
        # comply with RFC1035 format.
        # When a VM is created in the group, the MIG appends a hyphen and a random
        # four-character string to the base instance name. If you want the MIG to
        # assign sequential numbers instead of a random string, then end the base
        # instance name with a hyphen followed by one or more hash symbols. The hash
        # symbols indicate the number of digits. For example, a base instance name of
        # "vm-###" results in "vm-001" as a VM name.
        # @pattern
        # [a-z](([-a-z0-9]`0,57`)|([-a-z0-9]`0,51`-#`1,10`(\\[[0-9]`1,10`\\])?))
        # Corresponds to the JSON property `baseInstanceName`
        # @return [String]
        attr_accessor :base_instance_name
      
        # Output only. [Output Only] The creation timestamp for this managed instance
        # group inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # Output only. [Output Only] The list of instance actions and the number of
        # instances
        # in this managed instance group that are scheduled for each of those
        # actions.
        # Corresponds to the JSON property `currentActions`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerActionsSummary]
        attr_accessor :current_actions
      
        # An optional description of this resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Policy specifying the intended distribution of managed instances across
        # zones in a regional managed instance group.
        # Corresponds to the JSON property `distributionPolicy`
        # @return [Google::Apis::ComputeV1::DistributionPolicy]
        attr_accessor :distribution_policy
      
        # Fingerprint of this resource. This field may be used in optimistic locking.
        # It will be ignored when inserting an InstanceGroupManager. An up-to-date
        # fingerprint must be provided in order to update the InstanceGroupManager,
        # otherwise the request will fail with error412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to
        # retrieve an InstanceGroupManager.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # Output only. [Output Only] A unique identifier for this resource type. The
        # server
        # generates this identifier.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Instance flexibility allowing MIG to create VMs from multiple
        # types of machines.
        # Instance flexibility configuration on MIG overrides instance
        # template configuration.
        # Corresponds to the JSON property `instanceFlexibilityPolicy`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerInstanceFlexibilityPolicy]
        attr_accessor :instance_flexibility_policy
      
        # Output only. [Output Only] The URL of the Instance Group resource.
        # Corresponds to the JSON property `instanceGroup`
        # @return [String]
        attr_accessor :instance_group
      
        # The repair policy for this managed instance group.
        # Corresponds to the JSON property `instanceLifecyclePolicy`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerInstanceLifecyclePolicy]
        attr_accessor :instance_lifecycle_policy
      
        # The URL of the instance template that is specified for this managed
        # instance group. The group uses this template to create all new instances
        # in the managed instance group. The templates for existing instances in the
        # group do not change unless you run recreateInstances,
        # runapplyUpdatesToInstances, or set the group'supdatePolicy.type to PROACTIVE.
        # Corresponds to the JSON property `instanceTemplate`
        # @return [String]
        attr_accessor :instance_template
      
        # Output only. [Output Only] The resource type, which is alwayscompute#
        # instanceGroupManager for managed instance groups.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Pagination behavior of the listManagedInstances API method for
        # this managed instance group.
        # Corresponds to the JSON property `listManagedInstancesResults`
        # @return [String]
        attr_accessor :list_managed_instances_results
      
        # The name of the managed instance group. The name must be 1-63 characters
        # long, and comply withRFC1035.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # [Output Only] Named ports configured on the Instance Groups complementary
        # to this Instance Group Manager.
        # Corresponds to the JSON property `namedPorts`
        # @return [Array<Google::Apis::ComputeV1::NamedPort>]
        attr_accessor :named_ports
      
        # Output only. [Output Only] The URL of theregion
        # where the managed instance group resides (for regional resources).
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # Resource policies for this managed instance group.
        # Corresponds to the JSON property `resourcePolicies`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerResourcePolicies]
        attr_accessor :resource_policies
      
        # Output only. [Output Only] Reserved for future use.
        # Corresponds to the JSON property `satisfiesPzi`
        # @return [Boolean]
        attr_accessor :satisfies_pzi
        alias_method :satisfies_pzi?, :satisfies_pzi
      
        # Output only. [Output Only] Reserved for future use.
        # Corresponds to the JSON property `satisfiesPzs`
        # @return [Boolean]
        attr_accessor :satisfies_pzs
        alias_method :satisfies_pzs?, :satisfies_pzs
      
        # Output only. [Output Only] The URL for this managed instance group. The server
        # defines
        # this URL.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Standby policy for stopped and suspended instances.
        # Corresponds to the JSON property `standbyPolicy`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerStandbyPolicy]
        attr_accessor :standby_policy
      
        # Stateful configuration for this Instanced Group Manager
        # Corresponds to the JSON property `statefulPolicy`
        # @return [Google::Apis::ComputeV1::StatefulPolicy]
        attr_accessor :stateful_policy
      
        # Output only. [Output Only] The status of this managed instance group.
        # Corresponds to the JSON property `status`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerStatus]
        attr_accessor :status
      
        # The URLs for all TargetPool resources to which instances in theinstanceGroup
        # field are added. The target pools automatically
        # apply to all of the instances in the managed instance group.
        # Corresponds to the JSON property `targetPools`
        # @return [Array<String>]
        attr_accessor :target_pools
      
        # The target number of running instances for this managed instance group.
        # You can reduce this number by using the instanceGroupManager
        # deleteInstances or abandonInstances methods. Resizing the group also
        # changes this number.
        # Corresponds to the JSON property `targetSize`
        # @return [Fixnum]
        attr_accessor :target_size
      
        # The target number of stopped instances for this managed instance group.
        # This number changes when you:
        # 
        # - Stop instance using the stopInstances
        # method or start instances using the startInstances
        # method.
        # - Manually change the targetStoppedSize using the update
        # method.
        # Corresponds to the JSON property `targetStoppedSize`
        # @return [Fixnum]
        attr_accessor :target_stopped_size
      
        # The target number of suspended instances for this managed instance group.
        # This number changes when you:
        # 
        # - Suspend instance using the suspendInstances
        # method or resume instances using the resumeInstances
        # method.
        # - Manually change the targetSuspendedSize using the update
        # method.
        # Corresponds to the JSON property `targetSuspendedSize`
        # @return [Fixnum]
        attr_accessor :target_suspended_size
      
        # The update policy for this managed instance group.
        # Corresponds to the JSON property `updatePolicy`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerUpdatePolicy]
        attr_accessor :update_policy
      
        # Specifies the instance templates used by this managed instance group to
        # create instances.
        # Each version is defined by an instanceTemplate and aname. Every version can
        # appear at most once per instance
        # group. This field overrides the top-level instanceTemplate
        # field. Read more about therelationships
        # between these fields. Exactly one version must leave thetargetSize field unset.
        # That version will be applied to all
        # remaining instances. For more information, read aboutcanary
        # updates.
        # Corresponds to the JSON property `versions`
        # @return [Array<Google::Apis::ComputeV1::InstanceGroupManagerVersion>]
        attr_accessor :versions
      
        # Output only. [Output Only] The URL of azone
        # where the managed instance group is located (for zonal resources).
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @all_instances_config = args[:all_instances_config] if args.key?(:all_instances_config)
          @auto_healing_policies = args[:auto_healing_policies] if args.key?(:auto_healing_policies)
          @base_instance_name = args[:base_instance_name] if args.key?(:base_instance_name)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @current_actions = args[:current_actions] if args.key?(:current_actions)
          @description = args[:description] if args.key?(:description)
          @distribution_policy = args[:distribution_policy] if args.key?(:distribution_policy)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @id = args[:id] if args.key?(:id)
          @instance_flexibility_policy = args[:instance_flexibility_policy] if args.key?(:instance_flexibility_policy)
          @instance_group = args[:instance_group] if args.key?(:instance_group)
          @instance_lifecycle_policy = args[:instance_lifecycle_policy] if args.key?(:instance_lifecycle_policy)
          @instance_template = args[:instance_template] if args.key?(:instance_template)
          @kind = args[:kind] if args.key?(:kind)
          @list_managed_instances_results = args[:list_managed_instances_results] if args.key?(:list_managed_instances_results)
          @name = args[:name] if args.key?(:name)
          @named_ports = args[:named_ports] if args.key?(:named_ports)
          @region = args[:region] if args.key?(:region)
          @resource_policies = args[:resource_policies] if args.key?(:resource_policies)
          @satisfies_pzi = args[:satisfies_pzi] if args.key?(:satisfies_pzi)
          @satisfies_pzs = args[:satisfies_pzs] if args.key?(:satisfies_pzs)
          @self_link = args[:self_link] if args.key?(:self_link)
          @standby_policy = args[:standby_policy] if args.key?(:standby_policy)
          @stateful_policy = args[:stateful_policy] if args.key?(:stateful_policy)
          @status = args[:status] if args.key?(:status)
          @target_pools = args[:target_pools] if args.key?(:target_pools)
          @target_size = args[:target_size] if args.key?(:target_size)
          @target_stopped_size = args[:target_stopped_size] if args.key?(:target_stopped_size)
          @target_suspended_size = args[:target_suspended_size] if args.key?(:target_suspended_size)
          @update_policy = args[:update_policy] if args.key?(:update_policy)
          @versions = args[:versions] if args.key?(:versions)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class InstanceGroupManagerActionsSummary
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] The total number of instances in the managed
        # instance group
        # that are scheduled to be abandoned. Abandoning an instance removes it
        # from the managed instance group without deleting it.
        # Corresponds to the JSON property `abandoning`
        # @return [Fixnum]
        attr_accessor :abandoning
      
        # Output only. [Output Only] The number of instances in the managed instance
        # group that
        # are scheduled to be created or are currently being created. If the group
        # fails to create any of these instances, it tries again until it creates
        # the instance successfully.
        # If you have disabled creation retries, this field will not be populated;
        # instead, the creatingWithoutRetries field will be populated.
        # Corresponds to the JSON property `creating`
        # @return [Fixnum]
        attr_accessor :creating
      
        # Output only. [Output Only] The number of instances that the managed instance
        # group
        # will attempt to create. The group attempts to create each instance
        # only once. If the group fails to create any of these instances, it
        # decreases the group's targetSize value accordingly.
        # Corresponds to the JSON property `creatingWithoutRetries`
        # @return [Fixnum]
        attr_accessor :creating_without_retries
      
        # Output only. [Output Only] The number of instances in the managed instance
        # group that
        # are scheduled to be deleted or are currently being deleted.
        # Corresponds to the JSON property `deleting`
        # @return [Fixnum]
        attr_accessor :deleting
      
        # Output only. [Output Only] The number of instances in the managed instance
        # group that
        # are running and have no scheduled actions.
        # Corresponds to the JSON property `none`
        # @return [Fixnum]
        attr_accessor :none
      
        # Output only. [Output Only] The number of instances in the managed instance
        # group that
        # are scheduled to be recreated or are currently being being recreated.
        # Recreating an instance deletes the existing root persistent disk
        # and creates a new disk from the image that is defined in the
        # instance template.
        # Corresponds to the JSON property `recreating`
        # @return [Fixnum]
        attr_accessor :recreating
      
        # Output only. [Output Only] The number of instances in the managed instance
        # group that
        # are being reconfigured with properties that do not require a restart
        # or a recreate action. For example, setting or removing target
        # pools for the instance.
        # Corresponds to the JSON property `refreshing`
        # @return [Fixnum]
        attr_accessor :refreshing
      
        # Output only. [Output Only] The number of instances in the managed instance
        # group that
        # are scheduled to be restarted or are currently being restarted.
        # Corresponds to the JSON property `restarting`
        # @return [Fixnum]
        attr_accessor :restarting
      
        # Output only. [Output Only] The number of instances in the managed instance
        # group that
        # are scheduled to be resumed or are currently being resumed.
        # Corresponds to the JSON property `resuming`
        # @return [Fixnum]
        attr_accessor :resuming
      
        # Output only. [Output Only] The number of instances in the managed instance
        # group that
        # are scheduled to be started or are currently being started.
        # Corresponds to the JSON property `starting`
        # @return [Fixnum]
        attr_accessor :starting
      
        # Output only. [Output Only] The number of instances in the managed instance
        # group that
        # are scheduled to be stopped or are currently being stopped.
        # Corresponds to the JSON property `stopping`
        # @return [Fixnum]
        attr_accessor :stopping
      
        # Output only. [Output Only] The number of instances in the managed instance
        # group that
        # are scheduled to be suspended or are currently being suspended.
        # Corresponds to the JSON property `suspending`
        # @return [Fixnum]
        attr_accessor :suspending
      
        # Output only. [Output Only] The number of instances in the managed instance
        # group that
        # are being verified. See the managedInstances[].currentAction
        # property in the listManagedInstances method documentation.
        # Corresponds to the JSON property `verifying`
        # @return [Fixnum]
        attr_accessor :verifying
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @abandoning = args[:abandoning] if args.key?(:abandoning)
          @creating = args[:creating] if args.key?(:creating)
          @creating_without_retries = args[:creating_without_retries] if args.key?(:creating_without_retries)
          @deleting = args[:deleting] if args.key?(:deleting)
          @none = args[:none] if args.key?(:none)
          @recreating = args[:recreating] if args.key?(:recreating)
          @refreshing = args[:refreshing] if args.key?(:refreshing)
          @restarting = args[:restarting] if args.key?(:restarting)
          @resuming = args[:resuming] if args.key?(:resuming)
          @starting = args[:starting] if args.key?(:starting)
          @stopping = args[:stopping] if args.key?(:stopping)
          @suspending = args[:suspending] if args.key?(:suspending)
          @verifying = args[:verifying] if args.key?(:verifying)
        end
      end
      
      # 
      class InstanceGroupManagerAggregatedList
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Unique identifier for the resource; defined by the
        # server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceGroupManagersScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeV1::InstanceGroupManagersScopedList>]
        attr_accessor :items
      
        # Output only. [Output Only] The resource type, which is alwayscompute#
        # instanceGroupManagerAggregatedList for an aggregated
        # list of managed instance groups.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Output only. [Output Only] This token allows you to get the next page of
        # results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Unreachable resources.
        # Corresponds to the JSON property `unreachables`
        # @return [Array<String>]
        attr_accessor :unreachables
      
        # Output only. [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @unreachables = args[:unreachables] if args.key?(:unreachables)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Output only. [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::InstanceGroupManagerAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class InstanceGroupManagerAllInstancesConfig
        include Google::Apis::Core::Hashable
      
        # Represents the change that you want to make to the instance properties.
        # Corresponds to the JSON property `properties`
        # @return [Google::Apis::ComputeV1::InstancePropertiesPatch]
        attr_accessor :properties
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @properties = args[:properties] if args.key?(:properties)
        end
      end
      
      # 
      class InstanceGroupManagerAutoHealingPolicy
        include Google::Apis::Core::Hashable
      
        # The URL for the health check that signals autohealing.
        # Corresponds to the JSON property `healthCheck`
        # @return [String]
        attr_accessor :health_check
      
        # The initial delay is the number of seconds that a new VM takes to
        # initialize and run its startup script. During a VM's initial delay
        # period, the MIG ignores unsuccessful health checks because the VM might
        # be in the startup process. This prevents the MIG from prematurely
        # recreating a VM. If the health check receives a healthy response during
        # the initial delay, it indicates that the startup process is complete and
        # the VM is ready. The value of initial delay must be between 0 and 3600
        # seconds. The default value is 0.
        # Corresponds to the JSON property `initialDelaySec`
        # @return [Fixnum]
        attr_accessor :initial_delay_sec
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @health_check = args[:health_check] if args.key?(:health_check)
          @initial_delay_sec = args[:initial_delay_sec] if args.key?(:initial_delay_sec)
        end
      end
      
      # 
      class InstanceGroupManagerInstanceFlexibilityPolicy
        include Google::Apis::Core::Hashable
      
        # Named instance selections configuring properties that the group will use
        # when creating new VMs.
        # Corresponds to the JSON property `instanceSelections`
        # @return [Hash<String,Google::Apis::ComputeV1::InstanceGroupManagerInstanceFlexibilityPolicyInstanceSelection>]
        attr_accessor :instance_selections
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_selections = args[:instance_selections] if args.key?(:instance_selections)
        end
      end
      
      # 
      class InstanceGroupManagerInstanceFlexibilityPolicyInstanceSelection
        include Google::Apis::Core::Hashable
      
        # Full machine-type names, e.g. "n1-standard-16".
        # Corresponds to the JSON property `machineTypes`
        # @return [Array<String>]
        attr_accessor :machine_types
      
        # Preference of this instance selection. Lower number means higher
        # preference. MIG will first try to create a VM based on the machine-type
        # with lowest rank and fallback to next rank based on availability.
        # Machine types and instance selections with the same rank have the same
        # preference.
        # Corresponds to the JSON property `rank`
        # @return [Fixnum]
        attr_accessor :rank
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @machine_types = args[:machine_types] if args.key?(:machine_types)
          @rank = args[:rank] if args.key?(:rank)
        end
      end
      
      # 
      class InstanceGroupManagerInstanceLifecyclePolicy
        include Google::Apis::Core::Hashable
      
        # The action that a MIG performs on a failed or an unhealthy VM.
        # A VM is marked as unhealthy when the application running on that
        # VM fails a health check.
        # Valid values are
        # 
        # - REPAIR (default): MIG automatically repairs a failed or
        # an unhealthy VM by recreating it. For more information, see About
        # repairing VMs in a MIG.
        # - DO_NOTHING: MIG does not repair a failed or an unhealthy
        # VM.
        # Corresponds to the JSON property `defaultActionOnFailure`
        # @return [String]
        attr_accessor :default_action_on_failure
      
        # A bit indicating whether to forcefully apply the group's latest
        # configuration when repairing a VM. Valid options are:
        # 
        # 
        # -  NO (default): If configuration updates are available, they are not
        # forcefully applied during repair. Instead, configuration updates are
        # applied according to the group's update policy.
        # 
        # -  YES: If configuration updates are available, they are applied
        # during repair.
        # Corresponds to the JSON property `forceUpdateOnRepair`
        # @return [String]
        attr_accessor :force_update_on_repair
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @default_action_on_failure = args[:default_action_on_failure] if args.key?(:default_action_on_failure)
          @force_update_on_repair = args[:force_update_on_repair] if args.key?(:force_update_on_repair)
        end
      end
      
      # [Output Only] A list of managed instance groups.
      class InstanceGroupManagerList
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Unique identifier for the resource; defined by the
        # server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceGroupManager resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::InstanceGroupManager>]
        attr_accessor :items
      
        # Output only. [Output Only] The resource type, which is always
        # compute#instanceGroupManagerList for a list of managed instance groups.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Output only. [Output Only] This token allows you to get the next page of
        # results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Output only. [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::InstanceGroupManagerList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # InstanceGroupManagerResizeRequest represents a request to create
      # a number of VMs: either immediately or by queuing the request for the
      # specified time. This resize request is nested under InstanceGroupManager
      # and the VMs created by this request are added to the owning
      # InstanceGroupManager.
      class InstanceGroupManagerResizeRequest
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] The creation timestamp for this resize request
        # inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Output only. [Output Only] A unique identifier for this resource type. The
        # server
        # generates this identifier.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. [Output Only] The resource type, which is alwayscompute#
        # instanceGroupManagerResizeRequest for
        # resize requests.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The name of this resize request. The name must be 1-63 characters
        # long, and comply withRFC1035.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # A Duration represents a fixed-length span of time represented
        # as a count of seconds and fractions of seconds at nanosecond
        # resolution. It is independent of any calendar and concepts like "day"
        # or "month". Range is approximately 10,000 years.
        # Corresponds to the JSON property `requestedRunDuration`
        # @return [Google::Apis::ComputeV1::Duration]
        attr_accessor :requested_run_duration
      
        # The number of instances to be created by this resize request. The group's
        # target size will be increased by this number. This field cannot be used
        # together with 'instances'.
        # Corresponds to the JSON property `resizeBy`
        # @return [Fixnum]
        attr_accessor :resize_by
      
        # Output only. [Output Only] The URL for this resize request. The server defines
        # this URL.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Server-defined URL for this resource with the
        # resource id.
        # Corresponds to the JSON property `selfLinkWithId`
        # @return [String]
        attr_accessor :self_link_with_id
      
        # Output only. [Output only] Current state of the request.
        # Corresponds to the JSON property `state`
        # @return [String]
        attr_accessor :state
      
        # Output only. [Output only] Status of the request.
        # Corresponds to the JSON property `status`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerResizeRequestStatus]
        attr_accessor :status
      
        # Output only. [Output Only] The URL of azone
        # where the resize request is located. Populated only for zonal resize
        # requests.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @requested_run_duration = args[:requested_run_duration] if args.key?(:requested_run_duration)
          @resize_by = args[:resize_by] if args.key?(:resize_by)
          @self_link = args[:self_link] if args.key?(:self_link)
          @self_link_with_id = args[:self_link_with_id] if args.key?(:self_link_with_id)
          @state = args[:state] if args.key?(:state)
          @status = args[:status] if args.key?(:status)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class InstanceGroupManagerResizeRequestStatus
        include Google::Apis::Core::Hashable
      
        # Output only. [Output only] Fatal errors encountered during the queueing or
        # provisioning phases of the ResizeRequest that caused the transition to
        # the FAILED state. Contrary to the last_attempt errors, this field is
        # final and errors are never removed from here, as the ResizeRequest is not
        # going to retry.
        # Corresponds to the JSON property `error`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerResizeRequestStatus::Error]
        attr_accessor :error
      
        # Output only. [Output only] Information about the last attempt to fulfill the
        # request.
        # The value is temporary since the ResizeRequest can retry, as long as it's
        # still active and the last attempt value can either be cleared or replaced
        # with a different error. Since ResizeRequest retries infrequently, the
        # value may be stale and no longer show an active problem. The value is
        # cleared when ResizeRequest transitions to the final state (becomes
        # inactive). If the final state is FAILED the error describing it will be
        # storred in the "error" field only.
        # Corresponds to the JSON property `lastAttempt`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerResizeRequestStatusLastAttempt]
        attr_accessor :last_attempt
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @error = args[:error] if args.key?(:error)
          @last_attempt = args[:last_attempt] if args.key?(:last_attempt)
        end
        
        # Output only. [Output only] Fatal errors encountered during the queueing or
        # provisioning phases of the ResizeRequest that caused the transition to
        # the FAILED state. Contrary to the last_attempt errors, this field is
        # final and errors are never removed from here, as the ResizeRequest is not
        # going to retry.
        class Error
          include Google::Apis::Core::Hashable
        
          # [Output Only] The array of errors encountered while processing this
          # operation.
          # Corresponds to the JSON property `errors`
          # @return [Array<Google::Apis::ComputeV1::InstanceGroupManagerResizeRequestStatus::Error::Error>]
          attr_accessor :errors
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @errors = args[:errors] if args.key?(:errors)
          end
          
          # 
          class Error
            include Google::Apis::Core::Hashable
          
            # [Output Only] The error type identifier for this error.
            # Corresponds to the JSON property `code`
            # @return [String]
            attr_accessor :code
          
            # [Output Only] An optional list of messages that contain the error
            # details. There is a set of defined message types to use for providing
            # details.The syntax depends on the error code. For example,
            # QuotaExceededInfo will have details when the error code is
            # QUOTA_EXCEEDED.
            # Corresponds to the JSON property `errorDetails`
            # @return [Array<Google::Apis::ComputeV1::InstanceGroupManagerResizeRequestStatus::Error::Error::ErrorDetail>]
            attr_accessor :error_details
          
            # [Output Only] Indicates the field in the request that caused the error.
            # This property is optional.
            # Corresponds to the JSON property `location`
            # @return [String]
            attr_accessor :location
          
            # [Output Only] An optional, human-readable error message.
            # Corresponds to the JSON property `message`
            # @return [String]
            attr_accessor :message
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @code = args[:code] if args.key?(:code)
              @error_details = args[:error_details] if args.key?(:error_details)
              @location = args[:location] if args.key?(:location)
              @message = args[:message] if args.key?(:message)
            end
            
            # 
            class ErrorDetail
              include Google::Apis::Core::Hashable
            
              # Describes the cause of the error with structured details.
              # Example of an error when contacting the "pubsub.googleapis.com" API when it
              # is not enabled:
              # ` "reason": "API_DISABLED"
              # "domain": "googleapis.com"
              # "metadata": `
              # "resource": "projects/123",
              # "service": "pubsub.googleapis.com"
              # `
              # `
              # This response indicates that the pubsub.googleapis.com API is not enabled.
              # Example of an error that is returned when attempting to create a Spanner
              # instance in a region that is out of stock:
              # ` "reason": "STOCKOUT"
              # "domain": "spanner.googleapis.com",
              # "metadata": `
              # "availableRegions": "us-central1,us-east2"
              # `
              # `
              # Corresponds to the JSON property `errorInfo`
              # @return [Google::Apis::ComputeV1::ErrorInfo]
              attr_accessor :error_info
            
              # Provides links to documentation or for performing an out of band action.
              # For example, if a quota check failed with an error indicating the calling
              # project hasn't enabled the accessed service, this can contain a URL pointing
              # directly to the right place in the developer console to flip the bit.
              # Corresponds to the JSON property `help`
              # @return [Google::Apis::ComputeV1::Help]
              attr_accessor :help
            
              # Provides a localized error message that is safe to return to the user
              # which can be attached to an RPC error.
              # Corresponds to the JSON property `localizedMessage`
              # @return [Google::Apis::ComputeV1::LocalizedMessage]
              attr_accessor :localized_message
            
              # Additional details for quota exceeded error for resource quota.
              # Corresponds to the JSON property `quotaInfo`
              # @return [Google::Apis::ComputeV1::QuotaExceededInfo]
              attr_accessor :quota_info
            
              def initialize(**args)
                 update!(**args)
              end
            
              # Update properties of this object
              def update!(**args)
                @error_info = args[:error_info] if args.key?(:error_info)
                @help = args[:help] if args.key?(:help)
                @localized_message = args[:localized_message] if args.key?(:localized_message)
                @quota_info = args[:quota_info] if args.key?(:quota_info)
              end
            end
          end
        end
      end
      
      # 
      class InstanceGroupManagerResizeRequestStatusLastAttempt
        include Google::Apis::Core::Hashable
      
        # Output only. Errors that prevented the ResizeRequest to be fulfilled.
        # Corresponds to the JSON property `error`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerResizeRequestStatusLastAttempt::Error]
        attr_accessor :error
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @error = args[:error] if args.key?(:error)
        end
        
        # Output only. Errors that prevented the ResizeRequest to be fulfilled.
        class Error
          include Google::Apis::Core::Hashable
        
          # [Output Only] The array of errors encountered while processing this
          # operation.
          # Corresponds to the JSON property `errors`
          # @return [Array<Google::Apis::ComputeV1::InstanceGroupManagerResizeRequestStatusLastAttempt::Error::Error>]
          attr_accessor :errors
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @errors = args[:errors] if args.key?(:errors)
          end
          
          # 
          class Error
            include Google::Apis::Core::Hashable
          
            # [Output Only] The error type identifier for this error.
            # Corresponds to the JSON property `code`
            # @return [String]
            attr_accessor :code
          
            # [Output Only] An optional list of messages that contain the error
            # details. There is a set of defined message types to use for providing
            # details.The syntax depends on the error code. For example,
            # QuotaExceededInfo will have details when the error code is
            # QUOTA_EXCEEDED.
            # Corresponds to the JSON property `errorDetails`
            # @return [Array<Google::Apis::ComputeV1::InstanceGroupManagerResizeRequestStatusLastAttempt::Error::Error::ErrorDetail>]
            attr_accessor :error_details
          
            # [Output Only] Indicates the field in the request that caused the error.
            # This property is optional.
            # Corresponds to the JSON property `location`
            # @return [String]
            attr_accessor :location
          
            # [Output Only] An optional, human-readable error message.
            # Corresponds to the JSON property `message`
            # @return [String]
            attr_accessor :message
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @code = args[:code] if args.key?(:code)
              @error_details = args[:error_details] if args.key?(:error_details)
              @location = args[:location] if args.key?(:location)
              @message = args[:message] if args.key?(:message)
            end
            
            # 
            class ErrorDetail
              include Google::Apis::Core::Hashable
            
              # Describes the cause of the error with structured details.
              # Example of an error when contacting the "pubsub.googleapis.com" API when it
              # is not enabled:
              # ` "reason": "API_DISABLED"
              # "domain": "googleapis.com"
              # "metadata": `
              # "resource": "projects/123",
              # "service": "pubsub.googleapis.com"
              # `
              # `
              # This response indicates that the pubsub.googleapis.com API is not enabled.
              # Example of an error that is returned when attempting to create a Spanner
              # instance in a region that is out of stock:
              # ` "reason": "STOCKOUT"
              # "domain": "spanner.googleapis.com",
              # "metadata": `
              # "availableRegions": "us-central1,us-east2"
              # `
              # `
              # Corresponds to the JSON property `errorInfo`
              # @return [Google::Apis::ComputeV1::ErrorInfo]
              attr_accessor :error_info
            
              # Provides links to documentation or for performing an out of band action.
              # For example, if a quota check failed with an error indicating the calling
              # project hasn't enabled the accessed service, this can contain a URL pointing
              # directly to the right place in the developer console to flip the bit.
              # Corresponds to the JSON property `help`
              # @return [Google::Apis::ComputeV1::Help]
              attr_accessor :help
            
              # Provides a localized error message that is safe to return to the user
              # which can be attached to an RPC error.
              # Corresponds to the JSON property `localizedMessage`
              # @return [Google::Apis::ComputeV1::LocalizedMessage]
              attr_accessor :localized_message
            
              # Additional details for quota exceeded error for resource quota.
              # Corresponds to the JSON property `quotaInfo`
              # @return [Google::Apis::ComputeV1::QuotaExceededInfo]
              attr_accessor :quota_info
            
              def initialize(**args)
                 update!(**args)
              end
            
              # Update properties of this object
              def update!(**args)
                @error_info = args[:error_info] if args.key?(:error_info)
                @help = args[:help] if args.key?(:help)
                @localized_message = args[:localized_message] if args.key?(:localized_message)
                @quota_info = args[:quota_info] if args.key?(:quota_info)
              end
            end
          end
        end
      end
      
      # [Output Only] A list of resize requests.
      class InstanceGroupManagerResizeRequestsListResponse
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Unique identifier for the resource; defined by the
        # server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of resize request resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::InstanceGroupManagerResizeRequest>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of the resource. Alwayscompute#
        # instanceGroupManagerResizeRequestList for
        # a list of resize requests.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Output only. [Output Only] This token allows you to get the next page of
        # results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerResizeRequestsListResponse::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Output only. [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::InstanceGroupManagerResizeRequestsListResponse::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class InstanceGroupManagerResourcePolicies
        include Google::Apis::Core::Hashable
      
        # The URL of the workload policy that is specified for this managed
        # instance group.
        # It can be a full or partial URL. For example, the following are
        # all valid URLs to a workload policy:
        # 
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/regions/region/
        # resourcePolicies/resourcePolicy
        # - projects/project/regions/region/resourcePolicies/resourcePolicy
        # - regions/region/resourcePolicies/resourcePolicy
        # Corresponds to the JSON property `workloadPolicy`
        # @return [String]
        attr_accessor :workload_policy
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @workload_policy = args[:workload_policy] if args.key?(:workload_policy)
        end
      end
      
      # 
      class InstanceGroupManagerStandbyPolicy
        include Google::Apis::Core::Hashable
      
        # Specifies the number of seconds that the MIG should wait to suspend or
        # stop a VM after that VM was created. The initial delay gives the
        # initialization script the time to prepare your VM for a quick scale out.
        # The value of initial delay must be between 0 and 3600 seconds. The
        # default value is 0.
        # Corresponds to the JSON property `initialDelaySec`
        # @return [Fixnum]
        attr_accessor :initial_delay_sec
      
        # Defines how a MIG resumes or starts VMs from a standby pool when the
        # group scales out. The default mode is `MANUAL`.
        # Corresponds to the JSON property `mode`
        # @return [String]
        attr_accessor :mode
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @initial_delay_sec = args[:initial_delay_sec] if args.key?(:initial_delay_sec)
          @mode = args[:mode] if args.key?(:mode)
        end
      end
      
      # 
      class InstanceGroupManagerStatus
        include Google::Apis::Core::Hashable
      
        # Output only. [Output only] Status of all-instances configuration on the group.
        # Corresponds to the JSON property `allInstancesConfig`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerStatusAllInstancesConfig]
        attr_accessor :all_instances_config
      
        # Output only. [Output Only] The URL of theAutoscaler
        # that targets this instance group manager.
        # Corresponds to the JSON property `autoscaler`
        # @return [String]
        attr_accessor :autoscaler
      
        # Output only. [Output Only] A bit indicating whether the managed instance group
        # is in a
        # stable state. A stable state means that: none of the instances in the
        # managed instance group is currently undergoing any type of change (for
        # example, creation, restart, or deletion); no future changes are scheduled
        # for instances in the managed instance group; and the managed instance
        # group itself is not being modified.
        # Corresponds to the JSON property `isStable`
        # @return [Boolean]
        attr_accessor :is_stable
        alias_method :is_stable?, :is_stable
      
        # Output only. [Output Only] Stateful status of the given Instance Group Manager.
        # Corresponds to the JSON property `stateful`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerStatusStateful]
        attr_accessor :stateful
      
        # Output only. [Output Only] A status of consistency of Instances' versions with
        # their
        # target version specified by version field on Instance Group
        # Manager.
        # Corresponds to the JSON property `versionTarget`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerStatusVersionTarget]
        attr_accessor :version_target
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @all_instances_config = args[:all_instances_config] if args.key?(:all_instances_config)
          @autoscaler = args[:autoscaler] if args.key?(:autoscaler)
          @is_stable = args[:is_stable] if args.key?(:is_stable)
          @stateful = args[:stateful] if args.key?(:stateful)
          @version_target = args[:version_target] if args.key?(:version_target)
        end
      end
      
      # 
      class InstanceGroupManagerStatusAllInstancesConfig
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Current all-instances configuration revision.
        # This value is in RFC3339 text format.
        # Corresponds to the JSON property `currentRevision`
        # @return [String]
        attr_accessor :current_revision
      
        # Output only. [Output Only] A bit indicating whether this configuration has
        # been applied to all managed instances in the group.
        # Corresponds to the JSON property `effective`
        # @return [Boolean]
        attr_accessor :effective
        alias_method :effective?, :effective
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @current_revision = args[:current_revision] if args.key?(:current_revision)
          @effective = args[:effective] if args.key?(:effective)
        end
      end
      
      # 
      class InstanceGroupManagerStatusStateful
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] A bit indicating whether the managed instance group
        # has stateful configuration, that is, if you have configured any items
        # in a stateful policy or in per-instance configs.
        # The group might report that it has no stateful configuration even when
        # there is still some preserved state on a managed instance, for example,
        # if you have deleted all PICs but not yet applied those deletions.
        # Corresponds to the JSON property `hasStatefulConfig`
        # @return [Boolean]
        attr_accessor :has_stateful_config
        alias_method :has_stateful_config?, :has_stateful_config
      
        # Output only. [Output Only] Status of per-instance configurations on the
        # instances.
        # Corresponds to the JSON property `perInstanceConfigs`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagerStatusStatefulPerInstanceConfigs]
        attr_accessor :per_instance_configs
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @has_stateful_config = args[:has_stateful_config] if args.key?(:has_stateful_config)
          @per_instance_configs = args[:per_instance_configs] if args.key?(:per_instance_configs)
        end
      end
      
      # 
      class InstanceGroupManagerStatusStatefulPerInstanceConfigs
        include Google::Apis::Core::Hashable
      
        # Output only. A bit indicating if all of the group's per-instance
        # configurations
        # (listed in the output of a listPerInstanceConfigs API call) have
        # status EFFECTIVE or there are no per-instance-configs.
        # Corresponds to the JSON property `allEffective`
        # @return [Boolean]
        attr_accessor :all_effective
        alias_method :all_effective?, :all_effective
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @all_effective = args[:all_effective] if args.key?(:all_effective)
        end
      end
      
      # 
      class InstanceGroupManagerStatusVersionTarget
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] A bit indicating whether version target has been
        # reached
        # in this managed instance group, i.e. all instances are in their target
        # version. Instances' target version are specified byversion field on Instance
        # Group Manager.
        # Corresponds to the JSON property `isReached`
        # @return [Boolean]
        attr_accessor :is_reached
        alias_method :is_reached?, :is_reached
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @is_reached = args[:is_reached] if args.key?(:is_reached)
        end
      end
      
      # 
      class InstanceGroupManagerUpdatePolicy
        include Google::Apis::Core::Hashable
      
        # The
        # instance redistribution policy for regional managed instance groups.
        # Valid values are:
        # 
        # - PROACTIVE (default): The group attempts to maintain an
        # even distribution of VM instances across zones in the region.
        # - NONE: For non-autoscaled groups, proactive
        # redistribution is disabled.
        # Corresponds to the JSON property `instanceRedistributionType`
        # @return [String]
        attr_accessor :instance_redistribution_type
      
        # Encapsulates numeric value that can be either absolute or relative.
        # Corresponds to the JSON property `maxSurge`
        # @return [Google::Apis::ComputeV1::FixedOrPercent]
        attr_accessor :max_surge
      
        # Encapsulates numeric value that can be either absolute or relative.
        # Corresponds to the JSON property `maxUnavailable`
        # @return [Google::Apis::ComputeV1::FixedOrPercent]
        attr_accessor :max_unavailable
      
        # Minimal action to be taken on an instance. Use this option to minimize
        # disruption as much as possible or to apply a more disruptive action than
        # is necessary.
        # 
        # - To limit disruption as much as possible, set the minimal action toREFRESH.
        # If your update requires a more disruptive action,
        # Compute Engine performs the necessary action to execute the update.
        # - To apply a more disruptive action than is strictly necessary, set the
        # minimal action to RESTART or REPLACE. For
        # example, Compute Engine does not need to restart a VM to change its
        # metadata. But if your application reads instance metadata only when a VM
        # is restarted, you can set the minimal action to RESTART in
        # order to pick up metadata changes.
        # Corresponds to the JSON property `minimalAction`
        # @return [String]
        attr_accessor :minimal_action
      
        # Most disruptive action that is allowed to be taken on an instance.
        # You can specify either NONE to forbid any actions,REFRESH to avoid restarting
        # the VM and to limit disruption
        # as much as possible. RESTART to allow actions that can be
        # applied without instance replacing or REPLACE to allow all
        # possible actions. If the Updater determines that the minimal update
        # action needed is more disruptive than most disruptive allowed action you
        # specify it will not perform the update at all.
        # Corresponds to the JSON property `mostDisruptiveAllowedAction`
        # @return [String]
        attr_accessor :most_disruptive_allowed_action
      
        # What action should be used to replace instances.
        # See minimal_action.REPLACE
        # Corresponds to the JSON property `replacementMethod`
        # @return [String]
        attr_accessor :replacement_method
      
        # The type
        # of update process. You can specify either PROACTIVE so
        # that the MIG automatically updates VMs to the latest configurations
        # orOPPORTUNISTIC so that you can select the VMs that you want
        # to update.
        # Corresponds to the JSON property `type`
        # @return [String]
        attr_accessor :type
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_redistribution_type = args[:instance_redistribution_type] if args.key?(:instance_redistribution_type)
          @max_surge = args[:max_surge] if args.key?(:max_surge)
          @max_unavailable = args[:max_unavailable] if args.key?(:max_unavailable)
          @minimal_action = args[:minimal_action] if args.key?(:minimal_action)
          @most_disruptive_allowed_action = args[:most_disruptive_allowed_action] if args.key?(:most_disruptive_allowed_action)
          @replacement_method = args[:replacement_method] if args.key?(:replacement_method)
          @type = args[:type] if args.key?(:type)
        end
      end
      
      # 
      class InstanceGroupManagerVersion
        include Google::Apis::Core::Hashable
      
        # The URL of the instance template that is specified for this managed
        # instance group. The group uses this template to create new instances in
        # the managed instance group until the `targetSize` for this version is
        # reached. The templates for existing instances in the group do not change
        # unless you run recreateInstances, runapplyUpdatesToInstances, or set the group'
        # supdatePolicy.type to PROACTIVE; in those cases,
        # existing instances are updated until the `targetSize` for this version is
        # reached.
        # Corresponds to the JSON property `instanceTemplate`
        # @return [String]
        attr_accessor :instance_template
      
        # Name of the version. Unique among all versions in the scope of this
        # managed instance group.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # Encapsulates numeric value that can be either absolute or relative.
        # Corresponds to the JSON property `targetSize`
        # @return [Google::Apis::ComputeV1::FixedOrPercent]
        attr_accessor :target_size
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_template = args[:instance_template] if args.key?(:instance_template)
          @name = args[:name] if args.key?(:name)
          @target_size = args[:target_size] if args.key?(:target_size)
        end
      end
      
      # 
      class InstanceGroupManagersAbandonInstancesRequest
        include Google::Apis::Core::Hashable
      
        # The URLs of one or more instances to abandon. This can be a full URL or
        # a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # InstanceGroupManagers.applyUpdatesToInstances
      class InstanceGroupManagersApplyUpdatesRequest
        include Google::Apis::Core::Hashable
      
        # Flag to update all instances instead of specified list of “instances”.
        # If the flag is set to true then the instances may not be specified
        # in the request.
        # Corresponds to the JSON property `allInstances`
        # @return [Boolean]
        attr_accessor :all_instances
        alias_method :all_instances?, :all_instances
      
        # The list of URLs of one or more instances for which you want to apply
        # updates. Each URL can be a full URL or a partial URL, such aszones/[ZONE]/
        # instances/[INSTANCE_NAME].
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        # The minimal action that you want to perform on each instance during the
        # update:
        # 
        # 
        # - REPLACE: At minimum, delete the instance and create it
        # again.
        # - RESTART: Stop the instance and start it
        # again.
        # - REFRESH: Do not stop the instance and limit
        # disruption as much as possible.
        # - NONE: Do not
        # disrupt the instance at all.
        # By default, the minimum action is NONE. If your update
        # requires a more disruptive action than you set with this flag, the
        # necessary action is performed to execute the update.
        # Corresponds to the JSON property `minimalAction`
        # @return [String]
        attr_accessor :minimal_action
      
        # The most disruptive action that you want to perform on each instance during
        # the update:
        # 
        # 
        # - REPLACE: Delete the instance and create it again.
        # - RESTART: Stop the instance and start it again.
        # - REFRESH: Do not stop the instance and limit disruption
        # as much as possible.
        # - NONE: Do not disrupt the
        # instance at all.
        # By default, the most disruptive allowed action is REPLACE. If
        # your update requires a more disruptive action than you set with this flag,
        # the update request will fail.
        # Corresponds to the JSON property `mostDisruptiveAllowedAction`
        # @return [String]
        attr_accessor :most_disruptive_allowed_action
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @all_instances = args[:all_instances] if args.key?(:all_instances)
          @instances = args[:instances] if args.key?(:instances)
          @minimal_action = args[:minimal_action] if args.key?(:minimal_action)
          @most_disruptive_allowed_action = args[:most_disruptive_allowed_action] if args.key?(:most_disruptive_allowed_action)
        end
      end
      
      # InstanceGroupManagers.createInstances
      class InstanceGroupManagersCreateInstancesRequest
        include Google::Apis::Core::Hashable
      
        # [Required] List of specifications of per-instance configs.
        # Corresponds to the JSON property `instances`
        # @return [Array<Google::Apis::ComputeV1::PerInstanceConfig>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # 
      class InstanceGroupManagersDeleteInstancesRequest
        include Google::Apis::Core::Hashable
      
        # The URLs of one or more instances to delete. This can be a full URL or
        # a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
        # Queued instances do not have URL and can be deleted only by name.
        # One cannot specify both URLs and names in a single request.
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        # Specifies whether the request should proceed despite the inclusion of
        # instances that are not members of the group or that are already in the
        # process of being deleted or abandoned. If this field is set to `false` and
        # such an instance is specified in the request, the operation fails. The
        # operation always fails if the request contains a malformed instance URL or
        # a reference to an instance that exists in a zone or region other than the
        # group's zone or region.
        # Corresponds to the JSON property `skipInstancesOnValidationError`
        # @return [Boolean]
        attr_accessor :skip_instances_on_validation_error
        alias_method :skip_instances_on_validation_error?, :skip_instances_on_validation_error
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
          @skip_instances_on_validation_error = args[:skip_instances_on_validation_error] if args.key?(:skip_instances_on_validation_error)
        end
      end
      
      # InstanceGroupManagers.deletePerInstanceConfigs
      class InstanceGroupManagersDeletePerInstanceConfigsReq
        include Google::Apis::Core::Hashable
      
        # The list of instance names for which we want to delete per-instance configs
        # on this managed instance group.
        # Corresponds to the JSON property `names`
        # @return [Array<String>]
        attr_accessor :names
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @names = args[:names] if args.key?(:names)
        end
      end
      
      # 
      class InstanceGroupManagersListErrorsResponse
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] The list of errors of the managed instance group.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::InstanceManagedByIgmError>]
        attr_accessor :items
      
        # Output only. [Output Only] This token allows you to get the next page of
        # results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @items = args[:items] if args.key?(:items)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
        end
      end
      
      # 
      class InstanceGroupManagersListManagedInstancesResponse
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] The list of instances in the managed instance group.
        # Corresponds to the JSON property `managedInstances`
        # @return [Array<Google::Apis::ComputeV1::ManagedInstance>]
        attr_accessor :managed_instances
      
        # Output only. [Output Only] This token allows you to get the next page of
        # results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @managed_instances = args[:managed_instances] if args.key?(:managed_instances)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
        end
      end
      
      # 
      class InstanceGroupManagersListPerInstanceConfigsResp
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] The list of PerInstanceConfig.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::PerInstanceConfig>]
        attr_accessor :items
      
        # Output only. [Output Only] This token allows you to get the next page of
        # results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagersListPerInstanceConfigsResp::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @items = args[:items] if args.key?(:items)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Output only. [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::InstanceGroupManagersListPerInstanceConfigsResp::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # InstanceGroupManagers.patchPerInstanceConfigs
      class InstanceGroupManagersPatchPerInstanceConfigsReq
        include Google::Apis::Core::Hashable
      
        # The list of per-instance configurations to insert or patch on this managed
        # instance group.
        # Corresponds to the JSON property `perInstanceConfigs`
        # @return [Array<Google::Apis::ComputeV1::PerInstanceConfig>]
        attr_accessor :per_instance_configs
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @per_instance_configs = args[:per_instance_configs] if args.key?(:per_instance_configs)
        end
      end
      
      # 
      class InstanceGroupManagersRecreateInstancesRequest
        include Google::Apis::Core::Hashable
      
        # The URLs of one or more instances to recreate. This can be a full URL or
        # a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # 
      class InstanceGroupManagersResumeInstancesRequest
        include Google::Apis::Core::Hashable
      
        # The URLs of one or more instances to resume. This can be a full URL or
        # a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # 
      class InstanceGroupManagersScopedList
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] The list of managed instance groups that are
        # contained in
        # the specified project and zone.
        # Corresponds to the JSON property `instanceGroupManagers`
        # @return [Array<Google::Apis::ComputeV1::InstanceGroupManager>]
        attr_accessor :instance_group_managers
      
        # Output only. [Output Only] The warning that replaces the list of managed
        # instance
        # groups when the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::InstanceGroupManagersScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_group_managers = args[:instance_group_managers] if args.key?(:instance_group_managers)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Output only. [Output Only] The warning that replaces the list of managed
        # instance
        # groups when the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::InstanceGroupManagersScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class InstanceGroupManagersSetInstanceTemplateRequest
        include Google::Apis::Core::Hashable
      
        # The URL of the instance template that is specified for this managed
        # instance group. The group uses this template to create all new instances
        # in the managed instance group. The templates for existing instances in the
        # group do not change unless you run recreateInstances,
        # runapplyUpdatesToInstances, or set the group'supdatePolicy.type to PROACTIVE.
        # Corresponds to the JSON property `instanceTemplate`
        # @return [String]
        attr_accessor :instance_template
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_template = args[:instance_template] if args.key?(:instance_template)
        end
      end
      
      # 
      class InstanceGroupManagersSetTargetPoolsRequest
        include Google::Apis::Core::Hashable
      
        # The fingerprint of the target pools information. Use this optional
        # property to prevent conflicts when multiple users change the target pools
        # settings concurrently. Obtain the fingerprint with theinstanceGroupManagers.
        # get
        # method. Then, include the fingerprint in your request to ensure that you
        # do not overwrite changes that were applied from another
        # concurrent request.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # The list of target pool URLs that instances in this managed instance group
        # belong to. The managed instance group applies these target pools to all
        # of the instances in the group. Existing instances and new instances in the
        # group all receive these target pool settings.
        # Corresponds to the JSON property `targetPools`
        # @return [Array<String>]
        attr_accessor :target_pools
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @target_pools = args[:target_pools] if args.key?(:target_pools)
        end
      end
      
      # 
      class InstanceGroupManagersStartInstancesRequest
        include Google::Apis::Core::Hashable
      
        # The URLs of one or more instances to start. This can be a full URL or
        # a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # 
      class InstanceGroupManagersStopInstancesRequest
        include Google::Apis::Core::Hashable
      
        # If this flag is set to true, the Instance Group Manager will proceed to
        # stop the instances, skipping initialization on them.
        # Corresponds to the JSON property `forceStop`
        # @return [Boolean]
        attr_accessor :force_stop
        alias_method :force_stop?, :force_stop
      
        # The URLs of one or more instances to stop. This can be a full URL or
        # a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @force_stop = args[:force_stop] if args.key?(:force_stop)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # 
      class InstanceGroupManagersSuspendInstancesRequest
        include Google::Apis::Core::Hashable
      
        # If this flag is set to true, the Instance Group Manager will proceed to
        # suspend the instances, skipping initialization on them.
        # Corresponds to the JSON property `forceSuspend`
        # @return [Boolean]
        attr_accessor :force_suspend
        alias_method :force_suspend?, :force_suspend
      
        # The URLs of one or more instances to suspend. This can be a full URL or
        # a partial URL, such as zones/[ZONE]/instances/[INSTANCE_NAME].
        # Corresponds to the JSON property `instances`
        # @return [Array<String>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @force_suspend = args[:force_suspend] if args.key?(:force_suspend)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # InstanceGroupManagers.updatePerInstanceConfigs
      class InstanceGroupManagersUpdatePerInstanceConfigsReq
        include Google::Apis::Core::Hashable
      
        # The list of per-instance configurations to insert or patch on this managed
        # instance group.
        # Corresponds to the JSON property `perInstanceConfigs`
        # @return [Array<Google::Apis::ComputeV1::PerInstanceConfig>]
        attr_accessor :per_instance_configs
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @per_instance_configs = args[:per_instance_configs] if args.key?(:per_instance_configs)
        end
      end
      
      # 
      class InstanceGroupsAddInstancesRequest
        include Google::Apis::Core::Hashable
      
        # The list of instances to add to the instance group.
        # Corresponds to the JSON property `instances`
        # @return [Array<Google::Apis::ComputeV1::InstanceReference>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # 
      class InstanceGroupsListInstances
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Unique identifier for the resource; defined by the
        # server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceWithNamedPorts resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::InstanceWithNamedPorts>]
        attr_accessor :items
      
        # Output only. [Output Only] The resource type, which is alwayscompute#
        # instanceGroupsListInstances for the list of instances
        # in the specified instance group.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Output only. [Output Only] This token allows you to get the next page of
        # results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # Output only. [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::InstanceGroupsListInstances::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Output only. [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::InstanceGroupsListInstances::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class InstanceGroupsListInstancesRequest
        include Google::Apis::Core::Hashable
      
        # A filter for the state of the instances in the instance group. Valid
        # options are ALL or RUNNING. If you do not specify
        # this parameter the list includes all instances regardless of their state.
        # Corresponds to the JSON property `instanceState`
        # @return [String]
        attr_accessor :instance_state
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_state = args[:instance_state] if args.key?(:instance_state)
        end
      end
      
      # 
      class InstanceGroupsRemoveInstancesRequest
        include Google::Apis::Core::Hashable
      
        # The list of instances to remove from the instance group.
        # Corresponds to the JSON property `instances`
        # @return [Array<Google::Apis::ComputeV1::InstanceReference>]
        attr_accessor :instances
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instances = args[:instances] if args.key?(:instances)
        end
      end
      
      # 
      class InstanceGroupsScopedList
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] The list ofinstance
        # groups that are contained in this scope.
        # Corresponds to the JSON property `instanceGroups`
        # @return [Array<Google::Apis::ComputeV1::InstanceGroup>]
        attr_accessor :instance_groups
      
        # Output only. [Output Only] An informational warning that replaces the list of
        # instance groups when the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::InstanceGroupsScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_groups = args[:instance_groups] if args.key?(:instance_groups)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # Output only. [Output Only] An informational warning that replaces the list of
        # instance groups when the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::InstanceGroupsScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class InstanceGroupsSetNamedPortsRequest
        include Google::Apis::Core::Hashable
      
        # The fingerprint of the named ports information for this instance group.
        # Use this optional property to prevent conflicts when multiple users change
        # the named ports settings concurrently. Obtain the fingerprint with
        # theinstanceGroups.get
        # method. Then, include the fingerprint in your request to ensure that you
        # do not overwrite changes that were applied from another concurrent request.
        # A request with an incorrect fingerprint will fail with error412
        # conditionNotMet.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # The list of named ports to set for this instance group.
        # Corresponds to the JSON property `namedPorts`
        # @return [Array<Google::Apis::ComputeV1::NamedPort>]
        attr_accessor :named_ports
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @named_ports = args[:named_ports] if args.key?(:named_ports)
        end
      end
      
      # Contains a list of instances.
      class InstanceList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Instance resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::Instance>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Always compute#instanceList
        # for lists of Instance resources.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::InstanceList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::InstanceList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # Contains a list of instance referrers.
      class InstanceListReferrers
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of Reference resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::Reference>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of resource. Alwayscompute#
        # instanceListReferrers for lists of Instance referrers.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::InstanceListReferrers::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::InstanceListReferrers::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class InstanceManagedByIgmError
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Contents of the error.
        # Corresponds to the JSON property `error`
        # @return [Google::Apis::ComputeV1::InstanceManagedByIgmErrorManagedInstanceError]
        attr_accessor :error
      
        # Output only. [Output Only] Details of the instance action that triggered this
        # error.
        # May be null, if the error was not caused by an action on an instance.
        # This field is optional.
        # Corresponds to the JSON property `instanceActionDetails`
        # @return [Google::Apis::ComputeV1::InstanceManagedByIgmErrorInstanceActionDetails]
        attr_accessor :instance_action_details
      
        # Output only. [Output Only] The time that this error occurred.
        # This value is in RFC3339 text format.
        # Corresponds to the JSON property `timestamp`
        # @return [String]
        attr_accessor :timestamp
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @error = args[:error] if args.key?(:error)
          @instance_action_details = args[:instance_action_details] if args.key?(:instance_action_details)
          @timestamp = args[:timestamp] if args.key?(:timestamp)
        end
      end
      
      # 
      class InstanceManagedByIgmErrorInstanceActionDetails
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Action that managed instance group was executing on
        # the instance when the error occurred. Possible values:
        # Corresponds to the JSON property `action`
        # @return [String]
        attr_accessor :action
      
        # Output only. [Output Only] The URL of the instance.
        # The URL can be set even if the instance has not yet been created.
        # Corresponds to the JSON property `instance`
        # @return [String]
        attr_accessor :instance
      
        # Output only. [Output Only] Version this instance was created from, or was
        # being
        # created from, but the creation failed. Corresponds to one of the versions
        # that were set on the Instance Group Manager resource at the time this
        # instance was being created.
        # Corresponds to the JSON property `version`
        # @return [Google::Apis::ComputeV1::ManagedInstanceVersion]
        attr_accessor :version
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @action = args[:action] if args.key?(:action)
          @instance = args[:instance] if args.key?(:instance)
          @version = args[:version] if args.key?(:version)
        end
      end
      
      # 
      class InstanceManagedByIgmErrorManagedInstanceError
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] Error code.
        # Corresponds to the JSON property `code`
        # @return [String]
        attr_accessor :code
      
        # Output only. [Output Only] Error message.
        # Corresponds to the JSON property `message`
        # @return [String]
        attr_accessor :message
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @code = args[:code] if args.key?(:code)
          @message = args[:message] if args.key?(:message)
        end
      end
      
      # 
      class MoveInstanceRequest
        include Google::Apis::Core::Hashable
      
        # The URL of the destination zone to move the instance. This can be a full or
        # partial URL. For example, the following are all valid URLs to a zone:
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone
        # - projects/project/zones/zone
        # - zones/zone
        # Corresponds to the JSON property `destinationZone`
        # @return [String]
        attr_accessor :destination_zone
      
        # The URL of the target instance to move. This can be a full or partial URL.
        # For example, the following are all valid URLs to an instance:
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone/
        # instances/instance
        # - projects/project/zones/zone/instances/instance
        # - zones/zone/instances/instance
        # Corresponds to the JSON property `targetInstance`
        # @return [String]
        attr_accessor :target_instance
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @destination_zone = args[:destination_zone] if args.key?(:destination_zone)
          @target_instance = args[:target_instance] if args.key?(:target_instance)
        end
      end
      
      # Additional instance params.
      class InstanceParams
        include Google::Apis::Core::Hashable
      
        # A Duration represents a fixed-length span of time represented
        # as a count of seconds and fractions of seconds at nanosecond
        # resolution. It is independent of any calendar and concepts like "day"
        # or "month". Range is approximately 10,000 years.
        # Corresponds to the JSON property `requestValidForDuration`
        # @return [Google::Apis::ComputeV1::Duration]
        attr_accessor :request_valid_for_duration
      
        # Resource manager tags to be bound to the instance. Tag keys and values
        # have the same definition as resource
        # manager tags. Keys and values can be either in numeric format,
        # such as `tagKeys/`tag_key_id`` and `tagValues/456` or in namespaced
        # format such as ``org_id|project_id`/`tag_key_short_name`` and
        # ``tag_value_short_name``. The field is ignored (both PUT &
        # PATCH) when empty.
        # Corresponds to the JSON property `resourceManagerTags`
        # @return [Hash<String,String>]
        attr_accessor :resource_manager_tags
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @request_valid_for_duration = args[:request_valid_for_duration] if args.key?(:request_valid_for_duration)
          @resource_manager_tags = args[:resource_manager_tags] if args.key?(:resource_manager_tags)
        end
      end
      
      # 
      class InstanceProperties
        include Google::Apis::Core::Hashable
      
        # Specifies options for controlling advanced machine features.
        # Options that would traditionally be configured in a BIOS belong
        # here. Features that require operating system support may have
        # corresponding entries in the GuestOsFeatures of anImage (e.g., whether or not
        # the OS in theImage supports nested virtualization being enabled or
        # disabled).
        # Corresponds to the JSON property `advancedMachineFeatures`
        # @return [Google::Apis::ComputeV1::AdvancedMachineFeatures]
        attr_accessor :advanced_machine_features
      
        # Enables instances created based on these properties to send packets with
        # source IP addresses other than their own and receive packets with
        # destination IP addresses other than their own. If these instances will be
        # used as an IP gateway or it will be set as the next-hop in a Route
        # resource, specify true. If unsure, leave this set tofalse. See theEnable IP
        # forwarding
        # documentation for more information.
        # Corresponds to the JSON property `canIpForward`
        # @return [Boolean]
        attr_accessor :can_ip_forward
        alias_method :can_ip_forward?, :can_ip_forward
      
        # A set of Confidential Instance options.
        # Corresponds to the JSON property `confidentialInstanceConfig`
        # @return [Google::Apis::ComputeV1::ConfidentialInstanceConfig]
        attr_accessor :confidential_instance_config
      
        # An optional text description for the instances that are created from these
        # properties.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # An array of disks that are associated with the instances that are created
        # from these properties.
        # Corresponds to the JSON property `disks`
        # @return [Array<Google::Apis::ComputeV1::AttachedDisk>]
        attr_accessor :disks
      
        # A list of guest accelerator cards' type and count to use for instances
        # created from these properties.
        # Corresponds to the JSON property `guestAccelerators`
        # @return [Array<Google::Apis::ComputeV1::AcceleratorConfig>]
        attr_accessor :guest_accelerators
      
        # KeyRevocationActionType of the instance. Supported options are "STOP" and
        # "NONE". The default value is "NONE" if it is not specified.
        # Corresponds to the JSON property `keyRevocationActionType`
        # @return [String]
        attr_accessor :key_revocation_action_type
      
        # Labels to apply to instances that are created from these properties.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # The machine type to use for instances that are created from these
        # properties.
        # This field only accepts a machine type name, for example `n2-standard-4`.
        # If you use the machine type full or partial URL, for example
        # `projects/my-l7ilb-project/zones/us-central1-a/machineTypes/n2-standard-4`,
        # the request will result in an `INTERNAL_ERROR`.
        # Corresponds to the JSON property `machineType`
        # @return [String]
        attr_accessor :machine_type
      
        # A metadata key/value entry.
        # Corresponds to the JSON property `metadata`
        # @return [Google::Apis::ComputeV1::Metadata]
        attr_accessor :metadata
      
        # Minimum cpu/platform to be used by instances. The instance may be
        # scheduled on the specified or newer cpu/platform. Applicable values are the
        # friendly names of CPU platforms, such asminCpuPlatform: "Intel Haswell"
        # orminCpuPlatform: "Intel Sandy Bridge". For more
        # information, read Specifying a
        # Minimum CPU Platform.
        # Corresponds to the JSON property `minCpuPlatform`
        # @return [String]
        attr_accessor :min_cpu_platform
      
        # An array of network access configurations for this interface.
        # Corresponds to the JSON property `networkInterfaces`
        # @return [Array<Google::Apis::ComputeV1::NetworkInterface>]
        attr_accessor :network_interfaces
      
        # Note that for MachineImage, this is not supported yet.
        # Corresponds to the JSON property `networkPerformanceConfig`
        # @return [Google::Apis::ComputeV1::NetworkPerformanceConfig]
        attr_accessor :network_performance_config
      
        # The private IPv6 google access type for VMs.
        # If not specified, use  INHERIT_FROM_SUBNETWORK as default.
        # Note that for MachineImage, this is not supported yet.
        # Corresponds to the JSON property `privateIpv6GoogleAccess`
        # @return [String]
        attr_accessor :private_ipv6_google_access
      
        # Specifies the reservations that this instance can consume from.
        # Corresponds to the JSON property `reservationAffinity`
        # @return [Google::Apis::ComputeV1::ReservationAffinity]
        attr_accessor :reservation_affinity
      
        # Resource manager tags to be bound to the instance. Tag keys and values
        # have the same definition as resource
        # manager tags. Keys must be in the format `tagKeys/`tag_key_id``, and
        # values are in the format `tagValues/456`. The field is ignored (both PUT &
        # PATCH) when empty.
        # Corresponds to the JSON property `resourceManagerTags`
        # @return [Hash<String,String>]
        attr_accessor :resource_manager_tags
      
        # Resource policies (names, not URLs) applied to instances created from
        # these properties.
        # Note that for MachineImage, this is not supported yet.
        # Corresponds to the JSON property `resourcePolicies`
        # @return [Array<String>]
        attr_accessor :resource_policies
      
        # Sets the scheduling options for an Instance.
        # Corresponds to the JSON property `scheduling`
        # @return [Google::Apis::ComputeV1::Scheduling]
        attr_accessor :scheduling
      
        # A list of service accounts with specified scopes. Access tokens for these
        # service accounts are available to the instances that are created from
        # these properties. Use metadata queries to obtain the access tokens for
        # these instances.
        # Corresponds to the JSON property `serviceAccounts`
        # @return [Array<Google::Apis::ComputeV1::ServiceAccount>]
        attr_accessor :service_accounts
      
        # A set of Shielded Instance options.
        # Corresponds to the JSON property `shieldedInstanceConfig`
        # @return [Google::Apis::ComputeV1::ShieldedInstanceConfig]
        attr_accessor :shielded_instance_config
      
        # A set of instance tags.
        # Corresponds to the JSON property `tags`
        # @return [Google::Apis::ComputeV1::Tags]
        attr_accessor :tags
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @advanced_machine_features = args[:advanced_machine_features] if args.key?(:advanced_machine_features)
          @can_ip_forward = args[:can_ip_forward] if args.key?(:can_ip_forward)
          @confidential_instance_config = args[:confidential_instance_config] if args.key?(:confidential_instance_config)
          @description = args[:description] if args.key?(:description)
          @disks = args[:disks] if args.key?(:disks)
          @guest_accelerators = args[:guest_accelerators] if args.key?(:guest_accelerators)
          @key_revocation_action_type = args[:key_revocation_action_type] if args.key?(:key_revocation_action_type)
          @labels = args[:labels] if args.key?(:labels)
          @machine_type = args[:machine_type] if args.key?(:machine_type)
          @metadata = args[:metadata] if args.key?(:metadata)
          @min_cpu_platform = args[:min_cpu_platform] if args.key?(:min_cpu_platform)
          @network_interfaces = args[:network_interfaces] if args.key?(:network_interfaces)
          @network_performance_config = args[:network_performance_config] if args.key?(:network_performance_config)
          @private_ipv6_google_access = args[:private_ipv6_google_access] if args.key?(:private_ipv6_google_access)
          @reservation_affinity = args[:reservation_affinity] if args.key?(:reservation_affinity)
          @resource_manager_tags = args[:resource_manager_tags] if args.key?(:resource_manager_tags)
          @resource_policies = args[:resource_policies] if args.key?(:resource_policies)
          @scheduling = args[:scheduling] if args.key?(:scheduling)
          @service_accounts = args[:service_accounts] if args.key?(:service_accounts)
          @shielded_instance_config = args[:shielded_instance_config] if args.key?(:shielded_instance_config)
          @tags = args[:tags] if args.key?(:tags)
        end
      end
      
      # Represents the change that you want to make to the instance properties.
      class InstancePropertiesPatch
        include Google::Apis::Core::Hashable
      
        # The label key-value pairs that you want to patch onto the instance.
        # Corresponds to the JSON property `labels`
        # @return [Hash<String,String>]
        attr_accessor :labels
      
        # The metadata key-value pairs that you want to patch onto the instance. For
        # more information, see Project and
        # instance metadata.
        # Corresponds to the JSON property `metadata`
        # @return [Hash<String,String>]
        attr_accessor :metadata
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @labels = args[:labels] if args.key?(:labels)
          @metadata = args[:metadata] if args.key?(:metadata)
        end
      end
      
      # 
      class InstanceReference
        include Google::Apis::Core::Hashable
      
        # The URL for a specific instance.
        # @required compute.instancegroups.addInstances/removeInstances
        # Corresponds to the JSON property `instance`
        # @return [String]
        attr_accessor :instance
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance = args[:instance] if args.key?(:instance)
        end
      end
      
      # Represents a Instance Settings resource. You can use instance settings to
      # configure default settings for Compute Engine VM instances. For example, you
      # can use it to configure default machine type of Compute Engine VM instances.
      class InstanceSettings
        include Google::Apis::Core::Hashable
      
        # Specifies a fingerprint for instance settings, which is essentially a hash
        # of the instance settings resource's contents and used for optimistic
        # locking. The fingerprint is initially generated by Compute Engine and
        # changes after every request to modify or update the instance settings
        # resource. You must always provide an up-to-date fingerprint hash in order
        # to update or change the resource, otherwise the request will fail with
        # error 412 conditionNotMet.
        # To see the latest fingerprint, make a get() request to
        # retrieve the resource.
        # Corresponds to the JSON property `fingerprint`
        # NOTE: Values are automatically base64 encoded/decoded in the client library.
        # @return [String]
        attr_accessor :fingerprint
      
        # Output only. [Output Only] Type of the resource. Alwayscompute#
        # instance_settings for instance settings.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # The metadata key/value pairs assigned to all the instances in the
        # corresponding scope.
        # Corresponds to the JSON property `metadata`
        # @return [Google::Apis::ComputeV1::InstanceSettingsMetadata]
        attr_accessor :metadata
      
        # Output only. [Output Only] URL of the zone where the resource resides
        # You must specify this field as part of the HTTP request URL. It is not
        # settable as a field in the request body.
        # Corresponds to the JSON property `zone`
        # @return [String]
        attr_accessor :zone
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @fingerprint = args[:fingerprint] if args.key?(:fingerprint)
          @kind = args[:kind] if args.key?(:kind)
          @metadata = args[:metadata] if args.key?(:metadata)
          @zone = args[:zone] if args.key?(:zone)
        end
      end
      
      # 
      class InstanceSettingsMetadata
        include Google::Apis::Core::Hashable
      
        # A metadata key/value items map.
        # The total size of all keys and values must be less than 512KB.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,String>]
        attr_accessor :items
      
        # Output only. [Output Only] Type of the resource. Always compute#metadata
        # for metadata.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
        end
      end
      
      # Represents an Instance Template resource.
      # Google Compute Engine has two Instance Template resources:
      # * [Global](/compute/docs/reference/rest/v1/instanceTemplates)
      # * [Regional](/compute/docs/reference/rest/v1/regionInstanceTemplates)
      # You can reuse a global instance template in
      # different regions whereas you can use a regional instance template in a
      # specified region only. If you want to reduce cross-region dependency or
      # achieve data residency, use a regional instance template.
      # To create VMs, managed instance groups, and reservations, you can use either
      # global or regional instance templates.
      # For more information, readInstance Templates.
      class InstanceTemplate
        include Google::Apis::Core::Hashable
      
        # Output only. [Output Only] The creation timestamp for this instance template
        # inRFC3339
        # text format.
        # Corresponds to the JSON property `creationTimestamp`
        # @return [String]
        attr_accessor :creation_timestamp
      
        # An optional description of this resource. Provide this property when you
        # create the resource.
        # Corresponds to the JSON property `description`
        # @return [String]
        attr_accessor :description
      
        # Output only. [Output Only] A unique identifier for this instance template. The
        # server
        # defines this identifier.
        # Corresponds to the JSON property `id`
        # @return [Fixnum]
        attr_accessor :id
      
        # Output only. [Output Only] The resource type, which is alwayscompute#
        # instanceTemplate for instance templates.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # Name of the resource; provided by the client when the resource is created.
        # The name must be 1-63 characters long, and comply withRFC1035.
        # Specifically, the name must be 1-63 characters long and match the regular
        # expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
        # character must be a lowercase letter, and all following characters must be
        # a dash, lowercase letter, or digit, except the last character, which cannot
        # be a dash.
        # Corresponds to the JSON property `name`
        # @return [String]
        attr_accessor :name
      
        # The instance properties for this instance template.
        # Corresponds to the JSON property `properties`
        # @return [Google::Apis::ComputeV1::InstanceProperties]
        attr_accessor :properties
      
        # Output only. [Output Only] URL of the region where the instance template
        # resides. Only
        # applicable for regional resources.
        # Corresponds to the JSON property `region`
        # @return [String]
        attr_accessor :region
      
        # Output only. [Output Only] The URL for this instance template. The server
        # defines this
        # URL.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # The source instance used to create the template. You can provide this as a
        # partial or full URL to the resource. For example, the following are valid
        # values:
        # 
        # 
        # - https://www.googleapis.com/compute/v1/projects/project/zones/zone/
        # instances/instance
        # - projects/project/zones/zone/instances/instance
        # Corresponds to the JSON property `sourceInstance`
        # @return [String]
        attr_accessor :source_instance
      
        # A specification of the parameters to use when creating the instance template
        # from a source instance.
        # Corresponds to the JSON property `sourceInstanceParams`
        # @return [Google::Apis::ComputeV1::SourceInstanceParams]
        attr_accessor :source_instance_params
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @creation_timestamp = args[:creation_timestamp] if args.key?(:creation_timestamp)
          @description = args[:description] if args.key?(:description)
          @id = args[:id] if args.key?(:id)
          @kind = args[:kind] if args.key?(:kind)
          @name = args[:name] if args.key?(:name)
          @properties = args[:properties] if args.key?(:properties)
          @region = args[:region] if args.key?(:region)
          @self_link = args[:self_link] if args.key?(:self_link)
          @source_instance = args[:source_instance] if args.key?(:source_instance)
          @source_instance_params = args[:source_instance_params] if args.key?(:source_instance_params)
        end
      end
      
      # Contains a list of InstanceTemplatesScopedList.
      class InstanceTemplateAggregatedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceTemplatesScopedList resources.
        # Corresponds to the JSON property `items`
        # @return [Hash<String,Google::Apis::ComputeV1::InstanceTemplatesScopedList>]
        attr_accessor :items
      
        # Output only. Type of resource.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::InstanceTemplateAggregatedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::InstanceTemplateAggregatedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # A list of instance templates.
      class InstanceTemplateList
        include Google::Apis::Core::Hashable
      
        # [Output Only] Unique identifier for the resource; defined by the server.
        # Corresponds to the JSON property `id`
        # @return [String]
        attr_accessor :id
      
        # A list of InstanceTemplate resources.
        # Corresponds to the JSON property `items`
        # @return [Array<Google::Apis::ComputeV1::InstanceTemplate>]
        attr_accessor :items
      
        # Output only. [Output Only] The resource type, which is alwayscompute#
        # instanceTemplatesListResponse for instance template
        # lists.
        # Corresponds to the JSON property `kind`
        # @return [String]
        attr_accessor :kind
      
        # [Output Only] This token allows you to get the next page of results for
        # list requests. If the number of results is larger thanmaxResults, use the
        # nextPageToken as a value for
        # the query parameter pageToken in the next list request.
        # Subsequent list requests will have their own nextPageToken to
        # continue paging through the results.
        # Corresponds to the JSON property `nextPageToken`
        # @return [String]
        attr_accessor :next_page_token
      
        # Output only. [Output Only] Server-defined URL for this resource.
        # Corresponds to the JSON property `selfLink`
        # @return [String]
        attr_accessor :self_link
      
        # [Output Only] Informational warning message.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::InstanceTemplateList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @id = args[:id] if args.key?(:id)
          @items = args[:items] if args.key?(:items)
          @kind = args[:kind] if args.key?(:kind)
          @next_page_token = args[:next_page_token] if args.key?(:next_page_token)
          @self_link = args[:self_link] if args.key?(:self_link)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] Informational warning message.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::InstanceTemplateList::Warning::Datum>]
          attr_accessor :data
        
          # [Output Only] A human-readable description of the warning code.
          # Corresponds to the JSON property `message`
          # @return [String]
          attr_accessor :message
        
          def initialize(**args)
             update!(**args)
          end
        
          # Update properties of this object
          def update!(**args)
            @code = args[:code] if args.key?(:code)
            @data = args[:data] if args.key?(:data)
            @message = args[:message] if args.key?(:message)
          end
          
          # 
          class Datum
            include Google::Apis::Core::Hashable
          
            # [Output Only] A key that provides more detail on the warning being
            # returned. For example, for warnings where there are no results in a list
            # request for a particular zone, this key might be scope and
            # the key value might be the zone name. Other examples might be a key
            # indicating a deprecated resource and a suggested replacement, or a
            # warning about invalid network settings (for example, if an instance
            # attempts to perform IP forwarding but is not enabled for IP forwarding).
            # Corresponds to the JSON property `key`
            # @return [String]
            attr_accessor :key
          
            # [Output Only] A warning data value corresponding to the key.
            # Corresponds to the JSON property `value`
            # @return [String]
            attr_accessor :value
          
            def initialize(**args)
               update!(**args)
            end
          
            # Update properties of this object
            def update!(**args)
              @key = args[:key] if args.key?(:key)
              @value = args[:value] if args.key?(:value)
            end
          end
        end
      end
      
      # 
      class InstanceTemplatesScopedList
        include Google::Apis::Core::Hashable
      
        # [Output Only] A list of instance templates that are contained within
        # the specified project and zone.
        # Corresponds to the JSON property `instanceTemplates`
        # @return [Array<Google::Apis::ComputeV1::InstanceTemplate>]
        attr_accessor :instance_templates
      
        # [Output Only] An informational warning that replaces the list of instance
        # templates when the list is empty.
        # Corresponds to the JSON property `warning`
        # @return [Google::Apis::ComputeV1::InstanceTemplatesScopedList::Warning]
        attr_accessor :warning
      
        def initialize(**args)
           update!(**args)
        end
      
        # Update properties of this object
        def update!(**args)
          @instance_templates = args[:instance_templates] if args.key?(:instance_templates)
          @warning = args[:warning] if args.key?(:warning)
        end
        
        # [Output Only] An informational warning that replaces the list of instance
        # templates when the list is empty.
        class Warning
          include Google::Apis::Core::Hashable
        
          # [Output Only] A warning code, if applicable. For example, Compute
          # Engine returns NO_RESULTS_ON_PAGE if there
          # are no results in the response.
          # Corresponds to the JSON property `code`
          # @return [String]
          attr_accessor :code
        
          # [Output Only] Metadata about this warning in key:
          # value format. For example:
          # "data": [
          # `
          # "key": "scope",
          # "value": "zones/us-east1-d"
          # `
          # Corresponds to the JSON property `data`
          # @return [Array<Google::Apis::ComputeV1::InstanceTemplatesScopedList::Warning::Datum>]
          attr_accessor :data
        
          # [Output