/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkFontMetrics;
import gnu.java.awt.peer.gtk.GdkGraphics;
import gnu.java.awt.peer.gtk.GdkGraphics2D;
import gnu.java.awt.peer.gtk.GtkArg;
import gnu.java.awt.peer.gtk.GtkArgList;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkOffScreenImage;
import gnu.java.awt.peer.gtk.GtkToolkit;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;

public class GtkComponentPeer
extends GtkGenericPeer
implements ComponentPeer {
    Component awtComponent;
    Insets insets;

    native boolean isEnabled();

    static native boolean modalHasGrab();

    native int[] gtkWidgetGetForeground();

    native int[] gtkWidgetGetBackground();

    native void gtkWidgetSetVisible(boolean var1);

    native void gtkWidgetGetDimensions(int[] var1);

    native void gtkWidgetGetPreferredDimensions(int[] var1);

    native void gtkWidgetGetLocationOnScreen(int[] var1);

    native void gtkWidgetSetCursor(int var1);

    native void gtkWidgetSetBackground(int var1, int var2, int var3);

    native void gtkWidgetSetForeground(int var1, int var2, int var3);

    void create() {
        throw new RuntimeException();
    }

    native void connectJObject();

    native void connectSignals();

    protected GtkComponentPeer(Component awtComponent) {
        super(awtComponent);
        this.awtComponent = awtComponent;
        this.insets = new Insets(0, 0, 0, 0);
        try {
            this.create();
            GtkArgList args = new GtkArgList();
            this.getArgs(awtComponent, args);
            args.setArgs(this);
            this.connectJObject();
            this.connectSignals();
            if (awtComponent.getForeground() != null) {
                this.setForeground(awtComponent.getForeground());
            }
            if (awtComponent.getBackground() != null) {
                this.setBackground(awtComponent.getBackground());
            }
            if (awtComponent.getFont() != null) {
                this.setFont(awtComponent.getFont());
            }
            this.setCursor(awtComponent.getCursor());
            Rectangle bounds = awtComponent.getBounds();
            this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public int checkImage(Image image, int width, int height, ImageObserver observer) {
        GtkImage i = (GtkImage)image;
        return i.checkImage();
    }

    public Image createImage(ImageProducer producer) {
        return new GtkImage(producer, null);
    }

    public Image createImage(int width, int height) {
        Graphics g;
        if (GtkToolkit.useGraphics2D()) {
            GdkGraphics2D g2 = new GdkGraphics2D(width, height);
            ((Graphics2D)g2).setBackground(this.getBackground());
            g = g2;
        } else {
            g = new GdkGraphics(width, height);
        }
        return new GtkOffScreenImage(null, g, width, height);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public FontMetrics getFontMetrics(Font font) {
        return new GdkFontMetrics(font);
    }

    public Graphics getGraphics() {
        return null;
    }

    public Point getLocationOnScreen() {
        int[] point = new int[2];
        this.gtkWidgetGetLocationOnScreen(point);
        return new Point(point[0], point[1]);
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public void handleEvent(AWTEvent event) {
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Dimension minimumSize() {
        int[] dim = new int[2];
        this.gtkWidgetGetPreferredDimensions(dim);
        return new Dimension(dim[0], dim[1]);
    }

    public void paint(Graphics g) {
        this.awtComponent.paint(g);
    }

    public Dimension preferredSize() {
        int[] dim = new int[2];
        this.gtkWidgetGetPreferredDimensions(dim);
        return new Dimension(dim[0], dim[1]);
    }

    public boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
        GtkImage i = (GtkImage)image;
        if (i.isLoaded()) {
            return true;
        }
        new 1.PrepareImage(this, i, observer).start();
        return false;
    }

    public void print(Graphics g) {
        throw new RuntimeException();
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        GtkGenericPeer.q.postEvent(new PaintEvent(this.awtComponent, 801, new Rectangle(x, y, width, height)));
    }

    public native void requestFocus();

    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    public void setBackground(Color c) {
        this.gtkWidgetSetBackground(c.getRed(), c.getGreen(), c.getBlue());
    }

    public native void setNativeBounds(int var1, int var2, int var3, int var4);

    public void setBounds(int x, int y, int width, int height) {
        Container parent = this.awtComponent.getParent();
        if (parent instanceof Window) {
            Insets insets = ((Window)parent).getInsets();
            this.setNativeBounds(x - insets.left, y - insets.top, width, height);
        } else {
            this.setNativeBounds(x, y, width, height);
        }
    }

    public void setCursor(Cursor cursor) {
        this.gtkWidgetSetCursor(cursor.getType());
    }

    public void setEnabled(boolean b) {
        this.set("sensitive", b);
    }

    public void setFont(Font f) {
    }

    public void setForeground(Color c) {
        this.gtkWidgetSetForeground(c.getRed(), c.getGreen(), c.getBlue());
    }

    public Color getForeground() {
        int[] rgb = this.gtkWidgetGetForeground();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public Color getBackground() {
        int[] rgb = this.gtkWidgetGetBackground();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public void setVisible(boolean b) {
        this.set("visible", b);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void show() {
        this.setVisible(true);
    }

    protected void postMouseEvent(int id, long when, int mods, int x, int y, int clickCount, boolean popupTrigger) {
        GtkGenericPeer.q.postEvent(new MouseEvent(this.awtComponent, id, when, mods, x, y, clickCount, popupTrigger));
    }

    protected void postExposeEvent(int x, int y, int width, int height) {
        GtkGenericPeer.q.postEvent(new PaintEvent(this.awtComponent, 800, new Rectangle(x, y, width, height)));
    }

    protected void postKeyEvent(int id, long when, int mods, int keyCode, char keyChar, int keyLocation) {
        GtkGenericPeer.q.postEvent(new KeyEvent(this.awtComponent, id, when, mods, keyCode, keyChar, keyLocation));
    }

    protected void postFocusEvent(int id, boolean temporary) {
        GtkGenericPeer.q.postEvent(new FocusEvent(this.awtComponent, id, temporary));
    }

    protected void postItemEvent(Object item, int stateChange) {
        GtkGenericPeer.q.postEvent(new ItemEvent((ItemSelectable)((Object)this.awtComponent), 701, item, stateChange));
    }

    public void getArgs(Component component, GtkArgList args) {
        ComponentPeer p;
        args.add("visible", component.isVisible());
        args.add("sensitive", component.isEnabled());
        while ((p = (component = component.getParent()).getPeer()) instanceof LightweightPeer) {
        }
        if (p != null) {
            args.add("parent", (Object)p);
        }
    }

    native void set(String var1, String var2);

    native void set(String var1, boolean var2);

    native void set(String var1, int var2);

    native void set(String var1, float var2);

    native void set(String var1, Object var2);

    void set(GtkArg arg) {
        String name = arg.getName();
        Object value = arg.getValue();
        if (value instanceof Boolean) {
            this.set(name, (Boolean)value);
        } else if (value instanceof Integer) {
            this.set(name, (Integer)value);
        } else if (value instanceof Float) {
            this.set(name, ((Float)value).floatValue());
        } else if (value instanceof String) {
            this.set(name, (String)value);
        } else {
            this.set(name, value);
        }
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return null;
    }

    public void setEventMask(long mask) {
    }

    public boolean isFocusable() {
        return false;
    }

    public boolean requestFocus(Component source, boolean b1, boolean b2, long x) {
        return false;
    }

    public boolean isObscured() {
        return false;
    }

    public boolean canDetermineObscurity() {
        return false;
    }

    public void coalescePaintEvent(PaintEvent e) {
    }

    public void updateCursorImmediately() {
    }

    public VolatileImage createVolatileImage(int width, int height) {
        return null;
    }

    public boolean handlesWheelScrolling() {
        return false;
    }

    public void createBuffers(int x, BufferCapabilities capabilities) throws AWTException {
    }

    public Image getBackBuffer() {
        return null;
    }

    public void flip(BufferCapabilities.FlipContents contents) {
    }

    public void destroyBuffers() {
    }
}

