/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class Constructor
extends AccessibleObject
implements Member {
    private Class declaringClass;
    private Class[] exception_types;
    private Class[] parameter_types;
    private int offset;

    private Constructor() {
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public String getName() {
        return this.declaringClass.getName();
    }

    public native int getModifiers();

    public Class[] getParameterTypes() {
        if (this.parameter_types == null) {
            this.getType();
        }
        return (Class[])this.parameter_types.clone();
    }

    public Class[] getExceptionTypes() {
        if (this.exception_types == null) {
            this.getType();
        }
        return (Class[])this.exception_types.clone();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Constructor)) {
            return false;
        }
        Constructor c = (Constructor)obj;
        return this.declaringClass == c.declaringClass && this.offset == c.offset;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.declaringClass.getName().hashCode();
    }

    public String toString() {
        if (this.parameter_types == null) {
            this.getType();
        }
        StringBuffer b = new StringBuffer();
        int mods = this.getModifiers();
        if (mods != 0) {
            Modifier.toString(mods, b);
            b.append(" ");
        }
        Method.appendClassName(b, this.declaringClass);
        b.append("(");
        for (int i = 0; i < this.parameter_types.length; ++i) {
            Method.appendClassName(b, this.parameter_types[i]);
            if (i >= this.parameter_types.length - 1) continue;
            b.append(",");
        }
        b.append(")");
        return b.toString();
    }

    public native Object newInstance(Object[] var1) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    private native void getType();
}

