#
# Rules for making libraries. The object files that make up the library are
# removed once they are archived.
#
# To make several libararies in parallel, you should define the variable
# "many_libraries". This will serialize the invocations of ranlibs.
#
# To use, do something like this:
#
# OBJECTS = <files in the library>
#
# fish.a: fish.a($(OBJECTS)) MAKELIB
#
# $Id: makelib.mk,v 1.3 1992/02/19 07:07:40 stolcke Exp $ SPRITE (Berkeley)
#

#ifndef _MAKELIB_MK
_MAKELIB_MK	=

#include	<po.mk>

.po.a .o.a	:
	...
	$(RM) $(.MEMBER)

ARFLAGS		?= crl

#
# Re-archive the out-of-date members and recreate the library's table of
# contents using ranlib. If many_libraries is defined, put the ranlib off
# til the end so many libraries can be made at once.
#
MAKELIB		: .USE .PRECIOUS
	$(AR) $(ARFLAGS) $(.TARGET) $(.OODATE)
#ifdef many_libraries
	...
#endif many_libraries
	$(RANLIB) $(.TARGET)

#endif _MAKELIB_MK
