/***************************************************************************
                          kwifimanager_configwidget.cpp  -  description
                             -------------------
    begin                : Fre Jan 10 2003
    copyright            : (C) 2003 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <knumvalidator.h>
#include "kwifimanager_configwidget.h"
#include "kwifimanager_configwidget.moc"
#include "configcontainer.h"
#include <qlayout.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <kurlrequester.h>
#include <klineedit.h>

void
KWifimanager_ConfigWidget::saveData (int which_one)
{
  Configcontainer::configs->net_name[which_one] = network_name->text ();
  Configcontainer::configs->script_name[which_one] = script_name->lineEdit()->text();
  mangroup->id (mangroup->selected ()) ==
    0 ? Configcontainer::configs->managed[which_one] =
    true : Configcontainer::configs->managed[which_one] = false;
  Configcontainer::configs->crypto_enabled[which_one] =
    use_crypto->isChecked ();
  Configcontainer::configs->active_crypto_key[which_one] =
    crypto_number->text ().toInt ();
  Configcontainer::configs->active_key_string[which_one] =
    crypto_number->text ();
  Configcontainer::configs->crypto1[which_one] = crypto1->text ();
  Configcontainer::configs->crypto2[which_one] = crypto2->text ();
  Configcontainer::configs->crypto3[which_one] = crypto3->text ();
  Configcontainer::configs->crypto4[which_one] = crypto4->text ();
  Configcontainer::configs->crypto_is_string1[which_one] = ct1->isChecked ();
  Configcontainer::configs->crypto_is_string2[which_one] = ct2->isChecked ();
  Configcontainer::configs->crypto_is_string3[which_one] = ct3->isChecked ();
  Configcontainer::configs->crypto_is_string4[which_one] = ct4->isChecked ();
  switch (openquery->id (openquery->selected ()))
    {
    case 0:
      Configcontainer::configs->crypto_mode[which_one] = OPEN;
      break;
    case 1:
      Configcontainer::configs->crypto_mode[which_one] = RESTRICTED;
      break;
    };
  Configcontainer::configs->pm_enabled[which_one] = pm->isChecked ();
  Configcontainer::configs->sleep_time[which_one] =
    sleeptime->text ().toInt ();
  Configcontainer::configs->sleep_time_string[which_one] = sleeptime->text ();
  Configcontainer::configs->wake_time[which_one] = waketime->text ().toInt ();
  Configcontainer::configs->wake_time_string[which_one] = waketime->text ();
  switch (bitrate->id (bitrate->selected ()))
    {
    case 0:
      Configcontainer::configs->bitrate[which_one] = AUTO;
      break;
    case 1:
      Configcontainer::configs->bitrate[which_one] = M1;
      break;
    case 2:
      Configcontainer::configs->bitrate[which_one] = M2;
      break;
    case 3:
      Configcontainer::configs->bitrate[which_one] = M55;
      break;
    case 4:
      Configcontainer::configs->bitrate[which_one] = M11;
      break;
    };
  switch (receive->id (receive->selected ()))
    {
    case 0:
      Configcontainer::configs->packet[which_one] = UNI;
      break;
    case 1:
      Configcontainer::configs->packet[which_one] = MULTI;
      break;
    case 2:
      Configcontainer::configs->packet[which_one] = BOTH;
      break;
    };
}

void
KWifimanager_ConfigWidget::slotUserChangedSomething ()
{
  emit setChanged (true);
}

void
KWifimanager_ConfigWidget::slotToggleCrypto (bool aktiv)
{
  if (aktiv)
    {
      crypto_number->show ();
      openquery->show ();
      cryptobox->show ();
      cryptlabel->show ();
    }
  else
    {
      crypto_number->hide ();
      openquery->hide ();
      cryptobox->hide ();
      cryptlabel->hide ();
    };
}

void
KWifimanager_ConfigWidget::slotTogglePower (bool aktiv)
{
  if (aktiv)
    {
      sleeptime->show ();
      waketime->show ();
      receive->show ();
      sleep->show ();
      wake->show ();
    }
  else
    {
      sleeptime->hide ();
      waketime->hide ();
      receive->hide ();
      sleep->hide ();
      wake->hide ();
    };
}

KWifimanager_ConfigWidget::KWifimanager_ConfigWidget (int number,
						      QWidget * parent,
						      const char *name)
    : QWidget (parent, name)
{
  geo = new QGridLayout (this, 1, 1, 20, 0);
  network_name =
    new QLineEdit (Configcontainer::configs->net_name[number], this);
  network_name->setMaxLength (200);
  network_name->setFixedSize (150, 20);
  script_name =
    new KURLRequester (Configcontainer::configs->script_name[number], this);
  mangroup =
    new QButtonGroup (2, Qt::Vertical, i18n ("Operational Mode"), this);
  managed = new QRadioButton (i18n ("Infrastructure"), mangroup);
  ad_hoc = new QRadioButton (i18n ("Peer-to-peer"), mangroup);
  Configcontainer::configs->managed[number] ==
    true ? mangroup->setButton (0) : mangroup->setButton (1);
  cryptobox = new QGroupBox (3, Qt::Horizontal, i18n ("Crypto Keys"), this);
  ct1 = new QCheckBox (i18n ("String:"), cryptobox);
  ct1->setChecked (Configcontainer::configs->crypto_is_string1[number]);
  crypto1 =
    new QLineEdit (Configcontainer::configs->crypto1[number], cryptobox);
  crypto1->setEchoMode (QLineEdit::Password);
  crypto1->setFixedSize (100, 20);
  new QLabel ("1", cryptobox);
  ct2 = new QCheckBox (i18n ("String:"), cryptobox);
  ct2->setChecked (Configcontainer::configs->crypto_is_string2[number]);
  crypto2 =
    new QLineEdit (Configcontainer::configs->crypto2[number], cryptobox);
  crypto2->setEchoMode (QLineEdit::Password);
  crypto2->setFixedSize (100, 20);
  new QLabel ("2", cryptobox);
  ct3 = new QCheckBox (i18n ("String:"), cryptobox);
  ct3->setChecked (Configcontainer::configs->crypto_is_string3[number]);
  crypto3 =
    new QLineEdit (Configcontainer::configs->crypto3[number], cryptobox);
  crypto3->setEchoMode (QLineEdit::Password);
  crypto3->setFixedSize (100, 20);
  new QLabel ("3", cryptobox);
  ct4 = new QCheckBox (i18n ("String:"), cryptobox);
  ct4->setChecked (Configcontainer::configs->crypto_is_string4[number]);
  crypto4 =
    new QLineEdit (Configcontainer::configs->crypto4[number], cryptobox);
  crypto4->setEchoMode (QLineEdit::Password);
  crypto4->setFixedSize (100, 20);
  new QLabel ("4", cryptobox);
  bitrate =
    new QButtonGroup (2, Qt::Horizontal, i18n ("Speed Setting"), this);
  MXA = new QRadioButton (i18n ("Auto"), bitrate);
  MX1 = new QRadioButton (i18n ("1 MBit/s"), bitrate);
  MX2 = new QRadioButton (i18n ("2 MBit/s"), bitrate);
  MX55 = new QRadioButton (i18n ("5.5 MBit/s"), bitrate);
  MX11 = new QRadioButton (i18n ("11 MBit/s"), bitrate);
  bitrate->setButton (Configcontainer::configs->bitrate[number]);
  pm = new QCheckBox (i18n ("Enable power management"), this);
  pm->setChecked (Configcontainer::configs->pm_enabled[number]);
  KIntValidator *numValidator = new KIntValidator( this );
  sleep = new QLabel (i18n ("Sleep duration (ms):"), this);
  wake = new QLabel (i18n ("Awaken time (ms):"), this);
  sleeptime = new QLineEdit (this);
  sleeptime->setValidator( numValidator );
  sleeptime->setFixedSize (60, 20);
  sleeptime->setText (Configcontainer::configs->sleep_time_string[number]);
  waketime = new QLineEdit (this);
  waketime->setFixedSize (60, 20);
  waketime->setText (Configcontainer::configs->wake_time_string[number]);
  waketime->setValidator( numValidator );
  receive =
    new QButtonGroup (1, Qt::Horizontal, i18n ("Receive Packets"), this);
  rec_uni = new QRadioButton (i18n ("Unicast only"), receive);
  rec_multi = new QRadioButton (i18n ("Multi/broadcast only"), receive);
  rec_both = new QRadioButton (i18n ("Both"), receive);
  receive->setButton (Configcontainer::configs->packet[number]);
  use_crypto = new QCheckBox (i18n ("Use cryptography"), this);
  use_crypto->setChecked (Configcontainer::configs->crypto_enabled[number]);
  cryptlabel = new QLabel (i18n ("Key to use:"), this);
  crypto_number = new QLineEdit (this);
  crypto_number->setMaxLength (1);
  crypto_number->setFixedSize (20, 20);
  crypto_number->setText (Configcontainer::configs->
			  active_key_string[number]);
  openquery =
    new QButtonGroup (2, Qt::Horizontal, i18n ("Crypto Mode"), this);
  open = new QRadioButton (i18n ("Open mode"), openquery);
  rest = new QRadioButton (i18n ("Restricted mode"), openquery);
  openquery->setButton (Configcontainer::configs->crypto_mode[number]);
  QLabel *sn = new QLabel (i18n ("Execute script on connect:"), this);
  QLabel *nn = new QLabel (i18n ("Network name:"), this);
  geo->addWidget (nn, 0, 0);
  geo->addWidget (network_name, 0, 1);
  geo->addWidget (mangroup, 1, 0);
  geo->addWidget (sn, 2, 0);
  geo->addMultiCellWidget (script_name, 2, 2, 1, 4);
  geo->addMultiCellWidget (use_crypto, 4, 4, 0, 1);
  geo->addWidget (cryptlabel, 5, 0);
  geo->addWidget (crypto_number, 5, 1);
  geo->addMultiCellWidget (openquery, 6, 6, 0, 1);
  geo->addMultiCellWidget (cryptobox, 7, 7, 0, 1);
  geo->addMultiCellWidget (bitrate, 0, 1, 3, 4);
  geo->addMultiCellWidget (pm, 4, 4, 3, 4);
  geo->addWidget (sleep, 5, 3);
  geo->addWidget (sleeptime, 5, 4);
  geo->addWidget (wake, 6, 3);
  geo->addWidget (waketime, 6, 4);
  geo->addMultiCellWidget (receive, 7, 7, 3, 4);
  geo->addColSpacing (2, 25);
  geo->addColSpacing (4,
		      bitrate->sizeHint ().width () -
		      sleep->sizeHint ().width ());
  geo->addRowSpacing (3, 25);
  int temp = crypto_number->sizeHint ().height ();
  if (use_crypto->sizeHint ().height () > temp)
    temp = use_crypto->sizeHint ().height ();
  geo->addRowSpacing (5, temp);
  temp = openquery->sizeHint ().height ();
  geo->addRowSpacing (6, temp);
  temp = cryptobox->sizeHint ().height ();
  geo->addRowSpacing (7, temp);
  temp = cryptobox->sizeHint ().width () - cryptlabel->sizeHint ().width ();
  geo->addColSpacing (1, temp);
  geo->addColSpacing (0, cryptlabel->sizeHint ().width ());
  geo->addColSpacing (3, sleep->sizeHint ().width ());
  geo->addColSpacing (4,
		      bitrate->sizeHint ().width () -
		      sleep->sizeHint ().width ());
  bitrate->setMaximumSize (bitrate->sizeHint ().width (),
			   bitrate->sizeHint ().height ());
  connect (use_crypto, SIGNAL (toggled (bool)), this,
	   SLOT (slotToggleCrypto (bool)));
  slotToggleCrypto (use_crypto->isChecked ());
  connect (pm, SIGNAL (toggled (bool)), this, SLOT (slotTogglePower (bool)));
  slotTogglePower (pm->isChecked ());
  connect (script_name->lineEdit(), SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotUserChangedSomething ()));
  connect (network_name, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotUserChangedSomething ()));
  connect (mangroup, SIGNAL (clicked (int)), this,
	   SLOT (slotUserChangedSomething ()));
  connect (bitrate, SIGNAL (clicked (int)), this,
	   SLOT (slotUserChangedSomething ()));
  connect (pm, SIGNAL (clicked ()), this, SLOT (slotUserChangedSomething ()));
  connect (use_crypto, SIGNAL (clicked ()), this,
	   SLOT (slotUserChangedSomething ()));
  connect (openquery, SIGNAL (clicked (int)), this,
	   SLOT (slotUserChangedSomething ()));
  connect (ct1, SIGNAL (clicked ()), this,
	   SLOT (slotUserChangedSomething ()));
  connect (ct2, SIGNAL (clicked ()), this,
	   SLOT (slotUserChangedSomething ()));
  connect (ct3, SIGNAL (clicked ()), this,
	   SLOT (slotUserChangedSomething ()));
  connect (ct4, SIGNAL (clicked ()), this,
	   SLOT (slotUserChangedSomething ()));
  connect (crypto1, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotUserChangedSomething ()));
  connect (crypto2, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotUserChangedSomething ()));
  connect (crypto3, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotUserChangedSomething ()));
  connect (crypto4, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotUserChangedSomething ()));
  connect (crypto_number, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotUserChangedSomething ()));
  connect (sleeptime, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotUserChangedSomething ()));
  connect (waketime, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotUserChangedSomething ()));
  connect (receive, SIGNAL (clicked (int)), this,
	   SLOT (slotUserChangedSomething ()));

}

void KWifimanager_ConfigWidget::makeReadOnly()
{
    script_name->setEnabled( false );
    network_name->setEnabled( false );
    crypto1->setEnabled( false );
    crypto2->setEnabled( false );
    crypto3->setEnabled( false );
    crypto4->setEnabled( false );
    sleeptime->setEnabled( false );
    waketime->setEnabled( false );
    crypto_number->setEnabled( false );
    managed->setEnabled( false );
    ad_hoc->setEnabled( false );
    MXA->setEnabled( false );
    MX1->setEnabled( false );
    MX2->setEnabled( false );
    MX55->setEnabled( false );
    MX11->setEnabled( false );
    rec_uni->setEnabled( false );
    rec_multi->setEnabled( false );
    rec_both->setEnabled( false );
    open->setEnabled( false );
    rest->setEnabled( false );
    ct1->setEnabled( false );
    ct2->setEnabled( false );
    ct3->setEnabled( false );
    ct4->setEnabled( false );
    pm->setEnabled( false );
    use_crypto->setEnabled( false );
    sleep->setEnabled( false );
    wake->setEnabled( false );
    cryptlabel->setEnabled( false );
}
