/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class SubList
extends AbstractList {
    final AbstractList backingList;
    final int offset;
    int size;

    SubList(AbstractList backing, int fromIndex, int toIndex) {
        this.backingList = backing;
        this.modCount = backing.modCount;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    void checkMod() {
        if (this.modCount != this.backingList.modCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void checkBoundsInclusive(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
    }

    private void checkBoundsExclusive(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
    }

    public int size() {
        this.checkMod();
        return this.size;
    }

    public Object set(int index, Object o) {
        this.checkMod();
        this.checkBoundsExclusive(index);
        return this.backingList.set(index + this.offset, o);
    }

    public Object get(int index) {
        this.checkMod();
        this.checkBoundsExclusive(index);
        return this.backingList.get(index + this.offset);
    }

    public void add(int index, Object o) {
        this.checkMod();
        this.checkBoundsInclusive(index);
        this.backingList.add(index + this.offset, o);
        ++this.size;
        this.modCount = this.backingList.modCount;
    }

    public Object remove(int index) {
        this.checkMod();
        this.checkBoundsExclusive(index);
        Object o = this.backingList.remove(index + this.offset);
        --this.size;
        this.modCount = this.backingList.modCount;
        return o;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        this.checkMod();
        this.backingList.removeRange(this.offset + fromIndex, this.offset + toIndex);
        this.size -= toIndex - fromIndex;
        this.modCount = this.backingList.modCount;
    }

    public boolean addAll(int index, Collection c) {
        this.checkMod();
        this.checkBoundsInclusive(index);
        int csize = c.size();
        boolean result = this.backingList.addAll(this.offset + index, c);
        this.size += csize;
        this.modCount = this.backingList.modCount;
        return result;
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator(int index) {
        this.checkMod();
        this.checkBoundsInclusive(index);
        return new ListIterator(this, index){
            private /* synthetic */ SubList this$0;
            private /* synthetic */ int val$index;
            private final ListIterator i;
            private int position;
            {
                this.this$0 = this$0;
                this.finit$(parm$index);
            }

            private /* synthetic */ void finit$(int parm$index) {
                this.val$index = parm$index;
                this.i = this.this$0.backingList.listIterator(this.val$index + this.this$0.offset);
                this.position = this.val$index;
            }

            public boolean hasNext() {
                this.this$0.checkMod();
                return this.position < this.this$0.size;
            }

            public boolean hasPrevious() {
                this.this$0.checkMod();
                return this.position > 0;
            }

            public Object next() {
                if (this.position == this.this$0.size) {
                    throw new NoSuchElementException();
                }
                ++this.position;
                return this.i.next();
            }

            public Object previous() {
                if (this.position == 0) {
                    throw new NoSuchElementException();
                }
                --this.position;
                return this.i.previous();
            }

            public int nextIndex() {
                return this.i.nextIndex() - this.this$0.offset;
            }

            public int previousIndex() {
                return this.i.previousIndex() - this.this$0.offset;
            }

            public void remove() {
                this.i.remove();
                --this.this$0.size;
                this.position = this.nextIndex();
                this.this$0.modCount = this.this$0.backingList.modCount;
            }

            public void set(Object o) {
                this.i.set(o);
            }

            public void add(Object o) {
                this.i.add(o);
                ++this.this$0.size;
                ++this.position;
                this.this$0.modCount = this.this$0.backingList.modCount;
            }
        };
    }
}

