/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileChannelImpl;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd;
    private FileChannel ch;

    public FileInputStream(String name) throws FileNotFoundException {
        this(new File(name));
    }

    public FileInputStream(File file) throws FileNotFoundException {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkRead(file.getPath());
        }
        if (file.isDirectory()) {
            throw new FileNotFoundException(file.getPath() + " is a directory");
        }
        this.fd = new FileDescriptor(file.getPath(), 1);
    }

    public FileInputStream(FileDescriptor fdObj) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkRead(fdObj);
        }
        this.fd = fdObj;
    }

    public int available() throws IOException {
        return this.fd.available();
    }

    public void close() throws IOException {
        if (this.fd.valid()) {
            this.fd.close();
        }
    }

    protected void finalize() throws IOException {
    }

    public final FileDescriptor getFD() throws IOException {
        if (!this.fd.valid()) {
            throw new IOException();
        }
        return this.fd;
    }

    public int read() throws IOException {
        return this.fd.read();
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        if (offset < 0 || len < 0 || offset + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.fd.read(buf, offset, len);
    }

    public synchronized long skip(long numBytes) throws IOException {
        if (numBytes < 0L) {
            throw new IllegalArgumentException("Can't skip negative bytes: " + numBytes);
        }
        if (numBytes == 0L) {
            return 0L;
        }
        long curPos = this.fd.getFilePointer();
        long newPos = this.fd.seek(numBytes, 1, true);
        return newPos - curPos;
    }

    public synchronized FileChannel getChannel() {
        if (this.ch == null) {
            this.ch = new FileChannelImpl(this.fd, false, this);
        }
        return this.ch;
    }
}

