/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.util.Arrays;

public final class Inet6Address
extends InetAddress {
    static final long serialVersionUID = 6880410070516793377L;
    byte[] ipaddress;

    Inet6Address(byte[] addr, String host) {
        super(addr, host);
        this.ipaddress = addr;
    }

    public boolean isMulticastAddress() {
        return this.ipaddress[0] == 255;
    }

    public boolean isAnyLocalAddress() {
        byte[] anylocal = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        return Arrays.equals(this.ipaddress, anylocal);
    }

    public boolean isLoopbackAddress() {
        byte[] loopback = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        return Arrays.equals(this.ipaddress, loopback);
    }

    public boolean isLinkLocalAddress() {
        return this.ipaddress[0] == 250;
    }

    public boolean isSiteLocalAddress() {
        return this.ipaddress[0] == 251;
    }

    public boolean isMCGlobal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 14;
    }

    public boolean isMCNodeLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 1;
    }

    public boolean isMCLinkLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 2;
    }

    public boolean isMCSiteLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 5;
    }

    public boolean isMCOrgLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return (this.ipaddress[1] & 0xF) == 8;
    }

    public byte[] getAddress() {
        return this.ipaddress;
    }

    public String getHostAddress() {
        StringBuffer sbuf = new StringBuffer(40);
        for (int i = 0; i < 16; i += 2) {
            boolean empty;
            int x = (this.ipaddress[i] & 0xFF) << 8 | this.ipaddress[i + 1] & 0xFF;
            boolean bl = empty = sbuf.length() == 0;
            if (empty) {
                if (i > 0) {
                    sbuf.append("::");
                }
            } else {
                sbuf.append(':');
            }
            if (x == 0 && i < 14) continue;
            sbuf.append(Integer.toHexString(x));
        }
        return sbuf.toString();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Inet6Address)) {
            return false;
        }
        Inet6Address tmp = (Inet6Address)obj;
        return super.equals(tmp) && this.ipaddress == tmp.ipaddress;
    }

    public boolean isIPv4CompatibleAddress() {
        return this.ipaddress[0] == 0 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0 && this.ipaddress[3] == 0 && this.ipaddress[4] == 0 && this.ipaddress[5] == 0 && this.ipaddress[6] == 0 && this.ipaddress[7] == 0 && this.ipaddress[8] == 0 && this.ipaddress[9] == 0 && this.ipaddress[10] == 0 && this.ipaddress[11] == 0;
    }
}

