/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class BasicSplitPaneDivider
extends Container
implements PropertyChangeListener {
    static final long serialVersionUID = 1463404307042803342L;
    protected static final int ONE_TOUCH_SIZE = 6;
    protected static final int ONE_TOUCH_OFFSET = 2;
    protected DragController dragger;
    protected BasicSplitPaneUI splitPaneUI;
    protected int dividerSize;
    protected Component hiddenDivider;
    protected JSplitPane splitPane;
    protected MouseHandler mouseHandler;
    protected int orientation;
    protected JButton leftButton;
    protected JButton rightButton;
    private Border border;

    private /* synthetic */ void finit$() {
        this.mouseHandler = new MouseHandler(this);
    }

    public BasicSplitPaneDivider(BasicSplitPaneUI ui) {
        this.finit$();
        this.setBasicSplitPaneUI(ui);
    }

    public void setBasicSplitPaneUI(BasicSplitPaneUI newUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            this.splitPane.removeMouseListener(this.mouseHandler);
            this.splitPane.removeMouseMotionListener(this.mouseHandler);
            this.splitPane = null;
        }
        this.splitPaneUI = newUI;
        if (this.splitPaneUI != null) {
            this.splitPane = newUI.getSplitPane();
        }
        if (this.splitPane != null) {
            this.splitPane.addPropertyChangeListener(this);
            this.splitPane.addMouseListener(this.mouseHandler);
            this.splitPane.addMouseMotionListener(this.mouseHandler);
            this.orientation = this.splitPane.getOrientation();
        }
    }

    public BasicSplitPaneUI getBasicSplitPaneUI() {
        return this.splitPaneUI;
    }

    public void setDividerSize(int newSize) {
        this.dividerSize = newSize;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setBorder(Border border) {
        Border oldValue = this.border;
        this.border = border;
        this.firePropertyChange("border", oldValue, border);
    }

    public Border getBorder() {
        return this.border;
    }

    public Insets getInsets() {
        if (this.border != null) {
            return this.border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.dividerSize, this.dividerSize);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.border != null) {
            Dimension dividerSize = this.getSize();
            this.border.paintBorder(this, g, 0, 0, dividerSize.width, dividerSize.height);
        }
    }

    protected void oneTouchExpandableChanged() {
    }

    protected JButton createLeftOneTouchButton() {
        return new OneTouchButton(true);
    }

    protected JButton createRightOneTouchButton() {
        return new OneTouchButton(false);
    }

    protected void prepareForDragging() {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.startDragging();
        }
    }

    protected void dragDividerTo(int location) {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.dragDividerTo(location);
        }
    }

    protected void finishDraggingTo(int location) {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.finishDraggingTo(location);
        }
    }

    protected class DragController {
        private /* synthetic */ BasicSplitPaneDivider this$0;

        protected DragController(BasicSplitPaneDivider this$0, MouseEvent e) {
            this.this$0 = this$0;
        }

        protected boolean isValid() {
            return true;
        }

        protected int positionForMouseEvent(MouseEvent e) {
            return 0;
        }

        protected int getNeededLocation(int x, int y) {
            return 0;
        }

        protected void continueDrag(int newX, int newY) {
        }

        protected void completeDrag(int x, int y) {
        }

        protected void completeDrag(MouseEvent e) {
        }
    }

    private static class OneTouchButton
    extends JButton {
        OneTouchButton(boolean left) {
            if (left) {
                this.setText("<");
            } else {
                this.setText(">");
            }
            Dimension butSize = new Dimension(6, 6);
            this.setMinimumSize(butSize);
            this.setMaximumSize(butSize);
            this.setPreferredSize(butSize);
            this.setBorderPainted(false);
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private /* synthetic */ BasicSplitPaneDivider this$0;

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        MouseHandler(BasicSplitPaneDivider this$0) {
            this.this$0 = this$0;
        }
    }
}

