/*-
 * customsError.c --
 *	Return string describing import error
 *
 * Copyright (c) 1988, 1989 by the Regents of the University of California
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * Berkeley Softworks and Adam de Boor make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 */
#ifndef lint
static char *rcsid =
"$Id: customsError.c,v 1.2 1994/07/07 03:57:27 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    <string.h>
#include    <stdio.h>
#include    <errno.h>
extern int  errno;

#include    "customs.h"

extern char customsImportError[];


/*-
 *-----------------------------------------------------------------------
 * Customs_ErrorMessage --
 *	Return a string that describes the given error code, as returned
 *	by Customs_RawExport().
 *	NOTE: errno values and the import error string from the last call
 *	to Customs_RawExportAttr() are used, hence this function should
 *	be called immediately upon return of the error condition.
 *
 * Results:
 *	See above.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
char *
Customs_ErrorMessage(code, addr)
    int	  		code;		/* Error code */
    struct in_addr	*addr;		/* Optional server address */
{
    static char msg[128];

    switch (code) {
	case CUSTOMS_NOEXPORT:
	    sprintf(msg, "couldn't export command");
	    break;
	case CUSTOMS_NORETURN:
	    sprintf(msg, "couldn't create return socket: %s",
		    strerror(errno));
	    break;
	case CUSTOMS_NONAME:
	    sprintf(msg, "couldn't find name of return socket: %s",
		    strerror(errno));
	    break;
	case CUSTOMS_ERROR:
	    if (addr) {
	        sprintf(msg, "%s: %s", Customs_Hostname(addr),
		        customsImportError);
	    } else {
		strcpy(msg, customsImportError);
	    }
	    break;
	case CUSTOMS_NOIOSOCK:
	    sprintf(msg, "couldn't create I/O socket: %s",
		    strerror(errno));
	    break;
	case CUSTOMS_NOCWD:
	    sprintf(msg, "couldn't locate current directory: %s",
		    strerror(errno));
	    break;
	default:
	    if (code > -100) {
		sprintf(msg, "local server: %s",
			     Rpc_ErrorMessage(-code));
	    } else {
		sprintf(msg, "%s: %s",
			     addr ? Customs_Hostname(addr) : "remote server",
			     Rpc_ErrorMessage(-(code + 200)));
	    }
	    break;
    }
    return msg;
}

