'\" t
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XGetVInfo.man,v 1.4 2003/04/28 22:17:55 herrb Exp $
.\" $XdotOrg: xc/doc/man/X11/XGetVInfo.man,v 1.2 2004/04/23 18:42:09 eich Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
'\" t
.TH XGetVisualInfo 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XGetVisualInfo, XMatchVisualInfo, XVisualIDFromVisual, XVisualInfo \- obtain visual information and visual structure
.SH SYNTAX
.HP
XVisualInfo *XGetVisualInfo\^(\^Display *\fIdisplay\fP\^, long
\fIvinfo_mask\fP\^, XVisualInfo *\fIvinfo_template\fP\^, int
*\fInitems_return\fP\^); 
.HP
Status XMatchVisualInfo\^(\^Display *\fIdisplay\fP\^, int \fIscreen\fP\^, int
\fIdepth\fP\^, int \fIclass\fP\^, XVisualInfo *\fIvinfo_return\fP\^); 
.HP
VisualID XVisualIDFromVisual\^(\^Visual *\^\fIvisual\fP\^); 
.SH ARGUMENTS
.IP \fIclass\fP 1i
Specifies the class of the screen.
.IP \fIdepth\fP 1i
Specifies the depth of the screen.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fInitems_return\fP 1i
Returns the number of matching visual structures.
.IP \fIscreen\fP 1i
Specifies the screen.
.IP \fIvisual\fP 1i
Specifies the visual type.
.IP \fIvinfo_mask\fP 1i
Specifies the visual mask value.
.IP \fIvinfo_return\fP 1i
Returns the matched visual information.
.IP \fIvinfo_template\fP 1i
Specifies the visual attributes that are to be used in matching the visual
structures.
.SH DESCRIPTION
The
.ZN XGetVisualInfo
function returns a list of visual structures that have attributes 
equal to the attributes specified by vinfo_template.
If no visual structures match the template using the specified vinfo_mask,
.ZN XGetVisualInfo
returns a NULL.
To free the data returned by this function, use
.ZN XFree .
.LP
The
.ZN XMatchVisualInfo
function returns the visual information for a visual that matches the specified
depth and class for a screen.
Because multiple visuals that match the specified depth and class can exist,
the exact visual chosen is undefined.
If a visual is found,
.ZN XMatchVisualInfo
returns nonzero and the information on the visual to vinfo_return.
Otherwise, when a visual is not found,
.ZN XMatchVisualInfo
returns zero.
.LP
The
.ZN XVisualIDFromVisual
function returns the visual ID for the specified visual type.
.SH STRUCTURES
The
.ZN XVisualInfo
structure contains:
.LP
.LP
/\(** Visual information mask bits */
.TS
lw(.5i) lw(2.5i) lw(.8i).
T{
\&#define
T}	T{
.ZN VisualNoMask
T}	T{
0x0
T}
T{
\&#define
T}	T{
.ZN VisualIDMask
T}	T{
0x1
T}
T{
\&#define
T}	T{
.ZN VisualScreenMask
T}	T{
0x2
T}
T{
\&#define
T}	T{
.ZN VisualDepthMask
T}	T{
0x4
T}
T{
\&#define
T}	T{
.ZN VisualClassMask
T}	T{
0x8
T}
T{
\&#define
T}	T{
.ZN VisualRedMaskMask
T}	T{
0x10
T}
T{
\&#define
T}	T{
.ZN VisualGreenMaskMask
T}	T{
0x20
T}
T{
\&#define
T}	T{
.ZN VisualBlueMaskMask
T}	T{
0x40
T}
T{
\&#define
T}	T{
.ZN VisualColormapSizeMask
T}	T{
0x80
T}
T{
\&#define
T}	T{
.ZN VisualBitsPerRGBMask
T}	T{
0x100
T}
T{
\&#define
T}	T{
.ZN VisualAllMask
T}	T{
0x1FF
T}
.TE
.IN "XVisualInfo" "" "@DEF@"
.Ds 0
.TA .5i 3i
.ta .5i 3i
/\(** Values */

typedef struct {
	Visual *visual;
	VisualID visualid;
	int screen;
	unsigned int depth;
	int class;
	unsigned long red_mask;
	unsigned long green_mask;
	unsigned long blue_mask;
	int colormap_size;
	int bits_per_rgb;
} XVisualInfo;
.De
.SH "SEE ALSO"
XFree(3X11)
.br
\fI\*(xL\fP
