#!/usr/bin/env python

# Qt tutorial 8.

import sys
from qt import *


class LCDRange(QVBox):
    def __init__(self,parent=None,name=None):
        QVBox.__init__(self,parent,name)

        lcd = QLCDNumber(2,self,'lcd')
        self.slider = QSlider(Qt.Horizontal,self,'slider')
        self.slider.setRange(0,99)
        self.slider.setValue(0)
        self.connect(self.slider,SIGNAL('valueChanged(int)'),lcd,SLOT('display(int)'))
        self.connect(self.slider,SIGNAL('valueChanged(int)'),self,PYSIGNAL('valueChanged(int)'))

        self.setFocusProxy(self.slider)

    def value(self):
        return self.slider.value()

    def setValue(self,value):
        self.slider.setValue(value)

    def setRange(self,minVal,maxVal):
        if minVal < 0 or maxVal > 99 or minVal > maxVal:
            raise ValueError, 'LCDRange.setRange(): invalid range'
        self.slider.setRange(minVal,maxVal)


class CannonField(QWidget):
    def __init__(self,parent=None,name=None):
        QWidget.__init__(self,parent,name)

        self.ang = 45
        self.setPalette(QPalette(QColor(250,250,200)))

    def angle(self):
        return self.ang

    def setAngle(self,degrees):
        if degrees < 5:
            degrees = 5
        if degrees > 70:
            degrees = 70
        if self.ang == degrees:
            return
        self.ang = degrees
        self.repaint()
        self.emit(PYSIGNAL('angleChanged(int)'),(self.ang,))

    def paintEvent(self,ev):
        p = QPainter(self)
        p.drawText(200,200,'Angle = %d' % (self.ang))

    def sizePolicy(self):
        return QSizePolicy(QSizePolicy.Expanding,QSizePolicy.Expanding)


class MyWidget(QWidget):
    def __init__(self,parent=None,name=None):
        QWidget.__init__(self,parent,name)

        quit = QPushButton('Quit',self,'quit')
        quit.setFont(QFont('Times',18,QFont.Bold))
        self.connect(quit,SIGNAL('clicked()'),qApp,SLOT('quit()'))

        self.angle = LCDRange(self,'angle')
        self.angle.setRange(5,70)

        self.cannonField = CannonField(self,'cannonField')

        self.connect(self.angle,PYSIGNAL('valueChanged(int)'),self.cannonField.setAngle)
        self.connect(self.cannonField,PYSIGNAL('angleChanged(int)'),self.angle.setValue)

        grid = QGridLayout(self,2,2,10)

        grid.addWidget(quit,0,0)
        grid.addWidget(self.angle,1,0,Qt.AlignTop)
        grid.addWidget(self.cannonField,1,1)
        grid.setColStretch(1,10)

        self.angle.setValue(60)
        self.angle.setFocus()


a = QApplication(sys.argv)

w = MyWidget()
w.setGeometry(100,100,500,355)
a.setMainWidget(w)
w.show()
a.exec_loop()
