.\"
.\" $XFree86: xc/doc/man/Xi/XQueryDv.man,v 1.2 2001/01/27 18:20:21 dawes Exp $
.\"
.\"
.\" Copyright ([\d,\s]*) by Hewlett-Packard Company, Ardent Computer, 
.\" 
.\" Permission to use, copy, modify, distribute, and sell this documentation 
.\" for any purpose and without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\" Ardent, and Hewlett-Packard make no representations about the 
.\" suitability for any purpose of the information in this document.  It is 
.\" provided \`\`as is'' without express or implied warranty.
.\" 
.\" $Xorg: XQueryDv.man,v 1.3 2000/08/17 19:41:56 cpqbld Exp $
.ds xL Programming with Xlib
.TH XQueryDeviceState __LIB_MAN_SUFFIX__ __xorgversion__ "X FUNCTIONS"
.SH NAME
XQueryDeviceState \- query the state of an extension input device.
.SH SYNTAX
.HP
int XQueryDeviceState\^(\^Display *\fIdisplay\fP\^, XDevice *\fIdevice\fP\^); 
.SH ARGUMENTS
.TP 12
.I display
Specifies the connection to the X server.
.TP 12
.I device
Specifies the device whose state is to be queried.
.SH DESCRIPTION
The
\fIXQueryDeviceState\fP
request queries the state of an input device.  The current state of 
keys and buttons (up or down), and valuators (current value) on the device 
is reported by this request.  Each key or button is represented by a bit
in the \fIXDeviceState\fP structure that is returned.  Valuators on the 
device report 0 if they are reporting relative information, and the
current value if they are reporting absolute information.
.LP
\fIXQueryDeviceState\fP
can generate a \fIBadDevice\fP error.
.SH STRUCTURES
The
\fIXDeviceState\fP
structure contains:
.LP
.nf
typedef struct {
	XID device_id;
	int num_classes;
	XInputClass *data;
} XDeviceState;
.fi
.LP
The
\fIXValuatorState\fP
structure contains:
.LP
.nf
typedef struct {
	unsigned char class;
	unsigned char length;
	unsigned char num_valuators;
	unsigned char mode;
	int *valuators;
} XValuatorState;
.fi
.LP
The \fIXKeyState\fP structure contains:
.LP
.nf
typedef struct {
	unsigned char class;
	unsigned char length;
	short         num_keys;
	char keys[32];
} XKeyState;
.fi
.LP
The \fIXButtonState\fP structure contains:
.LP
.nf
typedef struct {
	unsigned char class;
	unsigned char length;
	short         num_buttons;
	char buttons[32];
} XButtonState;
.fi
.SH DIAGNOSTICS
.TP 12
\fIBadDevice\fP
An invalid device was specified.  The specified device does not exist or has 
not been opened by this client via \fIXOpenInputDevice\fP.  This error may
also occur if some other client has caused the specified device to become
the X keyboard or X pointer device via the \fIXChangeKeyboardDevice\fP or
\fIXChangePointerDevice\fP requests.
.SH "SEE ALSO"
.br
\fI\*(xL\fP
