'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbGetNamedGeometry 3Xkb "Release 6.1" "X Version 11" "XKBLIB FUNCTION"
.SH NAME
XkbGetNamedGeometry \- Loads a keyboard geometry description from this database 
by name
.SH SYNTAX
.B Status XkbGetNamedGeometry
(
.I dpy,
.I xkb,
.I name 
)
.br
      Display * \fIdpy\fP\^;
.br
      XkbDescPtr \fIxkb\fP\^;
.br
      Atom \fIname\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to the X server
.TP
.I \- xkb
keyboard description into which the geometry should be loaded
.TP
.I \- name
name of the geometry to be loaded
.SH DESCRIPTION
.LP
It is also possible to load a keyboard geometry by name. The X server maintains 
a database 
of keyboard components (see below).

.I XkbGetNamedGeometry 
can return BadName if the name cannot be found.

The X server maintains a database of keyboard components, identified by 
component type. 
The database contains all the information necessary to build a complete keyboard 
description for a particular device, as well as to assemble partial 
descriptions. Table 1 identifies the component types and the type of information 
they contain.

.TS
c s s
l l l
l l l
l lw(2i) lw(2i).
Table 1 Server Database Keyboard Components
_
Component	Component Primary Contents	May also contain
Type
_
Keymap	T{
Complete keyboard description
.br 
Normally assembled using a complete component from each of the other types
T}
.sp
Keycodes	T{
Symbolic name for each key
.br
Minimum and maximum legal keycodes
T}	T{
Aliases for some keys
.br
Symbolic names for indicators
.br
Description of indicators physically present
T}
.sp
Types	Key types	T{
Real modifier bindings and symbolic names for some virtual modifiers
T}
.sp
Compatibility	T{
Rules used to assign actions to keysyms
T}	T{
Maps for some indicators
.br
Real modifier bindings and symbolic names for some virtual modifiers
T}
.sp
Symbols	T{
Symbol mapping for keyboard keys
.br
Modifier mapping
.br
Symbolic names for groups
T}	T{
Explicit actions and behaviors for some keys
.br
Real modifier bindings and symbolic names for some virtual modifiers
T}
.sp
Geometry	Layout of the keyboard	T{
Aliases for some keys; overrides keycodes component aliases
.br
Symbolic names for some indicators
.br
Description of indicators physically present
T}
.TE

While a keymap is a database entry for a complete keyboard description, and 
therefore 
logically different from the individual component database entries, the rules 
for 
processing keymap entries are identical to those for the individual components. 
In the 
discussion that follows, the term component is used to refer to either 
individual 
components or a keymap.

There may be multiple entries for each of the component types. An entry may be 
either
.I complete 
or 
.I partial. 
Partial entries describe only a piece of the corresponding keyboard component 
and are 
designed to be combined with other entries of the same type to form a complete 
entry.

For example, a partial symbols map might describe the differences between a 
common ASCII 
keyboard and some national layout. Such a partial map is not useful on its own 
because it 
does not include those symbols that are the same on both the ASCII and national 
layouts 
(such as function keys). On the other hand, this partial map can be used to 
configure 
.I any 
ASCII keyboard to use a national layout.

When a keyboard description is built, the components are processed in the order 
in which 
they appear in Table 1; later definitions override earlier ones.
.SH DIAGNOSTICS
.TP 15
.B BadName
A font or color of the specified name does not exist.
