.\" Converted with mdoc2man 0.2
.\" from NiH: zip_name_locate.mdoc,v 1.8 2005/06/09 21:14:54 wiz Exp 
.\" $NiH: zip_name_locate.mdoc,v 1.8 2005/06/09 21:14:54 wiz Exp $
.\"
.\" zip_name_locate.mdoc \-- get index of file by name
.\" Copyright (C) 2003, 2005 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_NAME_LOCATE 3 "October 4, 2006" NiH
.SH "NAME"
zip_name_locate \- get index of file by name
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
int
zip_name_locate(struct zip *archive, const char *fname, int flags);
.SH "DESCRIPTION"
The
zip_name_locate
function returns the index of the file named
\fBfname\fR
in
\fBarchive.\fR
If
\fBarchive\fR
does not contain a file with that name, \-1 is returned.
The
.Fa flags
are specified by
.I or'ing
the following values, or 0 for none of them.
.RS
.TP 15
\fBZIP_FL_NOCASE\fR
Ignore case distinctions.
.TP 15
\fBZIP_FL_NODIR\fR
Ignore directory part of file name in archive.
.RE
.SH "RETURN VALUES"
zip_name_locate
returns the index of the file named
\fBfname\fR
or \-1, if
\fBarchive\fR
does not contain an entry of that name.
.SH "ERRORS"
The
zip_name_locate
function fails and sets the error information to
ZIP_ER_NOENT
if no entry of the name
\fBfname\fR
is found in the archive.
If one of the arguments is invalid, the error information is set to
ZIP_ER_INVAL.
.SH "SEE ALSO"
libzip(3),
zip_get_name(3)
.SH "AUTHORS"

Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at>
