/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.app.ActivityManager;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.Waiter;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Asserter {
    private final ActivityUtils activityUtils;
    private final Waiter waiter;

    public Asserter(ActivityUtils activityUtils, Waiter waiter) {
        this.activityUtils = activityUtils;
        this.waiter = waiter;
    }

    public void assertCurrentActivity(String message, String name) {
        this.waiter.waitForActivity(name);
        Assert.assertEquals((String)message, (String)name, (String)this.activityUtils.getCurrentActivity().getClass().getSimpleName());
    }

    public void assertCurrentActivity(String message, Class<? extends Activity> expectedClass) {
        this.waiter.waitForActivity(expectedClass.getSimpleName());
        Assert.assertEquals((String)message, (String)expectedClass.getName(), (String)this.activityUtils.getCurrentActivity().getClass().getName());
    }

    public void assertCurrentActivity(String message, String name, boolean isNewInstance) {
        this.assertCurrentActivity(message, name);
        this.assertCurrentActivity(message, this.activityUtils.getCurrentActivity().getClass(), isNewInstance);
    }

    public void assertCurrentActivity(String message, Class<? extends Activity> expectedClass, boolean isNewInstance) {
        boolean found = false;
        this.assertCurrentActivity(message, expectedClass);
        Activity activity = this.activityUtils.getCurrentActivity(false);
        for (int i = 0; i < this.activityUtils.getAllOpenedActivities().size() - 1; ++i) {
            String instanceString = this.activityUtils.getAllOpenedActivities().get(i).toString();
            if (!instanceString.equals(activity.toString())) continue;
            found = true;
        }
        Assert.assertNotSame((String)(message + ", isNewInstance: actual and "), (Object)isNewInstance, (Object)found);
    }

    public void assertMemoryNotLow() {
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        ((ActivityManager)this.activityUtils.getCurrentActivity().getSystemService("activity")).getMemoryInfo(mi);
        Assert.assertFalse((String)("Low memory available: " + mi.availMem + " bytes"), (boolean)mi.lowMemory);
    }
}

