# REQUIRES: x86

# Test that the strtab size is included in the allocation even if the
# strtab itself is empty. To achieve this, we need a number of symbols N
# where alignTo(N*18, 512) < alignTo(N*18 + 4, 512), where the first
# positive N fulfilling that is 199.

# RUN: llvm-mc -triple=x86_64-windows-msvc %s -filetype=obj -o %t.obj
# RUN: lld-link -out:%t.exe -entry:main %t.obj -debug:dwarf

# If the size of the strtab isn't allocated for, llvm-readobj would
# output SymbolCount: 0 (and dumpbin.exe would error out with "invalid file
# or disk full, cannot seek to 0x1602").

# RUN: llvm-readobj --file-headers %t.exe | FileCheck %s
# CHECK: SymbolCount: 197

.global main
.text
main:
sym0:
sym1:
sym2:
sym3:
sym4:
sym5:
sym6:
sym7:
sym8:
sym9:
sym10:
sym11:
sym12:
sym13:
sym14:
sym15:
sym16:
sym17:
sym18:
sym19:
sym20:
sym21:
sym22:
sym23:
sym24:
sym25:
sym26:
sym27:
sym28:
sym29:
sym30:
sym31:
sym32:
sym33:
sym34:
sym35:
sym36:
sym37:
sym38:
sym39:
sym40:
sym41:
sym42:
sym43:
sym44:
sym45:
sym46:
sym47:
sym48:
sym49:
sym50:
sym51:
sym52:
sym53:
sym54:
sym55:
sym56:
sym57:
sym58:
sym59:
sym60:
sym61:
sym62:
sym63:
sym64:
sym65:
sym66:
sym67:
sym68:
sym69:
sym70:
sym71:
sym72:
sym73:
sym74:
sym75:
sym76:
sym77:
sym78:
sym79:
sym80:
sym81:
sym82:
sym83:
sym84:
sym85:
sym86:
sym87:
sym88:
sym89:
sym90:
sym91:
sym92:
sym93:
sym94:
sym95:
sym96:
sym97:
sym98:
sym99:
sym100:
sym101:
sym102:
sym103:
sym104:
sym105:
sym106:
sym107:
sym108:
sym109:
sym110:
sym111:
sym112:
sym113:
sym114:
sym115:
sym116:
sym117:
sym118:
sym119:
sym120:
sym121:
sym122:
sym123:
sym124:
sym125:
sym126:
sym127:
sym128:
sym129:
sym130:
sym131:
sym132:
sym133:
sym134:
sym135:
sym136:
sym137:
sym138:
sym139:
sym140:
sym141:
sym142:
sym143:
sym144:
sym145:
sym146:
sym147:
sym148:
sym149:
sym150:
sym151:
sym152:
sym153:
sym154:
sym155:
sym156:
sym157:
sym158:
sym159:
sym160:
sym161:
sym162:
sym163:
sym164:
sym165:
sym166:
sym167:
sym168:
sym169:
sym170:
sym171:
sym172:
sym173:
sym174:
sym175:
sym176:
sym177:
sym178:
sym179:
sym180:
sym181:
sym182:
sym183:
sym184:
sym185:
sym186:
sym187:
sym188:
sym189:
sym190:
sym191:
sym192:
sym193:
sym194:
  ret
