/* $XConsortium: maskbits.c,v 1.16 95/04/07 18:59:14 kaleb Exp $ */
/* Combined Purdue/PurduePlus patches, level 2.0, 1/17/89 */
/*

Copyright (c) 1987  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.


Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,

	All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

*/

#include "maskbits.h"
#include "servermd.h"

/*
these tables are used by several macros in the mfb code.

   the vax numbers everything left to right, so bit indices on the
screen match bit indices in longwords.  the pc-rt and Sun number
bits on the screen the way they would be written on paper,
(i.e. msb to the left), and so a bit index n on the screen is
bit index PPW-n in a longword

   see also maskbits.h
*/

#if (BITMAP_BIT_ORDER == MSBFirst)
/* NOTE:
the first element in starttab could be 0xffffffff.  making it 0
lets us deal with a full first word in the middle loop, rather
than having to do the multiple reads and masks that we'd
have to do if we thought it was partial.
*/
PixelType starttab[PPW+1] =
    {
	LONG2CHARS( 0x00000000 ),
#if PPW == 64
	LONG2CHARS( 0x7FFFFFFFFFFFFFFF ),
	LONG2CHARS( 0x3FFFFFFFFFFFFFFF ),
	LONG2CHARS( 0x1FFFFFFFFFFFFFFF ),
	LONG2CHARS( 0x0FFFFFFFFFFFFFFF ),
	LONG2CHARS( 0x07FFFFFFFFFFFFFF ),
	LONG2CHARS( 0x03FFFFFFFFFFFFFF ),
	LONG2CHARS( 0x01FFFFFFFFFFFFFF ),
	LONG2CHARS( 0x00FFFFFFFFFFFFFF ),
	LONG2CHARS( 0x007FFFFFFFFFFFFF ),
	LONG2CHARS( 0x003FFFFFFFFFFFFF ),
	LONG2CHARS( 0x001FFFFFFFFFFFFF ),
	LONG2CHARS( 0x000FFFFFFFFFFFFF ),
	LONG2CHARS( 0x0007FFFFFFFFFFFF ),
	LONG2CHARS( 0x0003FFFFFFFFFFFF ),
	LONG2CHARS( 0x0001FFFFFFFFFFFF ),
	LONG2CHARS( 0x0000FFFFFFFFFFFF ),
	LONG2CHARS( 0x00007FFFFFFFFFFF ),
	LONG2CHARS( 0x00003FFFFFFFFFFF ),
	LONG2CHARS( 0x00001FFFFFFFFFFF ),
	LONG2CHARS( 0x00000FFFFFFFFFFF ),
	LONG2CHARS( 0x000007FFFFFFFFFF ),
	LONG2CHARS( 0x000003FFFFFFFFFF ),
	LONG2CHARS( 0x000001FFFFFFFFFF ),
	LONG2CHARS( 0x000000FFFFFFFFFF ),
	LONG2CHARS( 0x0000007FFFFFFFFF ),
	LONG2CHARS( 0x0000003FFFFFFFFF ),
	LONG2CHARS( 0x0000001FFFFFFFFF ),
	LONG2CHARS( 0x0000000FFFFFFFFF ),
	LONG2CHARS( 0x00000007FFFFFFFF ),
	LONG2CHARS( 0x00000003FFFFFFFF ),
	LONG2CHARS( 0x00000001FFFFFFFF ),
	LONG2CHARS( 0x00000000FFFFFFFF ),
#endif /* PPW == 64 */
	LONG2CHARS( 0x7FFFFFFF ),
	LONG2CHARS( 0x3FFFFFFF ),
	LONG2CHARS( 0x1FFFFFFF ),
	LONG2CHARS( 0x0FFFFFFF ),
	LONG2CHARS( 0x07FFFFFF ),
	LONG2CHARS( 0x03FFFFFF ),
	LONG2CHARS( 0x01FFFFFF ),
	LONG2CHARS( 0x00FFFFFF ),
	LONG2CHARS( 0x007FFFFF ),
	LONG2CHARS( 0x003FFFFF ),
	LONG2CHARS( 0x001FFFFF ),
	LONG2CHARS( 0x000FFFFF ),
	LONG2CHARS( 0x0007FFFF ),
	LONG2CHARS( 0x0003FFFF ),
	LONG2CHARS( 0x0001FFFF ),
	LONG2CHARS( 0x0000FFFF ),
	LONG2CHARS( 0x00007FFF ),
	LONG2CHARS( 0x00003FFF ),
	LONG2CHARS( 0x00001FFF ),
	LONG2CHARS( 0x00000FFF ),
	LONG2CHARS( 0x000007FF ),
	LONG2CHARS( 0x000003FF ),
	LONG2CHARS( 0x000001FF ),
	LONG2CHARS( 0x000000FF ),
	LONG2CHARS( 0x0000007F ),
	LONG2CHARS( 0x0000003F ),
	LONG2CHARS( 0x0000001F ),
	LONG2CHARS( 0x0000000F ),
	LONG2CHARS( 0x00000007 ),
	LONG2CHARS( 0x00000003 ),
	LONG2CHARS( 0x00000001 ),
	LONG2CHARS( 0x00000000 )
    };

PixelType endtab[PPW+1] =
    {
#if PPW == 32
	LONG2CHARS( 0x00000000 ),
	LONG2CHARS( 0x80000000 ),
	LONG2CHARS( 0xC0000000 ),
	LONG2CHARS( 0xE0000000 ),
	LONG2CHARS( 0xF0000000 ),
	LONG2CHARS( 0xF8000000 ),
	LONG2CHARS( 0xFC000000 ),
	LONG2CHARS( 0xFE000000 ),
	LONG2CHARS( 0xFF000000 ),
	LONG2CHARS( 0xFF800000 ),
	LONG2CHARS( 0xFFC00000 ),
	LONG2CHARS( 0xFFE00000 ),
	LONG2CHARS( 0xFFF00000 ),
	LONG2CHARS( 0xFFF80000 ),
	LONG2CHARS( 0xFFFC0000 ),
	LONG2CHARS( 0xFFFE0000 ),
	LONG2CHARS( 0xFFFF0000 ),
	LONG2CHARS( 0xFFFF8000 ),
	LONG2CHARS( 0xFFFFC000 ),
	LONG2CHARS( 0xFFFFE000 ),
	LONG2CHARS( 0xFFFFF000 ),
	LONG2CHARS( 0xFFFFF800 ),
	LONG2CHARS( 0xFFFFFC00 ),
	LONG2CHARS( 0xFFFFFE00 ),
	LONG2CHARS( 0xFFFFFF00 ),
	LONG2CHARS( 0xFFFFFF80 ),
	LONG2CHARS( 0xFFFFFFC0 ),
	LONG2CHARS( 0xFFFFFFE0 ),
	LONG2CHARS( 0xFFFFFFF0 ),
	LONG2CHARS( 0xFFFFFFF8 ),
	LONG2CHARS( 0xFFFFFFFC ),
	LONG2CHARS( 0xFFFFFFFE ),
	LONG2CHARS( 0xFFFFFFFF )
#else /* PPW */
	LONG2CHARS( 0x0000000000000000 ),
	LONG2CHARS( 0x8000000000000000 ),
	LONG2CHARS( 0xC000000000000000 ),
	LONG2CHARS( 0xE000000000000000 ),
	LONG2CHARS( 0xF000000000000000 ),
	LONG2CHARS( 0xF800000000000000 ),
	LONG2CHARS( 0xFC00000000000000 ),
	LONG2CHARS( 0xFE00000000000000 ),
	LONG2CHARS( 0xFF00000000000000 ),
	LONG2CHARS( 0xFF80000000000000 ),
	LONG2CHARS( 0xFFC0000000000000 ),
	LONG2CHARS( 0xFFE0000000000000 ),
	LONG2CHARS( 0xFFF0000000000000 ),
	LONG2CHARS( 0xFFF8000000000000 ),
	LONG2CHARS( 0xFFFC000000000000 ),
	LONG2CHARS( 0xFFFE000000000000 ),
	LONG2CHARS( 0xFFFF000000000000 ),
	LONG2CHARS( 0xFFFF800000000000 ),
	LONG2CHARS( 0xFFFFC00000000000 ),
	LONG2CHARS( 0xFFFFE00000000000 ),
	LONG2CHARS( 0xFFFFF00000000000 ),
	LONG2CHARS( 0xFFFFF80000000000 ),
	LONG2CHARS( 0xFFFFFC0000000000 ),
	LONG2CHARS( 0xFFFFFE0000000000 ),
	LONG2CHARS( 0xFFFFFF0000000000 ),
	LONG2CHARS( 0xFFFFFF8000000000 ),
	LONG2CHARS( 0xFFFFFFC000000000 ),
	LONG2CHARS( 0xFFFFFFE000000000 ),
	LONG2CHARS( 0xFFFFFFF000000000 ),
	LONG2CHARS( 0xFFFFFFF800000000 ),
	LONG2CHARS( 0xFFFFFFFC00000000 ),
	LONG2CHARS( 0xFFFFFFFE00000000 ),
	LONG2CHARS( 0xFFFFFFFF00000000 ),
	LONG2CHARS( 0xFFFFFFFF80000000 ),
	LONG2CHARS( 0xFFFFFFFFC0000000 ),
	LONG2CHARS( 0xFFFFFFFFE0000000 ),
	LONG2CHARS( 0xFFFFFFFFF0000000 ),
	LONG2CHARS( 0xFFFFFFFFF8000000 ),
	LONG2CHARS( 0xFFFFFFFFFC000000 ),
	LONG2CHARS( 0xFFFFFFFFFE000000 ),
	LONG2CHARS( 0xFFFFFFFFFF000000 ),
	LONG2CHARS( 0xFFFFFFFFFF800000 ),
	LONG2CHARS( 0xFFFFFFFFFFC00000 ),
	LONG2CHARS( 0xFFFFFFFFFFE00000 ),
	LONG2CHARS( 0xFFFFFFFFFFF00000 ),
	LONG2CHARS( 0xFFFFFFFFFFF80000 ),
	LONG2CHARS( 0xFFFFFFFFFFFC0000 ),
	LONG2CHARS( 0xFFFFFFFFFFFE0000 ),
	LONG2CHARS( 0xFFFFFFFFFFFF0000 ),
	LONG2CHARS( 0xFFFFFFFFFFFF8000 ),
	LONG2CHARS( 0xFFFFFFFFFFFFC000 ),
	LONG2CHARS( 0xFFFFFFFFFFFFE000 ),
	LONG2CHARS( 0xFFFFFFFFFFFFF000 ),
	LONG2CHARS( 0xFFFFFFFFFFFFF800 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFC00 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFE00 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFF00 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFF80 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFFC0 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFFE0 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFFF0 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFFF8 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFFFC ),
	LONG2CHARS( 0xFFFFFFFFFFFFFFFE ),
	LONG2CHARS( 0xFFFFFFFFFFFFFFFF )
#endif /* PPW */
    };

#if NEED_OLD_MFB_MASKS
/* a hack, for now, since the entries for 0 need to be all
   1 bits, not all zeros.
   this means the code DOES NOT WORK for segments of length
   0 (which is only a problem in the horizontal line code.)
*/
PixelType startpartial[33] =
    {
	LONG2CHARS( 0xFFFFFFFF ),
	LONG2CHARS( 0x7FFFFFFF ),
	LONG2CHARS( 0x3FFFFFFF ),
	LONG2CHARS( 0x1FFFFFFF ),
	LONG2CHARS( 0x0FFFFFFF ),
	LONG2CHARS( 0x07FFFFFF ),
	LONG2CHARS( 0x03FFFFFF ),
	LONG2CHARS( 0x01FFFFFF ),
	LONG2CHARS( 0x00FFFFFF ),
	LONG2CHARS( 0x007FFFFF ),
	LONG2CHARS( 0x003FFFFF ),
	LONG2CHARS( 0x001FFFFF ),
	LONG2CHARS( 0x000FFFFF ),
	LONG2CHARS( 0x0007FFFF ),
	LONG2CHARS( 0x0003FFFF ),
	LONG2CHARS( 0x0001FFFF ),
	LONG2CHARS( 0x0000FFFF ),
	LONG2CHARS( 0x00007FFF ),
	LONG2CHARS( 0x00003FFF ),
	LONG2CHARS( 0x00001FFF ),
	LONG2CHARS( 0x00000FFF ),
	LONG2CHARS( 0x000007FF ),
	LONG2CHARS( 0x000003FF ),
	LONG2CHARS( 0x000001FF ),
	LONG2CHARS( 0x000000FF ),
	LONG2CHARS( 0x0000007F ),
	LONG2CHARS( 0x0000003F ),
	LONG2CHARS( 0x0000001F ),
	LONG2CHARS( 0x0000000F ),
	LONG2CHARS( 0x00000007 ),
	LONG2CHARS( 0x00000003 ),
	LONG2CHARS( 0x00000001 ),
	LONG2CHARS( 0x00000000 )
    };

PixelType endpartial[33] =
    {
	LONG2CHARS( 0xFFFFFFFF ),
	LONG2CHARS( 0x80000000 ),
	LONG2CHARS( 0xC0000000 ),
	LONG2CHARS( 0xE0000000 ),
	LONG2CHARS( 0xF0000000 ),
	LONG2CHARS( 0xF8000000 ),
	LONG2CHARS( 0xFC000000 ),
	LONG2CHARS( 0xFE000000 ),
	LONG2CHARS( 0xFF000000 ),
	LONG2CHARS( 0xFF800000 ),
	LONG2CHARS( 0xFFC00000 ),
	LONG2CHARS( 0xFFE00000 ),
	LONG2CHARS( 0xFFF00000 ),
	LONG2CHARS( 0xFFF80000 ),
	LONG2CHARS( 0xFFFC0000 ),
	LONG2CHARS( 0xFFFE0000 ),
	LONG2CHARS( 0xFFFF0000 ),
	LONG2CHARS( 0xFFFF8000 ),
	LONG2CHARS( 0xFFFFC000 ),
	LONG2CHARS( 0xFFFFE000 ),
	LONG2CHARS( 0xFFFFF000 ),
	LONG2CHARS( 0xFFFFF800 ),
	LONG2CHARS( 0xFFFFFC00 ),
	LONG2CHARS( 0xFFFFFE00 ),
	LONG2CHARS( 0xFFFFFF00 ),
	LONG2CHARS( 0xFFFFFF80 ),
	LONG2CHARS( 0xFFFFFFC0 ),
	LONG2CHARS( 0xFFFFFFE0 ),
	LONG2CHARS( 0xFFFFFFF0 ),
	LONG2CHARS( 0xFFFFFFF8 ),
	LONG2CHARS( 0xFFFFFFFC ),
	LONG2CHARS( 0xFFFFFFFE ),
	LONG2CHARS( 0xFFFFFFFF )
    };
#endif /* NEED_OLD_MFB_MASKS */

#if PPW == 32
PixelType partmasks[PPW][PPW] = {
     {LONG2CHARS( 0xFFFFFFFF ), LONG2CHARS( 0x80000000 ), LONG2CHARS( 0xC0000000 ), LONG2CHARS( 0xE0000000 ),
      LONG2CHARS( 0xF0000000 ), LONG2CHARS( 0xF8000000 ), LONG2CHARS( 0xFC000000 ), LONG2CHARS( 0xFE000000 ),
      LONG2CHARS( 0xFF000000 ), LONG2CHARS( 0xFF800000 ), LONG2CHARS( 0xFFC00000 ), LONG2CHARS( 0xFFE00000 ),
      LONG2CHARS( 0xFFF00000 ), LONG2CHARS( 0xFFF80000 ), LONG2CHARS( 0xFFFC0000 ), LONG2CHARS( 0xFFFE0000 ),
      LONG2CHARS( 0xFFFF0000 ), LONG2CHARS( 0xFFFF8000 ), LONG2CHARS( 0xFFFFC000 ), LONG2CHARS( 0xFFFFE000 ),
      LONG2CHARS( 0xFFFFF000 ), LONG2CHARS( 0xFFFFF800 ), LONG2CHARS( 0xFFFFFC00 ), LONG2CHARS( 0xFFFFFE00 ),
      LONG2CHARS( 0xFFFFFF00 ), LONG2CHARS( 0xFFFFFF80 ), LONG2CHARS( 0xFFFFFFC0 ), LONG2CHARS( 0xFFFFFFE0 ),
      LONG2CHARS( 0xFFFFFFF0 ), LONG2CHARS( 0xFFFFFFF8 ), LONG2CHARS( 0xFFFFFFFC ), LONG2CHARS( 0xFFFFFFFE )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x40000000 ), LONG2CHARS( 0x60000000 ), LONG2CHARS( 0x70000000 ),
      LONG2CHARS( 0x78000000 ), LONG2CHARS( 0x7C000000 ), LONG2CHARS( 0x7E000000 ), LONG2CHARS( 0x7F000000 ),
      LONG2CHARS( 0x7F800000 ), LONG2CHARS( 0x7FC00000 ), LONG2CHARS( 0x7FE00000 ), LONG2CHARS( 0x7FF00000 ),
      LONG2CHARS( 0x7FF80000 ), LONG2CHARS( 0x7FFC0000 ), LONG2CHARS( 0x7FFE0000 ), LONG2CHARS( 0x7FFF0000 ),
      LONG2CHARS( 0x7FFF8000 ), LONG2CHARS( 0x7FFFC000 ), LONG2CHARS( 0x7FFFE000 ), LONG2CHARS( 0x7FFFF000 ),
      LONG2CHARS( 0x7FFFF800 ), LONG2CHARS( 0x7FFFFC00 ), LONG2CHARS( 0x7FFFFE00 ), LONG2CHARS( 0x7FFFFF00 ),
      LONG2CHARS( 0x7FFFFF80 ), LONG2CHARS( 0x7FFFFFC0 ), LONG2CHARS( 0x7FFFFFE0 ), LONG2CHARS( 0x7FFFFFF0 ),
      LONG2CHARS( 0x7FFFFFF8 ), LONG2CHARS( 0x7FFFFFFC ), LONG2CHARS( 0x7FFFFFFE ), LONG2CHARS( 0x7FFFFFFF )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x20000000 ), LONG2CHARS( 0x30000000 ), LONG2CHARS( 0x38000000 ),
      LONG2CHARS( 0x3C000000 ), LONG2CHARS( 0x3E000000 ), LONG2CHARS( 0x3F000000 ), LONG2CHARS( 0x3F800000 ),
      LONG2CHARS( 0x3FC00000 ), LONG2CHARS( 0x3FE00000 ), LONG2CHARS( 0x3FF00000 ), LONG2CHARS( 0x3FF80000 ),
      LONG2CHARS( 0x3FFC0000 ), LONG2CHARS( 0x3FFE0000 ), LONG2CHARS( 0x3FFF0000 ), LONG2CHARS( 0x3FFF8000 ),
      LONG2CHARS( 0x3FFFC000 ), LONG2CHARS( 0x3FFFE000 ), LONG2CHARS( 0x3FFFF000 ), LONG2CHARS( 0x3FFFF800 ),
      LONG2CHARS( 0x3FFFFC00 ), LONG2CHARS( 0x3FFFFE00 ), LONG2CHARS( 0x3FFFFF00 ), LONG2CHARS( 0x3FFFFF80 ),
      LONG2CHARS( 0x3FFFFFC0 ), LONG2CHARS( 0x3FFFFFE0 ), LONG2CHARS( 0x3FFFFFF0 ), LONG2CHARS( 0x3FFFFFF8 ),
      LONG2CHARS( 0x3FFFFFFC ), LONG2CHARS( 0x3FFFFFFE ), LONG2CHARS( 0x3FFFFFFF ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x10000000 ), LONG2CHARS( 0x18000000 ), LONG2CHARS( 0x1C000000 ),
      LONG2CHARS( 0x1E000000 ), LONG2CHARS( 0x1F000000 ), LONG2CHARS( 0x1F800000 ), LONG2CHARS( 0x1FC00000 ),
      LONG2CHARS( 0x1FE00000 ), LONG2CHARS( 0x1FF00000 ), LONG2CHARS( 0x1FF80000 ), LONG2CHARS( 0x1FFC0000 ),
      LONG2CHARS( 0x1FFE0000 ), LONG2CHARS( 0x1FFF0000 ), LONG2CHARS( 0x1FFF8000 ), LONG2CHARS( 0x1FFFC000 ),
      LONG2CHARS( 0x1FFFE000 ), LONG2CHARS( 0x1FFFF000 ), LONG2CHARS( 0x1FFFF800 ), LONG2CHARS( 0x1FFFFC00 ),
      LONG2CHARS( 0x1FFFFE00 ), LONG2CHARS( 0x1FFFFF00 ), LONG2CHARS( 0x1FFFFF80 ), LONG2CHARS( 0x1FFFFFC0 ),
      LONG2CHARS( 0x1FFFFFE0 ), LONG2CHARS( 0x1FFFFFF0 ), LONG2CHARS( 0x1FFFFFF8 ), LONG2CHARS( 0x1FFFFFFC ),
      LONG2CHARS( 0x1FFFFFFE ), LONG2CHARS( 0x1FFFFFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x08000000 ), LONG2CHARS( 0x0C000000 ), LONG2CHARS( 0x0E000000 ),
      LONG2CHARS( 0x0F000000 ), LONG2CHARS( 0x0F800000 ), LONG2CHARS( 0x0FC00000 ), LONG2CHARS( 0x0FE00000 ),
      LONG2CHARS( 0x0FF00000 ), LONG2CHARS( 0x0FF80000 ), LONG2CHARS( 0x0FFC0000 ), LONG2CHARS( 0x0FFE0000 ),
      LONG2CHARS( 0x0FFF0000 ), LONG2CHARS( 0x0FFF8000 ), LONG2CHARS( 0x0FFFC000 ), LONG2CHARS( 0x0FFFE000 ),
      LONG2CHARS( 0x0FFFF000 ), LONG2CHARS( 0x0FFFF800 ), LONG2CHARS( 0x0FFFFC00 ), LONG2CHARS( 0x0FFFFE00 ),
      LONG2CHARS( 0x0FFFFF00 ), LONG2CHARS( 0x0FFFFF80 ), LONG2CHARS( 0x0FFFFFC0 ), LONG2CHARS( 0x0FFFFFE0 ),
      LONG2CHARS( 0x0FFFFFF0 ), LONG2CHARS( 0x0FFFFFF8 ), LONG2CHARS( 0x0FFFFFFC ), LONG2CHARS( 0x0FFFFFFE ),
      LONG2CHARS( 0x0FFFFFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x04000000 ), LONG2CHARS( 0x06000000 ), LONG2CHARS( 0x07000000 ),
      LONG2CHARS( 0x07800000 ), LONG2CHARS( 0x07C00000 ), LONG2CHARS( 0x07E00000 ), LONG2CHARS( 0x07F00000 ),
      LONG2CHARS( 0x07F80000 ), LONG2CHARS( 0x07FC0000 ), LONG2CHARS( 0x07FE0000 ), LONG2CHARS( 0x07FF0000 ),
      LONG2CHARS( 0x07FF8000 ), LONG2CHARS( 0x07FFC000 ), LONG2CHARS( 0x07FFE000 ), LONG2CHARS( 0x07FFF000 ),
      LONG2CHARS( 0x07FFF800 ), LONG2CHARS( 0x07FFFC00 ), LONG2CHARS( 0x07FFFE00 ), LONG2CHARS( 0x07FFFF00 ),
      LONG2CHARS( 0x07FFFF80 ), LONG2CHARS( 0x07FFFFC0 ), LONG2CHARS( 0x07FFFFE0 ), LONG2CHARS( 0x07FFFFF0 ),
      LONG2CHARS( 0x07FFFFF8 ), LONG2CHARS( 0x07FFFFFC ), LONG2CHARS( 0x07FFFFFE ), LONG2CHARS( 0x07FFFFFF ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x02000000 ), LONG2CHARS( 0x03000000 ), LONG2CHARS( 0x03800000 ),
      LONG2CHARS( 0x03C00000 ), LONG2CHARS( 0x03E00000 ), LONG2CHARS( 0x03F00000 ), LONG2CHARS( 0x03F80000 ),
      LONG2CHARS( 0x03FC0000 ), LONG2CHARS( 0x03FE0000 ), LONG2CHARS( 0x03FF0000 ), LONG2CHARS( 0x03FF8000 ),
      LONG2CHARS( 0x03FFC000 ), LONG2CHARS( 0x03FFE000 ), LONG2CHARS( 0x03FFF000 ), LONG2CHARS( 0x03FFF800 ),
      LONG2CHARS( 0x03FFFC00 ), LONG2CHARS( 0x03FFFE00 ), LONG2CHARS( 0x03FFFF00 ), LONG2CHARS( 0x03FFFF80 ),
      LONG2CHARS( 0x03FFFFC0 ), LONG2CHARS( 0x03FFFFE0 ), LONG2CHARS( 0x03FFFFF0 ), LONG2CHARS( 0x03FFFFF8 ),
      LONG2CHARS( 0x03FFFFFC ), LONG2CHARS( 0x03FFFFFE ), LONG2CHARS( 0x03FFFFFF ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x01000000 ), LONG2CHARS( 0x01800000 ), LONG2CHARS( 0x01C00000 ),
      LONG2CHARS( 0x01E00000 ), LONG2CHARS( 0x01F00000 ), LONG2CHARS( 0x01F80000 ), LONG2CHARS( 0x01FC0000 ),
      LONG2CHARS( 0x01FE0000 ), LONG2CHARS( 0x01FF0000 ), LONG2CHARS( 0x01FF8000 ), LONG2CHARS( 0x01FFC000 ),
      LONG2CHARS( 0x01FFE000 ), LONG2CHARS( 0x01FFF000 ), LONG2CHARS( 0x01FFF800 ), LONG2CHARS( 0x01FFFC00 ),
      LONG2CHARS( 0x01FFFE00 ), LONG2CHARS( 0x01FFFF00 ), LONG2CHARS( 0x01FFFF80 ), LONG2CHARS( 0x01FFFFC0 ),
      LONG2CHARS( 0x01FFFFE0 ), LONG2CHARS( 0x01FFFFF0 ), LONG2CHARS( 0x01FFFFF8 ), LONG2CHARS( 0x01FFFFFC ),
      LONG2CHARS( 0x01FFFFFE ), LONG2CHARS( 0x01FFFFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00800000 ), LONG2CHARS( 0x00C00000 ), LONG2CHARS( 0x00E00000 ),
      LONG2CHARS( 0x00F00000 ), LONG2CHARS( 0x00F80000 ), LONG2CHARS( 0x00FC0000 ), LONG2CHARS( 0x00FE0000 ),
      LONG2CHARS( 0x00FF0000 ), LONG2CHARS( 0x00FF8000 ), LONG2CHARS( 0x00FFC000 ), LONG2CHARS( 0x00FFE000 ),
      LONG2CHARS( 0x00FFF000 ), LONG2CHARS( 0x00FFF800 ), LONG2CHARS( 0x00FFFC00 ), LONG2CHARS( 0x00FFFE00 ),
      LONG2CHARS( 0x00FFFF00 ), LONG2CHARS( 0x00FFFF80 ), LONG2CHARS( 0x00FFFFC0 ), LONG2CHARS( 0x00FFFFE0 ),
      LONG2CHARS( 0x00FFFFF0 ), LONG2CHARS( 0x00FFFFF8 ), LONG2CHARS( 0x00FFFFFC ), LONG2CHARS( 0x00FFFFFE ),
      LONG2CHARS( 0x00FFFFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00400000 ), LONG2CHARS( 0x00600000 ), LONG2CHARS( 0x00700000 ),
      LONG2CHARS( 0x00780000 ), LONG2CHARS( 0x007C0000 ), LONG2CHARS( 0x007E0000 ), LONG2CHARS( 0x007F0000 ),
      LONG2CHARS( 0x007F8000 ), LONG2CHARS( 0x007FC000 ), LONG2CHARS( 0x007FE000 ), LONG2CHARS( 0x007FF000 ),
      LONG2CHARS( 0x007FF800 ), LONG2CHARS( 0x007FFC00 ), LONG2CHARS( 0x007FFE00 ), LONG2CHARS( 0x007FFF00 ),
      LONG2CHARS( 0x007FFF80 ), LONG2CHARS( 0x007FFFC0 ), LONG2CHARS( 0x007FFFE0 ), LONG2CHARS( 0x007FFFF0 ),
      LONG2CHARS( 0x007FFFF8 ), LONG2CHARS( 0x007FFFFC ), LONG2CHARS( 0x007FFFFE ), LONG2CHARS( 0x007FFFFF ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00200000 ), LONG2CHARS( 0x00300000 ), LONG2CHARS( 0x00380000 ),
      LONG2CHARS( 0x003C0000 ), LONG2CHARS( 0x003E0000 ), LONG2CHARS( 0x003F0000 ), LONG2CHARS( 0x003F8000 ),
      LONG2CHARS( 0x003FC000 ), LONG2CHARS( 0x003FE000 ), LONG2CHARS( 0x003FF000 ), LONG2CHARS( 0x003FF800 ),
      LONG2CHARS( 0x003FFC00 ), LONG2CHARS( 0x003FFE00 ), LONG2CHARS( 0x003FFF00 ), LONG2CHARS( 0x003FFF80 ),
      LONG2CHARS( 0x003FFFC0 ), LONG2CHARS( 0x003FFFE0 ), LONG2CHARS( 0x003FFFF0 ), LONG2CHARS( 0x003FFFF8 ),
      LONG2CHARS( 0x003FFFFC ), LONG2CHARS( 0x003FFFFE ), LONG2CHARS( 0x003FFFFF ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00100000 ), LONG2CHARS( 0x00180000 ), LONG2CHARS( 0x001C0000 ),
      LONG2CHARS( 0x001E0000 ), LONG2CHARS( 0x001F0000 ), LONG2CHARS( 0x001F8000 ), LONG2CHARS( 0x001FC000 ),
      LONG2CHARS( 0x001FE000 ), LONG2CHARS( 0x001FF000 ), LONG2CHARS( 0x001FF800 ), LONG2CHARS( 0x001FFC00 ),
      LONG2CHARS( 0x001FFE00 ), LONG2CHARS( 0x001FFF00 ), LONG2CHARS( 0x001FFF80 ), LONG2CHARS( 0x001FFFC0 ),
      LONG2CHARS( 0x001FFFE0 ), LONG2CHARS( 0x001FFFF0 ), LONG2CHARS( 0x001FFFF8 ), LONG2CHARS( 0x001FFFFC ),
      LONG2CHARS( 0x001FFFFE ), LONG2CHARS( 0x001FFFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00080000 ), LONG2CHARS( 0x000C0000 ), LONG2CHARS( 0x000E0000 ),
      LONG2CHARS( 0x000F0000 ), LONG2CHARS( 0x000F8000 ), LONG2CHARS( 0x000FC000 ), LONG2CHARS( 0x000FE000 ),
      LONG2CHARS( 0x000FF000 ), LONG2CHARS( 0x000FF800 ), LONG2CHARS( 0x000FFC00 ), LONG2CHARS( 0x000FFE00 ),
      LONG2CHARS( 0x000FFF00 ), LONG2CHARS( 0x000FFF80 ), LONG2CHARS( 0x000FFFC0 ), LONG2CHARS( 0x000FFFE0 ),
      LONG2CHARS( 0x000FFFF0 ), LONG2CHARS( 0x000FFFF8 ), LONG2CHARS( 0x000FFFFC ), LONG2CHARS( 0x000FFFFE ),
      LONG2CHARS( 0x000FFFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00040000 ), LONG2CHARS( 0x00060000 ), LONG2CHARS( 0x00070000 ),
      LONG2CHARS( 0x00078000 ), LONG2CHARS( 0x0007C000 ), LONG2CHARS( 0x0007E000 ), LONG2CHARS( 0x0007F000 ),
      LONG2CHARS( 0x0007F800 ), LONG2CHARS( 0x0007FC00 ), LONG2CHARS( 0x0007FE00 ), LONG2CHARS( 0x0007FF00 ),
      LONG2CHARS( 0x0007FF80 ), LONG2CHARS( 0x0007FFC0 ), LONG2CHARS( 0x0007FFE0 ), LONG2CHARS( 0x0007FFF0 ),
      LONG2CHARS( 0x0007FFF8 ), LONG2CHARS( 0x0007FFFC ), LONG2CHARS( 0x0007FFFE ), LONG2CHARS( 0x0007FFFF ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00020000 ), LONG2CHARS( 0x00030000 ), LONG2CHARS( 0x00038000 ),
      LONG2CHARS( 0x0003C000 ), LONG2CHARS( 0x0003E000 ), LONG2CHARS( 0x0003F000 ), LONG2CHARS( 0x0003F800 ),
      LONG2CHARS( 0x0003FC00 ), LONG2CHARS( 0x0003FE00 ), LONG2CHARS( 0x0003FF00 ), LONG2CHARS( 0x0003FF80 ),
      LONG2CHARS( 0x0003FFC0 ), LONG2CHARS( 0x0003FFE0 ), LONG2CHARS( 0x0003FFF0 ), LONG2CHARS( 0x0003FFF8 ),
      LONG2CHARS( 0x0003FFFC ), LONG2CHARS( 0x0003FFFE ), LONG2CHARS( 0x0003FFFF ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00010000 ), LONG2CHARS( 0x00018000 ), LONG2CHARS( 0x0001C000 ),
      LONG2CHARS( 0x0001E000 ), LONG2CHARS( 0x0001F000 ), LONG2CHARS( 0x0001F800 ), LONG2CHARS( 0x0001FC00 ),
      LONG2CHARS( 0x0001FE00 ), LONG2CHARS( 0x0001FF00 ), LONG2CHARS( 0x0001FF80 ), LONG2CHARS( 0x0001FFC0 ),
      LONG2CHARS( 0x0001FFE0 ), LONG2CHARS( 0x0001FFF0 ), LONG2CHARS( 0x0001FFF8 ), LONG2CHARS( 0x0001FFFC ),
      LONG2CHARS( 0x0001FFFE ), LONG2CHARS( 0x0001FFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00008000 ), LONG2CHARS( 0x0000C000 ), LONG2CHARS( 0x0000E000 ),
      LONG2CHARS( 0x0000F000 ), LONG2CHARS( 0x0000F800 ), LONG2CHARS( 0x0000FC00 ), LONG2CHARS( 0x0000FE00 ),
      LONG2CHARS( 0x0000FF00 ), LONG2CHARS( 0x0000FF80 ), LONG2CHARS( 0x0000FFC0 ), LONG2CHARS( 0x0000FFE0 ),
      LONG2CHARS( 0x0000FFF0 ), LONG2CHARS( 0x0000FFF8 ), LONG2CHARS( 0x0000FFFC ), LONG2CHARS( 0x0000FFFE ),
      LONG2CHARS( 0x0000FFFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00004000 ), LONG2CHARS( 0x00006000 ), LONG2CHARS( 0x00007000 ),
      LONG2CHARS( 0x00007800 ), LONG2CHARS( 0x00007C00 ), LONG2CHARS( 0x00007E00 ), LONG2CHARS( 0x00007F00 ),
      LONG2CHARS( 0x00007F80 ), LONG2CHARS( 0x00007FC0 ), LONG2CHARS( 0x00007FE0 ), LONG2CHARS( 0x00007FF0 ),
      LONG2CHARS( 0x00007FF8 ), LONG2CHARS( 0x00007FFC ), LONG2CHARS( 0x00007FFE ), LONG2CHARS( 0x00007FFF ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00002000 ), LONG2CHARS( 0x00003000 ), LONG2CHARS( 0x00003800 ),
      LONG2CHARS( 0x00003C00 ), LONG2CHARS( 0x00003E00 ), LONG2CHARS( 0x00003F00 ), LONG2CHARS( 0x00003F80 ),
      LONG2CHARS( 0x00003FC0 ), LONG2CHARS( 0x00003FE0 ), LONG2CHARS( 0x00003FF0 ), LONG2CHARS( 0x00003FF8 ),
      LONG2CHARS( 0x00003FFC ), LONG2CHARS( 0x00003FFE ), LONG2CHARS( 0x00003FFF ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00001000 ), LONG2CHARS( 0x00001800 ), LONG2CHARS( 0x00001C00 ),
      LONG2CHARS( 0x00001E00 ), LONG2CHARS( 0x00001F00 ), LONG2CHARS( 0x00001F80 ), LONG2CHARS( 0x00001FC0 ),
      LONG2CHARS( 0x00001FE0 ), LONG2CHARS( 0x00001FF0 ), LONG2CHARS( 0x00001FF8 ), LONG2CHARS( 0x00001FFC ),
      LONG2CHARS( 0x00001FFE ), LONG2CHARS( 0x00001FFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000800 ), LONG2CHARS( 0x00000C00 ), LONG2CHARS( 0x00000E00 ),
      LONG2CHARS( 0x00000F00 ), LONG2CHARS( 0x00000F80 ), LONG2CHARS( 0x00000FC0 ), LONG2CHARS( 0x00000FE0 ),
      LONG2CHARS( 0x00000FF0 ), LONG2CHARS( 0x00000FF8 ), LONG2CHARS( 0x00000FFC ), LONG2CHARS( 0x00000FFE ),
      LONG2CHARS( 0x00000FFF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000400 ), LONG2CHARS( 0x00000600 ), LONG2CHARS( 0x00000700 ),
      LONG2CHARS( 0x00000780 ), LONG2CHARS( 0x000007C0 ), LONG2CHARS( 0x000007E0 ), LONG2CHARS( 0x000007F0 ),
      LONG2CHARS( 0x000007F8 ), LONG2CHARS( 0x000007FC ), LONG2CHARS( 0x000007FE ), LONG2CHARS( 0x000007FF ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000200 ), LONG2CHARS( 0x00000300 ), LONG2CHARS( 0x00000380 ),
      LONG2CHARS( 0x000003C0 ), LONG2CHARS( 0x000003E0 ), LONG2CHARS( 0x000003F0 ), LONG2CHARS( 0x000003F8 ),
      LONG2CHARS( 0x000003FC ), LONG2CHARS( 0x000003FE ), LONG2CHARS( 0x000003FF ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000100 ), LONG2CHARS( 0x00000180 ), LONG2CHARS( 0x000001C0 ),
      LONG2CHARS( 0x000001E0 ), LONG2CHARS( 0x000001F0 ), LONG2CHARS( 0x000001F8 ), LONG2CHARS( 0x000001FC ),
      LONG2CHARS( 0x000001FE ), LONG2CHARS( 0x000001FF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000080 ), LONG2CHARS( 0x000000C0 ), LONG2CHARS( 0x000000E0 ),
      LONG2CHARS( 0x000000F0 ), LONG2CHARS( 0x000000F8 ), LONG2CHARS( 0x000000FC ), LONG2CHARS( 0x000000FE ),
      LONG2CHARS( 0x000000FF ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000040 ), LONG2CHARS( 0x00000060 ), LONG2CHARS( 0x00000070 ),
      LONG2CHARS( 0x00000078 ), LONG2CHARS( 0x0000007C ), LONG2CHARS( 0x0000007E ), LONG2CHARS( 0x0000007F ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000020 ), LONG2CHARS( 0x00000030 ), LONG2CHARS( 0x00000038 ),
      LONG2CHARS( 0x0000003C ), LONG2CHARS( 0x0000003E ), LONG2CHARS( 0x0000003F ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000010 ), LONG2CHARS( 0x00000018 ), LONG2CHARS( 0x0000001C ),
      LONG2CHARS( 0x0000001E ), LONG2CHARS( 0x0000001F ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000008 ), LONG2CHARS( 0x0000000C ), LONG2CHARS( 0x0000000E ),
      LONG2CHARS( 0x0000000F ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000004 ), LONG2CHARS( 0x00000006 ), LONG2CHARS( 0x00000007 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000002 ), LONG2CHARS( 0x00000003 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000001 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
};
#else /* PPW == 64 */
unsigned long partmasks[PPW][PPW] = {
	{
		LONG2CHARS( 0xFFFFFFFFFFFFFFFF ),
		LONG2CHARS( 0x8000000000000000 ),
		LONG2CHARS( 0xC000000000000000 ),
		LONG2CHARS( 0xE000000000000000 ),
		LONG2CHARS( 0xF000000000000000 ),
		LONG2CHARS( 0xF800000000000000 ),
		LONG2CHARS( 0xFC00000000000000 ),
		LONG2CHARS( 0xFE00000000000000 ),
		LONG2CHARS( 0xFF00000000000000 ),
		LONG2CHARS( 0xFF80000000000000 ),
		LONG2CHARS( 0xFFC0000000000000 ),
		LONG2CHARS( 0xFFE0000000000000 ),
		LONG2CHARS( 0xFFF0000000000000 ),
		LONG2CHARS( 0xFFF8000000000000 ),
		LONG2CHARS( 0xFFFC000000000000 ),
		LONG2CHARS( 0xFFFE000000000000 ),
		LONG2CHARS( 0xFFFF000000000000 ),
		LONG2CHARS( 0xFFFF800000000000 ),
		LONG2CHARS( 0xFFFFC00000000000 ),
		LONG2CHARS( 0xFFFFE00000000000 ),
		LONG2CHARS( 0xFFFFF00000000000 ),
		LONG2CHARS( 0xFFFFF80000000000 ),
		LONG2CHARS( 0xFFFFFC0000000000 ),
		LONG2CHARS( 0xFFFFFE0000000000 ),
		LONG2CHARS( 0xFFFFFF0000000000 ),
		LONG2CHARS( 0xFFFFFF8000000000 ),
		LONG2CHARS( 0xFFFFFFC000000000 ),
		LONG2CHARS( 0xFFFFFFE000000000 ),
		LONG2CHARS( 0xFFFFFFF000000000 ),
		LONG2CHARS( 0xFFFFFFF800000000 ),
		LONG2CHARS( 0xFFFFFFFC00000000 ),
		LONG2CHARS( 0xFFFFFFFE00000000 ),
		LONG2CHARS( 0xFFFFFFFF00000000 ),
		LONG2CHARS( 0xFFFFFFFF80000000 ),
		LONG2CHARS( 0xFFFFFFFFC0000000 ),
		LONG2CHARS( 0xFFFFFFFFE0000000 ),
		LONG2CHARS( 0xFFFFFFFFF0000000 ),
		LONG2CHARS( 0xFFFFFFFFF8000000 ),
		LONG2CHARS( 0xFFFFFFFFFC000000 ),
		LONG2CHARS( 0xFFFFFFFFFE000000 ),
		LONG2CHARS( 0xFFFFFFFFFF000000 ),
		LONG2CHARS( 0xFFFFFFFFFF800000 ),
		LONG2CHARS( 0xFFFFFFFFFFC00000 ),
		LONG2CHARS( 0xFFFFFFFFFFE00000 ),
		LONG2CHARS( 0xFFFFFFFFFFF00000 ),
		LONG2CHARS( 0xFFFFFFFFFFF80000 ),
		LONG2CHARS( 0xFFFFFFFFFFFC0000 ),
		LONG2CHARS( 0xFFFFFFFFFFFE0000 ),
		LONG2CHARS( 0xFFFFFFFFFFFF0000 ),
		LONG2CHARS( 0xFFFFFFFFFFFF8000 ),
		LONG2CHARS( 0xFFFFFFFFFFFFC000 ),
		LONG2CHARS( 0xFFFFFFFFFFFFE000 ),
		LONG2CHARS( 0xFFFFFFFFFFFFF000 ),
		LONG2CHARS( 0xFFFFFFFFFFFFF800 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFC00 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFE00 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFF00 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFF80 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFFC0 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFFE0 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFFF0 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFFF8 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFFFC ),
		LONG2CHARS( 0xFFFFFFFFFFFFFFFE ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x4000000000000000 ),
		LONG2CHARS( 0x6000000000000000 ),
		LONG2CHARS( 0x7000000000000000 ),
		LONG2CHARS( 0x7800000000000000 ),
		LONG2CHARS( 0x7C00000000000000 ),
		LONG2CHARS( 0x7E00000000000000 ),
		LONG2CHARS( 0x7F00000000000000 ),
		LONG2CHARS( 0x7F80000000000000 ),
		LONG2CHARS( 0x7FC0000000000000 ),
		LONG2CHARS( 0x7FE0000000000000 ),
		LONG2CHARS( 0x7FF0000000000000 ),
		LONG2CHARS( 0x7FF8000000000000 ),
		LONG2CHARS( 0x7FFC000000000000 ),
		LONG2CHARS( 0x7FFE000000000000 ),
		LONG2CHARS( 0x7FFF000000000000 ),
		LONG2CHARS( 0x7FFF800000000000 ),
		LONG2CHARS( 0x7FFFC00000000000 ),
		LONG2CHARS( 0x7FFFE00000000000 ),
		LONG2CHARS( 0x7FFFF00000000000 ),
		LONG2CHARS( 0x7FFFF80000000000 ),
		LONG2CHARS( 0x7FFFFC0000000000 ),
		LONG2CHARS( 0x7FFFFE0000000000 ),
		LONG2CHARS( 0x7FFFFF0000000000 ),
		LONG2CHARS( 0x7FFFFF8000000000 ),
		LONG2CHARS( 0x7FFFFFC000000000 ),
		LONG2CHARS( 0x7FFFFFE000000000 ),
		LONG2CHARS( 0x7FFFFFF000000000 ),
		LONG2CHARS( 0x7FFFFFF800000000 ),
		LONG2CHARS( 0x7FFFFFFC00000000 ),
		LONG2CHARS( 0x7FFFFFFE00000000 ),
		LONG2CHARS( 0x7FFFFFFF00000000 ),
		LONG2CHARS( 0x7FFFFFFF80000000 ),
		LONG2CHARS( 0x7FFFFFFFC0000000 ),
		LONG2CHARS( 0x7FFFFFFFE0000000 ),
		LONG2CHARS( 0x7FFFFFFFF0000000 ),
		LONG2CHARS( 0x7FFFFFFFF8000000 ),
		LONG2CHARS( 0x7FFFFFFFFC000000 ),
		LONG2CHARS( 0x7FFFFFFFFE000000 ),
		LONG2CHARS( 0x7FFFFFFFFF000000 ),
		LONG2CHARS( 0x7FFFFFFFFF800000 ),
		LONG2CHARS( 0x7FFFFFFFFFC00000 ),
		LONG2CHARS( 0x7FFFFFFFFFE00000 ),
		LONG2CHARS( 0x7FFFFFFFFFF00000 ),
		LONG2CHARS( 0x7FFFFFFFFFF80000 ),
		LONG2CHARS( 0x7FFFFFFFFFFC0000 ),
		LONG2CHARS( 0x7FFFFFFFFFFE0000 ),
		LONG2CHARS( 0x7FFFFFFFFFFF0000 ),
		LONG2CHARS( 0x7FFFFFFFFFFF8000 ),
		LONG2CHARS( 0x7FFFFFFFFFFFC000 ),
		LONG2CHARS( 0x7FFFFFFFFFFFE000 ),
		LONG2CHARS( 0x7FFFFFFFFFFFF000 ),
		LONG2CHARS( 0x7FFFFFFFFFFFF800 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFC00 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFE00 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFF00 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFF80 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFFFC ),
		LONG2CHARS( 0x7FFFFFFFFFFFFFFE ),
		LONG2CHARS( 0x7FFFFFFFFFFFFFFF ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x2000000000000000 ),
		LONG2CHARS( 0x3000000000000000 ),
		LONG2CHARS( 0x3800000000000000 ),
		LONG2CHARS( 0x3C00000000000000 ),
		LONG2CHARS( 0x3E00000000000000 ),
		LONG2CHARS( 0x3F00000000000000 ),
		LONG2CHARS( 0x3F80000000000000 ),
		LONG2CHARS( 0x3FC0000000000000 ),
		LONG2CHARS( 0x3FE0000000000000 ),
		LONG2CHARS( 0x3FF0000000000000 ),
		LONG2CHARS( 0x3FF8000000000000 ),
		LONG2CHARS( 0x3FFC000000000000 ),
		LONG2CHARS( 0x3FFE000000000000 ),
		LONG2CHARS( 0x3FFF000000000000 ),
		LONG2CHARS( 0x3FFF800000000000 ),
		LONG2CHARS( 0x3FFFC00000000000 ),
		LONG2CHARS( 0x3FFFE00000000000 ),
		LONG2CHARS( 0x3FFFF00000000000 ),
		LONG2CHARS( 0x3FFFF80000000000 ),
		LONG2CHARS( 0x3FFFFC0000000000 ),
		LONG2CHARS( 0x3FFFFE0000000000 ),
		LONG2CHARS( 0x3FFFFF0000000000 ),
		LONG2CHARS( 0x3FFFFF8000000000 ),
		LONG2CHARS( 0x3FFFFFC000000000 ),
		LONG2CHARS( 0x3FFFFFE000000000 ),
		LONG2CHARS( 0x3FFFFFF000000000 ),
		LONG2CHARS( 0x3FFFFFF800000000 ),
		LONG2CHARS( 0x3FFFFFFC00000000 ),
		LONG2CHARS( 0x3FFFFFFE00000000 ),
		LONG2CHARS( 0x3FFFFFFF00000000 ),
		LONG2CHARS( 0x3FFFFFFF80000000 ),
		LONG2CHARS( 0x3FFFFFFFC0000000 ),
		LONG2CHARS( 0x3FFFFFFFE0000000 ),
		LONG2CHARS( 0x3FFFFFFFF0000000 ),
		LONG2CHARS( 0x3FFFFFFFF8000000 ),
		LONG2CHARS( 0x3FFFFFFFFC000000 ),
		LONG2CHARS( 0x3FFFFFFFFE000000 ),
		LONG2CHARS( 0x3FFFFFFFFF000000 ),
		LONG2CHARS( 0x3FFFFFFFFF800000 ),
		LONG2CHARS( 0x3FFFFFFFFFC00000 ),
		LONG2CHARS( 0x3FFFFFFFFFE00000 ),
		LONG2CHARS( 0x3FFFFFFFFFF00000 ),
		LONG2CHARS( 0x3FFFFFFFFFF80000 ),
		LONG2CHARS( 0x3FFFFFFFFFFC0000 ),
		LONG2CHARS( 0x3FFFFFFFFFFE0000 ),
		LONG2CHARS( 0x3FFFFFFFFFFF0000 ),
		LONG2CHARS( 0x3FFFFFFFFFFF8000 ),
		LONG2CHARS( 0x3FFFFFFFFFFFC000 ),
		LONG2CHARS( 0x3FFFFFFFFFFFE000 ),
		LONG2CHARS( 0x3FFFFFFFFFFFF000 ),
		LONG2CHARS( 0x3FFFFFFFFFFFF800 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFC00 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFE00 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFF00 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFF80 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFFFC ),
		LONG2CHARS( 0x3FFFFFFFFFFFFFFE ),
		LONG2CHARS( 0x3FFFFFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x1000000000000000 ),
		LONG2CHARS( 0x1800000000000000 ),
		LONG2CHARS( 0x1C00000000000000 ),
		LONG2CHARS( 0x1E00000000000000 ),
		LONG2CHARS( 0x1F00000000000000 ),
		LONG2CHARS( 0x1F80000000000000 ),
		LONG2CHARS( 0x1FC0000000000000 ),
		LONG2CHARS( 0x1FE0000000000000 ),
		LONG2CHARS( 0x1FF0000000000000 ),
		LONG2CHARS( 0x1FF8000000000000 ),
		LONG2CHARS( 0x1FFC000000000000 ),
		LONG2CHARS( 0x1FFE000000000000 ),
		LONG2CHARS( 0x1FFF000000000000 ),
		LONG2CHARS( 0x1FFF800000000000 ),
		LONG2CHARS( 0x1FFFC00000000000 ),
		LONG2CHARS( 0x1FFFE00000000000 ),
		LONG2CHARS( 0x1FFFF00000000000 ),
		LONG2CHARS( 0x1FFFF80000000000 ),
		LONG2CHARS( 0x1FFFFC0000000000 ),
		LONG2CHARS( 0x1FFFFE0000000000 ),
		LONG2CHARS( 0x1FFFFF0000000000 ),
		LONG2CHARS( 0x1FFFFF8000000000 ),
		LONG2CHARS( 0x1FFFFFC000000000 ),
		LONG2CHARS( 0x1FFFFFE000000000 ),
		LONG2CHARS( 0x1FFFFFF000000000 ),
		LONG2CHARS( 0x1FFFFFF800000000 ),
		LONG2CHARS( 0x1FFFFFFC00000000 ),
		LONG2CHARS( 0x1FFFFFFE00000000 ),
		LONG2CHARS( 0x1FFFFFFF00000000 ),
		LONG2CHARS( 0x1FFFFFFF80000000 ),
		LONG2CHARS( 0x1FFFFFFFC0000000 ),
		LONG2CHARS( 0x1FFFFFFFE0000000 ),
		LONG2CHARS( 0x1FFFFFFFF0000000 ),
		LONG2CHARS( 0x1FFFFFFFF8000000 ),
		LONG2CHARS( 0x1FFFFFFFFC000000 ),
		LONG2CHARS( 0x1FFFFFFFFE000000 ),
		LONG2CHARS( 0x1FFFFFFFFF000000 ),
		LONG2CHARS( 0x1FFFFFFFFF800000 ),
		LONG2CHARS( 0x1FFFFFFFFFC00000 ),
		LONG2CHARS( 0x1FFFFFFFFFE00000 ),
		LONG2CHARS( 0x1FFFFFFFFFF00000 ),
		LONG2CHARS( 0x1FFFFFFFFFF80000 ),
		LONG2CHARS( 0x1FFFFFFFFFFC0000 ),
		LONG2CHARS( 0x1FFFFFFFFFFE0000 ),
		LONG2CHARS( 0x1FFFFFFFFFFF0000 ),
		LONG2CHARS( 0x1FFFFFFFFFFF8000 ),
		LONG2CHARS( 0x1FFFFFFFFFFFC000 ),
		LONG2CHARS( 0x1FFFFFFFFFFFE000 ),
		LONG2CHARS( 0x1FFFFFFFFFFFF000 ),
		LONG2CHARS( 0x1FFFFFFFFFFFF800 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFC00 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFE00 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFF00 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFF80 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFFFC ),
		LONG2CHARS( 0x1FFFFFFFFFFFFFFE ),
		LONG2CHARS( 0x1FFFFFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0800000000000000 ),
		LONG2CHARS( 0x0C00000000000000 ),
		LONG2CHARS( 0x0E00000000000000 ),
		LONG2CHARS( 0x0F00000000000000 ),
		LONG2CHARS( 0x0F80000000000000 ),
		LONG2CHARS( 0x0FC0000000000000 ),
		LONG2CHARS( 0x0FE0000000000000 ),
		LONG2CHARS( 0x0FF0000000000000 ),
		LONG2CHARS( 0x0FF8000000000000 ),
		LONG2CHARS( 0x0FFC000000000000 ),
		LONG2CHARS( 0x0FFE000000000000 ),
		LONG2CHARS( 0x0FFF000000000000 ),
		LONG2CHARS( 0x0FFF800000000000 ),
		LONG2CHARS( 0x0FFFC00000000000 ),
		LONG2CHARS( 0x0FFFE00000000000 ),
		LONG2CHARS( 0x0FFFF00000000000 ),
		LONG2CHARS( 0x0FFFF80000000000 ),
		LONG2CHARS( 0x0FFFFC0000000000 ),
		LONG2CHARS( 0x0FFFFE0000000000 ),
		LONG2CHARS( 0x0FFFFF0000000000 ),
		LONG2CHARS( 0x0FFFFF8000000000 ),
		LONG2CHARS( 0x0FFFFFC000000000 ),
		LONG2CHARS( 0x0FFFFFE000000000 ),
		LONG2CHARS( 0x0FFFFFF000000000 ),
		LONG2CHARS( 0x0FFFFFF800000000 ),
		LONG2CHARS( 0x0FFFFFFC00000000 ),
		LONG2CHARS( 0x0FFFFFFE00000000 ),
		LONG2CHARS( 0x0FFFFFFF00000000 ),
		LONG2CHARS( 0x0FFFFFFF80000000 ),
		LONG2CHARS( 0x0FFFFFFFC0000000 ),
		LONG2CHARS( 0x0FFFFFFFE0000000 ),
		LONG2CHARS( 0x0FFFFFFFF0000000 ),
		LONG2CHARS( 0x0FFFFFFFF8000000 ),
		LONG2CHARS( 0x0FFFFFFFFC000000 ),
		LONG2CHARS( 0x0FFFFFFFFE000000 ),
		LONG2CHARS( 0x0FFFFFFFFF000000 ),
		LONG2CHARS( 0x0FFFFFFFFF800000 ),
		LONG2CHARS( 0x0FFFFFFFFFC00000 ),
		LONG2CHARS( 0x0FFFFFFFFFE00000 ),
		LONG2CHARS( 0x0FFFFFFFFFF00000 ),
		LONG2CHARS( 0x0FFFFFFFFFF80000 ),
		LONG2CHARS( 0x0FFFFFFFFFFC0000 ),
		LONG2CHARS( 0x0FFFFFFFFFFE0000 ),
		LONG2CHARS( 0x0FFFFFFFFFFF0000 ),
		LONG2CHARS( 0x0FFFFFFFFFFF8000 ),
		LONG2CHARS( 0x0FFFFFFFFFFFC000 ),
		LONG2CHARS( 0x0FFFFFFFFFFFE000 ),
		LONG2CHARS( 0x0FFFFFFFFFFFF000 ),
		LONG2CHARS( 0x0FFFFFFFFFFFF800 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFC00 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFE00 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFF00 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFF80 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFFFC ),
		LONG2CHARS( 0x0FFFFFFFFFFFFFFE ),
		LONG2CHARS( 0x0FFFFFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0400000000000000 ),
		LONG2CHARS( 0x0600000000000000 ),
		LONG2CHARS( 0x0700000000000000 ),
		LONG2CHARS( 0x0780000000000000 ),
		LONG2CHARS( 0x07C0000000000000 ),
		LONG2CHARS( 0x07E0000000000000 ),
		LONG2CHARS( 0x07F0000000000000 ),
		LONG2CHARS( 0x07F8000000000000 ),
		LONG2CHARS( 0x07FC000000000000 ),
		LONG2CHARS( 0x07FE000000000000 ),
		LONG2CHARS( 0x07FF000000000000 ),
		LONG2CHARS( 0x07FF800000000000 ),
		LONG2CHARS( 0x07FFC00000000000 ),
		LONG2CHARS( 0x07FFE00000000000 ),
		LONG2CHARS( 0x07FFF00000000000 ),
		LONG2CHARS( 0x07FFF80000000000 ),
		LONG2CHARS( 0x07FFFC0000000000 ),
		LONG2CHARS( 0x07FFFE0000000000 ),
		LONG2CHARS( 0x07FFFF0000000000 ),
		LONG2CHARS( 0x07FFFF8000000000 ),
		LONG2CHARS( 0x07FFFFC000000000 ),
		LONG2CHARS( 0x07FFFFE000000000 ),
		LONG2CHARS( 0x07FFFFF000000000 ),
		LONG2CHARS( 0x07FFFFF800000000 ),
		LONG2CHARS( 0x07FFFFFC00000000 ),
		LONG2CHARS( 0x07FFFFFE00000000 ),
		LONG2CHARS( 0x07FFFFFF00000000 ),
		LONG2CHARS( 0x07FFFFFF80000000 ),
		LONG2CHARS( 0x07FFFFFFC0000000 ),
		LONG2CHARS( 0x07FFFFFFE0000000 ),
		LONG2CHARS( 0x07FFFFFFF0000000 ),
		LONG2CHARS( 0x07FFFFFFF8000000 ),
		LONG2CHARS( 0x07FFFFFFFC000000 ),
		LONG2CHARS( 0x07FFFFFFFE000000 ),
		LONG2CHARS( 0x07FFFFFFFF000000 ),
		LONG2CHARS( 0x07FFFFFFFF800000 ),
		LONG2CHARS( 0x07FFFFFFFFC00000 ),
		LONG2CHARS( 0x07FFFFFFFFE00000 ),
		LONG2CHARS( 0x07FFFFFFFFF00000 ),
		LONG2CHARS( 0x07FFFFFFFFF80000 ),
		LONG2CHARS( 0x07FFFFFFFFFC0000 ),
		LONG2CHARS( 0x07FFFFFFFFFE0000 ),
		LONG2CHARS( 0x07FFFFFFFFFF0000 ),
		LONG2CHARS( 0x07FFFFFFFFFF8000 ),
		LONG2CHARS( 0x07FFFFFFFFFFC000 ),
		LONG2CHARS( 0x07FFFFFFFFFFE000 ),
		LONG2CHARS( 0x07FFFFFFFFFFF000 ),
		LONG2CHARS( 0x07FFFFFFFFFFF800 ),
		LONG2CHARS( 0x07FFFFFFFFFFFC00 ),
		LONG2CHARS( 0x07FFFFFFFFFFFE00 ),
		LONG2CHARS( 0x07FFFFFFFFFFFF00 ),
		LONG2CHARS( 0x07FFFFFFFFFFFF80 ),
		LONG2CHARS( 0x07FFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x07FFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x07FFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x07FFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x07FFFFFFFFFFFFFC ),
		LONG2CHARS( 0x07FFFFFFFFFFFFFE ),
		LONG2CHARS( 0x07FFFFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0200000000000000 ),
		LONG2CHARS( 0x0300000000000000 ),
		LONG2CHARS( 0x0380000000000000 ),
		LONG2CHARS( 0x03C0000000000000 ),
		LONG2CHARS( 0x03E0000000000000 ),
		LONG2CHARS( 0x03F0000000000000 ),
		LONG2CHARS( 0x03F8000000000000 ),
		LONG2CHARS( 0x03FC000000000000 ),
		LONG2CHARS( 0x03FE000000000000 ),
		LONG2CHARS( 0x03FF000000000000 ),
		LONG2CHARS( 0x03FF800000000000 ),
		LONG2CHARS( 0x03FFC00000000000 ),
		LONG2CHARS( 0x03FFE00000000000 ),
		LONG2CHARS( 0x03FFF00000000000 ),
		LONG2CHARS( 0x03FFF80000000000 ),
		LONG2CHARS( 0x03FFFC0000000000 ),
		LONG2CHARS( 0x03FFFE0000000000 ),
		LONG2CHARS( 0x03FFFF0000000000 ),
		LONG2CHARS( 0x03FFFF8000000000 ),
		LONG2CHARS( 0x03FFFFC000000000 ),
		LONG2CHARS( 0x03FFFFE000000000 ),
		LONG2CHARS( 0x03FFFFF000000000 ),
		LONG2CHARS( 0x03FFFFF800000000 ),
		LONG2CHARS( 0x03FFFFFC00000000 ),
		LONG2CHARS( 0x03FFFFFE00000000 ),
		LONG2CHARS( 0x03FFFFFF00000000 ),
		LONG2CHARS( 0x03FFFFFF80000000 ),
		LONG2CHARS( 0x03FFFFFFC0000000 ),
		LONG2CHARS( 0x03FFFFFFE0000000 ),
		LONG2CHARS( 0x03FFFFFFF0000000 ),
		LONG2CHARS( 0x03FFFFFFF8000000 ),
		LONG2CHARS( 0x03FFFFFFFC000000 ),
		LONG2CHARS( 0x03FFFFFFFE000000 ),
		LONG2CHARS( 0x03FFFFFFFF000000 ),
		LONG2CHARS( 0x03FFFFFFFF800000 ),
		LONG2CHARS( 0x03FFFFFFFFC00000 ),
		LONG2CHARS( 0x03FFFFFFFFE00000 ),
		LONG2CHARS( 0x03FFFFFFFFF00000 ),
		LONG2CHARS( 0x03FFFFFFFFF80000 ),
		LONG2CHARS( 0x03FFFFFFFFFC0000 ),
		LONG2CHARS( 0x03FFFFFFFFFE0000 ),
		LONG2CHARS( 0x03FFFFFFFFFF0000 ),
		LONG2CHARS( 0x03FFFFFFFFFF8000 ),
		LONG2CHARS( 0x03FFFFFFFFFFC000 ),
		LONG2CHARS( 0x03FFFFFFFFFFE000 ),
		LONG2CHARS( 0x03FFFFFFFFFFF000 ),
		LONG2CHARS( 0x03FFFFFFFFFFF800 ),
		LONG2CHARS( 0x03FFFFFFFFFFFC00 ),
		LONG2CHARS( 0x03FFFFFFFFFFFE00 ),
		LONG2CHARS( 0x03FFFFFFFFFFFF00 ),
		LONG2CHARS( 0x03FFFFFFFFFFFF80 ),
		LONG2CHARS( 0x03FFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x03FFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x03FFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x03FFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x03FFFFFFFFFFFFFC ),
		LONG2CHARS( 0x03FFFFFFFFFFFFFE ),
		LONG2CHARS( 0x03FFFFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0100000000000000 ),
		LONG2CHARS( 0x0180000000000000 ),
		LONG2CHARS( 0x01C0000000000000 ),
		LONG2CHARS( 0x01E0000000000000 ),
		LONG2CHARS( 0x01F0000000000000 ),
		LONG2CHARS( 0x01F8000000000000 ),
		LONG2CHARS( 0x01FC000000000000 ),
		LONG2CHARS( 0x01FE000000000000 ),
		LONG2CHARS( 0x01FF000000000000 ),
		LONG2CHARS( 0x01FF800000000000 ),
		LONG2CHARS( 0x01FFC00000000000 ),
		LONG2CHARS( 0x01FFE00000000000 ),
		LONG2CHARS( 0x01FFF00000000000 ),
		LONG2CHARS( 0x01FFF80000000000 ),
		LONG2CHARS( 0x01FFFC0000000000 ),
		LONG2CHARS( 0x01FFFE0000000000 ),
		LONG2CHARS( 0x01FFFF0000000000 ),
		LONG2CHARS( 0x01FFFF8000000000 ),
		LONG2CHARS( 0x01FFFFC000000000 ),
		LONG2CHARS( 0x01FFFFE000000000 ),
		LONG2CHARS( 0x01FFFFF000000000 ),
		LONG2CHARS( 0x01FFFFF800000000 ),
		LONG2CHARS( 0x01FFFFFC00000000 ),
		LONG2CHARS( 0x01FFFFFE00000000 ),
		LONG2CHARS( 0x01FFFFFF00000000 ),
		LONG2CHARS( 0x01FFFFFF80000000 ),
		LONG2CHARS( 0x01FFFFFFC0000000 ),
		LONG2CHARS( 0x01FFFFFFE0000000 ),
		LONG2CHARS( 0x01FFFFFFF0000000 ),
		LONG2CHARS( 0x01FFFFFFF8000000 ),
		LONG2CHARS( 0x01FFFFFFFC000000 ),
		LONG2CHARS( 0x01FFFFFFFE000000 ),
		LONG2CHARS( 0x01FFFFFFFF000000 ),
		LONG2CHARS( 0x01FFFFFFFF800000 ),
		LONG2CHARS( 0x01FFFFFFFFC00000 ),
		LONG2CHARS( 0x01FFFFFFFFE00000 ),
		LONG2CHARS( 0x01FFFFFFFFF00000 ),
		LONG2CHARS( 0x01FFFFFFFFF80000 ),
		LONG2CHARS( 0x01FFFFFFFFFC0000 ),
		LONG2CHARS( 0x01FFFFFFFFFE0000 ),
		LONG2CHARS( 0x01FFFFFFFFFF0000 ),
		LONG2CHARS( 0x01FFFFFFFFFF8000 ),
		LONG2CHARS( 0x01FFFFFFFFFFC000 ),
		LONG2CHARS( 0x01FFFFFFFFFFE000 ),
		LONG2CHARS( 0x01FFFFFFFFFFF000 ),
		LONG2CHARS( 0x01FFFFFFFFFFF800 ),
		LONG2CHARS( 0x01FFFFFFFFFFFC00 ),
		LONG2CHARS( 0x01FFFFFFFFFFFE00 ),
		LONG2CHARS( 0x01FFFFFFFFFFFF00 ),
		LONG2CHARS( 0x01FFFFFFFFFFFF80 ),
		LONG2CHARS( 0x01FFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x01FFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x01FFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x01FFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x01FFFFFFFFFFFFFC ),
		LONG2CHARS( 0x01FFFFFFFFFFFFFE ),
		LONG2CHARS( 0x01FFFFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0080000000000000 ),
		LONG2CHARS( 0x00C0000000000000 ),
		LONG2CHARS( 0x00E0000000000000 ),
		LONG2CHARS( 0x00F0000000000000 ),
		LONG2CHARS( 0x00F8000000000000 ),
		LONG2CHARS( 0x00FC000000000000 ),
		LONG2CHARS( 0x00FE000000000000 ),
		LONG2CHARS( 0x00FF000000000000 ),
		LONG2CHARS( 0x00FF800000000000 ),
		LONG2CHARS( 0x00FFC00000000000 ),
		LONG2CHARS( 0x00FFE00000000000 ),
		LONG2CHARS( 0x00FFF00000000000 ),
		LONG2CHARS( 0x00FFF80000000000 ),
		LONG2CHARS( 0x00FFFC0000000000 ),
		LONG2CHARS( 0x00FFFE0000000000 ),
		LONG2CHARS( 0x00FFFF0000000000 ),
		LONG2CHARS( 0x00FFFF8000000000 ),
		LONG2CHARS( 0x00FFFFC000000000 ),
		LONG2CHARS( 0x00FFFFE000000000 ),
		LONG2CHARS( 0x00FFFFF000000000 ),
		LONG2CHARS( 0x00FFFFF800000000 ),
		LONG2CHARS( 0x00FFFFFC00000000 ),
		LONG2CHARS( 0x00FFFFFE00000000 ),
		LONG2CHARS( 0x00FFFFFF00000000 ),
		LONG2CHARS( 0x00FFFFFF80000000 ),
		LONG2CHARS( 0x00FFFFFFC0000000 ),
		LONG2CHARS( 0x00FFFFFFE0000000 ),
		LONG2CHARS( 0x00FFFFFFF0000000 ),
		LONG2CHARS( 0x00FFFFFFF8000000 ),
		LONG2CHARS( 0x00FFFFFFFC000000 ),
		LONG2CHARS( 0x00FFFFFFFE000000 ),
		LONG2CHARS( 0x00FFFFFFFF000000 ),
		LONG2CHARS( 0x00FFFFFFFF800000 ),
		LONG2CHARS( 0x00FFFFFFFFC00000 ),
		LONG2CHARS( 0x00FFFFFFFFE00000 ),
		LONG2CHARS( 0x00FFFFFFFFF00000 ),
		LONG2CHARS( 0x00FFFFFFFFF80000 ),
		LONG2CHARS( 0x00FFFFFFFFFC0000 ),
		LONG2CHARS( 0x00FFFFFFFFFE0000 ),
		LONG2CHARS( 0x00FFFFFFFFFF0000 ),
		LONG2CHARS( 0x00FFFFFFFFFF8000 ),
		LONG2CHARS( 0x00FFFFFFFFFFC000 ),
		LONG2CHARS( 0x00FFFFFFFFFFE000 ),
		LONG2CHARS( 0x00FFFFFFFFFFF000 ),
		LONG2CHARS( 0x00FFFFFFFFFFF800 ),
		LONG2CHARS( 0x00FFFFFFFFFFFC00 ),
		LONG2CHARS( 0x00FFFFFFFFFFFE00 ),
		LONG2CHARS( 0x00FFFFFFFFFFFF00 ),
		LONG2CHARS( 0x00FFFFFFFFFFFF80 ),
		LONG2CHARS( 0x00FFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x00FFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x00FFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x00FFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x00FFFFFFFFFFFFFC ),
		LONG2CHARS( 0x00FFFFFFFFFFFFFE ),
		LONG2CHARS( 0x00FFFFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0040000000000000 ),
		LONG2CHARS( 0x0060000000000000 ),
		LONG2CHARS( 0x0070000000000000 ),
		LONG2CHARS( 0x0078000000000000 ),
		LONG2CHARS( 0x007C000000000000 ),
		LONG2CHARS( 0x007E000000000000 ),
		LONG2CHARS( 0x007F000000000000 ),
		LONG2CHARS( 0x007F800000000000 ),
		LONG2CHARS( 0x007FC00000000000 ),
		LONG2CHARS( 0x007FE00000000000 ),
		LONG2CHARS( 0x007FF00000000000 ),
		LONG2CHARS( 0x007FF80000000000 ),
		LONG2CHARS( 0x007FFC0000000000 ),
		LONG2CHARS( 0x007FFE0000000000 ),
		LONG2CHARS( 0x007FFF0000000000 ),
		LONG2CHARS( 0x007FFF8000000000 ),
		LONG2CHARS( 0x007FFFC000000000 ),
		LONG2CHARS( 0x007FFFE000000000 ),
		LONG2CHARS( 0x007FFFF000000000 ),
		LONG2CHARS( 0x007FFFF800000000 ),
		LONG2CHARS( 0x007FFFFC00000000 ),
		LONG2CHARS( 0x007FFFFE00000000 ),
		LONG2CHARS( 0x007FFFFF00000000 ),
		LONG2CHARS( 0x007FFFFF80000000 ),
		LONG2CHARS( 0x007FFFFFC0000000 ),
		LONG2CHARS( 0x007FFFFFE0000000 ),
		LONG2CHARS( 0x007FFFFFF0000000 ),
		LONG2CHARS( 0x007FFFFFF8000000 ),
		LONG2CHARS( 0x007FFFFFFC000000 ),
		LONG2CHARS( 0x007FFFFFFE000000 ),
		LONG2CHARS( 0x007FFFFFFF000000 ),
		LONG2CHARS( 0x007FFFFFFF800000 ),
		LONG2CHARS( 0x007FFFFFFFC00000 ),
		LONG2CHARS( 0x007FFFFFFFE00000 ),
		LONG2CHARS( 0x007FFFFFFFF00000 ),
		LONG2CHARS( 0x007FFFFFFFF80000 ),
		LONG2CHARS( 0x007FFFFFFFFC0000 ),
		LONG2CHARS( 0x007FFFFFFFFE0000 ),
		LONG2CHARS( 0x007FFFFFFFFF0000 ),
		LONG2CHARS( 0x007FFFFFFFFF8000 ),
		LONG2CHARS( 0x007FFFFFFFFFC000 ),
		LONG2CHARS( 0x007FFFFFFFFFE000 ),
		LONG2CHARS( 0x007FFFFFFFFFF000 ),
		LONG2CHARS( 0x007FFFFFFFFFF800 ),
		LONG2CHARS( 0x007FFFFFFFFFFC00 ),
		LONG2CHARS( 0x007FFFFFFFFFFE00 ),
		LONG2CHARS( 0x007FFFFFFFFFFF00 ),
		LONG2CHARS( 0x007FFFFFFFFFFF80 ),
		LONG2CHARS( 0x007FFFFFFFFFFFC0 ),
		LONG2CHARS( 0x007FFFFFFFFFFFE0 ),
		LONG2CHARS( 0x007FFFFFFFFFFFF0 ),
		LONG2CHARS( 0x007FFFFFFFFFFFF8 ),
		LONG2CHARS( 0x007FFFFFFFFFFFFC ),
		LONG2CHARS( 0x007FFFFFFFFFFFFE ),
		LONG2CHARS( 0x007FFFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0020000000000000 ),
		LONG2CHARS( 0x0030000000000000 ),
		LONG2CHARS( 0x0038000000000000 ),
		LONG2CHARS( 0x003C000000000000 ),
		LONG2CHARS( 0x003E000000000000 ),
		LONG2CHARS( 0x003F000000000000 ),
		LONG2CHARS( 0x003F800000000000 ),
		LONG2CHARS( 0x003FC00000000000 ),
		LONG2CHARS( 0x003FE00000000000 ),
		LONG2CHARS( 0x003FF00000000000 ),
		LONG2CHARS( 0x003FF80000000000 ),
		LONG2CHARS( 0x003FFC0000000000 ),
		LONG2CHARS( 0x003FFE0000000000 ),
		LONG2CHARS( 0x003FFF0000000000 ),
		LONG2CHARS( 0x003FFF8000000000 ),
		LONG2CHARS( 0x003FFFC000000000 ),
		LONG2CHARS( 0x003FFFE000000000 ),
		LONG2CHARS( 0x003FFFF000000000 ),
		LONG2CHARS( 0x003FFFF800000000 ),
		LONG2CHARS( 0x003FFFFC00000000 ),
		LONG2CHARS( 0x003FFFFE00000000 ),
		LONG2CHARS( 0x003FFFFF00000000 ),
		LONG2CHARS( 0x003FFFFF80000000 ),
		LONG2CHARS( 0x003FFFFFC0000000 ),
		LONG2CHARS( 0x003FFFFFE0000000 ),
		LONG2CHARS( 0x003FFFFFF0000000 ),
		LONG2CHARS( 0x003FFFFFF8000000 ),
		LONG2CHARS( 0x003FFFFFFC000000 ),
		LONG2CHARS( 0x003FFFFFFE000000 ),
		LONG2CHARS( 0x003FFFFFFF000000 ),
		LONG2CHARS( 0x003FFFFFFF800000 ),
		LONG2CHARS( 0x003FFFFFFFC00000 ),
		LONG2CHARS( 0x003FFFFFFFE00000 ),
		LONG2CHARS( 0x003FFFFFFFF00000 ),
		LONG2CHARS( 0x003FFFFFFFF80000 ),
		LONG2CHARS( 0x003FFFFFFFFC0000 ),
		LONG2CHARS( 0x003FFFFFFFFE0000 ),
		LONG2CHARS( 0x003FFFFFFFFF0000 ),
		LONG2CHARS( 0x003FFFFFFFFF8000 ),
		LONG2CHARS( 0x003FFFFFFFFFC000 ),
		LONG2CHARS( 0x003FFFFFFFFFE000 ),
		LONG2CHARS( 0x003FFFFFFFFFF000 ),
		LONG2CHARS( 0x003FFFFFFFFFF800 ),
		LONG2CHARS( 0x003FFFFFFFFFFC00 ),
		LONG2CHARS( 0x003FFFFFFFFFFE00 ),
		LONG2CHARS( 0x003FFFFFFFFFFF00 ),
		LONG2CHARS( 0x003FFFFFFFFFFF80 ),
		LONG2CHARS( 0x003FFFFFFFFFFFC0 ),
		LONG2CHARS( 0x003FFFFFFFFFFFE0 ),
		LONG2CHARS( 0x003FFFFFFFFFFFF0 ),
		LONG2CHARS( 0x003FFFFFFFFFFFF8 ),
		LONG2CHARS( 0x003FFFFFFFFFFFFC ),
		LONG2CHARS( 0x003FFFFFFFFFFFFE ),
		LONG2CHARS( 0x003FFFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0010000000000000 ),
		LONG2CHARS( 0x0018000000000000 ),
		LONG2CHARS( 0x001C000000000000 ),
		LONG2CHARS( 0x001E000000000000 ),
		LONG2CHARS( 0x001F000000000000 ),
		LONG2CHARS( 0x001F800000000000 ),
		LONG2CHARS( 0x001FC00000000000 ),
		LONG2CHARS( 0x001FE00000000000 ),
		LONG2CHARS( 0x001FF00000000000 ),
		LONG2CHARS( 0x001FF80000000000 ),
		LONG2CHARS( 0x001FFC0000000000 ),
		LONG2CHARS( 0x001FFE0000000000 ),
		LONG2CHARS( 0x001FFF0000000000 ),
		LONG2CHARS( 0x001FFF8000000000 ),
		LONG2CHARS( 0x001FFFC000000000 ),
		LONG2CHARS( 0x001FFFE000000000 ),
		LONG2CHARS( 0x001FFFF000000000 ),
		LONG2CHARS( 0x001FFFF800000000 ),
		LONG2CHARS( 0x001FFFFC00000000 ),
		LONG2CHARS( 0x001FFFFE00000000 ),
		LONG2CHARS( 0x001FFFFF00000000 ),
		LONG2CHARS( 0x001FFFFF80000000 ),
		LONG2CHARS( 0x001FFFFFC0000000 ),
		LONG2CHARS( 0x001FFFFFE0000000 ),
		LONG2CHARS( 0x001FFFFFF0000000 ),
		LONG2CHARS( 0x001FFFFFF8000000 ),
		LONG2CHARS( 0x001FFFFFFC000000 ),
		LONG2CHARS( 0x001FFFFFFE000000 ),
		LONG2CHARS( 0x001FFFFFFF000000 ),
		LONG2CHARS( 0x001FFFFFFF800000 ),
		LONG2CHARS( 0x001FFFFFFFC00000 ),
		LONG2CHARS( 0x001FFFFFFFE00000 ),
		LONG2CHARS( 0x001FFFFFFFF00000 ),
		LONG2CHARS( 0x001FFFFFFFF80000 ),
		LONG2CHARS( 0x001FFFFFFFFC0000 ),
		LONG2CHARS( 0x001FFFFFFFFE0000 ),
		LONG2CHARS( 0x001FFFFFFFFF0000 ),
		LONG2CHARS( 0x001FFFFFFFFF8000 ),
		LONG2CHARS( 0x001FFFFFFFFFC000 ),
		LONG2CHARS( 0x001FFFFFFFFFE000 ),
		LONG2CHARS( 0x001FFFFFFFFFF000 ),
		LONG2CHARS( 0x001FFFFFFFFFF800 ),
		LONG2CHARS( 0x001FFFFFFFFFFC00 ),
		LONG2CHARS( 0x001FFFFFFFFFFE00 ),
		LONG2CHARS( 0x001FFFFFFFFFFF00 ),
		LONG2CHARS( 0x001FFFFFFFFFFF80 ),
		LONG2CHARS( 0x001FFFFFFFFFFFC0 ),
		LONG2CHARS( 0x001FFFFFFFFFFFE0 ),
		LONG2CHARS( 0x001FFFFFFFFFFFF0 ),
		LONG2CHARS( 0x001FFFFFFFFFFFF8 ),
		LONG2CHARS( 0x001FFFFFFFFFFFFC ),
		LONG2CHARS( 0x001FFFFFFFFFFFFE ),
		LONG2CHARS( 0x001FFFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0008000000000000 ),
		LONG2CHARS( 0x000C000000000000 ),
		LONG2CHARS( 0x000E000000000000 ),
		LONG2CHARS( 0x000F000000000000 ),
		LONG2CHARS( 0x000F800000000000 ),
		LONG2CHARS( 0x000FC00000000000 ),
		LONG2CHARS( 0x000FE00000000000 ),
		LONG2CHARS( 0x000FF00000000000 ),
		LONG2CHARS( 0x000FF80000000000 ),
		LONG2CHARS( 0x000FFC0000000000 ),
		LONG2CHARS( 0x000FFE0000000000 ),
		LONG2CHARS( 0x000FFF0000000000 ),
		LONG2CHARS( 0x000FFF8000000000 ),
		LONG2CHARS( 0x000FFFC000000000 ),
		LONG2CHARS( 0x000FFFE000000000 ),
		LONG2CHARS( 0x000FFFF000000000 ),
		LONG2CHARS( 0x000FFFF800000000 ),
		LONG2CHARS( 0x000FFFFC00000000 ),
		LONG2CHARS( 0x000FFFFE00000000 ),
		LONG2CHARS( 0x000FFFFF00000000 ),
		LONG2CHARS( 0x000FFFFF80000000 ),
		LONG2CHARS( 0x000FFFFFC0000000 ),
		LONG2CHARS( 0x000FFFFFE0000000 ),
		LONG2CHARS( 0x000FFFFFF0000000 ),
		LONG2CHARS( 0x000FFFFFF8000000 ),
		LONG2CHARS( 0x000FFFFFFC000000 ),
		LONG2CHARS( 0x000FFFFFFE000000 ),
		LONG2CHARS( 0x000FFFFFFF000000 ),
		LONG2CHARS( 0x000FFFFFFF800000 ),
		LONG2CHARS( 0x000FFFFFFFC00000 ),
		LONG2CHARS( 0x000FFFFFFFE00000 ),
		LONG2CHARS( 0x000FFFFFFFF00000 ),
		LONG2CHARS( 0x000FFFFFFFF80000 ),
		LONG2CHARS( 0x000FFFFFFFFC0000 ),
		LONG2CHARS( 0x000FFFFFFFFE0000 ),
		LONG2CHARS( 0x000FFFFFFFFF0000 ),
		LONG2CHARS( 0x000FFFFFFFFF8000 ),
		LONG2CHARS( 0x000FFFFFFFFFC000 ),
		LONG2CHARS( 0x000FFFFFFFFFE000 ),
		LONG2CHARS( 0x000FFFFFFFFFF000 ),
		LONG2CHARS( 0x000FFFFFFFFFF800 ),
		LONG2CHARS( 0x000FFFFFFFFFFC00 ),
		LONG2CHARS( 0x000FFFFFFFFFFE00 ),
		LONG2CHARS( 0x000FFFFFFFFFFF00 ),
		LONG2CHARS( 0x000FFFFFFFFFFF80 ),
		LONG2CHARS( 0x000FFFFFFFFFFFC0 ),
		LONG2CHARS( 0x000FFFFFFFFFFFE0 ),
		LONG2CHARS( 0x000FFFFFFFFFFFF0 ),
		LONG2CHARS( 0x000FFFFFFFFFFFF8 ),
		LONG2CHARS( 0x000FFFFFFFFFFFFC ),
		LONG2CHARS( 0x000FFFFFFFFFFFFE ),
		LONG2CHARS( 0x000FFFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0004000000000000 ),
		LONG2CHARS( 0x0006000000000000 ),
		LONG2CHARS( 0x0007000000000000 ),
		LONG2CHARS( 0x0007800000000000 ),
		LONG2CHARS( 0x0007C00000000000 ),
		LONG2CHARS( 0x0007E00000000000 ),
		LONG2CHARS( 0x0007F00000000000 ),
		LONG2CHARS( 0x0007F80000000000 ),
		LONG2CHARS( 0x0007FC0000000000 ),
		LONG2CHARS( 0x0007FE0000000000 ),
		LONG2CHARS( 0x0007FF0000000000 ),
		LONG2CHARS( 0x0007FF8000000000 ),
		LONG2CHARS( 0x0007FFC000000000 ),
		LONG2CHARS( 0x0007FFE000000000 ),
		LONG2CHARS( 0x0007FFF000000000 ),
		LONG2CHARS( 0x0007FFF800000000 ),
		LONG2CHARS( 0x0007FFFC00000000 ),
		LONG2CHARS( 0x0007FFFE00000000 ),
		LONG2CHARS( 0x0007FFFF00000000 ),
		LONG2CHARS( 0x0007FFFF80000000 ),
		LONG2CHARS( 0x0007FFFFC0000000 ),
		LONG2CHARS( 0x0007FFFFE0000000 ),
		LONG2CHARS( 0x0007FFFFF0000000 ),
		LONG2CHARS( 0x0007FFFFF8000000 ),
		LONG2CHARS( 0x0007FFFFFC000000 ),
		LONG2CHARS( 0x0007FFFFFE000000 ),
		LONG2CHARS( 0x0007FFFFFF000000 ),
		LONG2CHARS( 0x0007FFFFFF800000 ),
		LONG2CHARS( 0x0007FFFFFFC00000 ),
		LONG2CHARS( 0x0007FFFFFFE00000 ),
		LONG2CHARS( 0x0007FFFFFFF00000 ),
		LONG2CHARS( 0x0007FFFFFFF80000 ),
		LONG2CHARS( 0x0007FFFFFFFC0000 ),
		LONG2CHARS( 0x0007FFFFFFFE0000 ),
		LONG2CHARS( 0x0007FFFFFFFF0000 ),
		LONG2CHARS( 0x0007FFFFFFFF8000 ),
		LONG2CHARS( 0x0007FFFFFFFFC000 ),
		LONG2CHARS( 0x0007FFFFFFFFE000 ),
		LONG2CHARS( 0x0007FFFFFFFFF000 ),
		LONG2CHARS( 0x0007FFFFFFFFF800 ),
		LONG2CHARS( 0x0007FFFFFFFFFC00 ),
		LONG2CHARS( 0x0007FFFFFFFFFE00 ),
		LONG2CHARS( 0x0007FFFFFFFFFF00 ),
		LONG2CHARS( 0x0007FFFFFFFFFF80 ),
		LONG2CHARS( 0x0007FFFFFFFFFFC0 ),
		LONG2CHARS( 0x0007FFFFFFFFFFE0 ),
		LONG2CHARS( 0x0007FFFFFFFFFFF0 ),
		LONG2CHARS( 0x0007FFFFFFFFFFF8 ),
		LONG2CHARS( 0x0007FFFFFFFFFFFC ),
		LONG2CHARS( 0x0007FFFFFFFFFFFE ),
		LONG2CHARS( 0x0007FFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0002000000000000 ),
		LONG2CHARS( 0x0003000000000000 ),
		LONG2CHARS( 0x0003800000000000 ),
		LONG2CHARS( 0x0003C00000000000 ),
		LONG2CHARS( 0x0003E00000000000 ),
		LONG2CHARS( 0x0003F00000000000 ),
		LONG2CHARS( 0x0003F80000000000 ),
		LONG2CHARS( 0x0003FC0000000000 ),
		LONG2CHARS( 0x0003FE0000000000 ),
		LONG2CHARS( 0x0003FF0000000000 ),
		LONG2CHARS( 0x0003FF8000000000 ),
		LONG2CHARS( 0x0003FFC000000000 ),
		LONG2CHARS( 0x0003FFE000000000 ),
		LONG2CHARS( 0x0003FFF000000000 ),
		LONG2CHARS( 0x0003FFF800000000 ),
		LONG2CHARS( 0x0003FFFC00000000 ),
		LONG2CHARS( 0x0003FFFE00000000 ),
		LONG2CHARS( 0x0003FFFF00000000 ),
		LONG2CHARS( 0x0003FFFF80000000 ),
		LONG2CHARS( 0x0003FFFFC0000000 ),
		LONG2CHARS( 0x0003FFFFE0000000 ),
		LONG2CHARS( 0x0003FFFFF0000000 ),
		LONG2CHARS( 0x0003FFFFF8000000 ),
		LONG2CHARS( 0x0003FFFFFC000000 ),
		LONG2CHARS( 0x0003FFFFFE000000 ),
		LONG2CHARS( 0x0003FFFFFF000000 ),
		LONG2CHARS( 0x0003FFFFFF800000 ),
		LONG2CHARS( 0x0003FFFFFFC00000 ),
		LONG2CHARS( 0x0003FFFFFFE00000 ),
		LONG2CHARS( 0x0003FFFFFFF00000 ),
		LONG2CHARS( 0x0003FFFFFFF80000 ),
		LONG2CHARS( 0x0003FFFFFFFC0000 ),
		LONG2CHARS( 0x0003FFFFFFFE0000 ),
		LONG2CHARS( 0x0003FFFFFFFF0000 ),
		LONG2CHARS( 0x0003FFFFFFFF8000 ),
		LONG2CHARS( 0x0003FFFFFFFFC000 ),
		LONG2CHARS( 0x0003FFFFFFFFE000 ),
		LONG2CHARS( 0x0003FFFFFFFFF000 ),
		LONG2CHARS( 0x0003FFFFFFFFF800 ),
		LONG2CHARS( 0x0003FFFFFFFFFC00 ),
		LONG2CHARS( 0x0003FFFFFFFFFE00 ),
		LONG2CHARS( 0x0003FFFFFFFFFF00 ),
		LONG2CHARS( 0x0003FFFFFFFFFF80 ),
		LONG2CHARS( 0x0003FFFFFFFFFFC0 ),
		LONG2CHARS( 0x0003FFFFFFFFFFE0 ),
		LONG2CHARS( 0x0003FFFFFFFFFFF0 ),
		LONG2CHARS( 0x0003FFFFFFFFFFF8 ),
		LONG2CHARS( 0x0003FFFFFFFFFFFC ),
		LONG2CHARS( 0x0003FFFFFFFFFFFE ),
		LONG2CHARS( 0x0003FFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0001000000000000 ),
		LONG2CHARS( 0x0001800000000000 ),
		LONG2CHARS( 0x0001C00000000000 ),
		LONG2CHARS( 0x0001E00000000000 ),
		LONG2CHARS( 0x0001F00000000000 ),
		LONG2CHARS( 0x0001F80000000000 ),
		LONG2CHARS( 0x0001FC0000000000 ),
		LONG2CHARS( 0x0001FE0000000000 ),
		LONG2CHARS( 0x0001FF0000000000 ),
		LONG2CHARS( 0x0001FF8000000000 ),
		LONG2CHARS( 0x0001FFC000000000 ),
		LONG2CHARS( 0x0001FFE000000000 ),
		LONG2CHARS( 0x0001FFF000000000 ),
		LONG2CHARS( 0x0001FFF800000000 ),
		LONG2CHARS( 0x0001FFFC00000000 ),
		LONG2CHARS( 0x0001FFFE00000000 ),
		LONG2CHARS( 0x0001FFFF00000000 ),
		LONG2CHARS( 0x0001FFFF80000000 ),
		LONG2CHARS( 0x0001FFFFC0000000 ),
		LONG2CHARS( 0x0001FFFFE0000000 ),
		LONG2CHARS( 0x0001FFFFF0000000 ),
		LONG2CHARS( 0x0001FFFFF8000000 ),
		LONG2CHARS( 0x0001FFFFFC000000 ),
		LONG2CHARS( 0x0001FFFFFE000000 ),
		LONG2CHARS( 0x0001FFFFFF000000 ),
		LONG2CHARS( 0x0001FFFFFF800000 ),
		LONG2CHARS( 0x0001FFFFFFC00000 ),
		LONG2CHARS( 0x0001FFFFFFE00000 ),
		LONG2CHARS( 0x0001FFFFFFF00000 ),
		LONG2CHARS( 0x0001FFFFFFF80000 ),
		LONG2CHARS( 0x0001FFFFFFFC0000 ),
		LONG2CHARS( 0x0001FFFFFFFE0000 ),
		LONG2CHARS( 0x0001FFFFFFFF0000 ),
		LONG2CHARS( 0x0001FFFFFFFF8000 ),
		LONG2CHARS( 0x0001FFFFFFFFC000 ),
		LONG2CHARS( 0x0001FFFFFFFFE000 ),
		LONG2CHARS( 0x0001FFFFFFFFF000 ),
		LONG2CHARS( 0x0001FFFFFFFFF800 ),
		LONG2CHARS( 0x0001FFFFFFFFFC00 ),
		LONG2CHARS( 0x0001FFFFFFFFFE00 ),
		LONG2CHARS( 0x0001FFFFFFFFFF00 ),
		LONG2CHARS( 0x0001FFFFFFFFFF80 ),
		LONG2CHARS( 0x0001FFFFFFFFFFC0 ),
		LONG2CHARS( 0x0001FFFFFFFFFFE0 ),
		LONG2CHARS( 0x0001FFFFFFFFFFF0 ),
		LONG2CHARS( 0x0001FFFFFFFFFFF8 ),
		LONG2CHARS( 0x0001FFFFFFFFFFFC ),
		LONG2CHARS( 0x0001FFFFFFFFFFFE ),
		LONG2CHARS( 0x0001FFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000800000000000 ),
		LONG2CHARS( 0x0000C00000000000 ),
		LONG2CHARS( 0x0000E00000000000 ),
		LONG2CHARS( 0x0000F00000000000 ),
		LONG2CHARS( 0x0000F80000000000 ),
		LONG2CHARS( 0x0000FC0000000000 ),
		LONG2CHARS( 0x0000FE0000000000 ),
		LONG2CHARS( 0x0000FF0000000000 ),
		LONG2CHARS( 0x0000FF8000000000 ),
		LONG2CHARS( 0x0000FFC000000000 ),
		LONG2CHARS( 0x0000FFE000000000 ),
		LONG2CHARS( 0x0000FFF000000000 ),
		LONG2CHARS( 0x0000FFF800000000 ),
		LONG2CHARS( 0x0000FFFC00000000 ),
		LONG2CHARS( 0x0000FFFE00000000 ),
		LONG2CHARS( 0x0000FFFF00000000 ),
		LONG2CHARS( 0x0000FFFF80000000 ),
		LONG2CHARS( 0x0000FFFFC0000000 ),
		LONG2CHARS( 0x0000FFFFE0000000 ),
		LONG2CHARS( 0x0000FFFFF0000000 ),
		LONG2CHARS( 0x0000FFFFF8000000 ),
		LONG2CHARS( 0x0000FFFFFC000000 ),
		LONG2CHARS( 0x0000FFFFFE000000 ),
		LONG2CHARS( 0x0000FFFFFF000000 ),
		LONG2CHARS( 0x0000FFFFFF800000 ),
		LONG2CHARS( 0x0000FFFFFFC00000 ),
		LONG2CHARS( 0x0000FFFFFFE00000 ),
		LONG2CHARS( 0x0000FFFFFFF00000 ),
		LONG2CHARS( 0x0000FFFFFFF80000 ),
		LONG2CHARS( 0x0000FFFFFFFC0000 ),
		LONG2CHARS( 0x0000FFFFFFFE0000 ),
		LONG2CHARS( 0x0000FFFFFFFF0000 ),
		LONG2CHARS( 0x0000FFFFFFFF8000 ),
		LONG2CHARS( 0x0000FFFFFFFFC000 ),
		LONG2CHARS( 0x0000FFFFFFFFE000 ),
		LONG2CHARS( 0x0000FFFFFFFFF000 ),
		LONG2CHARS( 0x0000FFFFFFFFF800 ),
		LONG2CHARS( 0x0000FFFFFFFFFC00 ),
		LONG2CHARS( 0x0000FFFFFFFFFE00 ),
		LONG2CHARS( 0x0000FFFFFFFFFF00 ),
		LONG2CHARS( 0x0000FFFFFFFFFF80 ),
		LONG2CHARS( 0x0000FFFFFFFFFFC0 ),
		LONG2CHARS( 0x0000FFFFFFFFFFE0 ),
		LONG2CHARS( 0x0000FFFFFFFFFFF0 ),
		LONG2CHARS( 0x0000FFFFFFFFFFF8 ),
		LONG2CHARS( 0x0000FFFFFFFFFFFC ),
		LONG2CHARS( 0x0000FFFFFFFFFFFE ),
		LONG2CHARS( 0x0000FFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000400000000000 ),
		LONG2CHARS( 0x0000600000000000 ),
		LONG2CHARS( 0x0000700000000000 ),
		LONG2CHARS( 0x0000780000000000 ),
		LONG2CHARS( 0x00007C0000000000 ),
		LONG2CHARS( 0x00007E0000000000 ),
		LONG2CHARS( 0x00007F0000000000 ),
		LONG2CHARS( 0x00007F8000000000 ),
		LONG2CHARS( 0x00007FC000000000 ),
		LONG2CHARS( 0x00007FE000000000 ),
		LONG2CHARS( 0x00007FF000000000 ),
		LONG2CHARS( 0x00007FF800000000 ),
		LONG2CHARS( 0x00007FFC00000000 ),
		LONG2CHARS( 0x00007FFE00000000 ),
		LONG2CHARS( 0x00007FFF00000000 ),
		LONG2CHARS( 0x00007FFF80000000 ),
		LONG2CHARS( 0x00007FFFC0000000 ),
		LONG2CHARS( 0x00007FFFE0000000 ),
		LONG2CHARS( 0x00007FFFF0000000 ),
		LONG2CHARS( 0x00007FFFF8000000 ),
		LONG2CHARS( 0x00007FFFFC000000 ),
		LONG2CHARS( 0x00007FFFFE000000 ),
		LONG2CHARS( 0x00007FFFFF000000 ),
		LONG2CHARS( 0x00007FFFFF800000 ),
		LONG2CHARS( 0x00007FFFFFC00000 ),
		LONG2CHARS( 0x00007FFFFFE00000 ),
		LONG2CHARS( 0x00007FFFFFF00000 ),
		LONG2CHARS( 0x00007FFFFFF80000 ),
		LONG2CHARS( 0x00007FFFFFFC0000 ),
		LONG2CHARS( 0x00007FFFFFFE0000 ),
		LONG2CHARS( 0x00007FFFFFFF0000 ),
		LONG2CHARS( 0x00007FFFFFFF8000 ),
		LONG2CHARS( 0x00007FFFFFFFC000 ),
		LONG2CHARS( 0x00007FFFFFFFE000 ),
		LONG2CHARS( 0x00007FFFFFFFF000 ),
		LONG2CHARS( 0x00007FFFFFFFF800 ),
		LONG2CHARS( 0x00007FFFFFFFFC00 ),
		LONG2CHARS( 0x00007FFFFFFFFE00 ),
		LONG2CHARS( 0x00007FFFFFFFFF00 ),
		LONG2CHARS( 0x00007FFFFFFFFF80 ),
		LONG2CHARS( 0x00007FFFFFFFFFC0 ),
		LONG2CHARS( 0x00007FFFFFFFFFE0 ),
		LONG2CHARS( 0x00007FFFFFFFFFF0 ),
		LONG2CHARS( 0x00007FFFFFFFFFF8 ),
		LONG2CHARS( 0x00007FFFFFFFFFFC ),
		LONG2CHARS( 0x00007FFFFFFFFFFE ),
		LONG2CHARS( 0x00007FFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000200000000000 ),
		LONG2CHARS( 0x0000300000000000 ),
		LONG2CHARS( 0x0000380000000000 ),
		LONG2CHARS( 0x00003C0000000000 ),
		LONG2CHARS( 0x00003E0000000000 ),
		LONG2CHARS( 0x00003F0000000000 ),
		LONG2CHARS( 0x00003F8000000000 ),
		LONG2CHARS( 0x00003FC000000000 ),
		LONG2CHARS( 0x00003FE000000000 ),
		LONG2CHARS( 0x00003FF000000000 ),
		LONG2CHARS( 0x00003FF800000000 ),
		LONG2CHARS( 0x00003FFC00000000 ),
		LONG2CHARS( 0x00003FFE00000000 ),
		LONG2CHARS( 0x00003FFF00000000 ),
		LONG2CHARS( 0x00003FFF80000000 ),
		LONG2CHARS( 0x00003FFFC0000000 ),
		LONG2CHARS( 0x00003FFFE0000000 ),
		LONG2CHARS( 0x00003FFFF0000000 ),
		LONG2CHARS( 0x00003FFFF8000000 ),
		LONG2CHARS( 0x00003FFFFC000000 ),
		LONG2CHARS( 0x00003FFFFE000000 ),
		LONG2CHARS( 0x00003FFFFF000000 ),
		LONG2CHARS( 0x00003FFFFF800000 ),
		LONG2CHARS( 0x00003FFFFFC00000 ),
		LONG2CHARS( 0x00003FFFFFE00000 ),
		LONG2CHARS( 0x00003FFFFFF00000 ),
		LONG2CHARS( 0x00003FFFFFF80000 ),
		LONG2CHARS( 0x00003FFFFFFC0000 ),
		LONG2CHARS( 0x00003FFFFFFE0000 ),
		LONG2CHARS( 0x00003FFFFFFF0000 ),
		LONG2CHARS( 0x00003FFFFFFF8000 ),
		LONG2CHARS( 0x00003FFFFFFFC000 ),
		LONG2CHARS( 0x00003FFFFFFFE000 ),
		LONG2CHARS( 0x00003FFFFFFFF000 ),
		LONG2CHARS( 0x00003FFFFFFFF800 ),
		LONG2CHARS( 0x00003FFFFFFFFC00 ),
		LONG2CHARS( 0x00003FFFFFFFFE00 ),
		LONG2CHARS( 0x00003FFFFFFFFF00 ),
		LONG2CHARS( 0x00003FFFFFFFFF80 ),
		LONG2CHARS( 0x00003FFFFFFFFFC0 ),
		LONG2CHARS( 0x00003FFFFFFFFFE0 ),
		LONG2CHARS( 0x00003FFFFFFFFFF0 ),
		LONG2CHARS( 0x00003FFFFFFFFFF8 ),
		LONG2CHARS( 0x00003FFFFFFFFFFC ),
		LONG2CHARS( 0x00003FFFFFFFFFFE ),
		LONG2CHARS( 0x00003FFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000100000000000 ),
		LONG2CHARS( 0x0000180000000000 ),
		LONG2CHARS( 0x00001C0000000000 ),
		LONG2CHARS( 0x00001E0000000000 ),
		LONG2CHARS( 0x00001F0000000000 ),
		LONG2CHARS( 0x00001F8000000000 ),
		LONG2CHARS( 0x00001FC000000000 ),
		LONG2CHARS( 0x00001FE000000000 ),
		LONG2CHARS( 0x00001FF000000000 ),
		LONG2CHARS( 0x00001FF800000000 ),
		LONG2CHARS( 0x00001FFC00000000 ),
		LONG2CHARS( 0x00001FFE00000000 ),
		LONG2CHARS( 0x00001FFF00000000 ),
		LONG2CHARS( 0x00001FFF80000000 ),
		LONG2CHARS( 0x00001FFFC0000000 ),
		LONG2CHARS( 0x00001FFFE0000000 ),
		LONG2CHARS( 0x00001FFFF0000000 ),
		LONG2CHARS( 0x00001FFFF8000000 ),
		LONG2CHARS( 0x00001FFFFC000000 ),
		LONG2CHARS( 0x00001FFFFE000000 ),
		LONG2CHARS( 0x00001FFFFF000000 ),
		LONG2CHARS( 0x00001FFFFF800000 ),
		LONG2CHARS( 0x00001FFFFFC00000 ),
		LONG2CHARS( 0x00001FFFFFE00000 ),
		LONG2CHARS( 0x00001FFFFFF00000 ),
		LONG2CHARS( 0x00001FFFFFF80000 ),
		LONG2CHARS( 0x00001FFFFFFC0000 ),
		LONG2CHARS( 0x00001FFFFFFE0000 ),
		LONG2CHARS( 0x00001FFFFFFF0000 ),
		LONG2CHARS( 0x00001FFFFFFF8000 ),
		LONG2CHARS( 0x00001FFFFFFFC000 ),
		LONG2CHARS( 0x00001FFFFFFFE000 ),
		LONG2CHARS( 0x00001FFFFFFFF000 ),
		LONG2CHARS( 0x00001FFFFFFFF800 ),
		LONG2CHARS( 0x00001FFFFFFFFC00 ),
		LONG2CHARS( 0x00001FFFFFFFFE00 ),
		LONG2CHARS( 0x00001FFFFFFFFF00 ),
		LONG2CHARS( 0x00001FFFFFFFFF80 ),
		LONG2CHARS( 0x00001FFFFFFFFFC0 ),
		LONG2CHARS( 0x00001FFFFFFFFFE0 ),
		LONG2CHARS( 0x00001FFFFFFFFFF0 ),
		LONG2CHARS( 0x00001FFFFFFFFFF8 ),
		LONG2CHARS( 0x00001FFFFFFFFFFC ),
		LONG2CHARS( 0x00001FFFFFFFFFFE ),
		LONG2CHARS( 0x00001FFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000080000000000 ),
		LONG2CHARS( 0x00000C0000000000 ),
		LONG2CHARS( 0x00000E0000000000 ),
		LONG2CHARS( 0x00000F0000000000 ),
		LONG2CHARS( 0x00000F8000000000 ),
		LONG2CHARS( 0x00000FC000000000 ),
		LONG2CHARS( 0x00000FE000000000 ),
		LONG2CHARS( 0x00000FF000000000 ),
		LONG2CHARS( 0x00000FF800000000 ),
		LONG2CHARS( 0x00000FFC00000000 ),
		LONG2CHARS( 0x00000FFE00000000 ),
		LONG2CHARS( 0x00000FFF00000000 ),
		LONG2CHARS( 0x00000FFF80000000 ),
		LONG2CHARS( 0x00000FFFC0000000 ),
		LONG2CHARS( 0x00000FFFE0000000 ),
		LONG2CHARS( 0x00000FFFF0000000 ),
		LONG2CHARS( 0x00000FFFF8000000 ),
		LONG2CHARS( 0x00000FFFFC000000 ),
		LONG2CHARS( 0x00000FFFFE000000 ),
		LONG2CHARS( 0x00000FFFFF000000 ),
		LONG2CHARS( 0x00000FFFFF800000 ),
		LONG2CHARS( 0x00000FFFFFC00000 ),
		LONG2CHARS( 0x00000FFFFFE00000 ),
		LONG2CHARS( 0x00000FFFFFF00000 ),
		LONG2CHARS( 0x00000FFFFFF80000 ),
		LONG2CHARS( 0x00000FFFFFFC0000 ),
		LONG2CHARS( 0x00000FFFFFFE0000 ),
		LONG2CHARS( 0x00000FFFFFFF0000 ),
		LONG2CHARS( 0x00000FFFFFFF8000 ),
		LONG2CHARS( 0x00000FFFFFFFC000 ),
		LONG2CHARS( 0x00000FFFFFFFE000 ),
		LONG2CHARS( 0x00000FFFFFFFF000 ),
		LONG2CHARS( 0x00000FFFFFFFF800 ),
		LONG2CHARS( 0x00000FFFFFFFFC00 ),
		LONG2CHARS( 0x00000FFFFFFFFE00 ),
		LONG2CHARS( 0x00000FFFFFFFFF00 ),
		LONG2CHARS( 0x00000FFFFFFFFF80 ),
		LONG2CHARS( 0x00000FFFFFFFFFC0 ),
		LONG2CHARS( 0x00000FFFFFFFFFE0 ),
		LONG2CHARS( 0x00000FFFFFFFFFF0 ),
		LONG2CHARS( 0x00000FFFFFFFFFF8 ),
		LONG2CHARS( 0x00000FFFFFFFFFFC ),
		LONG2CHARS( 0x00000FFFFFFFFFFE ),
		LONG2CHARS( 0x00000FFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000040000000000 ),
		LONG2CHARS( 0x0000060000000000 ),
		LONG2CHARS( 0x0000070000000000 ),
		LONG2CHARS( 0x0000078000000000 ),
		LONG2CHARS( 0x000007C000000000 ),
		LONG2CHARS( 0x000007E000000000 ),
		LONG2CHARS( 0x000007F000000000 ),
		LONG2CHARS( 0x000007F800000000 ),
		LONG2CHARS( 0x000007FC00000000 ),
		LONG2CHARS( 0x000007FE00000000 ),
		LONG2CHARS( 0x000007FF00000000 ),
		LONG2CHARS( 0x000007FF80000000 ),
		LONG2CHARS( 0x000007FFC0000000 ),
		LONG2CHARS( 0x000007FFE0000000 ),
		LONG2CHARS( 0x000007FFF0000000 ),
		LONG2CHARS( 0x000007FFF8000000 ),
		LONG2CHARS( 0x000007FFFC000000 ),
		LONG2CHARS( 0x000007FFFE000000 ),
		LONG2CHARS( 0x000007FFFF000000 ),
		LONG2CHARS( 0x000007FFFF800000 ),
		LONG2CHARS( 0x000007FFFFC00000 ),
		LONG2CHARS( 0x000007FFFFE00000 ),
		LONG2CHARS( 0x000007FFFFF00000 ),
		LONG2CHARS( 0x000007FFFFF80000 ),
		LONG2CHARS( 0x000007FFFFFC0000 ),
		LONG2CHARS( 0x000007FFFFFE0000 ),
		LONG2CHARS( 0x000007FFFFFF0000 ),
		LONG2CHARS( 0x000007FFFFFF8000 ),
		LONG2CHARS( 0x000007FFFFFFC000 ),
		LONG2CHARS( 0x000007FFFFFFE000 ),
		LONG2CHARS( 0x000007FFFFFFF000 ),
		LONG2CHARS( 0x000007FFFFFFF800 ),
		LONG2CHARS( 0x000007FFFFFFFC00 ),
		LONG2CHARS( 0x000007FFFFFFFE00 ),
		LONG2CHARS( 0x000007FFFFFFFF00 ),
		LONG2CHARS( 0x000007FFFFFFFF80 ),
		LONG2CHARS( 0x000007FFFFFFFFC0 ),
		LONG2CHARS( 0x000007FFFFFFFFE0 ),
		LONG2CHARS( 0x000007FFFFFFFFF0 ),
		LONG2CHARS( 0x000007FFFFFFFFF8 ),
		LONG2CHARS( 0x000007FFFFFFFFFC ),
		LONG2CHARS( 0x000007FFFFFFFFFE ),
		LONG2CHARS( 0x000007FFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000020000000000 ),
		LONG2CHARS( 0x0000030000000000 ),
		LONG2CHARS( 0x0000038000000000 ),
		LONG2CHARS( 0x000003C000000000 ),
		LONG2CHARS( 0x000003E000000000 ),
		LONG2CHARS( 0x000003F000000000 ),
		LONG2CHARS( 0x000003F800000000 ),
		LONG2CHARS( 0x000003FC00000000 ),
		LONG2CHARS( 0x000003FE00000000 ),
		LONG2CHARS( 0x000003FF00000000 ),
		LONG2CHARS( 0x000003FF80000000 ),
		LONG2CHARS( 0x000003FFC0000000 ),
		LONG2CHARS( 0x000003FFE0000000 ),
		LONG2CHARS( 0x000003FFF0000000 ),
		LONG2CHARS( 0x000003FFF8000000 ),
		LONG2CHARS( 0x000003FFFC000000 ),
		LONG2CHARS( 0x000003FFFE000000 ),
		LONG2CHARS( 0x000003FFFF000000 ),
		LONG2CHARS( 0x000003FFFF800000 ),
		LONG2CHARS( 0x000003FFFFC00000 ),
		LONG2CHARS( 0x000003FFFFE00000 ),
		LONG2CHARS( 0x000003FFFFF00000 ),
		LONG2CHARS( 0x000003FFFFF80000 ),
		LONG2CHARS( 0x000003FFFFFC0000 ),
		LONG2CHARS( 0x000003FFFFFE0000 ),
		LONG2CHARS( 0x000003FFFFFF0000 ),
		LONG2CHARS( 0x000003FFFFFF8000 ),
		LONG2CHARS( 0x000003FFFFFFC000 ),
		LONG2CHARS( 0x000003FFFFFFE000 ),
		LONG2CHARS( 0x000003FFFFFFF000 ),
		LONG2CHARS( 0x000003FFFFFFF800 ),
		LONG2CHARS( 0x000003FFFFFFFC00 ),
		LONG2CHARS( 0x000003FFFFFFFE00 ),
		LONG2CHARS( 0x000003FFFFFFFF00 ),
		LONG2CHARS( 0x000003FFFFFFFF80 ),
		LONG2CHARS( 0x000003FFFFFFFFC0 ),
		LONG2CHARS( 0x000003FFFFFFFFE0 ),
		LONG2CHARS( 0x000003FFFFFFFFF0 ),
		LONG2CHARS( 0x000003FFFFFFFFF8 ),
		LONG2CHARS( 0x000003FFFFFFFFFC ),
		LONG2CHARS( 0x000003FFFFFFFFFE ),
		LONG2CHARS( 0x000003FFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000010000000000 ),
		LONG2CHARS( 0x0000018000000000 ),
		LONG2CHARS( 0x000001C000000000 ),
		LONG2CHARS( 0x000001E000000000 ),
		LONG2CHARS( 0x000001F000000000 ),
		LONG2CHARS( 0x000001F800000000 ),
		LONG2CHARS( 0x000001FC00000000 ),
		LONG2CHARS( 0x000001FE00000000 ),
		LONG2CHARS( 0x000001FF00000000 ),
		LONG2CHARS( 0x000001FF80000000 ),
		LONG2CHARS( 0x000001FFC0000000 ),
		LONG2CHARS( 0x000001FFE0000000 ),
		LONG2CHARS( 0x000001FFF0000000 ),
		LONG2CHARS( 0x000001FFF8000000 ),
		LONG2CHARS( 0x000001FFFC000000 ),
		LONG2CHARS( 0x000001FFFE000000 ),
		LONG2CHARS( 0x000001FFFF000000 ),
		LONG2CHARS( 0x000001FFFF800000 ),
		LONG2CHARS( 0x000001FFFFC00000 ),
		LONG2CHARS( 0x000001FFFFE00000 ),
		LONG2CHARS( 0x000001FFFFF00000 ),
		LONG2CHARS( 0x000001FFFFF80000 ),
		LONG2CHARS( 0x000001FFFFFC0000 ),
		LONG2CHARS( 0x000001FFFFFE0000 ),
		LONG2CHARS( 0x000001FFFFFF0000 ),
		LONG2CHARS( 0x000001FFFFFF8000 ),
		LONG2CHARS( 0x000001FFFFFFC000 ),
		LONG2CHARS( 0x000001FFFFFFE000 ),
		LONG2CHARS( 0x000001FFFFFFF000 ),
		LONG2CHARS( 0x000001FFFFFFF800 ),
		LONG2CHARS( 0x000001FFFFFFFC00 ),
		LONG2CHARS( 0x000001FFFFFFFE00 ),
		LONG2CHARS( 0x000001FFFFFFFF00 ),
		LONG2CHARS( 0x000001FFFFFFFF80 ),
		LONG2CHARS( 0x000001FFFFFFFFC0 ),
		LONG2CHARS( 0x000001FFFFFFFFE0 ),
		LONG2CHARS( 0x000001FFFFFFFFF0 ),
		LONG2CHARS( 0x000001FFFFFFFFF8 ),
		LONG2CHARS( 0x000001FFFFFFFFFC ),
		LONG2CHARS( 0x000001FFFFFFFFFE ),
		LONG2CHARS( 0x000001FFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000008000000000 ),
		LONG2CHARS( 0x000000C000000000 ),
		LONG2CHARS( 0x000000E000000000 ),
		LONG2CHARS( 0x000000F000000000 ),
		LONG2CHARS( 0x000000F800000000 ),
		LONG2CHARS( 0x000000FC00000000 ),
		LONG2CHARS( 0x000000FE00000000 ),
		LONG2CHARS( 0x000000FF00000000 ),
		LONG2CHARS( 0x000000FF80000000 ),
		LONG2CHARS( 0x000000FFC0000000 ),
		LONG2CHARS( 0x000000FFE0000000 ),
		LONG2CHARS( 0x000000FFF0000000 ),
		LONG2CHARS( 0x000000FFF8000000 ),
		LONG2CHARS( 0x000000FFFC000000 ),
		LONG2CHARS( 0x000000FFFE000000 ),
		LONG2CHARS( 0x000000FFFF000000 ),
		LONG2CHARS( 0x000000FFFF800000 ),
		LONG2CHARS( 0x000000FFFFC00000 ),
		LONG2CHARS( 0x000000FFFFE00000 ),
		LONG2CHARS( 0x000000FFFFF00000 ),
		LONG2CHARS( 0x000000FFFFF80000 ),
		LONG2CHARS( 0x000000FFFFFC0000 ),
		LONG2CHARS( 0x000000FFFFFE0000 ),
		LONG2CHARS( 0x000000FFFFFF0000 ),
		LONG2CHARS( 0x000000FFFFFF8000 ),
		LONG2CHARS( 0x000000FFFFFFC000 ),
		LONG2CHARS( 0x000000FFFFFFE000 ),
		LONG2CHARS( 0x000000FFFFFFF000 ),
		LONG2CHARS( 0x000000FFFFFFF800 ),
		LONG2CHARS( 0x000000FFFFFFFC00 ),
		LONG2CHARS( 0x000000FFFFFFFE00 ),
		LONG2CHARS( 0x000000FFFFFFFF00 ),
		LONG2CHARS( 0x000000FFFFFFFF80 ),
		LONG2CHARS( 0x000000FFFFFFFFC0 ),
		LONG2CHARS( 0x000000FFFFFFFFE0 ),
		LONG2CHARS( 0x000000FFFFFFFFF0 ),
		LONG2CHARS( 0x000000FFFFFFFFF8 ),
		LONG2CHARS( 0x000000FFFFFFFFFC ),
		LONG2CHARS( 0x000000FFFFFFFFFE ),
		LONG2CHARS( 0x000000FFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000004000000000 ),
		LONG2CHARS( 0x0000006000000000 ),
		LONG2CHARS( 0x0000007000000000 ),
		LONG2CHARS( 0x0000007800000000 ),
		LONG2CHARS( 0x0000007C00000000 ),
		LONG2CHARS( 0x0000007E00000000 ),
		LONG2CHARS( 0x0000007F00000000 ),
		LONG2CHARS( 0x0000007F80000000 ),
		LONG2CHARS( 0x0000007FC0000000 ),
		LONG2CHARS( 0x0000007FE0000000 ),
		LONG2CHARS( 0x0000007FF0000000 ),
		LONG2CHARS( 0x0000007FF8000000 ),
		LONG2CHARS( 0x0000007FFC000000 ),
		LONG2CHARS( 0x0000007FFE000000 ),
		LONG2CHARS( 0x0000007FFF000000 ),
		LONG2CHARS( 0x0000007FFF800000 ),
		LONG2CHARS( 0x0000007FFFC00000 ),
		LONG2CHARS( 0x0000007FFFE00000 ),
		LONG2CHARS( 0x0000007FFFF00000 ),
		LONG2CHARS( 0x0000007FFFF80000 ),
		LONG2CHARS( 0x0000007FFFFC0000 ),
		LONG2CHARS( 0x0000007FFFFE0000 ),
		LONG2CHARS( 0x0000007FFFFF0000 ),
		LONG2CHARS( 0x0000007FFFFF8000 ),
		LONG2CHARS( 0x0000007FFFFFC000 ),
		LONG2CHARS( 0x0000007FFFFFE000 ),
		LONG2CHARS( 0x0000007FFFFFF000 ),
		LONG2CHARS( 0x0000007FFFFFF800 ),
		LONG2CHARS( 0x0000007FFFFFFC00 ),
		LONG2CHARS( 0x0000007FFFFFFE00 ),
		LONG2CHARS( 0x0000007FFFFFFF00 ),
		LONG2CHARS( 0x0000007FFFFFFF80 ),
		LONG2CHARS( 0x0000007FFFFFFFC0 ),
		LONG2CHARS( 0x0000007FFFFFFFE0 ),
		LONG2CHARS( 0x0000007FFFFFFFF0 ),
		LONG2CHARS( 0x0000007FFFFFFFF8 ),
		LONG2CHARS( 0x0000007FFFFFFFFC ),
		LONG2CHARS( 0x0000007FFFFFFFFE ),
		LONG2CHARS( 0x0000007FFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000002000000000 ),
		LONG2CHARS( 0x0000003000000000 ),
		LONG2CHARS( 0x0000003800000000 ),
		LONG2CHARS( 0x0000003C00000000 ),
		LONG2CHARS( 0x0000003E00000000 ),
		LONG2CHARS( 0x0000003F00000000 ),
		LONG2CHARS( 0x0000003F80000000 ),
		LONG2CHARS( 0x0000003FC0000000 ),
		LONG2CHARS( 0x0000003FE0000000 ),
		LONG2CHARS( 0x0000003FF0000000 ),
		LONG2CHARS( 0x0000003FF8000000 ),
		LONG2CHARS( 0x0000003FFC000000 ),
		LONG2CHARS( 0x0000003FFE000000 ),
		LONG2CHARS( 0x0000003FFF000000 ),
		LONG2CHARS( 0x0000003FFF800000 ),
		LONG2CHARS( 0x0000003FFFC00000 ),
		LONG2CHARS( 0x0000003FFFE00000 ),
		LONG2CHARS( 0x0000003FFFF00000 ),
		LONG2CHARS( 0x0000003FFFF80000 ),
		LONG2CHARS( 0x0000003FFFFC0000 ),
		LONG2CHARS( 0x0000003FFFFE0000 ),
		LONG2CHARS( 0x0000003FFFFF0000 ),
		LONG2CHARS( 0x0000003FFFFF8000 ),
		LONG2CHARS( 0x0000003FFFFFC000 ),
		LONG2CHARS( 0x0000003FFFFFE000 ),
		LONG2CHARS( 0x0000003FFFFFF000 ),
		LONG2CHARS( 0x0000003FFFFFF800 ),
		LONG2CHARS( 0x0000003FFFFFFC00 ),
		LONG2CHARS( 0x0000003FFFFFFE00 ),
		LONG2CHARS( 0x0000003FFFFFFF00 ),
		LONG2CHARS( 0x0000003FFFFFFF80 ),
		LONG2CHARS( 0x0000003FFFFFFFC0 ),
		LONG2CHARS( 0x0000003FFFFFFFE0 ),
		LONG2CHARS( 0x0000003FFFFFFFF0 ),
		LONG2CHARS( 0x0000003FFFFFFFF8 ),
		LONG2CHARS( 0x0000003FFFFFFFFC ),
		LONG2CHARS( 0x0000003FFFFFFFFE ),
		LONG2CHARS( 0x0000003FFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000001000000000 ),
		LONG2CHARS( 0x0000001800000000 ),
		LONG2CHARS( 0x0000001C00000000 ),
		LONG2CHARS( 0x0000001E00000000 ),
		LONG2CHARS( 0x0000001F00000000 ),
		LONG2CHARS( 0x0000001F80000000 ),
		LONG2CHARS( 0x0000001FC0000000 ),
		LONG2CHARS( 0x0000001FE0000000 ),
		LONG2CHARS( 0x0000001FF0000000 ),
		LONG2CHARS( 0x0000001FF8000000 ),
		LONG2CHARS( 0x0000001FFC000000 ),
		LONG2CHARS( 0x0000001FFE000000 ),
		LONG2CHARS( 0x0000001FFF000000 ),
		LONG2CHARS( 0x0000001FFF800000 ),
		LONG2CHARS( 0x0000001FFFC00000 ),
		LONG2CHARS( 0x0000001FFFE00000 ),
		LONG2CHARS( 0x0000001FFFF00000 ),
		LONG2CHARS( 0x0000001FFFF80000 ),
		LONG2CHARS( 0x0000001FFFFC0000 ),
		LONG2CHARS( 0x0000001FFFFE0000 ),
		LONG2CHARS( 0x0000001FFFFF0000 ),
		LONG2CHARS( 0x0000001FFFFF8000 ),
		LONG2CHARS( 0x0000001FFFFFC000 ),
		LONG2CHARS( 0x0000001FFFFFE000 ),
		LONG2CHARS( 0x0000001FFFFFF000 ),
		LONG2CHARS( 0x0000001FFFFFF800 ),
		LONG2CHARS( 0x0000001FFFFFFC00 ),
		LONG2CHARS( 0x0000001FFFFFFE00 ),
		LONG2CHARS( 0x0000001FFFFFFF00 ),
		LONG2CHARS( 0x0000001FFFFFFF80 ),
		LONG2CHARS( 0x0000001FFFFFFFC0 ),
		LONG2CHARS( 0x0000001FFFFFFFE0 ),
		LONG2CHARS( 0x0000001FFFFFFFF0 ),
		LONG2CHARS( 0x0000001FFFFFFFF8 ),
		LONG2CHARS( 0x0000001FFFFFFFFC ),
		LONG2CHARS( 0x0000001FFFFFFFFE ),
		LONG2CHARS( 0x0000001FFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000800000000 ),
		LONG2CHARS( 0x0000000C00000000 ),
		LONG2CHARS( 0x0000000E00000000 ),
		LONG2CHARS( 0x0000000F00000000 ),
		LONG2CHARS( 0x0000000F80000000 ),
		LONG2CHARS( 0x0000000FC0000000 ),
		LONG2CHARS( 0x0000000FE0000000 ),
		LONG2CHARS( 0x0000000FF0000000 ),
		LONG2CHARS( 0x0000000FF8000000 ),
		LONG2CHARS( 0x0000000FFC000000 ),
		LONG2CHARS( 0x0000000FFE000000 ),
		LONG2CHARS( 0x0000000FFF000000 ),
		LONG2CHARS( 0x0000000FFF800000 ),
		LONG2CHARS( 0x0000000FFFC00000 ),
		LONG2CHARS( 0x0000000FFFE00000 ),
		LONG2CHARS( 0x0000000FFFF00000 ),
		LONG2CHARS( 0x0000000FFFF80000 ),
		LONG2CHARS( 0x0000000FFFFC0000 ),
		LONG2CHARS( 0x0000000FFFFE0000 ),
		LONG2CHARS( 0x0000000FFFFF0000 ),
		LONG2CHARS( 0x0000000FFFFF8000 ),
		LONG2CHARS( 0x0000000FFFFFC000 ),
		LONG2CHARS( 0x0000000FFFFFE000 ),
		LONG2CHARS( 0x0000000FFFFFF000 ),
		LONG2CHARS( 0x0000000FFFFFF800 ),
		LONG2CHARS( 0x0000000FFFFFFC00 ),
		LONG2CHARS( 0x0000000FFFFFFE00 ),
		LONG2CHARS( 0x0000000FFFFFFF00 ),
		LONG2CHARS( 0x0000000FFFFFFF80 ),
		LONG2CHARS( 0x0000000FFFFFFFC0 ),
		LONG2CHARS( 0x0000000FFFFFFFE0 ),
		LONG2CHARS( 0x0000000FFFFFFFF0 ),
		LONG2CHARS( 0x0000000FFFFFFFF8 ),
		LONG2CHARS( 0x0000000FFFFFFFFC ),
		LONG2CHARS( 0x0000000FFFFFFFFE ),
		LONG2CHARS( 0x0000000FFFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000400000000 ),
		LONG2CHARS( 0x0000000600000000 ),
		LONG2CHARS( 0x0000000700000000 ),
		LONG2CHARS( 0x0000000780000000 ),
		LONG2CHARS( 0x00000007C0000000 ),
		LONG2CHARS( 0x00000007E0000000 ),
		LONG2CHARS( 0x00000007F0000000 ),
		LONG2CHARS( 0x00000007F8000000 ),
		LONG2CHARS( 0x00000007FC000000 ),
		LONG2CHARS( 0x00000007FE000000 ),
		LONG2CHARS( 0x00000007FF000000 ),
		LONG2CHARS( 0x00000007FF800000 ),
		LONG2CHARS( 0x00000007FFC00000 ),
		LONG2CHARS( 0x00000007FFE00000 ),
		LONG2CHARS( 0x00000007FFF00000 ),
		LONG2CHARS( 0x00000007FFF80000 ),
		LONG2CHARS( 0x00000007FFFC0000 ),
		LONG2CHARS( 0x00000007FFFE0000 ),
		LONG2CHARS( 0x00000007FFFF0000 ),
		LONG2CHARS( 0x00000007FFFF8000 ),
		LONG2CHARS( 0x00000007FFFFC000 ),
		LONG2CHARS( 0x00000007FFFFE000 ),
		LONG2CHARS( 0x00000007FFFFF000 ),
		LONG2CHARS( 0x00000007FFFFF800 ),
		LONG2CHARS( 0x00000007FFFFFC00 ),
		LONG2CHARS( 0x00000007FFFFFE00 ),
		LONG2CHARS( 0x00000007FFFFFF00 ),
		LONG2CHARS( 0x00000007FFFFFF80 ),
		LONG2CHARS( 0x00000007FFFFFFC0 ),
		LONG2CHARS( 0x00000007FFFFFFE0 ),
		LONG2CHARS( 0x00000007FFFFFFF0 ),
		LONG2CHARS( 0x00000007FFFFFFF8 ),
		LONG2CHARS( 0x00000007FFFFFFFC ),
		LONG2CHARS( 0x00000007FFFFFFFE ),
		LONG2CHARS( 0x00000007FFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000200000000 ),
		LONG2CHARS( 0x0000000300000000 ),
		LONG2CHARS( 0x0000000380000000 ),
		LONG2CHARS( 0x00000003C0000000 ),
		LONG2CHARS( 0x00000003E0000000 ),
		LONG2CHARS( 0x00000003F0000000 ),
		LONG2CHARS( 0x00000003F8000000 ),
		LONG2CHARS( 0x00000003FC000000 ),
		LONG2CHARS( 0x00000003FE000000 ),
		LONG2CHARS( 0x00000003FF000000 ),
		LONG2CHARS( 0x00000003FF800000 ),
		LONG2CHARS( 0x00000003FFC00000 ),
		LONG2CHARS( 0x00000003FFE00000 ),
		LONG2CHARS( 0x00000003FFF00000 ),
		LONG2CHARS( 0x00000003FFF80000 ),
		LONG2CHARS( 0x00000003FFFC0000 ),
		LONG2CHARS( 0x00000003FFFE0000 ),
		LONG2CHARS( 0x00000003FFFF0000 ),
		LONG2CHARS( 0x00000003FFFF8000 ),
		LONG2CHARS( 0x00000003FFFFC000 ),
		LONG2CHARS( 0x00000003FFFFE000 ),
		LONG2CHARS( 0x00000003FFFFF000 ),
		LONG2CHARS( 0x00000003FFFFF800 ),
		LONG2CHARS( 0x00000003FFFFFC00 ),
		LONG2CHARS( 0x00000003FFFFFE00 ),
		LONG2CHARS( 0x00000003FFFFFF00 ),
		LONG2CHARS( 0x00000003FFFFFF80 ),
		LONG2CHARS( 0x00000003FFFFFFC0 ),
		LONG2CHARS( 0x00000003FFFFFFE0 ),
		LONG2CHARS( 0x00000003FFFFFFF0 ),
		LONG2CHARS( 0x00000003FFFFFFF8 ),
		LONG2CHARS( 0x00000003FFFFFFFC ),
		LONG2CHARS( 0x00000003FFFFFFFE ),
		LONG2CHARS( 0x00000003FFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000100000000 ),
		LONG2CHARS( 0x0000000180000000 ),
		LONG2CHARS( 0x00000001C0000000 ),
		LONG2CHARS( 0x00000001E0000000 ),
		LONG2CHARS( 0x00000001F0000000 ),
		LONG2CHARS( 0x00000001F8000000 ),
		LONG2CHARS( 0x00000001FC000000 ),
		LONG2CHARS( 0x00000001FE000000 ),
		LONG2CHARS( 0x00000001FF000000 ),
		LONG2CHARS( 0x00000001FF800000 ),
		LONG2CHARS( 0x00000001FFC00000 ),
		LONG2CHARS( 0x00000001FFE00000 ),
		LONG2CHARS( 0x00000001FFF00000 ),
		LONG2CHARS( 0x00000001FFF80000 ),
		LONG2CHARS( 0x00000001FFFC0000 ),
		LONG2CHARS( 0x00000001FFFE0000 ),
		LONG2CHARS( 0x00000001FFFF0000 ),
		LONG2CHARS( 0x00000001FFFF8000 ),
		LONG2CHARS( 0x00000001FFFFC000 ),
		LONG2CHARS( 0x00000001FFFFE000 ),
		LONG2CHARS( 0x00000001FFFFF000 ),
		LONG2CHARS( 0x00000001FFFFF800 ),
		LONG2CHARS( 0x00000001FFFFFC00 ),
		LONG2CHARS( 0x00000001FFFFFE00 ),
		LONG2CHARS( 0x00000001FFFFFF00 ),
		LONG2CHARS( 0x00000001FFFFFF80 ),
		LONG2CHARS( 0x00000001FFFFFFC0 ),
		LONG2CHARS( 0x00000001FFFFFFE0 ),
		LONG2CHARS( 0x00000001FFFFFFF0 ),
		LONG2CHARS( 0x00000001FFFFFFF8 ),
		LONG2CHARS( 0x00000001FFFFFFFC ),
		LONG2CHARS( 0x00000001FFFFFFFE ),
		LONG2CHARS( 0x00000001FFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000080000000 ),
		LONG2CHARS( 0x00000000C0000000 ),
		LONG2CHARS( 0x00000000E0000000 ),
		LONG2CHARS( 0x00000000F0000000 ),
		LONG2CHARS( 0x00000000F8000000 ),
		LONG2CHARS( 0x00000000FC000000 ),
		LONG2CHARS( 0x00000000FE000000 ),
		LONG2CHARS( 0x00000000FF000000 ),
		LONG2CHARS( 0x00000000FF800000 ),
		LONG2CHARS( 0x00000000FFC00000 ),
		LONG2CHARS( 0x00000000FFE00000 ),
		LONG2CHARS( 0x00000000FFF00000 ),
		LONG2CHARS( 0x00000000FFF80000 ),
		LONG2CHARS( 0x00000000FFFC0000 ),
		LONG2CHARS( 0x00000000FFFE0000 ),
		LONG2CHARS( 0x00000000FFFF0000 ),
		LONG2CHARS( 0x00000000FFFF8000 ),
		LONG2CHARS( 0x00000000FFFFC000 ),
		LONG2CHARS( 0x00000000FFFFE000 ),
		LONG2CHARS( 0x00000000FFFFF000 ),
		LONG2CHARS( 0x00000000FFFFF800 ),
		LONG2CHARS( 0x00000000FFFFFC00 ),
		LONG2CHARS( 0x00000000FFFFFE00 ),
		LONG2CHARS( 0x00000000FFFFFF00 ),
		LONG2CHARS( 0x00000000FFFFFF80 ),
		LONG2CHARS( 0x00000000FFFFFFC0 ),
		LONG2CHARS( 0x00000000FFFFFFE0 ),
		LONG2CHARS( 0x00000000FFFFFFF0 ),
		LONG2CHARS( 0x00000000FFFFFFF8 ),
		LONG2CHARS( 0x00000000FFFFFFFC ),
		LONG2CHARS( 0x00000000FFFFFFFE ),
		LONG2CHARS( 0x00000000FFFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000040000000 ),
		LONG2CHARS( 0x0000000060000000 ),
		LONG2CHARS( 0x0000000070000000 ),
		LONG2CHARS( 0x0000000078000000 ),
		LONG2CHARS( 0x000000007C000000 ),
		LONG2CHARS( 0x000000007E000000 ),
		LONG2CHARS( 0x000000007F000000 ),
		LONG2CHARS( 0x000000007F800000 ),
		LONG2CHARS( 0x000000007FC00000 ),
		LONG2CHARS( 0x000000007FE00000 ),
		LONG2CHARS( 0x000000007FF00000 ),
		LONG2CHARS( 0x000000007FF80000 ),
		LONG2CHARS( 0x000000007FFC0000 ),
		LONG2CHARS( 0x000000007FFE0000 ),
		LONG2CHARS( 0x000000007FFF0000 ),
		LONG2CHARS( 0x000000007FFF8000 ),
		LONG2CHARS( 0x000000007FFFC000 ),
		LONG2CHARS( 0x000000007FFFE000 ),
		LONG2CHARS( 0x000000007FFFF000 ),
		LONG2CHARS( 0x000000007FFFF800 ),
		LONG2CHARS( 0x000000007FFFFC00 ),
		LONG2CHARS( 0x000000007FFFFE00 ),
		LONG2CHARS( 0x000000007FFFFF00 ),
		LONG2CHARS( 0x000000007FFFFF80 ),
		LONG2CHARS( 0x000000007FFFFFC0 ),
		LONG2CHARS( 0x000000007FFFFFE0 ),
		LONG2CHARS( 0x000000007FFFFFF0 ),
		LONG2CHARS( 0x000000007FFFFFF8 ),
		LONG2CHARS( 0x000000007FFFFFFC ),
		LONG2CHARS( 0x000000007FFFFFFE ),
		LONG2CHARS( 0x000000007FFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000020000000 ),
		LONG2CHARS( 0x0000000030000000 ),
		LONG2CHARS( 0x0000000038000000 ),
		LONG2CHARS( 0x000000003C000000 ),
		LONG2CHARS( 0x000000003E000000 ),
		LONG2CHARS( 0x000000003F000000 ),
		LONG2CHARS( 0x000000003F800000 ),
		LONG2CHARS( 0x000000003FC00000 ),
		LONG2CHARS( 0x000000003FE00000 ),
		LONG2CHARS( 0x000000003FF00000 ),
		LONG2CHARS( 0x000000003FF80000 ),
		LONG2CHARS( 0x000000003FFC0000 ),
		LONG2CHARS( 0x000000003FFE0000 ),
		LONG2CHARS( 0x000000003FFF0000 ),
		LONG2CHARS( 0x000000003FFF8000 ),
		LONG2CHARS( 0x000000003FFFC000 ),
		LONG2CHARS( 0x000000003FFFE000 ),
		LONG2CHARS( 0x000000003FFFF000 ),
		LONG2CHARS( 0x000000003FFFF800 ),
		LONG2CHARS( 0x000000003FFFFC00 ),
		LONG2CHARS( 0x000000003FFFFE00 ),
		LONG2CHARS( 0x000000003FFFFF00 ),
		LONG2CHARS( 0x000000003FFFFF80 ),
		LONG2CHARS( 0x000000003FFFFFC0 ),
		LONG2CHARS( 0x000000003FFFFFE0 ),
		LONG2CHARS( 0x000000003FFFFFF0 ),
		LONG2CHARS( 0x000000003FFFFFF8 ),
		LONG2CHARS( 0x000000003FFFFFFC ),
		LONG2CHARS( 0x000000003FFFFFFE ),
		LONG2CHARS( 0x000000003FFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000010000000 ),
		LONG2CHARS( 0x0000000018000000 ),
		LONG2CHARS( 0x000000001C000000 ),
		LONG2CHARS( 0x000000001E000000 ),
		LONG2CHARS( 0x000000001F000000 ),
		LONG2CHARS( 0x000000001F800000 ),
		LONG2CHARS( 0x000000001FC00000 ),
		LONG2CHARS( 0x000000001FE00000 ),
		LONG2CHARS( 0x000000001FF00000 ),
		LONG2CHARS( 0x000000001FF80000 ),
		LONG2CHARS( 0x000000001FFC0000 ),
		LONG2CHARS( 0x000000001FFE0000 ),
		LONG2CHARS( 0x000000001FFF0000 ),
		LONG2CHARS( 0x000000001FFF8000 ),
		LONG2CHARS( 0x000000001FFFC000 ),
		LONG2CHARS( 0x000000001FFFE000 ),
		LONG2CHARS( 0x000000001FFFF000 ),
		LONG2CHARS( 0x000000001FFFF800 ),
		LONG2CHARS( 0x000000001FFFFC00 ),
		LONG2CHARS( 0x000000001FFFFE00 ),
		LONG2CHARS( 0x000000001FFFFF00 ),
		LONG2CHARS( 0x000000001FFFFF80 ),
		LONG2CHARS( 0x000000001FFFFFC0 ),
		LONG2CHARS( 0x000000001FFFFFE0 ),
		LONG2CHARS( 0x000000001FFFFFF0 ),
		LONG2CHARS( 0x000000001FFFFFF8 ),
		LONG2CHARS( 0x000000001FFFFFFC ),
		LONG2CHARS( 0x000000001FFFFFFE ),
		LONG2CHARS( 0x000000001FFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000008000000 ),
		LONG2CHARS( 0x000000000C000000 ),
		LONG2CHARS( 0x000000000E000000 ),
		LONG2CHARS( 0x000000000F000000 ),
		LONG2CHARS( 0x000000000F800000 ),
		LONG2CHARS( 0x000000000FC00000 ),
		LONG2CHARS( 0x000000000FE00000 ),
		LONG2CHARS( 0x000000000FF00000 ),
		LONG2CHARS( 0x000000000FF80000 ),
		LONG2CHARS( 0x000000000FFC0000 ),
		LONG2CHARS( 0x000000000FFE0000 ),
		LONG2CHARS( 0x000000000FFF0000 ),
		LONG2CHARS( 0x000000000FFF8000 ),
		LONG2CHARS( 0x000000000FFFC000 ),
		LONG2CHARS( 0x000000000FFFE000 ),
		LONG2CHARS( 0x000000000FFFF000 ),
		LONG2CHARS( 0x000000000FFFF800 ),
		LONG2CHARS( 0x000000000FFFFC00 ),
		LONG2CHARS( 0x000000000FFFFE00 ),
		LONG2CHARS( 0x000000000FFFFF00 ),
		LONG2CHARS( 0x000000000FFFFF80 ),
		LONG2CHARS( 0x000000000FFFFFC0 ),
		LONG2CHARS( 0x000000000FFFFFE0 ),
		LONG2CHARS( 0x000000000FFFFFF0 ),
		LONG2CHARS( 0x000000000FFFFFF8 ),
		LONG2CHARS( 0x000000000FFFFFFC ),
		LONG2CHARS( 0x000000000FFFFFFE ),
		LONG2CHARS( 0x000000000FFFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000004000000 ),
		LONG2CHARS( 0x0000000006000000 ),
		LONG2CHARS( 0x0000000007000000 ),
		LONG2CHARS( 0x0000000007800000 ),
		LONG2CHARS( 0x0000000007C00000 ),
		LONG2CHARS( 0x0000000007E00000 ),
		LONG2CHARS( 0x0000000007F00000 ),
		LONG2CHARS( 0x0000000007F80000 ),
		LONG2CHARS( 0x0000000007FC0000 ),
		LONG2CHARS( 0x0000000007FE0000 ),
		LONG2CHARS( 0x0000000007FF0000 ),
		LONG2CHARS( 0x0000000007FF8000 ),
		LONG2CHARS( 0x0000000007FFC000 ),
		LONG2CHARS( 0x0000000007FFE000 ),
		LONG2CHARS( 0x0000000007FFF000 ),
		LONG2CHARS( 0x0000000007FFF800 ),
		LONG2CHARS( 0x0000000007FFFC00 ),
		LONG2CHARS( 0x0000000007FFFE00 ),
		LONG2CHARS( 0x0000000007FFFF00 ),
		LONG2CHARS( 0x0000000007FFFF80 ),
		LONG2CHARS( 0x0000000007FFFFC0 ),
		LONG2CHARS( 0x0000000007FFFFE0 ),
		LONG2CHARS( 0x0000000007FFFFF0 ),
		LONG2CHARS( 0x0000000007FFFFF8 ),
		LONG2CHARS( 0x0000000007FFFFFC ),
		LONG2CHARS( 0x0000000007FFFFFE ),
		LONG2CHARS( 0x0000000007FFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000002000000 ),
		LONG2CHARS( 0x0000000003000000 ),
		LONG2CHARS( 0x0000000003800000 ),
		LONG2CHARS( 0x0000000003C00000 ),
		LONG2CHARS( 0x0000000003E00000 ),
		LONG2CHARS( 0x0000000003F00000 ),
		LONG2CHARS( 0x0000000003F80000 ),
		LONG2CHARS( 0x0000000003FC0000 ),
		LONG2CHARS( 0x0000000003FE0000 ),
		LONG2CHARS( 0x0000000003FF0000 ),
		LONG2CHARS( 0x0000000003FF8000 ),
		LONG2CHARS( 0x0000000003FFC000 ),
		LONG2CHARS( 0x0000000003FFE000 ),
		LONG2CHARS( 0x0000000003FFF000 ),
		LONG2CHARS( 0x0000000003FFF800 ),
		LONG2CHARS( 0x0000000003FFFC00 ),
		LONG2CHARS( 0x0000000003FFFE00 ),
		LONG2CHARS( 0x0000000003FFFF00 ),
		LONG2CHARS( 0x0000000003FFFF80 ),
		LONG2CHARS( 0x0000000003FFFFC0 ),
		LONG2CHARS( 0x0000000003FFFFE0 ),
		LONG2CHARS( 0x0000000003FFFFF0 ),
		LONG2CHARS( 0x0000000003FFFFF8 ),
		LONG2CHARS( 0x0000000003FFFFFC ),
		LONG2CHARS( 0x0000000003FFFFFE ),
		LONG2CHARS( 0x0000000003FFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000001000000 ),
		LONG2CHARS( 0x0000000001800000 ),
		LONG2CHARS( 0x0000000001C00000 ),
		LONG2CHARS( 0x0000000001E00000 ),
		LONG2CHARS( 0x0000000001F00000 ),
		LONG2CHARS( 0x0000000001F80000 ),
		LONG2CHARS( 0x0000000001FC0000 ),
		LONG2CHARS( 0x0000000001FE0000 ),
		LONG2CHARS( 0x0000000001FF0000 ),
		LONG2CHARS( 0x0000000001FF8000 ),
		LONG2CHARS( 0x0000000001FFC000 ),
		LONG2CHARS( 0x0000000001FFE000 ),
		LONG2CHARS( 0x0000000001FFF000 ),
		LONG2CHARS( 0x0000000001FFF800 ),
		LONG2CHARS( 0x0000000001FFFC00 ),
		LONG2CHARS( 0x0000000001FFFE00 ),
		LONG2CHARS( 0x0000000001FFFF00 ),
		LONG2CHARS( 0x0000000001FFFF80 ),
		LONG2CHARS( 0x0000000001FFFFC0 ),
		LONG2CHARS( 0x0000000001FFFFE0 ),
		LONG2CHARS( 0x0000000001FFFFF0 ),
		LONG2CHARS( 0x0000000001FFFFF8 ),
		LONG2CHARS( 0x0000000001FFFFFC ),
		LONG2CHARS( 0x0000000001FFFFFE ),
		LONG2CHARS( 0x0000000001FFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000800000 ),
		LONG2CHARS( 0x0000000000C00000 ),
		LONG2CHARS( 0x0000000000E00000 ),
		LONG2CHARS( 0x0000000000F00000 ),
		LONG2CHARS( 0x0000000000F80000 ),
		LONG2CHARS( 0x0000000000FC0000 ),
		LONG2CHARS( 0x0000000000FE0000 ),
		LONG2CHARS( 0x0000000000FF0000 ),
		LONG2CHARS( 0x0000000000FF8000 ),
		LONG2CHARS( 0x0000000000FFC000 ),
		LONG2CHARS( 0x0000000000FFE000 ),
		LONG2CHARS( 0x0000000000FFF000 ),
		LONG2CHARS( 0x0000000000FFF800 ),
		LONG2CHARS( 0x0000000000FFFC00 ),
		LONG2CHARS( 0x0000000000FFFE00 ),
		LONG2CHARS( 0x0000000000FFFF00 ),
		LONG2CHARS( 0x0000000000FFFF80 ),
		LONG2CHARS( 0x0000000000FFFFC0 ),
		LONG2CHARS( 0x0000000000FFFFE0 ),
		LONG2CHARS( 0x0000000000FFFFF0 ),
		LONG2CHARS( 0x0000000000FFFFF8 ),
		LONG2CHARS( 0x0000000000FFFFFC ),
		LONG2CHARS( 0x0000000000FFFFFE ),
		LONG2CHARS( 0x0000000000FFFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000400000 ),
		LONG2CHARS( 0x0000000000600000 ),
		LONG2CHARS( 0x0000000000700000 ),
		LONG2CHARS( 0x0000000000780000 ),
		LONG2CHARS( 0x00000000007C0000 ),
		LONG2CHARS( 0x00000000007E0000 ),
		LONG2CHARS( 0x00000000007F0000 ),
		LONG2CHARS( 0x00000000007F8000 ),
		LONG2CHARS( 0x00000000007FC000 ),
		LONG2CHARS( 0x00000000007FE000 ),
		LONG2CHARS( 0x00000000007FF000 ),
		LONG2CHARS( 0x00000000007FF800 ),
		LONG2CHARS( 0x00000000007FFC00 ),
		LONG2CHARS( 0x00000000007FFE00 ),
		LONG2CHARS( 0x00000000007FFF00 ),
		LONG2CHARS( 0x00000000007FFF80 ),
		LONG2CHARS( 0x00000000007FFFC0 ),
		LONG2CHARS( 0x00000000007FFFE0 ),
		LONG2CHARS( 0x00000000007FFFF0 ),
		LONG2CHARS( 0x00000000007FFFF8 ),
		LONG2CHARS( 0x00000000007FFFFC ),
		LONG2CHARS( 0x00000000007FFFFE ),
		LONG2CHARS( 0x00000000007FFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000200000 ),
		LONG2CHARS( 0x0000000000300000 ),
		LONG2CHARS( 0x0000000000380000 ),
		LONG2CHARS( 0x00000000003C0000 ),
		LONG2CHARS( 0x00000000003E0000 ),
		LONG2CHARS( 0x00000000003F0000 ),
		LONG2CHARS( 0x00000000003F8000 ),
		LONG2CHARS( 0x00000000003FC000 ),
		LONG2CHARS( 0x00000000003FE000 ),
		LONG2CHARS( 0x00000000003FF000 ),
		LONG2CHARS( 0x00000000003FF800 ),
		LONG2CHARS( 0x00000000003FFC00 ),
		LONG2CHARS( 0x00000000003FFE00 ),
		LONG2CHARS( 0x00000000003FFF00 ),
		LONG2CHARS( 0x00000000003FFF80 ),
		LONG2CHARS( 0x00000000003FFFC0 ),
		LONG2CHARS( 0x00000000003FFFE0 ),
		LONG2CHARS( 0x00000000003FFFF0 ),
		LONG2CHARS( 0x00000000003FFFF8 ),
		LONG2CHARS( 0x00000000003FFFFC ),
		LONG2CHARS( 0x00000000003FFFFE ),
		LONG2CHARS( 0x00000000003FFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000100000 ),
		LONG2CHARS( 0x0000000000180000 ),
		LONG2CHARS( 0x00000000001C0000 ),
		LONG2CHARS( 0x00000000001E0000 ),
		LONG2CHARS( 0x00000000001F0000 ),
		LONG2CHARS( 0x00000000001F8000 ),
		LONG2CHARS( 0x00000000001FC000 ),
		LONG2CHARS( 0x00000000001FE000 ),
		LONG2CHARS( 0x00000000001FF000 ),
		LONG2CHARS( 0x00000000001FF800 ),
		LONG2CHARS( 0x00000000001FFC00 ),
		LONG2CHARS( 0x00000000001FFE00 ),
		LONG2CHARS( 0x00000000001FFF00 ),
		LONG2CHARS( 0x00000000001FFF80 ),
		LONG2CHARS( 0x00000000001FFFC0 ),
		LONG2CHARS( 0x00000000001FFFE0 ),
		LONG2CHARS( 0x00000000001FFFF0 ),
		LONG2CHARS( 0x00000000001FFFF8 ),
		LONG2CHARS( 0x00000000001FFFFC ),
		LONG2CHARS( 0x00000000001FFFFE ),
		LONG2CHARS( 0x00000000001FFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000080000 ),
		LONG2CHARS( 0x00000000000C0000 ),
		LONG2CHARS( 0x00000000000E0000 ),
		LONG2CHARS( 0x00000000000F0000 ),
		LONG2CHARS( 0x00000000000F8000 ),
		LONG2CHARS( 0x00000000000FC000 ),
		LONG2CHARS( 0x00000000000FE000 ),
		LONG2CHARS( 0x00000000000FF000 ),
		LONG2CHARS( 0x00000000000FF800 ),
		LONG2CHARS( 0x00000000000FFC00 ),
		LONG2CHARS( 0x00000000000FFE00 ),
		LONG2CHARS( 0x00000000000FFF00 ),
		LONG2CHARS( 0x00000000000FFF80 ),
		LONG2CHARS( 0x00000000000FFFC0 ),
		LONG2CHARS( 0x00000000000FFFE0 ),
		LONG2CHARS( 0x00000000000FFFF0 ),
		LONG2CHARS( 0x00000000000FFFF8 ),
		LONG2CHARS( 0x00000000000FFFFC ),
		LONG2CHARS( 0x00000000000FFFFE ),
		LONG2CHARS( 0x00000000000FFFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000040000 ),
		LONG2CHARS( 0x0000000000060000 ),
		LONG2CHARS( 0x0000000000070000 ),
		LONG2CHARS( 0x0000000000078000 ),
		LONG2CHARS( 0x000000000007C000 ),
		LONG2CHARS( 0x000000000007E000 ),
		LONG2CHARS( 0x000000000007F000 ),
		LONG2CHARS( 0x000000000007F800 ),
		LONG2CHARS( 0x000000000007FC00 ),
		LONG2CHARS( 0x000000000007FE00 ),
		LONG2CHARS( 0x000000000007FF00 ),
		LONG2CHARS( 0x000000000007FF80 ),
		LONG2CHARS( 0x000000000007FFC0 ),
		LONG2CHARS( 0x000000000007FFE0 ),
		LONG2CHARS( 0x000000000007FFF0 ),
		LONG2CHARS( 0x000000000007FFF8 ),
		LONG2CHARS( 0x000000000007FFFC ),
		LONG2CHARS( 0x000000000007FFFE ),
		LONG2CHARS( 0x000000000007FFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000020000 ),
		LONG2CHARS( 0x0000000000030000 ),
		LONG2CHARS( 0x0000000000038000 ),
		LONG2CHARS( 0x000000000003C000 ),
		LONG2CHARS( 0x000000000003E000 ),
		LONG2CHARS( 0x000000000003F000 ),
		LONG2CHARS( 0x000000000003F800 ),
		LONG2CHARS( 0x000000000003FC00 ),
		LONG2CHARS( 0x000000000003FE00 ),
		LONG2CHARS( 0x000000000003FF00 ),
		LONG2CHARS( 0x000000000003FF80 ),
		LONG2CHARS( 0x000000000003FFC0 ),
		LONG2CHARS( 0x000000000003FFE0 ),
		LONG2CHARS( 0x000000000003FFF0 ),
		LONG2CHARS( 0x000000000003FFF8 ),
		LONG2CHARS( 0x000000000003FFFC ),
		LONG2CHARS( 0x000000000003FFFE ),
		LONG2CHARS( 0x000000000003FFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000010000 ),
		LONG2CHARS( 0x0000000000018000 ),
		LONG2CHARS( 0x000000000001C000 ),
		LONG2CHARS( 0x000000000001E000 ),
		LONG2CHARS( 0x000000000001F000 ),
		LONG2CHARS( 0x000000000001F800 ),
		LONG2CHARS( 0x000000000001FC00 ),
		LONG2CHARS( 0x000000000001FE00 ),
		LONG2CHARS( 0x000000000001FF00 ),
		LONG2CHARS( 0x000000000001FF80 ),
		LONG2CHARS( 0x000000000001FFC0 ),
		LONG2CHARS( 0x000000000001FFE0 ),
		LONG2CHARS( 0x000000000001FFF0 ),
		LONG2CHARS( 0x000000000001FFF8 ),
		LONG2CHARS( 0x000000000001FFFC ),
		LONG2CHARS( 0x000000000001FFFE ),
		LONG2CHARS( 0x000000000001FFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000008000 ),
		LONG2CHARS( 0x000000000000C000 ),
		LONG2CHARS( 0x000000000000E000 ),
		LONG2CHARS( 0x000000000000F000 ),
		LONG2CHARS( 0x000000000000F800 ),
		LONG2CHARS( 0x000000000000FC00 ),
		LONG2CHARS( 0x000000000000FE00 ),
		LONG2CHARS( 0x000000000000FF00 ),
		LONG2CHARS( 0x000000000000FF80 ),
		LONG2CHARS( 0x000000000000FFC0 ),
		LONG2CHARS( 0x000000000000FFE0 ),
		LONG2CHARS( 0x000000000000FFF0 ),
		LONG2CHARS( 0x000000000000FFF8 ),
		LONG2CHARS( 0x000000000000FFFC ),
		LONG2CHARS( 0x000000000000FFFE ),
		LONG2CHARS( 0x000000000000FFFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000004000 ),
		LONG2CHARS( 0x0000000000006000 ),
		LONG2CHARS( 0x0000000000007000 ),
		LONG2CHARS( 0x0000000000007800 ),
		LONG2CHARS( 0x0000000000007C00 ),
		LONG2CHARS( 0x0000000000007E00 ),
		LONG2CHARS( 0x0000000000007F00 ),
		LONG2CHARS( 0x0000000000007F80 ),
		LONG2CHARS( 0x0000000000007FC0 ),
		LONG2CHARS( 0x0000000000007FE0 ),
		LONG2CHARS( 0x0000000000007FF0 ),
		LONG2CHARS( 0x0000000000007FF8 ),
		LONG2CHARS( 0x0000000000007FFC ),
		LONG2CHARS( 0x0000000000007FFE ),
		LONG2CHARS( 0x0000000000007FFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000002000 ),
		LONG2CHARS( 0x0000000000003000 ),
		LONG2CHARS( 0x0000000000003800 ),
		LONG2CHARS( 0x0000000000003C00 ),
		LONG2CHARS( 0x0000000000003E00 ),
		LONG2CHARS( 0x0000000000003F00 ),
		LONG2CHARS( 0x0000000000003F80 ),
		LONG2CHARS( 0x0000000000003FC0 ),
		LONG2CHARS( 0x0000000000003FE0 ),
		LONG2CHARS( 0x0000000000003FF0 ),
		LONG2CHARS( 0x0000000000003FF8 ),
		LONG2CHARS( 0x0000000000003FFC ),
		LONG2CHARS( 0x0000000000003FFE ),
		LONG2CHARS( 0x0000000000003FFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000001000 ),
		LONG2CHARS( 0x0000000000001800 ),
		LONG2CHARS( 0x0000000000001C00 ),
		LONG2CHARS( 0x0000000000001E00 ),
		LONG2CHARS( 0x0000000000001F00 ),
		LONG2CHARS( 0x0000000000001F80 ),
		LONG2CHARS( 0x0000000000001FC0 ),
		LONG2CHARS( 0x0000000000001FE0 ),
		LONG2CHARS( 0x0000000000001FF0 ),
		LONG2CHARS( 0x0000000000001FF8 ),
		LONG2CHARS( 0x0000000000001FFC ),
		LONG2CHARS( 0x0000000000001FFE ),
		LONG2CHARS( 0x0000000000001FFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000800 ),
		LONG2CHARS( 0x0000000000000C00 ),
		LONG2CHARS( 0x0000000000000E00 ),
		LONG2CHARS( 0x0000000000000F00 ),
		LONG2CHARS( 0x0000000000000F80 ),
		LONG2CHARS( 0x0000000000000FC0 ),
		LONG2CHARS( 0x0000000000000FE0 ),
		LONG2CHARS( 0x0000000000000FF0 ),
		LONG2CHARS( 0x0000000000000FF8 ),
		LONG2CHARS( 0x0000000000000FFC ),
		LONG2CHARS( 0x0000000000000FFE ),
		LONG2CHARS( 0x0000000000000FFF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000400 ),
		LONG2CHARS( 0x0000000000000600 ),
		LONG2CHARS( 0x0000000000000700 ),
		LONG2CHARS( 0x0000000000000780 ),
		LONG2CHARS( 0x00000000000007C0 ),
		LONG2CHARS( 0x00000000000007E0 ),
		LONG2CHARS( 0x00000000000007F0 ),
		LONG2CHARS( 0x00000000000007F8 ),
		LONG2CHARS( 0x00000000000007FC ),
		LONG2CHARS( 0x00000000000007FE ),
		LONG2CHARS( 0x00000000000007FF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000200 ),
		LONG2CHARS( 0x0000000000000300 ),
		LONG2CHARS( 0x0000000000000380 ),
		LONG2CHARS( 0x00000000000003C0 ),
		LONG2CHARS( 0x00000000000003E0 ),
		LONG2CHARS( 0x00000000000003F0 ),
		LONG2CHARS( 0x00000000000003F8 ),
		LONG2CHARS( 0x00000000000003FC ),
		LONG2CHARS( 0x00000000000003FE ),
		LONG2CHARS( 0x00000000000003FF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000100 ),
		LONG2CHARS( 0x0000000000000180 ),
		LONG2CHARS( 0x00000000000001C0 ),
		LONG2CHARS( 0x00000000000001E0 ),
		LONG2CHARS( 0x00000000000001F0 ),
		LONG2CHARS( 0x00000000000001F8 ),
		LONG2CHARS( 0x00000000000001FC ),
		LONG2CHARS( 0x00000000000001FE ),
		LONG2CHARS( 0x00000000000001FF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000080 ),
		LONG2CHARS( 0x00000000000000C0 ),
		LONG2CHARS( 0x00000000000000E0 ),
		LONG2CHARS( 0x00000000000000F0 ),
		LONG2CHARS( 0x00000000000000F8 ),
		LONG2CHARS( 0x00000000000000FC ),
		LONG2CHARS( 0x00000000000000FE ),
		LONG2CHARS( 0x00000000000000FF ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000040 ),
		LONG2CHARS( 0x0000000000000060 ),
		LONG2CHARS( 0x0000000000000070 ),
		LONG2CHARS( 0x0000000000000078 ),
		LONG2CHARS( 0x000000000000007C ),
		LONG2CHARS( 0x000000000000007E ),
		LONG2CHARS( 0x000000000000007F ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000020 ),
		LONG2CHARS( 0x0000000000000030 ),
		LONG2CHARS( 0x0000000000000038 ),
		LONG2CHARS( 0x000000000000003C ),
		LONG2CHARS( 0x000000000000003E ),
		LONG2CHARS( 0x000000000000003F ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000010 ),
		LONG2CHARS( 0x0000000000000018 ),
		LONG2CHARS( 0x000000000000001C ),
		LONG2CHARS( 0x000000000000001E ),
		LONG2CHARS( 0x000000000000001F ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000008 ),
		LONG2CHARS( 0x000000000000000C ),
		LONG2CHARS( 0x000000000000000E ),
		LONG2CHARS( 0x000000000000000F ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000004 ),
		LONG2CHARS( 0x0000000000000006 ),
		LONG2CHARS( 0x0000000000000007 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000002 ),
		LONG2CHARS( 0x0000000000000003 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000001 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
};
#endif /* PPW */

#else		/* LSBFirst */
/* NOTE:
the first element in starttab could be LONG2CHARS( 0xffffffff.  making it 0
lets us deal with a full first word in the middle loop ), rather
than having to do the multiple reads and masks that we'd
have to do if we thought it was partial.
*/
PixelType starttab[PPW+1] = 
	{
#if PPW == 32
	LONG2CHARS( 0x00000000 ),
	LONG2CHARS( 0xFFFFFFFE ),
	LONG2CHARS( 0xFFFFFFFC ),
	LONG2CHARS( 0xFFFFFFF8 ),
	LONG2CHARS( 0xFFFFFFF0 ),
	LONG2CHARS( 0xFFFFFFE0 ),
	LONG2CHARS( 0xFFFFFFC0 ),
	LONG2CHARS( 0xFFFFFF80 ),
	LONG2CHARS( 0xFFFFFF00 ),
	LONG2CHARS( 0xFFFFFE00 ),
	LONG2CHARS( 0xFFFFFC00 ),
	LONG2CHARS( 0xFFFFF800 ),
	LONG2CHARS( 0xFFFFF000 ),
	LONG2CHARS( 0xFFFFE000 ),
	LONG2CHARS( 0xFFFFC000 ),
	LONG2CHARS( 0xFFFF8000 ),
	LONG2CHARS( 0xFFFF0000 ),
	LONG2CHARS( 0xFFFE0000 ),
	LONG2CHARS( 0xFFFC0000 ),
	LONG2CHARS( 0xFFF80000 ),
	LONG2CHARS( 0xFFF00000 ),
	LONG2CHARS( 0xFFE00000 ),
	LONG2CHARS( 0xFFC00000 ),
	LONG2CHARS( 0xFF800000 ),
	LONG2CHARS( 0xFF000000 ),
	LONG2CHARS( 0xFE000000 ),
	LONG2CHARS( 0xFC000000 ),
	LONG2CHARS( 0xF8000000 ),
	LONG2CHARS( 0xF0000000 ),
	LONG2CHARS( 0xE0000000 ),
	LONG2CHARS( 0xC0000000 ),
	LONG2CHARS( 0x80000000 ),
	LONG2CHARS( 0x00000000 )
#else /* PPW == 64 */
	LONG2CHARS( 0x0000000000000000 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFFFE ),
	LONG2CHARS( 0xFFFFFFFFFFFFFFFC ),
	LONG2CHARS( 0xFFFFFFFFFFFFFFF8 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFFF0 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFFE0 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFFC0 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFF80 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFF00 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFE00 ),
	LONG2CHARS( 0xFFFFFFFFFFFFFC00 ),
	LONG2CHARS( 0xFFFFFFFFFFFFF800 ),
	LONG2CHARS( 0xFFFFFFFFFFFFF000 ),
	LONG2CHARS( 0xFFFFFFFFFFFFE000 ),
	LONG2CHARS( 0xFFFFFFFFFFFFC000 ),
	LONG2CHARS( 0xFFFFFFFFFFFF8000 ),
	LONG2CHARS( 0xFFFFFFFFFFFF0000 ),
	LONG2CHARS( 0xFFFFFFFFFFFE0000 ),
	LONG2CHARS( 0xFFFFFFFFFFFC0000 ),
	LONG2CHARS( 0xFFFFFFFFFFF80000 ),
	LONG2CHARS( 0xFFFFFFFFFFF00000 ),
	LONG2CHARS( 0xFFFFFFFFFFE00000 ),
	LONG2CHARS( 0xFFFFFFFFFFC00000 ),
	LONG2CHARS( 0xFFFFFFFFFF800000 ),
	LONG2CHARS( 0xFFFFFFFFFF000000 ),
	LONG2CHARS( 0xFFFFFFFFFE000000 ),
	LONG2CHARS( 0xFFFFFFFFFC000000 ),
	LONG2CHARS( 0xFFFFFFFFF8000000 ),
	LONG2CHARS( 0xFFFFFFFFF0000000 ),
	LONG2CHARS( 0xFFFFFFFFE0000000 ),
	LONG2CHARS( 0xFFFFFFFFC0000000 ),
	LONG2CHARS( 0xFFFFFFFF80000000 ),
	LONG2CHARS( 0xFFFFFFFF00000000 ),
	LONG2CHARS( 0xFFFFFFFE00000000 ),
	LONG2CHARS( 0xFFFFFFFC00000000 ),
	LONG2CHARS( 0xFFFFFFF800000000 ),
	LONG2CHARS( 0xFFFFFFF000000000 ),
	LONG2CHARS( 0xFFFFFFE000000000 ),
	LONG2CHARS( 0xFFFFFFC000000000 ),
	LONG2CHARS( 0xFFFFFF8000000000 ),
	LONG2CHARS( 0xFFFFFF0000000000 ),
	LONG2CHARS( 0xFFFFFE0000000000 ),
	LONG2CHARS( 0xFFFFFC0000000000 ),
	LONG2CHARS( 0xFFFFF80000000000 ),
	LONG2CHARS( 0xFFFFF00000000000 ),
	LONG2CHARS( 0xFFFFE00000000000 ),
	LONG2CHARS( 0xFFFFC00000000000 ),
	LONG2CHARS( 0xFFFF800000000000 ),
	LONG2CHARS( 0xFFFF000000000000 ),
	LONG2CHARS( 0xFFFE000000000000 ),
	LONG2CHARS( 0xFFFC000000000000 ),
	LONG2CHARS( 0xFFF8000000000000 ),
	LONG2CHARS( 0xFFF0000000000000 ),
	LONG2CHARS( 0xFFE0000000000000 ),
	LONG2CHARS( 0xFFC0000000000000 ),
	LONG2CHARS( 0xFF80000000000000 ),
	LONG2CHARS( 0xFF00000000000000 ),
	LONG2CHARS( 0xFE00000000000000 ),
	LONG2CHARS( 0xFC00000000000000 ),
	LONG2CHARS( 0xF800000000000000 ),
	LONG2CHARS( 0xF000000000000000 ),
	LONG2CHARS( 0xE000000000000000 ),
	LONG2CHARS( 0xC000000000000000 ),
	LONG2CHARS( 0x8000000000000000 ),
	LONG2CHARS( 0x0000000000000000 )
#endif /* PPW */
	};

PixelType endtab[PPW+1] = 
	{
	LONG2CHARS( 0x00000000 ),
	LONG2CHARS( 0x00000001 ),
	LONG2CHARS( 0x00000003 ),
	LONG2CHARS( 0x00000007 ),
	LONG2CHARS( 0x0000000F ),
	LONG2CHARS( 0x0000001F ),
	LONG2CHARS( 0x0000003F ),
	LONG2CHARS( 0x0000007F ),
	LONG2CHARS( 0x000000FF ),
	LONG2CHARS( 0x000001FF ),
	LONG2CHARS( 0x000003FF ),
	LONG2CHARS( 0x000007FF ),
	LONG2CHARS( 0x00000FFF ),
	LONG2CHARS( 0x00001FFF ),
	LONG2CHARS( 0x00003FFF ),
	LONG2CHARS( 0x00007FFF ),
	LONG2CHARS( 0x0000FFFF ),
	LONG2CHARS( 0x0001FFFF ),
	LONG2CHARS( 0x0003FFFF ),
	LONG2CHARS( 0x0007FFFF ),
	LONG2CHARS( 0x000FFFFF ),
	LONG2CHARS( 0x001FFFFF ),
	LONG2CHARS( 0x003FFFFF ),
	LONG2CHARS( 0x007FFFFF ),
	LONG2CHARS( 0x00FFFFFF ),
	LONG2CHARS( 0x01FFFFFF ),
	LONG2CHARS( 0x03FFFFFF ),
	LONG2CHARS( 0x07FFFFFF ),
	LONG2CHARS( 0x0FFFFFFF ),
	LONG2CHARS( 0x1FFFFFFF ),
	LONG2CHARS( 0x3FFFFFFF ),
	LONG2CHARS( 0x7FFFFFFF ),
	LONG2CHARS( 0xFFFFFFFF )
#if PPW == 64
	,
	LONG2CHARS( 0x00000001FFFFFFFF ),
	LONG2CHARS( 0x00000003FFFFFFFF ),
	LONG2CHARS( 0x00000007FFFFFFFF ),
	LONG2CHARS( 0x0000000FFFFFFFFF ),
	LONG2CHARS( 0x0000001FFFFFFFFF ),
	LONG2CHARS( 0x0000003FFFFFFFFF ),
	LONG2CHARS( 0x0000007FFFFFFFFF ),
	LONG2CHARS( 0x000000FFFFFFFFFF ),
	LONG2CHARS( 0x000001FFFFFFFFFF ),
	LONG2CHARS( 0x000003FFFFFFFFFF ),
	LONG2CHARS( 0x000007FFFFFFFFFF ),
	LONG2CHARS( 0x00000FFFFFFFFFFF ),
	LONG2CHARS( 0x00001FFFFFFFFFFF ),
	LONG2CHARS( 0x00003FFFFFFFFFFF ),
	LONG2CHARS( 0x00007FFFFFFFFFFF ),
	LONG2CHARS( 0x0000FFFFFFFFFFFF ),
	LONG2CHARS( 0x0001FFFFFFFFFFFF ),
	LONG2CHARS( 0x0003FFFFFFFFFFFF ),
	LONG2CHARS( 0x0007FFFFFFFFFFFF ),
	LONG2CHARS( 0x000FFFFFFFFFFFFF ),
	LONG2CHARS( 0x001FFFFFFFFFFFFF ),
	LONG2CHARS( 0x003FFFFFFFFFFFFF ),
	LONG2CHARS( 0x007FFFFFFFFFFFFF ),
	LONG2CHARS( 0x00FFFFFFFFFFFFFF ),
	LONG2CHARS( 0x01FFFFFFFFFFFFFF ),
	LONG2CHARS( 0x03FFFFFFFFFFFFFF ),
	LONG2CHARS( 0x07FFFFFFFFFFFFFF ),
	LONG2CHARS( 0x0FFFFFFFFFFFFFFF ),
	LONG2CHARS( 0x1FFFFFFFFFFFFFFF ),
	LONG2CHARS( 0x3FFFFFFFFFFFFFFF ),
	LONG2CHARS( 0x7FFFFFFFFFFFFFFF ),
	LONG2CHARS( 0xFFFFFFFFFFFFFFFF )
#endif /* PPW */
	};

#ifdef NEED_OLD_MFB_MASKS
/* a hack ), for now, since the entries for 0 need to be all
   1 bits ), not all zeros.
   this means the code DOES NOT WORK for segments of length
   0 (which is only a problem in the horizontal line code.)
*/
PixelType startpartial[33] = 
	{
	LONG2CHARS( 0xFFFFFFFF ),
	LONG2CHARS( 0xFFFFFFFE ),
	LONG2CHARS( 0xFFFFFFFC ),
	LONG2CHARS( 0xFFFFFFF8 ),
	LONG2CHARS( 0xFFFFFFF0 ),
	LONG2CHARS( 0xFFFFFFE0 ),
	LONG2CHARS( 0xFFFFFFC0 ),
	LONG2CHARS( 0xFFFFFF80 ),
	LONG2CHARS( 0xFFFFFF00 ),
	LONG2CHARS( 0xFFFFFE00 ),
	LONG2CHARS( 0xFFFFFC00 ),
	LONG2CHARS( 0xFFFFF800 ),
	LONG2CHARS( 0xFFFFF000 ),
	LONG2CHARS( 0xFFFFE000 ),
	LONG2CHARS( 0xFFFFC000 ),
	LONG2CHARS( 0xFFFF8000 ),
	LONG2CHARS( 0xFFFF0000 ),
	LONG2CHARS( 0xFFFE0000 ),
	LONG2CHARS( 0xFFFC0000 ),
	LONG2CHARS( 0xFFF80000 ),
	LONG2CHARS( 0xFFF00000 ),
	LONG2CHARS( 0xFFE00000 ),
	LONG2CHARS( 0xFFC00000 ),
	LONG2CHARS( 0xFF800000 ),
	LONG2CHARS( 0xFF000000 ),
	LONG2CHARS( 0xFE000000 ),
	LONG2CHARS( 0xFC000000 ),
	LONG2CHARS( 0xF8000000 ),
	LONG2CHARS( 0xF0000000 ),
	LONG2CHARS( 0xE0000000 ),
	LONG2CHARS( 0xC0000000 ),
	LONG2CHARS( 0x80000000 ),
	LONG2CHARS( 0x00000000 )
	};

PixelType endpartial[33] = 
	{
	LONG2CHARS( 0xFFFFFFFF ),
	LONG2CHARS( 0x00000001 ),
	LONG2CHARS( 0x00000003 ),
	LONG2CHARS( 0x00000007 ),
	LONG2CHARS( 0x0000000F ),
	LONG2CHARS( 0x0000001F ),
	LONG2CHARS( 0x0000003F ),
	LONG2CHARS( 0x0000007F ),
	LONG2CHARS( 0x000000FF ),
	LONG2CHARS( 0x000001FF ),
	LONG2CHARS( 0x000003FF ),
	LONG2CHARS( 0x000007FF ),
	LONG2CHARS( 0x00000FFF ),
	LONG2CHARS( 0x00001FFF ),
	LONG2CHARS( 0x00003FFF ),
	LONG2CHARS( 0x00007FFF ),
	LONG2CHARS( 0x0000FFFF ),
	LONG2CHARS( 0x0001FFFF ),
	LONG2CHARS( 0x0003FFFF ),
	LONG2CHARS( 0x0007FFFF ),
	LONG2CHARS( 0x000FFFFF ),
	LONG2CHARS( 0x001FFFFF ),
	LONG2CHARS( 0x003FFFFF ),
	LONG2CHARS( 0x007FFFFF ),
	LONG2CHARS( 0x00FFFFFF ),
	LONG2CHARS( 0x01FFFFFF ),
	LONG2CHARS( 0x03FFFFFF ),
	LONG2CHARS( 0x07FFFFFF ),
	LONG2CHARS( 0x0FFFFFFF ),
	LONG2CHARS( 0x1FFFFFFF ),
	LONG2CHARS( 0x3FFFFFFF ),
	LONG2CHARS( 0x7FFFFFFF ),
	LONG2CHARS( 0xFFFFFFFF )
	};
#endif

#if PPW == 32
PixelType partmasks[PPW][PPW] = {
     {LONG2CHARS( 0xFFFFFFFF ), LONG2CHARS( 0x00000001 ), LONG2CHARS( 0x00000003 ), LONG2CHARS( 0x00000007 ),
      LONG2CHARS( 0x0000000F ), LONG2CHARS( 0x0000001F ), LONG2CHARS( 0x0000003F ), LONG2CHARS( 0x0000007F ),
      LONG2CHARS( 0x000000FF ), LONG2CHARS( 0x000001FF ), LONG2CHARS( 0x000003FF ), LONG2CHARS( 0x000007FF ),
      LONG2CHARS( 0x00000FFF ), LONG2CHARS( 0x00001FFF ), LONG2CHARS( 0x00003FFF ), LONG2CHARS( 0x00007FFF ),
      LONG2CHARS( 0x0000FFFF ), LONG2CHARS( 0x0001FFFF ), LONG2CHARS( 0x0003FFFF ), LONG2CHARS( 0x0007FFFF ),
      LONG2CHARS( 0x000FFFFF ), LONG2CHARS( 0x001FFFFF ), LONG2CHARS( 0x003FFFFF ), LONG2CHARS( 0x007FFFFF ),
      LONG2CHARS( 0x00FFFFFF ), LONG2CHARS( 0x01FFFFFF ), LONG2CHARS( 0x03FFFFFF ), LONG2CHARS( 0x07FFFFFF ),
      LONG2CHARS( 0x0FFFFFFF ), LONG2CHARS( 0x1FFFFFFF ), LONG2CHARS( 0x3FFFFFFF ), LONG2CHARS( 0x7FFFFFFF )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000002 ), LONG2CHARS( 0x00000006 ), LONG2CHARS( 0x0000000E ),
      LONG2CHARS( 0x0000001E ), LONG2CHARS( 0x0000003E ), LONG2CHARS( 0x0000007E ), LONG2CHARS( 0x000000FE ),
      LONG2CHARS( 0x000001FE ), LONG2CHARS( 0x000003FE ), LONG2CHARS( 0x000007FE ), LONG2CHARS( 0x00000FFE ),
      LONG2CHARS( 0x00001FFE ), LONG2CHARS( 0x00003FFE ), LONG2CHARS( 0x00007FFE ), LONG2CHARS( 0x0000FFFE ),
      LONG2CHARS( 0x0001FFFE ), LONG2CHARS( 0x0003FFFE ), LONG2CHARS( 0x0007FFFE ), LONG2CHARS( 0x000FFFFE ),
      LONG2CHARS( 0x001FFFFE ), LONG2CHARS( 0x003FFFFE ), LONG2CHARS( 0x007FFFFE ), LONG2CHARS( 0x00FFFFFE ),
      LONG2CHARS( 0x01FFFFFE ), LONG2CHARS( 0x03FFFFFE ), LONG2CHARS( 0x07FFFFFE ), LONG2CHARS( 0x0FFFFFFE ),
      LONG2CHARS( 0x1FFFFFFE ), LONG2CHARS( 0x3FFFFFFE ), LONG2CHARS( 0x7FFFFFFE ), LONG2CHARS( 0xFFFFFFFE )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000004 ), LONG2CHARS( 0x0000000C ), LONG2CHARS( 0x0000001C ),
      LONG2CHARS( 0x0000003C ), LONG2CHARS( 0x0000007C ), LONG2CHARS( 0x000000FC ), LONG2CHARS( 0x000001FC ),
      LONG2CHARS( 0x000003FC ), LONG2CHARS( 0x000007FC ), LONG2CHARS( 0x00000FFC ), LONG2CHARS( 0x00001FFC ),
      LONG2CHARS( 0x00003FFC ), LONG2CHARS( 0x00007FFC ), LONG2CHARS( 0x0000FFFC ), LONG2CHARS( 0x0001FFFC ),
      LONG2CHARS( 0x0003FFFC ), LONG2CHARS( 0x0007FFFC ), LONG2CHARS( 0x000FFFFC ), LONG2CHARS( 0x001FFFFC ),
      LONG2CHARS( 0x003FFFFC ), LONG2CHARS( 0x007FFFFC ), LONG2CHARS( 0x00FFFFFC ), LONG2CHARS( 0x01FFFFFC ),
      LONG2CHARS( 0x03FFFFFC ), LONG2CHARS( 0x07FFFFFC ), LONG2CHARS( 0x0FFFFFFC ), LONG2CHARS( 0x1FFFFFFC ),
      LONG2CHARS( 0x3FFFFFFC ), LONG2CHARS( 0x7FFFFFFC ), LONG2CHARS( 0xFFFFFFFC ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000008 ), LONG2CHARS( 0x00000018 ), LONG2CHARS( 0x00000038 ),
      LONG2CHARS( 0x00000078 ), LONG2CHARS( 0x000000F8 ), LONG2CHARS( 0x000001F8 ), LONG2CHARS( 0x000003F8 ),
      LONG2CHARS( 0x000007F8 ), LONG2CHARS( 0x00000FF8 ), LONG2CHARS( 0x00001FF8 ), LONG2CHARS( 0x00003FF8 ),
      LONG2CHARS( 0X00007FF8 ), LONG2CHARS( 0x0000FFF8 ), LONG2CHARS( 0x0001FFF8 ), LONG2CHARS( 0x0003FFF8 ),
      LONG2CHARS( 0X0007FFF8 ), LONG2CHARS( 0x000FFFF8 ), LONG2CHARS( 0x001FFFF8 ), LONG2CHARS( 0x003FFFF8 ),
      LONG2CHARS( 0X007FFFF8 ), LONG2CHARS( 0x00FFFFF8 ), LONG2CHARS( 0x01FFFFF8 ), LONG2CHARS( 0x03FFFFF8 ),
      LONG2CHARS( 0X07FFFFF8 ), LONG2CHARS( 0x0FFFFFF8 ), LONG2CHARS( 0x1FFFFFF8 ), LONG2CHARS( 0x3FFFFFF8 ),
      LONG2CHARS( 0X7FFFFFF8 ), LONG2CHARS( 0xFFFFFFF8 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000010 ), LONG2CHARS( 0x00000030 ), LONG2CHARS( 0x00000070 ),
      LONG2CHARS( 0X000000F0 ), LONG2CHARS( 0x000001F0 ), LONG2CHARS( 0x000003F0 ), LONG2CHARS( 0x000007F0 ),
      LONG2CHARS( 0X00000FF0 ), LONG2CHARS( 0x00001FF0 ), LONG2CHARS( 0x00003FF0 ), LONG2CHARS( 0x00007FF0 ),
      LONG2CHARS( 0X0000FFF0 ), LONG2CHARS( 0x0001FFF0 ), LONG2CHARS( 0x0003FFF0 ), LONG2CHARS( 0x0007FFF0 ),
      LONG2CHARS( 0X000FFFF0 ), LONG2CHARS( 0x001FFFF0 ), LONG2CHARS( 0x003FFFF0 ), LONG2CHARS( 0x007FFFF0 ),
      LONG2CHARS( 0X00FFFFF0 ), LONG2CHARS( 0x01FFFFF0 ), LONG2CHARS( 0x03FFFFF0 ), LONG2CHARS( 0x07FFFFF0 ),
      LONG2CHARS( 0X0FFFFFF0 ), LONG2CHARS( 0x1FFFFFF0 ), LONG2CHARS( 0x3FFFFFF0 ), LONG2CHARS( 0x7FFFFFF0 ),
      LONG2CHARS( 0XFFFFFFF0 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000020 ), LONG2CHARS( 0x00000060 ), LONG2CHARS( 0x000000E0 ),
      LONG2CHARS( 0X000001E0 ), LONG2CHARS( 0x000003E0 ), LONG2CHARS( 0x000007E0 ), LONG2CHARS( 0x00000FE0 ),
      LONG2CHARS( 0X00001FE0 ), LONG2CHARS( 0x00003FE0 ), LONG2CHARS( 0x00007FE0 ), LONG2CHARS( 0x0000FFE0 ),
      LONG2CHARS( 0X0001FFE0 ), LONG2CHARS( 0x0003FFE0 ), LONG2CHARS( 0x0007FFE0 ), LONG2CHARS( 0x000FFFE0 ),
      LONG2CHARS( 0X001FFFE0 ), LONG2CHARS( 0x003FFFE0 ), LONG2CHARS( 0x007FFFE0 ), LONG2CHARS( 0x00FFFFE0 ),
      LONG2CHARS( 0X01FFFFE0 ), LONG2CHARS( 0x03FFFFE0 ), LONG2CHARS( 0x07FFFFE0 ), LONG2CHARS( 0x0FFFFFE0 ),
      LONG2CHARS( 0X1FFFFFE0 ), LONG2CHARS( 0x3FFFFFE0 ), LONG2CHARS( 0x7FFFFFE0 ), LONG2CHARS( 0xFFFFFFE0 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000040 ), LONG2CHARS( 0x000000C0 ), LONG2CHARS( 0x000001C0 ),
      LONG2CHARS( 0X000003C0 ), LONG2CHARS( 0x000007C0 ), LONG2CHARS( 0x00000FC0 ), LONG2CHARS( 0x00001FC0 ),
      LONG2CHARS( 0X00003FC0 ), LONG2CHARS( 0x00007FC0 ), LONG2CHARS( 0x0000FFC0 ), LONG2CHARS( 0x0001FFC0 ),
      LONG2CHARS( 0X0003FFC0 ), LONG2CHARS( 0x0007FFC0 ), LONG2CHARS( 0x000FFFC0 ), LONG2CHARS( 0x001FFFC0 ),
      LONG2CHARS( 0X003FFFC0 ), LONG2CHARS( 0x007FFFC0 ), LONG2CHARS( 0x00FFFFC0 ), LONG2CHARS( 0x01FFFFC0 ),
      LONG2CHARS( 0X03FFFFC0 ), LONG2CHARS( 0x07FFFFC0 ), LONG2CHARS( 0x0FFFFFC0 ), LONG2CHARS( 0x1FFFFFC0 ),
      LONG2CHARS( 0X3FFFFFC0 ), LONG2CHARS( 0x7FFFFFC0 ), LONG2CHARS( 0xFFFFFFC0 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000080 ), LONG2CHARS( 0x00000180 ), LONG2CHARS( 0x00000380 ),
      LONG2CHARS( 0X00000780 ), LONG2CHARS( 0x00000F80 ), LONG2CHARS( 0x00001F80 ), LONG2CHARS( 0x00003F80 ),
      LONG2CHARS( 0X00007F80 ), LONG2CHARS( 0x0000FF80 ), LONG2CHARS( 0x0001FF80 ), LONG2CHARS( 0x0003FF80 ),
      LONG2CHARS( 0X0007FF80 ), LONG2CHARS( 0x000FFF80 ), LONG2CHARS( 0x001FFF80 ), LONG2CHARS( 0x003FFF80 ),
      LONG2CHARS( 0X007FFF80 ), LONG2CHARS( 0x00FFFF80 ), LONG2CHARS( 0x01FFFF80 ), LONG2CHARS( 0x03FFFF80 ),
      LONG2CHARS( 0X07FFFF80 ), LONG2CHARS( 0x0FFFFF80 ), LONG2CHARS( 0x1FFFFF80 ), LONG2CHARS( 0x3FFFFF80 ),
      LONG2CHARS( 0X7FFFFF80 ), LONG2CHARS( 0xFFFFFF80 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000100 ), LONG2CHARS( 0x00000300 ), LONG2CHARS( 0x00000700 ),
      LONG2CHARS( 0X00000F00 ), LONG2CHARS( 0x00001F00 ), LONG2CHARS( 0x00003F00 ), LONG2CHARS( 0x00007F00 ),
      LONG2CHARS( 0X0000FF00 ), LONG2CHARS( 0x0001FF00 ), LONG2CHARS( 0x0003FF00 ), LONG2CHARS( 0x0007FF00 ),
      LONG2CHARS( 0X000FFF00 ), LONG2CHARS( 0x001FFF00 ), LONG2CHARS( 0x003FFF00 ), LONG2CHARS( 0x007FFF00 ),
      LONG2CHARS( 0X00FFFF00 ), LONG2CHARS( 0x01FFFF00 ), LONG2CHARS( 0x03FFFF00 ), LONG2CHARS( 0x07FFFF00 ),
      LONG2CHARS( 0X0FFFFF00 ), LONG2CHARS( 0x1FFFFF00 ), LONG2CHARS( 0x3FFFFF00 ), LONG2CHARS( 0x7FFFFF00 ),
      LONG2CHARS( 0XFFFFFF00 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000200 ), LONG2CHARS( 0x00000600 ), LONG2CHARS( 0x00000E00 ),
      LONG2CHARS( 0X00001E00 ), LONG2CHARS( 0x00003E00 ), LONG2CHARS( 0x00007E00 ), LONG2CHARS( 0x0000FE00 ),
      LONG2CHARS( 0X0001FE00 ), LONG2CHARS( 0x0003FE00 ), LONG2CHARS( 0x0007FE00 ), LONG2CHARS( 0x000FFE00 ),
      LONG2CHARS( 0X001FFE00 ), LONG2CHARS( 0x003FFE00 ), LONG2CHARS( 0x007FFE00 ), LONG2CHARS( 0x00FFFE00 ),
      LONG2CHARS( 0X01FFFE00 ), LONG2CHARS( 0x03FFFE00 ), LONG2CHARS( 0x07FFFE00 ), LONG2CHARS( 0x0FFFFE00 ),
      LONG2CHARS( 0X1FFFFE00 ), LONG2CHARS( 0x3FFFFE00 ), LONG2CHARS( 0x7FFFFE00 ), LONG2CHARS( 0xFFFFFE00 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000400 ), LONG2CHARS( 0x00000C00 ), LONG2CHARS( 0x00001C00 ),
      LONG2CHARS( 0X00003C00 ), LONG2CHARS( 0x00007C00 ), LONG2CHARS( 0x0000FC00 ), LONG2CHARS( 0x0001FC00 ),
      LONG2CHARS( 0X0003FC00 ), LONG2CHARS( 0x0007FC00 ), LONG2CHARS( 0x000FFC00 ), LONG2CHARS( 0x001FFC00 ),
      LONG2CHARS( 0X003FFC00 ), LONG2CHARS( 0x007FFC00 ), LONG2CHARS( 0x00FFFC00 ), LONG2CHARS( 0x01FFFC00 ),
      LONG2CHARS( 0X03FFFC00 ), LONG2CHARS( 0x07FFFC00 ), LONG2CHARS( 0x0FFFFC00 ), LONG2CHARS( 0x1FFFFC00 ),
      LONG2CHARS( 0X3FFFFC00 ), LONG2CHARS( 0x7FFFFC00 ), LONG2CHARS( 0xFFFFFC00 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000800 ), LONG2CHARS( 0x00001800 ), LONG2CHARS( 0x00003800 ),
      LONG2CHARS( 0X00007800 ), LONG2CHARS( 0x0000F800 ), LONG2CHARS( 0x0001F800 ), LONG2CHARS( 0x0003F800 ),
      LONG2CHARS( 0X0007F800 ), LONG2CHARS( 0x000FF800 ), LONG2CHARS( 0x001FF800 ), LONG2CHARS( 0x003FF800 ),
      LONG2CHARS( 0X007FF800 ), LONG2CHARS( 0x00FFF800 ), LONG2CHARS( 0x01FFF800 ), LONG2CHARS( 0x03FFF800 ),
      LONG2CHARS( 0X07FFF800 ), LONG2CHARS( 0x0FFFF800 ), LONG2CHARS( 0x1FFFF800 ), LONG2CHARS( 0x3FFFF800 ),
      LONG2CHARS( 0X7FFFF800 ), LONG2CHARS( 0xFFFFF800 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00001000 ), LONG2CHARS( 0x00003000 ), LONG2CHARS( 0x00007000 ),
      LONG2CHARS( 0X0000F000 ), LONG2CHARS( 0x0001F000 ), LONG2CHARS( 0x0003F000 ), LONG2CHARS( 0x0007F000 ),
      LONG2CHARS( 0X000FF000 ), LONG2CHARS( 0x001FF000 ), LONG2CHARS( 0x003FF000 ), LONG2CHARS( 0x007FF000 ),
      LONG2CHARS( 0X00FFF000 ), LONG2CHARS( 0x01FFF000 ), LONG2CHARS( 0x03FFF000 ), LONG2CHARS( 0x07FFF000 ),
      LONG2CHARS( 0X0FFFF000 ), LONG2CHARS( 0x1FFFF000 ), LONG2CHARS( 0x3FFFF000 ), LONG2CHARS( 0x7FFFF000 ),
      LONG2CHARS( 0XFFFFF000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00002000 ), LONG2CHARS( 0x00006000 ), LONG2CHARS( 0x0000E000 ),
      LONG2CHARS( 0X0001E000 ), LONG2CHARS( 0x0003E000 ), LONG2CHARS( 0x0007E000 ), LONG2CHARS( 0x000FE000 ),
      LONG2CHARS( 0X001FE000 ), LONG2CHARS( 0x003FE000 ), LONG2CHARS( 0x007FE000 ), LONG2CHARS( 0x00FFE000 ),
      LONG2CHARS( 0X01FFE000 ), LONG2CHARS( 0x03FFE000 ), LONG2CHARS( 0x07FFE000 ), LONG2CHARS( 0x0FFFE000 ),
      LONG2CHARS( 0X1FFFE000 ), LONG2CHARS( 0x3FFFE000 ), LONG2CHARS( 0x7FFFE000 ), LONG2CHARS( 0xFFFFE000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00004000 ), LONG2CHARS( 0x0000C000 ), LONG2CHARS( 0x0001C000 ),
      LONG2CHARS( 0X0003C000 ), LONG2CHARS( 0x0007C000 ), LONG2CHARS( 0x000FC000 ), LONG2CHARS( 0x001FC000 ),
      LONG2CHARS( 0X003FC000 ), LONG2CHARS( 0x007FC000 ), LONG2CHARS( 0x00FFC000 ), LONG2CHARS( 0x01FFC000 ),
      LONG2CHARS( 0X03FFC000 ), LONG2CHARS( 0x07FFC000 ), LONG2CHARS( 0x0FFFC000 ), LONG2CHARS( 0x1FFFC000 ),
      LONG2CHARS( 0X3FFFC000 ), LONG2CHARS( 0x7FFFC000 ), LONG2CHARS( 0xFFFFC000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00008000 ), LONG2CHARS( 0x00018000 ), LONG2CHARS( 0x00038000 ),
      LONG2CHARS( 0X00078000 ), LONG2CHARS( 0x000F8000 ), LONG2CHARS( 0x001F8000 ), LONG2CHARS( 0x003F8000 ),
      LONG2CHARS( 0X007F8000 ), LONG2CHARS( 0x00FF8000 ), LONG2CHARS( 0x01FF8000 ), LONG2CHARS( 0x03FF8000 ),
      LONG2CHARS( 0X07FF8000 ), LONG2CHARS( 0x0FFF8000 ), LONG2CHARS( 0x1FFF8000 ), LONG2CHARS( 0x3FFF8000 ),
      LONG2CHARS( 0X7FFF8000 ), LONG2CHARS( 0xFFFF8000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00010000 ), LONG2CHARS( 0x00030000 ), LONG2CHARS( 0x00070000 ),
      LONG2CHARS( 0X000F0000 ), LONG2CHARS( 0x001F0000 ), LONG2CHARS( 0x003F0000 ), LONG2CHARS( 0x007F0000 ),
      LONG2CHARS( 0X00FF0000 ), LONG2CHARS( 0x01FF0000 ), LONG2CHARS( 0x03FF0000 ), LONG2CHARS( 0x07FF0000 ),
      LONG2CHARS( 0X0FFF0000 ), LONG2CHARS( 0x1FFF0000 ), LONG2CHARS( 0x3FFF0000 ), LONG2CHARS( 0x7FFF0000 ),
      LONG2CHARS( 0XFFFF0000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00020000 ), LONG2CHARS( 0x00060000 ), LONG2CHARS( 0x000E0000 ),
      LONG2CHARS( 0X001E0000 ), LONG2CHARS( 0x003E0000 ), LONG2CHARS( 0x007E0000 ), LONG2CHARS( 0x00FE0000 ),
      LONG2CHARS( 0X01FE0000 ), LONG2CHARS( 0x03FE0000 ), LONG2CHARS( 0x07FE0000 ), LONG2CHARS( 0x0FFE0000 ),
      LONG2CHARS( 0X1FFE0000 ), LONG2CHARS( 0x3FFE0000 ), LONG2CHARS( 0x7FFE0000 ), LONG2CHARS( 0xFFFE0000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00040000 ), LONG2CHARS( 0x000C0000 ), LONG2CHARS( 0x001C0000 ),
      LONG2CHARS( 0X003C0000 ), LONG2CHARS( 0x007C0000 ), LONG2CHARS( 0x00FC0000 ), LONG2CHARS( 0x01FC0000 ),
      LONG2CHARS( 0X03FC0000 ), LONG2CHARS( 0x07FC0000 ), LONG2CHARS( 0x0FFC0000 ), LONG2CHARS( 0x1FFC0000 ),
      LONG2CHARS( 0X3FFC0000 ), LONG2CHARS( 0x7FFC0000 ), LONG2CHARS( 0xFFFC0000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00080000 ), LONG2CHARS( 0x00180000 ), LONG2CHARS( 0x00380000 ),
      LONG2CHARS( 0X00780000 ), LONG2CHARS( 0x00F80000 ), LONG2CHARS( 0x01F80000 ), LONG2CHARS( 0x03F80000 ),
      LONG2CHARS( 0X07F80000 ), LONG2CHARS( 0x0FF80000 ), LONG2CHARS( 0x1FF80000 ), LONG2CHARS( 0x3FF80000 ),
      LONG2CHARS( 0X7FF80000 ), LONG2CHARS( 0xFFF80000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00100000 ), LONG2CHARS( 0x00300000 ), LONG2CHARS( 0x00700000 ),
      LONG2CHARS( 0X00F00000 ), LONG2CHARS( 0x01F00000 ), LONG2CHARS( 0x03F00000 ), LONG2CHARS( 0x07F00000 ),
      LONG2CHARS( 0X0FF00000 ), LONG2CHARS( 0x1FF00000 ), LONG2CHARS( 0x3FF00000 ), LONG2CHARS( 0x7FF00000 ),
      LONG2CHARS( 0XFFF00000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00200000 ), LONG2CHARS( 0x00600000 ), LONG2CHARS( 0x00E00000 ),
      LONG2CHARS( 0X01E00000 ), LONG2CHARS( 0x03E00000 ), LONG2CHARS( 0x07E00000 ), LONG2CHARS( 0x0FE00000 ),
      LONG2CHARS( 0X1FE00000 ), LONG2CHARS( 0x3FE00000 ), LONG2CHARS( 0x7FE00000 ), LONG2CHARS( 0xFFE00000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00400000 ), LONG2CHARS( 0x00C00000 ), LONG2CHARS( 0x01C00000 ),
      LONG2CHARS( 0X03C00000 ), LONG2CHARS( 0x07C00000 ), LONG2CHARS( 0x0FC00000 ), LONG2CHARS( 0x1FC00000 ),
      LONG2CHARS( 0X3FC00000 ), LONG2CHARS( 0x7FC00000 ), LONG2CHARS( 0xFFC00000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00800000 ), LONG2CHARS( 0x01800000 ), LONG2CHARS( 0x03800000 ),
      LONG2CHARS( 0X07800000 ), LONG2CHARS( 0x0F800000 ), LONG2CHARS( 0x1F800000 ), LONG2CHARS( 0x3F800000 ),
      LONG2CHARS( 0X7F800000 ), LONG2CHARS( 0xFF800000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x01000000 ), LONG2CHARS( 0x03000000 ), LONG2CHARS( 0x07000000 ),
      LONG2CHARS( 0X0F000000 ), LONG2CHARS( 0x1F000000 ), LONG2CHARS( 0x3F000000 ), LONG2CHARS( 0x7F000000 ),
      LONG2CHARS( 0XFF000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x02000000 ), LONG2CHARS( 0x06000000 ), LONG2CHARS( 0x0E000000 ),
      LONG2CHARS( 0X1E000000 ), LONG2CHARS( 0x3E000000 ), LONG2CHARS( 0x7E000000 ), LONG2CHARS( 0xFE000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x04000000 ), LONG2CHARS( 0x0C000000 ), LONG2CHARS( 0x1C000000 ),
      LONG2CHARS( 0X3C000000 ), LONG2CHARS( 0x7C000000 ), LONG2CHARS( 0xFC000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x08000000 ), LONG2CHARS( 0x18000000 ), LONG2CHARS( 0x38000000 ),
      LONG2CHARS( 0X78000000 ), LONG2CHARS( 0xF8000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x10000000 ), LONG2CHARS( 0x30000000 ), LONG2CHARS( 0x70000000 ),
      LONG2CHARS( 0XF0000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x20000000 ), LONG2CHARS( 0x60000000 ), LONG2CHARS( 0xE0000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x40000000 ), LONG2CHARS( 0xC0000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
     {LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x80000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ),
      LONG2CHARS( 0X00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 ), LONG2CHARS( 0x00000000 )},
};
#else /* PPW == 64 */
unsigned long partmasks[PPW][PPW] = {
	{
		LONG2CHARS( 0xFFFFFFFFFFFFFFFF ),
		LONG2CHARS( 0x0000000000000001 ),
		LONG2CHARS( 0x0000000000000003 ),
		LONG2CHARS( 0x0000000000000007 ),
		LONG2CHARS( 0x000000000000000F ),
		LONG2CHARS( 0x000000000000001F ),
		LONG2CHARS( 0x000000000000003F ),
		LONG2CHARS( 0x000000000000007F ),
		LONG2CHARS( 0x00000000000000FF ),
		LONG2CHARS( 0x00000000000001FF ),
		LONG2CHARS( 0x00000000000003FF ),
		LONG2CHARS( 0x00000000000007FF ),
		LONG2CHARS( 0x0000000000000FFF ),
		LONG2CHARS( 0x0000000000001FFF ),
		LONG2CHARS( 0x0000000000003FFF ),
		LONG2CHARS( 0x0000000000007FFF ),
		LONG2CHARS( 0x000000000000FFFF ),
		LONG2CHARS( 0x000000000001FFFF ),
		LONG2CHARS( 0x000000000003FFFF ),
		LONG2CHARS( 0x000000000007FFFF ),
		LONG2CHARS( 0x00000000000FFFFF ),
		LONG2CHARS( 0x00000000001FFFFF ),
		LONG2CHARS( 0x00000000003FFFFF ),
		LONG2CHARS( 0x00000000007FFFFF ),
		LONG2CHARS( 0x0000000000FFFFFF ),
		LONG2CHARS( 0x0000000001FFFFFF ),
		LONG2CHARS( 0x0000000003FFFFFF ),
		LONG2CHARS( 0x0000000007FFFFFF ),
		LONG2CHARS( 0x000000000FFFFFFF ),
		LONG2CHARS( 0x000000001FFFFFFF ),
		LONG2CHARS( 0x000000003FFFFFFF ),
		LONG2CHARS( 0x000000007FFFFFFF ),
		LONG2CHARS( 0x00000000FFFFFFFF ),
		LONG2CHARS( 0x00000001FFFFFFFF ),
		LONG2CHARS( 0x00000003FFFFFFFF ),
		LONG2CHARS( 0x00000007FFFFFFFF ),
		LONG2CHARS( 0x0000000FFFFFFFFF ),
		LONG2CHARS( 0x0000001FFFFFFFFF ),
		LONG2CHARS( 0x0000003FFFFFFFFF ),
		LONG2CHARS( 0x0000007FFFFFFFFF ),
		LONG2CHARS( 0x000000FFFFFFFFFF ),
		LONG2CHARS( 0x000001FFFFFFFFFF ),
		LONG2CHARS( 0x000003FFFFFFFFFF ),
		LONG2CHARS( 0x000007FFFFFFFFFF ),
		LONG2CHARS( 0x00000FFFFFFFFFFF ),
		LONG2CHARS( 0x00001FFFFFFFFFFF ),
		LONG2CHARS( 0x00003FFFFFFFFFFF ),
		LONG2CHARS( 0x00007FFFFFFFFFFF ),
		LONG2CHARS( 0x0000FFFFFFFFFFFF ),
		LONG2CHARS( 0x0001FFFFFFFFFFFF ),
		LONG2CHARS( 0x0003FFFFFFFFFFFF ),
		LONG2CHARS( 0x0007FFFFFFFFFFFF ),
		LONG2CHARS( 0x000FFFFFFFFFFFFF ),
		LONG2CHARS( 0x001FFFFFFFFFFFFF ),
		LONG2CHARS( 0x003FFFFFFFFFFFFF ),
		LONG2CHARS( 0x007FFFFFFFFFFFFF ),
		LONG2CHARS( 0x00FFFFFFFFFFFFFF ),
		LONG2CHARS( 0x01FFFFFFFFFFFFFF ),
		LONG2CHARS( 0x03FFFFFFFFFFFFFF ),
		LONG2CHARS( 0x07FFFFFFFFFFFFFF ),
		LONG2CHARS( 0x0FFFFFFFFFFFFFFF ),
		LONG2CHARS( 0x1FFFFFFFFFFFFFFF ),
		LONG2CHARS( 0x3FFFFFFFFFFFFFFF ),
		LONG2CHARS( 0x7FFFFFFFFFFFFFFF ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000002 ),
		LONG2CHARS( 0x0000000000000006 ),
		LONG2CHARS( 0x000000000000000E ),
		LONG2CHARS( 0x000000000000001E ),
		LONG2CHARS( 0x000000000000003E ),
		LONG2CHARS( 0x000000000000007E ),
		LONG2CHARS( 0x00000000000000FE ),
		LONG2CHARS( 0x00000000000001FE ),
		LONG2CHARS( 0x00000000000003FE ),
		LONG2CHARS( 0x00000000000007FE ),
		LONG2CHARS( 0x0000000000000FFE ),
		LONG2CHARS( 0x0000000000001FFE ),
		LONG2CHARS( 0x0000000000003FFE ),
		LONG2CHARS( 0x0000000000007FFE ),
		LONG2CHARS( 0x000000000000FFFE ),
		LONG2CHARS( 0x000000000001FFFE ),
		LONG2CHARS( 0x000000000003FFFE ),
		LONG2CHARS( 0x000000000007FFFE ),
		LONG2CHARS( 0x00000000000FFFFE ),
		LONG2CHARS( 0x00000000001FFFFE ),
		LONG2CHARS( 0x00000000003FFFFE ),
		LONG2CHARS( 0x00000000007FFFFE ),
		LONG2CHARS( 0x0000000000FFFFFE ),
		LONG2CHARS( 0x0000000001FFFFFE ),
		LONG2CHARS( 0x0000000003FFFFFE ),
		LONG2CHARS( 0x0000000007FFFFFE ),
		LONG2CHARS( 0x000000000FFFFFFE ),
		LONG2CHARS( 0x000000001FFFFFFE ),
		LONG2CHARS( 0x000000003FFFFFFE ),
		LONG2CHARS( 0x000000007FFFFFFE ),
		LONG2CHARS( 0x00000000FFFFFFFE ),
		LONG2CHARS( 0x00000001FFFFFFFE ),
		LONG2CHARS( 0x00000003FFFFFFFE ),
		LONG2CHARS( 0x00000007FFFFFFFE ),
		LONG2CHARS( 0x0000000FFFFFFFFE ),
		LONG2CHARS( 0x0000001FFFFFFFFE ),
		LONG2CHARS( 0x0000003FFFFFFFFE ),
		LONG2CHARS( 0x0000007FFFFFFFFE ),
		LONG2CHARS( 0x000000FFFFFFFFFE ),
		LONG2CHARS( 0x000001FFFFFFFFFE ),
		LONG2CHARS( 0x000003FFFFFFFFFE ),
		LONG2CHARS( 0x000007FFFFFFFFFE ),
		LONG2CHARS( 0x00000FFFFFFFFFFE ),
		LONG2CHARS( 0x00001FFFFFFFFFFE ),
		LONG2CHARS( 0x00003FFFFFFFFFFE ),
		LONG2CHARS( 0x00007FFFFFFFFFFE ),
		LONG2CHARS( 0x0000FFFFFFFFFFFE ),
		LONG2CHARS( 0x0001FFFFFFFFFFFE ),
		LONG2CHARS( 0x0003FFFFFFFFFFFE ),
		LONG2CHARS( 0x0007FFFFFFFFFFFE ),
		LONG2CHARS( 0x000FFFFFFFFFFFFE ),
		LONG2CHARS( 0x001FFFFFFFFFFFFE ),
		LONG2CHARS( 0x003FFFFFFFFFFFFE ),
		LONG2CHARS( 0x007FFFFFFFFFFFFE ),
		LONG2CHARS( 0x00FFFFFFFFFFFFFE ),
		LONG2CHARS( 0x01FFFFFFFFFFFFFE ),
		LONG2CHARS( 0x03FFFFFFFFFFFFFE ),
		LONG2CHARS( 0x07FFFFFFFFFFFFFE ),
		LONG2CHARS( 0x0FFFFFFFFFFFFFFE ),
		LONG2CHARS( 0x1FFFFFFFFFFFFFFE ),
		LONG2CHARS( 0x3FFFFFFFFFFFFFFE ),
		LONG2CHARS( 0x7FFFFFFFFFFFFFFE ),
		LONG2CHARS( 0xFFFFFFFFFFFFFFFE ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000004 ),
		LONG2CHARS( 0x000000000000000C ),
		LONG2CHARS( 0x000000000000001C ),
		LONG2CHARS( 0x000000000000003C ),
		LONG2CHARS( 0x000000000000007C ),
		LONG2CHARS( 0x00000000000000FC ),
		LONG2CHARS( 0x00000000000001FC ),
		LONG2CHARS( 0x00000000000003FC ),
		LONG2CHARS( 0x00000000000007FC ),
		LONG2CHARS( 0x0000000000000FFC ),
		LONG2CHARS( 0x0000000000001FFC ),
		LONG2CHARS( 0x0000000000003FFC ),
		LONG2CHARS( 0x0000000000007FFC ),
		LONG2CHARS( 0x000000000000FFFC ),
		LONG2CHARS( 0x000000000001FFFC ),
		LONG2CHARS( 0x000000000003FFFC ),
		LONG2CHARS( 0x000000000007FFFC ),
		LONG2CHARS( 0x00000000000FFFFC ),
		LONG2CHARS( 0x00000000001FFFFC ),
		LONG2CHARS( 0x00000000003FFFFC ),
		LONG2CHARS( 0x00000000007FFFFC ),
		LONG2CHARS( 0x0000000000FFFFFC ),
		LONG2CHARS( 0x0000000001FFFFFC ),
		LONG2CHARS( 0x0000000003FFFFFC ),
		LONG2CHARS( 0x0000000007FFFFFC ),
		LONG2CHARS( 0x000000000FFFFFFC ),
		LONG2CHARS( 0x000000001FFFFFFC ),
		LONG2CHARS( 0x000000003FFFFFFC ),
		LONG2CHARS( 0x000000007FFFFFFC ),
		LONG2CHARS( 0x00000000FFFFFFFC ),
		LONG2CHARS( 0x00000001FFFFFFFC ),
		LONG2CHARS( 0x00000003FFFFFFFC ),
		LONG2CHARS( 0x00000007FFFFFFFC ),
		LONG2CHARS( 0x0000000FFFFFFFFC ),
		LONG2CHARS( 0x0000001FFFFFFFFC ),
		LONG2CHARS( 0x0000003FFFFFFFFC ),
		LONG2CHARS( 0x0000007FFFFFFFFC ),
		LONG2CHARS( 0x000000FFFFFFFFFC ),
		LONG2CHARS( 0x000001FFFFFFFFFC ),
		LONG2CHARS( 0x000003FFFFFFFFFC ),
		LONG2CHARS( 0x000007FFFFFFFFFC ),
		LONG2CHARS( 0x00000FFFFFFFFFFC ),
		LONG2CHARS( 0x00001FFFFFFFFFFC ),
		LONG2CHARS( 0x00003FFFFFFFFFFC ),
		LONG2CHARS( 0x00007FFFFFFFFFFC ),
		LONG2CHARS( 0x0000FFFFFFFFFFFC ),
		LONG2CHARS( 0x0001FFFFFFFFFFFC ),
		LONG2CHARS( 0x0003FFFFFFFFFFFC ),
		LONG2CHARS( 0x0007FFFFFFFFFFFC ),
		LONG2CHARS( 0x000FFFFFFFFFFFFC ),
		LONG2CHARS( 0x001FFFFFFFFFFFFC ),
		LONG2CHARS( 0x003FFFFFFFFFFFFC ),
		LONG2CHARS( 0x007FFFFFFFFFFFFC ),
		LONG2CHARS( 0x00FFFFFFFFFFFFFC ),
		LONG2CHARS( 0x01FFFFFFFFFFFFFC ),
		LONG2CHARS( 0x03FFFFFFFFFFFFFC ),
		LONG2CHARS( 0x07FFFFFFFFFFFFFC ),
		LONG2CHARS( 0x0FFFFFFFFFFFFFFC ),
		LONG2CHARS( 0x1FFFFFFFFFFFFFFC ),
		LONG2CHARS( 0x3FFFFFFFFFFFFFFC ),
		LONG2CHARS( 0x7FFFFFFFFFFFFFFC ),
		LONG2CHARS( 0xFFFFFFFFFFFFFFFC ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000008 ),
		LONG2CHARS( 0x0000000000000018 ),
		LONG2CHARS( 0x0000000000000038 ),
		LONG2CHARS( 0x0000000000000078 ),
		LONG2CHARS( 0x00000000000000F8 ),
		LONG2CHARS( 0x00000000000001F8 ),
		LONG2CHARS( 0x00000000000003F8 ),
		LONG2CHARS( 0x00000000000007F8 ),
		LONG2CHARS( 0x0000000000000FF8 ),
		LONG2CHARS( 0x0000000000001FF8 ),
		LONG2CHARS( 0x0000000000003FF8 ),
		LONG2CHARS( 0x0000000000007FF8 ),
		LONG2CHARS( 0x000000000000FFF8 ),
		LONG2CHARS( 0x000000000001FFF8 ),
		LONG2CHARS( 0x000000000003FFF8 ),
		LONG2CHARS( 0x000000000007FFF8 ),
		LONG2CHARS( 0x00000000000FFFF8 ),
		LONG2CHARS( 0x00000000001FFFF8 ),
		LONG2CHARS( 0x00000000003FFFF8 ),
		LONG2CHARS( 0x00000000007FFFF8 ),
		LONG2CHARS( 0x0000000000FFFFF8 ),
		LONG2CHARS( 0x0000000001FFFFF8 ),
		LONG2CHARS( 0x0000000003FFFFF8 ),
		LONG2CHARS( 0x0000000007FFFFF8 ),
		LONG2CHARS( 0x000000000FFFFFF8 ),
		LONG2CHARS( 0x000000001FFFFFF8 ),
		LONG2CHARS( 0x000000003FFFFFF8 ),
		LONG2CHARS( 0x000000007FFFFFF8 ),
		LONG2CHARS( 0x00000000FFFFFFF8 ),
		LONG2CHARS( 0x00000001FFFFFFF8 ),
		LONG2CHARS( 0x00000003FFFFFFF8 ),
		LONG2CHARS( 0x00000007FFFFFFF8 ),
		LONG2CHARS( 0x0000000FFFFFFFF8 ),
		LONG2CHARS( 0x0000001FFFFFFFF8 ),
		LONG2CHARS( 0x0000003FFFFFFFF8 ),
		LONG2CHARS( 0x0000007FFFFFFFF8 ),
		LONG2CHARS( 0x000000FFFFFFFFF8 ),
		LONG2CHARS( 0x000001FFFFFFFFF8 ),
		LONG2CHARS( 0x000003FFFFFFFFF8 ),
		LONG2CHARS( 0x000007FFFFFFFFF8 ),
		LONG2CHARS( 0x00000FFFFFFFFFF8 ),
		LONG2CHARS( 0x00001FFFFFFFFFF8 ),
		LONG2CHARS( 0x00003FFFFFFFFFF8 ),
		LONG2CHARS( 0x00007FFFFFFFFFF8 ),
		LONG2CHARS( 0x0000FFFFFFFFFFF8 ),
		LONG2CHARS( 0x0001FFFFFFFFFFF8 ),
		LONG2CHARS( 0x0003FFFFFFFFFFF8 ),
		LONG2CHARS( 0x0007FFFFFFFFFFF8 ),
		LONG2CHARS( 0x000FFFFFFFFFFFF8 ),
		LONG2CHARS( 0x001FFFFFFFFFFFF8 ),
		LONG2CHARS( 0x003FFFFFFFFFFFF8 ),
		LONG2CHARS( 0x007FFFFFFFFFFFF8 ),
		LONG2CHARS( 0x00FFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x01FFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x03FFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x07FFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFFF8 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFFF8 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000010 ),
		LONG2CHARS( 0x0000000000000030 ),
		LONG2CHARS( 0x0000000000000070 ),
		LONG2CHARS( 0x00000000000000F0 ),
		LONG2CHARS( 0x00000000000001F0 ),
		LONG2CHARS( 0x00000000000003F0 ),
		LONG2CHARS( 0x00000000000007F0 ),
		LONG2CHARS( 0x0000000000000FF0 ),
		LONG2CHARS( 0x0000000000001FF0 ),
		LONG2CHARS( 0x0000000000003FF0 ),
		LONG2CHARS( 0x0000000000007FF0 ),
		LONG2CHARS( 0x000000000000FFF0 ),
		LONG2CHARS( 0x000000000001FFF0 ),
		LONG2CHARS( 0x000000000003FFF0 ),
		LONG2CHARS( 0x000000000007FFF0 ),
		LONG2CHARS( 0x00000000000FFFF0 ),
		LONG2CHARS( 0x00000000001FFFF0 ),
		LONG2CHARS( 0x00000000003FFFF0 ),
		LONG2CHARS( 0x00000000007FFFF0 ),
		LONG2CHARS( 0x0000000000FFFFF0 ),
		LONG2CHARS( 0x0000000001FFFFF0 ),
		LONG2CHARS( 0x0000000003FFFFF0 ),
		LONG2CHARS( 0x0000000007FFFFF0 ),
		LONG2CHARS( 0x000000000FFFFFF0 ),
		LONG2CHARS( 0x000000001FFFFFF0 ),
		LONG2CHARS( 0x000000003FFFFFF0 ),
		LONG2CHARS( 0x000000007FFFFFF0 ),
		LONG2CHARS( 0x00000000FFFFFFF0 ),
		LONG2CHARS( 0x00000001FFFFFFF0 ),
		LONG2CHARS( 0x00000003FFFFFFF0 ),
		LONG2CHARS( 0x00000007FFFFFFF0 ),
		LONG2CHARS( 0x0000000FFFFFFFF0 ),
		LONG2CHARS( 0x0000001FFFFFFFF0 ),
		LONG2CHARS( 0x0000003FFFFFFFF0 ),
		LONG2CHARS( 0x0000007FFFFFFFF0 ),
		LONG2CHARS( 0x000000FFFFFFFFF0 ),
		LONG2CHARS( 0x000001FFFFFFFFF0 ),
		LONG2CHARS( 0x000003FFFFFFFFF0 ),
		LONG2CHARS( 0x000007FFFFFFFFF0 ),
		LONG2CHARS( 0x00000FFFFFFFFFF0 ),
		LONG2CHARS( 0x00001FFFFFFFFFF0 ),
		LONG2CHARS( 0x00003FFFFFFFFFF0 ),
		LONG2CHARS( 0x00007FFFFFFFFFF0 ),
		LONG2CHARS( 0x0000FFFFFFFFFFF0 ),
		LONG2CHARS( 0x0001FFFFFFFFFFF0 ),
		LONG2CHARS( 0x0003FFFFFFFFFFF0 ),
		LONG2CHARS( 0x0007FFFFFFFFFFF0 ),
		LONG2CHARS( 0x000FFFFFFFFFFFF0 ),
		LONG2CHARS( 0x001FFFFFFFFFFFF0 ),
		LONG2CHARS( 0x003FFFFFFFFFFFF0 ),
		LONG2CHARS( 0x007FFFFFFFFFFFF0 ),
		LONG2CHARS( 0x00FFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x01FFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x03FFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x07FFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFFF0 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFFF0 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000020 ),
		LONG2CHARS( 0x0000000000000060 ),
		LONG2CHARS( 0x00000000000000E0 ),
		LONG2CHARS( 0x00000000000001E0 ),
		LONG2CHARS( 0x00000000000003E0 ),
		LONG2CHARS( 0x00000000000007E0 ),
		LONG2CHARS( 0x0000000000000FE0 ),
		LONG2CHARS( 0x0000000000001FE0 ),
		LONG2CHARS( 0x0000000000003FE0 ),
		LONG2CHARS( 0x0000000000007FE0 ),
		LONG2CHARS( 0x000000000000FFE0 ),
		LONG2CHARS( 0x000000000001FFE0 ),
		LONG2CHARS( 0x000000000003FFE0 ),
		LONG2CHARS( 0x000000000007FFE0 ),
		LONG2CHARS( 0x00000000000FFFE0 ),
		LONG2CHARS( 0x00000000001FFFE0 ),
		LONG2CHARS( 0x00000000003FFFE0 ),
		LONG2CHARS( 0x00000000007FFFE0 ),
		LONG2CHARS( 0x0000000000FFFFE0 ),
		LONG2CHARS( 0x0000000001FFFFE0 ),
		LONG2CHARS( 0x0000000003FFFFE0 ),
		LONG2CHARS( 0x0000000007FFFFE0 ),
		LONG2CHARS( 0x000000000FFFFFE0 ),
		LONG2CHARS( 0x000000001FFFFFE0 ),
		LONG2CHARS( 0x000000003FFFFFE0 ),
		LONG2CHARS( 0x000000007FFFFFE0 ),
		LONG2CHARS( 0x00000000FFFFFFE0 ),
		LONG2CHARS( 0x00000001FFFFFFE0 ),
		LONG2CHARS( 0x00000003FFFFFFE0 ),
		LONG2CHARS( 0x00000007FFFFFFE0 ),
		LONG2CHARS( 0x0000000FFFFFFFE0 ),
		LONG2CHARS( 0x0000001FFFFFFFE0 ),
		LONG2CHARS( 0x0000003FFFFFFFE0 ),
		LONG2CHARS( 0x0000007FFFFFFFE0 ),
		LONG2CHARS( 0x000000FFFFFFFFE0 ),
		LONG2CHARS( 0x000001FFFFFFFFE0 ),
		LONG2CHARS( 0x000003FFFFFFFFE0 ),
		LONG2CHARS( 0x000007FFFFFFFFE0 ),
		LONG2CHARS( 0x00000FFFFFFFFFE0 ),
		LONG2CHARS( 0x00001FFFFFFFFFE0 ),
		LONG2CHARS( 0x00003FFFFFFFFFE0 ),
		LONG2CHARS( 0x00007FFFFFFFFFE0 ),
		LONG2CHARS( 0x0000FFFFFFFFFFE0 ),
		LONG2CHARS( 0x0001FFFFFFFFFFE0 ),
		LONG2CHARS( 0x0003FFFFFFFFFFE0 ),
		LONG2CHARS( 0x0007FFFFFFFFFFE0 ),
		LONG2CHARS( 0x000FFFFFFFFFFFE0 ),
		LONG2CHARS( 0x001FFFFFFFFFFFE0 ),
		LONG2CHARS( 0x003FFFFFFFFFFFE0 ),
		LONG2CHARS( 0x007FFFFFFFFFFFE0 ),
		LONG2CHARS( 0x00FFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x01FFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x03FFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x07FFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFFE0 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFFE0 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000040 ),
		LONG2CHARS( 0x00000000000000C0 ),
		LONG2CHARS( 0x00000000000001C0 ),
		LONG2CHARS( 0x00000000000003C0 ),
		LONG2CHARS( 0x00000000000007C0 ),
		LONG2CHARS( 0x0000000000000FC0 ),
		LONG2CHARS( 0x0000000000001FC0 ),
		LONG2CHARS( 0x0000000000003FC0 ),
		LONG2CHARS( 0x0000000000007FC0 ),
		LONG2CHARS( 0x000000000000FFC0 ),
		LONG2CHARS( 0x000000000001FFC0 ),
		LONG2CHARS( 0x000000000003FFC0 ),
		LONG2CHARS( 0x000000000007FFC0 ),
		LONG2CHARS( 0x00000000000FFFC0 ),
		LONG2CHARS( 0x00000000001FFFC0 ),
		LONG2CHARS( 0x00000000003FFFC0 ),
		LONG2CHARS( 0x00000000007FFFC0 ),
		LONG2CHARS( 0x0000000000FFFFC0 ),
		LONG2CHARS( 0x0000000001FFFFC0 ),
		LONG2CHARS( 0x0000000003FFFFC0 ),
		LONG2CHARS( 0x0000000007FFFFC0 ),
		LONG2CHARS( 0x000000000FFFFFC0 ),
		LONG2CHARS( 0x000000001FFFFFC0 ),
		LONG2CHARS( 0x000000003FFFFFC0 ),
		LONG2CHARS( 0x000000007FFFFFC0 ),
		LONG2CHARS( 0x00000000FFFFFFC0 ),
		LONG2CHARS( 0x00000001FFFFFFC0 ),
		LONG2CHARS( 0x00000003FFFFFFC0 ),
		LONG2CHARS( 0x00000007FFFFFFC0 ),
		LONG2CHARS( 0x0000000FFFFFFFC0 ),
		LONG2CHARS( 0x0000001FFFFFFFC0 ),
		LONG2CHARS( 0x0000003FFFFFFFC0 ),
		LONG2CHARS( 0x0000007FFFFFFFC0 ),
		LONG2CHARS( 0x000000FFFFFFFFC0 ),
		LONG2CHARS( 0x000001FFFFFFFFC0 ),
		LONG2CHARS( 0x000003FFFFFFFFC0 ),
		LONG2CHARS( 0x000007FFFFFFFFC0 ),
		LONG2CHARS( 0x00000FFFFFFFFFC0 ),
		LONG2CHARS( 0x00001FFFFFFFFFC0 ),
		LONG2CHARS( 0x00003FFFFFFFFFC0 ),
		LONG2CHARS( 0x00007FFFFFFFFFC0 ),
		LONG2CHARS( 0x0000FFFFFFFFFFC0 ),
		LONG2CHARS( 0x0001FFFFFFFFFFC0 ),
		LONG2CHARS( 0x0003FFFFFFFFFFC0 ),
		LONG2CHARS( 0x0007FFFFFFFFFFC0 ),
		LONG2CHARS( 0x000FFFFFFFFFFFC0 ),
		LONG2CHARS( 0x001FFFFFFFFFFFC0 ),
		LONG2CHARS( 0x003FFFFFFFFFFFC0 ),
		LONG2CHARS( 0x007FFFFFFFFFFFC0 ),
		LONG2CHARS( 0x00FFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x01FFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x03FFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x07FFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFFC0 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFFC0 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000080 ),
		LONG2CHARS( 0x0000000000000180 ),
		LONG2CHARS( 0x0000000000000380 ),
		LONG2CHARS( 0x0000000000000780 ),
		LONG2CHARS( 0x0000000000000F80 ),
		LONG2CHARS( 0x0000000000001F80 ),
		LONG2CHARS( 0x0000000000003F80 ),
		LONG2CHARS( 0x0000000000007F80 ),
		LONG2CHARS( 0x000000000000FF80 ),
		LONG2CHARS( 0x000000000001FF80 ),
		LONG2CHARS( 0x000000000003FF80 ),
		LONG2CHARS( 0x000000000007FF80 ),
		LONG2CHARS( 0x00000000000FFF80 ),
		LONG2CHARS( 0x00000000001FFF80 ),
		LONG2CHARS( 0x00000000003FFF80 ),
		LONG2CHARS( 0x00000000007FFF80 ),
		LONG2CHARS( 0x0000000000FFFF80 ),
		LONG2CHARS( 0x0000000001FFFF80 ),
		LONG2CHARS( 0x0000000003FFFF80 ),
		LONG2CHARS( 0x0000000007FFFF80 ),
		LONG2CHARS( 0x000000000FFFFF80 ),
		LONG2CHARS( 0x000000001FFFFF80 ),
		LONG2CHARS( 0x000000003FFFFF80 ),
		LONG2CHARS( 0x000000007FFFFF80 ),
		LONG2CHARS( 0x00000000FFFFFF80 ),
		LONG2CHARS( 0x00000001FFFFFF80 ),
		LONG2CHARS( 0x00000003FFFFFF80 ),
		LONG2CHARS( 0x00000007FFFFFF80 ),
		LONG2CHARS( 0x0000000FFFFFFF80 ),
		LONG2CHARS( 0x0000001FFFFFFF80 ),
		LONG2CHARS( 0x0000003FFFFFFF80 ),
		LONG2CHARS( 0x0000007FFFFFFF80 ),
		LONG2CHARS( 0x000000FFFFFFFF80 ),
		LONG2CHARS( 0x000001FFFFFFFF80 ),
		LONG2CHARS( 0x000003FFFFFFFF80 ),
		LONG2CHARS( 0x000007FFFFFFFF80 ),
		LONG2CHARS( 0x00000FFFFFFFFF80 ),
		LONG2CHARS( 0x00001FFFFFFFFF80 ),
		LONG2CHARS( 0x00003FFFFFFFFF80 ),
		LONG2CHARS( 0x00007FFFFFFFFF80 ),
		LONG2CHARS( 0x0000FFFFFFFFFF80 ),
		LONG2CHARS( 0x0001FFFFFFFFFF80 ),
		LONG2CHARS( 0x0003FFFFFFFFFF80 ),
		LONG2CHARS( 0x0007FFFFFFFFFF80 ),
		LONG2CHARS( 0x000FFFFFFFFFFF80 ),
		LONG2CHARS( 0x001FFFFFFFFFFF80 ),
		LONG2CHARS( 0x003FFFFFFFFFFF80 ),
		LONG2CHARS( 0x007FFFFFFFFFFF80 ),
		LONG2CHARS( 0x00FFFFFFFFFFFF80 ),
		LONG2CHARS( 0x01FFFFFFFFFFFF80 ),
		LONG2CHARS( 0x03FFFFFFFFFFFF80 ),
		LONG2CHARS( 0x07FFFFFFFFFFFF80 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFF80 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFF80 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFF80 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFF80 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFF80 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000100 ),
		LONG2CHARS( 0x0000000000000300 ),
		LONG2CHARS( 0x0000000000000700 ),
		LONG2CHARS( 0x0000000000000F00 ),
		LONG2CHARS( 0x0000000000001F00 ),
		LONG2CHARS( 0x0000000000003F00 ),
		LONG2CHARS( 0x0000000000007F00 ),
		LONG2CHARS( 0x000000000000FF00 ),
		LONG2CHARS( 0x000000000001FF00 ),
		LONG2CHARS( 0x000000000003FF00 ),
		LONG2CHARS( 0x000000000007FF00 ),
		LONG2CHARS( 0x00000000000FFF00 ),
		LONG2CHARS( 0x00000000001FFF00 ),
		LONG2CHARS( 0x00000000003FFF00 ),
		LONG2CHARS( 0x00000000007FFF00 ),
		LONG2CHARS( 0x0000000000FFFF00 ),
		LONG2CHARS( 0x0000000001FFFF00 ),
		LONG2CHARS( 0x0000000003FFFF00 ),
		LONG2CHARS( 0x0000000007FFFF00 ),
		LONG2CHARS( 0x000000000FFFFF00 ),
		LONG2CHARS( 0x000000001FFFFF00 ),
		LONG2CHARS( 0x000000003FFFFF00 ),
		LONG2CHARS( 0x000000007FFFFF00 ),
		LONG2CHARS( 0x00000000FFFFFF00 ),
		LONG2CHARS( 0x00000001FFFFFF00 ),
		LONG2CHARS( 0x00000003FFFFFF00 ),
		LONG2CHARS( 0x00000007FFFFFF00 ),
		LONG2CHARS( 0x0000000FFFFFFF00 ),
		LONG2CHARS( 0x0000001FFFFFFF00 ),
		LONG2CHARS( 0x0000003FFFFFFF00 ),
		LONG2CHARS( 0x0000007FFFFFFF00 ),
		LONG2CHARS( 0x000000FFFFFFFF00 ),
		LONG2CHARS( 0x000001FFFFFFFF00 ),
		LONG2CHARS( 0x000003FFFFFFFF00 ),
		LONG2CHARS( 0x000007FFFFFFFF00 ),
		LONG2CHARS( 0x00000FFFFFFFFF00 ),
		LONG2CHARS( 0x00001FFFFFFFFF00 ),
		LONG2CHARS( 0x00003FFFFFFFFF00 ),
		LONG2CHARS( 0x00007FFFFFFFFF00 ),
		LONG2CHARS( 0x0000FFFFFFFFFF00 ),
		LONG2CHARS( 0x0001FFFFFFFFFF00 ),
		LONG2CHARS( 0x0003FFFFFFFFFF00 ),
		LONG2CHARS( 0x0007FFFFFFFFFF00 ),
		LONG2CHARS( 0x000FFFFFFFFFFF00 ),
		LONG2CHARS( 0x001FFFFFFFFFFF00 ),
		LONG2CHARS( 0x003FFFFFFFFFFF00 ),
		LONG2CHARS( 0x007FFFFFFFFFFF00 ),
		LONG2CHARS( 0x00FFFFFFFFFFFF00 ),
		LONG2CHARS( 0x01FFFFFFFFFFFF00 ),
		LONG2CHARS( 0x03FFFFFFFFFFFF00 ),
		LONG2CHARS( 0x07FFFFFFFFFFFF00 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFF00 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFF00 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFF00 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFF00 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFF00 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000200 ),
		LONG2CHARS( 0x0000000000000600 ),
		LONG2CHARS( 0x0000000000000E00 ),
		LONG2CHARS( 0x0000000000001E00 ),
		LONG2CHARS( 0x0000000000003E00 ),
		LONG2CHARS( 0x0000000000007E00 ),
		LONG2CHARS( 0x000000000000FE00 ),
		LONG2CHARS( 0x000000000001FE00 ),
		LONG2CHARS( 0x000000000003FE00 ),
		LONG2CHARS( 0x000000000007FE00 ),
		LONG2CHARS( 0x00000000000FFE00 ),
		LONG2CHARS( 0x00000000001FFE00 ),
		LONG2CHARS( 0x00000000003FFE00 ),
		LONG2CHARS( 0x00000000007FFE00 ),
		LONG2CHARS( 0x0000000000FFFE00 ),
		LONG2CHARS( 0x0000000001FFFE00 ),
		LONG2CHARS( 0x0000000003FFFE00 ),
		LONG2CHARS( 0x0000000007FFFE00 ),
		LONG2CHARS( 0x000000000FFFFE00 ),
		LONG2CHARS( 0x000000001FFFFE00 ),
		LONG2CHARS( 0x000000003FFFFE00 ),
		LONG2CHARS( 0x000000007FFFFE00 ),
		LONG2CHARS( 0x00000000FFFFFE00 ),
		LONG2CHARS( 0x00000001FFFFFE00 ),
		LONG2CHARS( 0x00000003FFFFFE00 ),
		LONG2CHARS( 0x00000007FFFFFE00 ),
		LONG2CHARS( 0x0000000FFFFFFE00 ),
		LONG2CHARS( 0x0000001FFFFFFE00 ),
		LONG2CHARS( 0x0000003FFFFFFE00 ),
		LONG2CHARS( 0x0000007FFFFFFE00 ),
		LONG2CHARS( 0x000000FFFFFFFE00 ),
		LONG2CHARS( 0x000001FFFFFFFE00 ),
		LONG2CHARS( 0x000003FFFFFFFE00 ),
		LONG2CHARS( 0x000007FFFFFFFE00 ),
		LONG2CHARS( 0x00000FFFFFFFFE00 ),
		LONG2CHARS( 0x00001FFFFFFFFE00 ),
		LONG2CHARS( 0x00003FFFFFFFFE00 ),
		LONG2CHARS( 0x00007FFFFFFFFE00 ),
		LONG2CHARS( 0x0000FFFFFFFFFE00 ),
		LONG2CHARS( 0x0001FFFFFFFFFE00 ),
		LONG2CHARS( 0x0003FFFFFFFFFE00 ),
		LONG2CHARS( 0x0007FFFFFFFFFE00 ),
		LONG2CHARS( 0x000FFFFFFFFFFE00 ),
		LONG2CHARS( 0x001FFFFFFFFFFE00 ),
		LONG2CHARS( 0x003FFFFFFFFFFE00 ),
		LONG2CHARS( 0x007FFFFFFFFFFE00 ),
		LONG2CHARS( 0x00FFFFFFFFFFFE00 ),
		LONG2CHARS( 0x01FFFFFFFFFFFE00 ),
		LONG2CHARS( 0x03FFFFFFFFFFFE00 ),
		LONG2CHARS( 0x07FFFFFFFFFFFE00 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFE00 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFE00 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFE00 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFE00 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFE00 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000400 ),
		LONG2CHARS( 0x0000000000000C00 ),
		LONG2CHARS( 0x0000000000001C00 ),
		LONG2CHARS( 0x0000000000003C00 ),
		LONG2CHARS( 0x0000000000007C00 ),
		LONG2CHARS( 0x000000000000FC00 ),
		LONG2CHARS( 0x000000000001FC00 ),
		LONG2CHARS( 0x000000000003FC00 ),
		LONG2CHARS( 0x000000000007FC00 ),
		LONG2CHARS( 0x00000000000FFC00 ),
		LONG2CHARS( 0x00000000001FFC00 ),
		LONG2CHARS( 0x00000000003FFC00 ),
		LONG2CHARS( 0x00000000007FFC00 ),
		LONG2CHARS( 0x0000000000FFFC00 ),
		LONG2CHARS( 0x0000000001FFFC00 ),
		LONG2CHARS( 0x0000000003FFFC00 ),
		LONG2CHARS( 0x0000000007FFFC00 ),
		LONG2CHARS( 0x000000000FFFFC00 ),
		LONG2CHARS( 0x000000001FFFFC00 ),
		LONG2CHARS( 0x000000003FFFFC00 ),
		LONG2CHARS( 0x000000007FFFFC00 ),
		LONG2CHARS( 0x00000000FFFFFC00 ),
		LONG2CHARS( 0x00000001FFFFFC00 ),
		LONG2CHARS( 0x00000003FFFFFC00 ),
		LONG2CHARS( 0x00000007FFFFFC00 ),
		LONG2CHARS( 0x0000000FFFFFFC00 ),
		LONG2CHARS( 0x0000001FFFFFFC00 ),
		LONG2CHARS( 0x0000003FFFFFFC00 ),
		LONG2CHARS( 0x0000007FFFFFFC00 ),
		LONG2CHARS( 0x000000FFFFFFFC00 ),
		LONG2CHARS( 0x000001FFFFFFFC00 ),
		LONG2CHARS( 0x000003FFFFFFFC00 ),
		LONG2CHARS( 0x000007FFFFFFFC00 ),
		LONG2CHARS( 0x00000FFFFFFFFC00 ),
		LONG2CHARS( 0x00001FFFFFFFFC00 ),
		LONG2CHARS( 0x00003FFFFFFFFC00 ),
		LONG2CHARS( 0x00007FFFFFFFFC00 ),
		LONG2CHARS( 0x0000FFFFFFFFFC00 ),
		LONG2CHARS( 0x0001FFFFFFFFFC00 ),
		LONG2CHARS( 0x0003FFFFFFFFFC00 ),
		LONG2CHARS( 0x0007FFFFFFFFFC00 ),
		LONG2CHARS( 0x000FFFFFFFFFFC00 ),
		LONG2CHARS( 0x001FFFFFFFFFFC00 ),
		LONG2CHARS( 0x003FFFFFFFFFFC00 ),
		LONG2CHARS( 0x007FFFFFFFFFFC00 ),
		LONG2CHARS( 0x00FFFFFFFFFFFC00 ),
		LONG2CHARS( 0x01FFFFFFFFFFFC00 ),
		LONG2CHARS( 0x03FFFFFFFFFFFC00 ),
		LONG2CHARS( 0x07FFFFFFFFFFFC00 ),
		LONG2CHARS( 0x0FFFFFFFFFFFFC00 ),
		LONG2CHARS( 0x1FFFFFFFFFFFFC00 ),
		LONG2CHARS( 0x3FFFFFFFFFFFFC00 ),
		LONG2CHARS( 0x7FFFFFFFFFFFFC00 ),
		LONG2CHARS( 0xFFFFFFFFFFFFFC00 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000800 ),
		LONG2CHARS( 0x0000000000001800 ),
		LONG2CHARS( 0x0000000000003800 ),
		LONG2CHARS( 0x0000000000007800 ),
		LONG2CHARS( 0x000000000000F800 ),
		LONG2CHARS( 0x000000000001F800 ),
		LONG2CHARS( 0x000000000003F800 ),
		LONG2CHARS( 0x000000000007F800 ),
		LONG2CHARS( 0x00000000000FF800 ),
		LONG2CHARS( 0x00000000001FF800 ),
		LONG2CHARS( 0x00000000003FF800 ),
		LONG2CHARS( 0x00000000007FF800 ),
		LONG2CHARS( 0x0000000000FFF800 ),
		LONG2CHARS( 0x0000000001FFF800 ),
		LONG2CHARS( 0x0000000003FFF800 ),
		LONG2CHARS( 0x0000000007FFF800 ),
		LONG2CHARS( 0x000000000FFFF800 ),
		LONG2CHARS( 0x000000001FFFF800 ),
		LONG2CHARS( 0x000000003FFFF800 ),
		LONG2CHARS( 0x000000007FFFF800 ),
		LONG2CHARS( 0x00000000FFFFF800 ),
		LONG2CHARS( 0x00000001FFFFF800 ),
		LONG2CHARS( 0x00000003FFFFF800 ),
		LONG2CHARS( 0x00000007FFFFF800 ),
		LONG2CHARS( 0x0000000FFFFFF800 ),
		LONG2CHARS( 0x0000001FFFFFF800 ),
		LONG2CHARS( 0x0000003FFFFFF800 ),
		LONG2CHARS( 0x0000007FFFFFF800 ),
		LONG2CHARS( 0x000000FFFFFFF800 ),
		LONG2CHARS( 0x000001FFFFFFF800 ),
		LONG2CHARS( 0x000003FFFFFFF800 ),
		LONG2CHARS( 0x000007FFFFFFF800 ),
		LONG2CHARS( 0x00000FFFFFFFF800 ),
		LONG2CHARS( 0x00001FFFFFFFF800 ),
		LONG2CHARS( 0x00003FFFFFFFF800 ),
		LONG2CHARS( 0x00007FFFFFFFF800 ),
		LONG2CHARS( 0x0000FFFFFFFFF800 ),
		LONG2CHARS( 0x0001FFFFFFFFF800 ),
		LONG2CHARS( 0x0003FFFFFFFFF800 ),
		LONG2CHARS( 0x0007FFFFFFFFF800 ),
		LONG2CHARS( 0x000FFFFFFFFFF800 ),
		LONG2CHARS( 0x001FFFFFFFFFF800 ),
		LONG2CHARS( 0x003FFFFFFFFFF800 ),
		LONG2CHARS( 0x007FFFFFFFFFF800 ),
		LONG2CHARS( 0x00FFFFFFFFFFF800 ),
		LONG2CHARS( 0x01FFFFFFFFFFF800 ),
		LONG2CHARS( 0x03FFFFFFFFFFF800 ),
		LONG2CHARS( 0x07FFFFFFFFFFF800 ),
		LONG2CHARS( 0x0FFFFFFFFFFFF800 ),
		LONG2CHARS( 0x1FFFFFFFFFFFF800 ),
		LONG2CHARS( 0x3FFFFFFFFFFFF800 ),
		LONG2CHARS( 0x7FFFFFFFFFFFF800 ),
		LONG2CHARS( 0xFFFFFFFFFFFFF800 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000001000 ),
		LONG2CHARS( 0x0000000000003000 ),
		LONG2CHARS( 0x0000000000007000 ),
		LONG2CHARS( 0x000000000000F000 ),
		LONG2CHARS( 0x000000000001F000 ),
		LONG2CHARS( 0x000000000003F000 ),
		LONG2CHARS( 0x000000000007F000 ),
		LONG2CHARS( 0x00000000000FF000 ),
		LONG2CHARS( 0x00000000001FF000 ),
		LONG2CHARS( 0x00000000003FF000 ),
		LONG2CHARS( 0x00000000007FF000 ),
		LONG2CHARS( 0x0000000000FFF000 ),
		LONG2CHARS( 0x0000000001FFF000 ),
		LONG2CHARS( 0x0000000003FFF000 ),
		LONG2CHARS( 0x0000000007FFF000 ),
		LONG2CHARS( 0x000000000FFFF000 ),
		LONG2CHARS( 0x000000001FFFF000 ),
		LONG2CHARS( 0x000000003FFFF000 ),
		LONG2CHARS( 0x000000007FFFF000 ),
		LONG2CHARS( 0x00000000FFFFF000 ),
		LONG2CHARS( 0x00000001FFFFF000 ),
		LONG2CHARS( 0x00000003FFFFF000 ),
		LONG2CHARS( 0x00000007FFFFF000 ),
		LONG2CHARS( 0x0000000FFFFFF000 ),
		LONG2CHARS( 0x0000001FFFFFF000 ),
		LONG2CHARS( 0x0000003FFFFFF000 ),
		LONG2CHARS( 0x0000007FFFFFF000 ),
		LONG2CHARS( 0x000000FFFFFFF000 ),
		LONG2CHARS( 0x000001FFFFFFF000 ),
		LONG2CHARS( 0x000003FFFFFFF000 ),
		LONG2CHARS( 0x000007FFFFFFF000 ),
		LONG2CHARS( 0x00000FFFFFFFF000 ),
		LONG2CHARS( 0x00001FFFFFFFF000 ),
		LONG2CHARS( 0x00003FFFFFFFF000 ),
		LONG2CHARS( 0x00007FFFFFFFF000 ),
		LONG2CHARS( 0x0000FFFFFFFFF000 ),
		LONG2CHARS( 0x0001FFFFFFFFF000 ),
		LONG2CHARS( 0x0003FFFFFFFFF000 ),
		LONG2CHARS( 0x0007FFFFFFFFF000 ),
		LONG2CHARS( 0x000FFFFFFFFFF000 ),
		LONG2CHARS( 0x001FFFFFFFFFF000 ),
		LONG2CHARS( 0x003FFFFFFFFFF000 ),
		LONG2CHARS( 0x007FFFFFFFFFF000 ),
		LONG2CHARS( 0x00FFFFFFFFFFF000 ),
		LONG2CHARS( 0x01FFFFFFFFFFF000 ),
		LONG2CHARS( 0x03FFFFFFFFFFF000 ),
		LONG2CHARS( 0x07FFFFFFFFFFF000 ),
		LONG2CHARS( 0x0FFFFFFFFFFFF000 ),
		LONG2CHARS( 0x1FFFFFFFFFFFF000 ),
		LONG2CHARS( 0x3FFFFFFFFFFFF000 ),
		LONG2CHARS( 0x7FFFFFFFFFFFF000 ),
		LONG2CHARS( 0xFFFFFFFFFFFFF000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000002000 ),
		LONG2CHARS( 0x0000000000006000 ),
		LONG2CHARS( 0x000000000000E000 ),
		LONG2CHARS( 0x000000000001E000 ),
		LONG2CHARS( 0x000000000003E000 ),
		LONG2CHARS( 0x000000000007E000 ),
		LONG2CHARS( 0x00000000000FE000 ),
		LONG2CHARS( 0x00000000001FE000 ),
		LONG2CHARS( 0x00000000003FE000 ),
		LONG2CHARS( 0x00000000007FE000 ),
		LONG2CHARS( 0x0000000000FFE000 ),
		LONG2CHARS( 0x0000000001FFE000 ),
		LONG2CHARS( 0x0000000003FFE000 ),
		LONG2CHARS( 0x0000000007FFE000 ),
		LONG2CHARS( 0x000000000FFFE000 ),
		LONG2CHARS( 0x000000001FFFE000 ),
		LONG2CHARS( 0x000000003FFFE000 ),
		LONG2CHARS( 0x000000007FFFE000 ),
		LONG2CHARS( 0x00000000FFFFE000 ),
		LONG2CHARS( 0x00000001FFFFE000 ),
		LONG2CHARS( 0x00000003FFFFE000 ),
		LONG2CHARS( 0x00000007FFFFE000 ),
		LONG2CHARS( 0x0000000FFFFFE000 ),
		LONG2CHARS( 0x0000001FFFFFE000 ),
		LONG2CHARS( 0x0000003FFFFFE000 ),
		LONG2CHARS( 0x0000007FFFFFE000 ),
		LONG2CHARS( 0x000000FFFFFFE000 ),
		LONG2CHARS( 0x000001FFFFFFE000 ),
		LONG2CHARS( 0x000003FFFFFFE000 ),
		LONG2CHARS( 0x000007FFFFFFE000 ),
		LONG2CHARS( 0x00000FFFFFFFE000 ),
		LONG2CHARS( 0x00001FFFFFFFE000 ),
		LONG2CHARS( 0x00003FFFFFFFE000 ),
		LONG2CHARS( 0x00007FFFFFFFE000 ),
		LONG2CHARS( 0x0000FFFFFFFFE000 ),
		LONG2CHARS( 0x0001FFFFFFFFE000 ),
		LONG2CHARS( 0x0003FFFFFFFFE000 ),
		LONG2CHARS( 0x0007FFFFFFFFE000 ),
		LONG2CHARS( 0x000FFFFFFFFFE000 ),
		LONG2CHARS( 0x001FFFFFFFFFE000 ),
		LONG2CHARS( 0x003FFFFFFFFFE000 ),
		LONG2CHARS( 0x007FFFFFFFFFE000 ),
		LONG2CHARS( 0x00FFFFFFFFFFE000 ),
		LONG2CHARS( 0x01FFFFFFFFFFE000 ),
		LONG2CHARS( 0x03FFFFFFFFFFE000 ),
		LONG2CHARS( 0x07FFFFFFFFFFE000 ),
		LONG2CHARS( 0x0FFFFFFFFFFFE000 ),
		LONG2CHARS( 0x1FFFFFFFFFFFE000 ),
		LONG2CHARS( 0x3FFFFFFFFFFFE000 ),
		LONG2CHARS( 0x7FFFFFFFFFFFE000 ),
		LONG2CHARS( 0xFFFFFFFFFFFFE000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000004000 ),
		LONG2CHARS( 0x000000000000C000 ),
		LONG2CHARS( 0x000000000001C000 ),
		LONG2CHARS( 0x000000000003C000 ),
		LONG2CHARS( 0x000000000007C000 ),
		LONG2CHARS( 0x00000000000FC000 ),
		LONG2CHARS( 0x00000000001FC000 ),
		LONG2CHARS( 0x00000000003FC000 ),
		LONG2CHARS( 0x00000000007FC000 ),
		LONG2CHARS( 0x0000000000FFC000 ),
		LONG2CHARS( 0x0000000001FFC000 ),
		LONG2CHARS( 0x0000000003FFC000 ),
		LONG2CHARS( 0x0000000007FFC000 ),
		LONG2CHARS( 0x000000000FFFC000 ),
		LONG2CHARS( 0x000000001FFFC000 ),
		LONG2CHARS( 0x000000003FFFC000 ),
		LONG2CHARS( 0x000000007FFFC000 ),
		LONG2CHARS( 0x00000000FFFFC000 ),
		LONG2CHARS( 0x00000001FFFFC000 ),
		LONG2CHARS( 0x00000003FFFFC000 ),
		LONG2CHARS( 0x00000007FFFFC000 ),
		LONG2CHARS( 0x0000000FFFFFC000 ),
		LONG2CHARS( 0x0000001FFFFFC000 ),
		LONG2CHARS( 0x0000003FFFFFC000 ),
		LONG2CHARS( 0x0000007FFFFFC000 ),
		LONG2CHARS( 0x000000FFFFFFC000 ),
		LONG2CHARS( 0x000001FFFFFFC000 ),
		LONG2CHARS( 0x000003FFFFFFC000 ),
		LONG2CHARS( 0x000007FFFFFFC000 ),
		LONG2CHARS( 0x00000FFFFFFFC000 ),
		LONG2CHARS( 0x00001FFFFFFFC000 ),
		LONG2CHARS( 0x00003FFFFFFFC000 ),
		LONG2CHARS( 0x00007FFFFFFFC000 ),
		LONG2CHARS( 0x0000FFFFFFFFC000 ),
		LONG2CHARS( 0x0001FFFFFFFFC000 ),
		LONG2CHARS( 0x0003FFFFFFFFC000 ),
		LONG2CHARS( 0x0007FFFFFFFFC000 ),
		LONG2CHARS( 0x000FFFFFFFFFC000 ),
		LONG2CHARS( 0x001FFFFFFFFFC000 ),
		LONG2CHARS( 0x003FFFFFFFFFC000 ),
		LONG2CHARS( 0x007FFFFFFFFFC000 ),
		LONG2CHARS( 0x00FFFFFFFFFFC000 ),
		LONG2CHARS( 0x01FFFFFFFFFFC000 ),
		LONG2CHARS( 0x03FFFFFFFFFFC000 ),
		LONG2CHARS( 0x07FFFFFFFFFFC000 ),
		LONG2CHARS( 0x0FFFFFFFFFFFC000 ),
		LONG2CHARS( 0x1FFFFFFFFFFFC000 ),
		LONG2CHARS( 0x3FFFFFFFFFFFC000 ),
		LONG2CHARS( 0x7FFFFFFFFFFFC000 ),
		LONG2CHARS( 0xFFFFFFFFFFFFC000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000008000 ),
		LONG2CHARS( 0x0000000000018000 ),
		LONG2CHARS( 0x0000000000038000 ),
		LONG2CHARS( 0x0000000000078000 ),
		LONG2CHARS( 0x00000000000F8000 ),
		LONG2CHARS( 0x00000000001F8000 ),
		LONG2CHARS( 0x00000000003F8000 ),
		LONG2CHARS( 0x00000000007F8000 ),
		LONG2CHARS( 0x0000000000FF8000 ),
		LONG2CHARS( 0x0000000001FF8000 ),
		LONG2CHARS( 0x0000000003FF8000 ),
		LONG2CHARS( 0x0000000007FF8000 ),
		LONG2CHARS( 0x000000000FFF8000 ),
		LONG2CHARS( 0x000000001FFF8000 ),
		LONG2CHARS( 0x000000003FFF8000 ),
		LONG2CHARS( 0x000000007FFF8000 ),
		LONG2CHARS( 0x00000000FFFF8000 ),
		LONG2CHARS( 0x00000001FFFF8000 ),
		LONG2CHARS( 0x00000003FFFF8000 ),
		LONG2CHARS( 0x00000007FFFF8000 ),
		LONG2CHARS( 0x0000000FFFFF8000 ),
		LONG2CHARS( 0x0000001FFFFF8000 ),
		LONG2CHARS( 0x0000003FFFFF8000 ),
		LONG2CHARS( 0x0000007FFFFF8000 ),
		LONG2CHARS( 0x000000FFFFFF8000 ),
		LONG2CHARS( 0x000001FFFFFF8000 ),
		LONG2CHARS( 0x000003FFFFFF8000 ),
		LONG2CHARS( 0x000007FFFFFF8000 ),
		LONG2CHARS( 0x00000FFFFFFF8000 ),
		LONG2CHARS( 0x00001FFFFFFF8000 ),
		LONG2CHARS( 0x00003FFFFFFF8000 ),
		LONG2CHARS( 0x00007FFFFFFF8000 ),
		LONG2CHARS( 0x0000FFFFFFFF8000 ),
		LONG2CHARS( 0x0001FFFFFFFF8000 ),
		LONG2CHARS( 0x0003FFFFFFFF8000 ),
		LONG2CHARS( 0x0007FFFFFFFF8000 ),
		LONG2CHARS( 0x000FFFFFFFFF8000 ),
		LONG2CHARS( 0x001FFFFFFFFF8000 ),
		LONG2CHARS( 0x003FFFFFFFFF8000 ),
		LONG2CHARS( 0x007FFFFFFFFF8000 ),
		LONG2CHARS( 0x00FFFFFFFFFF8000 ),
		LONG2CHARS( 0x01FFFFFFFFFF8000 ),
		LONG2CHARS( 0x03FFFFFFFFFF8000 ),
		LONG2CHARS( 0x07FFFFFFFFFF8000 ),
		LONG2CHARS( 0x0FFFFFFFFFFF8000 ),
		LONG2CHARS( 0x1FFFFFFFFFFF8000 ),
		LONG2CHARS( 0x3FFFFFFFFFFF8000 ),
		LONG2CHARS( 0x7FFFFFFFFFFF8000 ),
		LONG2CHARS( 0xFFFFFFFFFFFF8000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000010000 ),
		LONG2CHARS( 0x0000000000030000 ),
		LONG2CHARS( 0x0000000000070000 ),
		LONG2CHARS( 0x00000000000F0000 ),
		LONG2CHARS( 0x00000000001F0000 ),
		LONG2CHARS( 0x00000000003F0000 ),
		LONG2CHARS( 0x00000000007F0000 ),
		LONG2CHARS( 0x0000000000FF0000 ),
		LONG2CHARS( 0x0000000001FF0000 ),
		LONG2CHARS( 0x0000000003FF0000 ),
		LONG2CHARS( 0x0000000007FF0000 ),
		LONG2CHARS( 0x000000000FFF0000 ),
		LONG2CHARS( 0x000000001FFF0000 ),
		LONG2CHARS( 0x000000003FFF0000 ),
		LONG2CHARS( 0x000000007FFF0000 ),
		LONG2CHARS( 0x00000000FFFF0000 ),
		LONG2CHARS( 0x00000001FFFF0000 ),
		LONG2CHARS( 0x00000003FFFF0000 ),
		LONG2CHARS( 0x00000007FFFF0000 ),
		LONG2CHARS( 0x0000000FFFFF0000 ),
		LONG2CHARS( 0x0000001FFFFF0000 ),
		LONG2CHARS( 0x0000003FFFFF0000 ),
		LONG2CHARS( 0x0000007FFFFF0000 ),
		LONG2CHARS( 0x000000FFFFFF0000 ),
		LONG2CHARS( 0x000001FFFFFF0000 ),
		LONG2CHARS( 0x000003FFFFFF0000 ),
		LONG2CHARS( 0x000007FFFFFF0000 ),
		LONG2CHARS( 0x00000FFFFFFF0000 ),
		LONG2CHARS( 0x00001FFFFFFF0000 ),
		LONG2CHARS( 0x00003FFFFFFF0000 ),
		LONG2CHARS( 0x00007FFFFFFF0000 ),
		LONG2CHARS( 0x0000FFFFFFFF0000 ),
		LONG2CHARS( 0x0001FFFFFFFF0000 ),
		LONG2CHARS( 0x0003FFFFFFFF0000 ),
		LONG2CHARS( 0x0007FFFFFFFF0000 ),
		LONG2CHARS( 0x000FFFFFFFFF0000 ),
		LONG2CHARS( 0x001FFFFFFFFF0000 ),
		LONG2CHARS( 0x003FFFFFFFFF0000 ),
		LONG2CHARS( 0x007FFFFFFFFF0000 ),
		LONG2CHARS( 0x00FFFFFFFFFF0000 ),
		LONG2CHARS( 0x01FFFFFFFFFF0000 ),
		LONG2CHARS( 0x03FFFFFFFFFF0000 ),
		LONG2CHARS( 0x07FFFFFFFFFF0000 ),
		LONG2CHARS( 0x0FFFFFFFFFFF0000 ),
		LONG2CHARS( 0x1FFFFFFFFFFF0000 ),
		LONG2CHARS( 0x3FFFFFFFFFFF0000 ),
		LONG2CHARS( 0x7FFFFFFFFFFF0000 ),
		LONG2CHARS( 0xFFFFFFFFFFFF0000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000020000 ),
		LONG2CHARS( 0x0000000000060000 ),
		LONG2CHARS( 0x00000000000E0000 ),
		LONG2CHARS( 0x00000000001E0000 ),
		LONG2CHARS( 0x00000000003E0000 ),
		LONG2CHARS( 0x00000000007E0000 ),
		LONG2CHARS( 0x0000000000FE0000 ),
		LONG2CHARS( 0x0000000001FE0000 ),
		LONG2CHARS( 0x0000000003FE0000 ),
		LONG2CHARS( 0x0000000007FE0000 ),
		LONG2CHARS( 0x000000000FFE0000 ),
		LONG2CHARS( 0x000000001FFE0000 ),
		LONG2CHARS( 0x000000003FFE0000 ),
		LONG2CHARS( 0x000000007FFE0000 ),
		LONG2CHARS( 0x00000000FFFE0000 ),
		LONG2CHARS( 0x00000001FFFE0000 ),
		LONG2CHARS( 0x00000003FFFE0000 ),
		LONG2CHARS( 0x00000007FFFE0000 ),
		LONG2CHARS( 0x0000000FFFFE0000 ),
		LONG2CHARS( 0x0000001FFFFE0000 ),
		LONG2CHARS( 0x0000003FFFFE0000 ),
		LONG2CHARS( 0x0000007FFFFE0000 ),
		LONG2CHARS( 0x000000FFFFFE0000 ),
		LONG2CHARS( 0x000001FFFFFE0000 ),
		LONG2CHARS( 0x000003FFFFFE0000 ),
		LONG2CHARS( 0x000007FFFFFE0000 ),
		LONG2CHARS( 0x00000FFFFFFE0000 ),
		LONG2CHARS( 0x00001FFFFFFE0000 ),
		LONG2CHARS( 0x00003FFFFFFE0000 ),
		LONG2CHARS( 0x00007FFFFFFE0000 ),
		LONG2CHARS( 0x0000FFFFFFFE0000 ),
		LONG2CHARS( 0x0001FFFFFFFE0000 ),
		LONG2CHARS( 0x0003FFFFFFFE0000 ),
		LONG2CHARS( 0x0007FFFFFFFE0000 ),
		LONG2CHARS( 0x000FFFFFFFFE0000 ),
		LONG2CHARS( 0x001FFFFFFFFE0000 ),
		LONG2CHARS( 0x003FFFFFFFFE0000 ),
		LONG2CHARS( 0x007FFFFFFFFE0000 ),
		LONG2CHARS( 0x00FFFFFFFFFE0000 ),
		LONG2CHARS( 0x01FFFFFFFFFE0000 ),
		LONG2CHARS( 0x03FFFFFFFFFE0000 ),
		LONG2CHARS( 0x07FFFFFFFFFE0000 ),
		LONG2CHARS( 0x0FFFFFFFFFFE0000 ),
		LONG2CHARS( 0x1FFFFFFFFFFE0000 ),
		LONG2CHARS( 0x3FFFFFFFFFFE0000 ),
		LONG2CHARS( 0x7FFFFFFFFFFE0000 ),
		LONG2CHARS( 0xFFFFFFFFFFFE0000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000040000 ),
		LONG2CHARS( 0x00000000000C0000 ),
		LONG2CHARS( 0x00000000001C0000 ),
		LONG2CHARS( 0x00000000003C0000 ),
		LONG2CHARS( 0x00000000007C0000 ),
		LONG2CHARS( 0x0000000000FC0000 ),
		LONG2CHARS( 0x0000000001FC0000 ),
		LONG2CHARS( 0x0000000003FC0000 ),
		LONG2CHARS( 0x0000000007FC0000 ),
		LONG2CHARS( 0x000000000FFC0000 ),
		LONG2CHARS( 0x000000001FFC0000 ),
		LONG2CHARS( 0x000000003FFC0000 ),
		LONG2CHARS( 0x000000007FFC0000 ),
		LONG2CHARS( 0x00000000FFFC0000 ),
		LONG2CHARS( 0x00000001FFFC0000 ),
		LONG2CHARS( 0x00000003FFFC0000 ),
		LONG2CHARS( 0x00000007FFFC0000 ),
		LONG2CHARS( 0x0000000FFFFC0000 ),
		LONG2CHARS( 0x0000001FFFFC0000 ),
		LONG2CHARS( 0x0000003FFFFC0000 ),
		LONG2CHARS( 0x0000007FFFFC0000 ),
		LONG2CHARS( 0x000000FFFFFC0000 ),
		LONG2CHARS( 0x000001FFFFFC0000 ),
		LONG2CHARS( 0x000003FFFFFC0000 ),
		LONG2CHARS( 0x000007FFFFFC0000 ),
		LONG2CHARS( 0x00000FFFFFFC0000 ),
		LONG2CHARS( 0x00001FFFFFFC0000 ),
		LONG2CHARS( 0x00003FFFFFFC0000 ),
		LONG2CHARS( 0x00007FFFFFFC0000 ),
		LONG2CHARS( 0x0000FFFFFFFC0000 ),
		LONG2CHARS( 0x0001FFFFFFFC0000 ),
		LONG2CHARS( 0x0003FFFFFFFC0000 ),
		LONG2CHARS( 0x0007FFFFFFFC0000 ),
		LONG2CHARS( 0x000FFFFFFFFC0000 ),
		LONG2CHARS( 0x001FFFFFFFFC0000 ),
		LONG2CHARS( 0x003FFFFFFFFC0000 ),
		LONG2CHARS( 0x007FFFFFFFFC0000 ),
		LONG2CHARS( 0x00FFFFFFFFFC0000 ),
		LONG2CHARS( 0x01FFFFFFFFFC0000 ),
		LONG2CHARS( 0x03FFFFFFFFFC0000 ),
		LONG2CHARS( 0x07FFFFFFFFFC0000 ),
		LONG2CHARS( 0x0FFFFFFFFFFC0000 ),
		LONG2CHARS( 0x1FFFFFFFFFFC0000 ),
		LONG2CHARS( 0x3FFFFFFFFFFC0000 ),
		LONG2CHARS( 0x7FFFFFFFFFFC0000 ),
		LONG2CHARS( 0xFFFFFFFFFFFC0000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000080000 ),
		LONG2CHARS( 0x0000000000180000 ),
		LONG2CHARS( 0x0000000000380000 ),
		LONG2CHARS( 0x0000000000780000 ),
		LONG2CHARS( 0x0000000000F80000 ),
		LONG2CHARS( 0x0000000001F80000 ),
		LONG2CHARS( 0x0000000003F80000 ),
		LONG2CHARS( 0x0000000007F80000 ),
		LONG2CHARS( 0x000000000FF80000 ),
		LONG2CHARS( 0x000000001FF80000 ),
		LONG2CHARS( 0x000000003FF80000 ),
		LONG2CHARS( 0x000000007FF80000 ),
		LONG2CHARS( 0x00000000FFF80000 ),
		LONG2CHARS( 0x00000001FFF80000 ),
		LONG2CHARS( 0x00000003FFF80000 ),
		LONG2CHARS( 0x00000007FFF80000 ),
		LONG2CHARS( 0x0000000FFFF80000 ),
		LONG2CHARS( 0x0000001FFFF80000 ),
		LONG2CHARS( 0x0000003FFFF80000 ),
		LONG2CHARS( 0x0000007FFFF80000 ),
		LONG2CHARS( 0x000000FFFFF80000 ),
		LONG2CHARS( 0x000001FFFFF80000 ),
		LONG2CHARS( 0x000003FFFFF80000 ),
		LONG2CHARS( 0x000007FFFFF80000 ),
		LONG2CHARS( 0x00000FFFFFF80000 ),
		LONG2CHARS( 0x00001FFFFFF80000 ),
		LONG2CHARS( 0x00003FFFFFF80000 ),
		LONG2CHARS( 0x00007FFFFFF80000 ),
		LONG2CHARS( 0x0000FFFFFFF80000 ),
		LONG2CHARS( 0x0001FFFFFFF80000 ),
		LONG2CHARS( 0x0003FFFFFFF80000 ),
		LONG2CHARS( 0x0007FFFFFFF80000 ),
		LONG2CHARS( 0x000FFFFFFFF80000 ),
		LONG2CHARS( 0x001FFFFFFFF80000 ),
		LONG2CHARS( 0x003FFFFFFFF80000 ),
		LONG2CHARS( 0x007FFFFFFFF80000 ),
		LONG2CHARS( 0x00FFFFFFFFF80000 ),
		LONG2CHARS( 0x01FFFFFFFFF80000 ),
		LONG2CHARS( 0x03FFFFFFFFF80000 ),
		LONG2CHARS( 0x07FFFFFFFFF80000 ),
		LONG2CHARS( 0x0FFFFFFFFFF80000 ),
		LONG2CHARS( 0x1FFFFFFFFFF80000 ),
		LONG2CHARS( 0x3FFFFFFFFFF80000 ),
		LONG2CHARS( 0x7FFFFFFFFFF80000 ),
		LONG2CHARS( 0xFFFFFFFFFFF80000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000100000 ),
		LONG2CHARS( 0x0000000000300000 ),
		LONG2CHARS( 0x0000000000700000 ),
		LONG2CHARS( 0x0000000000F00000 ),
		LONG2CHARS( 0x0000000001F00000 ),
		LONG2CHARS( 0x0000000003F00000 ),
		LONG2CHARS( 0x0000000007F00000 ),
		LONG2CHARS( 0x000000000FF00000 ),
		LONG2CHARS( 0x000000001FF00000 ),
		LONG2CHARS( 0x000000003FF00000 ),
		LONG2CHARS( 0x000000007FF00000 ),
		LONG2CHARS( 0x00000000FFF00000 ),
		LONG2CHARS( 0x00000001FFF00000 ),
		LONG2CHARS( 0x00000003FFF00000 ),
		LONG2CHARS( 0x00000007FFF00000 ),
		LONG2CHARS( 0x0000000FFFF00000 ),
		LONG2CHARS( 0x0000001FFFF00000 ),
		LONG2CHARS( 0x0000003FFFF00000 ),
		LONG2CHARS( 0x0000007FFFF00000 ),
		LONG2CHARS( 0x000000FFFFF00000 ),
		LONG2CHARS( 0x000001FFFFF00000 ),
		LONG2CHARS( 0x000003FFFFF00000 ),
		LONG2CHARS( 0x000007FFFFF00000 ),
		LONG2CHARS( 0x00000FFFFFF00000 ),
		LONG2CHARS( 0x00001FFFFFF00000 ),
		LONG2CHARS( 0x00003FFFFFF00000 ),
		LONG2CHARS( 0x00007FFFFFF00000 ),
		LONG2CHARS( 0x0000FFFFFFF00000 ),
		LONG2CHARS( 0x0001FFFFFFF00000 ),
		LONG2CHARS( 0x0003FFFFFFF00000 ),
		LONG2CHARS( 0x0007FFFFFFF00000 ),
		LONG2CHARS( 0x000FFFFFFFF00000 ),
		LONG2CHARS( 0x001FFFFFFFF00000 ),
		LONG2CHARS( 0x003FFFFFFFF00000 ),
		LONG2CHARS( 0x007FFFFFFFF00000 ),
		LONG2CHARS( 0x00FFFFFFFFF00000 ),
		LONG2CHARS( 0x01FFFFFFFFF00000 ),
		LONG2CHARS( 0x03FFFFFFFFF00000 ),
		LONG2CHARS( 0x07FFFFFFFFF00000 ),
		LONG2CHARS( 0x0FFFFFFFFFF00000 ),
		LONG2CHARS( 0x1FFFFFFFFFF00000 ),
		LONG2CHARS( 0x3FFFFFFFFFF00000 ),
		LONG2CHARS( 0x7FFFFFFFFFF00000 ),
		LONG2CHARS( 0xFFFFFFFFFFF00000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000200000 ),
		LONG2CHARS( 0x0000000000600000 ),
		LONG2CHARS( 0x0000000000E00000 ),
		LONG2CHARS( 0x0000000001E00000 ),
		LONG2CHARS( 0x0000000003E00000 ),
		LONG2CHARS( 0x0000000007E00000 ),
		LONG2CHARS( 0x000000000FE00000 ),
		LONG2CHARS( 0x000000001FE00000 ),
		LONG2CHARS( 0x000000003FE00000 ),
		LONG2CHARS( 0x000000007FE00000 ),
		LONG2CHARS( 0x00000000FFE00000 ),
		LONG2CHARS( 0x00000001FFE00000 ),
		LONG2CHARS( 0x00000003FFE00000 ),
		LONG2CHARS( 0x00000007FFE00000 ),
		LONG2CHARS( 0x0000000FFFE00000 ),
		LONG2CHARS( 0x0000001FFFE00000 ),
		LONG2CHARS( 0x0000003FFFE00000 ),
		LONG2CHARS( 0x0000007FFFE00000 ),
		LONG2CHARS( 0x000000FFFFE00000 ),
		LONG2CHARS( 0x000001FFFFE00000 ),
		LONG2CHARS( 0x000003FFFFE00000 ),
		LONG2CHARS( 0x000007FFFFE00000 ),
		LONG2CHARS( 0x00000FFFFFE00000 ),
		LONG2CHARS( 0x00001FFFFFE00000 ),
		LONG2CHARS( 0x00003FFFFFE00000 ),
		LONG2CHARS( 0x00007FFFFFE00000 ),
		LONG2CHARS( 0x0000FFFFFFE00000 ),
		LONG2CHARS( 0x0001FFFFFFE00000 ),
		LONG2CHARS( 0x0003FFFFFFE00000 ),
		LONG2CHARS( 0x0007FFFFFFE00000 ),
		LONG2CHARS( 0x000FFFFFFFE00000 ),
		LONG2CHARS( 0x001FFFFFFFE00000 ),
		LONG2CHARS( 0x003FFFFFFFE00000 ),
		LONG2CHARS( 0x007FFFFFFFE00000 ),
		LONG2CHARS( 0x00FFFFFFFFE00000 ),
		LONG2CHARS( 0x01FFFFFFFFE00000 ),
		LONG2CHARS( 0x03FFFFFFFFE00000 ),
		LONG2CHARS( 0x07FFFFFFFFE00000 ),
		LONG2CHARS( 0x0FFFFFFFFFE00000 ),
		LONG2CHARS( 0x1FFFFFFFFFE00000 ),
		LONG2CHARS( 0x3FFFFFFFFFE00000 ),
		LONG2CHARS( 0x7FFFFFFFFFE00000 ),
		LONG2CHARS( 0xFFFFFFFFFFE00000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000400000 ),
		LONG2CHARS( 0x0000000000C00000 ),
		LONG2CHARS( 0x0000000001C00000 ),
		LONG2CHARS( 0x0000000003C00000 ),
		LONG2CHARS( 0x0000000007C00000 ),
		LONG2CHARS( 0x000000000FC00000 ),
		LONG2CHARS( 0x000000001FC00000 ),
		LONG2CHARS( 0x000000003FC00000 ),
		LONG2CHARS( 0x000000007FC00000 ),
		LONG2CHARS( 0x00000000FFC00000 ),
		LONG2CHARS( 0x00000001FFC00000 ),
		LONG2CHARS( 0x00000003FFC00000 ),
		LONG2CHARS( 0x00000007FFC00000 ),
		LONG2CHARS( 0x0000000FFFC00000 ),
		LONG2CHARS( 0x0000001FFFC00000 ),
		LONG2CHARS( 0x0000003FFFC00000 ),
		LONG2CHARS( 0x0000007FFFC00000 ),
		LONG2CHARS( 0x000000FFFFC00000 ),
		LONG2CHARS( 0x000001FFFFC00000 ),
		LONG2CHARS( 0x000003FFFFC00000 ),
		LONG2CHARS( 0x000007FFFFC00000 ),
		LONG2CHARS( 0x00000FFFFFC00000 ),
		LONG2CHARS( 0x00001FFFFFC00000 ),
		LONG2CHARS( 0x00003FFFFFC00000 ),
		LONG2CHARS( 0x00007FFFFFC00000 ),
		LONG2CHARS( 0x0000FFFFFFC00000 ),
		LONG2CHARS( 0x0001FFFFFFC00000 ),
		LONG2CHARS( 0x0003FFFFFFC00000 ),
		LONG2CHARS( 0x0007FFFFFFC00000 ),
		LONG2CHARS( 0x000FFFFFFFC00000 ),
		LONG2CHARS( 0x001FFFFFFFC00000 ),
		LONG2CHARS( 0x003FFFFFFFC00000 ),
		LONG2CHARS( 0x007FFFFFFFC00000 ),
		LONG2CHARS( 0x00FFFFFFFFC00000 ),
		LONG2CHARS( 0x01FFFFFFFFC00000 ),
		LONG2CHARS( 0x03FFFFFFFFC00000 ),
		LONG2CHARS( 0x07FFFFFFFFC00000 ),
		LONG2CHARS( 0x0FFFFFFFFFC00000 ),
		LONG2CHARS( 0x1FFFFFFFFFC00000 ),
		LONG2CHARS( 0x3FFFFFFFFFC00000 ),
		LONG2CHARS( 0x7FFFFFFFFFC00000 ),
		LONG2CHARS( 0xFFFFFFFFFFC00000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000800000 ),
		LONG2CHARS( 0x0000000001800000 ),
		LONG2CHARS( 0x0000000003800000 ),
		LONG2CHARS( 0x0000000007800000 ),
		LONG2CHARS( 0x000000000F800000 ),
		LONG2CHARS( 0x000000001F800000 ),
		LONG2CHARS( 0x000000003F800000 ),
		LONG2CHARS( 0x000000007F800000 ),
		LONG2CHARS( 0x00000000FF800000 ),
		LONG2CHARS( 0x00000001FF800000 ),
		LONG2CHARS( 0x00000003FF800000 ),
		LONG2CHARS( 0x00000007FF800000 ),
		LONG2CHARS( 0x0000000FFF800000 ),
		LONG2CHARS( 0x0000001FFF800000 ),
		LONG2CHARS( 0x0000003FFF800000 ),
		LONG2CHARS( 0x0000007FFF800000 ),
		LONG2CHARS( 0x000000FFFF800000 ),
		LONG2CHARS( 0x000001FFFF800000 ),
		LONG2CHARS( 0x000003FFFF800000 ),
		LONG2CHARS( 0x000007FFFF800000 ),
		LONG2CHARS( 0x00000FFFFF800000 ),
		LONG2CHARS( 0x00001FFFFF800000 ),
		LONG2CHARS( 0x00003FFFFF800000 ),
		LONG2CHARS( 0x00007FFFFF800000 ),
		LONG2CHARS( 0x0000FFFFFF800000 ),
		LONG2CHARS( 0x0001FFFFFF800000 ),
		LONG2CHARS( 0x0003FFFFFF800000 ),
		LONG2CHARS( 0x0007FFFFFF800000 ),
		LONG2CHARS( 0x000FFFFFFF800000 ),
		LONG2CHARS( 0x001FFFFFFF800000 ),
		LONG2CHARS( 0x003FFFFFFF800000 ),
		LONG2CHARS( 0x007FFFFFFF800000 ),
		LONG2CHARS( 0x00FFFFFFFF800000 ),
		LONG2CHARS( 0x01FFFFFFFF800000 ),
		LONG2CHARS( 0x03FFFFFFFF800000 ),
		LONG2CHARS( 0x07FFFFFFFF800000 ),
		LONG2CHARS( 0x0FFFFFFFFF800000 ),
		LONG2CHARS( 0x1FFFFFFFFF800000 ),
		LONG2CHARS( 0x3FFFFFFFFF800000 ),
		LONG2CHARS( 0x7FFFFFFFFF800000 ),
		LONG2CHARS( 0xFFFFFFFFFF800000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000001000000 ),
		LONG2CHARS( 0x0000000003000000 ),
		LONG2CHARS( 0x0000000007000000 ),
		LONG2CHARS( 0x000000000F000000 ),
		LONG2CHARS( 0x000000001F000000 ),
		LONG2CHARS( 0x000000003F000000 ),
		LONG2CHARS( 0x000000007F000000 ),
		LONG2CHARS( 0x00000000FF000000 ),
		LONG2CHARS( 0x00000001FF000000 ),
		LONG2CHARS( 0x00000003FF000000 ),
		LONG2CHARS( 0x00000007FF000000 ),
		LONG2CHARS( 0x0000000FFF000000 ),
		LONG2CHARS( 0x0000001FFF000000 ),
		LONG2CHARS( 0x0000003FFF000000 ),
		LONG2CHARS( 0x0000007FFF000000 ),
		LONG2CHARS( 0x000000FFFF000000 ),
		LONG2CHARS( 0x000001FFFF000000 ),
		LONG2CHARS( 0x000003FFFF000000 ),
		LONG2CHARS( 0x000007FFFF000000 ),
		LONG2CHARS( 0x00000FFFFF000000 ),
		LONG2CHARS( 0x00001FFFFF000000 ),
		LONG2CHARS( 0x00003FFFFF000000 ),
		LONG2CHARS( 0x00007FFFFF000000 ),
		LONG2CHARS( 0x0000FFFFFF000000 ),
		LONG2CHARS( 0x0001FFFFFF000000 ),
		LONG2CHARS( 0x0003FFFFFF000000 ),
		LONG2CHARS( 0x0007FFFFFF000000 ),
		LONG2CHARS( 0x000FFFFFFF000000 ),
		LONG2CHARS( 0x001FFFFFFF000000 ),
		LONG2CHARS( 0x003FFFFFFF000000 ),
		LONG2CHARS( 0x007FFFFFFF000000 ),
		LONG2CHARS( 0x00FFFFFFFF000000 ),
		LONG2CHARS( 0x01FFFFFFFF000000 ),
		LONG2CHARS( 0x03FFFFFFFF000000 ),
		LONG2CHARS( 0x07FFFFFFFF000000 ),
		LONG2CHARS( 0x0FFFFFFFFF000000 ),
		LONG2CHARS( 0x1FFFFFFFFF000000 ),
		LONG2CHARS( 0x3FFFFFFFFF000000 ),
		LONG2CHARS( 0x7FFFFFFFFF000000 ),
		LONG2CHARS( 0xFFFFFFFFFF000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000002000000 ),
		LONG2CHARS( 0x0000000006000000 ),
		LONG2CHARS( 0x000000000E000000 ),
		LONG2CHARS( 0x000000001E000000 ),
		LONG2CHARS( 0x000000003E000000 ),
		LONG2CHARS( 0x000000007E000000 ),
		LONG2CHARS( 0x00000000FE000000 ),
		LONG2CHARS( 0x00000001FE000000 ),
		LONG2CHARS( 0x00000003FE000000 ),
		LONG2CHARS( 0x00000007FE000000 ),
		LONG2CHARS( 0x0000000FFE000000 ),
		LONG2CHARS( 0x0000001FFE000000 ),
		LONG2CHARS( 0x0000003FFE000000 ),
		LONG2CHARS( 0x0000007FFE000000 ),
		LONG2CHARS( 0x000000FFFE000000 ),
		LONG2CHARS( 0x000001FFFE000000 ),
		LONG2CHARS( 0x000003FFFE000000 ),
		LONG2CHARS( 0x000007FFFE000000 ),
		LONG2CHARS( 0x00000FFFFE000000 ),
		LONG2CHARS( 0x00001FFFFE000000 ),
		LONG2CHARS( 0x00003FFFFE000000 ),
		LONG2CHARS( 0x00007FFFFE000000 ),
		LONG2CHARS( 0x0000FFFFFE000000 ),
		LONG2CHARS( 0x0001FFFFFE000000 ),
		LONG2CHARS( 0x0003FFFFFE000000 ),
		LONG2CHARS( 0x0007FFFFFE000000 ),
		LONG2CHARS( 0x000FFFFFFE000000 ),
		LONG2CHARS( 0x001FFFFFFE000000 ),
		LONG2CHARS( 0x003FFFFFFE000000 ),
		LONG2CHARS( 0x007FFFFFFE000000 ),
		LONG2CHARS( 0x00FFFFFFFE000000 ),
		LONG2CHARS( 0x01FFFFFFFE000000 ),
		LONG2CHARS( 0x03FFFFFFFE000000 ),
		LONG2CHARS( 0x07FFFFFFFE000000 ),
		LONG2CHARS( 0x0FFFFFFFFE000000 ),
		LONG2CHARS( 0x1FFFFFFFFE000000 ),
		LONG2CHARS( 0x3FFFFFFFFE000000 ),
		LONG2CHARS( 0x7FFFFFFFFE000000 ),
		LONG2CHARS( 0xFFFFFFFFFE000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000004000000 ),
		LONG2CHARS( 0x000000000C000000 ),
		LONG2CHARS( 0x000000001C000000 ),
		LONG2CHARS( 0x000000003C000000 ),
		LONG2CHARS( 0x000000007C000000 ),
		LONG2CHARS( 0x00000000FC000000 ),
		LONG2CHARS( 0x00000001FC000000 ),
		LONG2CHARS( 0x00000003FC000000 ),
		LONG2CHARS( 0x00000007FC000000 ),
		LONG2CHARS( 0x0000000FFC000000 ),
		LONG2CHARS( 0x0000001FFC000000 ),
		LONG2CHARS( 0x0000003FFC000000 ),
		LONG2CHARS( 0x0000007FFC000000 ),
		LONG2CHARS( 0x000000FFFC000000 ),
		LONG2CHARS( 0x000001FFFC000000 ),
		LONG2CHARS( 0x000003FFFC000000 ),
		LONG2CHARS( 0x000007FFFC000000 ),
		LONG2CHARS( 0x00000FFFFC000000 ),
		LONG2CHARS( 0x00001FFFFC000000 ),
		LONG2CHARS( 0x00003FFFFC000000 ),
		LONG2CHARS( 0x00007FFFFC000000 ),
		LONG2CHARS( 0x0000FFFFFC000000 ),
		LONG2CHARS( 0x0001FFFFFC000000 ),
		LONG2CHARS( 0x0003FFFFFC000000 ),
		LONG2CHARS( 0x0007FFFFFC000000 ),
		LONG2CHARS( 0x000FFFFFFC000000 ),
		LONG2CHARS( 0x001FFFFFFC000000 ),
		LONG2CHARS( 0x003FFFFFFC000000 ),
		LONG2CHARS( 0x007FFFFFFC000000 ),
		LONG2CHARS( 0x00FFFFFFFC000000 ),
		LONG2CHARS( 0x01FFFFFFFC000000 ),
		LONG2CHARS( 0x03FFFFFFFC000000 ),
		LONG2CHARS( 0x07FFFFFFFC000000 ),
		LONG2CHARS( 0x0FFFFFFFFC000000 ),
		LONG2CHARS( 0x1FFFFFFFFC000000 ),
		LONG2CHARS( 0x3FFFFFFFFC000000 ),
		LONG2CHARS( 0x7FFFFFFFFC000000 ),
		LONG2CHARS( 0xFFFFFFFFFC000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000008000000 ),
		LONG2CHARS( 0x0000000018000000 ),
		LONG2CHARS( 0x0000000038000000 ),
		LONG2CHARS( 0x0000000078000000 ),
		LONG2CHARS( 0x00000000F8000000 ),
		LONG2CHARS( 0x00000001F8000000 ),
		LONG2CHARS( 0x00000003F8000000 ),
		LONG2CHARS( 0x00000007F8000000 ),
		LONG2CHARS( 0x0000000FF8000000 ),
		LONG2CHARS( 0x0000001FF8000000 ),
		LONG2CHARS( 0x0000003FF8000000 ),
		LONG2CHARS( 0x0000007FF8000000 ),
		LONG2CHARS( 0x000000FFF8000000 ),
		LONG2CHARS( 0x000001FFF8000000 ),
		LONG2CHARS( 0x000003FFF8000000 ),
		LONG2CHARS( 0x000007FFF8000000 ),
		LONG2CHARS( 0x00000FFFF8000000 ),
		LONG2CHARS( 0x00001FFFF8000000 ),
		LONG2CHARS( 0x00003FFFF8000000 ),
		LONG2CHARS( 0x00007FFFF8000000 ),
		LONG2CHARS( 0x0000FFFFF8000000 ),
		LONG2CHARS( 0x0001FFFFF8000000 ),
		LONG2CHARS( 0x0003FFFFF8000000 ),
		LONG2CHARS( 0x0007FFFFF8000000 ),
		LONG2CHARS( 0x000FFFFFF8000000 ),
		LONG2CHARS( 0x001FFFFFF8000000 ),
		LONG2CHARS( 0x003FFFFFF8000000 ),
		LONG2CHARS( 0x007FFFFFF8000000 ),
		LONG2CHARS( 0x00FFFFFFF8000000 ),
		LONG2CHARS( 0x01FFFFFFF8000000 ),
		LONG2CHARS( 0x03FFFFFFF8000000 ),
		LONG2CHARS( 0x07FFFFFFF8000000 ),
		LONG2CHARS( 0x0FFFFFFFF8000000 ),
		LONG2CHARS( 0x1FFFFFFFF8000000 ),
		LONG2CHARS( 0x3FFFFFFFF8000000 ),
		LONG2CHARS( 0x7FFFFFFFF8000000 ),
		LONG2CHARS( 0xFFFFFFFFF8000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000010000000 ),
		LONG2CHARS( 0x0000000030000000 ),
		LONG2CHARS( 0x0000000070000000 ),
		LONG2CHARS( 0x00000000F0000000 ),
		LONG2CHARS( 0x00000001F0000000 ),
		LONG2CHARS( 0x00000003F0000000 ),
		LONG2CHARS( 0x00000007F0000000 ),
		LONG2CHARS( 0x0000000FF0000000 ),
		LONG2CHARS( 0x0000001FF0000000 ),
		LONG2CHARS( 0x0000003FF0000000 ),
		LONG2CHARS( 0x0000007FF0000000 ),
		LONG2CHARS( 0x000000FFF0000000 ),
		LONG2CHARS( 0x000001FFF0000000 ),
		LONG2CHARS( 0x000003FFF0000000 ),
		LONG2CHARS( 0x000007FFF0000000 ),
		LONG2CHARS( 0x00000FFFF0000000 ),
		LONG2CHARS( 0x00001FFFF0000000 ),
		LONG2CHARS( 0x00003FFFF0000000 ),
		LONG2CHARS( 0x00007FFFF0000000 ),
		LONG2CHARS( 0x0000FFFFF0000000 ),
		LONG2CHARS( 0x0001FFFFF0000000 ),
		LONG2CHARS( 0x0003FFFFF0000000 ),
		LONG2CHARS( 0x0007FFFFF0000000 ),
		LONG2CHARS( 0x000FFFFFF0000000 ),
		LONG2CHARS( 0x001FFFFFF0000000 ),
		LONG2CHARS( 0x003FFFFFF0000000 ),
		LONG2CHARS( 0x007FFFFFF0000000 ),
		LONG2CHARS( 0x00FFFFFFF0000000 ),
		LONG2CHARS( 0x01FFFFFFF0000000 ),
		LONG2CHARS( 0x03FFFFFFF0000000 ),
		LONG2CHARS( 0x07FFFFFFF0000000 ),
		LONG2CHARS( 0x0FFFFFFFF0000000 ),
		LONG2CHARS( 0x1FFFFFFFF0000000 ),
		LONG2CHARS( 0x3FFFFFFFF0000000 ),
		LONG2CHARS( 0x7FFFFFFFF0000000 ),
		LONG2CHARS( 0xFFFFFFFFF0000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000020000000 ),
		LONG2CHARS( 0x0000000060000000 ),
		LONG2CHARS( 0x00000000E0000000 ),
		LONG2CHARS( 0x00000001E0000000 ),
		LONG2CHARS( 0x00000003E0000000 ),
		LONG2CHARS( 0x00000007E0000000 ),
		LONG2CHARS( 0x0000000FE0000000 ),
		LONG2CHARS( 0x0000001FE0000000 ),
		LONG2CHARS( 0x0000003FE0000000 ),
		LONG2CHARS( 0x0000007FE0000000 ),
		LONG2CHARS( 0x000000FFE0000000 ),
		LONG2CHARS( 0x000001FFE0000000 ),
		LONG2CHARS( 0x000003FFE0000000 ),
		LONG2CHARS( 0x000007FFE0000000 ),
		LONG2CHARS( 0x00000FFFE0000000 ),
		LONG2CHARS( 0x00001FFFE0000000 ),
		LONG2CHARS( 0x00003FFFE0000000 ),
		LONG2CHARS( 0x00007FFFE0000000 ),
		LONG2CHARS( 0x0000FFFFE0000000 ),
		LONG2CHARS( 0x0001FFFFE0000000 ),
		LONG2CHARS( 0x0003FFFFE0000000 ),
		LONG2CHARS( 0x0007FFFFE0000000 ),
		LONG2CHARS( 0x000FFFFFE0000000 ),
		LONG2CHARS( 0x001FFFFFE0000000 ),
		LONG2CHARS( 0x003FFFFFE0000000 ),
		LONG2CHARS( 0x007FFFFFE0000000 ),
		LONG2CHARS( 0x00FFFFFFE0000000 ),
		LONG2CHARS( 0x01FFFFFFE0000000 ),
		LONG2CHARS( 0x03FFFFFFE0000000 ),
		LONG2CHARS( 0x07FFFFFFE0000000 ),
		LONG2CHARS( 0x0FFFFFFFE0000000 ),
		LONG2CHARS( 0x1FFFFFFFE0000000 ),
		LONG2CHARS( 0x3FFFFFFFE0000000 ),
		LONG2CHARS( 0x7FFFFFFFE0000000 ),
		LONG2CHARS( 0xFFFFFFFFE0000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000040000000 ),
		LONG2CHARS( 0x00000000C0000000 ),
		LONG2CHARS( 0x00000001C0000000 ),
		LONG2CHARS( 0x00000003C0000000 ),
		LONG2CHARS( 0x00000007C0000000 ),
		LONG2CHARS( 0x0000000FC0000000 ),
		LONG2CHARS( 0x0000001FC0000000 ),
		LONG2CHARS( 0x0000003FC0000000 ),
		LONG2CHARS( 0x0000007FC0000000 ),
		LONG2CHARS( 0x000000FFC0000000 ),
		LONG2CHARS( 0x000001FFC0000000 ),
		LONG2CHARS( 0x000003FFC0000000 ),
		LONG2CHARS( 0x000007FFC0000000 ),
		LONG2CHARS( 0x00000FFFC0000000 ),
		LONG2CHARS( 0x00001FFFC0000000 ),
		LONG2CHARS( 0x00003FFFC0000000 ),
		LONG2CHARS( 0x00007FFFC0000000 ),
		LONG2CHARS( 0x0000FFFFC0000000 ),
		LONG2CHARS( 0x0001FFFFC0000000 ),
		LONG2CHARS( 0x0003FFFFC0000000 ),
		LONG2CHARS( 0x0007FFFFC0000000 ),
		LONG2CHARS( 0x000FFFFFC0000000 ),
		LONG2CHARS( 0x001FFFFFC0000000 ),
		LONG2CHARS( 0x003FFFFFC0000000 ),
		LONG2CHARS( 0x007FFFFFC0000000 ),
		LONG2CHARS( 0x00FFFFFFC0000000 ),
		LONG2CHARS( 0x01FFFFFFC0000000 ),
		LONG2CHARS( 0x03FFFFFFC0000000 ),
		LONG2CHARS( 0x07FFFFFFC0000000 ),
		LONG2CHARS( 0x0FFFFFFFC0000000 ),
		LONG2CHARS( 0x1FFFFFFFC0000000 ),
		LONG2CHARS( 0x3FFFFFFFC0000000 ),
		LONG2CHARS( 0x7FFFFFFFC0000000 ),
		LONG2CHARS( 0xFFFFFFFFC0000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000080000000 ),
		LONG2CHARS( 0x0000000180000000 ),
		LONG2CHARS( 0x0000000380000000 ),
		LONG2CHARS( 0x0000000780000000 ),
		LONG2CHARS( 0x0000000F80000000 ),
		LONG2CHARS( 0x0000001F80000000 ),
		LONG2CHARS( 0x0000003F80000000 ),
		LONG2CHARS( 0x0000007F80000000 ),
		LONG2CHARS( 0x000000FF80000000 ),
		LONG2CHARS( 0x000001FF80000000 ),
		LONG2CHARS( 0x000003FF80000000 ),
		LONG2CHARS( 0x000007FF80000000 ),
		LONG2CHARS( 0x00000FFF80000000 ),
		LONG2CHARS( 0x00001FFF80000000 ),
		LONG2CHARS( 0x00003FFF80000000 ),
		LONG2CHARS( 0x00007FFF80000000 ),
		LONG2CHARS( 0x0000FFFF80000000 ),
		LONG2CHARS( 0x0001FFFF80000000 ),
		LONG2CHARS( 0x0003FFFF80000000 ),
		LONG2CHARS( 0x0007FFFF80000000 ),
		LONG2CHARS( 0x000FFFFF80000000 ),
		LONG2CHARS( 0x001FFFFF80000000 ),
		LONG2CHARS( 0x003FFFFF80000000 ),
		LONG2CHARS( 0x007FFFFF80000000 ),
		LONG2CHARS( 0x00FFFFFF80000000 ),
		LONG2CHARS( 0x01FFFFFF80000000 ),
		LONG2CHARS( 0x03FFFFFF80000000 ),
		LONG2CHARS( 0x07FFFFFF80000000 ),
		LONG2CHARS( 0x0FFFFFFF80000000 ),
		LONG2CHARS( 0x1FFFFFFF80000000 ),
		LONG2CHARS( 0x3FFFFFFF80000000 ),
		LONG2CHARS( 0x7FFFFFFF80000000 ),
		LONG2CHARS( 0xFFFFFFFF80000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000100000000 ),
		LONG2CHARS( 0x0000000300000000 ),
		LONG2CHARS( 0x0000000700000000 ),
		LONG2CHARS( 0x0000000F00000000 ),
		LONG2CHARS( 0x0000001F00000000 ),
		LONG2CHARS( 0x0000003F00000000 ),
		LONG2CHARS( 0x0000007F00000000 ),
		LONG2CHARS( 0x000000FF00000000 ),
		LONG2CHARS( 0x000001FF00000000 ),
		LONG2CHARS( 0x000003FF00000000 ),
		LONG2CHARS( 0x000007FF00000000 ),
		LONG2CHARS( 0x00000FFF00000000 ),
		LONG2CHARS( 0x00001FFF00000000 ),
		LONG2CHARS( 0x00003FFF00000000 ),
		LONG2CHARS( 0x00007FFF00000000 ),
		LONG2CHARS( 0x0000FFFF00000000 ),
		LONG2CHARS( 0x0001FFFF00000000 ),
		LONG2CHARS( 0x0003FFFF00000000 ),
		LONG2CHARS( 0x0007FFFF00000000 ),
		LONG2CHARS( 0x000FFFFF00000000 ),
		LONG2CHARS( 0x001FFFFF00000000 ),
		LONG2CHARS( 0x003FFFFF00000000 ),
		LONG2CHARS( 0x007FFFFF00000000 ),
		LONG2CHARS( 0x00FFFFFF00000000 ),
		LONG2CHARS( 0x01FFFFFF00000000 ),
		LONG2CHARS( 0x03FFFFFF00000000 ),
		LONG2CHARS( 0x07FFFFFF00000000 ),
		LONG2CHARS( 0x0FFFFFFF00000000 ),
		LONG2CHARS( 0x1FFFFFFF00000000 ),
		LONG2CHARS( 0x3FFFFFFF00000000 ),
		LONG2CHARS( 0x7FFFFFFF00000000 ),
		LONG2CHARS( 0xFFFFFFFF00000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000200000000 ),
		LONG2CHARS( 0x0000000600000000 ),
		LONG2CHARS( 0x0000000E00000000 ),
		LONG2CHARS( 0x0000001E00000000 ),
		LONG2CHARS( 0x0000003E00000000 ),
		LONG2CHARS( 0x0000007E00000000 ),
		LONG2CHARS( 0x000000FE00000000 ),
		LONG2CHARS( 0x000001FE00000000 ),
		LONG2CHARS( 0x000003FE00000000 ),
		LONG2CHARS( 0x000007FE00000000 ),
		LONG2CHARS( 0x00000FFE00000000 ),
		LONG2CHARS( 0x00001FFE00000000 ),
		LONG2CHARS( 0x00003FFE00000000 ),
		LONG2CHARS( 0x00007FFE00000000 ),
		LONG2CHARS( 0x0000FFFE00000000 ),
		LONG2CHARS( 0x0001FFFE00000000 ),
		LONG2CHARS( 0x0003FFFE00000000 ),
		LONG2CHARS( 0x0007FFFE00000000 ),
		LONG2CHARS( 0x000FFFFE00000000 ),
		LONG2CHARS( 0x001FFFFE00000000 ),
		LONG2CHARS( 0x003FFFFE00000000 ),
		LONG2CHARS( 0x007FFFFE00000000 ),
		LONG2CHARS( 0x00FFFFFE00000000 ),
		LONG2CHARS( 0x01FFFFFE00000000 ),
		LONG2CHARS( 0x03FFFFFE00000000 ),
		LONG2CHARS( 0x07FFFFFE00000000 ),
		LONG2CHARS( 0x0FFFFFFE00000000 ),
		LONG2CHARS( 0x1FFFFFFE00000000 ),
		LONG2CHARS( 0x3FFFFFFE00000000 ),
		LONG2CHARS( 0x7FFFFFFE00000000 ),
		LONG2CHARS( 0xFFFFFFFE00000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000400000000 ),
		LONG2CHARS( 0x0000000C00000000 ),
		LONG2CHARS( 0x0000001C00000000 ),
		LONG2CHARS( 0x0000003C00000000 ),
		LONG2CHARS( 0x0000007C00000000 ),
		LONG2CHARS( 0x000000FC00000000 ),
		LONG2CHARS( 0x000001FC00000000 ),
		LONG2CHARS( 0x000003FC00000000 ),
		LONG2CHARS( 0x000007FC00000000 ),
		LONG2CHARS( 0x00000FFC00000000 ),
		LONG2CHARS( 0x00001FFC00000000 ),
		LONG2CHARS( 0x00003FFC00000000 ),
		LONG2CHARS( 0x00007FFC00000000 ),
		LONG2CHARS( 0x0000FFFC00000000 ),
		LONG2CHARS( 0x0001FFFC00000000 ),
		LONG2CHARS( 0x0003FFFC00000000 ),
		LONG2CHARS( 0x0007FFFC00000000 ),
		LONG2CHARS( 0x000FFFFC00000000 ),
		LONG2CHARS( 0x001FFFFC00000000 ),
		LONG2CHARS( 0x003FFFFC00000000 ),
		LONG2CHARS( 0x007FFFFC00000000 ),
		LONG2CHARS( 0x00FFFFFC00000000 ),
		LONG2CHARS( 0x01FFFFFC00000000 ),
		LONG2CHARS( 0x03FFFFFC00000000 ),
		LONG2CHARS( 0x07FFFFFC00000000 ),
		LONG2CHARS( 0x0FFFFFFC00000000 ),
		LONG2CHARS( 0x1FFFFFFC00000000 ),
		LONG2CHARS( 0x3FFFFFFC00000000 ),
		LONG2CHARS( 0x7FFFFFFC00000000 ),
		LONG2CHARS( 0xFFFFFFFC00000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000800000000 ),
		LONG2CHARS( 0x0000001800000000 ),
		LONG2CHARS( 0x0000003800000000 ),
		LONG2CHARS( 0x0000007800000000 ),
		LONG2CHARS( 0x000000F800000000 ),
		LONG2CHARS( 0x000001F800000000 ),
		LONG2CHARS( 0x000003F800000000 ),
		LONG2CHARS( 0x000007F800000000 ),
		LONG2CHARS( 0x00000FF800000000 ),
		LONG2CHARS( 0x00001FF800000000 ),
		LONG2CHARS( 0x00003FF800000000 ),
		LONG2CHARS( 0x00007FF800000000 ),
		LONG2CHARS( 0x0000FFF800000000 ),
		LONG2CHARS( 0x0001FFF800000000 ),
		LONG2CHARS( 0x0003FFF800000000 ),
		LONG2CHARS( 0x0007FFF800000000 ),
		LONG2CHARS( 0x000FFFF800000000 ),
		LONG2CHARS( 0x001FFFF800000000 ),
		LONG2CHARS( 0x003FFFF800000000 ),
		LONG2CHARS( 0x007FFFF800000000 ),
		LONG2CHARS( 0x00FFFFF800000000 ),
		LONG2CHARS( 0x01FFFFF800000000 ),
		LONG2CHARS( 0x03FFFFF800000000 ),
		LONG2CHARS( 0x07FFFFF800000000 ),
		LONG2CHARS( 0x0FFFFFF800000000 ),
		LONG2CHARS( 0x1FFFFFF800000000 ),
		LONG2CHARS( 0x3FFFFFF800000000 ),
		LONG2CHARS( 0x7FFFFFF800000000 ),
		LONG2CHARS( 0xFFFFFFF800000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000001000000000 ),
		LONG2CHARS( 0x0000003000000000 ),
		LONG2CHARS( 0x0000007000000000 ),
		LONG2CHARS( 0x000000F000000000 ),
		LONG2CHARS( 0x000001F000000000 ),
		LONG2CHARS( 0x000003F000000000 ),
		LONG2CHARS( 0x000007F000000000 ),
		LONG2CHARS( 0x00000FF000000000 ),
		LONG2CHARS( 0x00001FF000000000 ),
		LONG2CHARS( 0x00003FF000000000 ),
		LONG2CHARS( 0x00007FF000000000 ),
		LONG2CHARS( 0x0000FFF000000000 ),
		LONG2CHARS( 0x0001FFF000000000 ),
		LONG2CHARS( 0x0003FFF000000000 ),
		LONG2CHARS( 0x0007FFF000000000 ),
		LONG2CHARS( 0x000FFFF000000000 ),
		LONG2CHARS( 0x001FFFF000000000 ),
		LONG2CHARS( 0x003FFFF000000000 ),
		LONG2CHARS( 0x007FFFF000000000 ),
		LONG2CHARS( 0x00FFFFF000000000 ),
		LONG2CHARS( 0x01FFFFF000000000 ),
		LONG2CHARS( 0x03FFFFF000000000 ),
		LONG2CHARS( 0x07FFFFF000000000 ),
		LONG2CHARS( 0x0FFFFFF000000000 ),
		LONG2CHARS( 0x1FFFFFF000000000 ),
		LONG2CHARS( 0x3FFFFFF000000000 ),
		LONG2CHARS( 0x7FFFFFF000000000 ),
		LONG2CHARS( 0xFFFFFFF000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000002000000000 ),
		LONG2CHARS( 0x0000006000000000 ),
		LONG2CHARS( 0x000000E000000000 ),
		LONG2CHARS( 0x000001E000000000 ),
		LONG2CHARS( 0x000003E000000000 ),
		LONG2CHARS( 0x000007E000000000 ),
		LONG2CHARS( 0x00000FE000000000 ),
		LONG2CHARS( 0x00001FE000000000 ),
		LONG2CHARS( 0x00003FE000000000 ),
		LONG2CHARS( 0x00007FE000000000 ),
		LONG2CHARS( 0x0000FFE000000000 ),
		LONG2CHARS( 0x0001FFE000000000 ),
		LONG2CHARS( 0x0003FFE000000000 ),
		LONG2CHARS( 0x0007FFE000000000 ),
		LONG2CHARS( 0x000FFFE000000000 ),
		LONG2CHARS( 0x001FFFE000000000 ),
		LONG2CHARS( 0x003FFFE000000000 ),
		LONG2CHARS( 0x007FFFE000000000 ),
		LONG2CHARS( 0x00FFFFE000000000 ),
		LONG2CHARS( 0x01FFFFE000000000 ),
		LONG2CHARS( 0x03FFFFE000000000 ),
		LONG2CHARS( 0x07FFFFE000000000 ),
		LONG2CHARS( 0x0FFFFFE000000000 ),
		LONG2CHARS( 0x1FFFFFE000000000 ),
		LONG2CHARS( 0x3FFFFFE000000000 ),
		LONG2CHARS( 0x7FFFFFE000000000 ),
		LONG2CHARS( 0xFFFFFFE000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000004000000000 ),
		LONG2CHARS( 0x000000C000000000 ),
		LONG2CHARS( 0x000001C000000000 ),
		LONG2CHARS( 0x000003C000000000 ),
		LONG2CHARS( 0x000007C000000000 ),
		LONG2CHARS( 0x00000FC000000000 ),
		LONG2CHARS( 0x00001FC000000000 ),
		LONG2CHARS( 0x00003FC000000000 ),
		LONG2CHARS( 0x00007FC000000000 ),
		LONG2CHARS( 0x0000FFC000000000 ),
		LONG2CHARS( 0x0001FFC000000000 ),
		LONG2CHARS( 0x0003FFC000000000 ),
		LONG2CHARS( 0x0007FFC000000000 ),
		LONG2CHARS( 0x000FFFC000000000 ),
		LONG2CHARS( 0x001FFFC000000000 ),
		LONG2CHARS( 0x003FFFC000000000 ),
		LONG2CHARS( 0x007FFFC000000000 ),
		LONG2CHARS( 0x00FFFFC000000000 ),
		LONG2CHARS( 0x01FFFFC000000000 ),
		LONG2CHARS( 0x03FFFFC000000000 ),
		LONG2CHARS( 0x07FFFFC000000000 ),
		LONG2CHARS( 0x0FFFFFC000000000 ),
		LONG2CHARS( 0x1FFFFFC000000000 ),
		LONG2CHARS( 0x3FFFFFC000000000 ),
		LONG2CHARS( 0x7FFFFFC000000000 ),
		LONG2CHARS( 0xFFFFFFC000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000008000000000 ),
		LONG2CHARS( 0x0000018000000000 ),
		LONG2CHARS( 0x0000038000000000 ),
		LONG2CHARS( 0x0000078000000000 ),
		LONG2CHARS( 0x00000F8000000000 ),
		LONG2CHARS( 0x00001F8000000000 ),
		LONG2CHARS( 0x00003F8000000000 ),
		LONG2CHARS( 0x00007F8000000000 ),
		LONG2CHARS( 0x0000FF8000000000 ),
		LONG2CHARS( 0x0001FF8000000000 ),
		LONG2CHARS( 0x0003FF8000000000 ),
		LONG2CHARS( 0x0007FF8000000000 ),
		LONG2CHARS( 0x000FFF8000000000 ),
		LONG2CHARS( 0x001FFF8000000000 ),
		LONG2CHARS( 0x003FFF8000000000 ),
		LONG2CHARS( 0x007FFF8000000000 ),
		LONG2CHARS( 0x00FFFF8000000000 ),
		LONG2CHARS( 0x01FFFF8000000000 ),
		LONG2CHARS( 0x03FFFF8000000000 ),
		LONG2CHARS( 0x07FFFF8000000000 ),
		LONG2CHARS( 0x0FFFFF8000000000 ),
		LONG2CHARS( 0x1FFFFF8000000000 ),
		LONG2CHARS( 0x3FFFFF8000000000 ),
		LONG2CHARS( 0x7FFFFF8000000000 ),
		LONG2CHARS( 0xFFFFFF8000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000010000000000 ),
		LONG2CHARS( 0x0000030000000000 ),
		LONG2CHARS( 0x0000070000000000 ),
		LONG2CHARS( 0x00000F0000000000 ),
		LONG2CHARS( 0x00001F0000000000 ),
		LONG2CHARS( 0x00003F0000000000 ),
		LONG2CHARS( 0x00007F0000000000 ),
		LONG2CHARS( 0x0000FF0000000000 ),
		LONG2CHARS( 0x0001FF0000000000 ),
		LONG2CHARS( 0x0003FF0000000000 ),
		LONG2CHARS( 0x0007FF0000000000 ),
		LONG2CHARS( 0x000FFF0000000000 ),
		LONG2CHARS( 0x001FFF0000000000 ),
		LONG2CHARS( 0x003FFF0000000000 ),
		LONG2CHARS( 0x007FFF0000000000 ),
		LONG2CHARS( 0x00FFFF0000000000 ),
		LONG2CHARS( 0x01FFFF0000000000 ),
		LONG2CHARS( 0x03FFFF0000000000 ),
		LONG2CHARS( 0x07FFFF0000000000 ),
		LONG2CHARS( 0x0FFFFF0000000000 ),
		LONG2CHARS( 0x1FFFFF0000000000 ),
		LONG2CHARS( 0x3FFFFF0000000000 ),
		LONG2CHARS( 0x7FFFFF0000000000 ),
		LONG2CHARS( 0xFFFFFF0000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000020000000000 ),
		LONG2CHARS( 0x0000060000000000 ),
		LONG2CHARS( 0x00000E0000000000 ),
		LONG2CHARS( 0x00001E0000000000 ),
		LONG2CHARS( 0x00003E0000000000 ),
		LONG2CHARS( 0x00007E0000000000 ),
		LONG2CHARS( 0x0000FE0000000000 ),
		LONG2CHARS( 0x0001FE0000000000 ),
		LONG2CHARS( 0x0003FE0000000000 ),
		LONG2CHARS( 0x0007FE0000000000 ),
		LONG2CHARS( 0x000FFE0000000000 ),
		LONG2CHARS( 0x001FFE0000000000 ),
		LONG2CHARS( 0x003FFE0000000000 ),
		LONG2CHARS( 0x007FFE0000000000 ),
		LONG2CHARS( 0x00FFFE0000000000 ),
		LONG2CHARS( 0x01FFFE0000000000 ),
		LONG2CHARS( 0x03FFFE0000000000 ),
		LONG2CHARS( 0x07FFFE0000000000 ),
		LONG2CHARS( 0x0FFFFE0000000000 ),
		LONG2CHARS( 0x1FFFFE0000000000 ),
		LONG2CHARS( 0x3FFFFE0000000000 ),
		LONG2CHARS( 0x7FFFFE0000000000 ),
		LONG2CHARS( 0xFFFFFE0000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000040000000000 ),
		LONG2CHARS( 0x00000C0000000000 ),
		LONG2CHARS( 0x00001C0000000000 ),
		LONG2CHARS( 0x00003C0000000000 ),
		LONG2CHARS( 0x00007C0000000000 ),
		LONG2CHARS( 0x0000FC0000000000 ),
		LONG2CHARS( 0x0001FC0000000000 ),
		LONG2CHARS( 0x0003FC0000000000 ),
		LONG2CHARS( 0x0007FC0000000000 ),
		LONG2CHARS( 0x000FFC0000000000 ),
		LONG2CHARS( 0x001FFC0000000000 ),
		LONG2CHARS( 0x003FFC0000000000 ),
		LONG2CHARS( 0x007FFC0000000000 ),
		LONG2CHARS( 0x00FFFC0000000000 ),
		LONG2CHARS( 0x01FFFC0000000000 ),
		LONG2CHARS( 0x03FFFC0000000000 ),
		LONG2CHARS( 0x07FFFC0000000000 ),
		LONG2CHARS( 0x0FFFFC0000000000 ),
		LONG2CHARS( 0x1FFFFC0000000000 ),
		LONG2CHARS( 0x3FFFFC0000000000 ),
		LONG2CHARS( 0x7FFFFC0000000000 ),
		LONG2CHARS( 0xFFFFFC0000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000080000000000 ),
		LONG2CHARS( 0x0000180000000000 ),
		LONG2CHARS( 0x0000380000000000 ),
		LONG2CHARS( 0x0000780000000000 ),
		LONG2CHARS( 0x0000F80000000000 ),
		LONG2CHARS( 0x0001F80000000000 ),
		LONG2CHARS( 0x0003F80000000000 ),
		LONG2CHARS( 0x0007F80000000000 ),
		LONG2CHARS( 0x000FF80000000000 ),
		LONG2CHARS( 0x001FF80000000000 ),
		LONG2CHARS( 0x003FF80000000000 ),
		LONG2CHARS( 0x007FF80000000000 ),
		LONG2CHARS( 0x00FFF80000000000 ),
		LONG2CHARS( 0x01FFF80000000000 ),
		LONG2CHARS( 0x03FFF80000000000 ),
		LONG2CHARS( 0x07FFF80000000000 ),
		LONG2CHARS( 0x0FFFF80000000000 ),
		LONG2CHARS( 0x1FFFF80000000000 ),
		LONG2CHARS( 0x3FFFF80000000000 ),
		LONG2CHARS( 0x7FFFF80000000000 ),
		LONG2CHARS( 0xFFFFF80000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000100000000000 ),
		LONG2CHARS( 0x0000300000000000 ),
		LONG2CHARS( 0x0000700000000000 ),
		LONG2CHARS( 0x0000F00000000000 ),
		LONG2CHARS( 0x0001F00000000000 ),
		LONG2CHARS( 0x0003F00000000000 ),
		LONG2CHARS( 0x0007F00000000000 ),
		LONG2CHARS( 0x000FF00000000000 ),
		LONG2CHARS( 0x001FF00000000000 ),
		LONG2CHARS( 0x003FF00000000000 ),
		LONG2CHARS( 0x007FF00000000000 ),
		LONG2CHARS( 0x00FFF00000000000 ),
		LONG2CHARS( 0x01FFF00000000000 ),
		LONG2CHARS( 0x03FFF00000000000 ),
		LONG2CHARS( 0x07FFF00000000000 ),
		LONG2CHARS( 0x0FFFF00000000000 ),
		LONG2CHARS( 0x1FFFF00000000000 ),
		LONG2CHARS( 0x3FFFF00000000000 ),
		LONG2CHARS( 0x7FFFF00000000000 ),
		LONG2CHARS( 0xFFFFF00000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000200000000000 ),
		LONG2CHARS( 0x0000600000000000 ),
		LONG2CHARS( 0x0000E00000000000 ),
		LONG2CHARS( 0x0001E00000000000 ),
		LONG2CHARS( 0x0003E00000000000 ),
		LONG2CHARS( 0x0007E00000000000 ),
		LONG2CHARS( 0x000FE00000000000 ),
		LONG2CHARS( 0x001FE00000000000 ),
		LONG2CHARS( 0x003FE00000000000 ),
		LONG2CHARS( 0x007FE00000000000 ),
		LONG2CHARS( 0x00FFE00000000000 ),
		LONG2CHARS( 0x01FFE00000000000 ),
		LONG2CHARS( 0x03FFE00000000000 ),
		LONG2CHARS( 0x07FFE00000000000 ),
		LONG2CHARS( 0x0FFFE00000000000 ),
		LONG2CHARS( 0x1FFFE00000000000 ),
		LONG2CHARS( 0x3FFFE00000000000 ),
		LONG2CHARS( 0x7FFFE00000000000 ),
		LONG2CHARS( 0xFFFFE00000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000400000000000 ),
		LONG2CHARS( 0x0000C00000000000 ),
		LONG2CHARS( 0x0001C00000000000 ),
		LONG2CHARS( 0x0003C00000000000 ),
		LONG2CHARS( 0x0007C00000000000 ),
		LONG2CHARS( 0x000FC00000000000 ),
		LONG2CHARS( 0x001FC00000000000 ),
		LONG2CHARS( 0x003FC00000000000 ),
		LONG2CHARS( 0x007FC00000000000 ),
		LONG2CHARS( 0x00FFC00000000000 ),
		LONG2CHARS( 0x01FFC00000000000 ),
		LONG2CHARS( 0x03FFC00000000000 ),
		LONG2CHARS( 0x07FFC00000000000 ),
		LONG2CHARS( 0x0FFFC00000000000 ),
		LONG2CHARS( 0x1FFFC00000000000 ),
		LONG2CHARS( 0x3FFFC00000000000 ),
		LONG2CHARS( 0x7FFFC00000000000 ),
		LONG2CHARS( 0xFFFFC00000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000800000000000 ),
		LONG2CHARS( 0x0001800000000000 ),
		LONG2CHARS( 0x0003800000000000 ),
		LONG2CHARS( 0x0007800000000000 ),
		LONG2CHARS( 0x000F800000000000 ),
		LONG2CHARS( 0x001F800000000000 ),
		LONG2CHARS( 0x003F800000000000 ),
		LONG2CHARS( 0x007F800000000000 ),
		LONG2CHARS( 0x00FF800000000000 ),
		LONG2CHARS( 0x01FF800000000000 ),
		LONG2CHARS( 0x03FF800000000000 ),
		LONG2CHARS( 0x07FF800000000000 ),
		LONG2CHARS( 0x0FFF800000000000 ),
		LONG2CHARS( 0x1FFF800000000000 ),
		LONG2CHARS( 0x3FFF800000000000 ),
		LONG2CHARS( 0x7FFF800000000000 ),
		LONG2CHARS( 0xFFFF800000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0001000000000000 ),
		LONG2CHARS( 0x0003000000000000 ),
		LONG2CHARS( 0x0007000000000000 ),
		LONG2CHARS( 0x000F000000000000 ),
		LONG2CHARS( 0x001F000000000000 ),
		LONG2CHARS( 0x003F000000000000 ),
		LONG2CHARS( 0x007F000000000000 ),
		LONG2CHARS( 0x00FF000000000000 ),
		LONG2CHARS( 0x01FF000000000000 ),
		LONG2CHARS( 0x03FF000000000000 ),
		LONG2CHARS( 0x07FF000000000000 ),
		LONG2CHARS( 0x0FFF000000000000 ),
		LONG2CHARS( 0x1FFF000000000000 ),
		LONG2CHARS( 0x3FFF000000000000 ),
		LONG2CHARS( 0x7FFF000000000000 ),
		LONG2CHARS( 0xFFFF000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0002000000000000 ),
		LONG2CHARS( 0x0006000000000000 ),
		LONG2CHARS( 0x000E000000000000 ),
		LONG2CHARS( 0x001E000000000000 ),
		LONG2CHARS( 0x003E000000000000 ),
		LONG2CHARS( 0x007E000000000000 ),
		LONG2CHARS( 0x00FE000000000000 ),
		LONG2CHARS( 0x01FE000000000000 ),
		LONG2CHARS( 0x03FE000000000000 ),
		LONG2CHARS( 0x07FE000000000000 ),
		LONG2CHARS( 0x0FFE000000000000 ),
		LONG2CHARS( 0x1FFE000000000000 ),
		LONG2CHARS( 0x3FFE000000000000 ),
		LONG2CHARS( 0x7FFE000000000000 ),
		LONG2CHARS( 0xFFFE000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0004000000000000 ),
		LONG2CHARS( 0x000C000000000000 ),
		LONG2CHARS( 0x001C000000000000 ),
		LONG2CHARS( 0x003C000000000000 ),
		LONG2CHARS( 0x007C000000000000 ),
		LONG2CHARS( 0x00FC000000000000 ),
		LONG2CHARS( 0x01FC000000000000 ),
		LONG2CHARS( 0x03FC000000000000 ),
		LONG2CHARS( 0x07FC000000000000 ),
		LONG2CHARS( 0x0FFC000000000000 ),
		LONG2CHARS( 0x1FFC000000000000 ),
		LONG2CHARS( 0x3FFC000000000000 ),
		LONG2CHARS( 0x7FFC000000000000 ),
		LONG2CHARS( 0xFFFC000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0008000000000000 ),
		LONG2CHARS( 0x0018000000000000 ),
		LONG2CHARS( 0x0038000000000000 ),
		LONG2CHARS( 0x0078000000000000 ),
		LONG2CHARS( 0x00F8000000000000 ),
		LONG2CHARS( 0x01F8000000000000 ),
		LONG2CHARS( 0x03F8000000000000 ),
		LONG2CHARS( 0x07F8000000000000 ),
		LONG2CHARS( 0x0FF8000000000000 ),
		LONG2CHARS( 0x1FF8000000000000 ),
		LONG2CHARS( 0x3FF8000000000000 ),
		LONG2CHARS( 0x7FF8000000000000 ),
		LONG2CHARS( 0xFFF8000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0010000000000000 ),
		LONG2CHARS( 0x0030000000000000 ),
		LONG2CHARS( 0x0070000000000000 ),
		LONG2CHARS( 0x00F0000000000000 ),
		LONG2CHARS( 0x01F0000000000000 ),
		LONG2CHARS( 0x03F0000000000000 ),
		LONG2CHARS( 0x07F0000000000000 ),
		LONG2CHARS( 0x0FF0000000000000 ),
		LONG2CHARS( 0x1FF0000000000000 ),
		LONG2CHARS( 0x3FF0000000000000 ),
		LONG2CHARS( 0x7FF0000000000000 ),
		LONG2CHARS( 0xFFF0000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0020000000000000 ),
		LONG2CHARS( 0x0060000000000000 ),
		LONG2CHARS( 0x00E0000000000000 ),
		LONG2CHARS( 0x01E0000000000000 ),
		LONG2CHARS( 0x03E0000000000000 ),
		LONG2CHARS( 0x07E0000000000000 ),
		LONG2CHARS( 0x0FE0000000000000 ),
		LONG2CHARS( 0x1FE0000000000000 ),
		LONG2CHARS( 0x3FE0000000000000 ),
		LONG2CHARS( 0x7FE0000000000000 ),
		LONG2CHARS( 0xFFE0000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0040000000000000 ),
		LONG2CHARS( 0x00C0000000000000 ),
		LONG2CHARS( 0x01C0000000000000 ),
		LONG2CHARS( 0x03C0000000000000 ),
		LONG2CHARS( 0x07C0000000000000 ),
		LONG2CHARS( 0x0FC0000000000000 ),
		LONG2CHARS( 0x1FC0000000000000 ),
		LONG2CHARS( 0x3FC0000000000000 ),
		LONG2CHARS( 0x7FC0000000000000 ),
		LONG2CHARS( 0xFFC0000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0080000000000000 ),
		LONG2CHARS( 0x0180000000000000 ),
		LONG2CHARS( 0x0380000000000000 ),
		LONG2CHARS( 0x0780000000000000 ),
		LONG2CHARS( 0x0F80000000000000 ),
		LONG2CHARS( 0x1F80000000000000 ),
		LONG2CHARS( 0x3F80000000000000 ),
		LONG2CHARS( 0x7F80000000000000 ),
		LONG2CHARS( 0xFF80000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0100000000000000 ),
		LONG2CHARS( 0x0300000000000000 ),
		LONG2CHARS( 0x0700000000000000 ),
		LONG2CHARS( 0x0F00000000000000 ),
		LONG2CHARS( 0x1F00000000000000 ),
		LONG2CHARS( 0x3F00000000000000 ),
		LONG2CHARS( 0x7F00000000000000 ),
		LONG2CHARS( 0xFF00000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0200000000000000 ),
		LONG2CHARS( 0x0600000000000000 ),
		LONG2CHARS( 0x0E00000000000000 ),
		LONG2CHARS( 0x1E00000000000000 ),
		LONG2CHARS( 0x3E00000000000000 ),
		LONG2CHARS( 0x7E00000000000000 ),
		LONG2CHARS( 0xFE00000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0400000000000000 ),
		LONG2CHARS( 0x0C00000000000000 ),
		LONG2CHARS( 0x1C00000000000000 ),
		LONG2CHARS( 0x3C00000000000000 ),
		LONG2CHARS( 0x7C00000000000000 ),
		LONG2CHARS( 0xFC00000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0800000000000000 ),
		LONG2CHARS( 0x1800000000000000 ),
		LONG2CHARS( 0x3800000000000000 ),
		LONG2CHARS( 0x7800000000000000 ),
		LONG2CHARS( 0xF800000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x1000000000000000 ),
		LONG2CHARS( 0x3000000000000000 ),
		LONG2CHARS( 0x7000000000000000 ),
		LONG2CHARS( 0xF000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x2000000000000000 ),
		LONG2CHARS( 0x6000000000000000 ),
		LONG2CHARS( 0xE000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x4000000000000000 ),
		LONG2CHARS( 0xC000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
	{
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x8000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
		LONG2CHARS( 0x0000000000000000 ),
	},
};
#endif /* PPW */
#endif


/* used for masking bits in bresenham lines
   mask[n] is used to mask out all but bit n in a longword (n is a
screen position).
   rmask[n] is used to mask out the single bit at position n (n
is a screen posiotion.)
*/

#define _1_ ((PixelType)1)

#if (BITMAP_BIT_ORDER == MSBFirst)
PixelType mask[PPW] =
    {
#if PPW == 64
    LONG2CHARS( _1_<<63 ), LONG2CHARS( 1L<<62 ), LONG2CHARS( 1L<<61 ), 
    LONG2CHARS( 1L<<60 ), LONG2CHARS( 1L<<59 ),
    LONG2CHARS( 1L<<58 ), LONG2CHARS( 1L<<57 ), LONG2CHARS( 1L<<56 ), 
    LONG2CHARS( 1L<<55 ), LONG2CHARS( 1L<<54 ), LONG2CHARS( 1L<<53 ), 
    LONG2CHARS( 1L<<52 ), LONG2CHARS( 1L<<51 ), LONG2CHARS( 1L<<50 ), 
    LONG2CHARS( 1L<<49 ), LONG2CHARS( 1L<<48 ), LONG2CHARS( 1L<<47 ), 
    LONG2CHARS( 1L<<46 ), LONG2CHARS( 1L<<45 ), LONG2CHARS( 1L<<44 ), 
    LONG2CHARS( 1L<<43 ), LONG2CHARS( 1L<<42 ), LONG2CHARS( 1L<<41 ), 
    LONG2CHARS( 1L<<40 ), LONG2CHARS( 1L<<39 ), LONG2CHARS( 1L<<38 ),
    LONG2CHARS( 1L<<37 ), LONG2CHARS( 1L<<36 ), LONG2CHARS( 1L<<35 ), 
    LONG2CHARS( 1L<<34 ), LONG2CHARS( 1L<<33 ), LONG2CHARS( 1L<<32 ), 
#endif /* PPW */
    LONG2CHARS( _1_<<31 ), LONG2CHARS( 1<<30 ), LONG2CHARS( 1<<29 ), 
    LONG2CHARS( 1<<28 ), LONG2CHARS( 1<<27 ), LONG2CHARS( 1<<26 ), 
    LONG2CHARS( 1<<25 ), LONG2CHARS( 1<<24 ), LONG2CHARS( 1<<23 ), 
    LONG2CHARS( 1<<22 ), LONG2CHARS( 1<<21 ), LONG2CHARS( 1<<20 ), 
    LONG2CHARS( 1<<19 ), LONG2CHARS( 1<<18 ), LONG2CHARS( 1<<17 ), 
    LONG2CHARS( 1<<16 ), LONG2CHARS( 1<<15 ), LONG2CHARS( 1<<14 ), 
    LONG2CHARS( 1<<13 ), LONG2CHARS( 1<<12 ), LONG2CHARS( 1<<11 ), 
    LONG2CHARS( 1<<10 ), LONG2CHARS( 1<<9 ), LONG2CHARS( 1<<8 ),
    LONG2CHARS( 1<<7 ), LONG2CHARS( 1<<6 ), LONG2CHARS( 1<<5 ), 
    LONG2CHARS( 1<<4 ), LONG2CHARS( 1<<3 ), LONG2CHARS( 1<<2 ), 
    LONG2CHARS( 1<<1 ), LONG2CHARS( 1<<0 )
    };

PixelType rmask[] = 
    {
#if PPW == 64
    0xffffffffffffffff ^ LONG2CHARS( _1_<<63 ),  
    0xffffffffffffffff ^ LONG2CHARS( 1L<<62 ),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<61 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<60 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<59 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<58 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<57 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<56 ),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<55 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<54 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<53 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<52 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<51 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<50 ),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<49 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<48 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<47 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<46 ),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<45 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<44 ),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<43 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<42 ),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<41 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<40 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<39 ),  
    0xffffffffffffffff ^ LONG2CHARS( 1L<<38 ),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<37 ),  
    0xffffffffffffffff ^ LONG2CHARS( 1L<<36 ),  
    0xffffffffffffffff ^ LONG2CHARS( 1L<<35 ),  
    0xffffffffffffffff ^ LONG2CHARS( 1L<<34 ),  
    0xffffffffffffffff ^ LONG2CHARS( 1L<<33 ),  
    0xffffffffffffffff ^ LONG2CHARS( 1L<<32 ),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<31 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<30 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<29 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<28 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<27 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<26 ),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<25 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<24 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<23 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<22 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<21 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<20 ),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<19 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<18 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<17 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<16 ),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<15 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<14 ),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<13 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<12 ),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<11 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<10 ), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<9 ),  
    0xffffffffffffffff ^ LONG2CHARS( 1L<<8 ),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<7 ),  
    0xffffffffffffffff ^ LONG2CHARS( 1L<<6 ),  
    0xffffffffffffffff ^ LONG2CHARS( 1L<<5 ),  
    0xffffffffffffffff ^ LONG2CHARS( 1L<<4 ),  
    0xffffffffffffffff ^ LONG2CHARS( 1L<<3 ),  
    0xffffffffffffffff ^ LONG2CHARS( 1L<<2 ),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<1 ),  
    0xffffffffffffffff ^ LONG2CHARS( 1L<<0 )
#else /* PPW */
    0xffffffff ^ LONG2CHARS( _1_<<31 ), 0xffffffff ^ LONG2CHARS( 1<<30 ), 
    0xffffffff ^ LONG2CHARS( 1<<29 ), 0xffffffff ^ LONG2CHARS( 1<<28), 
    0xffffffff ^ LONG2CHARS( 1<<27 ), 0xffffffff ^ LONG2CHARS( 1<<26),
    0xffffffff ^ LONG2CHARS( 1<<25 ), 0xffffffff ^ LONG2CHARS( 1<<24 ), 
    0xffffffff ^ LONG2CHARS( 1<<23 ), 0xffffffff ^ LONG2CHARS( 1<<22), 
    0xffffffff ^ LONG2CHARS( 1<<21 ), 0xffffffff ^ LONG2CHARS( 1<<20),
    0xffffffff ^ LONG2CHARS( 1<<19 ), 0xffffffff ^ LONG2CHARS( 1<<18 ), 
    0xffffffff ^ LONG2CHARS( 1<<17 ), 0xffffffff ^ LONG2CHARS( 1<<16),
    0xffffffff ^ LONG2CHARS( 1<<15 ), 0xffffffff ^ LONG2CHARS( 1<<14),
    0xffffffff ^ LONG2CHARS( 1<<13 ), 0xffffffff ^ LONG2CHARS( 1<<12 ),
    0xffffffff ^ LONG2CHARS( 1<<11 ), 0xffffffff ^ LONG2CHARS( 1<<10), 
    0xffffffff ^ LONG2CHARS( 1<<9 ),  0xffffffff ^ LONG2CHARS( 1<<8),
    0xffffffff ^ LONG2CHARS( 1<<7 ),  0xffffffff ^ LONG2CHARS( 1<<6),  
    0xffffffff ^ LONG2CHARS( 1<<5 ),  0xffffffff ^ LONG2CHARS( 1<<4),  
    0xffffffff ^ LONG2CHARS( 1<<3 ),  0xffffffff ^ LONG2CHARS( 1<<2),
    0xffffffff ^ LONG2CHARS( 1<<1 ),  0xffffffff ^ LONG2CHARS( 1<<0)
#endif /* PPW */
    };
#else	/* LSBFirst */
PixelType mask[] =
    {
    LONG2CHARS( 1<<0 ), LONG2CHARS( 1<<1 ), LONG2CHARS( 1<<2), 
    LONG2CHARS( 1<<3 ), LONG2CHARS( 1<<4 ), LONG2CHARS( 1<<5), 
    LONG2CHARS( 1<<6 ), LONG2CHARS( 1<<7 ), LONG2CHARS( 1<<8), 
    LONG2CHARS( 1<<9 ), LONG2CHARS( 1<<10 ), LONG2CHARS( 1<<11), 
    LONG2CHARS( 1<<12 ), LONG2CHARS( 1<<13 ), LONG2CHARS( 1<<14), 
    LONG2CHARS( 1<<15 ), LONG2CHARS( 1<<16 ), LONG2CHARS( 1<<17), 
    LONG2CHARS( 1<<18 ), LONG2CHARS( 1<<19 ), LONG2CHARS( 1<<20), 
    LONG2CHARS( 1<<21 ), LONG2CHARS( 1<<22 ), LONG2CHARS( 1<<23),
    LONG2CHARS( 1<<24 ), LONG2CHARS( 1<<25 ), LONG2CHARS( 1<<26), 
    LONG2CHARS( 1<<27 ), LONG2CHARS( 1<<28 ), LONG2CHARS( 1<<29), 
    LONG2CHARS( 1<<30 ), LONG2CHARS( _1_<<31 )
#if PPW == 64
    ,
    LONG2CHARS( 1L<<32), 
    LONG2CHARS( 1L<<33 ), LONG2CHARS( 1L<<34 ), LONG2CHARS( 1L<<35), 
    LONG2CHARS( 1L<<36 ), LONG2CHARS( 1L<<37 ), LONG2CHARS( 1L<<38), 
    LONG2CHARS( 1L<<39 ), LONG2CHARS( 1L<<40 ), LONG2CHARS( 1L<<41), 
    LONG2CHARS( 1L<<42 ), LONG2CHARS( 1L<<43 ), LONG2CHARS( 1L<<44), 
    LONG2CHARS( 1L<<45 ), LONG2CHARS( 1L<<46 ), LONG2CHARS( 1L<<47), 
    LONG2CHARS( 1L<<48 ), LONG2CHARS( 1L<<49 ), LONG2CHARS( 1L<<50), 
    LONG2CHARS( 1L<<51 ), LONG2CHARS( 1L<<52 ), LONG2CHARS( 1L<<53),
    LONG2CHARS( 1L<<54 ), LONG2CHARS( 1L<<55 ), LONG2CHARS( 1L<<56), 
    LONG2CHARS( 1L<<57 ), LONG2CHARS( 1L<<58 ), LONG2CHARS( 1L<<59), 
    LONG2CHARS( 1L<<60 ), LONG2CHARS( 1L<<61 ),
    LONG2CHARS( 1L<<62 ), LONG2CHARS( _1_<<63 ), 
#endif /* PPW */
    }; 
PixelType rmask[] = 
    {
#if PPW == 32
    0xffffffff ^ LONG2CHARS( 1<<0), 0xffffffff ^ LONG2CHARS( 1<<1), 
    0xffffffff ^ LONG2CHARS( 1<<2), 0xffffffff ^ LONG2CHARS( 1<<3), 
    0xffffffff ^ LONG2CHARS( 1<<4), 0xffffffff ^ LONG2CHARS( 1<<5),
    0xffffffff ^ LONG2CHARS( 1<<6), 0xffffffff ^ LONG2CHARS( 1<<7), 
    0xffffffff ^ LONG2CHARS( 1<<8), 0xffffffff ^ LONG2CHARS( 1<<9), 
    0xffffffff ^ LONG2CHARS( 1<<10), 0xffffffff ^ LONG2CHARS( 1<<11),
    0xffffffff ^ LONG2CHARS( 1<<12), 0xffffffff ^ LONG2CHARS( 1<<13), 
    0xffffffff ^ LONG2CHARS( 1<<14), 0xffffffff ^ LONG2CHARS( 1<<15), 
    0xffffffff ^ LONG2CHARS( 1<<16), 0xffffffff ^ LONG2CHARS( 1<<17),
    0xffffffff ^ LONG2CHARS( 1<<18), 0xffffffff ^ LONG2CHARS( 1<<19), 
    0xffffffff ^ LONG2CHARS( 1<<20), 0xffffffff ^ LONG2CHARS( 1<<21), 
    0xffffffff ^ LONG2CHARS( 1<<22), 0xffffffff ^ LONG2CHARS( 1<<23),
    0xffffffff ^ LONG2CHARS( 1<<24), 0xffffffff ^ LONG2CHARS( 1<<25), 
    0xffffffff ^ LONG2CHARS( 1<<26), 0xffffffff ^ LONG2CHARS( 1<<27), 
    0xffffffff ^ LONG2CHARS( 1<<28), 0xffffffff ^ LONG2CHARS( 1<<29),
    0xffffffff ^ LONG2CHARS( 1<<30), 0xffffffff ^ LONG2CHARS( _1_<<31)
#else /* PPW */
    0xffffffffffffffff ^ LONG2CHARS( 1L<<0), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<1), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<2), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<3), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<4), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<5),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<6), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<7), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<8), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<9), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<10), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<11),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<12), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<13), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<14), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<15), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<16), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<17),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<18), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<19), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<20), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<21), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<22), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<23),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<24), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<25), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<26), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<27), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<28), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<29),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<30), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<31),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<32), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<33), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<34), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<35),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<36), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<37), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<38), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<39), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<40), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<41),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<42), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<43), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<44), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<45), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<46), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<47),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<48), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<49), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<50), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<51), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<52), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<53),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<54), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<55), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<56), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<57), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<58), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<59),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<60), 
    0xffffffffffffffff ^ LONG2CHARS( 1L<<61),
    0xffffffffffffffff ^ LONG2CHARS( 1L<<62), 
    0xffffffffffffffff ^ LONG2CHARS( _1_<<63), 
#endif /* PPW */
    };
#endif /* BITMAP_BIT_ORDER */

#undef _1_

/*
 * Merge raster ops for full src + dest + plane mask
 *
 * More clever usage of boolean arithmetic to reduce the
 * cost of complex raster ops.  This is for bitblt and
 * reduces all 16 raster ops + planemask to a single
 * expression:
 *
 *  dst = dst & (src & ca1 ^ cx1) ^ (src & ca2 ^ cx2)
 *
 * The array below contains the values for c?? for each
 * raster op.  Those values are further modified by
 * planemasks on multi-plane displays as follows:
 *
 *  ca1 &= pm;
 *  cx1 |= ~pm;
 *  ca2 &= pm;
 *  cx2 &= pm;
 */

#include "mergerop.h"

#define O 0
#define I ~((unsigned long)0)

mergeRopRec mergeRopBits[16] = {
O,O,O,O,	/* clear	0x0		0 */
I,O,O,O,	/* and		0x1		src AND dst */
I,O,I,O,	/* andReverse	0x2		src AND NOT dst */
O,O,I,O,	/* copy		0x3		src */
I,I,O,O,	/* andInverted	0x4		NOT src AND dst */
O,I,O,O,	/* noop		0x5		dst */
O,I,I,O,	/* xor		0x6		src XOR dst */
I,I,I,O,	/* or		0x7		src OR dst */
I,I,I,I,	/* nor		0x8		NOT src AND NOT dst */
O,I,I,I,	/* equiv	0x9		NOT src XOR dst */
O,I,O,I,	/* invert	0xa		NOT dst */
I,I,O,I,	/* orReverse	0xb		src OR NOT dst */
O,O,I,I,	/* copyInverted	0xc		NOT src */
I,O,I,I,	/* orInverted	0xd		NOT src OR dst */
I,O,O,I,	/* nand		0xe		NOT src OR NOT dst */
O,O,O,I,	/* set		0xf		1 */
};

#undef O
#undef I
