/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import sun.plugin.AppletViewer;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.Trace;

public class ProgressInfo {
    private int progress = 0;
    private int base_progress = 0;
    private int step;
    private int progress_max = 10000;
    private int jar_num = 0;
    private int current_jar = 0;
    private AppletViewer av = null;
    private Pattern pattern;
    int count = 0;

    ProgressInfo() {
        try {
            this.pattern = Pattern.compile(".*(jar|jarjar|zip)$", 2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            patternSyntaxException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }

    public void init(AppletViewer appletViewer) {
        this.av = appletViewer;
        this.jar_num = this.calcJars();
        this.step = this.jar_num != 0 ? (int)((double)this.progress_max * 1.0 / (double)this.jar_num) : this.progress_max;
    }

    public synchronized void doOnStart(Object object) {
        if (this.jar_num != 0) {
            Matcher matcher;
            if (this.av.getLoadingStatus() == 3 && (matcher = this.pattern.matcher(object.toString())).matches()) {
                Trace.println(ResourceHandler.getMessage("progress_info.downloading"), 1);
            }
        } else {
            this.step /= 2;
        }
    }

    public synchronized void doOnProgress(Object object, int n, int n2) {
        if (this.jar_num != 0) {
            Matcher matcher = this.pattern.matcher(object.toString());
            if (matcher.matches()) {
                this.progress = (int)((double)this.step * ((double)this.current_jar + (double)n * 1.0 / (double)n2));
            }
        } else {
            this.progress = this.base_progress + (int)((double)this.step * ((double)n * 1.0 / (double)n2));
        }
        if (this.progress > this.progress_max) {
            this.progress = this.progress_max;
        }
    }

    public synchronized void doOnFinish(Object object) {
        if (this.jar_num != 0) {
            Matcher matcher = this.pattern.matcher(object.toString());
            if (matcher.matches()) {
                ++this.current_jar;
                this.progress = this.step * this.current_jar;
            }
        } else {
            this.base_progress = this.progress = this.base_progress + this.step;
        }
        if (this.progress > this.progress_max) {
            this.progress = this.progress_max;
            this.base_progress = this.progress_max;
        }
    }

    public synchronized int getProgress() {
        return this.progress;
    }

    public synchronized int getProgressMax() {
        return this.progress_max;
    }

    public int calcJars() {
        int n;
        block3: {
            block2: {
                n = 0;
                if (this.av.getParameter("cache_archive_ex") == null) break block2;
                StringTokenizer stringTokenizer = new StringTokenizer(this.av.getParameter("cache_archive_ex"), ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken().trim();
                    int n2 = string.indexOf(";preload");
                    if (n2 == -1) continue;
                    ++n;
                }
                break block3;
            }
            if (this.av.getJarFiles() == null) break block3;
            StringTokenizer stringTokenizer = new StringTokenizer(this.av.getJarFiles(), ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.equalsIgnoreCase("null")) continue;
                ++n;
            }
        }
        return n;
    }
}

