/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.plugin.cache.Cache;
import sun.plugin.cache.CachedFile;
import sun.plugin.cache.FileCache;
import sun.plugin.cache.FileType;
import sun.plugin.net.protocol.http.HttpUtils;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.ProgressTracker;

public class CachedFileLoader {
    private URL url;
    private HttpURLConnection uc = null;
    private long lastModified = 0L;
    private long expiration = 0L;
    private boolean upToDate = false;
    private File dataFile = null;
    private File indexFile = null;
    private boolean cached = false;
    private long size = 0L;
    private Map headerFields = null;
    private static String[] fieldName = new String[]{"content-length", "last-modified", "expires", "content-type", "content-encoding", "date", "server"};
    public long begin;

    public CachedFileLoader(URL uRL) throws IOException {
        this.url = uRL;
    }

    public long getFileSize() {
        return this.size;
    }

    public URL getURL() {
        return this.url;
    }

    public void setDataFile(File file) {
        this.dataFile = file;
    }

    public void setIndexFile(File file) {
        this.indexFile = file;
    }

    public void setLastModify(long l) {
        this.lastModified = l;
    }

    public void setExpiration(long l) {
        this.expiration = l;
    }

    public void setHeaderMap(Map map) {
        this.headerFields = map;
    }

    public CachedFile load() throws IOException {
        boolean bl = true;
        this.cached = this.getCacheFile();
        if (this.cached) {
            bl = this.loadFromCache();
        } else {
            bl = this.download();
            if (this.dataFile != null && Cache.cleanupThread != null) {
                Cache.privileged(new Cache.CacheIOAction(){

                    public Object run() throws IOException {
                        Cache.cleanupThread.addedFile(CachedFileLoader.this.dataFile.length() + CachedFileLoader.this.indexFile.length());
                        return null;
                    }
                });
            }
        }
        if (bl) {
            return new CachedFile(this.dataFile, this.headerFields);
        }
        return null;
    }

    private boolean getCacheFile() throws IOException {
        final CachedFileLoader cachedFileLoader = this;
        return (Boolean)Cache.privileged(new Cache.CacheIOAction(){

            public Object run() throws IOException {
                boolean bl = false;
                bl = FileCache.getMatchingFile(cachedFileLoader);
                return bl;
            }
        });
    }

    private boolean loadFromCache() {
        boolean bl = false;
        try {
            this.upToDate = this.isUpToDate();
            if (this.upToDate) {
                Cache.message(ResourceHandler.getMessage("cache.loading"), new Object[]{this.url});
                ProgressTracker.onProgressComplete(this.url);
                Cache.touch(this.indexFile);
                bl = true;
            } else {
                bl = this.updateCache();
            }
        }
        catch (IOException iOException) {
            Cache.message(ResourceHandler.getMessage("cache.load_warning"), new Object[]{this.url});
        }
        return bl;
    }

    private boolean isUpToDate() throws IOException {
        boolean bl = false;
        if (this.expiration != 0L && new Date().before(new Date(this.expiration))) {
            bl = true;
        }
        if (!bl && this.lastModified != 0L) {
            this.uc = (HttpURLConnection)this.url.openConnection();
            this.uc.setUseCaches(false);
            Cache.checkPermission(this.uc);
            this.uc.setAllowUserInteraction(false);
            this.uc.setIfModifiedSince(this.lastModified);
            this.uc = HttpUtils.followRedirects(this.uc);
            int n = this.uc.getResponseCode();
            if (n == 304) {
                this.uc.disconnect();
                bl = true;
            } else if (n >= 200 && n <= 299) {
                long l = this.lastModified;
                long l2 = this.expiration;
                this.lastModified = this.uc.getLastModified();
                this.expiration = this.uc.getExpiration();
                if (this.lastModified == l) {
                    this.uc.disconnect();
                    bl = true;
                } else {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance();
                    String string = dateFormat.format(new Date(l));
                    String string2 = dateFormat.format(new Date(this.lastModified));
                    Cache.message(ResourceHandler.getMessage("cache.out_of_date"), new Object[]{this.url, string, string2});
                    this.size = this.uc.getContentLength();
                    this.initializeHeaderFields(this.uc);
                }
            } else {
                Cache.message(ResourceHandler.getMessage("cache.response_warning"), new Object[]{String.valueOf(n), this.url});
            }
        }
        return bl;
    }

    private boolean download() throws IOException {
        boolean bl = false;
        if (this.uc == null) {
            this.uc = (HttpURLConnection)this.url.openConnection();
            this.uc.setUseCaches(false);
            this.uc.setAllowUserInteraction(false);
            Cache.checkPermission(this.uc);
            this.uc = HttpUtils.followRedirects(this.uc);
            int n = this.uc.getResponseCode();
            if (n == 200) {
                this.size = this.uc.getContentLength();
                this.lastModified = this.uc.getLastModified();
                this.expiration = this.uc.getExpiration();
                if (this.lastModified == 0L && this.expiration == 0L) {
                    throw new IOException("Caching not supported for " + this.url);
                }
                this.initializeHeaderFields(this.uc);
            }
        }
        bl = (Boolean)Cache.privileged(new Cache.CacheIOAction(){

            public Object run() throws IOException {
                return CachedFileLoader.this.createCacheFiles();
            }
        });
        return bl;
    }

    private void initializeHeaderFields(URLConnection uRLConnection) throws IOException {
        this.headerFields = new HashMap();
        int n = 0;
        while (n < fieldName.length) {
            String string = uRLConnection.getHeaderField(fieldName[n]);
            if (string != null) {
                this.headerFields.put(fieldName[n], string);
            }
            ++n;
        }
    }

    private boolean updateCache() throws IOException {
        Cache.privileged(new Cache.CacheIOAction(){

            public Object run() throws IOException {
                Cache.removeFromTable(CachedFileLoader.this.indexFile, FileCache.filesInCache);
                if (!CachedFileLoader.this.dataFile.delete()) {
                    CachedFileLoader.this.dataFile.deleteOnExit();
                }
                if (!CachedFileLoader.this.indexFile.delete()) {
                    FileOutputStream fileOutputStream = new FileOutputStream(CachedFileLoader.this.indexFile);
                    fileOutputStream.write(1);
                    fileOutputStream.close();
                    CachedFileLoader.this.indexFile.deleteOnExit();
                }
                return null;
            }
        });
        return this.download();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createCacheFiles() throws IOException {
        OutputStream outputStream;
        boolean bl;
        RandomAccessFile randomAccessFile;
        block10: {
            String string = FileCache.generateCacheFileName(this.url);
            this.dataFile = new File(FileCache.directory, string + Cache.getFileExtension(this.url.toString()));
            this.indexFile = new File(FileCache.directory, string + ".idx");
            randomAccessFile = null;
            bl = false;
            InputStream inputStream = null;
            outputStream = null;
            try {
                randomAccessFile = new RandomAccessFile(this.indexFile, "rw");
                randomAccessFile.writeByte(0);
                randomAccessFile.writeUTF(this.url.toString());
                randomAccessFile.writeLong(this.lastModified);
                randomAccessFile.writeLong(this.expiration);
                randomAccessFile.writeInt(FileType.getType(Cache.getFileExtension(this.url.toString())));
                this.writeHeaders(randomAccessFile);
                inputStream = new BufferedInputStream(this.uc.getInputStream());
                outputStream = new BufferedOutputStream(new FileOutputStream(this.dataFile));
                int n = 0;
                int n2 = 0;
                byte[] byArray = new byte[2048];
                while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                    n2 += n;
                    outputStream.write(byArray, 0, n);
                }
                randomAccessFile.seek(0L);
                randomAccessFile.writeByte(16);
                bl = true;
                Object var10_9 = null;
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (!bl) {
                    this.dataFile.delete();
                    this.indexFile.delete();
                    this.dataFile = null;
                    this.indexFile = null;
                }
                throw throwable;
            }
            inputStream.close();
        }
        if (outputStream != null) {
            outputStream.close();
        }
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
        if (!bl) {
            this.dataFile.delete();
            this.indexFile.delete();
            this.dataFile = null;
            this.indexFile = null;
        }
        Cache.message(ResourceHandler.getMessage("cache.cached_name"), new Object[]{this.dataFile.getName()});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeaders(RandomAccessFile randomAccessFile) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(randomAccessFile.getFD()));
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        try {
            if (!this.headerFields.isEmpty()) {
                dataOutputStream.writeInt(this.headerFields.size());
                Iterator iterator = this.headerFields.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    dataOutputStream.writeUTF(string);
                    dataOutputStream.writeUTF((String)this.headerFields.get(string));
                }
                dataOutputStream.flush();
            } else {
                dataOutputStream.writeInt(0);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }
}

