/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.net.cookie;

import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import sun.plugin.net.cookie.CookieHandler;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.services.BrowserService;
import sun.plugin.services.ServiceProvider;
import sun.plugin.services.ServiceUnavailableException;
import sun.plugin.usability.Trace;

public class PluginCookieManager {
    private static HashMap cookieTable = new HashMap();
    private static CookieHandler cookieHandler = null;

    public static synchronized void setCookieInfo(URL uRL, String string) {
        PluginCookieManager.initialize();
        MessageFormat messageFormat = new MessageFormat(ResourceHandler.getMessage("cookiehandler.server"));
        Object[] objectArray = new Object[]{uRL, string};
        Trace.netPrintln(messageFormat.format(objectArray), 2);
        try {
            cookieHandler.setCookieInfo(uRL.toString(), string);
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            System.out.println(ResourceHandler.getMessage("cookiehandler.ignore.setcookie"));
        }
    }

    public static synchronized String getCookieInfo(URL uRL) {
        PluginCookieManager.initialize();
        String string = null;
        try {
            String string2 = uRL.getProtocol() + uRL.getHost() + uRL.getFile();
            int n = string2.lastIndexOf(47);
            if (n < 0) {
                return null;
            }
            string2 = string2.substring(0, n);
            try {
                string = cookieHandler.getCookieInfo(uRL.toString());
                if (!(string == null || string.equals("") || string.equals("\n") || string.equals("\r\n"))) {
                    cookieTable.put(string2, string);
                } else {
                    cookieTable.put(string2, "");
                    string = null;
                }
            }
            catch (ServiceUnavailableException serviceUnavailableException) {
                System.out.println(ResourceHandler.getMessage("cookiehandler.noservice"));
                string = (String)cookieTable.get(string2);
            }
            if (string != null) {
                MessageFormat messageFormat = new MessageFormat(ResourceHandler.getMessage("cookiehandler.connect"));
                Object[] objectArray = new Object[]{uRL, string};
                Trace.netPrintln(messageFormat.format(objectArray), 2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string;
    }

    private static void initialize() {
        if (cookieHandler == null) {
            BrowserService browserService = ServiceProvider.getService();
            cookieHandler = browserService.getCookieHandler();
        }
    }
}

