/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class JPEGBuffer {
    private boolean debug = false;
    final int BUFFER_SIZE = 4096;
    byte[] buf = new byte[4096];
    int bufAvail = 0;
    int bufPtr = 0;
    ImageInputStream iis;

    JPEGBuffer(ImageInputStream imageInputStream) {
        this.iis = imageInputStream;
    }

    void loadBuf(int n2) throws IOException {
        if (this.debug) {
            System.out.print("loadbuf called with ");
            System.out.print("count " + n2 + ", ");
            System.out.println("bufAvail " + this.bufAvail + ", ");
        }
        if (n2 != 0 ? this.bufAvail >= n2 : this.bufAvail == 4096) {
            return;
        }
        if (this.bufAvail > 0 && this.bufAvail < 4096) {
            System.arraycopy(this.buf, this.bufPtr, this.buf, 0, this.bufAvail);
        }
        int n3 = this.iis.read(this.buf, this.bufAvail, this.buf.length - this.bufAvail);
        if (this.debug) {
            System.out.println("iis.read returned " + n3);
        }
        if (n3 != -1) {
            this.bufAvail += n3;
        }
        this.bufPtr = 0;
        int n4 = Math.min(4096, n2);
        if (this.bufAvail < n4) {
            throw new IIOException("Image Format Error");
        }
    }

    void readData(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        if (this.bufAvail >= n2) {
            System.arraycopy(this.buf, this.bufPtr, byArray, 0, n2);
            this.bufAvail -= n2;
            this.bufPtr += n2;
            return;
        }
        int n3 = 0;
        if (this.bufAvail > 0) {
            System.arraycopy(this.buf, this.bufPtr, byArray, 0, this.bufAvail);
            n3 = this.bufAvail;
            n2 -= this.bufAvail;
            this.bufAvail = 0;
            this.bufPtr = 0;
        }
        if (this.iis.read(byArray, n3, n2) != n2) {
            throw new IIOException("Image format Error");
        }
    }

    void skipData(int n2) throws IOException {
        if (this.bufAvail >= n2) {
            this.bufAvail -= n2;
            this.bufPtr += n2;
            return;
        }
        if (this.bufAvail > 0) {
            n2 -= this.bufAvail;
            this.bufAvail = 0;
            this.bufPtr = 0;
        }
        if (this.iis.skipBytes(n2) != n2) {
            throw new IIOException("Image format Error");
        }
    }

    void pushBack() throws IOException {
        this.iis.seek(this.iis.getStreamPosition() - (long)this.bufAvail);
        this.bufAvail = 0;
        this.bufPtr = 0;
    }

    long getStreamPosition() throws IOException {
        return this.iis.getStreamPosition() - (long)this.bufAvail;
    }

    /*
     * Unable to fully structure code
     */
    boolean scanForFF(JPEGImageReader var1_1) throws IOException {
        var2_2 = false;
        var3_3 = false;
        ** GOTO lbl24
        {
            block4: {
                if ((this.buf[this.bufPtr++] & 255) != 255) break block4;
                --this.bufAvail;
                var3_3 = true;
                ** GOTO lbl12
            }
            --this.bufAvail;
            do {
                if (this.bufAvail > 0) continue block0;
lbl12:
                // 2 sources

                this.loadBuf(0);
                if (var3_3) {
                    while (this.bufAvail > 0 && (this.buf[this.bufPtr] & 255) == 255) {
                        ++this.bufPtr;
                        --this.bufAvail;
                    }
                }
                if (this.bufAvail != 0) continue;
                var2_2 = true;
                this.buf[0] = -39;
                this.bufAvail = 1;
                this.bufPtr = 0;
                var3_3 = true;
lbl24:
                // 3 sources

            } while (!var3_3);
        }
        return var2_2;
    }

    void print(int n2) {
        System.out.print("buffer has ");
        System.out.print(this.bufAvail);
        System.out.println(" bytes available");
        if (this.bufAvail < n2) {
            n2 = this.bufAvail;
        }
        int n3 = this.bufPtr;
        while (n2 > 0) {
            int n4 = this.buf[n3++] & 0xFF;
            System.out.print(" " + Integer.toHexString(n4));
            --n2;
        }
        System.out.println();
    }
}

