/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

import com.sun.imageio.plugins.png.CRC;
import java.io.IOException;
import java.util.zip.Deflater;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;

class IDATOutputStream
extends ImageOutputStreamImpl {
    private static byte[] chunkType = new byte[]{73, 68, 65, 84};
    private ImageOutputStream stream;
    private int chunkLength;
    private long startPos;
    private CRC crc = new CRC();
    Deflater def = new Deflater(9);
    byte[] buf = new byte[512];
    private int bytesRemaining;

    public IDATOutputStream(ImageOutputStream imageOutputStream, int n2) throws IOException {
        this.stream = imageOutputStream;
        this.chunkLength = n2;
        this.startChunk();
    }

    private void startChunk() throws IOException {
        this.crc.reset();
        this.startPos = this.stream.getStreamPosition();
        this.stream.writeInt(-1);
        this.crc.update(chunkType, 0, 4);
        this.stream.write(chunkType, 0, 4);
        this.bytesRemaining = this.chunkLength;
    }

    private void finishChunk() throws IOException {
        this.stream.writeInt(this.crc.getValue());
        long l2 = this.stream.getStreamPosition();
        this.stream.seek(this.startPos);
        this.stream.writeInt((int)(l2 - this.startPos) - 12);
        this.stream.seek(l2);
        this.stream.flushBefore(l2);
    }

    public int read() throws IOException {
        throw new RuntimeException("Method not available");
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        throw new RuntimeException("Method not available");
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return;
        }
        if (!this.def.finished()) {
            this.def.setInput(byArray, n2, n3);
            while (!this.def.needsInput()) {
                this.deflate();
            }
        }
    }

    public void deflate() throws IOException {
        int n2 = this.def.deflate(this.buf, 0, this.buf.length);
        int n3 = 0;
        while (n2 > 0) {
            if (this.bytesRemaining == 0) {
                this.finishChunk();
                this.startChunk();
            }
            int n4 = Math.min(n2, this.bytesRemaining);
            this.crc.update(this.buf, n3, n4);
            this.stream.write(this.buf, n3, n4);
            n3 += n4;
            n2 -= n4;
            this.bytesRemaining -= n4;
        }
    }

    public void write(int n2) throws IOException {
        byte[] byArray = new byte[]{(byte)n2};
        this.write(byArray, 0, 1);
    }

    public void finish() throws IOException {
        if (!this.def.finished()) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
        }
        this.finishChunk();
    }
}

