/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractPlayer;
import javax.sound.midi.MidiChannel;

class MixerMidiChannel
implements MidiChannel {
    protected static final boolean defaultMute = false;
    protected static final boolean defaultLocal = true;
    protected static final boolean defaultMono = false;
    protected static final boolean defaultOmni = false;
    protected static final boolean defaultSolo = false;
    protected static final int defaultProgram = 0;
    private int channelNumber;
    protected boolean mute;
    protected boolean local;
    protected boolean mono;
    protected boolean omni;
    protected boolean solo;
    protected int program;
    protected AbstractPlayer player;
    private long id = 0L;

    MixerMidiChannel(AbstractPlayer abstractPlayer, int n2) {
        this.player = abstractPlayer;
        this.mute = false;
        this.local = true;
        this.mono = false;
        this.omni = false;
        this.solo = false;
        this.program = 0;
        this.channelNumber = n2;
    }

    public void noteOn(int n2, int n3) {
        if (this.id != 0L) {
            this.nNoteOn(this.id, this.channelNumber, n2, n3, this.player.getTimeStamp());
        }
    }

    public void noteOff(int n2, int n3) {
        if (this.id != 0L) {
            this.nNoteOff(this.id, this.channelNumber, n2, n3, this.player.getTimeStamp());
        }
    }

    public void noteOff(int n2) {
        this.noteOff(n2, 0);
    }

    public void setPolyPressure(int n2, int n3) {
    }

    public int getPolyPressure(int n2) {
        return 0;
    }

    public void setChannelPressure(int n2) {
    }

    public int getChannelPressure() {
        return 0;
    }

    public void controlChange(int n2, int n3) {
        if (this.id != 0L) {
            this.nControlChange(this.id, this.channelNumber, n2, n3, this.player.getTimeStamp());
        }
    }

    public int getController(int n2) {
        if (this.id != 0L) {
            return this.nGetController(this.id, this.channelNumber, n2);
        }
        return 0;
    }

    public void programChange(int n2) {
        if (this.id != 0L) {
            this.nProgramChange(this.id, this.channelNumber, n2, this.player.getTimeStamp());
            this.program = n2;
        }
    }

    public void programChange(int n2, int n3) {
        if (this.id != 0L) {
            this.nProgramChange(this.id, this.channelNumber, n2, n3, this.player.getTimeStamp());
            this.program = n3;
        }
    }

    public int getProgram() {
        return this.program;
    }

    public void setPitchBend(int n2) {
        if (this.id != 0L) {
            this.nSetPitchBend(this.id, this.channelNumber, n2 / 128, n2 % 128, this.player.getTimeStamp());
        }
    }

    public int getPitchBend() {
        if (this.id != 0L) {
            return this.nGetPitchBend(this.id, this.channelNumber);
        }
        return 0;
    }

    public void resetAllControllers() {
        if (this.id != 0L) {
            this.nResetAllControllers(this.id, this.channelNumber);
        }
    }

    public void allNotesOff() {
        if (this.id != 0L) {
            this.nAllNotesOff(this.id, this.channelNumber, this.player.getTimeStamp());
        }
    }

    public void allSoundOff() {
    }

    public boolean localControl(boolean bl2) {
        return this.local;
    }

    public void setMono(boolean bl2) {
    }

    public boolean getMono() {
        return this.mono;
    }

    public void setOmni(boolean bl2) {
    }

    public boolean getOmni() {
        return this.omni;
    }

    public void setMute(boolean bl2) {
        if (this.id != 0L && this.mute != bl2) {
            this.mute = this.nSetMute(this.id, this.channelNumber, bl2);
        }
    }

    public boolean getMute() {
        return this.mute;
    }

    public void setSolo(boolean bl2) {
        if (this.id != 0L && this.solo != bl2) {
            this.solo = this.nSetSolo(this.id, this.channelNumber, bl2);
        }
    }

    public boolean getSolo() {
        return this.solo;
    }

    void setId(long l2) {
        this.id = l2;
    }

    protected native boolean nSetSolo(long var1, int var3, boolean var4);

    protected native boolean nGetSolo(long var1, int var3);

    protected native int nGetController(long var1, int var3, int var4);

    protected native int nGetPitchBend(long var1, int var3);

    protected native void nNoteOn(long var1, int var3, int var4, int var5, long var6);

    protected native void nNoteOff(long var1, int var3, int var4, int var5, long var6);

    protected native void nControlChange(long var1, int var3, int var4, int var5, long var6);

    protected native void nProgramChange(long var1, int var3, int var4, long var5);

    protected native void nProgramChange(long var1, int var3, int var4, int var5, long var6);

    protected native void nSetPitchBend(long var1, int var3, int var4, int var5, long var6);

    protected native void nAllNotesOff(long var1, int var3, long var4);

    protected native void nResetAllControllers(long var1, int var3);

    protected native boolean nSetMute(long var1, int var3, boolean var4);
}

