/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InputStream;
import java.text.BreakDictionary;
import java.text.CharSet;
import java.text.CharacterIterator;
import java.text.RuleBasedBreakIterator;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class DictionaryBasedBreakIterator
extends RuleBasedBreakIterator {
    private BreakDictionary dictionary;
    private boolean[] categoryFlags;
    private int dictionaryCharCount;
    private int[] cachedBreakPositions;
    private int positionInCache;

    public DictionaryBasedBreakIterator(String string, InputStream inputStream) throws IOException {
        super(string);
        this.dictionary = new BreakDictionary(inputStream);
    }

    protected RuleBasedBreakIterator.Builder makeBuilder() {
        return new Builder();
    }

    public void setText(CharacterIterator characterIterator) {
        super.setText(characterIterator);
        this.cachedBreakPositions = null;
        this.dictionaryCharCount = 0;
        this.positionInCache = 0;
    }

    public int first() {
        this.cachedBreakPositions = null;
        this.dictionaryCharCount = 0;
        this.positionInCache = 0;
        return super.first();
    }

    public int last() {
        this.cachedBreakPositions = null;
        this.dictionaryCharCount = 0;
        this.positionInCache = 0;
        return super.last();
    }

    public int previous() {
        CharacterIterator characterIterator = this.getText();
        if (this.cachedBreakPositions != null && this.positionInCache > 0) {
            --this.positionInCache;
            characterIterator.setIndex(this.cachedBreakPositions[this.positionInCache]);
            return this.cachedBreakPositions[this.positionInCache];
        }
        this.cachedBreakPositions = null;
        int n2 = super.previous();
        if (this.cachedBreakPositions != null) {
            this.positionInCache = this.cachedBreakPositions.length - 2;
        }
        return n2;
    }

    public int preceding(int n2) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n2, characterIterator);
        if (this.cachedBreakPositions == null || n2 <= this.cachedBreakPositions[0] || n2 > this.cachedBreakPositions[this.cachedBreakPositions.length - 1]) {
            this.cachedBreakPositions = null;
            return super.preceding(n2);
        }
        this.positionInCache = 0;
        while (this.positionInCache < this.cachedBreakPositions.length && n2 > this.cachedBreakPositions[this.positionInCache]) {
            ++this.positionInCache;
        }
        --this.positionInCache;
        characterIterator.setIndex(this.cachedBreakPositions[this.positionInCache]);
        return characterIterator.getIndex();
    }

    public int following(int n2) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n2, characterIterator);
        if (this.cachedBreakPositions == null || n2 < this.cachedBreakPositions[0] || n2 >= this.cachedBreakPositions[this.cachedBreakPositions.length - 1]) {
            this.cachedBreakPositions = null;
            return super.following(n2);
        }
        this.positionInCache = 0;
        while (this.positionInCache < this.cachedBreakPositions.length && n2 >= this.cachedBreakPositions[this.positionInCache]) {
            ++this.positionInCache;
        }
        characterIterator.setIndex(this.cachedBreakPositions[this.positionInCache]);
        return characterIterator.getIndex();
    }

    protected int handleNext() {
        CharacterIterator characterIterator = this.getText();
        if (this.cachedBreakPositions == null || this.positionInCache == this.cachedBreakPositions.length - 1) {
            int n2 = characterIterator.getIndex();
            this.dictionaryCharCount = 0;
            int n3 = super.handleNext();
            if (this.dictionaryCharCount > 1 && n3 - n2 > 1) {
                this.divideUpDictionaryRange(n2, n3);
            } else {
                this.cachedBreakPositions = null;
                return n3;
            }
        }
        if (this.cachedBreakPositions != null) {
            ++this.positionInCache;
            characterIterator.setIndex(this.cachedBreakPositions[this.positionInCache]);
            return this.cachedBreakPositions[this.positionInCache];
        }
        return -9999;
    }

    protected int lookupCategory(char c2) {
        int n2 = super.lookupCategory(c2);
        if (n2 != -1 && this.categoryFlags[n2]) {
            ++this.dictionaryCharCount;
        }
        return n2;
    }

    private void divideUpDictionaryRange(int n2, int n3) {
        CharacterIterator characterIterator = this.getText();
        characterIterator.setIndex(n2);
        char c2 = characterIterator.current();
        int n4 = this.lookupCategory(c2);
        while (n4 == -1 || !this.categoryFlags[n4]) {
            c2 = characterIterator.next();
            n4 = this.lookupCategory(c2);
        }
        Stack stack = new Stack();
        Stack stack2 = new Stack();
        Vector vector = new Vector();
        int n5 = 0;
        int n6 = characterIterator.getIndex();
        Stack stack3 = null;
        c2 = characterIterator.current();
        while (true) {
            if (this.dictionary.at(n5, 0) == -1) {
                stack2.push(new Integer(characterIterator.getIndex()));
            }
            if ((n5 = (int)this.dictionary.at(n5, c2)) == -1) {
                stack.push(new Integer(characterIterator.getIndex()));
                break;
            }
            if (n5 == 0 || characterIterator.getIndex() >= n3) {
                if (characterIterator.getIndex() > n6) {
                    n6 = characterIterator.getIndex();
                    stack3 = (Stack)stack.clone();
                }
                Object var12_12 = null;
                while (!stack2.isEmpty() && vector.contains(stack2.peek())) {
                    stack2.pop();
                }
                if (stack2.isEmpty()) {
                    if (stack3 != null) {
                        stack = stack3;
                        if (n6 >= n3) break;
                        characterIterator.setIndex(n6 + 1);
                    } else {
                        if ((stack.size() == 0 || ((Integer)stack.peek()).intValue() != characterIterator.getIndex()) && characterIterator.getIndex() != n2) {
                            stack.push(new Integer(characterIterator.getIndex()));
                        }
                        characterIterator.next();
                        stack.push(new Integer(characterIterator.getIndex()));
                    }
                } else {
                    Integer n7 = (Integer)stack2.pop();
                    Object object = null;
                    while (!stack.isEmpty() && n7 < (Integer)stack.peek()) {
                        object = stack.pop();
                        vector.addElement(object);
                    }
                    stack.push(n7);
                    characterIterator.setIndex((Integer)stack.peek());
                }
                c2 = characterIterator.current();
                if (characterIterator.getIndex() < n3) continue;
                break;
            }
            c2 = characterIterator.next();
        }
        if (!stack.isEmpty()) {
            stack.pop();
        }
        stack.push(new Integer(n3));
        this.cachedBreakPositions = new int[stack.size() + 1];
        this.cachedBreakPositions[0] = n2;
        int n8 = 0;
        while (n8 < stack.size()) {
            this.cachedBreakPositions[n8 + 1] = (Integer)stack.elementAt(n8);
            ++n8;
        }
        this.positionInCache = 0;
    }

    static /* synthetic */ boolean[] access$002(DictionaryBasedBreakIterator dictionaryBasedBreakIterator, boolean[] blArray) {
        dictionaryBasedBreakIterator.categoryFlags = blArray;
        return blArray;
    }

    protected class Builder
    extends RuleBasedBreakIterator.Builder {
        private CharSet dictionaryChars = new CharSet();
        private String dictionaryExpression = "";

        public Builder() {
            super(DictionaryBasedBreakIterator.this);
        }

        protected void handleSpecialSubstitution(String string, String string2, int n2, String string3) {
            super.handleSpecialSubstitution(string, string2, n2, string3);
            if (string.equals("<dictionary>")) {
                if (string2.charAt(0) == '(') {
                    this.error("Dictionary group can't be enclosed in (", n2, string3);
                }
                this.dictionaryExpression = string2;
                this.dictionaryChars = CharSet.parseString(string2);
            }
        }

        protected void buildCharCategories(Vector vector) {
            super.buildCharCategories(vector);
            DictionaryBasedBreakIterator.access$002(DictionaryBasedBreakIterator.this, new boolean[this.categories.size()]);
            int n2 = 0;
            while (n2 < this.categories.size()) {
                CharSet charSet = (CharSet)this.categories.elementAt(n2);
                if (!charSet.intersection(this.dictionaryChars).empty()) {
                    ((DictionaryBasedBreakIterator)DictionaryBasedBreakIterator.this).categoryFlags[n2] = true;
                }
                ++n2;
            }
        }

        protected void mungeExpressionList(Hashtable hashtable) {
            hashtable.put(this.dictionaryExpression, this.dictionaryChars);
        }
    }
}

