/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.text.TextBoundaryData;

final class SimpleTextBoundary
extends BreakIterator {
    private transient int pos;
    private transient CharacterIterator text;
    private TextBoundaryData data;
    private static final char END_OF_STRING = '\uffff';

    protected SimpleTextBoundary(TextBoundaryData textBoundaryData) {
        this.data = textBoundaryData;
        this.text = new StringCharacterIterator("");
        this.pos = this.text.getBeginIndex();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleTextBoundary)) {
            return false;
        }
        SimpleTextBoundary simpleTextBoundary = (SimpleTextBoundary)object;
        if (this.data.getClass() != simpleTextBoundary.data.getClass()) {
            return false;
        }
        if (this.hashCode() != simpleTextBoundary.hashCode()) {
            return false;
        }
        if (this.pos != simpleTextBoundary.pos) {
            return false;
        }
        return this.text.equals(simpleTextBoundary.text);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.text.hashCode();
    }

    public Object clone() {
        try {
            SimpleTextBoundary simpleTextBoundary = (SimpleTextBoundary)super.clone();
            simpleTextBoundary.text = (CharacterIterator)this.text.clone();
            return simpleTextBoundary;
        }
        catch (InternalError internalError) {
            throw new InternalError();
        }
    }

    public CharacterIterator getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = new StringCharacterIterator(string);
        this.pos = this.text.getBeginIndex();
    }

    public void setText(CharacterIterator characterIterator) {
        this.text = characterIterator;
        this.pos = this.text.getBeginIndex();
    }

    public int first() {
        this.pos = this.text.getBeginIndex();
        return this.pos;
    }

    public int last() {
        this.pos = this.text.getEndIndex();
        return this.pos;
    }

    public int next(int n2) {
        int n3 = this.current();
        if (n2 < 0) {
            int n4 = n2;
            while (n4 < 0 && n3 != -1) {
                n3 = this.previous();
                ++n4;
            }
        } else {
            int n5 = n2;
            while (n5 > 0 && n3 != -1) {
                n3 = this.next();
                --n5;
            }
        }
        return n3;
    }

    public int previous() {
        if (this.pos > this.text.getBeginIndex()) {
            int n2 = this.pos;
            int n3 = this.pos = this.previousSafePosition(this.pos - 1);
            int n4 = this.next();
            while (n4 < n2 && n4 != -1) {
                n3 = n4;
                n4 = this.next();
            }
            this.pos = n3;
            return this.pos;
        }
        return -1;
    }

    public int next() {
        int n2 = this.pos;
        n2 = this.pos < this.text.getEndIndex() ? (this.pos = this.nextPosition(this.pos)) : -1;
        return n2;
    }

    public boolean isBoundary(int n2) {
        int n3 = this.text.getBeginIndex();
        if (n2 < n3 || n2 >= this.text.getEndIndex()) {
            throw new IllegalArgumentException("isBoundary offset out of bounds");
        }
        if (n2 == n3) {
            return true;
        }
        return this.following(n2 - 1) == n2;
    }

    public int following(int n2) {
        int n3;
        if (n2 < this.text.getBeginIndex() || n2 >= this.text.getEndIndex()) {
            throw new IllegalArgumentException("nextBoundaryAt offset out of bounds");
        }
        this.pos = this.previousSafePosition(n2);
        while ((n3 = this.next()) <= n2 && n3 != -1) {
        }
        return n3;
    }

    public int preceding(int n2) {
        int n3;
        if (n2 < this.text.getBeginIndex() || n2 >= this.text.getEndIndex()) {
            throw new IllegalArgumentException("preceding() offset out of bounds");
        }
        if (n2 == this.text.getBeginIndex()) {
            return -1;
        }
        int n4 = this.pos = this.previousSafePosition(n2);
        do {
            n3 = n4;
        } while ((n4 = this.next()) < n2 && n4 != -1);
        this.pos = n3;
        return n3;
    }

    public int current() {
        return this.pos;
    }

    private int previousSafePosition(int n2) {
        int n3 = this.text.getBeginIndex();
        int n4 = this.data.backward().initialState();
        if (n2 == n3) {
            ++n2;
        }
        char c2 = this.text.setIndex(n2 - 1);
        while (c2 != '\uffff' && !this.data.backward().isEndState(n4)) {
            n4 = this.data.backward().get(n4, this.mappedChar(c2));
            if (this.data.backward().isMarkState(n4)) {
                n3 = this.text.getIndex();
            }
            c2 = this.text.previous();
        }
        return n3;
    }

    private int nextPosition(int n2) {
        int n3 = this.text.getEndIndex();
        int n4 = this.data.forward().initialState();
        char c2 = this.text.setIndex(n2);
        while (c2 != '\uffff' && !this.data.forward().isEndState(n4)) {
            n4 = this.data.forward().get(n4, this.mappedChar(c2));
            if (this.data.forward().isMarkState(n4)) {
                n3 = this.text.getIndex();
            }
            c2 = this.text.next();
        }
        if (this.data.forward().isEndState(n4)) {
            return n3;
        }
        n4 = this.data.forward().get(n4, this.mappedChar('\uffff'));
        if (this.data.forward().isMarkState(n4)) {
            return this.text.getEndIndex();
        }
        return n3;
    }

    protected int mappedChar(char c2) {
        return this.data.map().mappedChar(c2);
    }
}

