/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class Level
implements Serializable {
    private static ArrayList known = new ArrayList();
    private static String defaultBundle = "sun.util.logging.resources.logging";
    private final String name;
    private final int value;
    private final String resourceBundleName;
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE, defaultBundle);
    public static final Level SEVERE = new Level("SEVERE", 1000, defaultBundle);
    public static final Level WARNING = new Level("WARNING", 900, defaultBundle);
    public static final Level INFO = new Level("INFO", 800, defaultBundle);
    public static final Level CONFIG = new Level("CONFIG", 700, defaultBundle);
    public static final Level FINE = new Level("FINE", 500, defaultBundle);
    public static final Level FINER = new Level("FINER", 400, defaultBundle);
    public static final Level FINEST = new Level("FINEST", 300, defaultBundle);
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE, defaultBundle);
    static /* synthetic */ Class class$java$util$logging$Level;

    protected Level(String string, int n2) {
        this(string, n2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Level(String string, int n2, String string2) {
        this.name = string;
        this.value = n2;
        this.resourceBundleName = string2;
        Class clazz = class$java$util$logging$Level == null ? (class$java$util$logging$Level = Level.class$("java.util.logging.Level")) : class$java$util$logging$Level;
        synchronized (clazz) {
            known.add(this);
        }
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(this.resourceBundleName);
            return resourceBundle.getString(this.name);
        }
        catch (Exception exception) {
            return this.name;
        }
    }

    public final String toString() {
        return this.name;
    }

    public final int intValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object readResolve() {
        Class clazz = class$java$util$logging$Level == null ? (class$java$util$logging$Level = Level.class$("java.util.logging.Level")) : class$java$util$logging$Level;
        synchronized (clazz) {
            int n2 = 0;
            while (n2 < known.size()) {
                Level level = (Level)known.get(n2);
                if (this.name.equals(level.name) && this.value == level.value) {
                    if (this.resourceBundleName == level.resourceBundleName) return level;
                    if (this.resourceBundleName != null && this.resourceBundleName.equals(level.resourceBundleName)) {
                        return level;
                    }
                }
                ++n2;
            }
            known.add(this);
            return this;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static synchronized Level parse(String var0) throws IllegalArgumentException {
        var0.length();
        var1_1 = 0;
        while (var1_1 < Level.known.size()) {
            var2_2 = (Level)Level.known.get(var1_1);
            if (var0.equals(var2_2.name)) {
                return var2_2;
            }
            ++var1_1;
        }
        try {
            var2_3 = Integer.parseInt(var0);
            var3_6 = 0;
            while (var3_6 < Level.known.size()) {
                var4_8 = (Level)Level.known.get(var3_6);
                if (var4_8.value == var2_3) {
                    return var4_8;
                }
                ++var3_6;
            }
            return new Level(var0, var2_3);
        }
        catch (NumberFormatException var2_4) {
            var2_5 = 0;
            ** while (var2_5 < Level.known.size())
        }
lbl-1000:
        // 1 sources

        {
            var3_7 = (Level)Level.known.get(var2_5);
            if (var0.equals(var3_7.getLocalizedName())) {
                return var3_7;
            }
            ++var2_5;
            continue;
        }
lbl28:
        // 1 sources

        throw new IllegalArgumentException("Bad level \"" + var0 + "\"");
    }

    public boolean equals(Object object) {
        try {
            Level level = (Level)object;
            return level.value == this.value;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.value;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

