/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Permission;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.PreferencesFactory;
import java.util.prefs.XmlSupport;

public abstract class Preferences {
    private static final PreferencesFactory factory;
    public static final int MAX_KEY_LENGTH = 80;
    public static final int MAX_VALUE_LENGTH = 8192;
    public static final int MAX_NAME_LENGTH = 80;
    private static Permission prefsPerm;

    public static Preferences userNodeForPackage(Class clazz) {
        return Preferences.userRoot().node(Preferences.nodeName(clazz));
    }

    public static Preferences systemNodeForPackage(Class clazz) {
        return Preferences.systemRoot().node(Preferences.nodeName(clazz));
    }

    private static String nodeName(Class clazz) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("Arrays have no associated preferences node.");
        }
        String string = clazz.getName();
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return "/<unnamed>";
        }
        String string2 = string.substring(0, n2);
        return "/" + string2.replace('.', '/');
    }

    public static Preferences userRoot() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(prefsPerm);
        }
        return factory.userRoot();
    }

    public static Preferences systemRoot() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(prefsPerm);
        }
        return factory.systemRoot();
    }

    protected Preferences() {
    }

    public abstract void put(String var1, String var2);

    public abstract String get(String var1, String var2);

    public abstract void remove(String var1);

    public abstract void clear() throws BackingStoreException;

    public abstract void putInt(String var1, int var2);

    public abstract int getInt(String var1, int var2);

    public abstract void putLong(String var1, long var2);

    public abstract long getLong(String var1, long var2);

    public abstract void putBoolean(String var1, boolean var2);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract void putFloat(String var1, float var2);

    public abstract float getFloat(String var1, float var2);

    public abstract void putDouble(String var1, double var2);

    public abstract double getDouble(String var1, double var2);

    public abstract void putByteArray(String var1, byte[] var2);

    public abstract byte[] getByteArray(String var1, byte[] var2);

    public abstract String[] keys() throws BackingStoreException;

    public abstract String[] childrenNames() throws BackingStoreException;

    public abstract Preferences parent();

    public abstract Preferences node(String var1);

    public abstract boolean nodeExists(String var1) throws BackingStoreException;

    public abstract void removeNode() throws BackingStoreException;

    public abstract String name();

    public abstract String absolutePath();

    public abstract boolean isUserNode();

    public abstract String toString();

    public abstract void flush() throws BackingStoreException;

    public abstract void sync() throws BackingStoreException;

    public abstract void addPreferenceChangeListener(PreferenceChangeListener var1);

    public abstract void removePreferenceChangeListener(PreferenceChangeListener var1);

    public abstract void addNodeChangeListener(NodeChangeListener var1);

    public abstract void removeNodeChangeListener(NodeChangeListener var1);

    public abstract void exportNode(OutputStream var1) throws IOException, BackingStoreException;

    public abstract void exportSubtree(OutputStream var1) throws IOException, BackingStoreException;

    public static void importPreferences(InputStream inputStream) throws IOException, InvalidPreferencesFormatException {
        XmlSupport.importPreferences(inputStream);
    }

    static {
        String string = System.getProperty("java.util.prefs.PreferencesFactory");
        if (string == null) {
            throw new InternalError("System property java.util.prefs.PreferencesFactory not set");
        }
        try {
            factory = (PreferencesFactory)Class.forName(string, false, ClassLoader.getSystemClassLoader()).newInstance();
        }
        catch (Exception exception) {
            throw new InternalError("Can't instantiate Preferences factory " + exception);
        }
        prefsPerm = new RuntimePermission("preferences");
    }
}

