/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicListUI;
import javax.swing.text.JTextComponent;

public class BasicFileChooserUI
extends FileChooserUI {
    protected Icon directoryIcon = null;
    protected Icon fileIcon = null;
    protected Icon computerIcon = null;
    protected Icon hardDriveIcon = null;
    protected Icon floppyDriveIcon = null;
    protected Icon newFolderIcon = null;
    protected Icon upFolderIcon = null;
    protected Icon homeFolderIcon = null;
    protected Icon listViewIcon = null;
    protected Icon detailsViewIcon = null;
    protected int saveButtonMnemonic = 0;
    protected int openButtonMnemonic = 0;
    protected int cancelButtonMnemonic = 0;
    protected int updateButtonMnemonic = 0;
    protected int helpButtonMnemonic = 0;
    protected int directoryOpenButtonMnemonic = 0;
    protected String saveButtonText = null;
    protected String openButtonText = null;
    protected String cancelButtonText = null;
    protected String updateButtonText = null;
    protected String helpButtonText = null;
    protected String directoryOpenButtonText = null;
    private String openDialogTitleText = null;
    private String saveDialogTitleText = null;
    protected String saveButtonToolTipText = null;
    protected String openButtonToolTipText = null;
    protected String cancelButtonToolTipText = null;
    protected String updateButtonToolTipText = null;
    protected String helpButtonToolTipText = null;
    protected String directoryOpenButtonToolTipText = null;
    private Action approveSelectionAction = new ApproveSelectionAction();
    private Action cancelSelectionAction = new CancelSelectionAction();
    private Action updateAction = new UpdateAction();
    private Action newFolderAction = new NewFolderAction();
    private Action goHomeAction = new GoHomeAction();
    private Action changeToParentDirectoryAction = new ChangeToParentDirectoryAction();
    private String newFolderErrorSeparator = null;
    private String newFolderErrorText = null;
    private String fileDescriptionText = null;
    private String directoryDescriptionText = null;
    private JFileChooser filechooser = null;
    private boolean directorySelected = false;
    private File directory = null;
    private PropertyChangeListener propertyChangeListener = null;
    private AcceptAllFileFilter acceptAllFileFilter = new AcceptAllFileFilter();
    private FileFilter actualFileFilter = null;
    private GlobFilter globFilter = null;
    private BasicDirectoryModel model = null;
    private BasicFileView fileView = new BasicFileView();
    private JPanel accessoryPanel = null;
    private static final TransferHandler defaultTransferHandler = new FileTransferHandler();

    public BasicFileChooserUI(JFileChooser jFileChooser) {
    }

    public void installUI(JComponent jComponent) {
        this.accessoryPanel = new JPanel(new BorderLayout());
        this.filechooser = (JFileChooser)jComponent;
        this.createModel();
        this.clearIconCache();
        this.installDefaults(this.filechooser);
        this.installComponents(this.filechooser);
        this.installListeners(this.filechooser);
        this.filechooser.applyComponentOrientation(this.filechooser.getComponentOrientation());
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners(this.filechooser);
        this.uninstallComponents(this.filechooser);
        this.uninstallDefaults(this.filechooser);
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
        }
        this.accessoryPanel = null;
        this.getFileChooser().removeAll();
    }

    public void installComponents(JFileChooser jFileChooser) {
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
    }

    protected void installListeners(JFileChooser jFileChooser) {
        this.propertyChangeListener = this.createPropertyChangeListener(jFileChooser);
        if (this.propertyChangeListener != null) {
            jFileChooser.addPropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.addPropertyChangeListener(this.getModel());
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(jFileChooser, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jFileChooser, actionMap);
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            return (InputMap)UIManager.get("FileChooser.ancestorInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    ActionMap createActionMap() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicFileChooserUI.this.getFileChooser().cancelSelection();
            }

            public boolean isEnabled() {
                return BasicFileChooserUI.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("approveSelection", this.getApproveSelectionAction());
        actionMapUIResource.put("cancelSelection", abstractAction);
        actionMapUIResource.put("Go Up", this.getChangeToParentDirectoryAction());
        return actionMapUIResource;
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        if (this.propertyChangeListener != null) {
            jFileChooser.removePropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.removePropertyChangeListener(this.getModel());
        SwingUtilities.replaceUIInputMap(jFileChooser, 1, null);
        SwingUtilities.replaceUIActionMap(jFileChooser, null);
    }

    protected void installDefaults(JFileChooser jFileChooser) {
        this.installIcons(jFileChooser);
        this.installStrings(jFileChooser);
        TransferHandler transferHandler = jFileChooser.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            jFileChooser.setTransferHandler(defaultTransferHandler);
        }
    }

    protected void installIcons(JFileChooser jFileChooser) {
        this.directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        this.fileIcon = UIManager.getIcon("FileView.fileIcon");
        this.computerIcon = UIManager.getIcon("FileView.computerIcon");
        this.hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
        this.floppyDriveIcon = UIManager.getIcon("FileView.floppyDriveIcon");
        this.newFolderIcon = UIManager.getIcon("FileChooser.newFolderIcon");
        this.upFolderIcon = UIManager.getIcon("FileChooser.upFolderIcon");
        this.homeFolderIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
        this.detailsViewIcon = UIManager.getIcon("FileChooser.detailsViewIcon");
        this.listViewIcon = UIManager.getIcon("FileChooser.listViewIcon");
    }

    protected void installStrings(JFileChooser jFileChooser) {
        Locale locale = jFileChooser.getLocale();
        this.newFolderErrorText = UIManager.getString((Object)"FileChooser.newFolderErrorText", locale);
        this.newFolderErrorSeparator = UIManager.getString((Object)"FileChooser.newFolderErrorSeparator", locale);
        this.fileDescriptionText = UIManager.getString((Object)"FileChooser.fileDescriptionText", locale);
        this.directoryDescriptionText = UIManager.getString((Object)"FileChooser.directoryDescriptionText", locale);
        this.saveButtonText = UIManager.getString((Object)"FileChooser.saveButtonText", locale);
        this.openButtonText = UIManager.getString((Object)"FileChooser.openButtonText", locale);
        this.saveDialogTitleText = UIManager.getString((Object)"FileChooser.saveDialogTitleText", locale);
        this.openDialogTitleText = UIManager.getString((Object)"FileChooser.openDialogTitleText", locale);
        this.cancelButtonText = UIManager.getString((Object)"FileChooser.cancelButtonText", locale);
        this.updateButtonText = UIManager.getString((Object)"FileChooser.updateButtonText", locale);
        this.helpButtonText = UIManager.getString((Object)"FileChooser.helpButtonText", locale);
        this.directoryOpenButtonText = UIManager.getString((Object)"FileChooser.directoryOpenButtonText", locale);
        this.saveButtonMnemonic = UIManager.getInt("FileChooser.saveButtonMnemonic");
        this.openButtonMnemonic = UIManager.getInt("FileChooser.openButtonMnemonic");
        this.cancelButtonMnemonic = UIManager.getInt("FileChooser.cancelButtonMnemonic");
        this.updateButtonMnemonic = UIManager.getInt("FileChooser.updateButtonMnemonic");
        this.helpButtonMnemonic = UIManager.getInt("FileChooser.helpButtonMnemonic");
        this.directoryOpenButtonMnemonic = UIManager.getInt("FileChooser.directoryOpenButtonMnemonic");
        this.saveButtonToolTipText = UIManager.getString((Object)"FileChooser.saveButtonToolTipText", locale);
        this.openButtonToolTipText = UIManager.getString((Object)"FileChooser.openButtonToolTipText", locale);
        this.cancelButtonToolTipText = UIManager.getString((Object)"FileChooser.cancelButtonToolTipText", locale);
        this.updateButtonToolTipText = UIManager.getString((Object)"FileChooser.updateButtonToolTipText", locale);
        this.helpButtonToolTipText = UIManager.getString((Object)"FileChooser.helpButtonToolTipText", locale);
        this.directoryOpenButtonToolTipText = UIManager.getString((Object)"FileChooser.directoryOpenButtonToolTipText", locale);
    }

    protected void uninstallDefaults(JFileChooser jFileChooser) {
        this.uninstallIcons(jFileChooser);
        this.uninstallStrings(jFileChooser);
        if (jFileChooser.getTransferHandler() instanceof UIResource) {
            jFileChooser.setTransferHandler(null);
        }
    }

    protected void uninstallIcons(JFileChooser jFileChooser) {
        this.directoryIcon = null;
        this.fileIcon = null;
        this.computerIcon = null;
        this.hardDriveIcon = null;
        this.floppyDriveIcon = null;
        this.newFolderIcon = null;
        this.upFolderIcon = null;
        this.homeFolderIcon = null;
        this.detailsViewIcon = null;
        this.listViewIcon = null;
    }

    protected void uninstallStrings(JFileChooser jFileChooser) {
        this.saveButtonText = null;
        this.openButtonText = null;
        this.cancelButtonText = null;
        this.updateButtonText = null;
        this.helpButtonText = null;
        this.directoryOpenButtonText = null;
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
        this.updateButtonToolTipText = null;
        this.helpButtonToolTipText = null;
        this.directoryOpenButtonToolTipText = null;
    }

    protected void createModel() {
        this.model = new BasicDirectoryModel(this.getFileChooser());
    }

    public BasicDirectoryModel getModel() {
        return this.model;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return null;
    }

    public String getFileName() {
        return null;
    }

    public String getDirectoryName() {
        return null;
    }

    public void setFileName(String string) {
    }

    public void setDirectoryName(String string) {
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return null;
    }

    public String getApproveButtonToolTipText(JFileChooser jFileChooser) {
        String string = jFileChooser.getApproveButtonToolTipText();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonToolTipText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonToolTipText;
        }
        return null;
    }

    public void clearIconCache() {
        this.fileView.clearIconCache();
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new SelectionListener();
    }

    protected MouseListener createDoubleClickListener(JFileChooser jFileChooser, JList jList) {
        return new DoubleClickListener(jList);
    }

    protected boolean isDirectorySelected() {
        return this.directorySelected;
    }

    protected void setDirectorySelected(boolean bl2) {
        this.directorySelected = bl2;
    }

    protected File getDirectory() {
        return this.directory;
    }

    protected void setDirectory(File file) {
        this.directory = file;
    }

    public FileFilter getAcceptAllFileFilter(JFileChooser jFileChooser) {
        return this.acceptAllFileFilter;
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    public String getDialogTitle(JFileChooser jFileChooser) {
        String string = jFileChooser.getDialogTitle();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openDialogTitleText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveDialogTitleText;
        }
        return this.getApproveButtonText(jFileChooser);
    }

    public int getApproveButtonMnemonic(JFileChooser jFileChooser) {
        int n2 = jFileChooser.getApproveButtonMnemonic();
        if (n2 > 0) {
            return n2;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonMnemonic;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonMnemonic;
        }
        return n2;
    }

    public String getApproveButtonText(JFileChooser jFileChooser) {
        String string = jFileChooser.getApproveButtonText();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonText;
        }
        return null;
    }

    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    public Action getGoHomeAction() {
        return this.goHomeAction;
    }

    public Action getChangeToParentDirectoryAction() {
        return this.changeToParentDirectoryAction;
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    public Action getCancelSelectionAction() {
        return this.cancelSelectionAction;
    }

    public Action getUpdateAction() {
        return this.updateAction;
    }

    private void resetGlobFilter() {
        if (this.actualFileFilter != null) {
            JFileChooser jFileChooser = this.getFileChooser();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (fileFilter != null && fileFilter.equals(this.globFilter)) {
                jFileChooser.setFileFilter(this.actualFileFilter);
                jFileChooser.removeChoosableFileFilter(this.globFilter);
            }
            this.actualFileFilter = null;
        }
    }

    private static boolean isGlobPattern(String string) {
        return File.separatorChar == '\\' && string.indexOf(42) >= 0 || File.separatorChar == '/' && (string.indexOf(42) >= 0 || string.indexOf(63) >= 0 || string.indexOf(91) >= 0);
    }

    static class FileTransferHandler
    extends TransferHandler
    implements UIResource {
        FileTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            JTable jTable;
            int[] nArray;
            Object[] objectArray = null;
            if (jComponent instanceof JList) {
                objectArray = ((JList)jComponent).getSelectedValues();
            } else if (jComponent instanceof JTable && (nArray = (jTable = (JTable)jComponent).getSelectedRows()) != null) {
                objectArray = new Object[nArray.length];
                int n2 = 0;
                while (n2 < nArray.length) {
                    objectArray[n2] = jTable.getValueAt(nArray[n2], 0);
                    ++n2;
                }
            }
            if (objectArray != null) {
                return new FileTransferable(objectArray);
            }
            return null;
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        static class FileTransferable
        extends BasicListUI.ListTransferHandler.ListTransferable {
            FileTransferable(Object[] objectArray) {
                super(objectArray);
            }

            protected DataFlavor[] getRicherFlavors() {
                DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.javaFileListFlavor};
                return dataFlavorArray;
            }

            protected Object getRicherData(DataFlavor dataFlavor) {
                if (DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                    ArrayList arrayList = new ArrayList();
                    Object[] objectArray = this.getSelectedValues();
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        arrayList.add(objectArray[n2]);
                        ++n2;
                    }
                    return arrayList;
                }
                return null;
            }
        }
    }

    protected class BasicFileView
    extends FileView {
        protected Hashtable iconCache = new Hashtable();

        public void clearIconCache() {
            this.iconCache = new Hashtable();
        }

        public String getName(File file) {
            String string = null;
            if (file != null) {
                string = BasicFileChooserUI.this.getFileChooser().getFileSystemView().getSystemDisplayName(file);
            }
            return string;
        }

        public String getDescription(File file) {
            return file.getName();
        }

        public String getTypeDescription(File file) {
            String string = BasicFileChooserUI.this.getFileChooser().getFileSystemView().getSystemTypeDescription(file);
            if (string == null) {
                string = file.isDirectory() ? BasicFileChooserUI.this.directoryDescriptionText : BasicFileChooserUI.this.fileDescriptionText;
            }
            return string;
        }

        public Icon getCachedIcon(File file) {
            return (Icon)this.iconCache.get(file);
        }

        public void cacheIcon(File file, Icon icon) {
            if (file == null || icon == null) {
                return;
            }
            this.iconCache.put(file, icon);
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            icon = BasicFileChooserUI.this.fileIcon;
            if (file != null) {
                FileSystemView fileSystemView = BasicFileChooserUI.this.getFileChooser().getFileSystemView();
                if (fileSystemView.isFloppyDrive(file)) {
                    icon = BasicFileChooserUI.this.floppyDriveIcon;
                } else if (fileSystemView.isDrive(file)) {
                    icon = BasicFileChooserUI.this.hardDriveIcon;
                } else if (fileSystemView.isComputerNode(file)) {
                    icon = BasicFileChooserUI.this.computerIcon;
                } else if (file.isDirectory()) {
                    icon = BasicFileChooserUI.this.directoryIcon;
                }
            }
            this.cacheIcon(file, icon);
            return icon;
        }

        public Boolean isHidden(File file) {
            String string = file.getName();
            if (string != null && string.charAt(0) == '.') {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    protected class AcceptAllFileFilter
    extends FileFilter {
        public boolean accept(File file) {
            return true;
        }

        public String getDescription() {
            return UIManager.getString((Object)"FileChooser.acceptAllFileFilterText", BasicFileChooserUI.this.getFileChooser().getLocale());
        }
    }

    protected class UpdateAction
    extends AbstractAction {
        protected UpdateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = BasicFileChooserUI.this.getFileChooser();
            jFileChooser.setCurrentDirectory(jFileChooser.getFileSystemView().createFileObject(BasicFileChooserUI.this.getDirectoryName()));
            jFileChooser.rescanCurrentDirectory();
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        protected CancelSelectionAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.getFileChooser().cancelSelection();
        }
    }

    class GlobFilter
    extends FileFilter {
        Pattern pattern;
        String globPattern;

        GlobFilter() {
        }

        public void setPattern(String string) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length * 2];
            boolean bl2 = File.separatorChar == '\\';
            boolean bl3 = false;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            this.globPattern = string;
            if (bl2) {
                int n3 = cArray.length;
                if (string.endsWith("*.*")) {
                    n3 -= 2;
                }
                int n4 = 0;
                while (n4 < n3) {
                    if (cArray[n4] == '*') {
                        cArray2[n2++] = 46;
                    }
                    cArray2[n2++] = cArray[n4];
                    ++n4;
                }
            } else {
                int n5 = 0;
                while (n5 < cArray.length) {
                    switch (cArray[n5]) {
                        case '*': {
                            if (!bl3) {
                                cArray2[n2++] = 46;
                            }
                            cArray2[n2++] = 42;
                            break;
                        }
                        case '?': {
                            cArray2[n2++] = bl3 ? 63 : 46;
                            break;
                        }
                        case '[': {
                            bl3 = true;
                            cArray2[n2++] = cArray[n5];
                            if (n5 >= cArray.length - 1) break;
                            switch (cArray[n5 + 1]) {
                                case '!': 
                                case '^': {
                                    cArray2[n2++] = 94;
                                    ++n5;
                                    break;
                                }
                                case ']': {
                                    cArray2[n2++] = cArray[++n5];
                                }
                            }
                            break;
                        }
                        case ']': {
                            cArray2[n2++] = cArray[n5];
                            bl3 = false;
                            break;
                        }
                        case '\\': {
                            if (n5 == 0 && cArray.length > 1 && cArray[1] == '~') {
                                cArray2[n2++] = cArray[++n5];
                                break;
                            }
                            cArray2[n2++] = 92;
                            if (n5 < cArray.length - 1 && "*?[]".indexOf(cArray[n5 + 1]) >= 0) {
                                cArray2[n2++] = cArray[++n5];
                                break;
                            }
                            cArray2[n2++] = 92;
                            break;
                        }
                        default: {
                            if (!Character.isLetterOrDigit(cArray[n5])) {
                                cArray2[n2++] = 92;
                            }
                            cArray2[n2++] = cArray[n5];
                        }
                    }
                    ++n5;
                }
            }
            this.pattern = Pattern.compile(new String(cArray2, 0, n2), 2);
        }

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            return this.pattern.matcher(file.getName()).matches();
        }

        public String getDescription() {
            return this.globPattern;
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        protected ApproveSelectionAction() {
            super("approveSelection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            if (BasicFileChooserUI.this.isDirectorySelected() && (serializable = BasicFileChooserUI.this.getDirectory()) != null) {
                try {
                    serializable = ((File)serializable).getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                BasicFileChooserUI.this.getFileChooser().setCurrentDirectory((File)serializable);
                return;
            }
            serializable = BasicFileChooserUI.this.getFileChooser();
            String string = BasicFileChooserUI.this.getFileName();
            FileSystemView fileSystemView = ((JFileChooser)serializable).getFileSystemView();
            File file = ((JFileChooser)serializable).getCurrentDirectory();
            if (string != null) {
                string = string.trim();
            }
            if (string == null || string.equals("")) {
                BasicFileChooserUI.this.resetGlobFilter();
                return;
            }
            File file2 = null;
            File[] fileArray = null;
            if (string != null && !string.equals("")) {
                if (File.separatorChar == '/') {
                    if (string.startsWith("~/")) {
                        string = System.getProperty("user.home") + string.substring(1);
                    } else if (string.equals("~")) {
                        string = System.getProperty("user.home");
                    }
                }
                if (((JFileChooser)serializable).isMultiSelectionEnabled() && string.startsWith("\"")) {
                    ArrayList arrayList = new ArrayList();
                    if ((string = string.substring(1)).endsWith("\"")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    do {
                        String string2;
                        int n2;
                        if ((n2 = string.indexOf("\" \"")) > 0) {
                            string2 = string.substring(0, n2);
                            string = string.substring(n2 + 3);
                        } else {
                            string2 = string;
                            string = "";
                        }
                        File file3 = fileSystemView.createFileObject(string2);
                        if (!file3.isAbsolute()) {
                            file3 = fileSystemView.getChild(file, string2);
                        }
                        arrayList.add(file3);
                    } while (string.length() > 0);
                    if (arrayList.size() > 0) {
                        fileArray = (File[])arrayList.toArray(new File[arrayList.size()]);
                    }
                    BasicFileChooserUI.this.resetGlobFilter();
                } else {
                    file2 = fileSystemView.createFileObject(string);
                    if (!file2.isAbsolute()) {
                        file2 = fileSystemView.getChild(file, string);
                    }
                    FileFilter fileFilter = ((JFileChooser)serializable).getFileFilter();
                    if (!file2.exists() && BasicFileChooserUI.isGlobPattern(string)) {
                        if (BasicFileChooserUI.this.globFilter == null) {
                            BasicFileChooserUI.this.globFilter = new GlobFilter();
                        }
                        BasicFileChooserUI.this.globFilter.setPattern(string);
                        if (!(fileFilter instanceof GlobFilter)) {
                            BasicFileChooserUI.this.actualFileFilter = fileFilter;
                        }
                        ((JFileChooser)serializable).setFileFilter(null);
                        ((JFileChooser)serializable).setFileFilter(BasicFileChooserUI.this.globFilter);
                        return;
                    }
                    BasicFileChooserUI.this.resetGlobFilter();
                    boolean bl2 = file2 != null && file2.isDirectory();
                    boolean bl3 = file2 != null && ((JFileChooser)serializable).isTraversable(file2);
                    boolean bl4 = ((JFileChooser)serializable).isDirectorySelectionEnabled();
                    boolean bl5 = ((JFileChooser)serializable).isFileSelectionEnabled();
                    if (bl2 && bl3 && !bl4) {
                        ((JFileChooser)serializable).setCurrentDirectory(file2);
                        return;
                    }
                    if (!(!bl2 && bl5 || bl2 && bl4 || bl4 && !file2.exists())) {
                        file2 = null;
                    }
                }
            }
            if (fileArray != null || file2 != null) {
                if (fileArray != null) {
                    ((JFileChooser)serializable).setSelectedFiles(fileArray);
                } else if (((JFileChooser)serializable).isMultiSelectionEnabled()) {
                    ((JFileChooser)serializable).setSelectedFiles(new File[]{file2});
                } else {
                    ((JFileChooser)serializable).setSelectedFile(file2);
                }
                ((JFileChooser)serializable).approveSelection();
            } else {
                if (((JFileChooser)serializable).isMultiSelectionEnabled()) {
                    ((JFileChooser)serializable).setSelectedFiles(null);
                } else {
                    ((JFileChooser)serializable).setSelectedFile(null);
                }
                ((JFileChooser)serializable).cancelSelection();
            }
        }
    }

    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        protected ChangeToParentDirectoryAction() {
            super("Go Up");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component == null || !(component instanceof JTextComponent)) {
                BasicFileChooserUI.this.getFileChooser().changeToParentDirectory();
            }
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        protected GoHomeAction() {
            super("Go Home");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.getFileChooser().setCurrentDirectory(null);
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = BasicFileChooserUI.this.getFileChooser();
            File file = jFileChooser.getCurrentDirectory();
            File file2 = null;
            try {
                file2 = jFileChooser.getFileSystemView().createNewFolder(file);
                if (jFileChooser.isMultiSelectionEnabled()) {
                    jFileChooser.setSelectedFiles(new File[]{file2});
                } else {
                    jFileChooser.setSelectedFile(file2);
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(jFileChooser, BasicFileChooserUI.this.newFolderErrorText + BasicFileChooserUI.this.newFolderErrorSeparator + iOException, BasicFileChooserUI.this.newFolderErrorText, 0);
                return;
            }
            jFileChooser.rescanCurrentDirectory();
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                JFileChooser jFileChooser = BasicFileChooserUI.this.getFileChooser();
                JList jList = (JList)listSelectionEvent.getSource();
                if (jFileChooser.isMultiSelectionEnabled()) {
                    File[] fileArray = null;
                    Object[] objectArray = jList.getSelectedValues();
                    if (objectArray != null) {
                        if (objectArray.length == 1 && ((File)objectArray[0]).isDirectory() && jFileChooser.isTraversable((File)objectArray[0]) && (jFileChooser.getFileSelectionMode() != 1 || !jFileChooser.getFileSystemView().isFileSystem((File)objectArray[0]))) {
                            BasicFileChooserUI.this.setDirectorySelected(true);
                            BasicFileChooserUI.this.setDirectory((File)objectArray[0]);
                        } else {
                            ArrayList arrayList = new ArrayList(objectArray.length);
                            int n2 = 0;
                            while (n2 < objectArray.length) {
                                File file = (File)objectArray[n2];
                                if (jFileChooser.isFileSelectionEnabled() && file.isFile() || jFileChooser.isDirectorySelectionEnabled() && file.isDirectory()) {
                                    arrayList.add(file);
                                }
                                ++n2;
                            }
                            if (arrayList.size() > 0) {
                                fileArray = (File[])arrayList.toArray(new File[arrayList.size()]);
                            }
                            BasicFileChooserUI.this.setDirectorySelected(false);
                        }
                    }
                    jFileChooser.setSelectedFiles(fileArray);
                } else {
                    File file = (File)jList.getSelectedValue();
                    if (file != null && file.isDirectory() && jFileChooser.isTraversable(file) && (jFileChooser.getFileSelectionMode() != 1 || !jFileChooser.getFileSystemView().isFileSystem(file))) {
                        BasicFileChooserUI.this.setDirectorySelected(true);
                        BasicFileChooserUI.this.setDirectory(file);
                    } else {
                        BasicFileChooserUI.this.setDirectorySelected(false);
                        if (file != null) {
                            jFileChooser.setSelectedFile(file);
                        }
                    }
                }
            }
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        JList list;

        public DoubleClickListener(JList jList) {
            this.list = jList;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            TransferHandler transferHandler;
            TransferHandler transferHandler2 = BasicFileChooserUI.this.filechooser.getTransferHandler();
            if (transferHandler2 != (transferHandler = this.list.getTransferHandler())) {
                this.list.setTransferHandler(transferHandler2);
            }
            if (BasicFileChooserUI.this.filechooser.getDragEnabled() != this.list.getDragEnabled()) {
                this.list.setDragEnabled(BasicFileChooserUI.this.filechooser.getDragEnabled());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n2;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && (n2 = this.list.locationToIndex(mouseEvent.getPoint())) >= 0) {
                File file = (File)this.list.getModel().getElementAt(n2);
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (BasicFileChooserUI.this.getFileChooser().isTraversable(file)) {
                    this.list.clearSelection();
                    BasicFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
                } else {
                    BasicFileChooserUI.this.getFileChooser().approveSelection();
                }
            }
        }
    }
}

