/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Position;
import sun.awt.shell.ShellFolder;

public class MetalFileChooserUI
extends BasicFileChooserUI {
    private JPanel centerPanel;
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private JPanel listViewPanel;
    private JPanel detailsViewPanel;
    private JPanel currentViewPanel;
    private FocusListener editorFocusListener = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                MetalFileChooserUI.this.applyEdit();
            }
        }
    };
    private boolean useShellFolder;
    private ListSelectionModel listSelectionModel;
    private JList list;
    private JTable detailsTable;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private static final Dimension hstrut5 = new Dimension(5, 1);
    private static final Dimension hstrut11 = new Dimension(11, 1);
    private static final Dimension vstrut5 = new Dimension(1, 5);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 500;
    private static int MIN_HEIGHT = 326;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 405;
    private static int LIST_PREF_HEIGHT = 135;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private static final int COLUMN_FILENAME = 0;
    private static final int COLUMN_FILESIZE = 1;
    private static final int COLUMN_FILETYPE = 2;
    private static final int COLUMN_FILEDATE = 3;
    private static final int COLUMN_FILEATTR = 4;
    private static final int COLUMN_COLCOUNT = 5;
    private int[] COLUMN_WIDTHS = new int[]{150, 75, 130, 130, 40};
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private String fileNameHeaderText = null;
    private String fileSizeHeaderText = null;
    private String fileTypeHeaderText = null;
    private String fileDateHeaderText = null;
    private String fileAttrHeaderText = null;
    int lastIndex = -1;
    boolean editing = false;
    int editX = 20;
    JTextField editCell = null;
    static final int space = 10;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Object;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalFileChooserUI((JFileChooser)jComponent);
    }

    public MetalFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
    }

    public void installComponents(JFileChooser jFileChooser) {
        Object object;
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        jFileChooser.setBorder(new EmptyBorder(12, 12, 11, 11));
        jFileChooser.setLayout(new BorderLayout(0, 11));
        JPanel jPanel = new JPanel(new BorderLayout(11, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel.add((Component)jPanel2, "After");
        jFileChooser.add((Component)jPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        jPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        jPanel.add((Component)this.directoryComboBox, "Center");
        JButton jButton = new JButton(this.getChangeToParentDirectoryAction());
        jButton.setText(null);
        jButton.setIcon(this.upFolderIcon);
        jButton.setToolTipText(this.upFolderToolTipText);
        jButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(shrinkwrap);
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(hstrut5));
        File file = fileSystemView.getHomeDirectory();
        String string = this.homeFolderToolTipText;
        if (fileSystemView.isRoot(file)) {
            string = this.getFileView(jFileChooser).getName(file);
        }
        JButton jButton2 = new JButton(this.homeFolderIcon);
        jButton2.setToolTipText(string);
        jButton2.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        jButton2.setAlignmentX(0.0f);
        jButton2.setAlignmentY(0.5f);
        jButton2.setMargin(shrinkwrap);
        jButton2.addActionListener(this.getGoHomeAction());
        jPanel2.add(jButton2);
        jPanel2.add(Box.createRigidArea(hstrut5));
        jButton2 = new JButton(this.getNewFolderAction());
        jButton2.setText(null);
        jButton2.setIcon(this.newFolderIcon);
        jButton2.setToolTipText(this.newFolderToolTipText);
        jButton2.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        jButton2.setAlignmentX(0.0f);
        jButton2.setAlignmentY(0.5f);
        jButton2.setMargin(shrinkwrap);
        jPanel2.add(jButton2);
        jPanel2.add(Box.createRigidArea(hstrut5));
        ButtonGroup buttonGroup = new ButtonGroup();
        class ViewButtonListener
        implements ActionListener {
            JFileChooser fc;
            private final /* synthetic */ MetalFileChooserUI this$0;

            ViewButtonListener(MetalFileChooserUI metalFileChooserUI, JFileChooser jFileChooser) {
                this.this$0 = metalFileChooserUI;
                this.fc = jFileChooser;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                JPanel jPanel = MetalFileChooserUI.access$100(this.this$0);
                if (jToggleButton == MetalFileChooserUI.access$200(this.this$0)) {
                    if (MetalFileChooserUI.access$300(this.this$0) == null) {
                        MetalFileChooserUI.access$302(this.this$0, this.this$0.createDetailsView(this.fc));
                        MetalFileChooserUI.access$300(this.this$0).setPreferredSize(MetalFileChooserUI.access$400());
                    }
                    MetalFileChooserUI.access$102(this.this$0, MetalFileChooserUI.access$300(this.this$0));
                } else {
                    MetalFileChooserUI.access$102(this.this$0, MetalFileChooserUI.access$500(this.this$0));
                }
                if (MetalFileChooserUI.access$100(this.this$0) != jPanel) {
                    MetalFileChooserUI.access$600(this.this$0).remove(jPanel);
                    MetalFileChooserUI.access$600(this.this$0).add((Component)MetalFileChooserUI.access$100(this.this$0), "Center");
                    MetalFileChooserUI.access$600(this.this$0).revalidate();
                    MetalFileChooserUI.access$600(this.this$0).repaint();
                }
            }
        }
        ViewButtonListener viewButtonListener = new ViewButtonListener(this, jFileChooser);
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.getAccessibleContext().setAccessibleName(this.listViewButtonAccessibleName);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener(viewButtonListener);
        jPanel2.add(this.listViewButton);
        buttonGroup.add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.getAccessibleContext().setAccessibleName(this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener(viewButtonListener);
        jPanel2.add(this.detailsViewButton);
        buttonGroup.add(this.detailsViewButton);
        this.useShellFolder = false;
        Object object2 = fileSystemView.getRoots();
        if (object2 != null && ((File[])object2).length == 1 && (object = (File[])ShellFolder.get("fileChooserComboBoxFolders")) != null && ((File[])object).length > 0 && object2[0] == object[0]) {
            this.useShellFolder = true;
        }
        this.centerPanel = new JPanel(new BorderLayout());
        this.listViewPanel = this.createList(jFileChooser);
        this.listSelectionModel = this.list.getSelectionModel();
        this.listViewPanel.setPreferredSize(LIST_PREF_SIZE);
        this.centerPanel.add((Component)this.listViewPanel, "Center");
        this.currentViewPanel = this.listViewPanel;
        this.centerPanel.add((Component)this.getAccessoryPanel(), "After");
        object2 = jFileChooser.getAccessory();
        if (object2 != null) {
            this.getAccessoryPanel().add((Component)object2);
        }
        jFileChooser.add((Component)this.centerPanel, "Center");
        object = this.getBottomPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
        jFileChooser.add((Component)object, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        ((Container)object).add(jPanel3);
        ((Container)object).add(Box.createRigidArea(vstrut5));
        AlignedLabel alignedLabel = new AlignedLabel(this.fileNameLabelText);
        alignedLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        jPanel3.add(alignedLabel);
        this.fileNameTextField = new JTextField(){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        jPanel3.add(this.fileNameTextField);
        alignedLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (!MetalFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    MetalFileChooserUI.this.listSelectionModel.clearSelection();
                }
            }
        });
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFile()));
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        ((Container)object).add(jPanel4);
        AlignedLabel alignedLabel2 = new AlignedLabel(this.filesOfTypeLabelText);
        alignedLabel2.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        jPanel4.add(alignedLabel2);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        alignedLabel2.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        jPanel4.add(this.filterComboBox);
        this.getButtonPanel().setLayout(new ButtonAreaLayout());
        this.approveButton = new JButton(this.getApproveButtonText(jFileChooser));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.getButtonPanel().add(this.approveButton);
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (jFileChooser.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        MetalFileChooserUI.groupLabels(new AlignedLabel[]{alignedLabel, alignedLabel2});
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        Locale locale = jFileChooser.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", locale);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", locale);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", locale);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", locale);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", locale);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", locale);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", locale);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", locale);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", locale);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", locale);
        this.listViewButtonToolTipText = UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", locale);
        this.listViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.listViewButtonAccessibleName", locale);
        this.detailsViewButtonToolTipText = UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", locale);
        this.detailsViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.detailsViewButtonAccessibleName", locale);
        this.fileNameHeaderText = UIManager.getString((Object)"FileChooser.fileNameHeaderText", locale);
        this.fileSizeHeaderText = UIManager.getString((Object)"FileChooser.fileSizeHeaderText", locale);
        this.fileTypeHeaderText = UIManager.getString((Object)"FileChooser.fileTypeHeaderText", locale);
        this.fileDateHeaderText = UIManager.getString((Object)"FileChooser.fileDateHeaderText", locale);
        this.fileAttrHeaderText = UIManager.getString((Object)"FileChooser.fileAttrHeaderText", locale);
    }

    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jFileChooser, actionMap);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MetalFileChooserUI.this.editing) {
                    MetalFileChooserUI.this.cancelEdit();
                } else {
                    MetalFileChooserUI.this.getFileChooser().cancelSelection();
                }
            }

            public boolean isEnabled() {
                return MetalFileChooserUI.this.getFileChooser().isEnabled();
            }
        };
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("approveSelection", this.getApproveSelectionAction());
        actionMapUIResource.put("cancelSelection", abstractAction);
        actionMapUIResource.put("Go Up", this.getChangeToParentDirectoryAction());
        return actionMapUIResource;
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        JPanel jPanel = new JPanel(new BorderLayout());
        final JFileChooser jFileChooser2 = jFileChooser;
        this.list = new JList(){

            public int getNextMatch(String string, int n2, Position.Bias bias) {
                ListModel listModel = this.getModel();
                int n3 = listModel.getSize();
                if (string == null || n2 < 0 || n2 >= n3) {
                    throw new IllegalArgumentException();
                }
                boolean bl2 = bias == Position.Bias.Backward;
                int n4 = n2;
                while (!bl2 ? n4 < n3 : n4 >= 0) {
                    String string2 = jFileChooser2.getName((File)listModel.getElementAt(n4));
                    if (string2.regionMatches(true, 0, string, 0, string.length())) {
                        return n4;
                    }
                    n4 += bl2 ? -1 : 1;
                }
                return -1;
            }
        };
        this.list.setCellRenderer(new FileRenderer());
        this.list.setLayoutOrientation(1);
        this.list.setVisibleRowCount(-1);
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
        this.list.setModel(this.getModel());
        this.list.addListSelectionListener(this.createListSelectionListener(jFileChooser));
        this.list.addMouseListener(this.createDoubleClickListener(jFileChooser, this.list));
        this.list.addMouseListener(this.createSingleClickListener(jFileChooser, this.list));
        this.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected JPanel createDetailsView(JFileChooser jFileChooser) {
        final JFileChooser jFileChooser2 = jFileChooser;
        JPanel jPanel = new JPanel(new BorderLayout());
        DetailsTableModel detailsTableModel = new DetailsTableModel(jFileChooser2);
        this.detailsTable = new JTable(detailsTableModel){

            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl2) {
                if (keyEvent.getKeyCode() == 27 && this.getCellEditor() == null) {
                    jFileChooser2.dispatchEvent(keyEvent);
                    return true;
                }
                return super.processKeyBinding(keyStroke, keyEvent, n2, bl2);
            }
        };
        this.detailsTable.setComponentOrientation(jFileChooser2.getComponentOrientation());
        this.detailsTable.setAutoResizeMode(0);
        this.detailsTable.setShowGrid(false);
        this.detailsTable.setSelectionModel(this.listSelectionModel);
        this.detailsTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        TableColumnModel tableColumnModel = this.detailsTable.getColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[5];
        int n2 = 0;
        while (n2 < 5) {
            tableColumnArray[n2] = tableColumnModel.getColumn(n2);
            tableColumnArray[n2].setPreferredWidth(this.COLUMN_WIDTHS[n2]);
            ++n2;
        }
        if (!System.getProperty("os.name").startsWith("Windows")) {
            tableColumnModel.removeColumn(tableColumnArray[2]);
            tableColumnModel.removeColumn(tableColumnArray[4]);
        }
        DetailsTableCellRenderer detailsTableCellRenderer = new DetailsTableCellRenderer(jFileChooser2);
        this.detailsTable.setDefaultRenderer(class$java$io$File == null ? (class$java$io$File = MetalFileChooserUI.class$("java.io.File")) : class$java$io$File, detailsTableCellRenderer);
        this.detailsTable.setDefaultRenderer(class$java$util$Date == null ? (class$java$util$Date = MetalFileChooserUI.class$("java.util.Date")) : class$java$util$Date, detailsTableCellRenderer);
        this.detailsTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = MetalFileChooserUI.class$("java.lang.Object")) : class$java$lang$Object, detailsTableCellRenderer);
        final JTextField jTextField = new JTextField();
        jTextField.addFocusListener(this.editorFocusListener);
        tableColumnArray[0].setCellEditor(new DefaultCellEditor(jTextField){

            public boolean isCellEditable(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    int n2 = MetalFileChooserUI.this.detailsTable.rowAtPoint(mouseEvent.getPoint());
                    return mouseEvent.getClickCount() == 1 && MetalFileChooserUI.this.detailsTable.isRowSelected(n2);
                }
                return super.isCellEditable(eventObject);
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
                Component component = super.getTableCellEditorComponent(jTable, object, bl2, n2, n3);
                if (object instanceof File) {
                    jTextField.setText(jFileChooser2.getName((File)object));
                    jTextField.requestFocus();
                    jTextField.selectAll();
                }
                return component;
            }
        });
        JList jList = new JList(detailsTableModel.listModel){
            JTable table;
            {
                this.table = MetalFileChooserUI.this.detailsTable;
            }

            public int locationToIndex(Point point) {
                return this.table.rowAtPoint(point);
            }

            public Rectangle getCellBounds(int n2, int n3) {
                Rectangle rectangle = this.table.getCellRect(n2, 0, false);
                Rectangle rectangle2 = this.table.getCellRect(n3, 0, false);
                return rectangle.union(rectangle2);
            }

            public Object getSelectedValue() {
                return this.table.getValueAt(this.table.getSelectedRow(), 0);
            }

            public Component add(Component component) {
                if (component instanceof JTextField) {
                    return this.table.add(component);
                }
                return super.add(component);
            }

            public void repaint() {
                if (this.table != null) {
                    this.table.repaint();
                }
            }

            public TransferHandler getTransferHandler() {
                if (this.table != null) {
                    return this.table.getTransferHandler();
                }
                return super.getTransferHandler();
            }

            public void setTransferHandler(TransferHandler transferHandler) {
                if (this.table != null) {
                    this.table.setTransferHandler(transferHandler);
                } else {
                    super.setTransferHandler(transferHandler);
                }
            }

            public boolean getDragEnabled() {
                if (this.table != null) {
                    return this.table.getDragEnabled();
                }
                return super.getDragEnabled();
            }

            public void setDragEnabled(boolean bl2) {
                if (this.table != null) {
                    this.table.setDragEnabled(bl2);
                } else {
                    super.setDragEnabled(bl2);
                }
            }
        };
        jList.setSelectionModel(this.listSelectionModel);
        this.detailsTable.addMouseListener(this.createDoubleClickListener(jFileChooser2, jList));
        JScrollPane jScrollPane = new JScrollPane(this.detailsTable);
        jScrollPane.setComponentOrientation(jFileChooser2.getComponentOrientation());
        LookAndFeel.installColors(jScrollPane.getViewport(), "Table.background", "Table.foreground");
        jScrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                JScrollPane jScrollPane = (JScrollPane)componentEvent.getComponent();
                MetalFileChooserUI.this.fixNameColumnWidth(jScrollPane.getViewport().getSize().width);
                jScrollPane.removeComponentListener(this);
            }
        });
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void fixNameColumnWidth(int n2) {
        TableColumn tableColumn = this.detailsTable.getColumnModel().getColumn(0);
        int n3 = this.detailsTable.getPreferredSize().width;
        if (n3 < n2) {
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n2 - n3);
        }
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new BasicFileChooserUI.SelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    JFileChooser jFileChooser = MetalFileChooserUI.this.getFileChooser();
                    FileSystemView fileSystemView = jFileChooser.getFileSystemView();
                    JList jList = (JList)listSelectionEvent.getSource();
                    if (jFileChooser.isMultiSelectionEnabled()) {
                        File[] fileArray = null;
                        Object[] objectArray = jList.getSelectedValues();
                        if (objectArray != null) {
                            if (objectArray.length == 1 && ((File)objectArray[0]).isDirectory() && jFileChooser.isTraversable((File)objectArray[0]) && (jFileChooser.getFileSelectionMode() == 0 || !fileSystemView.isFileSystem((File)objectArray[0]))) {
                                MetalFileChooserUI.this.setDirectorySelected(true);
                                MetalFileChooserUI.super.setDirectory((File)objectArray[0]);
                            } else {
                                File[] fileArray2;
                                fileArray = new File[objectArray.length];
                                int n2 = 0;
                                int n3 = 0;
                                while (n3 < objectArray.length) {
                                    fileArray2 = (File[])objectArray[n3];
                                    if (jFileChooser.isFileSelectionEnabled() && fileArray2.isFile() || jFileChooser.isDirectorySelectionEnabled() && fileSystemView.isFileSystem((File)fileArray2) && fileArray2.isDirectory()) {
                                        fileArray[n2++] = fileArray2;
                                    }
                                    ++n3;
                                }
                                if (n2 == 0) {
                                    fileArray = null;
                                } else if (n2 < objectArray.length) {
                                    fileArray2 = new File[n2];
                                    System.arraycopy(fileArray, 0, fileArray2, 0, n2);
                                    fileArray = fileArray2;
                                }
                                MetalFileChooserUI.this.setDirectorySelected(false);
                            }
                        }
                        jFileChooser.setSelectedFiles(fileArray);
                    } else {
                        File file = (File)jList.getSelectedValue();
                        if (file != null && file.isDirectory() && jFileChooser.isTraversable(file) && (jFileChooser.getFileSelectionMode() == 0 || !fileSystemView.isFileSystem(file))) {
                            MetalFileChooserUI.this.setDirectorySelected(true);
                            MetalFileChooserUI.super.setDirectory(file);
                            jFileChooser.setSelectedFile(null);
                        } else {
                            MetalFileChooserUI.this.setDirectorySelected(false);
                            if (file != null) {
                                jFileChooser.setSelectedFile(file);
                            }
                        }
                    }
                }
            }
        };
    }

    private MouseListener createSingleClickListener(JFileChooser jFileChooser, JList jList) {
        return new SingleClickListener(jList);
    }

    private int getEditIndex() {
        return this.lastIndex;
    }

    private void setEditIndex(int n2) {
        this.lastIndex = n2;
    }

    private void resetEditIndex() {
        this.lastIndex = -1;
    }

    private void cancelEdit() {
        if (this.editing) {
            this.editing = false;
            this.list.remove(this.editCell);
            this.centerPanel.repaint();
        } else if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().cancelCellEditing();
        }
    }

    private void editFileName(int n2) {
        this.ensureIndexIsVisible(n2);
        if (this.listViewPanel.isVisible()) {
            this.editing = true;
            Rectangle rectangle = this.list.getCellBounds(n2, n2);
            if (this.editCell == null) {
                this.editCell = new JTextField();
                this.editCell.addActionListener(new EditActionListener());
                this.editCell.addFocusListener(this.editorFocusListener);
                this.editCell.setNextFocusableComponent(this.list);
            }
            this.list.add(this.editCell);
            File file = (File)this.getModel().getElementAt(n2);
            this.editCell.setText(this.getFileChooser().getName(file));
            if (this.list.getComponentOrientation().isLeftToRight()) {
                this.editCell.setBounds(this.editX + rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
            } else {
                this.editCell.setBounds(rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
            }
            this.editCell.requestFocus();
            this.editCell.selectAll();
        } else if (this.detailsViewPanel.isVisible()) {
            this.detailsTable.editCellAt(n2, 0);
        }
    }

    private void applyEdit() {
        if (this.editing) {
            JFileChooser jFileChooser = this.getFileChooser();
            File file = null;
            file = this.isDirectorySelected() ? this.getDirectory() : jFileChooser.getSelectedFile();
            if (file != null) {
                String string = jFileChooser.getName(file);
                String string2 = file.getName();
                String string3 = this.editCell.getText().trim();
                if (!string3.equals(string)) {
                    int n2;
                    String string4 = string3;
                    int n3 = string2.length();
                    if (n3 > (n2 = string.length()) && string2.charAt(n2) == '.') {
                        string4 = string3 + string2.substring(n2);
                    }
                    FileSystemView fileSystemView = jFileChooser.getFileSystemView();
                    File file2 = fileSystemView.createFileObject(file.getParentFile(), string4);
                    if (this.getModel().renameFile(file, file2) && fileSystemView.isParent(jFileChooser.getCurrentDirectory(), file2)) {
                        if (jFileChooser.isMultiSelectionEnabled()) {
                            jFileChooser.setSelectedFiles(new File[]{file2});
                        } else {
                            jFileChooser.setSelectedFile(file2);
                        }
                    }
                }
            }
        }
        if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().stopCellEditing();
        }
        this.cancelEdit();
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n2 = MetalFileChooserUI.PREF_SIZE.width;
        Dimension dimension = jComponent.getLayout().preferredLayoutSize(jComponent);
        if (dimension != null) {
            return new Dimension(dimension.width < n2 ? n2 : dimension.width, dimension.height < MetalFileChooserUI.PREF_SIZE.height ? MetalFileChooserUI.PREF_SIZE.height : dimension.height);
        }
        return new Dimension(n2, MetalFileChooserUI.PREF_SIZE.height);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            int n2;
            int n3;
            int n4;
            File[] fileArray = this.getFileChooser().getSelectedFiles();
            Object[] objectArray = this.list.getSelectedValues();
            int n5 = 0;
            while (n5 < objectArray.length) {
                n4 = 0;
                n3 = 0;
                while (n3 < fileArray.length) {
                    if (fileArray[n3].equals(objectArray[n5])) {
                        n4 = 1;
                        break;
                    }
                    ++n3;
                }
                if (n4 == 0 && (n2 = this.getModel().indexOf(objectArray[n5])) >= 0) {
                    this.listSelectionModel.removeSelectionInterval(n2, n2);
                }
                ++n5;
            }
            n4 = 0;
            while (n4 < fileArray.length) {
                int n6;
                n3 = 0;
                n2 = 0;
                while (n2 < objectArray.length) {
                    if (fileArray[n4].equals(objectArray[n2])) {
                        n3 = 1;
                        break;
                    }
                    ++n2;
                }
                if (n3 == 0 && (n6 = this.getModel().indexOf(fileArray[n4])) >= 0) {
                    this.listSelectionModel.addSelectionInterval(n6, n6);
                }
                ++n4;
            }
        } else {
            int n7;
            JFileChooser jFileChooser = this.getFileChooser();
            File file = null;
            file = this.isDirectorySelected() ? this.getDirectory() : jFileChooser.getSelectedFile();
            if (file != null && (n7 = this.getModel().indexOf(file)) >= 0) {
                this.listSelectionModel.setSelectionInterval(n7, n7);
                this.ensureIndexIsVisible(n7);
            } else {
                this.listSelectionModel.clearSelection();
            }
        }
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (fileArray != null && n2 < fileArray.length) {
            if (n2 > 0) {
                stringBuffer.append(" ");
            }
            if (fileArray.length > 1) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(this.fileNameString(fileArray[n2]));
            if (fileArray.length > 1) {
                stringBuffer.append("\"");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File file = (File)propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && (jFileChooser.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && jFileChooser.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(file));
        } else {
            this.setFileName(null);
        }
        this.setFileSelected();
    }

    private void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File[] fileArray = (File[])propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (fileArray != null && fileArray.length > 0 && (fileArray.length > 1 || jFileChooser.isDirectorySelectionEnabled() || !fileArray[0].isDirectory())) {
            this.setFileName(this.fileNameString(fileArray));
        } else {
            this.setFileName(null);
        }
        this.setFileSelected();
    }

    private void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        this.ensureIndexIsVisible(0);
        File file = jFileChooser.getCurrentDirectory();
        if (file != null) {
            this.directoryComboBoxModel.addItem(file);
            this.getNewFolderAction().setEnabled(fileSystemView.isFileSystem(file) && file.canWrite());
            this.getChangeToParentDirectoryAction().setEnabled(!fileSystemView.isRoot(file));
            if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled() && fileSystemView.isFileSystem(file)) {
                this.setFileName(file.getPath());
            } else {
                this.setFileName(null);
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null && jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled() && jFileChooser.getFileSystemView().isFileSystem(file)) {
            this.setFileName(file.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.listSelectionModel.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() != null) {
            JComponent jComponent;
            if (propertyChangeEvent.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
            }
            if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        if (jFileChooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    MetalFileChooserUI.this.doSelectedFileChanged(propertyChangeEvent);
                } else if (string.equals("SelectedFilesChangedProperty")) {
                    MetalFileChooserUI.this.doSelectedFilesChanged(propertyChangeEvent);
                } else if (string.equals("directoryChanged")) {
                    MetalFileChooserUI.this.doDirectoryChanged(propertyChangeEvent);
                } else if (string.equals("fileFilterChanged")) {
                    MetalFileChooserUI.this.doFilterChanged(propertyChangeEvent);
                } else if (string.equals("fileSelectionChanged")) {
                    MetalFileChooserUI.this.doFileSelectionModeChanged(propertyChangeEvent);
                } else if (string.equals("MultiSelectionEnabledChangedProperty")) {
                    MetalFileChooserUI.this.doMultiSelectionChanged(propertyChangeEvent);
                } else if (string.equals("AccessoryChangedProperty")) {
                    MetalFileChooserUI.this.doAccessoryChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonTextChangedProperty") || string.equals("ApproveButtonToolTipTextChangedProperty")) {
                    MetalFileChooserUI.this.doApproveButtonTextChanged(propertyChangeEvent);
                } else if (string.equals("DialogTypeChangedProperty")) {
                    MetalFileChooserUI.this.doDialogTypeChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    MetalFileChooserUI.this.doApproveButtonMnemonicChanged(propertyChangeEvent);
                } else if (string.equals("ControlButtonsAreShownChangedProperty")) {
                    MetalFileChooserUI.this.doControlButtonsChanged(propertyChangeEvent);
                } else if (string.equals("CancelSelection")) {
                    MetalFileChooserUI.this.applyEdit();
                } else if (string.equals("componentOrientation")) {
                    ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                    JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                    if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                        jFileChooser.applyComponentOrientation(componentOrientation);
                    }
                    if (MetalFileChooserUI.this.detailsTable != null) {
                        MetalFileChooserUI.this.detailsTable.setComponentOrientation(componentOrientation);
                        MetalFileChooserUI.this.detailsTable.getParent().getParent().setComponentOrientation(componentOrientation);
                    }
                } else if (string.equals("ancestor") && propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
                    MetalFileChooserUI.this.fileNameTextField.selectAll();
                    MetalFileChooserUI.this.fileNameTextField.requestFocus();
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    private void ensureIndexIsVisible(int n2) {
        if (n2 >= 0) {
            this.list.ensureIndexIsVisible(n2);
            if (this.detailsTable != null) {
                this.detailsTable.scrollRectToVisible(this.detailsTable.getCellRect(n2, 0, true));
            }
        }
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        this.ensureIndexIsVisible(this.getModel().indexOf(file));
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getModel().validateFileCache();
    }

    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    public void setFileName(String string) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(string);
        }
    }

    protected void setDirectorySelected(boolean bl2) {
        super.setDirectorySelected(bl2);
        JFileChooser jFileChooser = this.getFileChooser();
        if (bl2) {
            this.approveButton.setText(this.directoryOpenButtonText);
            this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
        } else {
            this.approveButton.setText(this.getApproveButtonText(jFileChooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String string) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getSelectedFile();
        if (!listSelectionEvent.getValueIsAdjusting() && file != null && !this.getFileChooser().isTraversable(file)) {
            this.setFileName(this.fileNameString(file));
        }
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    private static void groupLabels(AlignedLabel[] alignedLabelArray) {
        int n2 = 0;
        while (n2 < alignedLabelArray.length) {
            AlignedLabel.access$3902(alignedLabelArray[n2], alignedLabelArray);
            ++n2;
        }
    }

    static /* synthetic */ JPanel access$100(MetalFileChooserUI metalFileChooserUI) {
        return metalFileChooserUI.currentViewPanel;
    }

    static /* synthetic */ JToggleButton access$200(MetalFileChooserUI metalFileChooserUI) {
        return metalFileChooserUI.detailsViewButton;
    }

    static /* synthetic */ JPanel access$300(MetalFileChooserUI metalFileChooserUI) {
        return metalFileChooserUI.detailsViewPanel;
    }

    static /* synthetic */ JPanel access$302(MetalFileChooserUI metalFileChooserUI, JPanel jPanel) {
        metalFileChooserUI.detailsViewPanel = jPanel;
        return metalFileChooserUI.detailsViewPanel;
    }

    static /* synthetic */ Dimension access$400() {
        return LIST_PREF_SIZE;
    }

    static /* synthetic */ JPanel access$102(MetalFileChooserUI metalFileChooserUI, JPanel jPanel) {
        metalFileChooserUI.currentViewPanel = jPanel;
        return metalFileChooserUI.currentViewPanel;
    }

    static /* synthetic */ JPanel access$500(MetalFileChooserUI metalFileChooserUI) {
        return metalFileChooserUI.listViewPanel;
    }

    static /* synthetic */ JPanel access$600(MetalFileChooserUI metalFileChooserUI) {
        return metalFileChooserUI.centerPanel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class AlignedLabel
    extends JLabel {
        private AlignedLabel[] group;
        private int maxWidth;

        AlignedLabel(String string) {
            super(string);
            this.maxWidth = 0;
            this.setAlignmentX(0.0f);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 11, dimension.height);
        }

        private int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.group.length) {
                    n2 = Math.max(this.group[n3].getSuperPreferredWidth(), n2);
                    ++n3;
                }
                int n4 = 0;
                while (n4 < this.group.length) {
                    this.group[n4].maxWidth = n2;
                    ++n4;
                }
            }
            return this.maxWidth;
        }

        private int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }

        static /* synthetic */ AlignedLabel[] access$3902(AlignedLabel alignedLabel, AlignedLabel[] alignedLabelArray) {
            alignedLabel.group = alignedLabelArray;
            return alignedLabelArray;
        }
    }

    private static class ButtonAreaLayout
    implements LayoutManager {
        private int hGap = 5;
        private int topMargin = 17;

        private ButtonAreaLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Component[] componentArray = container.getComponents();
            if (componentArray != null && componentArray.length > 0) {
                int n2;
                int n3;
                int n4 = componentArray.length;
                Dimension[] dimensionArray = new Dimension[n4];
                Insets insets = container.getInsets();
                int n5 = insets.top + this.topMargin;
                int n6 = 0;
                int n7 = 0;
                while (n7 < n4) {
                    dimensionArray[n7] = componentArray[n7].getPreferredSize();
                    n6 = Math.max(n6, dimensionArray[n7].width);
                    ++n7;
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    n3 = container.getSize().width - insets.left - n6;
                    n2 = this.hGap + n6;
                } else {
                    n3 = insets.left;
                    n2 = -(this.hGap + n6);
                }
                int n8 = n4 - 1;
                while (n8 >= 0) {
                    componentArray[n8].setBounds(n3, n5, n6, dimensionArray[n8].height);
                    n3 -= n2;
                    --n8;
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            Component[] componentArray;
            if (container != null && (componentArray = container.getComponents()) != null && componentArray.length > 0) {
                int n2 = componentArray.length;
                int n3 = 0;
                Insets insets = container.getInsets();
                int n4 = this.topMargin + insets.top + insets.bottom;
                int n5 = insets.left + insets.right;
                int n6 = 0;
                int n7 = 0;
                while (n7 < n2) {
                    Dimension dimension = componentArray[n7].getPreferredSize();
                    n3 = Math.max(n3, dimension.height);
                    n6 = Math.max(n6, dimension.width);
                    ++n7;
                }
                return new Dimension(n5 + n2 * n6 + (n2 - 1) * this.hGap, n4 + n3);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = (File)MetalFileChooserUI.this.directoryComboBox.getSelectedItem();
            MetalFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = MetalFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                MetalFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                MetalFileChooserUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = MetalFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl2 = false;
            if (fileFilter != null) {
                int n2 = 0;
                while (n2 < this.filters.length) {
                    if (this.filters[n2] == fileFilter) {
                        bl2 = true;
                    }
                    ++n2;
                }
                if (!bl2) {
                    MetalFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return MetalFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int n2) {
            if (n2 > this.getSize() - 1) {
                return MetalFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n2];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            if (object != null && object instanceof FileFilter) {
                this.setText(((FileFilter)object).getDescription());
            }
            return this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = MetalFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File file = MetalFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }

        private void addItem(File file) {
            if (file == null) {
                return;
            }
            this.directories.clear();
            Object[] objectArray = MetalFileChooserUI.this.useShellFolder ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(objectArray));
            File file2 = null;
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                file2 = file;
            }
            try {
                ShellFolder shellFolder;
                File file3 = shellFolder = ShellFolder.getShellFolder(file2);
                Vector vector = new Vector(10);
                do {
                    vector.addElement(file3);
                } while ((file3 = ((File)file3).getParentFile()) != null);
                int n2 = vector.size();
                int n3 = 0;
                while (n3 < n2) {
                    file3 = (File)vector.get(n3);
                    if (this.directories.contains(file3)) {
                        int n4 = this.directories.indexOf(file3);
                        int n5 = n3 - 1;
                        while (n5 >= 0) {
                            this.directories.insertElementAt(vector.get(n5), n4 + n3 - n5);
                            --n5;
                        }
                        break;
                    }
                    ++n3;
                }
                this.calculateDepths();
                this.setSelectedItem(shellFolder);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            int n2 = 0;
            while (n2 < this.depths.length) {
                File file = (File)this.directories.get(n2);
                File file2 = file.getParentFile();
                this.depths[n2] = 0;
                if (file2 != null) {
                    int n3 = n2 - 1;
                    while (n3 >= 0) {
                        if (file2.equals((File)this.directories.get(n3))) {
                            this.depths[n2] = this.depths[n3] + 1;
                            break;
                        }
                        --n3;
                    }
                }
                ++n2;
            }
        }

        public int getDepth(int n2) {
            return this.depths != null && n2 >= 0 && n2 < this.depths.length ? this.depths[n2] : 0;
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int n2) {
            return this.directories.elementAt(n2);
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            if (component.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(component, graphics, n2 + this.depth * 10, n3);
            } else {
                this.icon.paintIcon(component, graphics, n2, n3);
            }
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            Icon icon;
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            if (object == null) {
                this.setText("");
                return this;
            }
            File file = (File)object;
            this.setText(MetalFileChooserUI.this.getFileChooser().getName(file));
            this.ii.icon = icon = MetalFileChooserUI.this.getFileChooser().getIcon(file);
            this.ii.depth = MetalFileChooserUI.this.directoryComboBoxModel.getDepth(n2);
            this.setIcon(this.ii);
            return this;
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            File file = (File)object;
            String string = MetalFileChooserUI.this.getFileChooser().getName(file);
            this.setText(string);
            Icon icon = MetalFileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (bl2) {
                MetalFileChooserUI.this.editX = icon.getIconWidth() + 4;
            }
            return this;
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MetalFileChooserUI.this.applyEdit();
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        JList list;

        public SingleClickListener(JList jList) {
            this.list = jList;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (mouseEvent.getClickCount() == 1) {
                    JFileChooser jFileChooser = MetalFileChooserUI.this.getFileChooser();
                    int n2 = this.list.locationToIndex(mouseEvent.getPoint());
                    if (!(jFileChooser.isMultiSelectionEnabled() && jFileChooser.getSelectedFiles().length > 1 || n2 < 0 || !this.list.isSelectedIndex(n2) || MetalFileChooserUI.this.getEditIndex() != n2 || MetalFileChooserUI.this.editing)) {
                        MetalFileChooserUI.this.editFileName(n2);
                    } else if (n2 >= 0) {
                        MetalFileChooserUI.this.setEditIndex(n2);
                    } else {
                        MetalFileChooserUI.this.resetEditIndex();
                    }
                } else {
                    MetalFileChooserUI.this.resetEditIndex();
                }
            }
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        DelayedSelectionUpdater() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            MetalFileChooserUI.this.setFileSelected();
        }
    }

    class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        JFileChooser chooser;
        DateFormat df;

        DetailsTableCellRenderer(JFileChooser jFileChooser) {
            this.chooser = jFileChooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, jFileChooser.getLocale());
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (n3 == 1 || n3 == 4) {
                this.setHorizontalAlignment(11);
            } else {
                this.setHorizontalAlignment(10);
            }
            return super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
        }

        public void setValue(Object object) {
            this.setIcon(null);
            if (object instanceof File) {
                File file = (File)object;
                String string = this.chooser.getName(file);
                this.setText(string);
                Icon icon = this.chooser.getIcon(file);
                this.setIcon(icon);
            } else if (object instanceof Date) {
                this.setText(object == null ? "" : this.df.format((Date)object));
            } else {
                super.setValue(object);
            }
        }
    }

    class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener {
        String[] columnNames;
        JFileChooser chooser;
        ListModel listModel;

        DetailsTableModel(JFileChooser jFileChooser) {
            this.columnNames = new String[]{MetalFileChooserUI.this.fileNameHeaderText, MetalFileChooserUI.this.fileSizeHeaderText, MetalFileChooserUI.this.fileTypeHeaderText, MetalFileChooserUI.this.fileDateHeaderText, MetalFileChooserUI.this.fileAttrHeaderText};
            this.chooser = jFileChooser;
            this.listModel = MetalFileChooserUI.this.getModel();
            this.listModel.addListDataListener(this);
        }

        public int getRowCount() {
            return this.listModel.getSize();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int n2) {
            return this.columnNames[n2];
        }

        public Class getColumnClass(int n2) {
            switch (n2) {
                case 0: {
                    return class$java$io$File == null ? (class$java$io$File = MetalFileChooserUI.class$("java.io.File")) : class$java$io$File;
                }
                case 3: {
                    return class$java$util$Date == null ? (class$java$util$Date = MetalFileChooserUI.class$("java.util.Date")) : class$java$util$Date;
                }
            }
            return super.getColumnClass(n2);
        }

        public Object getValueAt(int n2, int n3) {
            File file = (File)this.listModel.getElementAt(n2);
            switch (n3) {
                case 0: {
                    return file;
                }
                case 1: {
                    if (!file.exists() || file.isDirectory()) {
                        return null;
                    }
                    long l2 = file.length() / 1024L;
                    if (l2 < 1024L) {
                        return (l2 == 0L ? 1L : l2) + " KB";
                    }
                    if ((l2 /= 1024L) < 1024L) {
                        return l2 + " MB";
                    }
                    return (l2 /= 1024L) + " GB";
                }
                case 2: {
                    if (!file.exists()) {
                        return null;
                    }
                    return this.chooser.getFileSystemView().getSystemTypeDescription(file);
                }
                case 3: {
                    if (!file.exists() || this.chooser.getFileSystemView().isFileSystemRoot(file)) {
                        return null;
                    }
                    long l3 = file.lastModified();
                    return l3 == 0L ? null : new Date(l3);
                }
                case 4: {
                    if (!file.exists() || this.chooser.getFileSystemView().isFileSystemRoot(file)) {
                        return null;
                    }
                    String string = "";
                    if (!file.canWrite()) {
                        string = string + "R";
                    }
                    if (file.isHidden()) {
                        string = string + "H";
                    }
                    return string;
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n2, int n3) {
            if (n3 == 0) {
                JFileChooser jFileChooser = MetalFileChooserUI.this.getFileChooser();
                File file = (File)this.getValueAt(n2, n3);
                if (file != null) {
                    String string = jFileChooser.getName(file);
                    String string2 = file.getName();
                    String string3 = ((String)object).trim();
                    if (!string3.equals(string)) {
                        int n4;
                        String string4 = string3;
                        int n5 = string2.length();
                        if (n5 > (n4 = string.length()) && string2.charAt(n4) == '.') {
                            string4 = string3 + string2.substring(n4);
                        }
                        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
                        File file2 = fileSystemView.createFileObject(file.getParentFile(), string4);
                        if (MetalFileChooserUI.this.getModel().renameFile(file, file2) && fileSystemView.isParent(jFileChooser.getCurrentDirectory(), file2)) {
                            if (jFileChooser.isMultiSelectionEnabled()) {
                                jFileChooser.setSelectedFiles(new File[]{file2});
                            } else {
                                jFileChooser.setSelectedFile(file2);
                            }
                        }
                    }
                }
            }
        }

        public boolean isCellEditable(int n2, int n3) {
            return n3 == 0;
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }
    }
}

