/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import sun.awt.FontProperties;

public class MFontProperties
extends FontProperties {
    protected void verifyProperties(File file) {
        try {
            String string;
            String string2;
            if (file.getPath().endsWith("properties")) {
                string2 = this.getProperty("sansserif.plain.0");
                if (string2 == null) {
                    string2 = this.getProperty("sansserif.0");
                }
                string = null;
            } else {
                string2 = this.getProperty("serif.plain.0");
                if (string2 == null) {
                    string2 = this.getProperty("serif.0");
                }
                if ((string = this.getProperty("serif.plain.1")) == null) {
                    string = this.getProperty("serif.1");
                }
            }
            if (GraphicsEnvironment.isHeadless() || !this.validPropertiesFile(string2, string)) {
                File file2;
                String string3 = file.getPath();
                if (string3.endsWith(FontProperties.osVersion)) {
                    string3 = string3.substring(0, string3.length() - FontProperties.osVersion.length() - 1);
                }
                if (!(file2 = new File(string3 + ".5.5.1")).exists() && !(file2 = new File(string3 + ".rf")).exists()) {
                    file2 = null;
                }
                if (file2 != null) {
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    this.clear();
                    this.load(fileInputStream);
                    fileInputStream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private native boolean validPropertiesFile(String var1, String var2);

    protected void setOsNameAndVersion() {
        super.setOsNameAndVersion();
        if (FontProperties.osName.equals("SunOS")) {
            FontProperties.osName = null;
        } else if (FontProperties.osName.equals("Linux")) {
            try {
                File file = new File("/etc/redhat-release");
                if (file != null && file.canRead()) {
                    FontProperties.osName = "Redhat";
                    FontProperties.osVersion = this.getVersionString(file);
                } else {
                    file = new File("/etc/turbolinux-release");
                    if (file != null && file.canRead()) {
                        FontProperties.osName = "Turbo";
                        FontProperties.osVersion = this.getVersionString(file);
                    } else {
                        file = new File("/etc/SuSE-release");
                        if (file != null && file.canRead()) {
                            FontProperties.osName = "SuSE";
                            FontProperties.osVersion = this.getVersionString(file);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getVersionString(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file.getPath())));
            String string = bufferedReader.readLine();
            bufferedReader.close();
            if (string == null) {
                return null;
            }
            char[] cArray = string.toCharArray();
            int n2 = cArray.length;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2 && !Character.isDigit(cArray[n4])) {
                ++n4;
            }
            if (n4 < n2) {
                n3 = n4;
                while (n3 < n2 && (cArray[n3] == '.' || Character.isDigit(cArray[n3]))) {
                    ++n3;
                }
                return new String(cArray, n4, n3 - n4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

