/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.AWTPermission;
import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.security.Permission;
import sun.awt.image.AcceleratedOffScreenImage;
import sun.awt.image.BufImgSurfaceData;
import sun.awt.image.SunVolatileImage;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.DrawGlyphList;
import sun.java2d.loops.DrawGlyphListAA;
import sun.java2d.loops.DrawLine;
import sun.java2d.loops.DrawPolygons;
import sun.java2d.loops.DrawRect;
import sun.java2d.loops.FillRect;
import sun.java2d.loops.FillSpans;
import sun.java2d.loops.MaskFill;
import sun.java2d.loops.RenderCache;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.AATextRenderer;
import sun.java2d.pipe.AlphaColorPipe;
import sun.java2d.pipe.AlphaPaintPipe;
import sun.java2d.pipe.CompositePipe;
import sun.java2d.pipe.DrawImage;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.DuctusShapeRenderer;
import sun.java2d.pipe.GeneralCompositePipe;
import sun.java2d.pipe.LoopPipe;
import sun.java2d.pipe.OutlineTextRenderer;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.pipe.SolidTextRenderer;
import sun.java2d.pipe.SpanClipRenderer;
import sun.java2d.pipe.SpanShapeRenderer;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.TextRenderer;

public abstract class SurfaceData
implements Transparency {
    private long pData;
    private boolean valid;
    private SurfaceType surfaceType;
    private ColorModel colorModel;
    private boolean dirty;
    private boolean needsBackup = true;
    private int numCopies;
    protected static final LoopPipe colorPrimitives;
    public static final TextPipe outlineTextRenderer;
    public static final TextPipe solidTextRenderer;
    public static final TextPipe aaTextRenderer;
    protected static final CompositePipe colorPipe;
    protected static final PixelToShapeConverter colorViaShape;
    protected static final TextPipe colorText;
    protected static final CompositePipe clipColorPipe;
    protected static final TextPipe clipColorText;
    protected static final DuctusShapeRenderer AAColorShape;
    protected static final PixelToShapeConverter AAColorViaShape;
    protected static final DuctusShapeRenderer AAClipColorShape;
    protected static final PixelToShapeConverter AAClipColorViaShape;
    protected static final CompositePipe paintPipe;
    protected static final SpanShapeRenderer paintShape;
    protected static final PixelToShapeConverter paintViaShape;
    protected static final TextPipe paintText;
    protected static final CompositePipe clipPaintPipe;
    protected static final TextPipe clipPaintText;
    protected static final DuctusShapeRenderer AAPaintShape;
    protected static final PixelToShapeConverter AAPaintViaShape;
    protected static final DuctusShapeRenderer AAClipPaintShape;
    protected static final PixelToShapeConverter AAClipPaintViaShape;
    protected static final CompositePipe compPipe;
    protected static final SpanShapeRenderer compShape;
    protected static final PixelToShapeConverter compViaShape;
    protected static final TextPipe compText;
    protected static final CompositePipe clipCompPipe;
    protected static final TextPipe clipCompText;
    protected static final DuctusShapeRenderer AACompShape;
    protected static final PixelToShapeConverter AACompViaShape;
    protected static final DuctusShapeRenderer AAClipCompShape;
    protected static final PixelToShapeConverter AAClipCompViaShape;
    protected static final DrawImagePipe imagepipe;
    private static RenderCache loopcache;
    static Permission compPermission;

    private static native void initIDs();

    protected SurfaceData(SurfaceType surfaceType, ColorModel colorModel) {
        this.colorModel = colorModel;
        this.surfaceType = surfaceType;
        this.valid = true;
    }

    protected SurfaceData() {
        this.valid = true;
    }

    public static SurfaceData getSurfaceDataFromImage(Image image, SurfaceData surfaceData, CompositeType compositeType, Color color) {
        if (image instanceof AcceleratedOffScreenImage) {
            return ((AcceleratedOffScreenImage)image).getSourceSurfaceData(surfaceData, compositeType, color);
        }
        if (image instanceof BufferedImage) {
            return BufImgSurfaceData.createData((BufferedImage)image);
        }
        if (image instanceof SunVolatileImage) {
            return ((SunVolatileImage)image).getSurfaceData();
        }
        return null;
    }

    private static native void setDirtyNative(SurfaceData var0, boolean var1);

    public void setNeedsBackup(boolean bl2) {
        this.needsBackup = bl2;
        this.numCopies = 0;
    }

    public boolean needsBackup() {
        return this.needsBackup;
    }

    public final int getNumCopies() {
        return this.numCopies;
    }

    public int increaseNumCopies() {
        if (this.dirty) {
            SurfaceData.setDirtyNative(this, false);
            this.dirty = false;
        }
        ++this.numCopies;
        return this.numCopies;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
    }

    public abstract SurfaceData getReplacement();

    public void validatePipe(SunGraphics2D sunGraphics2D) {
        sunGraphics2D.imagepipe = imagepipe;
        if (sunGraphics2D.compositeState == 2) {
            if (sunGraphics2D.paintState == 2) {
                sunGraphics2D.drawpipe = paintViaShape;
                sunGraphics2D.fillpipe = paintViaShape;
                sunGraphics2D.shapepipe = paintShape;
                sunGraphics2D.textpipe = outlineTextRenderer;
            } else {
                if (sunGraphics2D.clipState == 2) {
                    sunGraphics2D.drawpipe = colorViaShape;
                    sunGraphics2D.fillpipe = colorViaShape;
                    sunGraphics2D.textpipe = outlineTextRenderer;
                } else {
                    if (sunGraphics2D.transformState > 1) {
                        sunGraphics2D.drawpipe = colorViaShape;
                        sunGraphics2D.fillpipe = colorViaShape;
                    } else {
                        sunGraphics2D.drawpipe = sunGraphics2D.strokeState != 0 ? colorViaShape : colorPrimitives;
                        sunGraphics2D.fillpipe = colorPrimitives;
                    }
                    sunGraphics2D.textpipe = solidTextRenderer;
                }
                sunGraphics2D.shapepipe = colorPrimitives;
                sunGraphics2D.loops = this.getRenderLoops(sunGraphics2D);
            }
        } else if (sunGraphics2D.compositeState == 3) {
            if (sunGraphics2D.antialiasHint == 2) {
                if (sunGraphics2D.clipState == 2) {
                    sunGraphics2D.drawpipe = AAClipCompViaShape;
                    sunGraphics2D.fillpipe = AAClipCompViaShape;
                    sunGraphics2D.shapepipe = AAClipCompShape;
                    sunGraphics2D.textpipe = clipCompText;
                } else {
                    sunGraphics2D.drawpipe = AACompViaShape;
                    sunGraphics2D.fillpipe = AACompViaShape;
                    sunGraphics2D.shapepipe = AACompShape;
                    sunGraphics2D.textpipe = compText;
                }
            } else {
                sunGraphics2D.drawpipe = compViaShape;
                sunGraphics2D.fillpipe = compViaShape;
                sunGraphics2D.shapepipe = compShape;
                sunGraphics2D.textpipe = sunGraphics2D.clipState == 2 ? clipCompText : compText;
            }
        } else if (sunGraphics2D.antialiasHint == 2) {
            boolean bl2 = false;
            if (sunGraphics2D.paintState != 2) {
                if (sunGraphics2D.alphafill == null) {
                    sunGraphics2D.alphafill = MaskFill.getFromCache(SurfaceType.AnyColor, sunGraphics2D.fillComp, this.getSurfaceType());
                }
                if (sunGraphics2D.alphafill != null) {
                    if (sunGraphics2D.clipState == 2) {
                        sunGraphics2D.drawpipe = AAClipColorViaShape;
                        sunGraphics2D.fillpipe = AAClipColorViaShape;
                        sunGraphics2D.shapepipe = AAClipColorShape;
                        sunGraphics2D.textpipe = clipColorText;
                    } else {
                        sunGraphics2D.drawpipe = AAColorViaShape;
                        sunGraphics2D.fillpipe = AAColorViaShape;
                        sunGraphics2D.shapepipe = AAColorShape;
                        sunGraphics2D.textpipe = colorText;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) {
                if (sunGraphics2D.clipState == 2) {
                    sunGraphics2D.drawpipe = AAClipPaintViaShape;
                    sunGraphics2D.fillpipe = AAClipPaintViaShape;
                    sunGraphics2D.shapepipe = AAClipPaintShape;
                    sunGraphics2D.textpipe = clipPaintText;
                } else {
                    sunGraphics2D.drawpipe = AAPaintViaShape;
                    sunGraphics2D.fillpipe = AAPaintViaShape;
                    sunGraphics2D.shapepipe = AAPaintShape;
                    sunGraphics2D.textpipe = paintText;
                }
            }
        } else if (sunGraphics2D.paintState != 0 || sunGraphics2D.compositeState != 0 || sunGraphics2D.clipState == 2) {
            sunGraphics2D.drawpipe = paintViaShape;
            sunGraphics2D.fillpipe = paintViaShape;
            sunGraphics2D.shapepipe = paintShape;
            boolean bl3 = false;
            if (sunGraphics2D.paintState != 2 && sunGraphics2D.compositeState != 3) {
                if (sunGraphics2D.alphafill == null) {
                    sunGraphics2D.alphafill = MaskFill.getFromCache(SurfaceType.AnyColor, sunGraphics2D.fillComp, this.getSurfaceType());
                }
                if (sunGraphics2D.alphafill != null) {
                    sunGraphics2D.textpipe = sunGraphics2D.clipState == 2 ? clipColorText : colorText;
                    bl3 = true;
                }
            }
            if (!bl3) {
                sunGraphics2D.textpipe = sunGraphics2D.clipState == 2 ? clipPaintText : paintText;
            }
        } else {
            if (sunGraphics2D.transformState > 1) {
                sunGraphics2D.drawpipe = colorViaShape;
                sunGraphics2D.fillpipe = colorViaShape;
            } else {
                sunGraphics2D.drawpipe = sunGraphics2D.strokeState != 0 ? colorViaShape : colorPrimitives;
                sunGraphics2D.fillpipe = colorPrimitives;
            }
            sunGraphics2D.textpipe = sunGraphics2D.textAntialiasHint == 2 ? aaTextRenderer : solidTextRenderer;
            sunGraphics2D.shapepipe = colorPrimitives;
            sunGraphics2D.loops = this.getRenderLoops(sunGraphics2D);
        }
    }

    public RenderLoops getRenderLoops(SunGraphics2D sunGraphics2D) {
        SurfaceType surfaceType;
        switch (sunGraphics2D.paintState) {
            case 0: {
                surfaceType = SurfaceType.OpaqueColor;
                break;
            }
            case 1: {
                surfaceType = SurfaceType.AnyColor;
                break;
            }
            default: {
                surfaceType = SurfaceType.AnyPaint;
            }
        }
        CompositeType compositeType = sunGraphics2D.fillComp;
        SurfaceType surfaceType2 = sunGraphics2D.getSurfaceData().getSurfaceType();
        Object object = loopcache.get(surfaceType, compositeType, surfaceType2);
        if (object != null) {
            return (RenderLoops)object;
        }
        RenderLoops renderLoops = SurfaceData.makeRenderLoops(surfaceType, compositeType, surfaceType2);
        loopcache.put(surfaceType, compositeType, surfaceType2, renderLoops);
        return renderLoops;
    }

    public static RenderLoops makeRenderLoops(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        RenderLoops renderLoops = new RenderLoops();
        renderLoops.drawLineLoop = DrawLine.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.fillRectLoop = FillRect.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawRectLoop = DrawRect.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawPolygonsLoop = DrawPolygons.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.fillSpansLoop = FillSpans.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawGlyphListLoop = DrawGlyphList.locate(surfaceType, compositeType, surfaceType2);
        renderLoops.drawGlyphListAALoop = DrawGlyphListAA.locate(surfaceType, compositeType, surfaceType2);
        return renderLoops;
    }

    public abstract void lock() throws InvalidPipeException;

    public abstract void unlock();

    public abstract GraphicsConfiguration getDeviceConfiguration();

    public final SurfaceType getSurfaceType() {
        return this.surfaceType;
    }

    public final ColorModel getColorModel() {
        return this.colorModel;
    }

    public int getTransparency() {
        return this.getColorModel().getTransparency();
    }

    public abstract Raster getRaster(int var1, int var2, int var3, int var4);

    public boolean useTightBBoxes() {
        return true;
    }

    public int pixelFor(int n2) {
        return this.surfaceType.pixelFor(n2, this.colorModel);
    }

    public int pixelFor(Color color) {
        return this.pixelFor(color.getRGB());
    }

    public int rgbFor(int n2) {
        return this.surfaceType.rgbFor(n2, this.colorModel);
    }

    public abstract Rectangle getBounds();

    protected void checkCustomComposite() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (compPermission == null) {
                compPermission = new AWTPermission("readDisplayPixels");
            }
            securityManager.checkPermission(compPermission);
        }
    }

    protected static native boolean isOpaqueGray(IndexColorModel var0);

    public boolean copyArea(SunGraphics2D sunGraphics2D, int n2, int n3, int n4, int n5, int n6, int n7) {
        return false;
    }

    static {
        SurfaceData.initIDs();
        colorPrimitives = new LoopPipe();
        outlineTextRenderer = new OutlineTextRenderer();
        solidTextRenderer = new SolidTextRenderer();
        aaTextRenderer = new AATextRenderer();
        colorPipe = new AlphaColorPipe();
        colorViaShape = new PixelToShapeConverter(colorPrimitives);
        colorText = new TextRenderer(colorPipe);
        clipColorPipe = new SpanClipRenderer(colorPipe);
        clipColorText = new TextRenderer(clipColorPipe);
        AAColorShape = new DuctusShapeRenderer(colorPipe);
        AAColorViaShape = new PixelToShapeConverter(AAColorShape);
        AAClipColorShape = new DuctusShapeRenderer(clipColorPipe);
        AAClipColorViaShape = new PixelToShapeConverter(AAClipColorShape);
        paintPipe = new AlphaPaintPipe();
        paintShape = new SpanShapeRenderer.Composite(paintPipe);
        paintViaShape = new PixelToShapeConverter(paintShape);
        paintText = new TextRenderer(paintPipe);
        clipPaintPipe = new SpanClipRenderer(paintPipe);
        clipPaintText = new TextRenderer(clipPaintPipe);
        AAPaintShape = new DuctusShapeRenderer(paintPipe);
        AAPaintViaShape = new PixelToShapeConverter(AAPaintShape);
        AAClipPaintShape = new DuctusShapeRenderer(clipPaintPipe);
        AAClipPaintViaShape = new PixelToShapeConverter(AAClipPaintShape);
        compPipe = new GeneralCompositePipe();
        compShape = new SpanShapeRenderer.Composite(compPipe);
        compViaShape = new PixelToShapeConverter(compShape);
        compText = new TextRenderer(compPipe);
        clipCompPipe = new SpanClipRenderer(compPipe);
        clipCompText = new TextRenderer(clipCompPipe);
        AACompShape = new DuctusShapeRenderer(compPipe);
        AACompViaShape = new PixelToShapeConverter(AACompShape);
        AAClipCompShape = new DuctusShapeRenderer(clipCompPipe);
        AAClipCompViaShape = new PixelToShapeConverter(AAClipCompShape);
        imagepipe = new DrawImage();
        loopcache = new RenderCache(30);
    }
}

