/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Hashtable;
import sun.misc.HexDumpEncoder;
import sun.security.pkcs.SignerInfo;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.CertificateExtensions;

public class PKCS9Attribute
implements DerEncoder {
    private static final String RSADSI_str = "1.2.840.113549";
    private static final String PKCS_str = "1.2.840.113549.1";
    private static final String PKCS9_str = "1.2.840.113549.1.9";
    static final ObjectIdentifier[] PKCS9_OIDS = new ObjectIdentifier[16];
    public static final ObjectIdentifier EMAIL_ADDRESS_OID;
    public static final ObjectIdentifier UNSTRUCTURED_NAME_OID;
    public static final ObjectIdentifier CONTENT_TYPE_OID;
    public static final ObjectIdentifier MESSAGE_DIGEST_OID;
    public static final ObjectIdentifier SIGNING_TIME_OID;
    public static final ObjectIdentifier COUNTERSIGNATURE_OID;
    public static final ObjectIdentifier CHALLENGE_PASSWORD_OID;
    public static final ObjectIdentifier UNSTRUCTURED_ADDRESS_OID;
    public static final ObjectIdentifier EXTENDED_CERTIFICATE_ATTRIBUTES_OID;
    public static final ObjectIdentifier ISSUER_SERIALNUMBER_OID;
    public static final ObjectIdentifier EXTENSION_REQUEST_OID;
    public static final ObjectIdentifier SMIME_CAPABILITY_OID;
    public static final String EMAIL_ADDRESS_STR = "EmailAddress";
    public static final String UNSTRUCTURED_NAME_STR = "UnstructuredName";
    public static final String CONTENT_TYPE_STR = "ContentType";
    public static final String MESSAGE_DIGEST_STR = "MessageDigest";
    public static final String SIGNING_TIME_STR = "SigningTime";
    public static final String COUNTERSIGNATURE_STR = "Countersignature";
    public static final String CHALLENGE_PASSWORD_STR = "ChallengePassword";
    public static final String UNSTRUCTURED_ADDRESS_STR = "UnstructuredAddress";
    public static final String EXTENDED_CERTIFICATE_ATTRIBUTES_STR = "ExtendedCertificateAttributes";
    public static final String ISSUER_SERIALNUMBER_STR = "IssuerAndSerialNumber";
    private static final String RSA_PROPRIETARY_STR = "RSAProprietary";
    private static final String SMIME_SIGNING_DESC_STR = "SMIMESigningDesc";
    public static final String EXTENSION_REQUEST_STR = "ExtensionRequest";
    public static final String SMIME_CAPABILITY_STR = "SMIMECapability";
    private static final Hashtable NAME_OID_TABLE;
    private static final Hashtable OID_NAME_TABLE;
    private static final Byte[][] PKCS9_VALUE_TAGS;
    private static final Class[] VALUE_CLASSES;
    private static final boolean[] SINGLE_VALUED;
    private int index;
    private Object value;

    public PKCS9Attribute(ObjectIdentifier objectIdentifier, Object object) throws IllegalArgumentException {
        this.init(objectIdentifier, object);
    }

    public PKCS9Attribute(String string, Object object) throws IllegalArgumentException {
        ObjectIdentifier objectIdentifier = PKCS9Attribute.getOID(string);
        if (objectIdentifier == null) {
            throw new IllegalArgumentException("Unrecognized attribute name " + string + " constructing PKCS9Attribute.");
        }
        this.init(objectIdentifier, object);
    }

    private void init(ObjectIdentifier objectIdentifier, Object object) throws IllegalArgumentException {
        this.index = PKCS9Attribute.indexOf(objectIdentifier, PKCS9_OIDS, 1);
        if (this.index == -1) {
            throw new IllegalArgumentException("Unsupported OID " + objectIdentifier + " constructing PKCS9Attribute.");
        }
        if (!VALUE_CLASSES[this.index].isInstance(object)) {
            throw new IllegalArgumentException("Wrong value class  for attribute " + objectIdentifier + " constructing PKCS9Attribute; was " + object.getClass().toString() + ", should be " + VALUE_CLASSES[this.index].toString());
        }
        this.value = object;
    }

    public PKCS9Attribute(DerValue derValue) throws IOException {
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derInputStream.available() != 0) {
            throw new IOException("Excess data parsing PKCS9Attribute");
        }
        if (derValueArray.length != 2) {
            throw new IOException("PKCS9Attribute doesn't have two components");
        }
        ObjectIdentifier objectIdentifier = derValueArray[0].getOID();
        this.index = PKCS9Attribute.indexOf(objectIdentifier, PKCS9_OIDS, 1);
        if (this.index == -1) {
            throw new IOException("Invalid OID for PKCS9 attribute: " + objectIdentifier);
        }
        DerValue[] derValueArray2 = new DerInputStream(derValueArray[1].toByteArray()).getSet(1);
        if (SINGLE_VALUED[this.index] && derValueArray2.length > 1) {
            this.throwSingleValuedException();
        }
        int n2 = 0;
        while (n2 < derValueArray2.length) {
            Byte by = new Byte(derValueArray2[n2].tag);
            if (PKCS9Attribute.indexOf(by, PKCS9_VALUE_TAGS[this.index], 0) == -1) {
                this.throwTagException(by);
            }
            ++n2;
        }
        switch (this.index) {
            case 1: 
            case 2: 
            case 8: {
                String[] stringArray = new String[derValueArray2.length];
                int n3 = 0;
                while (n3 < derValueArray2.length) {
                    stringArray[n3] = derValueArray2[n3].getAsString();
                    ++n3;
                }
                this.value = stringArray;
                break;
            }
            case 3: {
                this.value = derValueArray2[0].getOID();
                break;
            }
            case 4: {
                this.value = derValueArray2[0].getOctetString();
                break;
            }
            case 5: {
                this.value = new DerInputStream(derValueArray2[0].toByteArray()).getUTCTime();
                break;
            }
            case 6: {
                SignerInfo[] signerInfoArray = new SignerInfo[derValueArray2.length];
                int n4 = 0;
                while (n4 < derValueArray2.length) {
                    signerInfoArray[n4] = new SignerInfo(derValueArray2[n4].toDerInputStream());
                    ++n4;
                }
                this.value = signerInfoArray;
                break;
            }
            case 7: {
                this.value = derValueArray2[0].getAsString();
                break;
            }
            case 9: {
                throw new IOException("PKCS9 extended-certificate attribute not supported.");
            }
            case 10: {
                throw new IOException("PKCS9 IssuerAndSerialNumberattribute not supported.");
            }
            case 11: 
            case 12: {
                throw new IOException("PKCS9 RSA DSI attributes11 and 12, not supported.");
            }
            case 13: {
                throw new IOException("PKCS9 attribute #13 not supported.");
            }
            case 14: {
                this.value = new CertificateExtensions(new DerInputStream(derValueArray2[0].toByteArray()));
                break;
            }
            case 15: {
                throw new IOException("PKCS9 SMIMECapability attribute not supported.");
            }
        }
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        Object object;
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOID(this.getOID());
        switch (this.index) {
            case 1: 
            case 2: {
                object = (String[])this.value;
                DerEncoder[] derEncoderArray = new DerOutputStream[((String[])object).length];
                int n2 = 0;
                while (n2 < ((Object)object).length) {
                    derEncoderArray[n2] = new DerOutputStream();
                    ((DerOutputStream)derEncoderArray[n2]).putIA5String((String)object[n2]);
                    ++n2;
                }
                derOutputStream.putOrderedSetOf((byte)49, derEncoderArray);
                break;
            }
            case 3: {
                object = new DerOutputStream();
                ((DerOutputStream)object).putOID((ObjectIdentifier)this.value);
                derOutputStream.write((byte)49, ((ByteArrayOutputStream)object).toByteArray());
                break;
            }
            case 4: {
                object = new DerOutputStream();
                ((DerOutputStream)object).putOctetString((byte[])this.value);
                derOutputStream.write((byte)49, ((ByteArrayOutputStream)object).toByteArray());
                break;
            }
            case 5: {
                object = new DerOutputStream();
                ((DerOutputStream)object).putUTCTime((Date)this.value);
                derOutputStream.write((byte)49, ((ByteArrayOutputStream)object).toByteArray());
                break;
            }
            case 6: {
                derOutputStream.putOrderedSetOf((byte)49, (DerEncoder[])this.value);
                break;
            }
            case 7: {
                object = new DerOutputStream();
                ((DerOutputStream)object).putPrintableString((String)this.value);
                derOutputStream.write((byte)49, ((ByteArrayOutputStream)object).toByteArray());
                break;
            }
            case 8: {
                object = (String[])this.value;
                DerEncoder[] derEncoderArray = new DerOutputStream[((String[])object).length];
                int n3 = 0;
                while (n3 < ((Object)object).length) {
                    derEncoderArray[n3] = new DerOutputStream();
                    ((DerOutputStream)derEncoderArray[n3]).putPrintableString((String)object[n3]);
                    ++n3;
                }
                derOutputStream.putOrderedSetOf((byte)49, derEncoderArray);
                break;
            }
            case 9: {
                throw new IOException("PKCS9 extended-certificate attribute not supported.");
            }
            case 10: {
                throw new IOException("PKCS9 IssuerAndSerialNumberattribute not supported.");
            }
            case 11: 
            case 12: {
                throw new IOException("PKCS9 RSA DSI attributes11 and 12, not supported.");
            }
            case 13: {
                throw new IOException("PKCS9 attribute #13 not supported.");
            }
            case 14: {
                object = new DerOutputStream();
                CertificateExtensions certificateExtensions = (CertificateExtensions)this.value;
                try {
                    certificateExtensions.encode((OutputStream)object, true);
                }
                catch (CertificateException certificateException) {
                    throw new IOException(certificateException.toString());
                }
                derOutputStream.write((byte)49, ((ByteArrayOutputStream)object).toByteArray());
                break;
            }
            case 15: {
                throw new IOException("PKCS9 attribute #15 not supported.");
            }
        }
        object = new DerOutputStream();
        ((DerOutputStream)object).write((byte)48, derOutputStream.toByteArray());
        outputStream.write(((ByteArrayOutputStream)object).toByteArray());
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isSingleValued() {
        return SINGLE_VALUED[this.index];
    }

    public ObjectIdentifier getOID() {
        return PKCS9_OIDS[this.index];
    }

    public String getName() {
        return (String)OID_NAME_TABLE.get(PKCS9_OIDS[this.index]);
    }

    public static ObjectIdentifier getOID(String string) {
        return (ObjectIdentifier)NAME_OID_TABLE.get(string.toLowerCase());
    }

    public static String getName(ObjectIdentifier objectIdentifier) {
        return (String)OID_NAME_TABLE.get(objectIdentifier);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("[");
        stringBuffer.append(OID_NAME_TABLE.get(PKCS9_OIDS[this.index]));
        stringBuffer.append(": ");
        if (SINGLE_VALUED[this.index]) {
            if (this.value instanceof byte[]) {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                stringBuffer.append(hexDumpEncoder.encodeBuffer((byte[])this.value));
            } else {
                stringBuffer.append(this.value.toString());
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        boolean bl2 = true;
        Object[] objectArray = (Object[])this.value;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(objectArray[n2].toString());
            ++n2;
        }
        return stringBuffer.toString();
    }

    static int indexOf(Object object, Object[] objectArray, int n2) {
        int n3 = n2;
        while (n3 < objectArray.length) {
            if (object.equals(objectArray[n3])) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private void throwSingleValuedException() throws IOException {
        throw new IOException("Single-value attribute " + this.getOID() + " (" + this.getName() + ")" + " has multiple values.");
    }

    private void throwTagException(Byte by) throws IOException {
        Byte[] byteArray = PKCS9_VALUE_TAGS[this.index];
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Value of attribute ");
        stringBuffer.append(this.getOID().toString());
        stringBuffer.append(" (");
        stringBuffer.append(this.getName());
        stringBuffer.append(") has wrong tag: ");
        stringBuffer.append(by.toString());
        stringBuffer.append(".  Expected tags: ");
        stringBuffer.append(byteArray[0].toString());
        int n2 = 1;
        while (n2 < byteArray.length) {
            stringBuffer.append(", ");
            stringBuffer.append(byteArray[n2].toString());
            ++n2;
        }
        stringBuffer.append(".");
        throw new IOException(stringBuffer.toString());
    }

    static {
        try {
            int n2 = 1;
            while (n2 < PKCS9_OIDS.length) {
                PKCS9Attribute.PKCS9_OIDS[n2] = new ObjectIdentifier("1.2.840.113549.1.9." + n2);
                ++n2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        EMAIL_ADDRESS_OID = PKCS9_OIDS[1];
        UNSTRUCTURED_NAME_OID = PKCS9_OIDS[2];
        CONTENT_TYPE_OID = PKCS9_OIDS[3];
        MESSAGE_DIGEST_OID = PKCS9_OIDS[4];
        SIGNING_TIME_OID = PKCS9_OIDS[5];
        COUNTERSIGNATURE_OID = PKCS9_OIDS[6];
        CHALLENGE_PASSWORD_OID = PKCS9_OIDS[7];
        UNSTRUCTURED_ADDRESS_OID = PKCS9_OIDS[8];
        EXTENDED_CERTIFICATE_ATTRIBUTES_OID = PKCS9_OIDS[9];
        ISSUER_SERIALNUMBER_OID = PKCS9_OIDS[10];
        EXTENSION_REQUEST_OID = PKCS9_OIDS[14];
        SMIME_CAPABILITY_OID = PKCS9_OIDS[15];
        NAME_OID_TABLE = new Hashtable(16);
        NAME_OID_TABLE.put("emailaddress", PKCS9_OIDS[1]);
        NAME_OID_TABLE.put("unstructuredname", PKCS9_OIDS[2]);
        NAME_OID_TABLE.put("contenttype", PKCS9_OIDS[3]);
        NAME_OID_TABLE.put("messagedigest", PKCS9_OIDS[4]);
        NAME_OID_TABLE.put("signingtime", PKCS9_OIDS[5]);
        NAME_OID_TABLE.put("countersignature", PKCS9_OIDS[6]);
        NAME_OID_TABLE.put("challengepassword", PKCS9_OIDS[7]);
        NAME_OID_TABLE.put("unstructuredaddress", PKCS9_OIDS[8]);
        NAME_OID_TABLE.put("extendedcertificateattributes", PKCS9_OIDS[9]);
        NAME_OID_TABLE.put("issuerandserialnumber", PKCS9_OIDS[10]);
        NAME_OID_TABLE.put("rsaproprietary", PKCS9_OIDS[11]);
        NAME_OID_TABLE.put("rsaproprietary", PKCS9_OIDS[12]);
        NAME_OID_TABLE.put("signingdescription", PKCS9_OIDS[13]);
        NAME_OID_TABLE.put("extensionrequest", PKCS9_OIDS[14]);
        NAME_OID_TABLE.put("smimecapability", PKCS9_OIDS[15]);
        OID_NAME_TABLE = new Hashtable(16);
        OID_NAME_TABLE.put(PKCS9_OIDS[1], EMAIL_ADDRESS_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[2], UNSTRUCTURED_NAME_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[3], CONTENT_TYPE_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[4], MESSAGE_DIGEST_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[5], SIGNING_TIME_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[6], COUNTERSIGNATURE_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[7], CHALLENGE_PASSWORD_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[8], UNSTRUCTURED_ADDRESS_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[9], EXTENDED_CERTIFICATE_ATTRIBUTES_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[10], ISSUER_SERIALNUMBER_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[11], RSA_PROPRIETARY_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[12], RSA_PROPRIETARY_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[13], SMIME_SIGNING_DESC_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[14], EXTENSION_REQUEST_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[15], SMIME_CAPABILITY_STR);
        PKCS9_VALUE_TAGS = new Byte[][]{null, {new Byte(22)}, {new Byte(22)}, {new Byte(6)}, {new Byte(4)}, {new Byte(23)}, {new Byte(48)}, {new Byte(19), new Byte(20)}, {new Byte(19), new Byte(20)}, {new Byte(49)}, {new Byte(48)}, null, null, null, {new Byte(48)}, {new Byte(48)}};
        VALUE_CLASSES = new Class[16];
        try {
            Class clazz = Class.forName("[Ljava.lang.String;");
            PKCS9Attribute.VALUE_CLASSES[0] = null;
            PKCS9Attribute.VALUE_CLASSES[1] = clazz;
            PKCS9Attribute.VALUE_CLASSES[2] = clazz;
            PKCS9Attribute.VALUE_CLASSES[3] = Class.forName("sun.security.util.ObjectIdentifier");
            PKCS9Attribute.VALUE_CLASSES[4] = Class.forName("[B");
            PKCS9Attribute.VALUE_CLASSES[5] = Class.forName("java.util.Date");
            PKCS9Attribute.VALUE_CLASSES[6] = Class.forName("[Lsun.security.pkcs.SignerInfo;");
            PKCS9Attribute.VALUE_CLASSES[7] = Class.forName("java.lang.String");
            PKCS9Attribute.VALUE_CLASSES[8] = clazz;
            PKCS9Attribute.VALUE_CLASSES[9] = null;
            PKCS9Attribute.VALUE_CLASSES[10] = null;
            PKCS9Attribute.VALUE_CLASSES[11] = null;
            PKCS9Attribute.VALUE_CLASSES[12] = null;
            PKCS9Attribute.VALUE_CLASSES[13] = null;
            PKCS9Attribute.VALUE_CLASSES[14] = Class.forName("sun.security.x509.CertificateExtensions");
            PKCS9Attribute.VALUE_CLASSES[15] = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException.toString());
        }
        SINGLE_VALUED = new boolean[]{false, false, false, true, true, true, false, true, false, false, true, false, false, false, true, true};
    }
}

