/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;
import sun.security.util.BigInt;
import sun.security.util.BitArray;
import sun.security.util.ByteArrayLexOrder;
import sun.security.util.ByteArrayTagOrder;
import sun.security.util.DerEncoder;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class DerOutputStream
extends ByteArrayOutputStream
implements DerEncoder {
    private static ByteArrayLexOrder lexOrder = new ByteArrayLexOrder();
    private static ByteArrayTagOrder tagOrder = new ByteArrayTagOrder();

    public DerOutputStream(int n2) {
        super(n2);
    }

    public DerOutputStream() {
    }

    public void write(byte by, byte[] byArray) throws IOException {
        this.write(by);
        this.putLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte by, DerOutputStream derOutputStream) throws IOException {
        this.write(by);
        this.putLength(derOutputStream.count);
        this.write(derOutputStream.buf, 0, derOutputStream.count);
    }

    public void writeImplicit(byte by, DerOutputStream derOutputStream) throws IOException {
        this.write(by);
        this.write(derOutputStream.buf, 1, derOutputStream.count - 1);
    }

    public void putDerValue(DerValue derValue) throws IOException {
        derValue.encode(this);
    }

    public void putBoolean(boolean bl2) throws IOException {
        this.write(1);
        this.putLength(1);
        if (bl2) {
            this.write(255);
        } else {
            this.write(0);
        }
    }

    public void putInteger(BigInt bigInt) throws IOException {
        this.write(2);
        this.putBigInt(bigInt);
    }

    public void putInteger(BigInteger bigInteger) throws IOException {
        this.write(2);
        byte[] byArray = bigInteger.toByteArray();
        this.putLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void putInteger(Integer n2) throws IOException {
        this.putInteger((int)n2);
    }

    public void putInteger(int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[4];
        int n4 = 0;
        byArray[3] = (byte)(n2 & 0xFF);
        byArray[2] = (byte)((n2 & 0xFF00) >>> 8);
        byArray[1] = (byte)((n2 & 0xFF0000) >>> 16);
        byArray[0] = (byte)((n2 & 0xFF000000) >>> 24);
        if (byArray[0] == 255) {
            n3 = 0;
            while (n3 < 3) {
                if (byArray[n3] == 255 && (byArray[n3 + 1] & 0x80) == 128) {
                    ++n4;
                    ++n3;
                    continue;
                }
                break;
            }
        } else if (byArray[0] == 0) {
            n3 = 0;
            while (n3 < 3) {
                if (byArray[n3] == 0 && (byArray[n3 + 1] & 0x80) == 0) {
                    ++n4;
                    ++n3;
                    continue;
                }
                break;
            }
        }
        this.write(2);
        this.putLength(4 - n4);
        n3 = n4;
        while (n3 < 4) {
            this.write(byArray[n3]);
            ++n3;
        }
    }

    public void putEnumerated(BigInt bigInt) throws IOException {
        this.write(10);
        this.putBigInt(bigInt);
    }

    private void putBigInt(BigInt bigInt) throws IOException {
        byte[] byArray = bigInt.toByteArray();
        if ((byArray[0] & 0x80) != 0) {
            this.putLength(byArray.length + 1);
            this.write(0);
        } else {
            this.putLength(byArray.length);
        }
        this.write(byArray, 0, byArray.length);
    }

    public void putBitString(byte[] byArray) throws IOException {
        this.write(3);
        this.putLength(byArray.length + 1);
        this.write(0);
        this.write(byArray);
    }

    public void putUnalignedBitString(BitArray bitArray) throws IOException {
        byte[] byArray = bitArray.toByteArray();
        this.write(3);
        this.putLength(byArray.length + 1);
        this.write(byArray.length * 8 - bitArray.length());
        this.write(byArray);
    }

    public void putOctetString(byte[] byArray) throws IOException {
        this.write((byte)4, byArray);
    }

    public void putNull() throws IOException {
        this.write(5);
        this.putLength(0);
    }

    public void putOID(ObjectIdentifier objectIdentifier) throws IOException {
        objectIdentifier.encode(this);
    }

    public void putSequence(DerValue[] derValueArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        int n2 = 0;
        while (n2 < derValueArray.length) {
            derValueArray[n2].encode(derOutputStream);
            ++n2;
        }
        this.write((byte)48, derOutputStream);
    }

    public void putSet(DerValue[] derValueArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        int n2 = 0;
        while (n2 < derValueArray.length) {
            derValueArray[n2].encode(derOutputStream);
            ++n2;
        }
        this.write((byte)49, derOutputStream);
    }

    public void putOrderedSetOf(byte by, DerEncoder[] derEncoderArray) throws IOException {
        this.putOrderedSet(by, derEncoderArray, lexOrder);
    }

    public void putOrderedSet(byte by, DerEncoder[] derEncoderArray) throws IOException {
        this.putOrderedSet(by, derEncoderArray, tagOrder);
    }

    private void putOrderedSet(byte by, DerEncoder[] derEncoderArray, Comparator comparator) throws IOException {
        DerOutputStream[] derOutputStreamArray = new DerOutputStream[derEncoderArray.length];
        int n2 = 0;
        while (n2 < derEncoderArray.length) {
            derOutputStreamArray[n2] = new DerOutputStream();
            derEncoderArray[n2].derEncode(derOutputStreamArray[n2]);
            ++n2;
        }
        byte[][] byArrayArray = new byte[derOutputStreamArray.length][];
        int n3 = 0;
        while (n3 < derOutputStreamArray.length) {
            byArrayArray[n3] = derOutputStreamArray[n3].toByteArray();
            ++n3;
        }
        Arrays.sort((Object[])byArrayArray, comparator);
        DerOutputStream derOutputStream = new DerOutputStream();
        int n4 = 0;
        while (n4 < derOutputStreamArray.length) {
            derOutputStream.write(byArrayArray[n4]);
            ++n4;
        }
        this.write(by, derOutputStream);
    }

    public void putUTF8String(String string) throws IOException {
        this.writeString(string, (byte)12, "UTF8");
    }

    public void putPrintableString(String string) throws IOException {
        this.writeString(string, (byte)19, "ASCII");
    }

    public void putT61String(String string) throws IOException {
        this.writeString(string, (byte)20, "ISO-8859-1");
    }

    public void putIA5String(String string) throws IOException {
        this.writeString(string, (byte)22, "ASCII");
    }

    public void putBMPString(String string) throws IOException {
        this.writeString(string, (byte)30, "UnicodeBigUnmarked");
    }

    public void putGeneralString(String string) throws IOException {
        this.writeString(string, (byte)27, "ASCII");
    }

    private void writeString(String string, byte by, String string2) throws IOException {
        byte[] byArray = string.getBytes(string2);
        this.write(by);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putUTCTime(Date date) throws IOException {
        this.putTime(date, (byte)23);
    }

    public void putGeneralizedTime(Date date) throws IOException {
        this.putTime(date, (byte)24);
    }

    private void putTime(Date date, byte by) throws IOException {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        String string = null;
        if (by == 23) {
            string = "yyMMddHHmmss'Z'";
        } else {
            by = (byte)24;
            string = "yyyyMMddHHmmss'Z'";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(timeZone);
        byte[] byArray = simpleDateFormat.format(date).getBytes();
        this.write(by);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putLength(int n2) throws IOException {
        if (n2 < 128) {
            this.write((byte)n2);
        } else if (n2 < 256) {
            this.write(-127);
            this.write((byte)n2);
        } else if (n2 < 65536) {
            this.write(-126);
            this.write((byte)(n2 >> 8));
            this.write((byte)n2);
        } else if (n2 < 0x1000000) {
            this.write(-125);
            this.write((byte)(n2 >> 16));
            this.write((byte)(n2 >> 8));
            this.write((byte)n2);
        } else {
            this.write(-124);
            this.write((byte)(n2 >> 24));
            this.write((byte)(n2 >> 16));
            this.write((byte)(n2 >> 8));
            this.write((byte)n2);
        }
    }

    public void putTag(byte by, boolean bl2, byte by2) {
        byte by3 = (byte)(by | by2);
        if (bl2) {
            by3 = (byte)(by3 | 0x20);
        }
        this.write(by3);
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }
}

