/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;

final class SSLServerSocketImpl
extends SSLServerSocket {
    private SSLContextImpl a;
    private byte b = 0;
    private boolean c = true;
    private boolean d = true;
    private String[] e = null;
    private String[] f = null;
    private boolean g = false;

    SSLServerSocketImpl(int n, int n2, SSLContextImpl sSLContextImpl) throws IOException, SSLException {
        super(n, n2);
        this.a(sSLContextImpl);
    }

    SSLServerSocketImpl(int n, int n2, InetAddress inetAddress, SSLContextImpl sSLContextImpl) throws IOException {
        super(n, n2, inetAddress);
        this.a(sSLContextImpl);
    }

    SSLServerSocketImpl(SSLContextImpl sSLContextImpl) throws IOException {
        this.a(sSLContextImpl);
    }

    private void a(SSLContextImpl sSLContextImpl) throws SSLException {
        if (sSLContextImpl == null) {
            throw new SSLException("No Authentication context given");
        }
        this.a = sSLContextImpl;
        this.e = SSLSocketImpl.getDefaultSuites();
        this.f = (String[])CipherSpec.b().clone();
    }

    public synchronized String[] getEnabledCipherSuites() {
        return (String[])this.e.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabledCipherSuites(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("cipher suites to enable can not be null");
        }
        SSLSocketImpl.a(stringArray);
        SSLServerSocketImpl sSLServerSocketImpl = this;
        synchronized (sSLServerSocketImpl) {
            this.e = (String[])stringArray.clone();
            this.g = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setEnabledProtocols(String[] stringArray) throws IllegalArgumentException {
        if (stringArray == null) {
            throw new IllegalArgumentException("protocols to enable can not be null");
        }
        CipherSpec.b(stringArray);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (n < stringArray.length) {
            if ("SSLv2Hello".equals(stringArray[n])) {
                bl = true;
            } else if ("SSLv3".equals(stringArray[n])) {
                bl2 = true;
            } else if ("TLSv1".equals(stringArray[n])) {
                bl3 = true;
            }
            ++n;
        }
        if (bl && !bl3 && !bl2) {
            throw new IllegalArgumentException("SSLv2 Hellocan not be enabled unless  either TLSv1 or SSLv3 is enabled");
        }
        SSLServerSocketImpl sSLServerSocketImpl = this;
        synchronized (sSLServerSocketImpl) {
            this.f = (String[])stringArray.clone();
        }
    }

    public synchronized String[] getEnabledProtocols() {
        return (String[])this.f.clone();
    }

    public void setNeedClientAuth(boolean bl) {
        this.b = (byte)(bl ? 2 : 0);
    }

    public boolean getNeedClientAuth() {
        return this.b == 2;
    }

    public void setWantClientAuth(boolean bl) {
        this.b = bl ? (byte)1 : 0;
    }

    public boolean getWantClientAuth() {
        return this.b == 1;
    }

    public void setUseClientMode(boolean bl) {
        this.c = !bl;
    }

    public boolean getUseClientMode() {
        return !this.c;
    }

    public void setEnableSessionCreation(boolean bl) {
        this.d = bl;
    }

    public boolean getEnableSessionCreation() {
        return this.d;
    }

    public Socket accept() throws IOException {
        this.a();
        SSLSocketImpl sSLSocketImpl = new SSLSocketImpl(this.a, this.c, this.e, this.b, this.d, this.f);
        this.implAccept(sSLSocketImpl);
        sSLSocketImpl.a();
        return sSLSocketImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void a() throws IOException {
        if (this.g) {
            return;
        }
        SSLServerSocketImpl sSLServerSocketImpl = this;
        synchronized (sSLServerSocketImpl) {
            if (!this.g) {
                SSLSocketImpl sSLSocketImpl = new SSLSocketImpl(this.a, this.c, this.e, this.b, this.d, this.f);
                String[] stringArray = this.e;
                Handshaker handshaker = sSLSocketImpl.f();
                int n = 0;
                while (n < stringArray.length) {
                    if (handshaker.canUseCipherSuite(stringArray[n])) {
                        this.g = true;
                        break;
                    }
                    ++n;
                }
                if (!this.g) {
                    throw new SSLException("No available certificate corresponds to the SSL cipher suites which are enabled.");
                }
            }
        }
    }

    public String[] getSupportedCipherSuites() {
        return (String[])CipherSpec.a().clone();
    }

    public String[] getSupportedProtocols() {
        return (String[])CipherSpec.b().clone();
    }

    public String toString() {
        return "[SSL: " + super.toString() + "]";
    }
}

