/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.https;

import java.io.IOException;
import java.net.URL;
import java.security.cert.Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import sun.net.www.protocol.http.Handler;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.https.HttpsClient;

public abstract class AbstractDelegateHttpsURLConnection
extends HttpURLConnection {
    protected AbstractDelegateHttpsURLConnection(URL uRL, Handler handler) throws IOException {
        super(uRL, handler);
    }

    protected abstract SSLSocketFactory getSSLSocketFactory();

    protected abstract HostnameVerifier getHostnameVerifier();

    public void setNewClient(URL uRL) throws IOException {
        this.setNewClient(uRL, false);
    }

    public void setNewClient(URL uRL, boolean bl) throws IOException {
        this.http = HttpsClient.a(this.getSSLSocketFactory(), uRL, this.getHostnameVerifier(), bl);
        ((HttpsClient)this.http).afterConnect();
    }

    public void setProxiedClient(URL uRL, String string, int n) throws IOException {
        this.setProxiedClient(uRL, string, n, false);
    }

    public void setProxiedClient(URL uRL, String string, int n, boolean bl) throws IOException {
        if (this.connected) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(string, n);
        }
        this.http = HttpsClient.a(this.getSSLSocketFactory(), uRL, this.getHostnameVerifier(), string, n, bl);
        this.connected = true;
        if (!this.http.isCachedConnection()) {
            this.doTunneling();
        }
        ((HttpsClient)this.http).afterConnect();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.plainConnect();
        if (!this.http.isCachedConnection() && this.http.needsTunneling()) {
            this.doTunneling();
        }
        ((HttpsClient)this.http).afterConnect();
    }

    protected void plainConnect() throws IOException {
        if (this.connected) {
            return;
        }
        this.http = (HttpsClient)HttpsClient.a(this.getSSLSocketFactory(), this.url, this.getHostnameVerifier());
        this.connected = true;
    }

    public String getCipherSuite() {
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).b();
    }

    public Certificate[] getLocalCertificates() {
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).getLocalCertificates();
    }

    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).c();
    }

    public X509Certificate[] getServerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.http == null) {
            throw new IllegalStateException("connection not yet open");
        }
        return ((HttpsClient)this.http).d();
    }
}

