/*
* canvas.h -- Declaration of class KImageCanvas.
* Generated by newclass on Thu Oct  9 09:03:54 EST 1997.
*/
#ifndef SSK_CANVAS_H
#define SSK_CANVAS_H

#include <qstring.h>
#include <qwmatrix.h>
#include <qlabel.h>
#include <qscrollview.h>

class KVImageHolder;
class QPainter;
class QPaintDevice;
class QPen;
class KViewKonqView;
class QColor;

/**
* @short KImageCanvas
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: canvas.h,v 1.25 2001/05/30 19:15:24 mkretz Exp $
*/
class KImageCanvas : public QScrollView
{
  Q_OBJECT
public:
  enum Error { OK, BadPath, BadFormat, NoMemory };
  enum WallpaperMode {
    NoWallpaper, Centred, Tiled, CenterTiled, CentredMaxpect,
    Scaled, lastWallpaperMode
  };

  /**
  * KImageCanvas Constructor
  */
  KImageCanvas( QWidget *parent = 0 );

  /**
  * KImageCanvas Destructor
  */
  virtual ~KImageCanvas();

  /**
  * Check canvas status.
  * @return Status code
  * @see ::Error
  */
  Error status() const;

  /**
  * Load the image from a file
  */
  int load( const QString & file, const QString &URL = QString::null, bool max = false );
  /**
  * Saves the image to a file
  */
  bool save( const QString&, QString& );

  /**
  * Resets the image to as loaded.
  */
  void reset();

  /**
   * forgets the original pixmap -> reset will restore current state
   */
  void forgetOriginal();

  /**
  * Clears the image to blank.
  */
  void clear();

  /**
   * is the canvas empty?
   */
  bool isEmpty() const;
  
  /**
  * Transform the image by the matrix.
  */
  void transformImage( const QWMatrix& mat );

  /**
  * Get the current image.
  */
  QImage getImage() const;

  /**
  * Get the url for the current image.
  */
  //QString url() const;

  void copyImage( QPaintDevice *dest ) const;

  KVImageHolder *client() { return _client; }

  /**
   * sets the background color
   */
  void setBgColor( const QColor & );

  /**
   * returns the current bg color
   */
  const QColor & bgColor() const;

  /**
   * the depth of the contained pixmap
   */
  int pixmapDepth() const;

  /**
   * the size of the original Image
   */
  QSize originalSize() const;
  
public slots:
  /**
  * Tile the image to the desktop
  */
  void slot_tileToDesktop() const;

  /**
  *
  */
  void slot_maxToDesktop() const;
  /**
  *
  */
  void slot_maxpectToDesktop() const;

  void slot_setImage( const QImage& );

  /**
  * Crop image to the current selection, if any.
  * If there is no selection, nothing happens.
  */
  void slot_cropImage();

  void slot_maxToWin();
  void slot_maxpectToWin();
  void slot_setCentered( bool );

  // image scrolling

  void slot_pageDown() { verticalScrollBar()->addPage(); }
  void slot_pageUp() { verticalScrollBar()->subtractPage(); }

  void slot_lineDown() { verticalScrollBar()->addLine(); }
  void slot_lineUp() { verticalScrollBar()->subtractLine(); }

  void slot_pageRight() { horizontalScrollBar()->addPage(); }
  void slot_pageLeft() { horizontalScrollBar()->subtractPage(); }

  void slot_lineRight() { horizontalScrollBar()->addLine(); }
  void slot_lineLeft() { horizontalScrollBar()->subtractLine(); }

protected:
  /**
  *
  */
  void resizeEvent( QResizeEvent * );
  
  void viewportMousePressEvent( QMouseEvent * );

  /**
  * Sets the status.
  */
  void setStatus( Error );

  /**
   * calls KDesktop via DCOP and tells it to
   * use some other Background
   */
  void setDesktopBackground( WallpaperMode ) const;

signals:
  /**
  *
  */
  void imageSizeChanged();
  void contextPress( const QPoint& );
  void selected( bool );

private:
  Error _status;
  QString _file;

  QSize m_originalsize;
  KVImageHolder *_client;

  QPixmap *_orig;
  
  QColor m_bgcolor;

  bool m_centered;
  int m_depth;

  /**
  * Returns a pixmap that is to be used for editing.
  */
  QPixmap *transPixmap();
};

inline void KImageCanvas::setStatus( Error e )
{
  _status = e;
}

//inline QString KImageCanvas::url() const
//{
  //return _file;
//}

/**
* Image widget, used as child in canvas.
*/
class KVImageHolder : public QLabel
{
  Q_OBJECT
private:
  QRect _selection;

  bool _selected;
  bool m_empty;

  QPainter *_painter;
  QPen *_pen;

public:
  KVImageHolder( QWidget *parent = 0 );

  virtual ~KVImageHolder();

  /**
  * Return the current selection.  If no selection has been made,
  * the returned rectangle will be null.
  */
  QRect selected() const;
  QPixmap selection();

  void clearSelection() { _selected = false; }

  void setImagePix( QPixmap );
  void setImageMovie( const QMovie &movie );

  QPixmap *imagePix();

  /**
  * clears the ImageHolder
  */
  void clear();

signals:
  void contextPress( const QPoint& );
  void selected( bool );


protected:
  void mousePressEvent( QMouseEvent * );
  void mouseMoveEvent( QMouseEvent * );

  void paintEvent( QPaintEvent * );

private:
  void drawSelect();
  void eraseSelect();
};

#endif // SSK_CANVAS_H
