/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DisabledSecurity;
import com.sun.media.sound.JDK12;
import com.sun.media.sound.JDK12NewEventDispatcherAction;
import com.sun.media.sound.JDK12TopmostThreadGroupAction;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.Printer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

class EventDispatcher
implements Runnable {
    private Vector eventQueue = new Vector();
    private boolean done = false;
    Thread thread = null;
    static boolean creatingThread = false;
    private static JSSecurity jsSecurity = null;
    private static boolean securityPrivilege = false;
    private static ThreadGroup topmostThreadGroup = null;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    EventDispatcher() {
    }

    private static void initSecurity() {
        securityPrivilege = true;
        try {
            jsSecurity = JSSecurityManager.getJSSecurity();
        }
        catch (SecurityException securityException) {
            securityPrivilege = false;
        }
        if (securityPrivilege) {
            if (jsSecurity == null || !(jsSecurity instanceof DisabledSecurity)) {
                if (jsSecurity != null && jsSecurity.getName().startsWith("JDK12")) {
                    try {
                        Constructor constructor = JDK12TopmostThreadGroupAction.cons;
                        topmostThreadGroup = (ThreadGroup)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[0])});
                    }
                    catch (Exception exception) {
                        topmostThreadGroup = EventDispatcher.getTopmostThreadGroup();
                    }
                } else {
                    topmostThreadGroup = EventDispatcher.getTopmostThreadGroup();
                }
            }
        } else {
            topmostThreadGroup = Thread.currentThread().getThreadGroup();
        }
    }

    void start() {
        block14: {
            if ((this.thread != null || creatingThread) && !this.done) break block14;
            EventDispatcher.initSecurity();
            EventDispatcher eventDispatcher = this;
            this.done = false;
            if (securityPrivilege && jsSecurity != null) {
                if (jsSecurity.getName().startsWith("JDK12")) {
                    try {
                        creatingThread = true;
                        Constructor constructor = JDK12NewEventDispatcherAction.cons;
                        Object[] objectArray = new Object[]{topmostThreadGroup, eventDispatcher};
                        this.thread = (Thread)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(objectArray)});
                        creatingThread = false;
                    }
                    catch (InstantiationException instantiationException) {
                        this.thread = new Thread(topmostThreadGroup, this);
                        this.thread.start();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.thread = new Thread(topmostThreadGroup, this);
                        this.thread.start();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        this.thread = new Thread(topmostThreadGroup, this);
                        this.thread.start();
                    }
                } else {
                    try {
                        jsSecurity.requestPermission(this.m, this.cl, this.args, 16);
                        this.m[0].invoke(this.cl[0], this.args[0]);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    this.thread = new Thread(topmostThreadGroup, this);
                    this.thread.start();
                }
            } else {
                this.thread = new Thread(topmostThreadGroup, this);
                this.thread.start();
            }
            if (this.thread != null) {
                try {
                    this.thread.setName("Java Sound event dispatcher");
                }
                catch (SecurityException securityException) {}
            }
        }
    }

    protected void processEvent(EventInfo eventInfo) {
        if (eventInfo.getEvent() instanceof LineEvent) {
            LineEvent lineEvent = (LineEvent)eventInfo.getEvent();
            Vector vector = eventInfo.getListeners();
            int n2 = 0;
            while (n2 < vector.size()) {
                ((LineListener)vector.elementAt(n2)).update(lineEvent);
                ++n2;
            }
            return;
        }
        if (eventInfo.getEvent() instanceof MetaMessage) {
            MetaMessage metaMessage = (MetaMessage)eventInfo.getEvent();
            Vector vector = eventInfo.getListeners();
            int n3 = 0;
            while (n3 < vector.size()) {
                ((MetaEventListener)vector.elementAt(n3)).meta(metaMessage);
                ++n3;
            }
            return;
        }
        if (eventInfo.getEvent() instanceof ShortMessage) {
            ShortMessage shortMessage = (ShortMessage)eventInfo.getEvent();
            int n4 = shortMessage.getStatus();
            if (n4 >> 4 == 11) {
                Vector vector = eventInfo.getListeners();
                int n5 = 0;
                while (n5 < vector.size()) {
                    ((ControllerEventListener)vector.elementAt(n5)).controlChange(shortMessage);
                    ++n5;
                }
            }
            return;
        }
        Printer.err("Unknown event type: " + eventInfo.getEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvents() {
        EventInfo eventInfo = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            try {
                while (!this.done && this.eventQueue.size() == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                this.done = true;
                this.notifyAll();
            }
            if (!this.done) {
                eventInfo = (EventInfo)this.eventQueue.elementAt(0);
                this.eventQueue.removeElementAt(0);
            }
        }
        if (eventInfo != null) {
            this.processEvent(eventInfo);
        }
    }

    synchronized void postEvent(EventInfo eventInfo) {
        this.eventQueue.addElement(eventInfo);
        this.notifyAll();
    }

    synchronized void kill() {
        this.done = true;
        this.notifyAll();
    }

    public void run() {
        while (!this.done) {
            this.dispatchEvents();
        }
    }

    void sendAudioEvents(Object object, Vector vector) {
        this.start();
        Vector vector2 = (Vector)vector.clone();
        EventInfo eventInfo = new EventInfo(object, vector2);
        this.postEvent(eventInfo);
    }

    private static ThreadGroup getTopmostThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    class EventInfo {
        private Object event;
        private Vector listeners;

        EventInfo(Object object, Vector vector) {
            this.event = object;
            this.listeners = vector;
        }

        Object getEvent() {
            return this.event;
        }

        Vector getListeners() {
            return this.listeners;
        }
    }
}

