/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;

public abstract class Graphics {
    protected Graphics() {
    }

    public abstract Graphics create();

    public Graphics create(int n2, int n3, int n4, int n5) {
        Graphics graphics = this.create();
        if (graphics == null) {
            return null;
        }
        graphics.translate(n2, n3);
        graphics.clipRect(0, 0, n4, n5);
        return graphics;
    }

    public abstract void translate(int var1, int var2);

    public abstract Color getColor();

    public abstract void setColor(Color var1);

    public abstract void setPaintMode();

    public abstract void setXORMode(Color var1);

    public abstract Font getFont();

    public abstract void setFont(Font var1);

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public abstract FontMetrics getFontMetrics(Font var1);

    public abstract Rectangle getClipBounds();

    public abstract void clipRect(int var1, int var2, int var3, int var4);

    public abstract void setClip(int var1, int var2, int var3, int var4);

    public abstract Shape getClip();

    public abstract void setClip(Shape var1);

    public abstract void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void drawLine(int var1, int var2, int var3, int var4);

    public abstract void fillRect(int var1, int var2, int var3, int var4);

    public void drawRect(int n2, int n3, int n4, int n5) {
        if (n4 < 0 || n5 < 0) {
            return;
        }
        if (n5 == 0 || n4 == 0) {
            this.drawLine(n2, n3, n2 + n4, n3 + n5);
        } else {
            this.drawLine(n2, n3, n2 + n4 - 1, n3);
            this.drawLine(n2 + n4, n3, n2 + n4, n3 + n5 - 1);
            this.drawLine(n2 + n4, n3 + n5, n2 + 1, n3 + n5);
            this.drawLine(n2, n3 + n5, n2, n3 + 1);
        }
    }

    public abstract void clearRect(int var1, int var2, int var3, int var4);

    public abstract void drawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void fillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public void draw3DRect(int n2, int n3, int n4, int n5, boolean bl2) {
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        this.setColor(bl2 ? color2 : color3);
        this.drawLine(n2, n3, n2, n3 + n5);
        this.drawLine(n2 + 1, n3, n2 + n4 - 1, n3);
        this.setColor(bl2 ? color3 : color2);
        this.drawLine(n2 + 1, n3 + n5, n2 + n4, n3 + n5);
        this.drawLine(n2 + n4, n3, n2 + n4, n3 + n5 - 1);
        this.setColor(color);
    }

    public void fill3DRect(int n2, int n3, int n4, int n5, boolean bl2) {
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        if (!bl2) {
            this.setColor(color3);
        }
        this.fillRect(n2 + 1, n3 + 1, n4 - 2, n5 - 2);
        this.setColor(bl2 ? color2 : color3);
        this.drawLine(n2, n3, n2, n3 + n5 - 1);
        this.drawLine(n2 + 1, n3, n2 + n4 - 2, n3);
        this.setColor(bl2 ? color3 : color2);
        this.drawLine(n2 + 1, n3 + n5 - 1, n2 + n4 - 1, n3 + n5 - 1);
        this.drawLine(n2 + n4 - 1, n3, n2 + n4 - 1, n3 + n5 - 2);
        this.setColor(color);
    }

    public abstract void drawOval(int var1, int var2, int var3, int var4);

    public abstract void fillOval(int var1, int var2, int var3, int var4);

    public abstract void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void drawPolyline(int[] var1, int[] var2, int var3);

    public abstract void drawPolygon(int[] var1, int[] var2, int var3);

    public void drawPolygon(Polygon polygon) {
        this.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public abstract void fillPolygon(int[] var1, int[] var2, int var3);

    public void fillPolygon(Polygon polygon) {
        this.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public abstract void drawString(String var1, int var2, int var3);

    public abstract void drawString(AttributedCharacterIterator var1, int var2, int var3);

    public void drawChars(char[] cArray, int n2, int n3, int n4, int n5) {
        this.drawString(new String(cArray, n2, n3), n4, n5);
    }

    public void drawBytes(byte[] byArray, int n2, int n3, int n4, int n5) {
        this.drawString(new String(byArray, 0, n2, n3), n4, n5);
    }

    public abstract boolean drawImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, ImageObserver var6);

    public abstract boolean drawImage(Image var1, int var2, int var3, Color var4, ImageObserver var5);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, Color var6, ImageObserver var7);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, ImageObserver var10);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, Color var10, ImageObserver var11);

    public abstract void dispose();

    public void finalize() {
        this.dispose();
    }

    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont() + ",color=" + this.getColor() + "]";
    }

    public Rectangle getClipRect() {
        return this.getClipBounds();
    }

    public boolean hitClip(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.getClipBounds();
        if (rectangle == null) {
            return true;
        }
        return rectangle.intersects(n2, n3, n4, n5);
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        Rectangle rectangle2 = this.getClipBounds();
        if (rectangle2 != null) {
            rectangle.x = rectangle2.x;
            rectangle.y = rectangle2.y;
            rectangle.width = rectangle2.width;
            rectangle.height = rectangle2.height;
        } else if (rectangle == null) {
            throw new NullPointerException("null rectangle parameter");
        }
        return rectangle;
    }
}

