/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public final class BandedSampleModel
extends ComponentSampleModel {
    public BandedSampleModel(int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, 1, n3, BandedSampleModel.createIndicesArray(n5), BandedSampleModel.createOffsetArray(n5));
    }

    public BandedSampleModel(int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        super(n2, n3, n4, 1, n5, nArray, nArray2);
    }

    public SampleModel createCompatibleSampleModel(int n2, int n3) {
        int[] nArray = this.numBanks == 1 ? this.orderBands(this.bandOffsets, n2 * n3) : new int[this.bandOffsets.length];
        BandedSampleModel bandedSampleModel = new BandedSampleModel(this.dataType, n2, n3, n2, this.bankIndices, nArray);
        return bandedSampleModel;
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.bankIndices.length) {
            throw new RasterFormatException("There are only " + this.bankIndices.length + " bands");
        }
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray2[n2] = this.bankIndices[nArray[n2]];
            nArray3[n2] = this.bandOffsets[nArray[n2]];
            ++n2;
        }
        return new BandedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, nArray2, nArray3);
    }

    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n2 = this.scanlineStride * this.height;
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n2, this.numBands);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n2, this.numBands);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(n2, this.numBands);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n2, this.numBands);
                break;
            }
            case 4: {
                dataBuffer = new DataBufferFloat(n2, this.numBands);
                break;
            }
            case 5: {
                dataBuffer = new DataBufferDouble(n2, this.numBands);
                break;
            }
            default: {
                throw new IllegalArgumentException("dataType is not one of the supported types.");
            }
        }
        return dataBuffer;
    }

    public Object getDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.getTransferType();
        int n5 = this.getNumDataElements();
        int n6 = n3 * this.scanlineStride + n2;
        switch (n4) {
            case 0: {
                byte[] byArray = object == null ? new byte[n5] : (byte[])object;
                int n7 = 0;
                while (n7 < n5) {
                    byArray[n7] = (byte)dataBuffer.getElem(this.bankIndices[n7], n6 + this.bandOffsets[n7]);
                    ++n7;
                }
                object = byArray;
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = object == null ? new short[n5] : (short[])object;
                int n8 = 0;
                while (n8 < n5) {
                    sArray[n8] = (short)dataBuffer.getElem(this.bankIndices[n8], n6 + this.bandOffsets[n8]);
                    ++n8;
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n5] : (int[])object;
                int n9 = 0;
                while (n9 < n5) {
                    nArray[n9] = dataBuffer.getElem(this.bankIndices[n9], n6 + this.bandOffsets[n9]);
                    ++n9;
                }
                object = nArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n5] : (float[])object;
                int n10 = 0;
                while (n10 < n5) {
                    fArray[n10] = dataBuffer.getElemFloat(this.bankIndices[n10], n6 + this.bandOffsets[n10]);
                    ++n10;
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n5] : (double[])object;
                int n11 = 0;
                while (n11 < n5) {
                    dArray[n11] = dataBuffer.getElemDouble(this.bankIndices[n11], n6 + this.bandOffsets[n11]);
                    ++n11;
                }
                object = dArray;
            }
        }
        return object;
    }

    public int[] getPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands];
        int n4 = n3 * this.scanlineStride + n2;
        int n5 = 0;
        while (n5 < this.numBands) {
            nArray2[n5] = dataBuffer.getElem(this.bankIndices[n5], n4 + this.bandOffsets[n5]);
            ++n5;
        }
        return nArray2;
    }

    public int[] getPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5 * this.numBands];
        int n6 = 0;
        while (n6 < this.numBands) {
            int n7 = n3 * this.scanlineStride + n2 + this.bandOffsets[n6];
            int n8 = n6;
            int n9 = this.bankIndices[n6];
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n7;
                int n12 = 0;
                while (n12 < n4) {
                    nArray2[n8] = dataBuffer.getElem(n9, n11++);
                    n8 += this.numBands;
                    ++n12;
                }
                n7 += this.scanlineStride;
                ++n10;
            }
            ++n6;
        }
        return nArray2;
    }

    public int getSample(int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = dataBuffer.getElem(this.bankIndices[n4], n3 * this.scanlineStride + n2 + this.bandOffsets[n4]);
        return n5;
    }

    public float getSampleFloat(int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        float f2 = dataBuffer.getElemFloat(this.bankIndices[n4], n3 * this.scanlineStride + n2 + this.bandOffsets[n4]);
        return f2;
    }

    public double getSampleDouble(int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        double d2 = dataBuffer.getElemDouble(this.bankIndices[n4], n3 * this.scanlineStride + n2 + this.bandOffsets[n4]);
        return d2;
    }

    public int[] getSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5];
        int n7 = n3 * this.scanlineStride + n2 + this.bandOffsets[n6];
        int n8 = 0;
        int n9 = this.bankIndices[n6];
        int n10 = 0;
        while (n10 < n5) {
            int n11 = n7;
            int n12 = 0;
            while (n12 < n4) {
                nArray2[n8++] = dataBuffer.getElem(n9, n11++);
                ++n12;
            }
            n7 += this.scanlineStride;
            ++n10;
        }
        return nArray2;
    }

    public void setDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.getTransferType();
        int n5 = this.getNumDataElements();
        int n6 = n3 * this.scanlineStride + n2;
        switch (n4) {
            case 0: {
                byte[] byArray = (byte[])object;
                int n7 = 0;
                while (n7 < n5) {
                    dataBuffer.setElem(this.bankIndices[n7], n6 + this.bandOffsets[n7], byArray[n7] & 0xFF);
                    ++n7;
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                int n8 = 0;
                while (n8 < n5) {
                    dataBuffer.setElem(this.bankIndices[n8], n6 + this.bandOffsets[n8], sArray[n8] & 0xFFFF);
                    ++n8;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int n9 = 0;
                while (n9 < n5) {
                    dataBuffer.setElem(this.bankIndices[n9], n6 + this.bandOffsets[n9], nArray[n9]);
                    ++n9;
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                int n10 = 0;
                while (n10 < n5) {
                    dataBuffer.setElemFloat(this.bankIndices[n10], n6 + this.bandOffsets[n10], fArray[n10]);
                    ++n10;
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                int n11 = 0;
                while (n11 < n5) {
                    dataBuffer.setElemDouble(this.bankIndices[n11], n6 + this.bandOffsets[n11], dArray[n11]);
                    ++n11;
                }
                break;
            }
        }
    }

    public void setPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = n3 * this.scanlineStride + n2;
        int n5 = 0;
        while (n5 < this.numBands) {
            dataBuffer.setElem(this.bankIndices[n5], n4 + this.bandOffsets[n5], nArray[n5]);
            ++n5;
        }
    }

    public void setPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = 0;
        while (n6 < this.numBands) {
            int n7 = n3 * this.scanlineStride + n2 + this.bandOffsets[n6];
            int n8 = n6;
            int n9 = this.bankIndices[n6];
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n7;
                int n12 = 0;
                while (n12 < n4) {
                    dataBuffer.setElem(n9, n11++, nArray[n8]);
                    n8 += this.numBands;
                    ++n12;
                }
                n7 += this.scanlineStride;
                ++n10;
            }
            ++n6;
        }
    }

    public void setSample(int n2, int n3, int n4, int n5, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElem(this.bankIndices[n4], n3 * this.scanlineStride + n2 + this.bandOffsets[n4], n5);
    }

    public void setSample(int n2, int n3, int n4, float f2, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElemFloat(this.bankIndices[n4], n3 * this.scanlineStride + n2 + this.bandOffsets[n4], f2);
    }

    public void setSample(int n2, int n3, int n4, double d2, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElemDouble(this.bankIndices[n4], n3 * this.scanlineStride + n2 + this.bandOffsets[n4], d2);
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n7 = n3 * this.scanlineStride + n2 + this.bandOffsets[n6];
        int n8 = 0;
        int n9 = this.bankIndices[n6];
        int n10 = 0;
        while (n10 < n5) {
            int n11 = n7;
            int n12 = 0;
            while (n12 < n4) {
                dataBuffer.setElem(n9, n11++, nArray[n8++]);
                ++n12;
            }
            n7 += this.scanlineStride;
            ++n10;
        }
    }

    private static int[] createOffsetArray(int n2) {
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = 0;
            ++n3;
        }
        return nArray;
    }

    private static int[] createIndicesArray(int n2) {
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = n3;
            ++n3;
        }
        return nArray;
    }

    public int hashCode() {
        return super.hashCode() ^ 2;
    }
}

