/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.SocketTimeoutException;
import java.net.SocksConsts;
import java.net.SocksSocketImpl;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

class SocksSocketImplFactory
implements SocketImplFactory,
SocksConsts {
    private String server;
    private int port = -1;
    private boolean useV4 = false;

    SocksSocketImplFactory(String string, int n2) {
        this.server = string;
        this.port = n2 == -1 ? 1080 : n2;
        this.guessVersion();
    }

    SocksSocketImplFactory(String string, int n2, boolean bl2) {
        this.server = string;
        this.port = n2 == -1 ? 1080 : n2;
        this.useV4 = bl2;
    }

    private void guessVersion() {
        Socket socket;
        try {
            socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Socket socket = new Socket(new PlainSocketImpl());
                    socket.connect(new InetSocketAddress(SocksSocketImplFactory.this.server, SocksSocketImplFactory.this.port));
                    return socket;
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            socket.setSoTimeout(1000);
            outputStream = socket.getOutputStream();
            inputStream = socket.getInputStream();
            outputStream.write(5);
            outputStream.write(2);
            outputStream.write(0);
            outputStream.write(2);
            outputStream.flush();
            int n2 = inputStream.read();
            if (n2 == 5) {
                this.useV4 = false;
                n2 = inputStream.read();
            } else {
                this.useV4 = true;
            }
            inputStream.close();
            outputStream.close();
            socket.close();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.useV4 = true;
            try {
                inputStream.close();
                outputStream.close();
                socket.close();
            }
            catch (Exception exception) {
            }
        }
        catch (IOException iOException) {}
    }

    public SocketImpl createSocketImpl() {
        SocksSocketImpl socksSocketImpl = new SocksSocketImpl(this.server, this.port);
        if (this.useV4) {
            socksSocketImpl.setV4();
        }
        return socksSocketImpl;
    }
}

