/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.Parts;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sun.security.action.GetPropertyAction;

public final class URL
implements Serializable {
    static final long serialVersionUID = -7627629688361524110L;
    private static final String protocolPathProp = "java.protocol.handler.pkgs";
    private String protocol;
    private String host;
    private int port = -1;
    private String file;
    private transient String query;
    private String authority;
    private transient String path;
    private transient String userInfo;
    private String ref;
    transient InetAddress hostAddress;
    transient URLStreamHandler handler;
    private int hashCode = -1;
    private static NetPermission specifyHandlerPerm;
    static URLStreamHandlerFactory factory;
    static Hashtable handlers;
    private static Object streamHandlerLock;

    public URL(String string, String string2, int n2, String string3) throws MalformedURLException {
        this(string, string2, n2, string3, null);
    }

    public URL(String string, String string2, String string3) throws MalformedURLException {
        this(string, string2, -1, string3);
    }

    public URL(String string, String string2, int n2, String string3, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        this(string, string2, n2, new Parts(string3), uRLStreamHandler);
    }

    private URL(String string, String string2, int n2, Parts parts, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        this(string, null, null, null, string2, n2, parts.getPath(), parts.getQuery(), parts.getRef(), uRLStreamHandler);
    }

    URL(String string, String string2, String object, String string3, String string4, int n2, String string5, String string6, String string7, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        Object object2;
        if (uRLStreamHandler != null && (object2 = System.getSecurityManager()) != null) {
            this.checkSpecifyHandler((SecurityManager)object2);
        }
        this.protocol = string = string.toLowerCase();
        if (string2 != null) {
            this.path = string2;
        } else {
            if (string4 != null) {
                this.userInfo = string3;
                if (string4 != null && string4.indexOf(58) >= 0 && !string4.startsWith("[")) {
                    string4 = "[" + string4 + "]";
                }
                this.host = string4;
                if (n2 < -1) {
                    throw new MalformedURLException("Invalid port number :" + n2);
                }
                this.port = n2;
                if (object == null) {
                    object2 = n2 == -1 ? string4 : string4 + ":" + n2;
                    object = string3 == null ? object2 : string3 + "@" + (String)object2;
                }
            }
            this.authority = object;
            this.path = string5;
            this.query = string6;
            this.file = string6 != null ? string5 + "?" + string6 : this.path;
        }
        this.ref = string7;
        if (uRLStreamHandler == null && (uRLStreamHandler = URL.getURLStreamHandler(string)) == null) {
            throw new MalformedURLException("unknown protocol: " + string);
        }
        this.handler = uRLStreamHandler;
    }

    public URL(String string) throws MalformedURLException {
        this(null, string);
    }

    public URL(URL uRL, String string) throws MalformedURLException {
        this(uRL, string, null);
    }

    public URL(URL uRL, String string, URLStreamHandler uRLStreamHandler) throws MalformedURLException {
        Object object;
        String string2 = string;
        int n2 = 0;
        Object object2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (uRLStreamHandler != null && (object = System.getSecurityManager()) != null) {
            this.checkSpecifyHandler((SecurityManager)object);
        }
        try {
            char c2;
            int n3 = string.length();
            while (n3 > 0 && string.charAt(n3 - 1) <= ' ') {
                --n3;
            }
            while (n2 < n3 && string.charAt(n2) <= ' ') {
                ++n2;
            }
            if (string.regionMatches(true, n2, "url:", 0, 4)) {
                n2 += 4;
            }
            if (n2 < string.length() && string.charAt(n2) == '#') {
                bl2 = true;
            }
            int n4 = n2;
            while (!bl2 && n4 < n3 && (c2 = string.charAt(n4)) != '/') {
                if (c2 == ':') {
                    object = string.substring(n2, n4).toLowerCase();
                    if (!this.isValidProtocol((String)object)) break;
                    object2 = object;
                    n2 = n4 + 1;
                    break;
                }
                ++n4;
            }
            this.protocol = object2;
            if (uRL != null && (object2 == null || ((String)object2).equalsIgnoreCase(uRL.protocol))) {
                if (uRLStreamHandler == null) {
                    uRLStreamHandler = uRL.handler;
                }
                if (uRL.path != null && uRL.path.startsWith("/")) {
                    object2 = null;
                }
                if (object2 == null) {
                    this.protocol = uRL.protocol;
                    this.authority = uRL.authority;
                    this.userInfo = uRL.userInfo;
                    this.host = uRL.host;
                    this.port = uRL.port;
                    this.file = uRL.file;
                    this.path = uRL.path;
                    bl3 = true;
                }
            }
            if (this.protocol == null) {
                throw new MalformedURLException("no protocol: " + string2);
            }
            if (uRLStreamHandler == null && (uRLStreamHandler = URL.getURLStreamHandler(this.protocol)) == null) {
                throw new MalformedURLException("unknown protocol: " + this.protocol);
            }
            this.handler = uRLStreamHandler;
            n4 = string.indexOf(35, n2);
            if (n4 >= 0) {
                this.ref = string.substring(n4 + 1, n3);
                n3 = n4;
            }
            if (bl3 && n2 == n3) {
                this.query = uRL.query;
                if (this.ref == null) {
                    this.ref = uRL.ref;
                }
            }
            uRLStreamHandler.parseURL(this, string, n2, n3);
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
        }
        catch (Exception exception) {
            throw new MalformedURLException(exception.getMessage());
        }
    }

    private boolean isValidProtocol(String string) {
        int n2 = string.length();
        if (n2 < 1) {
            return false;
        }
        char c2 = string.charAt(0);
        if (!Character.isLetter(c2)) {
            return false;
        }
        int n3 = 1;
        while (n3 < n2) {
            c2 = string.charAt(n3);
            if (!Character.isLetterOrDigit(c2) && c2 != '.' && c2 != '+' && c2 != '-') {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private void checkSpecifyHandler(SecurityManager securityManager) {
        if (specifyHandlerPerm == null) {
            specifyHandlerPerm = new NetPermission("specifyStreamHandler");
        }
        securityManager.checkPermission(specifyHandlerPerm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set(String string, String string2, int n2, String string3, String string4) {
        URL uRL = this;
        synchronized (uRL) {
            this.protocol = string;
            this.host = string2;
            this.authority = n2 == -1 ? string2 : string2 + ":" + n2;
            this.port = n2;
            this.file = string3;
            this.ref = string4;
            this.hashCode = -1;
            this.hostAddress = null;
            int n3 = string3.lastIndexOf(63);
            if (n3 != -1) {
                this.query = string3.substring(n3 + 1);
                this.path = string3.substring(0, n3);
            } else {
                this.path = string3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set(String string, String string2, int n2, String string3, String string4, String string5, String string6, String string7) {
        URL uRL = this;
        synchronized (uRL) {
            this.protocol = string;
            this.host = string2;
            this.port = n2;
            this.file = string6 == null ? string5 : string5 + "?" + string6;
            this.userInfo = string4;
            this.path = string5;
            this.ref = string7;
            this.hashCode = -1;
            this.hostAddress = null;
            this.query = string6;
            this.authority = string3;
        }
    }

    public String getQuery() {
        return this.query;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getAuthority() {
        return this.authority;
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.handler.getDefaultPort();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getFile() {
        return this.file;
    }

    public String getRef() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (!(object instanceof URL)) {
            return false;
        }
        URL uRL = (URL)object;
        return this.handler.equals(this, uRL);
    }

    public synchronized int hashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        this.hashCode = this.handler.hashCode(this);
        return this.hashCode;
    }

    public boolean sameFile(URL uRL) {
        return this.handler.sameFile(this, uRL);
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        return this.handler.toExternalForm(this);
    }

    public URLConnection openConnection() throws IOException {
        return this.handler.openConnection(this);
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    public final Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    public final Object getContent(Class[] classArray) throws IOException {
        return this.openConnection().getContent(classArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setURLStreamHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        Object object = streamHandlerLock;
        synchronized (object) {
            if (factory != null) {
                throw new Error("factory already defined");
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkSetFactory();
            }
            handlers.clear();
            factory = uRLStreamHandlerFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URLStreamHandler getURLStreamHandler(String string) {
        URLStreamHandler uRLStreamHandler = (URLStreamHandler)handlers.get(string);
        if (uRLStreamHandler == null) {
            Object object;
            Object object2;
            boolean bl2 = false;
            if (factory != null) {
                uRLStreamHandler = factory.createURLStreamHandler(string);
                bl2 = true;
            }
            if (uRLStreamHandler == null) {
                object2 = null;
                object2 = (String)AccessController.doPrivileged(new GetPropertyAction(protocolPathProp, ""));
                if (object2 != "") {
                    object2 = (String)object2 + "|";
                }
                object2 = (String)object2 + "sun.net.www.protocol";
                object = new StringTokenizer((String)object2, "|");
                while (uRLStreamHandler == null && ((StringTokenizer)object).hasMoreTokens()) {
                    String string2 = ((StringTokenizer)object).nextToken().trim();
                    try {
                        Class clazz;
                        block16: {
                            String string3 = string2 + "." + string + ".Handler";
                            clazz = null;
                            try {
                                clazz = Class.forName(string3);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                                if (classLoader == null) break block16;
                                clazz = classLoader.loadClass(string3);
                            }
                        }
                        if (clazz == null) continue;
                        uRLStreamHandler = (URLStreamHandler)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            object2 = streamHandlerLock;
            synchronized (object2) {
                object = null;
                object = (URLStreamHandler)handlers.get(string);
                if (object != null) {
                    return object;
                }
                if (!bl2 && factory != null) {
                    object = factory.createURLStreamHandler(string);
                }
                if (object != null) {
                    uRLStreamHandler = object;
                }
                if (uRLStreamHandler != null) {
                    handlers.put(string, uRLStreamHandler);
                }
            }
        }
        return uRLStreamHandler;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n2;
        objectInputStream.defaultReadObject();
        this.handler = URL.getURLStreamHandler(this.protocol);
        if (this.handler == null) {
            throw new IOException("unknown protocol: " + this.protocol);
        }
        if (this.authority == null && (this.host != null && this.host.length() > 0 || this.port != -1)) {
            if (this.host == null) {
                this.host = "";
            }
            this.authority = this.port == -1 ? this.host : this.host + ":" + this.port;
            n2 = this.host.lastIndexOf(64);
            if (n2 != -1) {
                this.userInfo = this.host.substring(0, n2);
                this.host = this.host.substring(n2 + 1);
            }
        } else if (this.authority != null && (n2 = this.authority.indexOf(64)) != -1) {
            this.userInfo = this.authority.substring(0, n2);
        }
        this.path = null;
        this.query = null;
        if (this.file != null) {
            n2 = this.file.lastIndexOf(63);
            if (n2 != -1) {
                this.query = this.file.substring(n2 + 1);
                this.path = this.file.substring(0, n2);
            } else {
                this.path = this.file;
            }
        }
    }

    static {
        handlers = new Hashtable();
        streamHandlerLock = new Object();
    }
}

