/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectByteBuffer;
import java.nio.DirectCharBufferRU;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectCharBufferU
extends CharBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe;
    protected static final boolean unaligned;
    protected boolean allocated;
    protected Object viewedBuffer = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$nio$DirectCharBufferU;

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    DirectCharBufferU(DirectByteBuffer directByteBuffer) {
        super(-1, 0, directByteBuffer.remaining() >> 1, directByteBuffer.remaining() >> 1);
        int n2 = this.capacity();
        this.limit(n2);
        int n3 = this.position();
        if (!$assertionsDisabled && n3 > n2) {
            throw new AssertionError();
        }
        this.address = directByteBuffer.address() + (long)n3;
        this.allocated = false;
        this.viewedBuffer = directByteBuffer;
    }

    DirectCharBufferU(DirectBuffer directBuffer, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5);
        this.address = directBuffer.address() + (long)n6;
        this.allocated = false;
        this.viewedBuffer = directBuffer;
    }

    public CharBuffer slice() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n2 << 1;
        return new DirectCharBufferU(this, -1, 0, n4, n4, n5);
    }

    public CharBuffer duplicate() {
        return new DirectCharBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public CharBuffer asReadOnlyBuffer() {
        return new DirectCharBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public long address() {
        return this.address;
    }

    private long ix(int n2) {
        return this.address + (long)(n2 << 1);
    }

    public char get() {
        return unsafe.getChar(this.ix(this.nextGetIndex()));
    }

    public char get(int n2) {
        return unsafe.getChar(this.ix(this.checkIndex(n2)));
    }

    public CharBuffer get(char[] cArray, int n2, int n3) {
        if (n3 << 1 > 6) {
            int n4;
            Buffer.checkBounds(n2, n3, cArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            if (!$assertionsDisabled && n5 > n6) {
                throw new AssertionError();
            }
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToCharArray(this.ix(n5), cArray, n2 << 1, n3 << 1);
            } else {
                Bits.copyToByteArray(this.ix(n5), cArray, n2 << 1, n3 << 1);
            }
            this.position(n5 + n3);
        } else {
            super.get(cArray, n2, n3);
        }
        return this;
    }

    public CharBuffer put(char c2) {
        unsafe.putChar(this.ix(this.nextPutIndex()), c2);
        return this;
    }

    public CharBuffer put(int n2, char c2) {
        unsafe.putChar(this.ix(this.checkIndex(n2)), c2);
        return this;
    }

    public CharBuffer put(CharBuffer charBuffer) {
        if (charBuffer instanceof DirectCharBufferU) {
            int n2;
            if (charBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectCharBufferU directCharBufferU = (DirectCharBufferU)charBuffer;
            int n3 = directCharBufferU.position();
            int n4 = directCharBufferU.limit();
            if (!$assertionsDisabled && n3 > n4) {
                throw new AssertionError();
            }
            int n5 = n3 <= n4 ? n4 - n3 : 0;
            int n6 = this.position();
            int n7 = this.limit();
            if (!$assertionsDisabled && n6 > n7) {
                throw new AssertionError();
            }
            int n8 = n2 = n6 <= n7 ? n7 - n6 : 0;
            if (n5 > n2) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directCharBufferU.ix(n3), this.ix(n6), n5 << 1);
            directCharBufferU.position(n3 + n5);
            this.position(n6 + n5);
        } else if (!charBuffer.isDirect()) {
            int n9 = charBuffer.position();
            int n10 = charBuffer.limit();
            if (!$assertionsDisabled && n9 > n10) {
                throw new AssertionError();
            }
            int n11 = n9 <= n10 ? n10 - n9 : 0;
            this.put(charBuffer.array(), charBuffer.arrayOffset() + n9, n11);
            charBuffer.position(n9 + n11);
        } else {
            super.put(charBuffer);
        }
        return this;
    }

    public CharBuffer put(char[] cArray, int n2, int n3) {
        if (n3 << 1 > 6) {
            int n4;
            Buffer.checkBounds(n2, n3, cArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            if (!$assertionsDisabled && n5 > n6) {
                throw new AssertionError();
            }
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromCharArray(cArray, n2 << 1, this.ix(n5), n3 << 1);
            } else {
                Bits.copyFromByteArray(cArray, n2 << 1, this.ix(n5), n3 << 1);
            }
            this.position(n5 + n3);
        } else {
            super.put(cArray, n2, n3);
        }
        return this;
    }

    public CharBuffer compact() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        unsafe.copyMemory(this.ix(n2), this.ix(0), n4 << 1);
        this.position(n4);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public String toString(int n2, int n3) {
        if (n3 > this.limit() || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int n4 = n3 - n2;
            char[] cArray = new char[n4];
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            CharBuffer charBuffer2 = this.duplicate();
            charBuffer2.position(n2);
            charBuffer2.limit(n3);
            charBuffer.put(charBuffer2);
            return new String(cArray);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public CharSequence subSequence(int n2, int n3) {
        int n4 = this.length();
        int n5 = this.position();
        if (!$assertionsDisabled && n5 > n4) {
            throw new AssertionError();
        }
        int n6 = n5 = n5 <= n4 ? n5 : n4;
        if (n2 < 0 || n3 > n4 || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        int n7 = n3 - n2;
        int n8 = n5 + n2 << 1;
        return new DirectCharBufferU(this, -1, 0, n7, n7, n8);
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$java$nio$DirectCharBufferU == null ? (class$java$nio$DirectCharBufferU = DirectCharBufferU.class$("java.nio.DirectCharBufferU")) : class$java$nio$DirectCharBufferU).desiredAssertionStatus();
        unsafe = Bits.unsafe();
        unaligned = Bits.unaligned();
    }
}

