/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FixedHeightLayoutCache
extends AbstractLayoutCache {
    private FHTreeStateNode root;
    private int rowCount;
    private Rectangle boundsBuffer;
    private Hashtable treePathMapping;
    private SearchInfo info;
    private Stack tempStacks = new Stack();

    public FixedHeightLayoutCache() {
        this.boundsBuffer = new Rectangle();
        this.treePathMapping = new Hashtable();
        this.info = new SearchInfo();
        this.setRowHeight(1);
    }

    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        this.rebuild(false);
    }

    public void setRootVisible(boolean bl2) {
        if (this.isRootVisible() != bl2) {
            super.setRootVisible(bl2);
            if (this.root != null) {
                if (bl2) {
                    ++this.rowCount;
                    this.root.adjustRowBy(1);
                } else {
                    --this.rowCount;
                    this.root.adjustRowBy(-1);
                }
                this.visibleNodesChanged();
            }
        }
    }

    public void setRowHeight(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("FixedHeightLayoutCache only supports row heights greater than 0");
        }
        if (this.getRowHeight() != n2) {
            super.setRowHeight(n2);
            this.visibleNodesChanged();
        }
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void invalidatePathBounds(TreePath treePath) {
    }

    public void invalidateSizes() {
        this.visibleNodesChanged();
    }

    public boolean isExpanded(TreePath treePath) {
        if (treePath != null) {
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
            return fHTreeStateNode != null && fHTreeStateNode.isExpanded();
        }
        return false;
    }

    public Rectangle getBounds(TreePath treePath, Rectangle rectangle) {
        int n2;
        if (treePath == null) {
            return null;
        }
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode != null) {
            return this.getBounds(fHTreeStateNode, -1, rectangle);
        }
        TreePath treePath2 = treePath.getParentPath();
        fHTreeStateNode = this.getNodeForPath(treePath2, true, false);
        if (fHTreeStateNode != null && (n2 = this.treeModel.getIndexOfChild(treePath2.getLastPathComponent(), treePath.getLastPathComponent())) != -1) {
            return this.getBounds(fHTreeStateNode, n2, rectangle);
        }
        return null;
    }

    public TreePath getPathForRow(int n2) {
        if (n2 >= 0 && n2 < this.getRowCount() && this.root.getPathForRow(n2, this.getRowCount(), this.info)) {
            return this.info.getPath();
        }
        return null;
    }

    public int getRowForPath(TreePath treePath) {
        if (treePath == null || this.root == null) {
            return -1;
        }
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode != null) {
            return fHTreeStateNode.getRow();
        }
        TreePath treePath2 = treePath.getParentPath();
        fHTreeStateNode = this.getNodeForPath(treePath2, true, false);
        if (fHTreeStateNode != null && fHTreeStateNode.isExpanded()) {
            return fHTreeStateNode.getRowToModelIndex(this.treeModel.getIndexOfChild(treePath2.getLastPathComponent(), treePath.getLastPathComponent()));
        }
        return -1;
    }

    public TreePath getPathClosestTo(int n2, int n3) {
        if (this.getRowCount() == 0) {
            return null;
        }
        int n4 = this.getRowContainingYLocation(n3);
        return this.getPathForRow(n4);
    }

    public int getVisibleChildCount(TreePath treePath) {
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode == null) {
            return 0;
        }
        return fHTreeStateNode.getTotalChildCount();
    }

    public Enumeration getVisiblePathsFrom(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode != null) {
            return new VisibleFHTreeStateNodeEnumeration(fHTreeStateNode);
        }
        TreePath treePath2 = treePath.getParentPath();
        fHTreeStateNode = this.getNodeForPath(treePath2, true, false);
        if (fHTreeStateNode != null && fHTreeStateNode.isExpanded()) {
            return new VisibleFHTreeStateNodeEnumeration(fHTreeStateNode, this.treeModel.getIndexOfChild(treePath2.getLastPathComponent(), treePath.getLastPathComponent()));
        }
        return null;
    }

    public void setExpandedState(TreePath treePath, boolean bl2) {
        if (bl2) {
            this.ensurePathIsExpanded(treePath, true);
        } else if (treePath != null) {
            FHTreeStateNode fHTreeStateNode;
            TreePath treePath2 = treePath.getParentPath();
            if (treePath2 != null && (fHTreeStateNode = this.getNodeForPath(treePath2, false, true)) != null) {
                fHTreeStateNode.makeVisible();
            }
            if ((fHTreeStateNode = this.getNodeForPath(treePath, true, false)) != null) {
                fHTreeStateNode.collapse(true);
            }
        }
    }

    public boolean getExpandedState(TreePath treePath) {
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        return fHTreeStateNode != null ? fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded() : false;
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treeModelEvent.getTreePath(), false, false);
            int[] nArray = treeModelEvent.getChildIndices();
            if (fHTreeStateNode != null) {
                int n2;
                if (nArray != null && (n2 = nArray.length) > 0) {
                    Object object = fHTreeStateNode.getUserObject();
                    int n3 = 0;
                    while (n3 < n2) {
                        FHTreeStateNode fHTreeStateNode2 = fHTreeStateNode.getChildAtModelIndex(nArray[n3]);
                        if (fHTreeStateNode2 != null) {
                            fHTreeStateNode2.setUserObject(this.treeModel.getChild(object, nArray[n3]));
                        }
                        ++n3;
                    }
                    if (fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded()) {
                        this.visibleNodesChanged();
                    }
                } else if (fHTreeStateNode == this.root && fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded()) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int n2;
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treeModelEvent.getTreePath(), false, false);
            int[] nArray = treeModelEvent.getChildIndices();
            if (fHTreeStateNode != null && nArray != null && (n2 = nArray.length) > 0) {
                boolean bl2 = fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded();
                int n3 = 0;
                while (n3 < n2) {
                    fHTreeStateNode.childInsertedAtModelIndex(nArray[n3], bl2);
                    ++n3;
                }
                if (bl2 && this.treeSelectionModel != null) {
                    this.treeSelectionModel.resetRowSelection();
                }
                if (fHTreeStateNode.isVisible()) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int n2;
            TreePath treePath = treeModelEvent.getTreePath();
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, false, false);
            int[] nArray = treeModelEvent.getChildIndices();
            if (fHTreeStateNode != null && nArray != null && (n2 = nArray.length) > 0) {
                Object[] objectArray = treeModelEvent.getChildren();
                boolean bl2 = fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded();
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    fHTreeStateNode.removeChildAtModelIndex(nArray[n3], bl2);
                    --n3;
                }
                if (bl2) {
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (this.treeModel.getChildCount(fHTreeStateNode.getUserObject()) == 0 && fHTreeStateNode.isLeaf()) {
                        fHTreeStateNode.collapse(false);
                    }
                    this.visibleNodesChanged();
                } else if (fHTreeStateNode.isVisible()) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            TreePath treePath = treeModelEvent.getTreePath();
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, false, false);
            if (fHTreeStateNode == this.root || fHTreeStateNode == null && (treePath == null && this.treeModel != null && this.treeModel.getRoot() == null || treePath != null && treePath.getPathCount() <= 1)) {
                this.rebuild(true);
            } else if (fHTreeStateNode != null) {
                FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)fHTreeStateNode.getParent();
                boolean bl2 = fHTreeStateNode.isExpanded();
                boolean bl3 = fHTreeStateNode.isVisible();
                fHTreeStateNode2.removeChildAtModelIndex(fHTreeStateNode.getChildIndex(), bl3);
                if (bl3 && bl2) {
                    fHTreeStateNode = this.getNodeForPath(treePath, false, true);
                    fHTreeStateNode.expand();
                }
                if (this.treeSelectionModel != null && bl3 && bl2) {
                    this.treeSelectionModel.resetRowSelection();
                }
                if (bl3) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    private void visibleNodesChanged() {
    }

    private Rectangle getBounds(FHTreeStateNode fHTreeStateNode, int n2, Rectangle rectangle) {
        int n3;
        boolean bl2;
        Object object;
        int n4;
        if (n2 == -1) {
            n4 = fHTreeStateNode.getRow();
            object = fHTreeStateNode.getUserObject();
            bl2 = fHTreeStateNode.isExpanded();
            n3 = fHTreeStateNode.getLevel();
        } else {
            n4 = fHTreeStateNode.getRowToModelIndex(n2);
            object = this.treeModel.getChild(fHTreeStateNode.getUserObject(), n2);
            bl2 = false;
            n3 = fHTreeStateNode.getLevel() + 1;
        }
        Rectangle rectangle2 = this.getNodeDimensions(object, n4, n3, bl2, this.boundsBuffer);
        if (rectangle2 == null) {
            return null;
        }
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.x = rectangle2.x;
        rectangle.height = this.getRowHeight();
        rectangle.y = n4 * rectangle.height;
        rectangle.width = rectangle2.width;
        return rectangle;
    }

    private void adjustRowCountBy(int n2) {
        this.rowCount += n2;
    }

    private void addMapping(FHTreeStateNode fHTreeStateNode) {
        this.treePathMapping.put(fHTreeStateNode.getTreePath(), fHTreeStateNode);
    }

    private void removeMapping(FHTreeStateNode fHTreeStateNode) {
        this.treePathMapping.remove(fHTreeStateNode.getTreePath());
    }

    private FHTreeStateNode getMapping(TreePath treePath) {
        return (FHTreeStateNode)this.treePathMapping.get(treePath);
    }

    private void rebuild(boolean bl2) {
        Object object;
        this.treePathMapping.clear();
        if (this.treeModel != null && (object = this.treeModel.getRoot()) != null) {
            this.root = this.createNodeForValue(object, 0);
            this.root.path = new TreePath(object);
            this.addMapping(this.root);
            if (this.isRootVisible()) {
                this.rowCount = 1;
                this.root.row = 0;
            } else {
                this.rowCount = 0;
                this.root.row = -1;
            }
            this.root.expand();
        } else {
            this.root = null;
            this.rowCount = 0;
        }
        if (bl2 && this.treeSelectionModel != null) {
            this.treeSelectionModel.clearSelection();
        }
        this.visibleNodesChanged();
    }

    private int getRowContainingYLocation(int n2) {
        if (this.getRowCount() == 0) {
            return -1;
        }
        return Math.max(0, Math.min(this.getRowCount() - 1, n2 / this.getRowHeight()));
    }

    private boolean ensurePathIsExpanded(TreePath treePath, boolean bl2) {
        if (treePath != null) {
            FHTreeStateNode fHTreeStateNode;
            if (this.treeModel.isLeaf(treePath.getLastPathComponent())) {
                treePath = treePath.getParentPath();
                bl2 = true;
            }
            if (treePath != null && (fHTreeStateNode = this.getNodeForPath(treePath, false, true)) != null) {
                fHTreeStateNode.makeVisible();
                if (bl2) {
                    fHTreeStateNode.expand();
                }
                return true;
            }
        }
        return false;
    }

    private FHTreeStateNode createNodeForValue(Object object, int n2) {
        return new FHTreeStateNode(object, n2, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FHTreeStateNode getNodeForPath(TreePath treePath, boolean bl2, boolean bl3) {
        if (treePath == null) return null;
        FHTreeStateNode fHTreeStateNode = this.getMapping(treePath);
        if (fHTreeStateNode != null) {
            if (!bl2) return fHTreeStateNode;
            if (fHTreeStateNode.isVisible()) return fHTreeStateNode;
            return null;
        }
        if (bl2) {
            return null;
        }
        Stack stack = this.tempStacks.size() == 0 ? new Stack() : (Stack)this.tempStacks.pop();
        try {
            stack.push(treePath);
            treePath = treePath.getParentPath();
            fHTreeStateNode = null;
            while (true) {
                if (treePath == null) {
                    break;
                }
                fHTreeStateNode = this.getMapping(treePath);
                if (fHTreeStateNode != null) {
                    while (true) {
                        if (fHTreeStateNode == null || stack.size() <= 0) break;
                        treePath = (TreePath)stack.pop();
                        fHTreeStateNode = fHTreeStateNode.createChildFor(treePath.getLastPathComponent());
                    }
                    FHTreeStateNode fHTreeStateNode2 = fHTreeStateNode;
                    Object var8_7 = null;
                    stack.removeAllElements();
                    this.tempStacks.push(stack);
                    return fHTreeStateNode2;
                }
                stack.push(treePath);
                treePath = treePath.getParentPath();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            stack.removeAllElements();
            this.tempStacks.push(stack);
            throw throwable;
        }
        Object var8_8 = null;
        stack.removeAllElements();
        this.tempStacks.push(stack);
        return null;
    }

    static /* synthetic */ FHTreeStateNode access$600(FixedHeightLayoutCache fixedHeightLayoutCache) {
        return fixedHeightLayoutCache.root;
    }

    private class VisibleFHTreeStateNodeEnumeration
    implements Enumeration {
        protected FHTreeStateNode parent;
        protected int nextIndex;
        protected int childCount;

        protected VisibleFHTreeStateNodeEnumeration(FHTreeStateNode fHTreeStateNode) {
            this(fHTreeStateNode, -1);
        }

        protected VisibleFHTreeStateNodeEnumeration(FHTreeStateNode fHTreeStateNode, int n2) {
            this.parent = fHTreeStateNode;
            this.nextIndex = n2;
            this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(this.parent.getUserObject());
        }

        public boolean hasMoreElements() {
            return this.parent != null;
        }

        public Object nextElement() {
            FHTreeStateNode fHTreeStateNode;
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more visible paths");
            }
            TreePath treePath = this.nextIndex == -1 ? this.parent.getTreePath() : ((fHTreeStateNode = this.parent.getChildAtModelIndex(this.nextIndex)) == null ? this.parent.getTreePath().pathByAddingChild(FixedHeightLayoutCache.this.treeModel.getChild(this.parent.getUserObject(), this.nextIndex)) : fHTreeStateNode.getTreePath());
            this.updateNextObject();
            return treePath;
        }

        protected void updateNextObject() {
            if (!this.updateNextIndex()) {
                this.findNextValidParent();
            }
        }

        /*
         * Unable to fully structure code
         */
        protected boolean findNextValidParent() {
            if (this.parent != FixedHeightLayoutCache.access$600(FixedHeightLayoutCache.this)) ** GOTO lbl12
            this.parent = null;
            return false;
lbl-1000:
            // 1 sources

            {
                var1_1 = (FHTreeStateNode)this.parent.getParent();
                if (var1_1 != null) {
                    this.nextIndex = this.parent.childIndex;
                    this.parent = var1_1;
                    this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(this.parent.getUserObject());
                    if (!this.updateNextIndex()) continue;
                    return true;
                }
                this.parent = null;
lbl12:
                // 3 sources

                ** while (this.parent != null)
            }
lbl13:
            // 1 sources

            return false;
        }

        protected boolean updateNextIndex() {
            if (this.nextIndex == -1 && !this.parent.isExpanded()) {
                return false;
            }
            if (this.childCount == 0) {
                return false;
            }
            if (++this.nextIndex >= this.childCount) {
                return false;
            }
            FHTreeStateNode fHTreeStateNode = this.parent.getChildAtModelIndex(this.nextIndex);
            if (fHTreeStateNode != null && fHTreeStateNode.isExpanded()) {
                this.parent = fHTreeStateNode;
                this.nextIndex = -1;
                this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(fHTreeStateNode.getUserObject());
            }
            return true;
        }
    }

    private class SearchInfo {
        protected FHTreeStateNode node;
        protected boolean isNodeParentNode;
        protected int childIndex;

        private SearchInfo() {
        }

        protected TreePath getPath() {
            if (this.node == null) {
                return null;
            }
            if (this.isNodeParentNode) {
                return this.node.getTreePath().pathByAddingChild(FixedHeightLayoutCache.this.treeModel.getChild(this.node.getUserObject(), this.childIndex));
            }
            return this.node.path;
        }
    }

    private class FHTreeStateNode
    extends DefaultMutableTreeNode {
        protected boolean isExpanded;
        protected int childIndex;
        protected int row;
        protected TreePath path;

        public FHTreeStateNode(Object object, int n2, int n3) {
            super(object);
            this.childIndex = n2;
            this.row = n3;
        }

        public void setParent(MutableTreeNode mutableTreeNode) {
            super.setParent(mutableTreeNode);
            if (mutableTreeNode != null) {
                this.path = ((FHTreeStateNode)mutableTreeNode).getTreePath().pathByAddingChild(this.getUserObject());
                FixedHeightLayoutCache.this.addMapping(this);
            }
        }

        public void remove(int n2) {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n2);
            fHTreeStateNode.removeFromMapping();
            super.remove(n2);
        }

        public void setUserObject(Object object) {
            super.setUserObject(object);
            if (this.path != null) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
                if (fHTreeStateNode != null) {
                    this.resetChildrenPaths(fHTreeStateNode.getTreePath());
                } else {
                    this.resetChildrenPaths(null);
                }
            }
        }

        public int getChildIndex() {
            return this.childIndex;
        }

        public TreePath getTreePath() {
            return this.path;
        }

        public FHTreeStateNode getChildAtModelIndex(int n2) {
            int n3 = this.getChildCount() - 1;
            while (n3 >= 0) {
                if (((FHTreeStateNode)this.getChildAt((int)n3)).childIndex == n2) {
                    return (FHTreeStateNode)this.getChildAt(n3);
                }
                --n3;
            }
            return null;
        }

        public boolean isVisible() {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode == null) {
                return true;
            }
            return fHTreeStateNode.isExpanded() && fHTreeStateNode.isVisible();
        }

        public int getRow() {
            return this.row;
        }

        public int getRowToModelIndex(int n2) {
            int n3;
            int n4 = n3 = this.getRow() + 1;
            int n5 = 0;
            int n6 = this.getChildCount();
            while (n5 < n6) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n5);
                if (fHTreeStateNode.childIndex >= n2) {
                    if (fHTreeStateNode.childIndex == n2) {
                        return fHTreeStateNode.row;
                    }
                    if (n5 == 0) {
                        return this.getRow() + 1 + n2;
                    }
                    return fHTreeStateNode.row - (fHTreeStateNode.childIndex - n2);
                }
                ++n5;
            }
            return this.getRow() + 1 + this.getTotalChildCount() - (FixedHeightLayoutCache.this.treeModel.getChildCount(this.getUserObject()) - n2);
        }

        public int getTotalChildCount() {
            if (this.isExpanded()) {
                int n2;
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
                if (fHTreeStateNode != null && (n2 = fHTreeStateNode.getIndex(this)) + 1 < fHTreeStateNode.getChildCount()) {
                    FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)fHTreeStateNode.getChildAt(n2 + 1);
                    return fHTreeStateNode2.row - this.row - (fHTreeStateNode2.childIndex - this.childIndex);
                }
                int n3 = FixedHeightLayoutCache.this.getModel().getChildCount(this.getUserObject());
                int n4 = this.getChildCount() - 1;
                while (n4 >= 0) {
                    n3 += ((FHTreeStateNode)this.getChildAt(n4)).getTotalChildCount();
                    --n4;
                }
                return n3;
            }
            return 0;
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public int getVisibleLevel() {
            if (FixedHeightLayoutCache.this.isRootVisible()) {
                return this.getLevel();
            }
            return this.getLevel() - 1;
        }

        protected void resetChildrenPaths(TreePath treePath) {
            FixedHeightLayoutCache.this.removeMapping(this);
            this.path = treePath == null ? new TreePath(this.getUserObject()) : treePath.pathByAddingChild(this.getUserObject());
            FixedHeightLayoutCache.this.addMapping(this);
            int n2 = this.getChildCount() - 1;
            while (n2 >= 0) {
                ((FHTreeStateNode)this.getChildAt(n2)).resetChildrenPaths(this.path);
                --n2;
            }
        }

        protected void removeFromMapping() {
            if (this.path != null) {
                FixedHeightLayoutCache.this.removeMapping(this);
                int n2 = this.getChildCount() - 1;
                while (n2 >= 0) {
                    ((FHTreeStateNode)this.getChildAt(n2)).removeFromMapping();
                    --n2;
                }
            }
        }

        protected FHTreeStateNode createChildFor(Object object) {
            int n2 = FixedHeightLayoutCache.this.treeModel.getIndexOfChild(this.getUserObject(), object);
            if (n2 < 0) {
                return null;
            }
            FHTreeStateNode fHTreeStateNode = FixedHeightLayoutCache.this.createNodeForValue(object, n2);
            int n3 = this.isVisible() ? this.getRowToModelIndex(n2) : -1;
            fHTreeStateNode.row = n3;
            int n4 = 0;
            int n5 = this.getChildCount();
            while (n4 < n5) {
                FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)this.getChildAt(n4);
                if (fHTreeStateNode2.childIndex > n2) {
                    this.insert(fHTreeStateNode, n4);
                    return fHTreeStateNode;
                }
                ++n4;
            }
            this.add(fHTreeStateNode);
            return fHTreeStateNode;
        }

        protected void adjustRowBy(int n2) {
            this.row += n2;
            if (this.isExpanded) {
                int n3 = this.getChildCount() - 1;
                while (n3 >= 0) {
                    ((FHTreeStateNode)this.getChildAt(n3)).adjustRowBy(n2);
                    --n3;
                }
            }
        }

        protected void adjustRowBy(int n2, int n3) {
            FHTreeStateNode fHTreeStateNode;
            if (this.isExpanded) {
                int n4 = this.getChildCount() - 1;
                while (n4 >= n3) {
                    ((FHTreeStateNode)this.getChildAt(n4)).adjustRowBy(n2);
                    --n4;
                }
            }
            if ((fHTreeStateNode = (FHTreeStateNode)this.getParent()) != null) {
                fHTreeStateNode.adjustRowBy(n2, fHTreeStateNode.getIndex(this) + 1);
            }
        }

        protected void didExpand() {
            int n2 = this.setRowAndChildren(this.row);
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            int n3 = n2 - this.row - 1;
            if (fHTreeStateNode != null) {
                fHTreeStateNode.adjustRowBy(n3, fHTreeStateNode.getIndex(this) + 1);
            }
            FixedHeightLayoutCache.this.adjustRowCountBy(n3);
        }

        protected int setRowAndChildren(int n2) {
            this.row = n2;
            if (!this.isExpanded()) {
                return this.row + 1;
            }
            int n3 = this.row + 1;
            int n4 = 0;
            int n5 = this.getChildCount();
            int n6 = 0;
            while (n6 < n5) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n6);
                n3 += fHTreeStateNode.childIndex - n4;
                n4 = fHTreeStateNode.childIndex + 1;
                if (fHTreeStateNode.isExpanded) {
                    n3 = fHTreeStateNode.setRowAndChildren(n3);
                } else {
                    fHTreeStateNode.row = n3++;
                }
                ++n6;
            }
            return n3 + FixedHeightLayoutCache.this.treeModel.getChildCount(this.getUserObject()) - n4;
        }

        protected void resetChildrenRowsFrom(int n2, int n3, int n4) {
            FHTreeStateNode fHTreeStateNode;
            int n5 = n2;
            int n6 = n4;
            int n7 = this.getChildCount();
            int n8 = n3;
            while (n8 < n7) {
                fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n8);
                n5 += fHTreeStateNode.childIndex - n6;
                n6 = fHTreeStateNode.childIndex + 1;
                if (fHTreeStateNode.isExpanded) {
                    n5 = fHTreeStateNode.setRowAndChildren(n5);
                } else {
                    fHTreeStateNode.row = n5++;
                }
                ++n8;
            }
            n5 += FixedHeightLayoutCache.this.treeModel.getChildCount(this.getUserObject()) - n6;
            fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode != null) {
                fHTreeStateNode.resetChildrenRowsFrom(n5, fHTreeStateNode.getIndex(this) + 1, this.childIndex + 1);
            } else {
                FixedHeightLayoutCache.this.rowCount = n5;
            }
        }

        protected void makeVisible() {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode != null) {
                fHTreeStateNode.expandParentAndReceiver();
            }
        }

        protected void expandParentAndReceiver() {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode != null) {
                fHTreeStateNode.expandParentAndReceiver();
            }
            this.expand();
        }

        protected void expand() {
            if (!this.isExpanded && !this.isLeaf()) {
                boolean bl2 = this.isVisible();
                this.isExpanded = true;
                if (bl2) {
                    this.didExpand();
                }
                if (bl2 && FixedHeightLayoutCache.this.treeSelectionModel != null) {
                    FixedHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        protected void collapse(boolean bl2) {
            if (this.isExpanded) {
                if (this.isVisible() && bl2) {
                    int n2 = this.getTotalChildCount();
                    this.isExpanded = false;
                    FixedHeightLayoutCache.this.adjustRowCountBy(-n2);
                    this.adjustRowBy(-n2, 0);
                } else {
                    this.isExpanded = false;
                }
                if (bl2 && this.isVisible() && FixedHeightLayoutCache.this.treeSelectionModel != null) {
                    FixedHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        public boolean isLeaf() {
            TreeModel treeModel = FixedHeightLayoutCache.this.getModel();
            return treeModel != null ? treeModel.isLeaf(this.getUserObject()) : true;
        }

        protected void addNode(FHTreeStateNode fHTreeStateNode) {
            boolean bl2 = false;
            int n2 = fHTreeStateNode.getChildIndex();
            int n3 = 0;
            int n4 = this.getChildCount();
            while (n3 < n4) {
                if (((FHTreeStateNode)this.getChildAt(n3)).getChildIndex() > n2) {
                    bl2 = true;
                    this.insert(fHTreeStateNode, n3);
                    n3 = n4;
                }
                ++n3;
            }
            if (!bl2) {
                this.add(fHTreeStateNode);
            }
        }

        protected void removeChildAtModelIndex(int n2, boolean bl2) {
            FHTreeStateNode fHTreeStateNode = this.getChildAtModelIndex(n2);
            if (fHTreeStateNode != null) {
                int n3 = fHTreeStateNode.getRow();
                int n4 = this.getIndex(fHTreeStateNode);
                fHTreeStateNode.collapse(false);
                this.remove(n4);
                this.adjustChildIndexs(n4, -1);
                if (bl2) {
                    this.resetChildrenRowsFrom(n3, n4, n2);
                }
            } else {
                int n5 = this.getChildCount();
                int n6 = 0;
                while (n6 < n5) {
                    FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)this.getChildAt(n6);
                    if (fHTreeStateNode2.childIndex >= n2) {
                        if (bl2) {
                            this.adjustRowBy(-1, n6);
                            FixedHeightLayoutCache.this.adjustRowCountBy(-1);
                        }
                        while (n6 < n5) {
                            --((FHTreeStateNode)this.getChildAt((int)n6)).childIndex;
                            ++n6;
                        }
                        return;
                    }
                    ++n6;
                }
                if (bl2) {
                    this.adjustRowBy(-1, n5);
                    FixedHeightLayoutCache.this.adjustRowCountBy(-1);
                }
            }
        }

        protected void adjustChildIndexs(int n2, int n3) {
            int n4 = n2;
            int n5 = this.getChildCount();
            while (n4 < n5) {
                ((FHTreeStateNode)this.getChildAt((int)n4)).childIndex += n3;
                ++n4;
            }
        }

        protected void childInsertedAtModelIndex(int n2, boolean bl2) {
            int n3 = this.getChildCount();
            int n4 = 0;
            while (n4 < n3) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n4);
                if (fHTreeStateNode.childIndex >= n2) {
                    if (bl2) {
                        this.adjustRowBy(1, n4);
                        FixedHeightLayoutCache.this.adjustRowCountBy(1);
                    }
                    while (n4 < n3) {
                        ++((FHTreeStateNode)this.getChildAt((int)n4)).childIndex;
                        ++n4;
                    }
                    return;
                }
                ++n4;
            }
            if (bl2) {
                this.adjustRowBy(1, n3);
                FixedHeightLayoutCache.this.adjustRowCountBy(1);
            }
        }

        protected boolean getPathForRow(int n2, int n3, SearchInfo searchInfo) {
            if (this.row == n2) {
                searchInfo.node = this;
                searchInfo.isNodeParentNode = false;
                searchInfo.childIndex = this.childIndex;
                return true;
            }
            FHTreeStateNode fHTreeStateNode = null;
            int n4 = 0;
            int n5 = this.getChildCount();
            while (n4 < n5) {
                FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)this.getChildAt(n4);
                if (fHTreeStateNode2.row > n2) {
                    if (n4 == 0) {
                        searchInfo.node = this;
                        searchInfo.isNodeParentNode = true;
                        searchInfo.childIndex = n2 - this.row - 1;
                        return true;
                    }
                    int n6 = 1 + fHTreeStateNode2.row - (fHTreeStateNode2.childIndex - fHTreeStateNode.childIndex);
                    if (n2 < n6) {
                        return fHTreeStateNode.getPathForRow(n2, n6, searchInfo);
                    }
                    searchInfo.node = this;
                    searchInfo.isNodeParentNode = true;
                    searchInfo.childIndex = n2 - n6 + fHTreeStateNode.childIndex + 1;
                    return true;
                }
                fHTreeStateNode = fHTreeStateNode2;
                ++n4;
            }
            int n7 = FixedHeightLayoutCache.this.treeModel.getChildCount(this.getUserObject());
            if (fHTreeStateNode != null) {
                int n8 = n3 - (n7 - fHTreeStateNode.childIndex) + 1;
                if (n2 < n8) {
                    return fHTreeStateNode.getPathForRow(n2, n8, searchInfo);
                }
                searchInfo.node = this;
                searchInfo.isNodeParentNode = true;
                searchInfo.childIndex = n2 - n8 + fHTreeStateNode.childIndex + 1;
                return true;
            }
            int n9 = n2 - this.row - 1;
            if (n9 >= n7) {
                return false;
            }
            searchInfo.node = this;
            searchInfo.isNodeParentNode = true;
            searchInfo.childIndex = n9;
            return true;
        }

        protected int getCountTo(int n2) {
            int n3 = n2 + 1;
            int n4 = 0;
            int n5 = this.getChildCount();
            while (n4 < n5) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n4);
                if (fHTreeStateNode.childIndex >= n2) {
                    n4 = n5;
                } else {
                    n3 += fHTreeStateNode.getTotalChildCount();
                }
                ++n4;
            }
            if (this.parent != null) {
                return n3 + ((FHTreeStateNode)this.getParent()).getCountTo(this.childIndex);
            }
            if (!FixedHeightLayoutCache.this.isRootVisible()) {
                return n3 - 1;
            }
            return n3;
        }

        protected int getNumExpandedChildrenTo(int n2) {
            int n3 = n2;
            int n4 = 0;
            int n5 = this.getChildCount();
            while (n4 < n5) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n4);
                if (fHTreeStateNode.childIndex >= n2) {
                    return n3;
                }
                n3 += fHTreeStateNode.getTotalChildCount();
                ++n4;
            }
            return n3;
        }

        protected void didAdjustTree() {
        }
    }
}

