/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPseudoCol;
import sun.jdbc.odbc.JdbcOdbcResultSetInterface;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;

public class JdbcOdbcResultSetMetaData
extends JdbcOdbcObject
implements ResultSetMetaData {
    protected JdbcOdbc OdbcApi;
    protected JdbcOdbcResultSetInterface resultSet;
    protected long hStmt;

    public JdbcOdbcResultSetMetaData(JdbcOdbc jdbcOdbc, JdbcOdbcResultSetInterface jdbcOdbcResultSetInterface) {
        this.OdbcApi = jdbcOdbc;
        this.resultSet = jdbcOdbcResultSetInterface;
        this.hStmt = jdbcOdbcResultSetInterface.getHSTMT();
    }

    public int getColumnCount() throws SQLException {
        return this.resultSet.getColumnCount();
    }

    public boolean isAutoIncrement(int n2) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isAutoIncrement (" + n2 + ")");
        }
        boolean bl2 = this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2)) != null ? false : this.getColAttributeBoolean(n2, 11);
        return bl2;
    }

    public boolean isCaseSensitive(int n2) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isCaseSensitive (" + n2 + ")");
        }
        boolean bl2 = this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2)) != null ? false : this.getColAttributeBoolean(n2, 12);
        return bl2;
    }

    public boolean isSearchable(int n2) throws SQLException {
        int n3;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isSearchable (" + n2 + ")");
        }
        boolean bl2 = this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2)) != null ? false : (n3 = this.getColAttribute(n2, 13)) != 0;
        return bl2;
    }

    public boolean isCurrency(int n2) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isCurrency (" + n2 + ")");
        }
        boolean bl2 = this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2)) != null ? false : this.getColAttributeBoolean(n2, 9);
        return bl2;
    }

    public int isNullable(int n2) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isNullable (" + n2 + ")");
        }
        int n3 = this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2)) != null ? 0 : this.getColAttribute(n2, 7);
        return n3;
    }

    public boolean isSigned(int n2) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isSigned (" + n2 + ")");
        }
        boolean bl2 = this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2)) != null ? false : !this.getColAttributeBoolean(n2, 8);
        return bl2;
    }

    public int getColumnDisplaySize(int n2) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnDisplaySize (" + n2 + ")");
        }
        int n3 = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2))) != null ? jdbcOdbcPseudoCol.getColumnDisplaySize() : this.getColAttribute(n2, 6);
        return n3;
    }

    public String getColumnLabel(int n2) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnLabel (" + n2 + ")");
        }
        String string = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2))) != null ? jdbcOdbcPseudoCol.getColumnLabel() : this.getColAttributeString(n2, 18);
        string = this.resultSet.mapColumnName(string, n2);
        return string;
    }

    public String getColumnName(int n2) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnName (" + n2 + ")");
        }
        String string = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2))) != null ? jdbcOdbcPseudoCol.getColumnLabel() : this.getColAttributeString(n2, 1);
        string = this.resultSet.mapColumnName(string, n2);
        return string;
    }

    public String getSchemaName(int n2) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getSchemaName (" + n2 + ")");
        }
        if (this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2)) != null) {
            n2 = 1;
        }
        return this.getColAttributeString(n2, 16);
    }

    public int getPrecision(int n2) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getPrecision (" + n2 + ")");
        }
        int n3 = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2))) != null ? jdbcOdbcPseudoCol.getColumnDisplaySize() - 1 : this.getColAttribute(n2, 4);
        return n3;
    }

    public int getScale(int n2) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getScale (" + n2 + ")");
        }
        return this.resultSet.getScale(n2);
    }

    public String getTableName(int n2) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getTableName (" + n2 + ")");
        }
        if (this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2)) != null) {
            n2 = 1;
        }
        return this.getColAttributeString(n2, 15);
    }

    public String getCatalogName(int n2) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getCatalogName (" + n2 + ")");
        }
        if (this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2)) != null) {
            n2 = 1;
        }
        return this.getColAttributeString(n2, 17);
    }

    public int getColumnType(int n2) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnType (" + n2 + ")");
        }
        int n3 = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n2)) != null ? jdbcOdbcPseudoCol.getColumnType() - 1 : this.resultSet.getColumnType(n2);
        return n3;
    }

    public String getColumnTypeName(int n2) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnTypeName (" + n2 + ")");
        }
        String string = this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2)) != null ? "" : this.getColAttributeString(n2, 14);
        return string;
    }

    public boolean isReadOnly(int n2) throws SQLException {
        int n3;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isReadOnly (" + n2 + ")");
        }
        boolean bl2 = this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2)) != null ? true : (n3 = this.getColAttribute(n2, 10)) == 0;
        return bl2;
    }

    public boolean isWritable(int n2) throws SQLException {
        int n3;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isWritable (" + n2 + ")");
        }
        boolean bl2 = this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2)) != null ? false : (n3 = this.getColAttribute(n2, 10)) == 2;
        return bl2;
    }

    public boolean isDefinitelyWritable(int n2) throws SQLException {
        int n3;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isDefinitelyWritable (" + n2 + ")");
        }
        boolean bl2 = this.resultSet.getPseudoCol(n2 = this.resultSet.mapColumn(n2)) != null ? false : (n3 = this.getColAttribute(n2, 10)) == 1;
        return bl2;
    }

    public String getColumnClassName(int n2) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnClassName (" + n2 + ")");
        }
        String string = new String().getClass().getName();
        int n3 = this.getColumnType(n2);
        switch (n3) {
            case 2: 
            case 3: {
                string = new BigDecimal(0.0).getClass().getName();
                break;
            }
            case -7: {
                string = new Boolean(false).getClass().getName();
                break;
            }
            case -6: {
                string = new Byte("0").getClass().getName();
                break;
            }
            case 5: {
                string = new Short("0").getClass().getName();
                break;
            }
            case 4: {
                string = new Integer(0).getClass().getName();
                break;
            }
            case -5: {
                string = new Long(0L).getClass().getName();
                break;
            }
            case 7: {
                string = new Float(0.0f).getClass().getName();
                break;
            }
            case 6: 
            case 8: {
                string = new Double(0.0).getClass().getName();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] byArray = new byte[]{};
                string = byArray.getClass().getName();
                break;
            }
            case 91: {
                string = new Date(123456L).getClass().getName();
                break;
            }
            case 92: {
                string = new Time(123456L).getClass().getName();
                break;
            }
            case 93: {
                string = new Timestamp(123456L).getClass().getName();
            }
        }
        return string;
    }

    protected int getColAttribute(int n2, int n3) throws SQLException {
        return this.resultSet.getColAttribute(n2, n3);
    }

    protected boolean getColAttributeBoolean(int n2, int n3) throws SQLException {
        int n4 = this.getColAttribute(n2, n3);
        boolean bl2 = false;
        if (n4 == 1) {
            bl2 = true;
        }
        return bl2;
    }

    protected String getColAttributeString(int n2, int n3) throws SQLException {
        String string = "";
        this.resultSet.clearWarnings();
        try {
            string = this.OdbcApi.SQLColAttributesString(this.hStmt, n2, n3);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.resultSet.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return string.trim();
    }
}

