/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.security.AccessController;
import sun.rmi.runtime.Log;
import sun.rmi.server.RemoteProxy;
import sun.rmi.transport.Connection;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.StreamRemoteCall;
import sun.security.action.GetBooleanAction;

public class UnicastRef
implements RemoteRef {
    public static final Log clientRefLog = Log.getLog("sun.rmi.client.ref", "transport", RemoteProxy.logLevel);
    public static final Log clientCallLog;
    protected LiveRef ref;

    public UnicastRef() {
    }

    public UnicastRef(LiveRef liveRef) {
        this.ref = liveRef;
    }

    /*
     * Exception decompiling
     */
    public Object invoke(Remote var1_1, Method var2_2, Object[] var3_3, long var4_4) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void marshalCustomCallData(ObjectOutput objectOutput) throws IOException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void marshalValue(Class clazz, Object object, ObjectOutput objectOutput) throws IOException {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                objectOutput.writeInt((Integer)object);
                return;
            } else if (clazz == Boolean.TYPE) {
                objectOutput.writeBoolean((Boolean)object);
                return;
            } else if (clazz == Byte.TYPE) {
                objectOutput.writeByte(((Byte)object).byteValue());
                return;
            } else if (clazz == Character.TYPE) {
                objectOutput.writeChar(((Character)object).charValue());
                return;
            } else if (clazz == Short.TYPE) {
                objectOutput.writeShort(((Short)object).shortValue());
                return;
            } else if (clazz == Long.TYPE) {
                objectOutput.writeLong((Long)object);
                return;
            } else if (clazz == Float.TYPE) {
                objectOutput.writeFloat(((Float)object).floatValue());
                return;
            } else {
                if (clazz != Double.TYPE) throw new Error("Unrecognized primitive type: " + clazz);
                objectOutput.writeDouble((Double)object);
            }
            return;
        } else {
            objectOutput.writeObject(object);
        }
    }

    protected static Object unmarshalValue(Class clazz, ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return new Integer(objectInput.readInt());
            }
            if (clazz == Boolean.TYPE) {
                return new Boolean(objectInput.readBoolean());
            }
            if (clazz == Byte.TYPE) {
                return new Byte(objectInput.readByte());
            }
            if (clazz == Character.TYPE) {
                return new Character(objectInput.readChar());
            }
            if (clazz == Short.TYPE) {
                return new Short(objectInput.readShort());
            }
            if (clazz == Long.TYPE) {
                return new Long(objectInput.readLong());
            }
            if (clazz == Float.TYPE) {
                return new Float(objectInput.readFloat());
            }
            if (clazz == Double.TYPE) {
                return new Double(objectInput.readDouble());
            }
            throw new Error("Unrecognized primitive type: " + clazz);
        }
        return objectInput.readObject();
    }

    public RemoteCall newCall(RemoteObject remoteObject, Operation[] operationArray, int n2, long l2) throws RemoteException {
        clientRefLog.log(Log.BRIEF, "get connection");
        Connection connection = this.ref.getChannel().newConnection();
        try {
            clientRefLog.log(Log.VERBOSE, "create call context");
            if (clientCallLog.isLoggable(Log.VERBOSE)) {
                this.logClientCall(remoteObject, operationArray[n2]);
            }
            StreamRemoteCall streamRemoteCall = new StreamRemoteCall(connection, this.ref.getObjID(), n2, l2);
            try {
                this.marshalCustomCallData(streamRemoteCall.getOutputStream());
            }
            catch (IOException iOException) {
                throw new MarshalException("error marshaling custom call data");
            }
            return streamRemoteCall;
        }
        catch (RemoteException remoteException) {
            this.ref.getChannel().free(connection, false);
            throw remoteException;
        }
    }

    public void invoke(RemoteCall remoteCall) throws Exception {
        try {
            clientRefLog.log(Log.VERBOSE, "execute call");
            remoteCall.executeCall();
        }
        catch (RemoteException remoteException) {
            clientRefLog.log(Log.BRIEF, "exception: ", remoteException);
            this.free(remoteCall, false);
            throw remoteException;
        }
        catch (Error error) {
            clientRefLog.log(Log.BRIEF, "error: ", error);
            this.free(remoteCall, false);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            clientRefLog.log(Log.BRIEF, "exception: ", runtimeException);
            this.free(remoteCall, false);
            throw runtimeException;
        }
        catch (Exception exception) {
            clientRefLog.log(Log.BRIEF, "exception: ", exception);
            this.free(remoteCall, true);
            throw exception;
        }
    }

    private void free(RemoteCall remoteCall, boolean bl2) throws RemoteException {
        Connection connection = ((StreamRemoteCall)remoteCall).getConnection();
        this.ref.getChannel().free(connection, bl2);
    }

    public void done(RemoteCall remoteCall) throws RemoteException {
        clientRefLog.log(Log.BRIEF, "free connection (reuse = true)");
        this.free(remoteCall, true);
        try {
            remoteCall.done();
        }
        catch (IOException iOException) {}
    }

    void logClientCall(Object object, Object object2) {
        clientCallLog.log(Log.VERBOSE, "outbound call: " + this.ref + " : " + object.getClass().getName() + this.ref.getObjID().toString() + ": " + object2);
    }

    public String getRefClass(ObjectOutput objectOutput) {
        return "UnicastRef";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.ref.write(objectOutput, false);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ref = LiveRef.read(objectInput, false);
    }

    public String remoteToString() {
        return "RemoteStub [ref: " + this.ref + "]";
    }

    public int remoteHashCode() {
        return this.ref.hashCode();
    }

    public boolean remoteEquals(RemoteRef remoteRef) {
        if (remoteRef instanceof UnicastRef) {
            return this.ref.remoteEquals(((UnicastRef)remoteRef).ref);
        }
        return false;
    }

    static {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.rmi.client.logCalls"));
        boolean bl3 = bl2;
        clientCallLog = Log.getLog("sun.rmi.client.call", "RMI", bl3);
    }
}

